/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class EditTextDialog
extends BaseDialog {
    private String text;
    private Text textControl;
    protected int textWidth = 300;
    protected int textHeight = 200;
    private boolean readonly = false;
    private boolean monospaceFont;

    public EditTextDialog(Shell parentShell, String title, String text) {
        this(parentShell, title, text, false);
    }

    public EditTextDialog(Shell parentShell, String title, String text, boolean readOnly) {
        super(parentShell, title, null);
        this.text = text;
        this.readonly = readOnly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public void setMonospaceFont(boolean monospaceFont) {
        this.monospaceFont = monospaceFont;
    }

    public void setAutoSize(boolean autoSize) {
        if (autoSize) {
            this.textWidth = 0;
            this.textHeight = 0;
        } else {
            this.textWidth = 300;
            this.textHeight = 200;
        }
    }

    @Override
    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        this.createControlsBeforeText(composite);
        this.textControl = new Text(composite, 2624);
        if (this.text != null) {
            this.textControl.setText(this.text);
        }
        this.textControl.setEditable(!this.readonly);
        if (this.monospaceFont) {
            this.textControl.setFont(UIUtils.getMonospaceFont());
        }
        GridData gd = new GridData(1808);
        if (this.textWidth > 0) {
            gd.widthHint = this.textWidth;
        }
        if (this.textHeight > 0) {
            gd.heightHint = this.textHeight;
        }
        gd.minimumHeight = 100;
        gd.minimumWidth = 100;
        this.textControl.setLayoutData((Object)gd);
        return composite;
    }

    protected void createControlsBeforeText(Composite composite) {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (!this.readonly) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    protected void okPressed() {
        this.text = this.textControl.getText();
        super.okPressed();
    }

    public static String editText(Shell parentShell, String title, String text) {
        EditTextDialog dialog = new EditTextDialog(parentShell, title, text);
        if (dialog.open() == 0) {
            return dialog.text;
        }
        return null;
    }

    public static void showText(Shell parentShell, String title, String text) {
        EditTextDialog dialog = new EditTextDialog(parentShell, title, text);
        dialog.setReadonly(true);
        dialog.open();
    }
}

