/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableIndex;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class ExasolTableManager
extends SQLTableManager<ExasolTable, ExasolSchema>
implements DBEObjectRenamer<ExasolTable> {
    private static final String NEW_TABLE_NAME = "NEW_TABLE";
    private static final String SQL_ALTER = "ALTER TABLE ";
    private static final String SQL_RENAME_TABLE = "RENAME TABLE %s TO %s";
    private static final String SQL_COMMENT = "COMMENT ON TABLE %s IS '%s'";
    private static final String CMD_ALTER = "Alter Table";
    private static final String CMD_COMMENT = "Comment on Table";
    private static final String CMD_RENAME = "Rename Table";
    private static final Class<?>[] CHILD_TYPES = new Class[]{ExasolTableColumn.class, ExasolTableUniqueKey.class, ExasolTableForeignKey.class, ExasolTableIndex.class};

    @NotNull
    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    @Nullable
    public DBSObjectCache<ExasolSchema, ExasolTable> getObjectsCache(ExasolTable object) {
        return object.getSchema().getTableCache();
    }

    public ExasolTable createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object exasolSchema, Object copyFrom, Map<String, Object> options) {
        ExasolTable table = new ExasolTable((ExasolSchema)exasolSchema, NEW_TABLE_NAME);
        this.setNewObjectName(monitor, (ExasolSchema)exasolSchema, table);
        return table;
    }

    public void appendTableModifiers(DBRProgressMonitor monitor, ExasolTable exasolTable, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter) {
    }

    public void addStructObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) throws DBException {
        super.addStructObjectCreateActions(monitor, executionContext, actions, command, options);
        DBEPersistAction commentAction = this.buildCommentAction((ExasolTable)command.getObject());
        if (commentAction != null) {
            actions.add(commentAction);
        }
    }

    public void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        DBEPersistAction commentAction;
        ExasolTable exasolTable = (ExasolTable)command.getObject();
        if (command.getProperties().size() > 0) {
            if (command.getProperties().containsKey("hasPartitionKey") && command.getProperties().get("hasPartitionKey").toString().equals("false")) {
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction(SQL_ALTER + exasolTable.getFullyQualifiedName(DBPEvaluationContext.DDL) + " DROP PARTITION KEYS"));
            } else if (command.getProperties().size() > 1) {
                StringBuilder sb = new StringBuilder(128);
                sb.append(SQL_ALTER);
                sb.append(exasolTable.getFullyQualifiedName(DBPEvaluationContext.DDL));
                sb.append(" ");
                this.appendTableModifiers(monitor, (ExasolTable)command.getObject(), (SQLObjectEditor.NestedObjectCommand)command, sb, true);
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction(CMD_ALTER, sb.toString()));
            }
        }
        if ((commentAction = this.buildCommentAction(exasolTable)) != null) {
            actionList.add(commentAction);
        }
    }

    public void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        String sql = String.format(SQL_RENAME_TABLE, String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)((ExasolTable)command.getObject()).getSchema())) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)((ExasolTable)command.getObject()).getDataSource(), (String)command.getOldName()), DBUtils.getQuotedIdentifier((DBPDataSource)((ExasolTable)command.getObject()).getDataSource(), (String)command.getNewName()));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(CMD_RENAME, sql));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull ExasolTable object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }

    private DBEPersistAction buildCommentAction(ExasolTable exasolTable) {
        if (CommonUtils.isNotEmpty((String)exasolTable.getDescription())) {
            String commentSQL = String.format(SQL_COMMENT, exasolTable.getFullyQualifiedName(DBPEvaluationContext.DDL), exasolTable.getDescription());
            return new SQLDatabasePersistAction(CMD_COMMENT, commentSQL);
        }
        return null;
    }
}

