/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.security;

import java.sql.ResultSet;
import java.sql.Timestamp;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolGrantee;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.access.DBARole;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class ExasolRole
extends ExasolGrantee
implements DBARole,
DBPNamedObject2 {
    private String name;
    private String description;
    private ExasolDataSource dataSource;
    private Timestamp created;

    public ExasolRole(ExasolDataSource dataSource, ResultSet resultSet) {
        super(dataSource, resultSet);
        if (resultSet != null) {
            this.name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"ROLE_NAME");
            this.description = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"ROLE_COMMENT");
            this.dataSource = dataSource;
            this.created = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CREATED");
        } else {
            this.name = "New Role";
        }
    }

    public ExasolRole(ExasolDataSource dataSource, String name, String description) {
        super(dataSource, false);
        this.dataSource = dataSource;
        this.name = name;
        this.description = description;
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, updatable=true, editable=true, length=PropertyLength.MULTILINE, order=10)
    public String getDescription() {
        return this.description;
    }

    @Property(viewable=true, order=20)
    public Timestamp getCreated() {
        return this.created;
    }

    @Override
    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "Role " + this.getName();
    }

    public void setName(String newName) {
        this.name = newName;
    }
}

