/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.utils.CommonUtils;

public class DataSourceNavigatorSettings
implements DBNBrowseSettings {
    public static final Map<String, Preset> PRESETS = new LinkedHashMap<String, Preset>();
    public static final Preset PRESET_SIMPLE = new Preset("simple", "Simple", "Shows only tables");
    public static final Preset PRESET_FULL = new Preset("advanced", "Advanced", "Shows all database objects");
    public static final Preset PRESET_CUSTOM = new Preset("custom", "Custom", "User configuration");
    private boolean showSystemObjects;
    private boolean showUtilityObjects;
    private boolean showOnlyEntities;
    private boolean mergeEntities;
    private boolean hideFolders;
    private boolean hideSchemas;
    private boolean hideVirtualModel;
    public static final String DEFAULT_NAVIGATOR_SETTINGS_PRESET = "navigator.settings.default.preset";
    private static final String DEFAULT_SHOW_SYSTEM_OBJECTS = "navigator.settings.default.showSystemObjects";
    private static final String DEFAULT_SHOW_UTILITY_OBJECTS = "navigator.settings.default.showUtilityObjects";
    private static final String DEFAULT_SHOW_ONLY_ENTITIES = "navigator.settings.default.showOnlyEntities";
    private static final String DEFAULT_MERGE_ENTITIES = "navigator.settings.default.mergeEntities";
    private static final String DEFAULT_HIDE_FOLDERS = "navigator.settings.default.hideFolders";
    private static final String DEFAULT_HIDE_SCHEMAS = "navigator.settings.default.hideSchemas";
    private static final String DEFAULT_HIDE_VIRTUAL_MODEL = "navigator.settings.default.hideVirtualModel";

    static {
        PRESET_SIMPLE.settings.setShowOnlyEntities(true);
        PRESET_SIMPLE.settings.setHideFolders(true);
        PRESET_SIMPLE.settings.setHideVirtualModel(true);
        PRESET_FULL.settings.setShowSystemObjects(true);
        PRESETS.put(PRESET_SIMPLE.name, PRESET_SIMPLE);
        PRESETS.put(PRESET_FULL.name, PRESET_FULL);
        PRESETS.put(PRESET_CUSTOM.name, PRESET_CUSTOM);
    }

    public DataSourceNavigatorSettings() {
    }

    public DataSourceNavigatorSettings(DBNBrowseSettings copyFrom) {
        this.showSystemObjects = copyFrom.isShowSystemObjects();
        this.showUtilityObjects = copyFrom.isShowUtilityObjects();
        this.showOnlyEntities = copyFrom.isShowOnlyEntities();
        this.mergeEntities = copyFrom.isMergeEntities();
        this.hideFolders = copyFrom.isHideFolders();
        this.hideSchemas = copyFrom.isHideSchemas();
        this.hideVirtualModel = copyFrom.isHideVirtualModel();
    }

    public boolean isShowSystemObjects() {
        return this.showSystemObjects;
    }

    public void setShowSystemObjects(boolean showSystemObjects) {
        this.showSystemObjects = showSystemObjects;
    }

    public boolean isShowUtilityObjects() {
        return this.showUtilityObjects;
    }

    public void setShowUtilityObjects(boolean showUtilityObjects) {
        this.showUtilityObjects = showUtilityObjects;
    }

    public boolean isShowOnlyEntities() {
        return this.showOnlyEntities;
    }

    public void setShowOnlyEntities(boolean showOnlyEntities) {
        this.showOnlyEntities = showOnlyEntities;
    }

    public boolean isMergeEntities() {
        return this.mergeEntities;
    }

    public void setMergeEntities(boolean mergeEntities) {
        this.mergeEntities = mergeEntities;
    }

    public boolean isHideFolders() {
        return this.hideFolders;
    }

    public void setHideFolders(boolean hideFolders) {
        this.hideFolders = hideFolders;
    }

    public boolean isHideSchemas() {
        return this.hideSchemas;
    }

    public void setHideSchemas(boolean hideSchemas) {
        this.hideSchemas = hideSchemas;
    }

    public boolean isHideVirtualModel() {
        return this.hideVirtualModel;
    }

    public void setHideVirtualModel(boolean hideVirtualModel) {
        this.hideVirtualModel = hideVirtualModel;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataSourceNavigatorSettings)) {
            return false;
        }
        DataSourceNavigatorSettings source = (DataSourceNavigatorSettings)obj;
        return this.showSystemObjects == source.showSystemObjects && this.showUtilityObjects == source.showUtilityObjects && this.showOnlyEntities == source.showOnlyEntities && this.mergeEntities == source.mergeEntities && this.hideFolders == source.hideFolders && this.hideSchemas == source.hideSchemas && this.hideVirtualModel == source.hideVirtualModel;
    }

    public static DBNBrowseSettings getDefaultSettings() {
        DBPPreferenceStore preferences = ModelPreferences.getPreferences();
        String defPreset = preferences.getString(DEFAULT_NAVIGATOR_SETTINGS_PRESET);
        if (!CommonUtils.isEmpty((String)defPreset)) {
            for (Preset p : PRESETS.values()) {
                if (!p.getId().equals(defPreset)) continue;
                return p.getSettings();
            }
        }
        DataSourceNavigatorSettings settings = new DataSourceNavigatorSettings();
        settings.setShowSystemObjects(preferences.getBoolean(DEFAULT_SHOW_SYSTEM_OBJECTS));
        settings.setShowUtilityObjects(preferences.getBoolean(DEFAULT_SHOW_UTILITY_OBJECTS));
        settings.setShowOnlyEntities(preferences.getBoolean(DEFAULT_SHOW_ONLY_ENTITIES));
        settings.setMergeEntities(preferences.getBoolean(DEFAULT_MERGE_ENTITIES));
        settings.setHideFolders(preferences.getBoolean(DEFAULT_HIDE_FOLDERS));
        settings.setHideSchemas(preferences.getBoolean(DEFAULT_HIDE_SCHEMAS));
        settings.setHideVirtualModel(preferences.getBoolean(DEFAULT_HIDE_VIRTUAL_MODEL));
        return settings;
    }

    public static void setDefaultSettings(DBNBrowseSettings settings) {
        DBPPreferenceStore preferences = ModelPreferences.getPreferences();
        String presetId = null;
        for (Preset p : PRESETS.values()) {
            if (!p.getSettings().equals(settings)) continue;
            presetId = p.getId();
            break;
        }
        if (CommonUtils.isEmptyTrimmed(presetId)) {
            preferences.setValue(DEFAULT_NAVIGATOR_SETTINGS_PRESET, "");
        } else {
            preferences.setValue(DEFAULT_NAVIGATOR_SETTINGS_PRESET, presetId);
        }
        preferences.setValue(DEFAULT_SHOW_SYSTEM_OBJECTS, settings.isShowSystemObjects());
        preferences.setValue(DEFAULT_SHOW_UTILITY_OBJECTS, settings.isShowUtilityObjects());
        preferences.setValue(DEFAULT_SHOW_ONLY_ENTITIES, settings.isShowOnlyEntities());
        preferences.setValue(DEFAULT_MERGE_ENTITIES, settings.isMergeEntities());
        preferences.setValue(DEFAULT_HIDE_FOLDERS, settings.isHideFolders());
        preferences.setValue(DEFAULT_HIDE_SCHEMAS, settings.isHideSchemas());
        preferences.setValue(DEFAULT_HIDE_VIRTUAL_MODEL, settings.isHideVirtualModel());
    }

    public static class Preset {
        private final String id;
        private final String name;
        private final String description;
        private final DataSourceNavigatorSettings settings = new DataSourceNavigatorSettings();

        public Preset(String id, String name, String description) {
            this.id = id;
            this.name = name;
            this.description = description;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public DataSourceNavigatorSettings getSettings() {
            return this.settings;
        }
    }
}

