/***************************************************************
 * Name:      dxicons.cpp
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#include <wx/icon.h>
#include <wx/image.h>
#include <wx/bitmap.h>
#include <wx/mstream.h>
#include <wx/fileconf.h>
#include <wx/stdpaths.h>
#include "dxicons.h"

static const char *const  empty[] = {
"16 16 11 1",
"   c None",
".  c #000000",
"+  c #FFFFFF",
"@  c #FDE4E4",
"#  c #F45C5C",
"$  c #EF0B0B",
"%  c #F12727",
"&  c #F67878",
"*  c #FAAEAE",
"=  c #FBC9C9",
"-  c #F89393",
"................",
".              .",
".              .",
".    @#$$%&    .",
".   @%$$$$$&   .",
".   &$$#*%$$   .",
".   =-#+@%$%   .",
".      @%$$*   .",
".      %$%@    .",
".     *$$*     .",
".     @**@     .",
".     *$$*     .",
".     *$$*     .",
".     @**@     .",
".              .",
"................"};

static const char * dxreminders_xpm[] = {
"32 32 108 2",
"   c None",
".  c #0000FF",
"+  c #808080",
"@  c #969696",
"#  c #B4B4B4",
"$  c #D0D0D0",
"%  c #DCDCDC",
"&  c #E5DEDE",
"*  c #E4E4E4",
"=  c #DBDBDB",
"-  c #CDCDCD",
";  c #B1B1B1",
">  c #929292",
",  c #8C8C8C",
"'  c #C7C7C7",
")  c #E6E6E6",
"!  c #F36E6E",
"~  c #EE9D9D",
"{  c #C0C0C0",
"]  c #888888",
"^  c #818181",
"/  c #ACACAC",
"(  c #E1E1E1",
"_  c #E7DBDB",
":  c #FC1717",
"<  c #F93D3D",
"[  c #DEDEDE",
"}  c #A4A4A4",
"|  c #8A8A8A",
"1  c #D1D1D1",
"2  c #ECB3B3",
"3  c #FF0000",
"4  c #FC1B1B",
"5  c #C8C8C8",
"6  c #838383",
"7  c #858585",
"8  c #D2D2D2",
"9  c #FE0B0B",
"0  c #E7DEDE",
"a  c #C5C5C5",
"b  c #F08C8C",
"c  c #EAC3C3",
"d  c #949494",
"e  c #F27B7B",
"f  c #EDA5A5",
"g  c #E2E2E2",
"h  c #8B8B8B",
"i  c #F17F7F",
"j  c #ECAAAA",
"k  c #B5B5B5",
"l  c #E3E3E3",
"m  c #F09090",
"n  c #FF0202",
"o  c #FF0101",
"p  c #E9CACA",
"q  c #D6D6D6",
"r  c #9A9A9A",
"s  c #EEA1A1",
"t  c #FD0F0F",
"u  c #E6E1E1",
"v  c #EABABA",
"w  c #FD1212",
"x  c #F37171",
"y  c #F46262",
"z  c #F65353",
"A  c #F84545",
"B  c #F74B4B",
"C  c #F55959",
"D  c #F46969",
"E  c #F27777",
"F  c #979797",
"G  c #ADADAD",
"H  c #EBB5B5",
"I  c #FE0404",
"J  c #FF0303",
"K  c #E6E4E4",
"L  c #A0A0A0",
"M  c #A6A6A6",
"N  c #F36B6B",
"O  c #F55B5B",
"P  c #F74D4D",
"Q  c #FA2E2E",
"R  c #F93434",
"S  c #F84444",
"T  c #F65555",
"U  c #F46464",
"V  c #F08F8F",
"W  c #999999",
"X  c #9C9C9C",
"Y  c #8E8E8E",
"Z  c #898989",
"`  c #E5E5E5",
" . c #CCCCCC",
".. c #BBBBBB",
"+. c #9D9D9D",
"@. c #CACACA",
"#. c #BCBCBC",
"$. c #DFDFDF",
"%. c #D7D7D7",
"&. c #C1C1C1",
"*. c #B7B7B7",
"=. c #848484",
"-. c #939393",
";. c #A9A9A9",
">. c #E0E0E0",
",. c #C4C4C4",
"'. c #909090",
"). c #868686",
"          . . . .                             . . . .           ",
"      . . . . . . .                         . . . . . . .       ",
"    . . . . . .           + + + + + +           . . . . . .     ",
"  . . . . .         + + + + + + + + + + + +         . . . . .   ",
"  . . .         + + + + + + + + + + + + + + + +         . . .   ",
"  . .       + + + + + @ # $ % & * = - ; > + + + +         . .   ",
"          + + + + , ' ) ) ) ) ! ~ ) ) ) ) { ] + + + +           ",
"        + + + ^ / ( ) ) ) ) _ : < ) ) ) ) ) [ } + + + +         ",
"      + + + | 1 ) ) ) ) ) ) 2 3 4 ) ) ) ) ) ) ) 5 6 + + +       ",
"      + + 7 8 ) ) ) ) ) ) ) ~ 3 9 0 ) ) ) ) ) ) ) a ^ + +       ",
"    + + + { ) ) ) ) ) ) ) ) b 3 3 c ) ) ) ) ) ) ) ) ; + + +     ",
"    + + d ) ) ) ) ) ) ) ) ) e 3 3 f ) ) ) ) ) ) ) ) g h + +     ",
"  + + + a ) ) ) ) ) ) ) ) ) i 3 3 j ) ) ) ) ) ) ) ) ) k + + +   ",
"  + + 7 l ) ) ) ) ) ) ) ) ) m n o p ) ) ) ) ) ) ) ) ) q + + +   ",
"  + + r ) ) ) ) ) ) ) ) ) ) s n t u ) ) ) ) ) ) ) ) ) ) , + +   ",
"  + + } ) ) ) ) ) ) ) ) ) ) v n w x y z A B C D E f ) ) F + +   ",
"  + + G ) ) ) ) ) ) ) ) ) ) H I 3 3 3 3 3 3 3 3 3 J C K L + +   ",
"  + + M ) ) ) ) ) ) ) ) ) ) ) N C O P < Q R S T U V K ) W + +   ",
"  + + X ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) Y + +   ",
"  + + Z ` ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) % ^ + +   ",
"  + + +  .) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ..+ + +   ",
"    + + +.) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ` > + +     ",
"    + + + @.) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) #.+ + +     ",
"      + + , % ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) 8 7 + +       ",
"      + + + d $.) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) %.| + + +       ",
"        + + + ] &.) ) ) ) ) ) ) ) ) ) ) ) ) * *.=.+ + +         ",
"          + + + + r %.) ) ) ) ) ) ) ) ) ) 1 -.+ + + +     +     ",
"    + +     + + + + 6 ;.@.l ) ) ) ) >.,.} ^ + + + +   ^ + +     ",
"    + + +       + + + + + + ] > '.).+ + + + + +     + + + +     ",
"  + + + + +       + + + + + + + + + + + + + +       + + + + +   ",
"  + + +                 + + + + + + + +                   + +   ",
"+                                                             + "};

static const char * about_xpm[] = {
"64 64 178 2",
"   c None",
".  c #0000FF",
"+  c #808080",
"@  c #848484",
"#  c #878787",
"$  c #868686",
"%  c #828282",
"&  c #9F9F9F",
"*  c #B8B8B8",
"=  c #CACACA",
"-  c #D9D9D9",
";  c #E5E5E5",
">  c #E6E6E6",
",  c #E3E3E3",
"'  c #D4D4D4",
")  c #C6C6C6",
"!  c #B1B1B1",
"~  c #989898",
"{  c #A7A7A7",
"]  c #E9C3C3",
"^  c #E7DEDE",
"/  c #E0E0E0",
"(  c #C0C0C0",
"_  c #9B9B9B",
":  c #B4B4B4",
"<  c #DEDEDE",
"[  c #EDAAAA",
"}  c #FD1111",
"|  c #F83F3F",
"1  c #818181",
"2  c #ACACAC",
"3  c #DFDFDF",
"4  c #F74848",
"5  c #FF0000",
"6  c #FE0909",
"7  c #ECADAD",
"8  c #8E8E8E",
"9  c #CFCFCF",
"0  c #E7E1E1",
"a  c #FC1E1E",
"b  c #F55E5E",
"c  c #BCBCBC",
"d  c #A0A0A0",
"e  c #E1E1E1",
"f  c #ECACAC",
"g  c #FF0303",
"h  c #D6D6D6",
"i  c #ADADAD",
"j  c #F27979",
"k  c #FB2A2A",
"l  c #969696",
"m  c #F56060",
"n  c #FC1616",
"o  c #E7DADA",
"p  c #E2E2E2",
"q  c #A8A8A8",
"r  c #F64C4C",
"s  c #EBB6B6",
"t  c #919191",
"u  c #E4E4E4",
"v  c #F83D3D",
"w  c #EF9393",
"x  c #D7D7D7",
"y  c #DBDBDB",
"z  c #F93737",
"A  c #F18484",
"B  c #C3C3C3",
"C  c #BDBDBD",
"D  c #F93131",
"E  c #F27575",
"F  c #9E9E9E",
"G  c #939393",
"H  c #FA2B2B",
"I  c #F36C6C",
"J  c #C7C7C7",
"K  c #FB2626",
"L  c #F46666",
"M  c #AAAAAA",
"N  c #FB2828",
"O  c #FF0101",
"P  c #F36A6A",
"Q  c #B9B9B9",
"R  c #FA2E2E",
"S  c #F36F6F",
"T  c #9A9A9A",
"U  c #DDDDDD",
"V  c #F93434",
"W  c #F27A7A",
"X  c #949494",
"Y  c #F93A3A",
"Z  c #FF0202",
"`  c #F08888",
" . c #DCDCDC",
".. c #AFAFAF",
"+. c #F84242",
"@. c #EDA2A2",
"#. c #F65555",
"$. c #FE0D0D",
"%. c #E9CCCC",
"&. c #A3A3A3",
"*. c #D0D0D0",
"=. c #F36969",
"-. c #FE0303",
";. c #FC1F1F",
">. c #E7DDDD",
",. c #EABFBF",
"'. c #F09191",
"). c #F17B7B",
"!. c #F37171",
"~. c #F46A6A",
"{. c #F55C5C",
"]. c #F46868",
"^. c #F27272",
"/. c #F08E8E",
"(. c #EABBBB",
"_. c #E7DBDB",
":. c #B3B3B3",
"<. c #DADADA",
"[. c #F09090",
"}. c #FC1818",
"|. c #FE0505",
"1. c #FE0404",
"2. c #FB2727",
"3. c #F83E3E",
"4. c #F56161",
"5. c #EBB5B5",
"6. c #F55656",
"7. c #FE0A0A",
"8. c #F65454",
"9. c #C2C2C2",
"0. c #F93838",
"a. c #F93939",
"b. c #E6E5E5",
"c. c #C4C4C4",
"d. c #E6E4E4",
"e. c #F93C3C",
"f. c #FE0E0E",
"g. c #FB2323",
"h. c #F84545",
"i. c #F17E7E",
"j. c #E7E0E0",
"k. c #BEBEBE",
"l. c #D5D5D5",
"m. c #E7DCDC",
"n. c #E9CFCF",
"o. c #F17C7C",
"p. c #F46464",
"q. c #F55B5B",
"r. c #F65656",
"s. c #F74C4C",
"t. c #F74B4B",
"u. c #F84141",
"v. c #F27777",
"w. c #EDA5A5",
"x. c #E9CECE",
"y. c #B7B7B7",
"z. c #A9A9A9",
"A. c #B6B6B6",
"B. c #999999",
"C. c #858585",
"D. c #CBCBCB",
"E. c #C8C8C8",
"F. c #ABABAB",
"G. c #A1A1A1",
"H. c #8D8D8D",
"I. c #959595",
"J. c #979797",
"K. c #CECECE",
"L. c #D1D1D1",
"M. c #BABABA",
"N. c #838383",
"O. c #B0B0B0",
"P. c #D3D3D3",
"Q. c #888888",
"R. c #8B8B8B",
"S. c #D8D8D8",
"T. c #BFBFBF",
"U. c #A4A4A4",
"                      . . . . . .                                                             . . . . . .                       ",
"                . . . . . . . . . . .                                                     . . . . . . . . . . .                 ",
"            . . . . . . . . . . . . .                                                   . . . . . . . . . . . . .               ",
"          . . . . . . . . . . . . . .                                                     . . . . . . . . . . . . . .           ",
"        . . . . . . . . . . . . .                       + + + + + + +                         . . . . . . . . . . . . .         ",
"      . . . . . . . . . . . .                 + + + + + + + + + + + + + + + + + +                 . . . . . . . . . . .         ",
"      . . . . . . . . . .               + + + + + + + + + + + + + + + + + + + + + + + +               . . . . . . . . . .       ",
"    . . . . . . . . .               + + + + + + + + + + + + + + + + + + + + + + + + + + + +             . . . . . . . . .       ",
"    . . . . . . . .             + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +             . . . . . . . .     ",
"    . . . . . .             + + + + + + + + + + + + + + + + @ # $ % + + + + + + + + + + + + + + +               . . . . . .     ",
"    . . . .               + + + + + + + + + + + # & * = - ; > > > > , ' ) ! ~ % + + + + + + + + + + +               . . . .     ",
"    . .                 + + + + + + + + + @ { = ; > > > > > > ] ^ > > > > > > / ( _ + + + + + + + + + +                 .       ",
"                      + + + + + + + + # : < > > > > > > > > [ } | > > > > > > > > > ' { 1 + + + + + + + +                       ",
"                  + + + + + + + + % 2 3 > > > > > > > > > > 4 5 6 7 > > > > > > > > > > ' _ + + + + + + + +                     ",
"                  + + + + + + + 8 9 > > > > > > > > > > > 0 a 5 5 b > > > > > > > > > > > ; c @ + + + + + + +                   ",
"                + + + + + + + d e > > > > > > > > > > > > f g 5 5 | > > > > > > > > > > > > > h 8 + + + + + + +                 ",
"              + + + + + + + i ; > > > > > > > > > > > > > j 5 5 5 k > > > > > > > > > > > > > > < l + + + + + + +               ",
"            + + + + + + + i > > > > > > > > > > > > > > > m 5 5 5 n o > > > > > > > > > > > > > > p ~ + + + + + + +             ",
"            + + + + + + q ; > > > > > > > > > > > > > > > r 5 5 5 g s > > > > > > > > > > > > > > > / t + + + + + +             ",
"          + + + + + + l u > > > > > > > > > > > > > > > > v 5 5 5 5 w > > > > > > > > > > > > > > > > x $ + + + + + +           ",
"        + + + + + + $ y > > > > > > > > > > > > > > > > > z 5 5 5 5 A > > > > > > > > > > > > > > > > > B + + + + + +           ",
"        + + + + + + C > > > > > > > > > > > > > > > > > > D 5 5 5 5 E > > > > > > > > > > > > > > > > > > F + + + + + +         ",
"      + + + + + + G ; > > > > > > > > > > > > > > > > > > H 5 5 5 5 I > > > > > > > > > > > > > > > > > > - % + + + + +         ",
"      + + + + + + J > > > > > > > > > > > > > > > > > > > K 5 5 5 5 L > > > > > > > > > > > > > > > > > > > M + + + + + +       ",
"      + + + + + t > > > > > > > > > > > > > > > > > > > > N 5 O 5 5 P > > > > > > > > > > > > > > > > > > > - 1 + + + + +       ",
"    + + + + + + Q > > > > > > > > > > > > > > > > > > > > R 5 O 5 5 S > > > > > > > > > > > > > > > > > > > > T + + + + +       ",
"    + + + + + 1 U > > > > > > > > > > > > > > > > > > > > V 5 O 5 5 W > > > > > > > > > > > > > > > > > > > > ( + + + + + +     ",
"    + + + + + X > > > > > > > > > > > > > > > > > > > > > Y 5 Z 5 5 ` > > > > > > > > > > > > > > > > > > > >  .+ + + + + +     ",
"    + + + + + ..> > > > > > > > > > > > > > > > > > > > > +.5 g 5 5 @.> > > > > > > > > > > > > > > > > > > > > t + + + + +     ",
"    + + + + + ( > > > > > > > > > > > > > > > > > > > > > #.5 g 5 $.%.> > > > > > > > > > > > > > > > > > > > > &.+ + + + +     ",
"  + + + + + + *.> > > > > > > > > > > > > > > > > > > > > =.5 -.5 ;.>.,.'.).!.~.=.{.=.].^.E /.(._.> > > > > > > :.+ + + + +     ",
"  + + + + + + <.> > > > > > > > > > > > > > > > > > > > > [.5 Z 5 6 }.|.5 5 5 5 5 5 5 5 5 5 5 1.n 2.3.4.5.> > > c + + + + +     ",
"  + + + + + + 3 > > > > > > > > > > > > > > > > > > > > > 6.O 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 7.8.> > 9.+ + + + +     ",
"  + + + + + + e > > > > > > > > > > > > > > > > > > > > > 0.O 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 a.b.> c.+ + + + +     ",
"  + + + + + +  .> > > > > > > > > > > > > > > > > > > > > d.e.Z 1.f.5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 f.g.h.i.j.> > k.+ + + + +     ",
"  + + + + + + l.> > > > > > > > > > > > > > > > > > > > > > m.z ` n.[ o.p.q.r.s.t.u.4 t.#.q.m v.w.x.> > > > > > y.+ + + + +     ",
"  + + + + + + J > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > z.+ + + + +     ",
"    + + + + + A.> > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > B.+ + + + +     ",
"    + + + + + F > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > , @ + + + + +     ",
"    + + + + + C.u > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > D.+ + + + + +     ",
"    + + + + + + E.> > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > F.+ + + + +       ",
"      + + + + + G.> > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > , $ + + + + +       ",
"      + + + + + % - > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > k.+ + + + + +       ",
"      + + + + + + { > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > u H.+ + + + +         ",
"        + + + + + % ' > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > y.+ + + + + +         ",
"        + + + + + + I.; > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > - @ + + + + + +         ",
"          + + + + + + :.> > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > u J.+ + + + + +           ",
"          + + + + + + 1 J > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > F.+ + + + + +             ",
"            + + + + + + @ K.> > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > Q + + + + + + +             ",
"              + + + + + + $ L.> > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > M.+ + + + + + +               ",
"              + + + + + + + N.B > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > > ; :.+ + + + + + +                 ",
"                + + + + + + + 1 O.u > > > > > > > > > > > > > > > > > > > > > > > > > > > >  ._ + + + + + + + +                 ",
"          +       + + + + + + + + I.P.> > > > > > > > > > > > > > > > > > > > > > > > > ; 9.Q.+ + + + + + + +       +           ",
"          + +       + + + + + + + + 1 { <.> > > > > > > > > > > > > > > > > > > > > > K.J.+ + + + + + + + +       + +           ",
"        + + + +       + + + + + + + + + % &.K.; > > > > > > > > > > > > > > > > , B J.+ + + + + + + + +         + + + +         ",
"        + + + + +       + + + + + + + + + + + R.i J 3 > > > > > > > > > > S.T.&.C.+ + + + + + + + + +         + + + + +         ",
"      + + + + + + +         + + + + + + + + + + + + + R._ { 2 ....M U.l # + + + + + + + + + + + + +         + + + + + + +       ",
"      + + + + + + + +         + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +         + + + + + + + + +       ",
"    1 + + + + + + + + +           + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +           + + + + + + + + + +     ",
"    + + + + + + + + +                 + + + + + + + + + + + + + + + + + + + + + + + + +                     + + + + + + + +     ",
"    + + + + + +                             + + + + + + + + + + + + + + + + + + + +                             + + + + + +     ",
"  + + + + +                                         + + + + + + + + + + + +                                         + + + + +   ",
"  + + +                                                                                                                   + +   ",
"+                                                                                                                               "};

wxIcon ICO_ICON, ICO_TRAY, ICO_ETRAY, ICO_ABOUT, ICO_ADD, ICO_GADD, ICO_EDIT, ICO_GEDIT, ICO_DELETE, ICO_GDELETE, ICO_DATE, ICO_TIME, ICO_GTIME;
wxIcon ICO_CLEAR, ICO_GCLEAR, ICO_NOTE, ICO_HIDE, ICO_GHIDE, ICO_SHOW, ICO_GSHOW, ICO_HIDEALL, ICO_GHIDEALL, ICO_SHOWALL, ICO_GSHOWALL;
wxIcon ICO_EADD, ICO_GEADD, ICO_EEDIT, ICO_GEEDIT, ICO_EDELETE, ICO_GEDELETE, ICO_FILTER, ICO_GFILTER, ICO_FILTERCLEAR, ICO_GFILTERCLEAR;
wxIcon ICO_SHOWDONOTDELETE, ICO_GSHOWDONOTDELETE;

wxIcon makeIcon(const wxString &path, const wxString &name)
{
    if(wxFileExists(path+wxFILE_SEP_PATH+name))
    {
        return wxIcon(path+wxFILE_SEP_PATH+name, wxBITMAP_TYPE_PNG);
    }
    else
    {
        if(name=="dxreminders_prog.png" || name=="dxreminders_tray.png")
        {
            wxIcon icon(dxreminders_xpm);
            return icon;
        }
        else if(name=="about.png")
        {
            wxIcon icon(about_xpm);
            return icon;
        }
        else
        {
            wxIcon icon(empty);
            return icon;
        }
    }
}

wxIcon makeGreyedIcon(const wxString &path, const wxString &name)
{
    if(wxFileExists(path+wxFILE_SEP_PATH+name))
    {
        wxImage img(path+wxFILE_SEP_PATH+name, wxBITMAP_TYPE_PNG);
        wxIcon icon;
        icon.CopyFromBitmap(wxBitmap(img.ConvertToGreyscale()));
        return icon;
    }
    wxImage img(empty);
    wxIcon icon;
    icon.CopyFromBitmap(wxBitmap(img.ConvertToGreyscale()));
    return icon;
}

wxIcon makeScaledIcon(const wxString &path, int max)
{
    if(wxFileExists(path))
    {
        wxImage img(path);
        int w = img.GetWidth();
        int h = img.GetHeight();
        if(w>max || h>max)
        {
            if(w>h)
                img = img.Scale(max, (max*h)/w);
            else
                img = img.Scale((max*w)/h, max);
        }
        wxIcon icon;
        icon.CopyFromBitmap(wxBitmap(img));
        return icon;
    }
    return wxIcon(empty);
}

void makeAllIcons(const wxString &path)
{
    wxString themePath;
    if(path == "default")
    {
#if defined (__WXMAC__)
        themePath = wxStandardPaths::Get().GetResourcesDir()+"/icons";
#else
        themePath = wxString(DXREMINDERS_DATADIR)+wxFILE_SEP_PATH+"icons";
#endif
    }
    else
    {
        themePath = path;
    }
    ICO_ICON = makeIcon(themePath, "dxreminders_prog.png");
    ICO_TRAY = makeIcon(themePath, "dxreminders_tray.png");
    ICO_ETRAY = makeIcon(themePath, "eventtray.png");
    ICO_ABOUT = makeIcon(themePath, "about.png");
    ICO_ADD = makeIcon(themePath, "add.png");
    ICO_GADD = makeGreyedIcon(themePath, "add.png");
    ICO_EDIT = makeIcon(themePath, "edit.png");
    ICO_GEDIT = makeGreyedIcon(themePath, "edit.png");
    ICO_DELETE = makeIcon(themePath, "delete.png");
    ICO_GDELETE = makeGreyedIcon(themePath, "delete.png");
    ICO_DATE = makeIcon(themePath, "date.png");
    ICO_TIME = makeIcon(themePath, "time.png");
    ICO_GTIME = makeGreyedIcon(themePath, "time.png");
    ICO_CLEAR = makeIcon(themePath, "clear.png");
    ICO_GCLEAR = makeGreyedIcon(themePath, "clear.png");
    ICO_NOTE = makeIcon(themePath, "note.png");
    ICO_HIDE = makeIcon(themePath, "hide.png");
    ICO_GHIDE = makeGreyedIcon(themePath, "hide.png");
    ICO_SHOW = makeIcon(themePath, "show.png");
    ICO_GSHOW = makeGreyedIcon(themePath, "show.png");
    ICO_HIDEALL = makeIcon(themePath, "hide_all.png");
    ICO_GHIDEALL = makeGreyedIcon(themePath, "hide_all.png");
    ICO_SHOWALL = makeIcon(themePath, "show_all.png");
    ICO_GSHOWALL = makeGreyedIcon(themePath, "show_all.png");
    ICO_EADD = makeIcon(themePath, "eadd.png");
    ICO_GEADD = makeGreyedIcon(themePath, "eadd.png");
    ICO_EEDIT = makeIcon(themePath, "eedit.png");
    ICO_GEEDIT = makeGreyedIcon(themePath, "eedit.png");
    ICO_EDELETE = makeIcon(themePath, "edelete.png");
    ICO_GEDELETE = makeGreyedIcon(themePath, "edelete.png");
    ICO_FILTER = makeIcon(themePath, "filter.png");
    ICO_GFILTER = makeGreyedIcon(themePath, "filter.png");
    ICO_FILTERCLEAR = makeIcon(themePath, "filterclear.png");
    ICO_GFILTERCLEAR = makeGreyedIcon(themePath, "filterclear.png");
    ICO_SHOWDONOTDELETE = makeIcon(themePath, "donotdelete.png");
    ICO_GSHOWDONOTDELETE = makeGreyedIcon(themePath, "donotdelete.png");
}
