/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.recoverykey;

import dagger.Lazy;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import javafx.beans.property.StringProperty;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.ui.common.Animations;
import org.cryptomator.ui.common.ErrorComponent;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.controls.NiceSecurePasswordField;
import org.cryptomator.ui.recoverykey.RecoveryKeyFactory;
import org.cryptomator.ui.recoverykey.RecoveryKeyScoped;
import org.cryptomator.ui.recoverykey.RecoveryKeyWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RecoveryKeyScoped
public class RecoveryKeyCreationController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveryKeyCreationController.class);
    private final Stage window;
    private final Lazy<Scene> successScene;
    private final Vault vault;
    private final ExecutorService executor;
    private final RecoveryKeyFactory recoveryKeyFactory;
    private final StringProperty recoveryKeyProperty;
    private final ErrorComponent.Builder errorComponent;
    public NiceSecurePasswordField passwordField;

    @Inject
    public RecoveryKeyCreationController(@RecoveryKeyWindow Stage window, @FxmlScene(value=FxmlFile.RECOVERYKEY_SUCCESS) Lazy<Scene> successScene, @RecoveryKeyWindow Vault vault, RecoveryKeyFactory recoveryKeyFactory, ExecutorService executor, @RecoveryKeyWindow StringProperty recoveryKey, ErrorComponent.Builder errorComponent) {
        this.window = window;
        this.successScene = successScene;
        this.vault = vault;
        this.executor = executor;
        this.recoveryKeyFactory = recoveryKeyFactory;
        this.recoveryKeyProperty = recoveryKey;
        this.errorComponent = errorComponent;
    }

    @FXML
    public void createRecoveryKey() {
        RecoveryKeyCreationTask task = new RecoveryKeyCreationTask();
        task.setOnScheduled(event -> LOG.debug("Creating recovery key for {}.", (Object)this.vault.getDisplayablePath()));
        task.setOnSucceeded(event -> {
            String recoveryKey = (String)task.getValue();
            this.recoveryKeyProperty.set((Object)recoveryKey);
            this.window.setScene((Scene)this.successScene.get());
        });
        task.setOnFailed(event -> {
            if (task.getException() instanceof InvalidPassphraseException) {
                Animations.createShakeWindowAnimation((Window)this.window).play();
            } else {
                LOG.error("Creation of recovery key failed.", task.getException());
                this.errorComponent.cause(task.getException()).window(this.window).returnToScene(this.window.getScene()).build().showErrorScene();
            }
        });
        this.executor.submit((Runnable)((Object)task));
    }

    @FXML
    public void close() {
        this.window.close();
    }

    public Vault getVault() {
        return this.vault;
    }

    private class RecoveryKeyCreationTask
    extends Task<String> {
        private RecoveryKeyCreationTask() {
            this.setOnFailed(event -> LOG.error("Failed to create recovery key", this.getException()));
        }

        protected String call() throws IOException, CryptoException {
            return RecoveryKeyCreationController.this.recoveryKeyFactory.createRecoveryKey(RecoveryKeyCreationController.this.vault.getPath(), RecoveryKeyCreationController.this.passwordField.getCharacters());
        }
    }
}

