/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav.servlet;

import com.google.common.base.CharMatcher;
import dagger.Module;
import dagger.Provides;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.file.Path;
import java.util.EnumSet;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.cryptomator.frontend.webdav.servlet.FixedPathNioWebDavServlet;
import org.cryptomator.webdav.core.filters.AcceptRangeFilter;
import org.cryptomator.webdav.core.filters.LoggingFilter;
import org.cryptomator.webdav.core.filters.MacChunkedPutCompatibilityFilter;
import org.cryptomator.webdav.core.filters.MkcolComplianceFilter;
import org.cryptomator.webdav.core.filters.PostRequestBlockingFilter;
import org.cryptomator.webdav.core.filters.UnicodeResourcePathNormalizationFilter;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

@Module
public class WebDavServletModule {
    private static final String WILDCARD = "/*";
    private final Path rootPath;
    private final String contextPath;

    public WebDavServletModule(Path rootPath, String contextPath) {
        String trimmedCtxPath = CharMatcher.is((char)'/').trimTrailingFrom((CharSequence)contextPath);
        this.rootPath = rootPath;
        this.contextPath = trimmedCtxPath.startsWith("/") ? trimmedCtxPath : "/" + trimmedCtxPath;
    }

    @PerServlet
    @Provides
    @ContextPath
    public String provideContextRootUri() {
        return this.contextPath;
    }

    @PerServlet
    @Provides
    public ServletContextHandler provideServletContext() {
        FixedPathNioWebDavServlet servlet = new FixedPathNioWebDavServlet(this.rootPath);
        ServletContextHandler servletContext = new ServletContextHandler(null, this.contextPath, 1);
        ServletHolder servletHolder = new ServletHolder(this.contextPath, (Servlet)servlet);
        servletContext.addServlet(servletHolder, WILDCARD);
        servletContext.addFilter(LoggingFilter.class, WILDCARD, EnumSet.of(DispatcherType.REQUEST));
        servletContext.addFilter(UnicodeResourcePathNormalizationFilter.class, WILDCARD, EnumSet.of(DispatcherType.REQUEST));
        servletContext.addFilter(PostRequestBlockingFilter.class, WILDCARD, EnumSet.of(DispatcherType.REQUEST));
        servletContext.addFilter(MkcolComplianceFilter.class, WILDCARD, EnumSet.of(DispatcherType.REQUEST));
        servletContext.addFilter(AcceptRangeFilter.class, WILDCARD, EnumSet.of(DispatcherType.REQUEST));
        servletContext.addFilter(MacChunkedPutCompatibilityFilter.class, WILDCARD, EnumSet.of(DispatcherType.REQUEST));
        return servletContext;
    }

    @Scope
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface PerServlet {
    }

    @Qualifier
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface ContextPath {
    }
}

