/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;
import org.cryptomator.cryptolib.common.ByteBuffers;

public class DecryptingReadableByteChannel
implements ReadableByteChannel {
    private final ReadableByteChannel delegate;
    private final Cryptor cryptor;
    private final boolean authenticate;
    private ByteBuffer cleartextChunk;
    private FileHeader header;
    private boolean reachedEof;
    private long chunk;

    public DecryptingReadableByteChannel(ReadableByteChannel src, Cryptor cryptor, boolean authenticate) {
        this(src, cryptor, authenticate, null, 0L);
    }

    public DecryptingReadableByteChannel(ReadableByteChannel src, Cryptor cryptor, boolean authenticate, FileHeader header, long firstChunk) {
        this.delegate = src;
        this.cryptor = cryptor;
        this.authenticate = authenticate;
        this.cleartextChunk = ByteBuffer.allocate(0);
        this.header = header;
        this.reachedEof = false;
        this.chunk = firstChunk;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public synchronized int read(ByteBuffer dst) throws IOException {
        try {
            this.loadHeaderIfNecessary();
            if (this.reachedEof) {
                return -1;
            }
            return this.readInternal(dst);
        }
        catch (AuthenticationFailedException e) {
            throw new IOException("Unauthentic ciphertext", e);
        }
    }

    private int readInternal(ByteBuffer dst) throws IOException, AuthenticationFailedException {
        assert (this.header != null) : "header must be initialized";
        int result = 0;
        while (dst.hasRemaining() && !this.reachedEof) {
            if (this.cleartextChunk.hasRemaining() || this.loadNextCleartextChunk()) {
                result += ByteBuffers.copy(this.cleartextChunk, dst);
                continue;
            }
            assert (this.reachedEof) : "no further cleartext available";
        }
        return result;
    }

    private void loadHeaderIfNecessary() throws IOException, AuthenticationFailedException {
        if (this.header == null) {
            ByteBuffer headerBuf = ByteBuffer.allocate(this.cryptor.fileHeaderCryptor().headerSize());
            int read = ByteBuffers.fill(this.delegate, headerBuf);
            if (read != headerBuf.capacity()) {
                throw new EOFException("Unable to read header from channel.");
            }
            headerBuf.flip();
            this.header = this.cryptor.fileHeaderCryptor().decryptHeader(headerBuf);
        }
    }

    private boolean loadNextCleartextChunk() throws IOException, AuthenticationFailedException {
        ByteBuffer ciphertextChunk = ByteBuffer.allocate(this.cryptor.fileContentCryptor().ciphertextChunkSize());
        int read = ByteBuffers.fill(this.delegate, ciphertextChunk);
        if (read == 0) {
            this.reachedEof = true;
            return false;
        }
        ciphertextChunk.flip();
        this.cleartextChunk = this.cryptor.fileContentCryptor().decryptChunk(ciphertextChunk, this.chunk++, this.header, this.authenticate);
        return true;
    }
}

