/*
 * Decompiled with CFR 0.152.
 */
package com.dokany.java.structure.filesecurity;

import com.dokany.java.structure.EnumIntegerSet;
import com.dokany.java.structure.filesecurity.AccessControlEntry;
import com.dokany.java.structure.filesecurity.AccessControlEntryFlag;
import com.dokany.java.structure.filesecurity.AccessControlEntryType;
import com.dokany.java.structure.filesecurity.AccessMask;
import com.dokany.java.structure.filesecurity.SecurityIdentifier;
import java.nio.ByteBuffer;

public class AccessAllowedACE
extends AccessControlEntry {
    EnumIntegerSet<AccessMask> rights;
    SecurityIdentifier sid;

    public AccessAllowedACE(EnumIntegerSet<AccessControlEntryFlag> flags, SecurityIdentifier sid, EnumIntegerSet<AccessMask> rights) {
        super(AccessControlEntryType.ACCESS_ALLOWED_ACE_TYPE, flags);
        this.rights = rights;
        this.sid = sid;
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buf = ByteBuffer.allocate(this.sizeOfByteArray());
        buf.put(this.type.toByteArray());
        buf.put((byte)this.flags.toInt());
        buf.putShort(Short.reverseBytes((short)this.sizeOfByteArray()));
        buf.putInt(Integer.reverseBytes(this.rights.toInt()));
        buf.put(this.sid.toByteArray());
        return buf.array();
    }

    @Override
    public int sizeOfByteArray() {
        return 8 + this.sid.sizeOfByteArray();
    }
}

