/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.locks;

import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import org.cryptomator.frontend.fuse.locks.DataLockImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataRLockImpl
extends DataLockImpl {
    private static final Logger LOG = LoggerFactory.getLogger(DataRLockImpl.class);

    private DataRLockImpl(List<String> pathComponents, ReadWriteLock lock) {
        super(pathComponents, lock);
    }

    static DataRLockImpl create(List<String> pathComponents, ReadWriteLock lock) {
        lock.readLock().lock();
        LOG.trace("Acquired read data lock for '{}'", pathComponents);
        return new DataRLockImpl(pathComponents, lock);
    }

    @Override
    public void close() {
        LOG.trace("Released read data lock for '{}'", (Object)this.pathComponents);
        this.lock.readLock().unlock();
    }
}

