//========================================================================
//
// annot_stamp_top_secret.h
//
// Copyright (C) 2021 Mahmoud Ahmed Khalil <mahmoudkhalil11@gmail.com>
// Copyright (C) 2021 Albert Astals Cid <aacid@kde.org>
//
// Mechanically extracted from an SVG created for Okular by Eugene Trounev eugene.trounev@gmail.com
//
// Licensed under GPLv2 or later
//
//========================================================================

#ifndef ANNOT_STAMP_TOP_SECRET_H
#define ANNOT_STAMP_TOP_SECRET_H

#include "Dict.h"
#include "Object.h"
#include "PDFDoc.h"

static const double ANNOT_STAMP_TOP_SECRET_WIDTH = 141.258179;
static const double ANNOT_STAMP_TOP_SECRET_HEIGHT = 26.484743;

static const char *ANNOT_STAMP_TOP_SECRET = "1 0 0 -1 0 26.484741 cm\n"
                                            "q\n"
                                            "1 1 1 rg /a0 gs\n"
                                            "3.406 2.129 m 137.867 2.129 l 138.566 2.129 139.137 2.828 139.137 3.398\n"
                                            " c 139.137 23.09 l 139.137 23.789 138.57 24.359 137.867 24.359 c 3.406 24.359\n"
                                            " l 2.707 24.359 2.137 23.66 2.137 23.09 c 2.137 3.398 l 2.137 2.699 2.703\n"
                                            " 2.129 3.406 2.129 c h\n"
                                            "3.406 2.129 m f\n"
                                            "0.74902 0 0 rg /a1 gs\n"
                                            "21.77 7.926 m 21.77 20.832 l 18.547 20.832 l 18.547 7.926 l 13.574 7.926\n"
                                            " l 13.574 5.434 l 26.754 5.434 l 26.754 7.926 l 21.77 7.926 l 38.137 14.906\n"
                                            " m 38.137 15.809 38.008 16.637 37.754 17.387 c 37.508 18.137 37.133 18.785\n"
                                            " 36.629 19.332 c 36.125 19.871 35.5 20.293 34.75 20.598 c 34 20.895 33.125\n"
                                            " 21.047 32.129 21.047 c 31.168 21.047 30.32 20.898 29.582 20.598 c 28.848\n"
                                            " 20.301 28.227 19.879 27.723 19.34 c 27.227 18.801 26.852 18.156 26.598 \n"
                                            "17.406 c 26.344 16.648 26.215 15.816 26.215 14.902 c 26.215 14.02 26.336\n"
                                            " 13.207 26.574 12.465 c 26.82 11.715 27.195 11.066 27.688 10.52 c 28.184\n"
                                            " 9.973 28.805 9.547 29.555 9.242 c 30.305 8.938 31.184 8.785 32.188 8.785\n"
                                            " c 33.25 8.785 34.156 8.938 34.91 9.242 c 35.66 9.547 36.273 9.973 36.746\n"
                                            " 10.52 c 37.227 11.059 37.578 11.703 37.797 12.453 c 38.023 13.195 38.137\n"
                                            " 14.012 38.137 14.902 c 34.926 14.902 m 34.926 13.496 34.695 12.477 34.238\n"
                                            " 11.844 c 33.781 11.211 33.113 10.895 32.238 10.895 c 31.336 10.895 30.645\n"
                                            " 11.215 30.164 11.855 c 29.684 12.496 29.441 13.512 29.441 14.902 c 29.441\n"
                                            " 15.609 29.504 16.219 29.629 16.727 c 29.762 17.238 29.941 17.656 30.176\n"
                                            " 17.984 c 30.41 18.312 30.688 18.555 31.016 18.715 c 31.344 18.867 31.703\n"
                                            " 18.945 32.098 18.945 c 32.551 18.945 32.949 18.867 33.301 18.715 c 33.656\n"
                                            " 18.555 33.957 18.312 34.195 17.984 c 34.438 17.656 34.617 17.238 34.742\n"
                                            " 16.727 c 34.867 16.215 34.93 15.609 34.93 14.902 c 51.777 14.859 m 51.777\n"
                                            " 15.754 51.688 16.582 51.504 17.34 c 51.328 18.098 51.055 18.75 50.684 19.297\n"
                                            " c 50.312 19.844 49.84 20.273 49.262 20.586 c 48.695 20.891 48.02 21.043\n"
                                            " 47.242 21.043 c 46.891 21.043 46.543 21.008 46.191 20.934 c 45.848 20.859\n"
                                            " 45.52 20.746 45.207 20.582 c 44.895 20.414 44.602 20.199 44.332 19.938 \n"
                                            "c 44.07 19.668 43.844 19.336 43.656 18.941 c 43.59 18.941 l 43.598 18.977\n"
                                            " 43.605 19.07 43.613 19.215 c 43.621 19.359 43.629 19.531 43.637 19.727 \n"
                                            "c 43.645 19.914 43.648 20.121 43.648 20.34 c 43.656 20.551 43.66 20.746 \n"
                                            "43.66 20.93 c 43.66 25.465 l 40.59 25.465 l 40.59 11.719 l 40.59 11.113 \n"
                                            "40.578 10.574 40.559 10.102 c 40.543 9.629 40.527 9.262 40.504 8.996 c 43.488\n"
                                            " 8.996 l 43.504 9.047 43.516 9.145 43.531 9.293 c 43.555 9.438 43.566 9.605\n"
                                            " 43.574 9.797 c 43.59 9.984 43.602 10.184 43.605 10.387 c 43.613 10.59 43.617\n"
                                            " 10.77 43.617 10.922 c 43.66 10.922 l 44.031 10.141 44.543 9.586 45.191 \n"
                                            "9.25 c 45.84 8.914 46.59 8.746 47.441 8.746 c 48.191 8.746 48.84 8.898 49.387\n"
                                            " 9.203 c 49.934 9.508 50.383 9.93 50.73 10.469 c 51.086 11.008 51.352 11.652\n"
                                            " 51.516 12.402 c 51.691 13.145 51.777 13.961 51.777 14.852 c 48.574 14.852\n"
                                            " m 48.574 13.504 48.371 12.508 47.961 11.859 c 47.555 11.203 46.945 10.875\n"
                                            " 46.137 10.875 c 45.832 10.875 45.523 10.941 45.219 11.07 c 44.922 11.195\n"
                                            " 44.652 11.414 44.41 11.727 c 44.176 12.031 43.984 12.449 43.832 12.973 \n"
                                            "c 43.688 13.488 43.613 14.145 43.613 14.941 c 43.613 15.715 43.688 16.359\n"
                                            " 43.832 16.875 c 43.977 17.387 44.168 17.793 44.398 18.098 c 44.641 18.402\n"
                                            " 44.91 18.621 45.207 18.754 c 45.504 18.879 45.809 18.941 46.113 18.941 \n"
                                            "c 46.508 18.941 46.855 18.863 47.164 18.711 c 47.469 18.551 47.727 18.309\n"
                                            " 47.93 17.98 c 48.141 17.645 48.301 17.219 48.41 16.703 c 48.52 16.188 48.574\n"
                                            " 15.57 48.574 14.855 c 72.965 16.387 m 72.965 17.086 72.836 17.723 72.582\n"
                                            " 18.301 c 72.328 18.867 71.93 19.355 71.391 19.766 c 70.859 20.172 70.176\n"
                                            " 20.492 69.336 20.715 c 68.504 20.934 67.516 21.043 66.363 21.043 c 65.344\n"
                                            " 21.043 64.445 20.953 63.664 20.77 c 62.883 20.586 62.215 20.316 61.652 \n"
                                            "19.961 c 61.098 19.605 60.648 19.164 60.297 18.641 c 59.953 18.109 59.707\n"
                                            " 17.5 59.555 16.816 c 62.668 16.305 l 62.754 16.648 62.883 16.961 63.051\n"
                                            " 17.246 c 63.219 17.531 63.449 17.777 63.738 17.988 c 64.035 18.191 64.406\n"
                                            " 18.352 64.844 18.469 c 65.289 18.578 65.824 18.633 66.449 18.633 c 67.543\n"
                                            " 18.633 68.375 18.469 68.953 18.141 c 69.535 17.805 69.828 17.285 69.828\n"
                                            " 16.578 c 69.828 16.156 69.711 15.809 69.477 15.539 c 69.242 15.27 68.934\n"
                                            " 15.047 68.547 14.871 c 68.16 14.695 67.715 14.551 67.215 14.434 c 66.711\n"
                                            " 14.316 66.188 14.203 65.641 14.094 c 65.203 13.992 64.766 13.887 64.328\n"
                                            " 13.777 c 63.891 13.668 63.473 13.535 63.07 13.383 c 62.676 13.23 62.309\n"
                                            " 13.047 61.965 12.836 c 61.621 12.625 61.324 12.367 61.07 12.059 c 60.824\n"
                                            " 11.746 60.625 11.383 60.48 10.965 c 60.344 10.551 60.273 10.062 60.273 \n"
                                            "9.5 c 60.273 8.734 60.426 8.078 60.73 7.531 c 61.035 6.984 61.457 6.539 \n"
                                            "61.996 6.199 c 62.543 5.848 63.191 5.594 63.941 5.434 c 64.691 5.273 65.512\n"
                                            " 5.191 66.398 5.191 c 67.402 5.191 68.262 5.273 68.977 5.434 c 69.699 5.586\n"
                                            " 70.297 5.824 70.781 6.145 c 71.27 6.465 71.652 6.871 71.93 7.355 c 72.215\n"
                                            " 7.836 72.422 8.402 72.551 9.051 c 69.426 9.477 l 69.266 8.812 68.938 8.316\n"
                                            " 68.441 7.98 c 67.953 7.645 67.25 7.477 66.332 7.477 c 65.766 7.477 65.289\n"
                                            " 7.527 64.91 7.629 c 64.539 7.723 64.238 7.855 64.016 8.023 c 63.797 8.191\n"
                                            " 63.641 8.387 63.547 8.613 c 63.453 8.832 63.406 9.066 63.406 9.312 c 63.406\n"
                                            " 9.691 63.496 10.004 63.68 10.254 c 63.863 10.496 64.117 10.699 64.445 10.867\n"
                                            " c 64.773 11.027 65.164 11.164 65.613 11.281 c 66.07 11.391 66.574 11.504\n"
                                            " 67.121 11.621 c 67.602 11.723 68.078 11.832 68.551 11.949 c 69.023 12.059\n"
                                            " 69.477 12.191 69.906 12.344 c 70.336 12.496 70.738 12.684 71.109 12.902\n"
                                            " c 71.48 13.121 71.801 13.391 72.07 13.711 c 72.348 14.023 72.562 14.398\n"
                                            " 72.715 14.836 c 72.875 15.273 72.957 15.789 72.957 16.387 c 80.258 21.043\n"
                                            " m 79.406 21.043 78.637 20.918 77.953 20.672 c 77.277 20.418 76.695 20.035\n"
                                            " 76.215 19.523 c 75.734 19.008 75.367 18.363 75.109 17.59 c 74.855 16.809\n"
                                            " 74.727 15.898 74.727 14.859 c 74.727 13.73 74.875 12.781 75.176 12.008 \n"
                                            "c 75.48 11.234 75.891 10.613 76.398 10.141 c 76.914 9.66 77.508 9.312 78.18\n"
                                            " 9.102 c 78.852 8.891 79.555 8.785 80.301 8.785 c 81.234 8.785 82.027 8.949\n"
                                            " 82.684 9.277 c 83.348 9.598 83.891 10.051 84.312 10.633 c 84.734 11.215\n"
                                            " 85.043 11.914 85.242 12.73 c 85.438 13.539 85.539 14.434 85.539 15.418 \n"
                                            "c 85.539 15.504 l 77.957 15.504 l 77.957 16 78 16.461 78.09 16.891 c 78.176\n"
                                            " 17.312 78.32 17.68 78.516 17.996 c 78.711 18.301 78.969 18.547 79.281 18.727\n"
                                            " c 79.594 18.902 79.973 18.988 80.418 18.988 c 80.957 18.988 81.398 18.875\n"
                                            " 81.738 18.648 c 82.082 18.414 82.324 18.059 82.469 17.578 c 85.363 17.828\n"
                                            " l 85.23 18.164 85.047 18.52 84.805 18.898 c 84.57 19.277 84.258 19.625 \n"
                                            "83.863 19.949 c 83.469 20.262 82.977 20.523 82.387 20.734 c 81.805 20.938\n"
                                            " 81.094 21.039 80.258 21.039 c 80.258 10.715 m 79.945 10.715 79.648 10.77\n"
                                            " 79.371 10.879 c 79.102 10.98 78.863 11.148 78.66 11.383 c 78.465 11.609\n"
                                            " 78.305 11.902 78.18 12.27 c 78.055 12.633 77.988 13.07 77.973 13.582 c \n"
                                            "82.562 13.582 l 82.504 12.629 82.273 11.914 81.875 11.441 c 81.473 10.961\n"
                                            " 80.934 10.719 80.258 10.719 c 92.801 21.043 m 91.859 21.043 91.039 20.898\n"
                                            " 90.332 20.605 c 89.633 20.312 89.051 19.902 88.582 19.371 c 88.117 18.84\n"
                                            " 87.766 18.203 87.531 17.457 c 87.297 16.707 87.18 15.879 87.18 14.977 c\n"
                                            " 87.18 13.992 87.309 13.117 87.562 12.355 c 87.816 11.582 88.184 10.934 \n"
                                            "88.668 10.41 c 89.148 9.879 89.738 9.473 90.438 9.199 c 91.145 8.922 91.945\n"
                                            " 8.785 92.84 8.785 c 93.605 8.785 94.281 8.887 94.871 9.09 c 95.469 9.293\n"
                                            " 95.98 9.574 96.41 9.93 c 96.84 10.281 97.188 10.695 97.449 11.176 c 97.719\n"
                                            " 11.656 97.906 12.172 98.008 12.727 c 94.914 12.879 l 94.828 12.273 94.609\n"
                                            " 11.793 94.258 11.438 c 93.906 11.074 93.414 10.891 92.773 10.891 c 91.949\n"
                                            " 10.891 91.348 11.23 90.969 11.906 c 90.59 12.582 90.402 13.566 90.402 14.855\n"
                                            " c 90.402 17.578 91.207 18.941 92.816 18.941 c 93.398 18.941 93.887 18.758\n"
                                            " 94.281 18.395 c 94.676 18.023 94.918 17.473 95.012 16.746 c 98.094 16.887\n"
                                            " l 98.02 17.434 97.852 17.957 97.59 18.461 c 97.336 18.957 96.984 19.398\n"
                                            " 96.539 19.781 c 96.102 20.16 95.57 20.465 94.945 20.699 c 94.32 20.926 \n"
                                            "93.602 21.039 92.793 21.039 c 100.32 20.82 m 100.32 11.773 l 100.32 11.52\n"
                                            " 100.316 11.25 100.309 10.965 c 100.309 10.68 100.301 10.41 100.285 10.156\n"
                                            " c 100.277 9.895 100.27 9.66 100.262 9.457 c 100.254 9.246 100.242 9.094\n"
                                            " 100.23 9 c 103.16 9 l 103.176 9.086 103.188 9.242 103.203 9.457 c 103.219\n"
                                            " 9.668 103.23 9.902 103.246 10.156 c 103.262 10.41 103.273 10.668 103.277\n"
                                            " 10.922 c 103.293 11.168 103.301 11.371 103.301 11.523 c 103.344 11.523 \n"
                                            "l 103.496 11.094 103.648 10.711 103.801 10.375 c 103.953 10.031 104.133 \n"
                                            "9.746 104.336 9.512 c 104.547 9.27 104.797 9.09 105.09 8.965 c 105.383 8.832\n"
                                            " 105.742 8.77 106.172 8.77 c 106.355 8.77 106.531 8.789 106.707 8.824 c \n"
                                            "106.891 8.852 107.027 8.891 107.121 8.934 c 107.121 11.5 l 106.926 11.457\n"
                                            " 106.723 11.418 106.52 11.391 c 106.324 11.355 106.086 11.336 105.809 11.336\n"
                                            " c 105.043 11.336 104.445 11.645 104.016 12.266 c 103.594 12.887 103.383\n"
                                            " 13.801 103.383 15.02 c 103.383 20.82 l 100.312 20.82 l 113.852 21.039 m\n"
                                            " 113 21.039 112.23 20.914 111.547 20.668 c 110.871 20.414 110.289 20.031\n"
                                            " 109.809 19.52 c 109.328 19.004 108.961 18.359 108.703 17.586 c 108.449 \n"
                                            "16.805 108.32 15.895 108.32 14.855 c 108.32 13.727 108.469 12.777 108.77\n"
                                            " 12.004 c 109.074 11.23 109.484 10.609 109.992 10.137 c 110.508 9.656 111.102\n"
                                            " 9.309 111.773 9.098 c 112.445 8.887 113.148 8.781 113.895 8.781 c 114.828\n"
                                            " 8.781 115.621 8.945 116.277 9.273 c 116.941 9.594 117.484 10.047 117.906\n"
                                            " 10.629 c 118.328 11.211 118.637 11.91 118.836 12.727 c 119.031 13.535 119.133\n"
                                            " 14.43 119.133 15.414 c 119.133 15.5 l 111.551 15.5 l 111.551 15.996 111.594\n"
                                            " 16.457 111.684 16.887 c 111.77 17.309 111.914 17.676 112.109 17.992 c 112.305\n"
                                            " 18.297 112.562 18.543 112.875 18.723 c 113.188 18.898 113.566 18.984 114.012\n"
                                            " 18.984 c 114.551 18.984 114.992 18.871 115.332 18.645 c 115.676 18.41 115.918\n"
                                            " 18.055 116.062 17.574 c 118.957 17.824 l 118.824 18.16 118.641 18.516 118.398\n"
                                            " 18.895 c 118.164 19.273 117.852 19.621 117.457 19.945 c 117.062 20.258 \n"
                                            "116.57 20.52 115.98 20.73 c 115.398 20.934 114.688 21.035 113.852 21.035\n"
                                            " c 113.852 10.711 m 113.539 10.711 113.242 10.766 112.965 10.875 c 112.695\n"
                                            " 10.977 112.457 11.145 112.254 11.379 c 112.059 11.605 111.898 11.898 111.773\n"
                                            " 12.266 c 111.648 12.629 111.582 13.066 111.566 13.578 c 116.156 13.578 \n"
                                            "l 116.098 12.625 115.867 11.91 115.469 11.438 c 115.066 10.957 114.527 10.715\n"
                                            " 113.852 10.715 c 124.496 21.02 m 123.594 21.02 122.898 20.777 122.41 20.289\n"
                                            " c 121.922 19.793 121.68 19.047 121.68 18.051 c 121.68 11.078 l 120.184 \n"
                                            "11.078 l 120.184 9.004 l 121.832 9.004 l 122.793 6.227 l 124.715 6.227 l\n"
                                            " 124.715 9.004 l 126.953 9.004 l 126.953 11.078 l 124.715 11.078 l 124.715\n"
                                            " 17.219 l 124.715 17.793 124.824 18.219 125.043 18.496 c 125.262 18.766 \n"
                                            "125.602 18.902 126.059 18.898 c 126.246 18.898 126.418 18.883 126.57 18.855\n"
                                            " c 126.723 18.828 126.895 18.789 127.082 18.746 c 127.082 20.648 l 126.703\n"
                                            " 20.773 126.301 20.863 125.879 20.922 c 125.457 20.988 124.992 21.02 124.492\n"
                                            " 21.02 c f\n"
                                            "1 1 1 RG 0.531496 w\n"
                                            "0 J\n"
                                            "0 j\n"
                                            "[] 0.0 d\n"
                                            "4 M q 1 0 0 1 0 0 cm\n"
                                            "21.77 7.926 m 21.77 20.832 l 18.547 20.832 l 18.547 7.926 l 13.574 7.926\n"
                                            " l 13.574 5.434 l 26.754 5.434 l 26.754 7.926 l 21.77 7.926 l 38.137 14.906\n"
                                            " m 38.137 15.809 38.008 16.637 37.754 17.387 c 37.508 18.137 37.133 18.785\n"
                                            " 36.629 19.332 c 36.125 19.871 35.5 20.293 34.75 20.598 c 34 20.895 33.125\n"
                                            " 21.047 32.129 21.047 c 31.168 21.047 30.32 20.898 29.582 20.598 c 28.848\n"
                                            " 20.301 28.227 19.879 27.723 19.34 c 27.227 18.801 26.852 18.156 26.598 \n"
                                            "17.406 c 26.344 16.648 26.215 15.816 26.215 14.902 c 26.215 14.02 26.336\n"
                                            " 13.207 26.574 12.465 c 26.82 11.715 27.195 11.066 27.688 10.52 c 28.184\n"
                                            " 9.973 28.805 9.547 29.555 9.242 c 30.305 8.938 31.184 8.785 32.188 8.785\n"
                                            " c 33.25 8.785 34.156 8.938 34.91 9.242 c 35.66 9.547 36.273 9.973 36.746\n"
                                            " 10.52 c 37.227 11.059 37.578 11.703 37.797 12.453 c 38.023 13.195 38.137\n"
                                            " 14.012 38.137 14.902 c 34.926 14.902 m 34.926 13.496 34.695 12.477 34.238\n"
                                            " 11.844 c 33.781 11.211 33.113 10.895 32.238 10.895 c 31.336 10.895 30.645\n"
                                            " 11.215 30.164 11.855 c 29.684 12.496 29.441 13.512 29.441 14.902 c 29.441\n"
                                            " 15.609 29.504 16.219 29.629 16.727 c 29.762 17.238 29.941 17.656 30.176\n"
                                            " 17.984 c 30.41 18.312 30.688 18.555 31.016 18.715 c 31.344 18.867 31.703\n"
                                            " 18.945 32.098 18.945 c 32.551 18.945 32.949 18.867 33.301 18.715 c 33.656\n"
                                            " 18.555 33.957 18.312 34.195 17.984 c 34.438 17.656 34.617 17.238 34.742\n"
                                            " 16.727 c 34.867 16.215 34.93 15.609 34.93 14.902 c 51.777 14.859 m 51.777\n"
                                            " 15.754 51.688 16.582 51.504 17.34 c 51.328 18.098 51.055 18.75 50.684 19.297\n"
                                            " c 50.312 19.844 49.84 20.273 49.262 20.586 c 48.695 20.891 48.02 21.043\n"
                                            " 47.242 21.043 c 46.891 21.043 46.543 21.008 46.191 20.934 c 45.848 20.859\n"
                                            " 45.52 20.746 45.207 20.582 c 44.895 20.414 44.602 20.199 44.332 19.938 \n"
                                            "c 44.07 19.668 43.844 19.336 43.656 18.941 c 43.59 18.941 l 43.598 18.977\n"
                                            " 43.605 19.07 43.613 19.215 c 43.621 19.359 43.629 19.531 43.637 19.727 \n"
                                            "c 43.645 19.914 43.648 20.121 43.648 20.34 c 43.656 20.551 43.66 20.746 \n"
                                            "43.66 20.93 c 43.66 25.465 l 40.59 25.465 l 40.59 11.719 l 40.59 11.113 \n"
                                            "40.578 10.574 40.559 10.102 c 40.543 9.629 40.527 9.262 40.504 8.996 c 43.488\n"
                                            " 8.996 l 43.504 9.047 43.516 9.145 43.531 9.293 c 43.555 9.438 43.566 9.605\n"
                                            " 43.574 9.797 c 43.59 9.984 43.602 10.184 43.605 10.387 c 43.613 10.59 43.617\n"
                                            " 10.77 43.617 10.922 c 43.66 10.922 l 44.031 10.141 44.543 9.586 45.191 \n"
                                            "9.25 c 45.84 8.914 46.59 8.746 47.441 8.746 c 48.191 8.746 48.84 8.898 49.387\n"
                                            " 9.203 c 49.934 9.508 50.383 9.93 50.73 10.469 c 51.086 11.008 51.352 11.652\n"
                                            " 51.516 12.402 c 51.691 13.145 51.777 13.961 51.777 14.852 c 48.574 14.852\n"
                                            " m 48.574 13.504 48.371 12.508 47.961 11.859 c 47.555 11.203 46.945 10.875\n"
                                            " 46.137 10.875 c 45.832 10.875 45.523 10.941 45.219 11.07 c 44.922 11.195\n"
                                            " 44.652 11.414 44.41 11.727 c 44.176 12.031 43.984 12.449 43.832 12.973 \n"
                                            "c 43.688 13.488 43.613 14.145 43.613 14.941 c 43.613 15.715 43.688 16.359\n"
                                            " 43.832 16.875 c 43.977 17.387 44.168 17.793 44.398 18.098 c 44.641 18.402\n"
                                            " 44.91 18.621 45.207 18.754 c 45.504 18.879 45.809 18.941 46.113 18.941 \n"
                                            "c 46.508 18.941 46.855 18.863 47.164 18.711 c 47.469 18.551 47.727 18.309\n"
                                            " 47.93 17.98 c 48.141 17.645 48.301 17.219 48.41 16.703 c 48.52 16.188 48.574\n"
                                            " 15.57 48.574 14.855 c 72.965 16.387 m 72.965 17.086 72.836 17.723 72.582\n"
                                            " 18.301 c 72.328 18.867 71.93 19.355 71.391 19.766 c 70.859 20.172 70.176\n"
                                            " 20.492 69.336 20.715 c 68.504 20.934 67.516 21.043 66.363 21.043 c 65.344\n"
                                            " 21.043 64.445 20.953 63.664 20.77 c 62.883 20.586 62.215 20.316 61.652 \n"
                                            "19.961 c 61.098 19.605 60.648 19.164 60.297 18.641 c 59.953 18.109 59.707\n"
                                            " 17.5 59.555 16.816 c 62.668 16.305 l 62.754 16.648 62.883 16.961 63.051\n"
                                            " 17.246 c 63.219 17.531 63.449 17.777 63.738 17.988 c 64.035 18.191 64.406\n"
                                            " 18.352 64.844 18.469 c 65.289 18.578 65.824 18.633 66.449 18.633 c 67.543\n"
                                            " 18.633 68.375 18.469 68.953 18.141 c 69.535 17.805 69.828 17.285 69.828\n"
                                            " 16.578 c 69.828 16.156 69.711 15.809 69.477 15.539 c 69.242 15.27 68.934\n"
                                            " 15.047 68.547 14.871 c 68.16 14.695 67.715 14.551 67.215 14.434 c 66.711\n"
                                            " 14.316 66.188 14.203 65.641 14.094 c 65.203 13.992 64.766 13.887 64.328\n"
                                            " 13.777 c 63.891 13.668 63.473 13.535 63.07 13.383 c 62.676 13.23 62.309\n"
                                            " 13.047 61.965 12.836 c 61.621 12.625 61.324 12.367 61.07 12.059 c 60.824\n"
                                            " 11.746 60.625 11.383 60.48 10.965 c 60.344 10.551 60.273 10.062 60.273 \n"
                                            "9.5 c 60.273 8.734 60.426 8.078 60.73 7.531 c 61.035 6.984 61.457 6.539 \n"
                                            "61.996 6.199 c 62.543 5.848 63.191 5.594 63.941 5.434 c 64.691 5.273 65.512\n"
                                            " 5.191 66.398 5.191 c 67.402 5.191 68.262 5.273 68.977 5.434 c 69.699 5.586\n"
                                            " 70.297 5.824 70.781 6.145 c 71.27 6.465 71.652 6.871 71.93 7.355 c 72.215\n"
                                            " 7.836 72.422 8.402 72.551 9.051 c 69.426 9.477 l 69.266 8.812 68.938 8.316\n"
                                            " 68.441 7.98 c 67.953 7.645 67.25 7.477 66.332 7.477 c 65.766 7.477 65.289\n"
                                            " 7.527 64.91 7.629 c 64.539 7.723 64.238 7.855 64.016 8.023 c 63.797 8.191\n"
                                            " 63.641 8.387 63.547 8.613 c 63.453 8.832 63.406 9.066 63.406 9.312 c 63.406\n"
                                            " 9.691 63.496 10.004 63.68 10.254 c 63.863 10.496 64.117 10.699 64.445 10.867\n"
                                            " c 64.773 11.027 65.164 11.164 65.613 11.281 c 66.07 11.391 66.574 11.504\n"
                                            " 67.121 11.621 c 67.602 11.723 68.078 11.832 68.551 11.949 c 69.023 12.059\n"
                                            " 69.477 12.191 69.906 12.344 c 70.336 12.496 70.738 12.684 71.109 12.902\n"
                                            " c 71.48 13.121 71.801 13.391 72.07 13.711 c 72.348 14.023 72.562 14.398\n"
                                            " 72.715 14.836 c 72.875 15.273 72.957 15.789 72.957 16.387 c 80.258 21.043\n"
                                            " m 79.406 21.043 78.637 20.918 77.953 20.672 c 77.277 20.418 76.695 20.035\n"
                                            " 76.215 19.523 c 75.734 19.008 75.367 18.363 75.109 17.59 c 74.855 16.809\n"
                                            " 74.727 15.898 74.727 14.859 c 74.727 13.73 74.875 12.781 75.176 12.008 \n"
                                            "c 75.48 11.234 75.891 10.613 76.398 10.141 c 76.914 9.66 77.508 9.312 78.18\n"
                                            " 9.102 c 78.852 8.891 79.555 8.785 80.301 8.785 c 81.234 8.785 82.027 8.949\n"
                                            " 82.684 9.277 c 83.348 9.598 83.891 10.051 84.312 10.633 c 84.734 11.215\n"
                                            " 85.043 11.914 85.242 12.73 c 85.438 13.539 85.539 14.434 85.539 15.418 \n"
                                            "c 85.539 15.504 l 77.957 15.504 l 77.957 16 78 16.461 78.09 16.891 c 78.176\n"
                                            " 17.312 78.32 17.68 78.516 17.996 c 78.711 18.301 78.969 18.547 79.281 18.727\n"
                                            " c 79.594 18.902 79.973 18.988 80.418 18.988 c 80.957 18.988 81.398 18.875\n"
                                            " 81.738 18.648 c 82.082 18.414 82.324 18.059 82.469 17.578 c 85.363 17.828\n"
                                            " l 85.23 18.164 85.047 18.52 84.805 18.898 c 84.57 19.277 84.258 19.625 \n"
                                            "83.863 19.949 c 83.469 20.262 82.977 20.523 82.387 20.734 c 81.805 20.938\n"
                                            " 81.094 21.039 80.258 21.039 c 80.258 10.715 m 79.945 10.715 79.648 10.77\n"
                                            " 79.371 10.879 c 79.102 10.98 78.863 11.148 78.66 11.383 c 78.465 11.609\n"
                                            " 78.305 11.902 78.18 12.27 c 78.055 12.633 77.988 13.07 77.973 13.582 c \n"
                                            "82.562 13.582 l 82.504 12.629 82.273 11.914 81.875 11.441 c 81.473 10.961\n"
                                            " 80.934 10.719 80.258 10.719 c 92.801 21.043 m 91.859 21.043 91.039 20.898\n"
                                            " 90.332 20.605 c 89.633 20.312 89.051 19.902 88.582 19.371 c 88.117 18.84\n"
                                            " 87.766 18.203 87.531 17.457 c 87.297 16.707 87.18 15.879 87.18 14.977 c\n"
                                            " 87.18 13.992 87.309 13.117 87.562 12.355 c 87.816 11.582 88.184 10.934 \n"
                                            "88.668 10.41 c 89.148 9.879 89.738 9.473 90.438 9.199 c 91.145 8.922 91.945\n"
                                            " 8.785 92.84 8.785 c 93.605 8.785 94.281 8.887 94.871 9.09 c 95.469 9.293\n"
                                            " 95.98 9.574 96.41 9.93 c 96.84 10.281 97.188 10.695 97.449 11.176 c 97.719\n"
                                            " 11.656 97.906 12.172 98.008 12.727 c 94.914 12.879 l 94.828 12.273 94.609\n"
                                            " 11.793 94.258 11.438 c 93.906 11.074 93.414 10.891 92.773 10.891 c 91.949\n"
                                            " 10.891 91.348 11.23 90.969 11.906 c 90.59 12.582 90.402 13.566 90.402 14.855\n"
                                            " c 90.402 17.578 91.207 18.941 92.816 18.941 c 93.398 18.941 93.887 18.758\n"
                                            " 94.281 18.395 c 94.676 18.023 94.918 17.473 95.012 16.746 c 98.094 16.887\n"
                                            " l 98.02 17.434 97.852 17.957 97.59 18.461 c 97.336 18.957 96.984 19.398\n"
                                            " 96.539 19.781 c 96.102 20.16 95.57 20.465 94.945 20.699 c 94.32 20.926 \n"
                                            "93.602 21.039 92.793 21.039 c 100.32 20.82 m 100.32 11.773 l 100.32 11.52\n"
                                            " 100.316 11.25 100.309 10.965 c 100.309 10.68 100.301 10.41 100.285 10.156\n"
                                            " c 100.277 9.895 100.27 9.66 100.262 9.457 c 100.254 9.246 100.242 9.094\n"
                                            " 100.23 9 c 103.16 9 l 103.176 9.086 103.188 9.242 103.203 9.457 c 103.219\n"
                                            " 9.668 103.23 9.902 103.246 10.156 c 103.262 10.41 103.273 10.668 103.277\n"
                                            " 10.922 c 103.293 11.168 103.301 11.371 103.301 11.523 c 103.344 11.523 \n"
                                            "l 103.496 11.094 103.648 10.711 103.801 10.375 c 103.953 10.031 104.133 \n"
                                            "9.746 104.336 9.512 c 104.547 9.27 104.797 9.09 105.09 8.965 c 105.383 8.832\n"
                                            " 105.742 8.77 106.172 8.77 c 106.355 8.77 106.531 8.789 106.707 8.824 c \n"
                                            "106.891 8.852 107.027 8.891 107.121 8.934 c 107.121 11.5 l 106.926 11.457\n"
                                            " 106.723 11.418 106.52 11.391 c 106.324 11.355 106.086 11.336 105.809 11.336\n"
                                            " c 105.043 11.336 104.445 11.645 104.016 12.266 c 103.594 12.887 103.383\n"
                                            " 13.801 103.383 15.02 c 103.383 20.82 l 100.312 20.82 l 113.852 21.039 m\n"
                                            " 113 21.039 112.23 20.914 111.547 20.668 c 110.871 20.414 110.289 20.031\n"
                                            " 109.809 19.52 c 109.328 19.004 108.961 18.359 108.703 17.586 c 108.449 \n"
                                            "16.805 108.32 15.895 108.32 14.855 c 108.32 13.727 108.469 12.777 108.77\n"
                                            " 12.004 c 109.074 11.23 109.484 10.609 109.992 10.137 c 110.508 9.656 111.102\n"
                                            " 9.309 111.773 9.098 c 112.445 8.887 113.148 8.781 113.895 8.781 c 114.828\n"
                                            " 8.781 115.621 8.945 116.277 9.273 c 116.941 9.594 117.484 10.047 117.906\n"
                                            " 10.629 c 118.328 11.211 118.637 11.91 118.836 12.727 c 119.031 13.535 119.133\n"
                                            " 14.43 119.133 15.414 c 119.133 15.5 l 111.551 15.5 l 111.551 15.996 111.594\n"
                                            " 16.457 111.684 16.887 c 111.77 17.309 111.914 17.676 112.109 17.992 c 112.305\n"
                                            " 18.297 112.562 18.543 112.875 18.723 c 113.188 18.898 113.566 18.984 114.012\n"
                                            " 18.984 c 114.551 18.984 114.992 18.871 115.332 18.645 c 115.676 18.41 115.918\n"
                                            " 18.055 116.062 17.574 c 118.957 17.824 l 118.824 18.16 118.641 18.516 118.398\n"
                                            " 18.895 c 118.164 19.273 117.852 19.621 117.457 19.945 c 117.062 20.258 \n"
                                            "116.57 20.52 115.98 20.73 c 115.398 20.934 114.688 21.035 113.852 21.035\n"
                                            " c 113.852 10.711 m 113.539 10.711 113.242 10.766 112.965 10.875 c 112.695\n"
                                            " 10.977 112.457 11.145 112.254 11.379 c 112.059 11.605 111.898 11.898 111.773\n"
                                            " 12.266 c 111.648 12.629 111.582 13.066 111.566 13.578 c 116.156 13.578 \n"
                                            "l 116.098 12.625 115.867 11.91 115.469 11.438 c 115.066 10.957 114.527 10.715\n"
                                            " 113.852 10.715 c 124.496 21.02 m 123.594 21.02 122.898 20.777 122.41 20.289\n"
                                            " c 121.922 19.793 121.68 19.047 121.68 18.051 c 121.68 11.078 l 120.184 \n"
                                            "11.078 l 120.184 9.004 l 121.832 9.004 l 122.793 6.227 l 124.715 6.227 l\n"
                                            " 124.715 9.004 l 126.953 9.004 l 126.953 11.078 l 124.715 11.078 l 124.715\n"
                                            " 17.219 l 124.715 17.793 124.824 18.219 125.043 18.496 c 125.262 18.766 \n"
                                            "125.602 18.902 126.059 18.898 c 126.246 18.898 126.418 18.883 126.57 18.855\n"
                                            " c 126.723 18.828 126.895 18.789 127.082 18.746 c 127.082 20.648 l 126.703\n"
                                            " 20.773 126.301 20.863 125.879 20.922 c 125.457 20.988 124.992 21.02 124.492\n"
                                            " 21.02 c S Q\n"
                                            "Q q\n"
                                            "0 0 141 26.484 re W n\n"
                                            "0.74902 0 0 rg /a1 gs\n"
                                            "3.398 0.398 m 1.77 0.398 0.398 1.77 0.398 3.398 c 0.398 23.086 l 0.398 \n"
                                            "24.715 1.77 26.086 3.398 26.086 c 137.859 26.086 l 139.488 26.086 140.859\n"
                                            " 24.715 140.859 23.086 c 140.859 3.398 l 140.859 1.77 139.488 0.398 137.859\n"
                                            " 0.398 c h\n"
                                            "3.867 3.844 m 137.414 3.844 l 137.414 22.617 l 3.867 22.617 l h\n"
                                            "3.867 3.844 m f\n"
                                            "Q q\n"
                                            "1 1 1 RG /a1 gs\n"
                                            "0.797243 w\n"
                                            "1 J\n"
                                            "1 j\n"
                                            "[] 0.0 d\n"
                                            "4 M q 1 0 0 1 0 0 cm\n"
                                            "3.398 0.398 m 1.77 0.398 0.398 1.77 0.398 3.398 c 0.398 23.086 l 0.398 \n"
                                            "24.715 1.77 26.086 3.398 26.086 c 137.859 26.086 l 139.488 26.086 140.859\n"
                                            " 24.715 140.859 23.086 c 140.859 3.398 l 140.859 1.77 139.488 0.398 137.859\n"
                                            " 0.398 c h\n"
                                            "3.867 3.844 m 137.414 3.844 l 137.414 22.617 l 3.867 22.617 l h\n"
                                            "3.867 3.844 m S Q\n"
                                            "Q\n";

static Dict *getTopSecretStampExtGStateDict(PDFDoc *doc)
{
    Dict *a0Dict = new Dict(doc->getXRef());
    a0Dict->add("CA", Object(0.588235));
    a0Dict->add("ca", Object(0.588235));

    Dict *a1Dict = new Dict(doc->getXRef());
    a1Dict->add("CA", Object(1));
    a1Dict->add("ca", Object(1));

    Dict *extGStateDict = new Dict(doc->getXRef());
    extGStateDict->add("a0", Object(a0Dict));
    extGStateDict->add("a1", Object(a1Dict));

    return extGStateDict;
}

#endif
