## ВСТУП

Wine - це програма, яка дозволяє запускати програми Microsoft
Windows (включаючи DOS, Windows 3.x, Win32 та Win64) на Unix. Вона
складається з програми завантаження, яка завантажує та виконує програми
Microsoft Windows, і бібліотеки (Winelib), яка реалізує виклики
Windows API, використовуючи їх Unix- або X11-еквіваленти. Бібліотека
також може бути використана для портування коду Win32 в середовище Unix.

Wine - вільне програмне забезпечення, опубліковане за ліцензією
GNU LGPL; дивіться файл LICENSE за детальною інформацією.


## ШВИДКИЙ СТАРТ

Кожен раз, коли ви компілюєте вихідний код, рекомендується використовувати
Wine Installer для компонування і встановлення Wine. У каталозі, що містить
вихідний код Wine (у ній знаходиться цей файл), введіть:

```
./configure
make
```

Запустіть програму як `wine program`. Додаткові джерела інформації
перераховані в кінці цього файлу. Ознайомтеся з посібником з Wine,
а також з сайтом https://www.winehq.org.


## ВИМОГИ

Компіляція і запуск Wine підтримується в наступних операційних системах:

- Linux версії 2.0.36 чи новіший
- FreeBSD 12.4 чи новіший
- Solaris x86 9 чи новіший
- NetBSD-поточна версія
- Mac OS X 10.8 чи новіший

Оскільки Wine вимагає для запуску підтримку потоків на рівні ядра, підтримуються
тільки операційні системи, перераховані вище. Інші операційні системи,
з підтримкою багатопоковості ядром, можуть підтримуватися Wine в майбутньому.

**FreeBSD**:
  Wine не буде працювати як слід на версіях нижче, ніж FreeBSD 6.3
  чи 7.0. Для FreeBSD 6.3 є патч, що дозволяє Wine запускатися.
  Відвідайте https://wiki.freebsd.org/Wine для додаткової інформації.

**Solaris**:
  Найкраще збирати Wine інструментами GNU (gcc, gas, тощо). Увага:
  встановлення gas *НЕ* гарантує що gcc буде його використовувати.
  Необхідно перекомпілювати gcc після установки gas або створити
  посилання на cc, як і на ld в інструментах gnu.

**NetBSD**:
  Переконайтеся, що параметри USER_LDT, SYSVSHM, SYSVSEM і SYSVMSG
  у вашому ядрі включені.

**Mac OS X**:
  Вам потрібен Xcode 2.4 або більш новий для компіляції x86.

**Підтримувані файлові системи**:
  Wine повинен працювати на більшості файлових систем. При використанні
  файлів через Samba можливі деякі проблеми з сумісністю. NTFS не має
  необхідної функціональності, потрібної для роботи деяких додатків.
  Рекомендується використовувати файлові системи Linux, такі як ext3.

**Базові вимоги**:
  У вас повинні бути встановлені файли заголовків X11
  (xorg-dev в Debian та libX11-devel в Red Hat).
  Звісно, вам потрібен make (краще всього використовувати GNU make).
  Вам також знадобляться flex (версії 2.5.33 або новіший) та bison.

**Додаткові бібліотеки підтримки**:
  Конфігураційний скрипт виведе список додаткових бібліотек, які не були
  знайдені у вашій системі. Ознайомтеся з переліком потрібних пакетів за
  адресою https://gitlab.winehq.org/wine/wine/-/wikis/Building-Wine.
  На 64-бітних платформах ви повинні переконатися, що у вас встановлені
  32-бітні версії цих бібліотек.

## ЗБИРАННЯ

Якщо ви не хочете використовувати wineinstall, введіть наступні команди
для збирання Wine:

```
./configure
make
```

Це збере програму "wine" та інші необхідні бібліотеки та бінарні файли.
Програма "wine" буде завантажувати, і виконувати програми Windows.
Бібліотека "libwine" ("Winelib") може бути використана для компілювання
й компонування вихідного коду Windows під Unix.

Для виведення конфігураційних налаштувань виконайте `./configure --help`.

## ВСТАНОВЛЕННЯ

Після того як Wine буде успішно зібрано, виконайте `make install`; це
встановить виконувані файли Wine та бібліотеки, керівництво Wine та
інші необхідні файли.

Спочатку не забудьте видалити будь-які конфліктуючі раніше встановлені
версії Wine. Спробуйте `dpkg -r wine` або `rpm -e wine` чи `make uninstall`
перед встановленням.

Після встановлення запустіть конфігураційну програму `winecfg`. Відвідайте Службу
підтримки на https://www.winehq.org/, якщо виникнуть питання щодо конфігурування.


## ЗАПУСК ПРОГРАМ

Для виклику Wine ви можете вказати повний шлях до виконуваного файлу,
або лише ім'я файлу.

Наприклад: щоб запустити Блокнот(Notepad):

```
wine notepad            (використавши шлях пошуку файлу,
wine notepad.exe         збережений в реєстрі)

wine c:\\windows\\notepad.exe      (використавши синтаксис DOS)

wine ~/.wine/drive_c/windows/notepad.exe  (використавши синтаксис Unix)

wine notepad.exe readme.txt          (виклик програми з параметрами)
```

Wine знаходиться в процесі розробки, тому деякі програми можуть не
працювати. Якщо станеться помилка, ви отримаєте лог збою, який
треба прикріпити до звіту про помилку при його заповненні.


## ОТРИМАННЯ ДОДАТКОВОЇ ІНФОРМАЦІЇ

- **WWW**: Багато інформації про Wine є в WineHQ на
        https://www.winehq.org/: різні керівництва Wine, база даних додатків,
        база даних помилок. Ймовірно найкраще почати з цього сайту.

- **FAQ** Wine FAQ розташований на https://gitlab.winehq.org/wine/wine/-/wikis/FAQ

- **Wiki** Wine Wiki розташована на https://gitlab.winehq.org/wine/wine/-/wikis/

- **Gitlab**: https://gitlab.winehq.org

- **Списки розсилання**:
	Є кілька розсилок для користувачів і розробників Wine;
        дивіться https://gitlab.winehq.org/wine/wine/-/wikis/Forums
	    для додаткової інформації.

- **Помилки(баги)**:
	Повідомляйте про помилки у Wine Bugzilla на https://bugs.winehq.org
	Перш ніж відправляти повідомлення про помилку перевірте в базі, чи
	ця помилка вже виявлена.

- **IRC**: Онлайн допомога доступна на каналі `#WineHQ` на irc.libera.chat.
