/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Defines memory manager interface 
 */


#ifndef CM_MM_H
#define CM_MM_H


/* Memory pool attributes bit masks*/
#define POOL_ATTR_SUB_POOL     0x0001
#define K_BYTE		       0
#define BYTE		       1


typedef struct _mp                 /* manages a single memory pool */
{
   struct _mp *        next;           /* next in linked list */
   us16                attributes;     /* attributes for this pool */
   us8 *               memory;         /* start of available memory */
   us32                size;           /* initial created size */
   us32                still_avail;    /* amount of memory still available */
   us8 *               next_free;      /* address of next free memory */
   us32                reserved;       /* used for internal purposes */
} memory_pool_t;

typedef handle_t       mph_t;    /* take-off from generic 32-bit handle */


#ifdef CM_MM_C
#define EXTRN                    /* not global if included in code module */
#else
#define EXTRN extern             /* global if not included in code module */
#endif /* CM_MM_C */


EXTRN us8 *        mm_malloc (mph_t h, us32 size);
 
EXTRN us16         mm_init (void);
EXTRN us16         mm_exit (void);
EXTRN us16         mm_get_pool (mph_t * h, us32 size);
EXTRN us16         mm_get_subpool (mph_t h, mph_t * sph, us32 size,us8 size_type);
EXTRN us16         mm_rtn_pool (mph_t h);
EXTRN us16         mm_clr_pool (mph_t h, flag_yn zero_out_memory);
EXTRN us16         mm_query_pool (mph_t h, us32 * memory_avail);
                                  
#ifdef DBG
EXTRN us16         mm_inquire (void);
EXTRN us16         mm_inquire_pool (mph_t h);
#endif /* DBG */      


#undef EXTRN
#endif /* CM_MM_H */


