/*
 * Internal instance ids are constructed from the
 * lockstat directory ordinal index (of each
 * lock:caller), and the cpu number. These are the
 * keys used to index the hash table for lock:caller:cpu
 * instance domain.
 */
#define PCP_LOCKSTAT_HASHKEY(dir, cpu) (((dir) << 16) | ((cpu) & 0xffff))

/*
 * hash table index entry
 */
typedef struct {
    int dir;		/* directory index for lock:caller */
    int cpu;		/* cpu number */
    char *lockname;	/* saved string from XlateAddressToSymbol() */
    char *callername;	/* saved string from XlateAddressToSymbol() */
} lockstat_inst_entry_t;

/*
 * hash table for the lock:caller:cpu instance domain
 */
extern __pmHashCtl pcp_lockstat_hash;

/*
 * externs from liblockstat
 */
extern int openKernelData(char *);
extern void setCollectionState(int);

extern void getKernelData(
        lstat_user_request_t **,
        lstat_cpu_counts_t **,
        lstat_directory_entry_t **,
        lstat_read_lock_cpu_counts_t **,
        int);

extern void openMapFile(char *);
extern void XlateAddressToSymbol(void *, char *buf);

extern int opt_debug;
