// **********************************************************************
// * IBMASM HEADER FILE                                                 *
// *                                                                    *
// * Written by Matthew DeLoera (deloera@us.ibm.com)                    *
// * (C) Copyright IBM Corporation, 1998-2001                           *
// *                                                                    *
// *  This software may be used and distributed according to the terms  *
// *  of the GNU Public License, incorporated herein by reference.      *
// **********************************************************************

#ifndef __SYSPLX_H_
#define __SYSPLX_H_



//------------------------------------------------------------------------
//              PLX 9080 PCI CONFIG REGISTER OFFSETS
//------------------------------------------------------------------------
#define PCI9080_RTR_BASE            0x010
#define PCI9080_RTR_IO_BASE         0x014
#define PCI9080_LOCAL_BASE_ADDR0    0x018
#define PCI9080_LOCAL_BASE_ADDR1    0x01C
#define PCI9080_LOCAL_BASE_ADDR2    0x020
#define PCI9080_LOCAL_BASE_ADDR3    0x024

//------------------------------------------------------------------------
//              PLX 9080 REGISTER ADDRESSES                             
//------------------------------------------------------------------------
#define PCI9080_MAILBOX1            0x044
#define PCI9080_MAILBOX5            0x054
#define PCI9080_LOCAL_DOORBELL      0x060
#define PCI9080_PCI_DOORBELL        0x064
#define PCI9080_INT_CONTROL_STATUS  0x068

#define PLX_INTR_OUTPUT_ENABLE      0x00000100L
#define PLX_DOORBELL_INTR_ENABLE    0x00000200L
#define PLX_LOCAL_INTR_ENABLE       0x00000800L
#define PLX_DOORBELL_INTR_ACTIVE    0x00002000L
#define PLX_LOCAL_INTR_ACTIVE       0x00008000L


#ifdef SYS_NETWARE

#define WRITE_PORT_ULONG(x,y) _inline_outpd(x,y)
#define WRITE_PORT_UCHAR(x,y) _inline_outp(x,y)

#define READ_PORT_ULONG(y)    _inline_inpd((int)y)
#define READ_PORT_UCHAR(y)    _inline_inp((int)y)

#endif


#ifdef SCO_UNIXWARE7

#define WRITE_PORT_ULONG(x,y) outl((int)x,(ulong_t)y)
#define WRITE_PORT_UCHAR(x,y) outb((int)x,(uchar_t)y)

#define READ_PORT_ULONG(y)    inl((int)y)
#define READ_PORT_UCHAR(y)    inb((int)y)

#endif


#ifdef __IBMLINUX__

#define WRITE_PORT_ULONG(x,y) outl((unsigned int)y,(unsigned)x)
#define WRITE_PORT_UCHAR(x,y) outb((unsigned char)y,(unsigned)x)

#define READ_PORT_ULONG(y)    inl((int)y)
#define READ_PORT_UCHAR(y)    inb((int)y)

#endif


#define SP_INTERRUPTS  (PLX_INTR_OUTPUT_ENABLE | PLX_DOORBELL_INTR_ENABLE)
#define COM_INTERRUPTS (PLX_INTR_OUTPUT_ENABLE | PLX_LOCAL_INTR_ENABLE)

#define ENABLE_ALL_SP_INTERRUPTS(pPLX)           \
   WRITE_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS),                     \
                     READ_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS) ) | \
                     SP_INTERRUPTS)

#define DISABLE_ALL_SP_INTERRUPTS(pPLX, iTemp)   \
   WRITE_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS),                      \
                     (iTemp = READ_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS) )) &  \
                     ~(SP_INTERRUPTS) )

#define DISABLE_SP_INTERRUPT(pPLX)               \
   WRITE_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS),                      \
                     (READ_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS) )) &  \
                     ~(PLX_DOORBELL_INTR_ENABLE) )

#define RESTORE_SP_INTERRUPTS(pPLX, iTemp)       \
   WRITE_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS),                      \
                     READ_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS) ) |  \
                     (iTemp & SP_INTERRUPTS) )

#define ENABLE_ALL_COM_INTERRUPTS(pPLX)          \
   WRITE_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS),                     \
                     READ_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS) ) | \
                     COM_INTERRUPTS)

#define DISABLE_ALL_COM_INTERRUPTS(pPLX, iTemp)  \
   WRITE_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS),                      \
                     (iTemp = READ_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS) )) &  \
                     ~(COM_INTERRUPTS) )

#define DISABLE_COM_INTERRUPT(pPLX)              \
   WRITE_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS),                      \
                     (READ_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS) )) &  \
                     ~(PLX_LOCAL_INTR_ENABLE) )

#define RESTORE_COM_INTERRUPTS(pPLX, iTemp)      \
   WRITE_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS),                      \
                     READ_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS) ) |  \
                     (iTemp & COM_INTERRUPTS) )

#define ENABLE_PCI_INTERRUPT(pPLX)               \
   WRITE_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS),                     \
                     READ_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS) ) | \
                     PLX_INTR_OUTPUT_ENABLE )

#define DISABLE_PCI_INTERRUPT(pPLX)              \
   WRITE_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS),                      \
                     READ_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS) ) &  \
                     ~PLX_INTR_OUTPUT_ENABLE )

#define READ_RECEIVE_MAILBOX(pPLX)               \
   READ_PORT_ULONG( (PULONG)(pPLX + PCI9080_MAILBOX1) )

#define READ_SEND_MAILBOX(pPLX)                  \
   READ_PORT_ULONG( (PULONG)(pPLX + PCI9080_MAILBOX5) )

#define READ_PCI_DOORBELL(pPLX)                  \
   READ_PORT_UCHAR( (PUCHAR)(pPLX + PCI9080_PCI_DOORBELL) )

#define READ_LOCAL_DOORBELL(pPLX)                \
   READ_PORT_UCHAR( (PUCHAR)(pPLX + PCI9080_LOCAL_DOORBELL) )

#define READ_INT_STATUS(pPLX)                    \
   READ_PORT_ULONG( (PULONG)(pPLX + PCI9080_INT_CONTROL_STATUS) )


#define WRITE_RECEIVE_MAILBOX(pPLX, addr)        \
   WRITE_PORT_ULONG( (PULONG)(pPLX + PCI9080_MAILBOX1), addr )

#define WRITE_SEND_MAILBOX(pPLX, addr)           \
   WRITE_PORT_ULONG( (PULONG)(pPLX + PCI9080_MAILBOX5), addr )

#define WRITE_PCI_DOORBELL(pPLX, iByte)          \
   WRITE_PORT_UCHAR( (PUCHAR)(pPLX + PCI9080_PCI_DOORBELL), iByte )

#define WRITE_LOCAL_DOORBELL(pPLX, iByte)        \
   WRITE_PORT_UCHAR( (PUCHAR)(pPLX + PCI9080_LOCAL_DOORBELL), iByte )

#define RESET_PCI_DOORBELL(pPLX)                 \
   WRITE_PCI_DOORBELL(pPLX, 0x01)

#define SET_LOCAL_DOORBELL(pPLX)                 \
   WRITE_LOCAL_DOORBELL(pPLX, 0x01)


#define GET_MFA_ADDR(x) (x & 0xFFFFFF00)

#define MBX_FULL(x)  (x & 0x00000001)
#define MBX_EMPTY(x) (!(MBX_FULL(x)))


#define PLX9080_VENDORID       0x1014 // IBM==0x1014 
#define PLX9080_DEVICEID       0x00DC // Wiseman


// --------------------------------------------------------------------
// PLX Register Access
// --------------------------------------------------------------------
typedef struct _plx9080Registers {
                           // Register offsets
   ULONG   reserved1[16];  // 0x00 - 0x3F
   ULONG   mailbox0;       // 0x40
   ULONG   mailbox1;       // 0x44
   ULONG   mailbox2;       // 0x48
   ULONG   mailbox3;       // 0x4C
   ULONG   mailbox4;       // 0x50
   ULONG   mailbox5;       // 0x54
   ULONG   mailbox6;       // 0x58
   ULONG   mailbox7;       // 0x5C
   ULONG   localDoorBell;  // 0x60
   ULONG   PCIDoorBell;    // 0x64
   ULONG   interruptCS;    // 0x68
   ULONG   reserved2[37];  // 0x6C - 0xFF
} plxRegisters;


// --------------------------------------------------------------------
// I2O Message typedefs
// --------------------------------------------------------------------
#define I2O_MESSAGE_SIZE            0x1000    //4K bytes per MFB buffer

#define I2O_HOST_DD_ADDR            0x00
#define I2O_HOST_AND_TARGET_ADDR    0x40
#define I2O_TARGET_ADDR             0x00
#define I2O_MSG_VERSION             0x01
 
typedef struct _I2O_MESSAGE_HEADER
{
  //DWORD 0 without endian swap (WISEMAN)
  UCHAR  ver_offset;
  UCHAR  msg_flags;
  USHORT msg_size;

  //DWORD 1 without endian swap (WISEMAN)
  UCHAR  target_addr;           
  UCHAR  initAndtgt_addr; // This byte is shared by both addrs
  UCHAR  initiator_addr;        
  UCHAR  function;

  //DWORD 2 without endian swap (WISEMAN)
  ULONG  initiator_context;

}I2O_MESSAGE_HEADER, *PI2O_MESSAGE_HEADER;


typedef struct _I2O_MESSAGE_FRAME
{
  I2O_MESSAGE_HEADER I2OMessageHeader;

  //I2O_MESSAGE_SIZE minus the header structure above
  UCHAR cmd[ I2O_MESSAGE_SIZE - sizeof(I2O_MESSAGE_HEADER) ];

}I2O_MESSAGE_FRAME, *PI2O_MESSAGE_FRAME;


#ifdef __IBMLINUX__
     // DEFINES for PCI Configuration register offsets
     #define VENDORID_OFFSET        0x0
     #define DEVICEID_OFFSET        0x02
     #define COMMAND_OFFSET         0x04
     #define STATUS_OFFSET          0x06
     #define REVISIONID_OFFSET      0x08
     #define PROGIF_OFFSET          0x09
     #define SUBCLASS_OFFSET        0x0
     #define BASECLASS_OFFSET       0x0
     #define CACHELINESIZE_OFFSET   0x0
     #define LATENCYTIMER_OFFSET    0x0
     #define HEADERTYPE_OFFSET      0x0
     #define BIST_OFFSET            0x0
     #define BASEADDR0_OFFSET       0x10
     #define BASEADDR1_OFFSET       0x14
     #define BASEADDR2_OFFSET       0x18
     #define BASEADDR3_OFFSET       0x1C
     #define BASEADDR4_OFFSET       0x20
     #define BASEADDR5_OFFSET       0x24
     #define CIS_OFFSET             0x28
     #define SUBVENDORID_OFFSET     0x30
     #define SUBSYSTEMID_OFFSET     0x32
     #define ROMBASEADDR_OFFSET     0x34
     #define INTLINE_OFFSET         0x3C
     #define INTPIN_OFFSET          0x3D
     #define MINGRANT_OFFSET        0x3E
     #define MAXLATENCY_OFFSET      0x3F
     #define DEVICESPECIFIC_OFFSET  0x40
#endif


#endif

