/******************************************************************************
 *
 * Name:	skgipnmi.h
 * Project:	SysKonnect SK-9Dxx Gigabit Ethernet
 * Version:	$Revision: 1.2 $
 * Date:	$Date: 2001/08/14 14:33:17 $
 * Purpose:	Defines for Private Network Management Interface
 *
 ******************************************************************************/

/******************************************************************************
 *
 *	(C)Copyright 2001 SysKonnect GmbH.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	The information in this file is provided "AS IS" without warranty.
 *
 ******************************************************************************/

/******************************************************************************
 *
 * History:
 *
 *	$Log: skgipnmi.h,v $
 *	Revision 1.2  2001/08/14 14:33:17  rschmidt
 *	Added line speed info and counter for Rx errors.
 *	
 *	Revision 1.1  2001/06/05 08:28:25  rassmann
 *	First public version.
 *	
 *
 ******************************************************************************/

/******************************************************************************
 *
 * Description:
 *
 ******************************************************************************/

#ifndef _SKGIPNMI_H_
#define _SKGIPNMI_H_

/*
 * Include dependencies
 */
#include "h/sktypes.h"

/*
 * Management Database Version
 */
#define SK_PNMI_MDB_VERSION			0x00040000	/* 4.0 */

#define SK_PNMI_MAC_ENTRIES			2


/*
 * Event definitions
 */
// #define SK_PNMI_EVT_SIRQ_OVERFLOW		1	/* Counter overflow */
// #define SK_PNMI_EVT_SEN_WAR_LOW			2	/* Lower war thres exceeded */
// #define SK_PNMI_EVT_SEN_WAR_UPP			3	/* Upper war thres exceeded */
// #define SK_PNMI_EVT_SEN_ERR_LOW			4	/* Lower err thres exceeded */
// #define SK_PNMI_EVT_SEN_ERR_UPP			5	/* Upper err thres exceeded */
// #define SK_PNMI_EVT_CHG_EST_TIMER		6	/* Timer event for RLMT Chg */
// #define SK_PNMI_EVT_UTILIZATION_TIMER	7	/* Timer event for Utiliza. */
// #define SK_PNMI_EVT_CLEAR_COUNTER		8	/* Clear statistic counters */
#define SK_PNMI_EVT_MAC_RESET			9	/* MAC will be reset */

#define SK_PNMI_EVT_RLMT_PORT_UP		10	/* Port came logically up */
#define SK_PNMI_EVT_RLMT_PORT_DOWN		11	/* Port went logically down */


/*
 * Return values
 */
#define SK_PNMI_ERR_OK				0
#define SK_PNMI_ERR_GENERAL			1
#define SK_PNMI_ERR_TOO_SHORT		2
#define SK_PNMI_ERR_BAD_VALUE		3
#define SK_PNMI_ERR_READ_ONLY		4
#define SK_PNMI_ERR_UNKNOWN_OID		5
#define SK_PNMI_ERR_UNKNOWN_INST	6
#define SK_PNMI_ERR_UNKNOWN_NET 	7

/*
 * OID definition
 */
#ifndef _NDIS_	/* Check, whether NDIS already included OIDs */

#define OID_GEN_XMIT_OK				0x00020101
#define OID_GEN_RCV_OK				0x00020102
#define OID_GEN_XMIT_ERROR			0x00020103
#define OID_GEN_RCV_ERROR			0x00020104
#define OID_GEN_RCV_NO_BUFFER		0x00020105

/* #define OID_GEN_DIRECTED_BYTES_XMIT	0x00020201 */
#define OID_GEN_DIRECTED_FRAMES_XMIT	0x00020202
/* #define OID_GEN_MULTICAST_BYTES_XMIT	0x00020203 */
#define OID_GEN_MULTICAST_FRAMES_XMIT	0x00020204
/* #define OID_GEN_BROADCAST_BYTES_XMIT	0x00020205 */
#define OID_GEN_BROADCAST_FRAMES_XMIT	0x00020206
/* #define OID_GEN_DIRECTED_BYTES_RCV	0x00020207 */
#define OID_GEN_DIRECTED_FRAMES_RCV		0x00020208
/* #define OID_GEN_MULTICAST_BYTES_RCV	0x00020209 */
#define OID_GEN_MULTICAST_FRAMES_RCV	0x0002020A
/* #define OID_GEN_BROADCAST_BYTES_RCV	0x0002020B */
#define OID_GEN_BROADCAST_FRAMES_RCV	0x0002020C
#define OID_GEN_RCV_CRC_ERROR			0x0002020D
#define OID_GEN_TRANSMIT_QUEUE_LENGTH	0x0002020E

#define OID_802_3_PERMANENT_ADDRESS		0x01010101
#define OID_802_3_CURRENT_ADDRESS		0x01010102
/* #define OID_802_3_MULTICAST_LIST		0x01010103 */
/* #define OID_802_3_MAXIMUM_LIST_SIZE	0x01010104 */
/* #define OID_802_3_MAC_OPTIONS		0x01010105 */
			
#define OID_802_3_RCV_ERROR_ALIGNMENT	0x01020101
#define OID_802_3_XMIT_ONE_COLLISION	0x01020102
#define OID_802_3_XMIT_MORE_COLLISIONS	0x01020103
#define OID_802_3_XMIT_DEFERRED			0x01020201
#define OID_802_3_XMIT_MAX_COLLISIONS	0x01020202
#define OID_802_3_RCV_OVERRUN			0x01020203
#define OID_802_3_XMIT_UNDERRUN			0x01020204
#define OID_802_3_XMIT_TIMES_CRS_LOST	0x01020206
#define OID_802_3_XMIT_LATE_COLLISIONS	0x01020207

#endif /* _NDIS_ */

#define OID_SKGE_MDB_VERSION			0xFF010100
#define OID_SKGE_SUPPORTED_LIST			0xFF010101
#define OID_SKGE_VPD_FREE_BYTES			0xFF010102
#define OID_SKGE_VPD_ENTRIES_LIST		0xFF010103
#define OID_SKGE_VPD_ENTRIES_NUMBER		0xFF010104
#define OID_SKGE_VPD_KEY				0xFF010105
#define OID_SKGE_VPD_VALUE				0xFF010106
#define OID_SKGE_VPD_ACCESS				0xFF010107
#define OID_SKGE_VPD_ACTION				0xFF010108
			
#define OID_SKGE_PORT_NUMBER			0xFF010110
#define OID_SKGE_DEVICE_TYPE			0xFF010111
#define OID_SKGE_DRIVER_DESCR			0xFF010112
#define OID_SKGE_DRIVER_VERSION			0xFF010113
#define OID_SKGE_HW_DESCR				0xFF010114
#define OID_SKGE_HW_VERSION				0xFF010115
#define OID_SKGE_CHIPSET				0xFF010116
#define OID_SKGE_ACTION					0xFF010117
#define OID_SKGE_RESULT					0xFF010118
#define OID_SKGE_BUS_TYPE				0xFF010119
#define OID_SKGE_BUS_SPEED				0xFF01011A
#define OID_SKGE_BUS_WIDTH				0xFF01011B
#define OID_SKGE_LINK_SPEED				0xFF01011C

/*#define OID_SKGE_MULTICAST_LIST		0xFF01011C*/

#define OID_SKGE_SENSOR_NUMBER			0xFF020100			
#define OID_SKGE_SENSOR_INDEX			0xFF020101
#define OID_SKGE_SENSOR_DESCR			0xFF020102
#define OID_SKGE_SENSOR_TYPE			0xFF020103
#define OID_SKGE_SENSOR_VALUE			0xFF020104
#define OID_SKGE_SENSOR_WAR_THRES_LOW	0xFF020105
#define OID_SKGE_SENSOR_WAR_THRES_UPP	0xFF020106
#define OID_SKGE_SENSOR_ERR_THRES_LOW	0xFF020107
#define OID_SKGE_SENSOR_ERR_THRES_UPP	0xFF020108
#define OID_SKGE_SENSOR_STATUS			0xFF020109
#define OID_SKGE_SENSOR_WAR_CTS			0xFF02010A
#define OID_SKGE_SENSOR_ERR_CTS			0xFF02010B
#define OID_SKGE_SENSOR_WAR_TIME		0xFF02010C
#define OID_SKGE_SENSOR_ERR_TIME		0xFF02010D

#define OID_SKGE_CHKSM_NUMBER			0xFF020110
#define OID_SKGE_CHKSM_RX_OK_CTS		0xFF020111
#define OID_SKGE_CHKSM_RX_UNABLE_CTS	0xFF020112
#define OID_SKGE_CHKSM_RX_ERR_CTS		0xFF020113
#define OID_SKGE_CHKSM_TX_OK_CTS		0xFF020114
#define OID_SKGE_CHKSM_TX_UNABLE_CTS	0xFF020115

#define OID_SKGE_STAT_TX				0xFF020120
#define OID_SKGE_STAT_TX_OCTETS			0xFF020121
#define OID_SKGE_STAT_TX_BROADCAST		0xFF020122
#define OID_SKGE_STAT_TX_MULTICAST		0xFF020123
#define OID_SKGE_STAT_TX_UNICAST		0xFF020124
#define OID_SKGE_STAT_TX_LONGFRAMES		0xFF020125
#define OID_SKGE_STAT_TX_BURST			0xFF020126
#define OID_SKGE_STAT_TX_PFLOWC			0xFF020127
#define OID_SKGE_STAT_TX_FLOWC			0xFF020128
#define OID_SKGE_STAT_TX_SINGLE_COL		0xFF020129
#define OID_SKGE_STAT_TX_MULTI_COL		0xFF02012A
#define OID_SKGE_STAT_TX_EXCESS_COL		0xFF02012B
#define OID_SKGE_STAT_TX_LATE_COL		0xFF02012C
#define OID_SKGE_STAT_TX_DEFFERAL		0xFF02012D
#define OID_SKGE_STAT_TX_EXCESS_DEF		0xFF02012E
#define OID_SKGE_STAT_TX_UNDERRUN		0xFF02012F
#define OID_SKGE_STAT_TX_CARRIER		0xFF020130
/* #define OID_SKGE_STAT_TX_UTIL		0xFF020131 */
#define OID_SKGE_STAT_TX_64				0xFF020132
#define OID_SKGE_STAT_TX_127			0xFF020133
#define OID_SKGE_STAT_TX_255			0xFF020134
#define OID_SKGE_STAT_TX_511			0xFF020135
#define OID_SKGE_STAT_TX_1023			0xFF020136
#define OID_SKGE_STAT_TX_MAX			0xFF020137
#define OID_SKGE_STAT_TX_SYNC			0xFF020138
#define OID_SKGE_STAT_TX_SYNC_OCTETS	0xFF020139
#define OID_SKGE_STAT_RX				0xFF02013A
#define OID_SKGE_STAT_RX_OCTETS			0xFF02013B
#define OID_SKGE_STAT_RX_BROADCAST		0xFF02013C
#define OID_SKGE_STAT_RX_MULTICAST		0xFF02013D
#define OID_SKGE_STAT_RX_UNICAST		0xFF02013E
#define OID_SKGE_STAT_RX_PFLOWC			0xFF02013F
#define OID_SKGE_STAT_RX_FLOWC			0xFF020140
#define OID_SKGE_STAT_RX_PFLOWC_ERR		0xFF020141
#define OID_SKGE_STAT_RX_FLOWC_UNKWN	0xFF020142
#define OID_SKGE_STAT_RX_BURST			0xFF020143
#define OID_SKGE_STAT_RX_MISSED			0xFF020144
#define OID_SKGE_STAT_RX_FRAMING		0xFF020145
#define OID_SKGE_STAT_RX_OVERFLOW		0xFF020146
#define OID_SKGE_STAT_RX_JABBER			0xFF020147
#define OID_SKGE_STAT_RX_CARRIER		0xFF020148
#define OID_SKGE_STAT_RX_IR_LENGTH		0xFF020149
#define OID_SKGE_STAT_RX_SYMBOL			0xFF02014A
#define OID_SKGE_STAT_RX_SHORTS			0xFF02014B
#define OID_SKGE_STAT_RX_RUNT			0xFF02014C
#define OID_SKGE_STAT_RX_CEXT			0xFF02014D
#define OID_SKGE_STAT_RX_TOO_LONG		0xFF02014E
#define OID_SKGE_STAT_RX_FCS			0xFF02014F
/* #define OID_SKGE_STAT_RX_UTIL		0xFF020150 */
#define OID_SKGE_STAT_RX_64				0xFF020151
#define OID_SKGE_STAT_RX_127			0xFF020152
#define OID_SKGE_STAT_RX_255			0xFF020153
#define OID_SKGE_STAT_RX_511			0xFF020154
#define OID_SKGE_STAT_RX_1023			0xFF020155
#define OID_SKGE_STAT_RX_MAX			0xFF020156
#define OID_SKGE_STAT_RX_LONGFRAMES		0xFF020157
#define OID_SKGE_STAT_RX_FRAGMENTS		0xFF020158

#define OID_SKGE_DIAG_ACTION			0xFF01011D
#define OID_SKGE_DIAG_RESULT			0xFF01011E
#define OID_SKGE_MTU					0xFF01011F
#define OID_SKGE_PHYS_CUR_ADDR			0xFF010120
#define OID_SKGE_PHYS_FAC_ADDR			0xFF010121
#define OID_SKGE_PMD					0xFF010122
#define OID_SKGE_CONNECTOR				0xFF010123
#define OID_SKGE_LINK_CAP				0xFF010124
#define OID_SKGE_LINK_MODE				0xFF010125
#define OID_SKGE_LINK_MODE_STATUS		0xFF010126
#define OID_SKGE_LINK_STATUS			0xFF010127
#define OID_SKGE_FLOWCTRL_CAP			0xFF010128
#define OID_SKGE_FLOWCTRL_MODE			0xFF010129
#define OID_SKGE_FLOWCTRL_STATUS		0xFF01012A
#define OID_SKGE_PHY_OPERATION_CAP		0xFF01012B
#define OID_SKGE_PHY_OPERATION_MODE		0xFF01012C
#define OID_SKGE_PHY_OPERATION_STATUS	0xFF01012D
#define OID_SKGE_MULTICAST_LIST			0xFF01012E
#define OID_SKGE_CURRENT_PACKET_FILTER	0xFF01012F

#define OID_SKGE_TRAP					0xFF010130
#define OID_SKGE_TRAP_NUMBER			0xFF010131

#define OID_SKGE_RLMT_MODE				0xFF010140
#define OID_SKGE_RLMT_PORT_NUMBER		0xFF010141
#define OID_SKGE_RLMT_PORT_ACTIVE		0xFF010142
#define OID_SKGE_RLMT_PORT_PREFERRED	0xFF010143
#define OID_SKGE_INTERMEDIATE_SUPPORT	0xFF010160
#define OID_SKGE_RLMT_CHANGE_CTS		0xFF020160
#define OID_SKGE_RLMT_CHANGE_TIME		0xFF020161
#define OID_SKGE_RLMT_CHANGE_ESTIM		0xFF020162
#define OID_SKGE_RLMT_CHANGE_THRES		0xFF020163

#define OID_SKGE_RLMT_PORT_INDEX		0xFF020164
#define OID_SKGE_RLMT_STATUS			0xFF020165
#define OID_SKGE_RLMT_TX_HELLO_CTS		0xFF020166
#define OID_SKGE_RLMT_RX_HELLO_CTS		0xFF020167
#define OID_SKGE_RLMT_TX_SP_REQ_CTS		0xFF020168
#define OID_SKGE_RLMT_RX_SP_CTS			0xFF020169

#define OID_SKGE_RLMT_MONITOR_NUMBER	0xFF010150
#define OID_SKGE_RLMT_MONITOR_INDEX		0xFF010151
#define OID_SKGE_RLMT_MONITOR_ADDR		0xFF010152
#define OID_SKGE_RLMT_MONITOR_ERRS		0xFF010153
#define OID_SKGE_RLMT_MONITOR_TIMESTAMP	0xFF010154
#define OID_SKGE_RLMT_MONITOR_ADMIN		0xFF010155

#define OID_SKGE_TX_SW_QUEUE_LEN		0xFF020170
#define OID_SKGE_TX_SW_QUEUE_MAX		0xFF020171
#define OID_SKGE_TX_RETRY				0xFF020172
#define OID_SKGE_RX_INTR_CTS			0xFF020173
#define OID_SKGE_TX_INTR_CTS			0xFF020174
#define OID_SKGE_RX_NO_BUF_CTS			0xFF020175
#define OID_SKGE_TX_NO_BUF_CTS			0xFF020176
#define OID_SKGE_TX_USED_DESCR_NO		0xFF020177
#define OID_SKGE_RX_DELIVERED_CTS		0xFF020178
#define OID_SKGE_RX_OCTETS_DELIV_CTS	0xFF020179
#define OID_SKGE_RX_HW_ERROR_CTS		0xFF02017A
#define OID_SKGE_TX_HW_ERROR_CTS		0xFF02017B
#define OID_SKGE_IN_ERRORS_CTS			0xFF02017C
#define OID_SKGE_OUT_ERROR_CTS			0xFF02017D
#define OID_SKGE_ERR_RECOVERY_CTS		0xFF02017E
#define OID_SKGE_SYSUPTIME				0xFF02017F

#define OID_SKGE_ALL_DATA				0xFF020190
/*
 * Structure definition for SkPnmiGetStruct and SkPnmiSetStruct
 */
#define SK_PNMI_STRINGLEN1		80
#define SK_PNMI_STRINGLEN2		25


/*
 * Management counter macros called by the driver
 */
#define SK_PNMI_SET_DRIVER_DESCR(pAC,v)	\
	((pAC)->Pnmi.pDriverDescription = (char *)(v))

#define SK_PNMI_SET_DRIVER_VER(pAC,v)	\
	((pAC)->Pnmi.pDriverVersion = (char *)(v))


#define SK_PNMI_CNT_TX_QUEUE_LEN(pAC,v) { 						\
	(pAC)->Pnmi.TxSwQueueLen = (SK_U64)(v); 					\
	if ((pAC)->Pnmi.TxSwQueueLen > (pAC)->Pnmi.TxSwQueueMax) {	\
		(pAC)->Pnmi.TxSwQueueMax = (pAC)->Pnmi.TxSwQueueLen;	\
	} \
}
#define SK_PNMI_CNT_TX_RETRY(pAC)	(((pAC)->Pnmi.TxRetryCts)++)
#define SK_PNMI_CNT_RX_INTR(pAC)	(((pAC)->Pnmi.RxIntrCts)++)
#define SK_PNMI_CNT_TX_INTR(pAC)	(((pAC)->Pnmi.TxIntrCts)++)
#define SK_PNMI_CNT_NO_RX_BUF(pAC)	(((pAC)->Pnmi.RxNoBufCts)++)
#define SK_PNMI_CNT_NO_TX_BUF(pAC)	(((pAC)->Pnmi.TxNoBufCts)++)
#define SK_PNMI_CNT_USED_TX_DESCR(pAC,v)((pAC)->Pnmi.TxUsedDescrNo=(SK_U64)(v));
#define SK_PNMI_CNT_RX_OCTETS_DELIVERED(pAC,v) {		\
	((pAC)->Pnmi.RxDeliveredCts)++; 					\
	(pAC)->Pnmi.RxOctetsDeliveredCts += (SK_U64)(v);	\
}
#define SK_PNMI_CNT_ERR_RECOVERY(pAC)	(((pAC)->Pnmi.ErrRecoveryCts)++);


#define SK_PNMI_CNT_RX_LONGFRAMES(pAC) {	\
	((pAC)->Pnmi.StatRxLongFrameCts)++;		\
}

typedef struct s_PnmiStat {
    SK_U64		COSIfHCOutPkts;
    SK_U64		ifHCOutOctets;
    SK_U64		ifHCOutBroadcastPkts;
    SK_U64		ifHCOutMulticastPkts;
    SK_U64		ifHCOutUcastPkts;
    SK_U64		dot3StatsSingleCollisionFrames;
    SK_U64		dot3StatsMultipleCollisionFrames;
    SK_U64		dot3StatsDeferredTransmissions;
    SK_U64		dot3StatsExcessiveCollisions;
    SK_U64		dot3StatsLateCollisions;
    SK_U64		dot3StatsInternalMacTransmitErrors;
    SK_U64		dot3StatsCarrierSenseErrors;
	SK_U64		ifOutDiscards;
	SK_U64		ifOutErrors;

    SK_U64		COSIfHCInPkts;
 	SK_U64		ifHCInOctets;
    SK_U64		ifHCInBroadcastPkts;
    SK_U64		ifHCInMulticastPkts;
    SK_U64		ifHCInUcastPkts;
    SK_U64		dot3StatsAlignmentErrors;
    SK_U64		nicNoMoreRxBDs;
    SK_U64		ifInDiscards;
    SK_U64		ifInErrors;
    SK_U64		etherStatsJabbers;
    SK_U64		etherStatsUndersizePkts;
    SK_U64		dot3StatsFramesTooLong;
    SK_U64		etherStatsFragments;
    SK_U64		dot3StatsFCSErrors;
    SK_U64		etherStatsPkts64Octets;
    SK_U64		etherStatsPkts65Octetsto127Octets;
    SK_U64		etherStatsPkts128Octetsto255Octets;
    SK_U64		etherStatsPkts256Octetsto511Octets;
    SK_U64		etherStatsPkts512Octetsto1023Octets;
    SK_U64		etherStatsPkts1024Octetsto9022Octets;
} SK_PNMI_STAT;


typedef struct s_PnmiData {
	char		HwVersion[10];
	char		*pDriverDescription;
	char		*pDriverVersion;
	char		PciBusSpeed;
	char		PciBusWidth;
	char		PciBusType;
	char		PMD;
	char		Connector;
	SK_U16		EthLinkSpeed;
	SK_U16		DeviceType;
	SK_U64		StartUpTime;

	/* Rx counters */
    SK_U64		RxPacketGoodCnt;
    SK_U64		RxBytesGoodCnt;
    SK_U64		RxPacketErrCnt;
    SK_U64		RxErrCrcCnt;
    SK_U64		RxErrCollCnt;
    SK_U64		RxErrLinkLostCnt;
    SK_U64		RxErrPhyDecodeCnt;
    SK_U64		RxErrOddNibbleCnt;
    SK_U64		RxErrMacAbortCnt;
    SK_U64		RxErrShortPacketCnt;
    SK_U64		RxErrNoResourceCnt;
    SK_U64		RxErrLargePacketCnt;

	/* Tx counters */
    SK_U64		TxPacketGoodCnt;
    SK_U64		TxBytesGoodCnt;
    SK_U64		TxPacketAbortedCnt;
    SK_U64		NoSendBdLeftCnt;
    SK_U64		NoMapRegisterLeftCnt;
    SK_U64		TooManyFragmentsCnt;
    SK_U64		NoTxPacketDescCnt;

	SK_U64		TxRetryCts;
	SK_U64		RxIntrCts;
	SK_U64		TxIntrCts;
	SK_U64		RxNoBufCts;
	SK_U64		TxNoBufCts;
	SK_U64		TxUsedDescrNo;
	SK_U64		RxDeliveredCts;
	SK_U64		RxOctetsDeliveredCts;
	SK_U64		RxHwErrorsCts;
	SK_U64		TxHwErrorsCts;
	SK_U64		InErrorsCts;
	SK_U64		OutErrorsCts;
	SK_U64		ErrRecoveryCts;
} SK_PNMI;

typedef struct s_PnmiRequestStatus {
	SK_U32		ErrorStatus;
	SK_U32		ErrorOffset;
} SK_PNMI_REQUEST_STATUS;


typedef struct s_PnmiStrucData {
	SK_U32					MgmtDBVersion;
	SK_PNMI_REQUEST_STATUS	ReturnStatus;
	SK_U32					PortNumber;
	SK_U32					DeviceType;
	char					DriverDescr[SK_PNMI_STRINGLEN1];
	char					DriverVersion[SK_PNMI_STRINGLEN2];
	char					HwDescr[SK_PNMI_STRINGLEN1];
	char					HwVersion[SK_PNMI_STRINGLEN2];
	SK_U8					BusType;
	SK_U8					BusSpeed;
	SK_U8					BusWidth;
	SK_U16					EthSpeed;
	SK_U16					Chipset;
	SK_U64					TxRetryCts;
	SK_U64					RxIntrCts;
	SK_U64					TxIntrCts;
	SK_U64					RxNoBufCts;
	SK_U64					TxNoBufCts;
	SK_U64					TxUsedDescrNo;
	SK_U64					RxDeliveredCts;
	SK_U64					RxOctetsDeliveredCts;
	SK_U64					RxHwErrorsCts;
	SK_U64					TxHwErrorsCts;
	SK_U64					InErrorsCts;
	SK_U64					OutErrorsCts;
	SK_U64					ErrRecoveryCts;
	SK_U64					SysUpTime;
	SK_PNMI_STAT			Stat[2];
} SK_PNMI_STRUCT_DATA;

#define SK_PNMI_STRUCT_SIZE	(sizeof(SK_PNMI_STRUCT_DATA))
typedef struct {
	SK_U8				Reserved0[0x400 - 0x300];

	/* Statistics maintained by Receive MAC. */
	SK_64BIT_REGISTER	ifHCInOctets;
	SK_64BIT_REGISTER	Reserved1;
	SK_64BIT_REGISTER	etherStatsFragments;
	SK_64BIT_REGISTER	ifHCInUcastPkts;
	SK_64BIT_REGISTER	ifHCInMulticastPkts;
	SK_64BIT_REGISTER	ifHCInBroadcastPkts;
	SK_64BIT_REGISTER	dot3StatsFCSErrors;
	SK_64BIT_REGISTER	dot3StatsAlignmentErrors;
	SK_64BIT_REGISTER	xonPauseFramesReceived;
	SK_64BIT_REGISTER	xoffPauseFramesReceived;
	SK_64BIT_REGISTER	macControlFramesReceived;
	SK_64BIT_REGISTER	xoffStateEntered;
	SK_64BIT_REGISTER	dot3StatsFramesTooLong;
	SK_64BIT_REGISTER	etherStatsJabbers;
	SK_64BIT_REGISTER	etherStatsUndersizePkts;
	SK_64BIT_REGISTER	inRangeLengthError;
	SK_64BIT_REGISTER	outRangeLengthError;
	SK_64BIT_REGISTER	etherStatsPkts64Octets;
	SK_64BIT_REGISTER	etherStatsPkts65Octetsto127Octets;
	SK_64BIT_REGISTER	etherStatsPkts128Octetsto255Octets;
	SK_64BIT_REGISTER	etherStatsPkts256Octetsto511Octets;
	SK_64BIT_REGISTER	etherStatsPkts512Octetsto1023Octets;
	SK_64BIT_REGISTER	etherStatsPkts1024Octetsto1522Octets;
	SK_64BIT_REGISTER	etherStatsPkts1523Octetsto2047Octets;
	SK_64BIT_REGISTER	etherStatsPkts2048Octetsto4095Octets;
	SK_64BIT_REGISTER	etherStatsPkts4096Octetsto8191Octets;
	SK_64BIT_REGISTER	etherStatsPkts8192Octetsto9022Octets;

	SK_64BIT_REGISTER	Dummy1[37];

	/* Statistics maintained by Transmit MAC. */
	SK_64BIT_REGISTER	ifHCOutOctets;
	SK_64BIT_REGISTER	Reserved2;
	SK_64BIT_REGISTER	etherStatsCollisions;
	SK_64BIT_REGISTER	outXonSent;
	SK_64BIT_REGISTER	outXoffSent;
	SK_64BIT_REGISTER	flowControlDone;
	SK_64BIT_REGISTER	dot3StatsInternalMacTransmitErrors;
	SK_64BIT_REGISTER	dot3StatsSingleCollisionFrames;
	SK_64BIT_REGISTER	dot3StatsMultipleCollisionFrames;
	SK_64BIT_REGISTER	dot3StatsDeferredTransmissions;
	SK_64BIT_REGISTER	Reserved3;
	SK_64BIT_REGISTER	dot3StatsExcessiveCollisions;
	SK_64BIT_REGISTER	dot3StatsLateCollisions;
	SK_64BIT_REGISTER	dot3Collided2Times;
	SK_64BIT_REGISTER	dot3Collided3Times;
	SK_64BIT_REGISTER	dot3Collided4Times;
	SK_64BIT_REGISTER	dot3Collided5Times;
	SK_64BIT_REGISTER	dot3Collided6Times;
	SK_64BIT_REGISTER	dot3Collided7Times;
	SK_64BIT_REGISTER	dot3Collided8Times;
	SK_64BIT_REGISTER	dot3Collided9Times;
	SK_64BIT_REGISTER	dot3Collided10Times;
	SK_64BIT_REGISTER	dot3Collided11Times;
	SK_64BIT_REGISTER	dot3Collided12Times;
	SK_64BIT_REGISTER	dot3Collided13Times;
	SK_64BIT_REGISTER	dot3Collided14Times;
	SK_64BIT_REGISTER	dot3Collided15Times;
	SK_64BIT_REGISTER	ifHCOutUcastPkts;
	SK_64BIT_REGISTER	ifHCOutMulticastPkts;
	SK_64BIT_REGISTER	ifHCOutBroadcastPkts;
	SK_64BIT_REGISTER	dot3StatsCarrierSenseErrors;
	SK_64BIT_REGISTER	ifOutDiscards;
	SK_64BIT_REGISTER	ifOutErrors;

	SK_64BIT_REGISTER	Dummy2[31];

	/* Statistics maintained by Receive List Placement. */
	SK_64BIT_REGISTER	COSIfHCInPkts[16];
	SK_64BIT_REGISTER	COSFramesDroppedDueToFilters;
	SK_64BIT_REGISTER	nicDmaWriteQueueFull;
	SK_64BIT_REGISTER	nicDmaWriteHighPriQueueFull;
	SK_64BIT_REGISTER	nicNoMoreRxBDs;
	SK_64BIT_REGISTER	ifInDiscards;
	SK_64BIT_REGISTER	ifInErrors;
	SK_64BIT_REGISTER	nicRecvThresholdHit;

	SK_64BIT_REGISTER	Dummy3[9];

	/* Statistics maintained by Send Data Initiator. */
	SK_64BIT_REGISTER	COSIfHCOutPkts[16];
	SK_64BIT_REGISTER	nicDmaReadQueueFull;
	SK_64BIT_REGISTER	nicDmaReadHighPriQueueFull;
	SK_64BIT_REGISTER	nicSendDataCompQueueFull;

	/* Statistics maintained by Host Coalescing. */
	SK_64BIT_REGISTER	nicRingSetSendProdIndex;
	SK_64BIT_REGISTER	nicRingStatusUpdate;
	SK_64BIT_REGISTER	nicInterrupts;
	SK_64BIT_REGISTER	nicAvoidedInterrupts;
	SK_64BIT_REGISTER	nicSendThresholdHit;

	SK_U8				Reserved4[0xb00 - 0x9c0];
} PNMI_STAT_BLOCK;


/*
 * Function prototypes
 */
extern void SkPnmiInit(
	SK_AC		*pAC,
	SK_IOC		IoC,
	int			Level);
extern int SkPnmiGetVar(
	SK_AC		*pAC,
	SK_IOC		IoC,
	SK_U32		Id,
	void		*pBuf,
	unsigned	*pLen,
	SK_U32		Instance);
extern int SkPnmiPreSetVar(
	SK_AC		*pAC,
	SK_IOC		IoC,
	SK_U32		Id,
	void		*pBuf,
	unsigned	*pLen,
	SK_U32		Instance);
extern int SkPnmiSetVar(
	SK_AC		*pAC,
	SK_IOC		IoC,
	SK_U32		Id,
	void		*pBuf,
	unsigned	*pLen,
	SK_U32		Instance);
extern int SkPnmiGetStruct(
	SK_AC		*pAC,
	SK_IOC		IoC,
	void		*pBuf,
	unsigned	*pLen);
extern int SkPnmiPreSetStruct(
	SK_AC		*pAC,
	SK_IOC		IoC,
	void		*pBuf,
	unsigned	*pLen);
extern int SkPnmiSetStruct(
	SK_AC		*pAC,
	SK_IOC		IoC,
	void		*pBuf,
	unsigned	*pLen);
extern int SkPnmiEvent(
	SK_AC		*pAC,
	SK_IOC		IoC,
	SK_U32		Event,
	SK_EVPARA	Para);

#endif	/* SKGIPNMI_H_ */

