/*******************************************************************
 * This file is part of the Emulex Linux Device Driver for         *
 * Enterprise Fibre Channel Host Bus Adapters.                     *
 * Refer to the README file included with this package for         *
 * driver version and adapter support.                             *
 * Copyright (C) 2003 Emulex Corporation.                          *
 * www.emulex.com                                                  *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2  *
 * of the License, or (at your option) any later version.          *
 *                                                                 *
 * This program is distributed in the hope that it will be useful, *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   *
 * GNU General Public License for more details, a copy of which    *
 * can be found in the file COPYING included with this package.    *
 *******************************************************************/

#ifndef _H_FCMSG
#define _H_FCMSG

/*
 * LOG Message Group Numbering Sequence
 *
 * Message Group    Preamble  From   To
 *                  String
 *
 * ELS              ELx        100    199
 * DISCOVERY        DIx        200    299
 * MBOX             MBx        300    399
 * INIT             INx        400    499
 * Unused                      500    599
 * IP               IPx        600    699
 * FCP              FPx        700    799
 * Unused                      800    899
 * NODE             NDx        900    999
 * MISC             MIx       1200   1299
 * LINK             LKx       1300   1399
 * SLI              SLx       1400   1499
 * CHK_CONDITION    CKx       1500   1599
 */

/*
 * Log Message Structure
 *
 * The following structure supports LOG messages only.
 * Every LOG message is associated to a msgBlkLogDef structure of the 
 * following type.
 */

typedef struct msgLogType {
   int    msgNum;               /* Message number */
   char * msgStr;               /* Ptr to log message */
   char * msgPreambleStr;       /* Ptr to log message preamble */
   int    msgOutput;            /* Message output target - bitmap */
   /*
    * This member controls message OUTPUT.
    *
    * The phase 'global controls' refers to user configurable parameters
    * such as LOG_VERBOSE that control message output on a global basis.
    */

#define FC_MSG_OPUT_GLOB_CTRL         0x0        /* Use global control */
#define FC_MSG_OPUT_DISA              0x1        /* Override global control */
#define FC_MSG_OPUT_FORCE             0x2        /* Override global control */
   int    msgType;              /* Message LOG type - bitmap */
#define FC_LOG_MSG_TYPE_INFO          0x1        /* Maskable */
#define FC_LOG_MSG_TYPE_WARN          0x2        /* Non-Maskable */
#define FC_LOG_MSG_TYPE_ERR_CFG       0x4        /* Non-Maskable */
#define FC_LOG_MSG_TYPE_ERR           0x8        /* Non-Maskable */ 
#define FC_LOG_MSG_TYPE_PANIC        0x10        /* Non-Maskable */
   int    msgMask;              /* Message LOG mask - bitmap */
   /*
    * NOTE: Only LOG messages of types MSG_TYPE_WARN & MSG_TYPE_INFO are 
    * maskable at the GLOBAL level.
    * 
    * Any LOG message regardless of message type can be disabled (override verbose) 
    * at the msgBlkLogDef struct level my setting member msgOutput = FC_MSG_OPUT_DISA.
    * The message will never be displayed regardless of verbose mask.
    * 
    * Any LOG message regardless of message type can be enable (override verbose) 
    * at the msgBlkLogDef struct level my setting member msgOutput = FC_MSG_OPUT_FORCE.
    * The message will always be displayed regardless of verbose mask.
    */
#define LOG_ELS                       0x1        /* ELS events */
#define LOG_DISCOVERY                 0x2        /* Link discovery events */
#define LOG_MBOX                      0x4        /* Mailbox events */
#define LOG_INIT                      0x8        /* Initialization events */
#define LOG_LINK_EVENT                0x10       /* Link events */
#define LOG_IP                        0x20       /* IP traffic history */
#define LOG_FCP                       0x40       /* FCP traffic history */
#define LOG_NODE                      0x80       /* Node table events */
#define LOG_MISC                      0x400      /* Miscellaneous events */
#define LOG_SLI                       0x800      /* SLI events */
#define LOG_CHK_COND                  0x1000     /* FCP Check condition flag */
#define LOG_ALL_MSG                   0x1fff     /* LOG all messages */
   unsigned int    msgLogID;  /* Message LOG ID */
#define ERRID_LOG_TIMEOUT             0xfdefefa7 /* Fibre Channel timeout */
#define ERRID_LOG_HDW_ERR             0x1ae4fffc /* Fibre Channel hardware failure */
#define ERRID_LOG_UNEXPECT_EVENT      0xbdb7e728 /* Fibre Channel unexpected event */
#define ERRID_LOG_INIT                0xbe1043b8 /*  Fibre Channel init failure */
#define ERRID_LOG_NO_RESOURCE         0x474c1775 /* Fibre Channel no resources */
   } msgLogDef;

/*
 * External Declarations for LOG Messages
 */

/* ELS LOG Messages */
extern char fc_mes0100[];
extern char fc_mes0101[];
extern char fc_mes0102[];
extern char fc_mes0103[];
extern char fc_mes0104[];
extern char fc_mes0105[];
extern char fc_mes0106[];
extern char fc_mes0107[];
extern char fc_mes0108[];
extern char fc_mes0109[];
extern char fc_mes0110[];
extern char fc_mes0111[];
extern char fc_mes0112[];
extern char fc_mes0113[];
extern char fc_mes0114[];
extern char fc_mes0115[];
extern char fc_mes0116[];
extern char fc_mes0117[];
extern char fc_mes0118[];
extern char fc_mes0119[];
extern char fc_mes0120[];
extern char fc_mes0121[];
extern char fc_mes0122[];
extern char fc_mes0123[];
extern char fc_mes0124[];
extern char fc_mes0125[];
extern char fc_mes0126[];
extern char fc_mes0127[];
extern char fc_mes0128[];
extern char fc_mes0129[];
extern char fc_mes0130[];
extern char fc_mes0131[];
extern char fc_mes0132[];
extern char fc_mes0133[];
extern char fc_mes0134[];
extern char fc_mes0135[];
extern char fc_mes0136[];

/* DISCOVERY LOG Messages */
extern char fc_mes0200[];
extern char fc_mes0201[];
extern char fc_mes0202[];
extern char fc_mes0203[];
extern char fc_mes0204[];
extern char fc_mes0205[];
extern char fc_mes0206[];
extern char fc_mes0207[];
extern char fc_mes0208[];
extern char fc_mes0209[];
extern char fc_mes0210[];
extern char fc_mes0211[];
extern char fc_mes0212[];
extern char fc_mes0213[];
extern char fc_mes0214[];
extern char fc_mes0215[];
extern char fc_mes0216[];
extern char fc_mes0217[];
extern char fc_mes0218[];
extern char fc_mes0219[];
extern char fc_mes0220[];
extern char fc_mes0221[];
extern char fc_mes0222[];
extern char fc_mes0223[];
extern char fc_mes0224[];
extern char fc_mes0225[];
extern char fc_mes0226[];
extern char fc_mes0227[];
extern char fc_mes0228[];
extern char fc_mes0229[];
extern char fc_mes0230[];
extern char fc_mes0231[];
extern char fc_mes0232[];
extern char fc_mes0233[];
extern char fc_mes0234[];
extern char fc_mes0235[];
extern char fc_mes0236[];
extern char fc_mes0237[];
extern char fc_mes0238[];
extern char fc_mes0239[];
extern char fc_mes0240[];
extern char fc_mes0241[];
extern char fc_mes0242[];
extern char fc_mes0243[];
extern char fc_mes0244[];
extern char fc_mes0245[];
extern char fc_mes0246[];
extern char fc_mes0247[];
extern char fc_mes0248[];
extern char fc_mes0249[];
extern char fc_mes0250[];
extern char fc_mes0251[];
extern char fc_mes0252[];

/* MAILBOX LOG Messages */
extern char fc_mes0300[];
extern char fc_mes0301[];
extern char fc_mes0302[];
extern char fc_mes0303[];
extern char fc_mes0304[];
extern char fc_mes0305[];
extern char fc_mes0306[];
extern char fc_mes0307[];
extern char fc_mes0308[];
extern char fc_mes0309[];
extern char fc_mes0310[];
extern char fc_mes0311[];
extern char fc_mes0312[];

/* INIT LOG Messages */
extern char fc_mes0400[];
extern char fc_mes0401[];
extern char fc_mes0402[];
extern char fc_mes0403[];
extern char fc_mes0404[];
extern char fc_mes0405[];
extern char fc_mes0406[];
extern char fc_mes0407[];
extern char fc_mes0408[];
extern char fc_mes0409[];
extern char fc_mes0410[];
extern char fc_mes0411[];
extern char fc_mes0412[];
extern char fc_mes0413[];
extern char fc_mes0414[];
extern char fc_mes0415[];
extern char fc_mes0416[];
extern char fc_mes0417[];
extern char fc_mes0418[];
extern char fc_mes0419[];
extern char fc_mes0420[];
extern char fc_mes0421[];
extern char fc_mes0422[];
extern char fc_mes0423[];
extern char fc_mes0424[];
extern char fc_mes0425[];
extern char fc_mes0426[];
extern char fc_mes0427[];
extern char fc_mes0428[];
extern char fc_mes0429[];
extern char fc_mes0430[];
extern char fc_mes0431[];
extern char fc_mes0432[];
extern char fc_mes0433[];
extern char fc_mes0434[];
extern char fc_mes0435[];
extern char fc_mes0436[];
extern char fc_mes0437[];
extern char fc_mes0438[];
extern char fc_mes0439[];
extern char fc_mes0440[];
extern char fc_mes0440[];
extern char fc_mes0441[];
extern char fc_mes0442[];
extern char fc_mes0443[];
extern char fc_mes0444[];
extern char fc_mes0445[];
extern char fc_mes0446[];
extern char fc_mes0447[];
extern char fc_mes0448[];
extern char fc_mes0449[];
extern char fc_mes0450[];
extern char fc_mes0451[];
extern char fc_mes0452[];
extern char fc_mes0453[];
extern char fc_mes0454[];
extern char fc_mes0455[];
extern char fc_mes0456[];
extern char fc_mes0457[];
extern char fc_mes0458[];
extern char fc_mes0459[];
extern char fc_mes0460[];
extern char fc_mes0461[];

/* UNUSED */
/*
extern char fc_mes0500[];
*/

/* IP LOG Messages */
extern char fc_mes0600[];
extern char fc_mes0601[];
extern char fc_mes0602[];
extern char fc_mes0603[];
extern char fc_mes0604[];
extern char fc_mes0605[];
extern char fc_mes0606[];
extern char fc_mes0607[];
extern char fc_mes0608[];

/* FCP LOG Messages */
extern char fc_mes0700[];
extern char fc_mes0701[];
extern char fc_mes0702[];
extern char fc_mes0703[];
extern char fc_mes0704[];
extern char fc_mes0705[];
extern char fc_mes0706[];
extern char fc_mes0707[];
extern char fc_mes0708[];
extern char fc_mes0709[];
extern char fc_mes0710[];
extern char fc_mes0711[];
extern char fc_mes0712[];
extern char fc_mes0713[];
extern char fc_mes0714[];
extern char fc_mes0715[];
extern char fc_mes0716[];
extern char fc_mes0717[];
extern char fc_mes0718[];
extern char fc_mes0719[];
extern char fc_mes0720[];
extern char fc_mes0721[];
extern char fc_mes0722[];
extern char fc_mes0723[];
extern char fc_mes0724[];
extern char fc_mes0725[];
extern char fc_mes0726[];
extern char fc_mes0727[];
extern char fc_mes0728[];
extern char fc_mes0729[];
extern char fc_mes0730[];
extern char fc_mes0731[];
extern char fc_mes0732[];
extern char fc_mes0733[];
extern char fc_mes0734[];
extern char fc_mes0735[];
extern char fc_mes0736[];
extern char fc_mes0737[];
extern char fc_mes0738[];
extern char fc_mes0739[];
extern char fc_mes0740[];
extern char fc_mes0741[];
extern char fc_mes0742[];
extern char fc_mes0743[];
extern char fc_mes0744[];
extern char fc_mes0745[];
extern char fc_mes0746[];
extern char fc_mes0747[];
extern char fc_mes0748[];
extern char fc_mes0749[];
extern char fc_mes0750[];
extern char fc_mes0751[];
extern char fc_mes0752[];
extern char fc_mes0753[];
extern char fc_mes0754[];
extern char fc_mes0756[];

/* UNUSED */
/*
extern char fc_mes0800[];
*/

/* NODE LOG Messages */
extern char fc_mes0900[];
extern char fc_mes0901[];
extern char fc_mes0902[];
extern char fc_mes0903[];
extern char fc_mes0904[];
extern char fc_mes0905[];
extern char fc_mes0906[];
extern char fc_mes0907[];
extern char fc_mes0908[];
extern char fc_mes0909[];
extern char fc_mes0910[];
extern char fc_mes0911[];
extern char fc_mes0912[];
extern char fc_mes0913[];
extern char fc_mes0914[];
extern char fc_mes0915[];
extern char fc_mes0916[];
extern char fc_mes0917[];
extern char fc_mes0918[];
extern char fc_mes0919[];
extern char fc_mes0920[];
extern char fc_mes0921[];
extern char fc_mes0922[];
extern char fc_mes0923[];
extern char fc_mes0924[];
extern char fc_mes0925[];
extern char fc_mes0926[];
extern char fc_mes0927[];
extern char fc_mes0928[];



/* MISC LOG messages */
extern char fc_mes1200[];
extern char fc_mes1201[];
extern char fc_mes1202[];
extern char fc_mes1203[];
extern char fc_mes1204[];
extern char fc_mes1205[];
extern char fc_mes1206[];
extern char fc_mes1207[];
extern char fc_mes1208[];
extern char fc_mes1209[];
extern char fc_mes1210[];
extern char fc_mes1211[];
extern char fc_mes1212[];
extern char fc_mes1213[];

/* LINK LOG Messages */
extern char fc_mes1300[];
extern char fc_mes1301[];
extern char fc_mes1302[];
extern char fc_mes1303[];
extern char fc_mes1304[];
extern char fc_mes1305[];
extern char fc_mes1306[];
extern char fc_mes1307[];

/* SLI LOG Messages */
extern char fc_mes1400[];
extern char fc_mes1401[];
extern char fc_mes1402[];

/* CHK CONDITION LOG Messages */
/* 
extern char fc_mes1500[];
*/

/*
 * External Declarations for LOG Message Structure msgBlkLogDef
 */

/* ELS LOG Message Structures */
extern msgLogDef fc_msgBlk0100;
extern msgLogDef fc_msgBlk0101;
extern msgLogDef fc_msgBlk0102;
extern msgLogDef fc_msgBlk0103;
extern msgLogDef fc_msgBlk0104;
extern msgLogDef fc_msgBlk0105;
extern msgLogDef fc_msgBlk0106;
extern msgLogDef fc_msgBlk0107;
extern msgLogDef fc_msgBlk0108;
extern msgLogDef fc_msgBlk0109;
extern msgLogDef fc_msgBlk0110;
extern msgLogDef fc_msgBlk0111;
extern msgLogDef fc_msgBlk0112;
extern msgLogDef fc_msgBlk0113;
extern msgLogDef fc_msgBlk0114;
extern msgLogDef fc_msgBlk0115;
extern msgLogDef fc_msgBlk0116;
extern msgLogDef fc_msgBlk0117;
extern msgLogDef fc_msgBlk0118;
extern msgLogDef fc_msgBlk0119;
extern msgLogDef fc_msgBlk0120;
extern msgLogDef fc_msgBlk0121;
extern msgLogDef fc_msgBlk0122;
extern msgLogDef fc_msgBlk0123;
extern msgLogDef fc_msgBlk0124;
extern msgLogDef fc_msgBlk0125;
extern msgLogDef fc_msgBlk0126;
extern msgLogDef fc_msgBlk0127;
extern msgLogDef fc_msgBlk0128;
extern msgLogDef fc_msgBlk0129;
extern msgLogDef fc_msgBlk0130;
extern msgLogDef fc_msgBlk0131;
extern msgLogDef fc_msgBlk0132;
extern msgLogDef fc_msgBlk0133;
extern msgLogDef fc_msgBlk0134;
extern msgLogDef fc_msgBlk0135;
extern msgLogDef fc_msgBlk0136;

/* DISCOVERY LOG Message Structures */
extern msgLogDef fc_msgBlk0200;
extern msgLogDef fc_msgBlk0201;
extern msgLogDef fc_msgBlk0202;
extern msgLogDef fc_msgBlk0203;
extern msgLogDef fc_msgBlk0204;
extern msgLogDef fc_msgBlk0205;
extern msgLogDef fc_msgBlk0206;
extern msgLogDef fc_msgBlk0207;
extern msgLogDef fc_msgBlk0208;
extern msgLogDef fc_msgBlk0209;
extern msgLogDef fc_msgBlk0210;
extern msgLogDef fc_msgBlk0211;
extern msgLogDef fc_msgBlk0212;
extern msgLogDef fc_msgBlk0213;
extern msgLogDef fc_msgBlk0214;
extern msgLogDef fc_msgBlk0215;
extern msgLogDef fc_msgBlk0216;
extern msgLogDef fc_msgBlk0217;
extern msgLogDef fc_msgBlk0218;
extern msgLogDef fc_msgBlk0219;
extern msgLogDef fc_msgBlk0220;
extern msgLogDef fc_msgBlk0221;
extern msgLogDef fc_msgBlk0222;
extern msgLogDef fc_msgBlk0223;
extern msgLogDef fc_msgBlk0224;
extern msgLogDef fc_msgBlk0225;
extern msgLogDef fc_msgBlk0226;
extern msgLogDef fc_msgBlk0227;
extern msgLogDef fc_msgBlk0228;
extern msgLogDef fc_msgBlk0229;
extern msgLogDef fc_msgBlk0230;
extern msgLogDef fc_msgBlk0231;
extern msgLogDef fc_msgBlk0232;
extern msgLogDef fc_msgBlk0233;
extern msgLogDef fc_msgBlk0234;
extern msgLogDef fc_msgBlk0235;
extern msgLogDef fc_msgBlk0236;
extern msgLogDef fc_msgBlk0237;
extern msgLogDef fc_msgBlk0238;
extern msgLogDef fc_msgBlk0239;
extern msgLogDef fc_msgBlk0240;
extern msgLogDef fc_msgBlk0241;
extern msgLogDef fc_msgBlk0242;
extern msgLogDef fc_msgBlk0243;
extern msgLogDef fc_msgBlk0244;
extern msgLogDef fc_msgBlk0245;
extern msgLogDef fc_msgBlk0246;
extern msgLogDef fc_msgBlk0247;
extern msgLogDef fc_msgBlk0248;
extern msgLogDef fc_msgBlk0249;
extern msgLogDef fc_msgBlk0250;
extern msgLogDef fc_msgBlk0251;
extern msgLogDef fc_msgBlk0252;

/* MAILBOX LOG Message Structures */
extern msgLogDef fc_msgBlk0300;
extern msgLogDef fc_msgBlk0301;
extern msgLogDef fc_msgBlk0302;
extern msgLogDef fc_msgBlk0303;
extern msgLogDef fc_msgBlk0304;
extern msgLogDef fc_msgBlk0305;
extern msgLogDef fc_msgBlk0306;
extern msgLogDef fc_msgBlk0307;
extern msgLogDef fc_msgBlk0308;
extern msgLogDef fc_msgBlk0309;
extern msgLogDef fc_msgBlk0310;
extern msgLogDef fc_msgBlk0311;
extern msgLogDef fc_msgBlk0312;

/* INIT LOG Message Structures */
extern msgLogDef fc_msgBlk0400;
extern msgLogDef fc_msgBlk0401;
extern msgLogDef fc_msgBlk0402;
extern msgLogDef fc_msgBlk0403;
extern msgLogDef fc_msgBlk0404;
extern msgLogDef fc_msgBlk0405;
extern msgLogDef fc_msgBlk0406;
extern msgLogDef fc_msgBlk0407;
extern msgLogDef fc_msgBlk0408;
extern msgLogDef fc_msgBlk0409;
extern msgLogDef fc_msgBlk0410;
extern msgLogDef fc_msgBlk0411;
extern msgLogDef fc_msgBlk0412;
extern msgLogDef fc_msgBlk0413;
extern msgLogDef fc_msgBlk0414;
extern msgLogDef fc_msgBlk0415;
extern msgLogDef fc_msgBlk0416;
extern msgLogDef fc_msgBlk0417;
extern msgLogDef fc_msgBlk0418;
extern msgLogDef fc_msgBlk0419;
extern msgLogDef fc_msgBlk0420;
extern msgLogDef fc_msgBlk0421;
extern msgLogDef fc_msgBlk0422;
extern msgLogDef fc_msgBlk0423;
extern msgLogDef fc_msgBlk0424;
extern msgLogDef fc_msgBlk0425;
extern msgLogDef fc_msgBlk0426;
extern msgLogDef fc_msgBlk0427;
extern msgLogDef fc_msgBlk0428;
extern msgLogDef fc_msgBlk0429;
extern msgLogDef fc_msgBlk0430;
extern msgLogDef fc_msgBlk0431;
extern msgLogDef fc_msgBlk0432;
extern msgLogDef fc_msgBlk0433;
extern msgLogDef fc_msgBlk0434;
extern msgLogDef fc_msgBlk0435;
extern msgLogDef fc_msgBlk0436;
extern msgLogDef fc_msgBlk0437;
extern msgLogDef fc_msgBlk0438;
extern msgLogDef fc_msgBlk0439;
extern msgLogDef fc_msgBlk0440;
extern msgLogDef fc_msgBlk0441;
extern msgLogDef fc_msgBlk0442;
extern msgLogDef fc_msgBlk0443;
extern msgLogDef fc_msgBlk0444;
extern msgLogDef fc_msgBlk0445;
extern msgLogDef fc_msgBlk0446;
extern msgLogDef fc_msgBlk0447;
extern msgLogDef fc_msgBlk0448;
extern msgLogDef fc_msgBlk0449;
extern msgLogDef fc_msgBlk0450;
extern msgLogDef fc_msgBlk0451;
extern msgLogDef fc_msgBlk0452;
extern msgLogDef fc_msgBlk0453;
extern msgLogDef fc_msgBlk0454;
extern msgLogDef fc_msgBlk0455;
extern msgLogDef fc_msgBlk0456;
extern msgLogDef fc_msgBlk0457;
extern msgLogDef fc_msgBlk0458;
extern msgLogDef fc_msgBlk0459;
extern msgLogDef fc_msgBlk0460;
extern msgLogDef fc_msgBlk0461;

/* UNUSED */
/*
extern msgLogDef fc_msgBlk0500;
*/

/* IP LOG Message Structures */
extern msgLogDef fc_msgBlk0600;
extern msgLogDef fc_msgBlk0601;
extern msgLogDef fc_msgBlk0602;
extern msgLogDef fc_msgBlk0603;
extern msgLogDef fc_msgBlk0604;
extern msgLogDef fc_msgBlk0605;
extern msgLogDef fc_msgBlk0606;
extern msgLogDef fc_msgBlk0607;
extern msgLogDef fc_msgBlk0608;

/* FCP LOG Message Structures */
extern msgLogDef fc_msgBlk0700;
extern msgLogDef fc_msgBlk0701;
extern msgLogDef fc_msgBlk0702;
extern msgLogDef fc_msgBlk0703;
extern msgLogDef fc_msgBlk0704;
extern msgLogDef fc_msgBlk0705;
extern msgLogDef fc_msgBlk0706;
extern msgLogDef fc_msgBlk0707;
extern msgLogDef fc_msgBlk0708;
extern msgLogDef fc_msgBlk0709;
extern msgLogDef fc_msgBlk0710;
extern msgLogDef fc_msgBlk0711;
extern msgLogDef fc_msgBlk0712;
extern msgLogDef fc_msgBlk0713;
extern msgLogDef fc_msgBlk0714;
extern msgLogDef fc_msgBlk0715;
extern msgLogDef fc_msgBlk0716;
extern msgLogDef fc_msgBlk0717;
extern msgLogDef fc_msgBlk0718;
extern msgLogDef fc_msgBlk0719;
extern msgLogDef fc_msgBlk0720;
extern msgLogDef fc_msgBlk0721;
extern msgLogDef fc_msgBlk0722;
extern msgLogDef fc_msgBlk0723;
extern msgLogDef fc_msgBlk0724;
extern msgLogDef fc_msgBlk0725;
extern msgLogDef fc_msgBlk0726;
extern msgLogDef fc_msgBlk0727;
extern msgLogDef fc_msgBlk0728;
extern msgLogDef fc_msgBlk0729;
extern msgLogDef fc_msgBlk0730;
extern msgLogDef fc_msgBlk0731;
extern msgLogDef fc_msgBlk0732;
extern msgLogDef fc_msgBlk0733;
extern msgLogDef fc_msgBlk0734;
extern msgLogDef fc_msgBlk0735;
extern msgLogDef fc_msgBlk0736;
extern msgLogDef fc_msgBlk0737;
extern msgLogDef fc_msgBlk0738;
extern msgLogDef fc_msgBlk0739;
extern msgLogDef fc_msgBlk0740;
extern msgLogDef fc_msgBlk0741;
extern msgLogDef fc_msgBlk0742;
extern msgLogDef fc_msgBlk0743;
extern msgLogDef fc_msgBlk0744;
extern msgLogDef fc_msgBlk0745;
extern msgLogDef fc_msgBlk0746;
extern msgLogDef fc_msgBlk0747;
extern msgLogDef fc_msgBlk0748;
extern msgLogDef fc_msgBlk0749;
extern msgLogDef fc_msgBlk0750;
extern msgLogDef fc_msgBlk0751;
extern msgLogDef fc_msgBlk0752;
extern msgLogDef fc_msgBlk0753;
extern msgLogDef fc_msgBlk0754;
extern msgLogDef fc_msgBlk0756;

/* UNUSED */
/*
extern msgLogDef fc_msgBlk0800;
*/

/* NODE LOG Message Structures */
extern msgLogDef fc_msgBlk0900;
extern msgLogDef fc_msgBlk0901;
extern msgLogDef fc_msgBlk0902;
extern msgLogDef fc_msgBlk0903;
extern msgLogDef fc_msgBlk0904;
extern msgLogDef fc_msgBlk0905;
extern msgLogDef fc_msgBlk0906;
extern msgLogDef fc_msgBlk0907;
extern msgLogDef fc_msgBlk0908;
extern msgLogDef fc_msgBlk0909;
extern msgLogDef fc_msgBlk0910;
extern msgLogDef fc_msgBlk0911;
extern msgLogDef fc_msgBlk0912;
extern msgLogDef fc_msgBlk0913;
extern msgLogDef fc_msgBlk0914;
extern msgLogDef fc_msgBlk0915;
extern msgLogDef fc_msgBlk0916;
extern msgLogDef fc_msgBlk0917;
extern msgLogDef fc_msgBlk0918;
extern msgLogDef fc_msgBlk0919;
extern msgLogDef fc_msgBlk0920;
extern msgLogDef fc_msgBlk0921;
extern msgLogDef fc_msgBlk0922;
extern msgLogDef fc_msgBlk0923;
extern msgLogDef fc_msgBlk0924;
extern msgLogDef fc_msgBlk0925;
extern msgLogDef fc_msgBlk0926;
extern msgLogDef fc_msgBlk0927;
extern msgLogDef fc_msgBlk0928;



/* MISC LOG Message Structures */
extern msgLogDef fc_msgBlk1200;
extern msgLogDef fc_msgBlk1201;
extern msgLogDef fc_msgBlk1202;
extern msgLogDef fc_msgBlk1203;
extern msgLogDef fc_msgBlk1204;
extern msgLogDef fc_msgBlk1205;
extern msgLogDef fc_msgBlk1206;
extern msgLogDef fc_msgBlk1207;
extern msgLogDef fc_msgBlk1208;
extern msgLogDef fc_msgBlk1209;
extern msgLogDef fc_msgBlk1210;
extern msgLogDef fc_msgBlk1211;
extern msgLogDef fc_msgBlk1212;
extern msgLogDef fc_msgBlk1213;

/* LINK LOG Message Structures */
extern msgLogDef fc_msgBlk1300;
extern msgLogDef fc_msgBlk1301;
extern msgLogDef fc_msgBlk1302;
extern msgLogDef fc_msgBlk1303;
extern msgLogDef fc_msgBlk1304;
extern msgLogDef fc_msgBlk1305;
extern msgLogDef fc_msgBlk1306;
extern msgLogDef fc_msgBlk1307;

/* SLI LOG Message Structures */
extern msgLogDef fc_msgBlk1400;
extern msgLogDef fc_msgBlk1401;
extern msgLogDef fc_msgBlk1402;

/* CHK CONDITION LOG Message Structures */
/*
extern msgLogDef fc_msgBlk1500;
*/

/* 
 * LOG Messages Numbers
 */

/* ELS LOG Message Numbers */
#define FC_LOG_MSG_EL_0100    100
#define FC_LOG_MSG_EL_0101    101
#define FC_LOG_MSG_EL_0102    102
#define FC_LOG_MSG_EL_0103    103
#define FC_LOG_MSG_EL_0104    104
#define FC_LOG_MSG_EL_0105    105
#define FC_LOG_MSG_EL_0106    106
#define FC_LOG_MSG_EL_0107    107
#define FC_LOG_MSG_EL_0108    108
#define FC_LOG_MSG_EL_0109    109
#define FC_LOG_MSG_EL_0110    110
#define FC_LOG_MSG_EL_0111    111
#define FC_LOG_MSG_EL_0112    112
#define FC_LOG_MSG_EL_0113    113
#define FC_LOG_MSG_EL_0114    114
#define FC_LOG_MSG_EL_0115    115
#define FC_LOG_MSG_EL_0116    116
#define FC_LOG_MSG_EL_0117    117
#define FC_LOG_MSG_EL_0118    118
#define FC_LOG_MSG_EL_0119    119
#define FC_LOG_MSG_EL_0120    120
#define FC_LOG_MSG_EL_0121    121
#define FC_LOG_MSG_EL_0122    122
#define FC_LOG_MSG_EL_0123    123
#define FC_LOG_MSG_EL_0124    124
#define FC_LOG_MSG_EL_0125    125
#define FC_LOG_MSG_EL_0126    126
#define FC_LOG_MSG_EL_0127    127
#define FC_LOG_MSG_EL_0128    128
#define FC_LOG_MSG_EL_0129    129
#define FC_LOG_MSG_EL_0130    130
#define FC_LOG_MSG_EL_0131    131
#define FC_LOG_MSG_EL_0132    132
#define FC_LOG_MSG_EL_0133    133
#define FC_LOG_MSG_EL_0134    134
#define FC_LOG_MSG_EL_0135    135
#define FC_LOG_MSG_EL_0136    136

/* DISCOVERY LOG Message Numbers */
#define FC_LOG_MSG_DI_0200    200
#define FC_LOG_MSG_DI_0201    201
#define FC_LOG_MSG_DI_0202    202
#define FC_LOG_MSG_DI_0203    203
#define FC_LOG_MSG_DI_0204    204
#define FC_LOG_MSG_DI_0205    205
#define FC_LOG_MSG_DI_0206    206
#define FC_LOG_MSG_DI_0207    207
#define FC_LOG_MSG_DI_0208    208
#define FC_LOG_MSG_DI_0209    209
#define FC_LOG_MSG_DI_0210    210
#define FC_LOG_MSG_DI_0211    211
#define FC_LOG_MSG_DI_0212    212
#define FC_LOG_MSG_DI_0213    213
#define FC_LOG_MSG_DI_0214    214
#define FC_LOG_MSG_DI_0215    215
#define FC_LOG_MSG_DI_0216    216
#define FC_LOG_MSG_DI_0217    217
#define FC_LOG_MSG_DI_0218    218
#define FC_LOG_MSG_DI_0219    219
#define FC_LOG_MSG_DI_0220    220
#define FC_LOG_MSG_DI_0221    221
#define FC_LOG_MSG_DI_0222    222
#define FC_LOG_MSG_DI_0223    223
#define FC_LOG_MSG_DI_0224    224
#define FC_LOG_MSG_DI_0225    225
#define FC_LOG_MSG_DI_0226    226
#define FC_LOG_MSG_DI_0227    227
#define FC_LOG_MSG_DI_0228    228
#define FC_LOG_MSG_DI_0229    229
#define FC_LOG_MSG_DI_0230    230
#define FC_LOG_MSG_DI_0231    231
#define FC_LOG_MSG_DI_0232    232
#define FC_LOG_MSG_DI_0233    233
#define FC_LOG_MSG_DI_0234    234
#define FC_LOG_MSG_DI_0235    235
#define FC_LOG_MSG_DI_0236    236
#define FC_LOG_MSG_DI_0237    237
#define FC_LOG_MSG_DI_0238    238
#define FC_LOG_MSG_DI_0239    239
#define FC_LOG_MSG_DI_0240    240
#define FC_LOG_MSG_DI_0241    241
#define FC_LOG_MSG_DI_0242    242
#define FC_LOG_MSG_DI_0243    243
#define FC_LOG_MSG_DI_0244    244
#define FC_LOG_MSG_DI_0245    245
#define FC_LOG_MSG_DI_0246    246
#define FC_LOG_MSG_DI_0247    247
#define FC_LOG_MSG_DI_0248    248
#define FC_LOG_MSG_DI_0249    249
#define FC_LOG_MSG_DI_0250    250
#define FC_LOG_MSG_DI_0251    251
#define FC_LOG_MSG_DI_0252    252

/* MAILBOX LOG Message Numbers */
#define FC_LOG_MSG_MB_0300    300
#define FC_LOG_MSG_MB_0301    301
#define FC_LOG_MSG_MB_0302    302
#define FC_LOG_MSG_MB_0303    303
#define FC_LOG_MSG_MB_0304    304
#define FC_LOG_MSG_MB_0305    305
#define FC_LOG_MSG_MB_0306    306
#define FC_LOG_MSG_MB_0307    307
#define FC_LOG_MSG_MB_0308    308
#define FC_LOG_MSG_MB_0309    309
#define FC_LOG_MSG_MB_0310    310
#define FC_LOG_MSG_MB_0311    311
#define FC_LOG_MSG_MB_0312    312

/* INIT LOG Message Numbers */
#define FC_LOG_MSG_IN_0400    400
#define FC_LOG_MSG_IN_0401    401
#define FC_LOG_MSG_IN_0402    402
#define FC_LOG_MSG_IN_0403    403
#define FC_LOG_MSG_IN_0404    404
#define FC_LOG_MSG_IN_0405    405
#define FC_LOG_MSG_IN_0406    406
#define FC_LOG_MSG_IN_0407    407
#define FC_LOG_MSG_IN_0408    408
#define FC_LOG_MSG_IN_0409    409
#define FC_LOG_MSG_IN_0410    410
#define FC_LOG_MSG_IN_0411    411
#define FC_LOG_MSG_IN_0412    412
#define FC_LOG_MSG_IN_0413    413
#define FC_LOG_MSG_IN_0414    414
#define FC_LOG_MSG_IN_0415    415
#define FC_LOG_MSG_IN_0416    416
#define FC_LOG_MSG_IN_0417    417
#define FC_LOG_MSG_IN_0418    418
#define FC_LOG_MSG_IN_0419    419
#define FC_LOG_MSG_IN_0420    420
#define FC_LOG_MSG_IN_0421    421
#define FC_LOG_MSG_IN_0422    422
#define FC_LOG_MSG_IN_0423    423
#define FC_LOG_MSG_IN_0424    424
#define FC_LOG_MSG_IN_0425    425
#define FC_LOG_MSG_IN_0426    426
#define FC_LOG_MSG_IN_0427    427
#define FC_LOG_MSG_IN_0428    428
#define FC_LOG_MSG_IN_0429    429
#define FC_LOG_MSG_IN_0430    430
#define FC_LOG_MSG_IN_0431    431
#define FC_LOG_MSG_IN_0432    432
#define FC_LOG_MSG_IN_0433    433
#define FC_LOG_MSG_IN_0434    434
#define FC_LOG_MSG_IN_0435    435
#define FC_LOG_MSG_IN_0436    436
#define FC_LOG_MSG_IN_0437    437
#define FC_LOG_MSG_IN_0438    438
#define FC_LOG_MSG_IN_0439    439
#define FC_LOG_MSG_IN_0440    440
#define FC_LOG_MSG_IN_0441    441
#define FC_LOG_MSG_IN_0442    442
#define FC_LOG_MSG_IN_0443    443
#define FC_LOG_MSG_IN_0444    444
#define FC_LOG_MSG_IN_0445    445
#define FC_LOG_MSG_IN_0446    446
#define FC_LOG_MSG_IN_0447    447
#define FC_LOG_MSG_IN_0448    448
#define FC_LOG_MSG_IN_0449    449
#define FC_LOG_MSG_IN_0450    450
#define FC_LOG_MSG_IN_0451    451
#define FC_LOG_MSG_IN_0452    452
#define FC_LOG_MSG_IN_0453    453
#define FC_LOG_MSG_IN_0454    454
#define FC_LOG_MSG_IN_0455    455
#define FC_LOG_MSG_IN_0456    456
#define FC_LOG_MSG_IN_0457    457
#define FC_LOG_MSG_IN_0458    458
#define FC_LOG_MSG_IN_0459    459
#define FC_LOG_MSG_IN_0460    460
#define FC_LOG_MSG_IN_0461    461

/* UNUSED */
/*
#define FC_LOG_MSG_IN_0500    500
*/

/* IP LOG Message Numbers */
#define FC_LOG_MSG_IP_0600    600
#define FC_LOG_MSG_IP_0601    601
#define FC_LOG_MSG_IP_0602    602
#define FC_LOG_MSG_IP_0603    603
#define FC_LOG_MSG_IP_0604    604
#define FC_LOG_MSG_IP_0605    605
#define FC_LOG_MSG_IP_0606    606
#define FC_LOG_MSG_IP_0607    607
#define FC_LOG_MSG_IP_0608    608

/* FCP LOG Message Numbers */
#define FC_LOG_MSG_FP_0700    700
#define FC_LOG_MSG_FP_0701    701
#define FC_LOG_MSG_FP_0702    702
#define FC_LOG_MSG_FP_0703    703
#define FC_LOG_MSG_FP_0704    704
#define FC_LOG_MSG_FP_0705    705
#define FC_LOG_MSG_FP_0706    706
#define FC_LOG_MSG_FP_0707    707
#define FC_LOG_MSG_FP_0708    708
#define FC_LOG_MSG_FP_0709    709
#define FC_LOG_MSG_FP_0710    710
#define FC_LOG_MSG_FP_0711    711
#define FC_LOG_MSG_FP_0712    712
#define FC_LOG_MSG_FP_0713    713
#define FC_LOG_MSG_FP_0714    714
#define FC_LOG_MSG_FP_0715    715
#define FC_LOG_MSG_FP_0716    716
#define FC_LOG_MSG_FP_0717    717
#define FC_LOG_MSG_FP_0718    718
#define FC_LOG_MSG_FP_0719    719
#define FC_LOG_MSG_FP_0720    720
#define FC_LOG_MSG_FP_0721    721
#define FC_LOG_MSG_FP_0722    722
#define FC_LOG_MSG_FP_0723    723
#define FC_LOG_MSG_FP_0724    724
#define FC_LOG_MSG_FP_0725    725
#define FC_LOG_MSG_FP_0726    726
#define FC_LOG_MSG_FP_0727    727
#define FC_LOG_MSG_FP_0728    728
#define FC_LOG_MSG_FP_0729    729
#define FC_LOG_MSG_FP_0730    730
#define FC_LOG_MSG_FP_0731    731
#define FC_LOG_MSG_FP_0732    732
#define FC_LOG_MSG_FP_0733    733
#define FC_LOG_MSG_FP_0734    734
#define FC_LOG_MSG_FP_0735    735
#define FC_LOG_MSG_FP_0736    736
#define FC_LOG_MSG_FP_0737    737
#define FC_LOG_MSG_FP_0738    738
#define FC_LOG_MSG_FP_0739    739
#define FC_LOG_MSG_FP_0740    740
#define FC_LOG_MSG_FP_0741    741
#define FC_LOG_MSG_FP_0742    742
#define FC_LOG_MSG_FP_0743    743
#define FC_LOG_MSG_FP_0744    744
#define FC_LOG_MSG_FP_0745    745
#define FC_LOG_MSG_FP_0746    746
#define FC_LOG_MSG_FP_0747    747
#define FC_LOG_MSG_FP_0748    748
#define FC_LOG_MSG_FP_0749    749
#define FC_LOG_MSG_FP_0750    750
#define FC_LOG_MSG_FP_0751    751
#define FC_LOG_MSG_FP_0752    752
#define FC_LOG_MSG_FP_0753    753
#define FC_LOG_MSG_FP_0754    754
#define FC_LOG_MSG_FP_0756    756

/* UNUSED */
/*
#define FC_LOG_MSG_FP_0800    800
*/

/* NODE LOG Message Numbers */
#define FC_LOG_MSG_ND_0900    900
#define FC_LOG_MSG_ND_0901    901
#define FC_LOG_MSG_ND_0902    902
#define FC_LOG_MSG_ND_0903    903
#define FC_LOG_MSG_ND_0904    904
#define FC_LOG_MSG_ND_0905    905
#define FC_LOG_MSG_ND_0906    906
#define FC_LOG_MSG_ND_0907    907
#define FC_LOG_MSG_ND_0908    908
#define FC_LOG_MSG_ND_0909    909
#define FC_LOG_MSG_ND_0910    910
#define FC_LOG_MSG_ND_0911    911
#define FC_LOG_MSG_ND_0912    912
#define FC_LOG_MSG_ND_0913    913
#define FC_LOG_MSG_ND_0914    914
#define FC_LOG_MSG_ND_0915    915
#define FC_LOG_MSG_ND_0916    916
#define FC_LOG_MSG_ND_0917    917
#define FC_LOG_MSG_ND_0918    918
#define FC_LOG_MSG_ND_0919    919
#define FC_LOG_MSG_ND_0920    920
#define FC_LOG_MSG_ND_0921    921
#define FC_LOG_MSG_ND_0922    922
#define FC_LOG_MSG_ND_0923    923
#define FC_LOG_MSG_ND_0924    924
#define FC_LOG_MSG_ND_0925    925
#define FC_LOG_MSG_ND_0926    926
#define FC_LOG_MSG_ND_0927    927
#define FC_LOG_MSG_ND_0928    928



/* MISC LOG Message Numbers */
#define FC_LOG_MSG_MI_1200  1200
#define FC_LOG_MSG_MI_1201  1201
#define FC_LOG_MSG_MI_1202  1202
#define FC_LOG_MSG_MI_1203  1203
#define FC_LOG_MSG_MI_1204  1204
#define FC_LOG_MSG_MI_1205  1205
#define FC_LOG_MSG_MI_1206  1206
#define FC_LOG_MSG_MI_1207  1207
#define FC_LOG_MSG_MI_1208  1208
#define FC_LOG_MSG_MI_1209  1209
#define FC_LOG_MSG_MI_1210  1210
#define FC_LOG_MSG_MI_1211  1211
#define FC_LOG_MSG_MI_1212  1212
#define FC_LOG_MSG_MI_1213  1213

/* LINK LOG Message Numbers */
#define FC_LOG_MSG_LK_1300  1300
#define FC_LOG_MSG_LK_1301  1301
#define FC_LOG_MSG_LK_1302  1302
#define FC_LOG_MSG_LK_1303  1303
#define FC_LOG_MSG_LK_1304  1304
#define FC_LOG_MSG_LK_1305  1305
#define FC_LOG_MSG_LK_1306  1306
#define FC_LOG_MSG_LK_1307  1307

/* SLI LOG Message Numbers */
#define FC_LOG_MSG_LK_1400  1400
#define FC_LOG_MSG_LK_1401  1401
#define FC_LOG_MSG_LK_1402  1402

/* CHK COMDITION LOG Message Numbers */
/*
#define FC_LOG_MSG_LK_1500  1500
*/
#endif /* _H_FCMSG */
