/*
 *	file	: asm/kmsgdump.h
 *	version	: 0.4.1/1999102301
 *	author	: Willy Tarreau <willy AT meta-x.org>
 *
 * Contents: several constants common to the ASM and C parts
 *
 */

/* LOG_BUF_LEN : should match </usr/src/linux/kernel/printk.c>'s */
#ifndef LOG_BUF_LEN
#define LOG_BUF_LEN     (16384)
#endif

#define	CODEORIGIN	0x0700
#define	TOPOFSTACK	0x0FB0
#define	BEGINOFMESSAGES	0x1000
#define FREEMEMORY	(BEGINOFMESSAGES+LOG_BUF_LEN)

#define BOOTSTACKFRAME	0xFB0	
#define	DRIVENUM	0xFF0
#define	TRACKNUM	0xFF1
#define MODEFLAGS	0xFF2

/* bits definitions for MODEFLAGS */
#define MASK_SYSRQMODE	0x80
#define MASK_OUTPUTFAT	0x40
#define MASK_PANICMAN	0x20
#define MASK_PANICDUMP	0x10
#define MASK_PANICBOOT	0x08
#define MASK_SAFEDUMP	0x04

/* type of function which requested a dump */
#define	DUMP_FROM_PANIC	0
#define	DUMP_FROM_SYSRQ	1

#ifdef __ASSEMBLY__

#define	CLOCKTICKS		0x46C
#define	VIDEOMODE		3
#define	HELPLINE		5
#define	BOTTOMLINE		24
#define	RIGHTCOL		79
#define	ATTRIB			0x1B
#define	HIGHLIGHT		0x1F

/* specify here the format of the diskette, 1.44 MB by default */
#define NBHEADS			2
#define	NBSECT			18
#define	NBTRACKS		80

/* let's compute some useful parameters from the diskette geometry */
#define	SECTPERCLUST		1
#define FIRSTCLUSTER		2

/* At the moment, most versions of gas are broken so you can't activate
   the following line which is the correct one. However, as long as the
   constant SECTPERCLUST equals 1, the next line can be used as a replacement.
   If you change the value of SECTPERCLUST, you'll have to change the
   definition of NBCLUSTERS WITHOUT involving the divide operation which older
   gas interpret as a comment. Versions from binutils 2.9.4 and later seem OK.
*/

#if THIS_GAS_IS_REALLY_GOOD
#  define	NBCLUSTERS		((NBHEADS*NBTRACKS*NBSECT)/SECTPERCLUST)
#else
#  define	NBCLUSTERS		(NBHEADS*NBTRACKS*NBSECT)
#endif

#define	FATSIZE			((NBCLUSTERS*3+1023)>>10)

#define STATUS_WAITING		0
#define STATUS_FORMATING	1
#define STATUS_DUMPING		2
#define STATUS_DUMPOK		3
#define STATUS_BOOTING		4
#define STATUS_HALTING		5
#define STATUS_PROBING		6
#define STATUS_PRINTING		7
#define STATUS_WERR		8
#define STATUS_MAXMSG		8

#define MKWORD(h,l)		((h)<<8|(l))

#else  /* C headers */

extern void kmsgdump(void);
extern void kmsgdump_end(void);

#endif

