/* Copyright (c) 1999 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include <mcheck.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include "nis_db.h"
#include "db_private.h"

#define MAX_TABLES 10

int
main (void)
{
  char *catalog_file = "data.dict";
  int i;

  mtrace ();

  /* Initialize the database backend */
  if (db_initialize (catalog_file) == FALSE)
    {
      fprintf (stderr, "db_initialize (%s) failed.\n", catalog_file);
      return 1;
    }

  for (i = 0; i < MAX_TABLES; ++i)
  {
    db_status status;
    char buf[255];

    sprintf (buf, "table_%.8d", i);
    status = db_table_exists (buf);
    if ( ((i % 2) == 0) && status == DB_SUCCESS)
      {
	fprintf (stderr, "db_table_exists (\"%s\") succed => error\n", buf);
	return 1;
      }
    if ( ((i % 2) == 1) && status != DB_SUCCESS)
      {
	fprintf (stderr, "db_table_exists (\"%s\") failed: %d\n", buf,
		 status);
	return 1;
      }

    if ((i % 2) == 1)
      db_destroy_table (buf);
  }

  muntrace ();

  unlink ("data.dict");
  unlink ("data.dict.log");

  return 0;
}
