/* Copyright (c) 1999 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <rpc/xdr.h>
#include <rpcsvc/nis.h>

#include "nis_db.h"
#include "db_private.h"
#include "nisdb_priv.h"
#include "xdb.h"

int
main (int argc, char *argv[])
{
  FILE *fp;
  XDR xdrs;
  xdb_logentry lentry;
  xdb_header header;

  fp = fopen (argv[1], "rb");
  if (fp == NULL)
    return FALSE;
  __close_on_exit (&fp);

  memset (&header, 0, sizeof (xdb_header));
  xdrstdio_create (&xdrs, fp, XDR_DECODE);
  if (!xdr_xdb_header (&xdrs, &header))
    {
      xdr_destroy (&xdrs);
      fclose (fp);
      return 1;
    }
  /* Read the logfile here */
  while (!feof (fp))
    {
      memset (&lentry, 0, sizeof (xdb_logentry));
      if (!xdr_xdb_logentry (&xdrs, &lentry))
	{
	  fclose (fp);
	  return 1;
	}
      switch (lentry.action)
	{
	case LOG_ADD:
	  {
	    table_t t_entry;

	    memset (&t_entry, 0, sizeof (t_entry));
	    t_entry.object = calloc (1, sizeof (table_obj));
	    if (t_entry.object == NULL)
	      return FALSE;
	    fprintf (stderr, "Load table %s from log\n",
		     lentry.table_name);

	    if (!__nisdb_xdr_table_obj (&xdrs, t_entry.object))
	      {
		fclose (fp);
		return FALSE;
	      }
	  }
	  break;
	case LOG_DELETE:
	  fprintf (stderr, "Delete table %s\n", lentry.table_name);
	  break;
	case LOG_IGNORE:
	  fprintf (stderr, "Ignore log entry for table %s\n",
		   lentry.table_name);
	  break;
	default:
	  fprintf (stderr, "Log file is broken.\n");
	  return FALSE;
	}
      xdr_free ((xdrproc_t) xdr_xdb_logentry, (caddr_t) &lentry);
    }

  xdr_destroy (&xdrs);

  return 0;
}
