#! /bin/perl -w
#
# dump a NIS+ Table to a file
#
# Nistool is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# Nistool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with the NIS+ Server; see the file COPYING.  If
# not, write to the Free Software Foundation, Inc., 675 Mass Ave,
# Cambridge, MA 02139, USA.
#
# Version: 0.1alpha
# Author: Ralf Lehmann <ralfl@darwin.muc.de>
#

use Nisplus;
use strict;

my $T;
my $F; 
my $append=0;
my $withheader=0;
my $RETSTR;

## Tables that can be dumped with nisaddent
my $STANDARD = "	aliases bootparams ethers group hosts netgroup netid netmasks networks passwd protocols rpc services shadow timezone";


if ($#ARGV < 1 || $#ARGV > 2 ) {usage();}
if ($ARGV[0] =~ /^-.*/) {
	$_ = shift @ARGV;
	$append=1 if /a/;
	$withheader=1 if /h/;
}
$T = shift @ARGV;
$F = shift @ARGV;

if (!($T =~ /.*\.$/)) {
	$!=1;
	die "Error: Tablename must be fully qualified.\n";
}
if (-e $F && !(-f $F)){ 
	$!=1;
	die "Error: $F exists but is not a File.\n";
}
my $name = Nisplus::get_first($T);
if ($name eq 'shadow'){
	$name = "passwd." . Nisplus::strip_first($T);
} else { $name = $T;}
my $o = Nisplus->new($name);
$o->getattr();
if ($RETSTR = $o->get_error()){
	$!=1;
	die "Error: $RETSTR\n";
}

my $FI = $F;
if ($append) {$FI = '>' . $FI;}	# uhh, dirty, dirty
if (!(open(FILE, ">$FI"))) {
	$!=1;
	die "Error: Can't open File $F: $!.\n";
}


dumptable();
close(FILE);
exit 0;


##
## dump a table
##
sub dumptable {
	my $opt = " ";
	my @out;

	if ($withheader){ $opt='-h';}
	if (is_standard_table($T)){
		dump_standard_table();
	}
	else {
		@out = `niscat -h $T`;
		if ($RETSTR = find_error(@out)) {
			print STDERR "Error: $RETSTR\n";
			exit 1;
		}
		print FILE @out;
	}
}


##
## dump a standard table
##
sub dump_standard_table{
	my $RETSTR;
	my $domain = Nisplus::strip_first($T);
	if (Nisplus::get_first($domain) ne 'org_dir'){
		$! = 1;
		die "Error: Standard Table $T not in org_dir directory\n";
	}
	$domain = Nisplus::strip_first($domain);
	my $tn = Nisplus::get_first($T);
	my @out = `nisaddent -d $tn $domain`;
	if ($RETSTR = find_error(@out)) {
		print STDERR "Error: $RETSTR\n";
		exit 1;
	}
	print FILE @out;
}


##
## is it a standard table?
##
sub is_standard_table{
	my $T = shift;
	my $NAME = Nisplus::get_first($T);
	if ($NAME eq 'cred') { $NAME = 'publickey'};
	if ($STANDARD =~ /$NAME/){
		return 1;
	}
	return 0;
}

##
## find an error in th eoutput string
##
sub find_error {
	my $RET;
	foreach (@_){
		if (/Error/ || /error/ || /cannot/) { 
			if (defined($RET)) {$RET .= $_ ; }
			else { $RET=$_;}
		}
	}
	return $RET;
}


sub usage {
	print STDERR "usage: $0 [-ah] table dumpfile\n";
	exit 1;
}
