#
# @(#) $Id: EventMgr.py,v 1.6 2003/08/20 18:58:57 ivm Exp $
#
# $Log: EventMgr.py,v $
# Revision 1.6  2003/08/20 18:58:57  ivm
# Implemented CPU power, round-robin-over-users scheduling inside queuei,
# other minor things.
#
# Revision 1.5  2003/07/02 17:52:24  ivm
# Fixed bug with unsubscribing from unknown section
#
# Revision 1.4  2001/04/20 17:41:25  ivm
# Fixed numerous bugs
#
# Revision 1.3  2001/04/03 16:04:31  ivm
# Fixed and tested Events
#
# Revision 1.1  2001/03/26 19:43:05  ivm
# Added EventManager
#
#

import fbs_misc
import bmgr_global
from TCPServer import *
from SockStream import *

#
# Methods to be called by Job/Section:
# ------------------------------------
# sectStateChanged(sid, newstate)         - when section is cancelled
# jobDeleted(jid)               - when the job is about to be deleted
# procSarted(sid, procno)       - when the process started successfully
# procExited(sid, procno)       - when the process exits
#
# Interface to Listener client:
# -----------------------------
# client -> event manager:
# subscribe(clnt, sid)
# unsubscribe(clnt, sid = (all))
#
# callbacks event manager -> client:
# sectionEvent(sid, event-type, arg)
#       types:  STATE   args:   newstate
#               DEL             ''
# processEvent(sid, pno, event-type, arg)
#       types:  START, EXIT
#       args: all '' for now
#

class	EventManager(TCPServer):
	def __init__(self, cfg, sel):
		self.Port = cfg.getValue('bmgr','*','event_mgr_port')
		if self.Port == None:
			self.Port = bmgr_global.G_NetworkIF.Port + 1
		self.Sel = sel
		TCPServer.__init__(self, self.Port, sel)
		self.Clients = {}		# sid -> [clients]
		
	def subscribe(self, clnt, sid):
		s = bmgr_global.G_JobFinder.getSection(sid)
		sstat = s.state()
		psts = []
		for ip in range(s.NProc):
			p = s.getProcess(ip+1)
			psts.append(p.Status)
		if not self.Clients.has_key(sid):
			self.Clients[sid] = []
		self.Clients[sid].append(clnt)
		return sstat, psts
			
	def unsubscribe(self, clnt, sid = None):
		if sid == None:
			slst = self.Clients.keys()
		else:
			slst = [sid]
		for sid in slst:
			if self.Clients.has_key(sid):
				lst = self.Clients[sid]
				lst1 = []
				found = 0
				for c in lst:
					if not c is clnt:
						lst1.append(c)
				if lst1:
					self.Clients[sid] = lst1
				else:
					del self.Clients[sid]
	
	def procStarted(self, sid, pno):
		if self.Clients.has_key(sid):
			self.sendProcessEvent(sid, pno, 'STATE', 'running')

	def procExited(self, sid, pno):
		if self.Clients.has_key(sid):
			self.sendProcessEvent(sid, pno, 'STATE', 'exited')

	def sectStateChanged(self, sid, newstate):
		if self.Clients.has_key(sid):
			self.sendSectionEvent(sid, 'STATE', newstate)

	def jobDeleted(self, jid):
		for sid in self.Clients.keys():
			jid1, sn = fbs_misc.decodeDotID(sid)
			if jid1 == jid:
				self.sendSectionEvent(sid, 'DEL', '')
				del self.Clients[sid]
		
	def sendSectionEvent(self, sid, etype, arg):
		for c in self.Clients[sid]:
			c.sectionEvent(sid, etype, arg)
			
	def sendProcessEvent(self, sid, pno, etype, arg):
		for c in self.Clients[sid]:
			c.processEvent(sid, pno, etype, arg)

	def createClientInterface(self, sock, addr, sel):
		EventManagerClient(self, sock, addr, sel)
		
class	EventManagerClient:
	def __init__(self, eventmgr, sock, addr, sel):
		self.EventMgr = eventmgr
		self.Sock = sock
		self.Addr = addr
		self.Sel = sel
		self.Sel.register(self, rd=sock.fileno())
		self.Str = SockStream(self.Sock)

	def doRead(self, fd, sel):
		if fd != self.Sock.fileno():
			return
		self.Str.readMore()
		while self.Str.msgReady():
			msg = self.Str.getMsg()
			words = string.split(msg)
			if not words:	continue
			if words[0] == 'SUBS':
				ans = self.doSubscribe(words, msg)
			elif words[0] == 'UNSUB':
				ans = self.doUnsubscribe(words, msg)
			else:
				ans = 'ERR Protocol error: <%s>' % msg
			if ans:
				self.Str.send(ans)
		if self.Str.eof():
			self.disconnect()

	def disconnect(self):
		self.EventMgr.unsubscribe(self)
		self.Sel.unregister(rd=self.Sock.fileno())
		self.Sock.close()
		self.Str = None

	# client interface			
	def doSubscribe(self, words, msg):
		# SUBS <sid>
		if len(words) < 2:
			return 'ERR Protocol error: <%s>' % msg
		sid = words[1]
		if bmgr_global.G_JobFinder.getSection(sid) == None:
			return 'NF Section <%s> not found' % sid
		sts, psts = self.EventMgr.subscribe(self, sid)
		str = sts
		for ps in psts:
			str = str + ' ' + ps
		return 'OK %s' % str

	def doUnsubscribe(self, words, msg):
		if len(words) == 1:
			# unsubscribe all
			self.EventMgr.unsubscribe(self)
		else:
			for sid in words[1:]:
				self.EventMgr.unsubscribe(self, sid)
		return 'OK'

	# event manager interface
	def sectionEvent(self, sid, etype, arg):
		self.Str.send('EVENT SECT %s %s %s' % (sid, etype, arg))
		
	def processEvent(self, sid, pno, etype, arg):
		self.Str.send('EVENT PROC %s %s %s %s' % (sid, pno, etype, arg))
