#
# @(#) $Id: FBSJobInfo.py,v 1.15 2001/03/13 15:59:00 ivm Exp $
#
# $Log: FBSJobInfo.py,v $
# Revision 1.15  2001/03/13 15:59:00  ivm
# Fixed bugs in object ownership
#
# Revision 1.14  2000/10/31 16:29:17  ivm
# Added Username
#
# Revision 1.13  2000/06/21 14:43:26  ivm
# Added killJob()
# Optimized EXITED/DEL part of launcher protocol
#
# Revision 1.12  2000/06/12 18:32:15  ivm
# Removed hold/release/kill job methods
#
# Revision 1.11  2000/06/09 16:41:53  ivm
# Fix use of Sections in JobInfo
# Delete corrupted sections
#
# Revision 1.10  2000/06/08 18:32:43  ivm
# Order sections by JDFSeq in FBSJobInfo.sections()
#
# Revision 1.9  2000/04/14 21:54:52  ivm
# Fixed UID/GID in refresh()
#
# Revision 1.8  2000/03/28 20:02:17  ivm
# Modified History and implemented some history functionality in FBSClient
#
# Revision 1.7  2000/03/22 19:30:26  ivm
# Implemented hold/release job/section
#
# Revision 1.6  2000/03/13 19:54:42  ivm
# Added sections() method
#
# Revision 1.4  2000/03/09 19:44:11  ivm
# Fixed bug with maxWords in job info
#
# Revision 1.1  2000/03/02 22:17:36  ivm
# Initial version, submit, get job/section, kill
#
#

import fbs_misc

class	FBSJobInfo:
	def __init__(self, fc, jid, hist = None):
		self.ID = jid
		self.Client = fc
		self.State = 'unknown'
		self.UID = -1
		self.GID = -1
		self.Username = 'unknown'
		self.Sections = {}		# sname -> JDF sequence number

	def refresh(self):
		pars, sects = self.Client._getJobInfo(self.ID)
		#print lst
		self.State, self.UID, self.GID, self.Username = tuple(pars)
		self.Sections = sects

	def _cmpSects(self, sn1, sn2):
		return self.Sections[sn1] - self.Sections[sn2]

	def sections(self):
		lst = self.Sections.keys()
		lst.sort(self._cmpSects)
		return lst

	def getSection(self, sname):
		if self.Sections.has_key(sname):
			return self.Client.getSection(
				fbs_misc.encodeSectionID(self.ID, sname))
		else:
			raise KeyError, 'Job %s does not have section %s' % (
					self.ID, sname)

	def kill(self, now = 0):
		return self.Client.killJob(self.ID, now)
