#
# @(#) $Id: FBSProcessInfo.py,v 1.13 2001/01/25 18:59:44 ivm Exp $
#
# $Log: FBSProcessInfo.py,v $
# Revision 1.13  2001/01/25 18:59:44  ivm
# More accurate CPU time accounting for just exited processes
#
# Revision 1.12  2000/08/08 17:11:17  ivm
# Renamed resource pool dictionaries to RsrcPoolDict
#
# Revision 1.11  2000/08/08 16:19:45  ivm
# Fixed user message sending from batch process to API
#
# Revision 1.10  2000/08/08 14:18:56  ivm
# Implemented pool dictionaries for SectionInfo and ProcessInfo
#
# Revision 1.9  2000/06/26 14:50:27  ivm
# Command will be sent from NetIF for process info
#
# Revision 1.8  2000/05/11 17:21:59  ivm
# Added r2shm and related code.
# Added SectOutput related code
#
# Revision 1.7  2000/04/25 21:46:44  ivm
# Fixed Suprocesses -> Subprocesses
#
# Revision 1.6  2000/04/21 20:42:08  ivm
# *** empty log message ***
#
# Revision 1.5  2000/04/17 15:44:15  ivm
# Do not question Launcher about non-running processes
#
# Revision 1.4  2000/04/10 20:28:40  ivm
# Fixed some bugs
#
# Revision 1.2  2000/04/03 16:31:51  ivm
# Implemented Section.getProcess()
#
# Revision 1.1  2000/03/31 23:13:34  ivm
# Implemented process status API - Launcher protocol
#
#

import fbs_misc
import sys
import Parser

class	FBSProcessInfo:
	def __init__(self, bpid, client = None):
		self.Client = client
		self.BPID = bpid
		self.UPID = 0
		self.Node = 'unknown'
		self.Status = 'unknown'
		self.Command = ''
		self.Message = ''
		self.CPUTime = 0
		self.ACPUTime = 0
		self.StartTime = 0
		self.EndTime = 0
		self.ExitCode = 0
		self.Core = 0
		self.Signal = 0
		self.Subprocesses = []
		self.LPDStr = ''
		self.GPDStr = ''
		self.RsrcPoolDict = {}
	
	def _fromNetIF(self, lst):
		#print 'FBSPI: fromNetIF: ', lst
		fbs_misc.deserializeObject(self, lst)
		self.RsrcPoolDict = {}
		if self.LPDStr:
			self.RsrcPoolDict = Parser.wordsToDict(self.LPDStr)
		if self.GPDStr:
			dict = Parser.wordsToDict(self.GPDStr)
			for k, v in dict.items():
				self.RsrcPoolDict[k] = v
		
	def _fromLauncher(self, lchpi):
		# copy information from FBSProcessInfo returned by Launcher
		for f in ['Command','Message']:
			try:	self.__dict__[f] = lchpi.__dict__[f]
			except: pass
		self.ACPUTime = max(self.ACPUTime, lchpi.ACPUTime)
		self.CPUTime = max(self.CPUTime, lchpi.CPUTime)
		self.Subprocesses = lchpi.Subprocesses + []

	def refresh(self, local_details = 1):
		if self.Status == 'exited':
			return
		jid, sname, inx = fbs_misc.decodeDotID(self.BPID)
		sid = fbs_misc.encodeSectionID(jid, sname)
		if self.Client != None:
			lst = self.Client._getPIFromBMGR(sid, inx)
			self._fromNetIF(lst)
		self.Subprocesses = []
		if local_details and self.Node != 'unknown' and \
							self.Status in ["running",'Running']:
			try:	lchpi = self.Client._getPIFromLch(self.Node, self.BPID)
			except KeyError:
				pass
			except:
				raise sys.exc_type, sys.exc_value
			else:
				#print 'getProcess: lchpi: ', lchpi.__dict__
				self._fromLauncher(lchpi)
