#@(#)$Id: GuiAdmin.py,v 1.21 2001/12/06 16:31:13 tlevshin Exp $
#@(#)$Author: tlevshin $
#@(#)$Log: GuiAdmin.py,v $
#@(#)Revision 1.21  2001/12/06 16:31:13  tlevshin
#@(#)added MaxNodeCount, CPU and Real Time Limit for Process Type
#@(#)
#@(#)Revision 1.20  2001/09/20 19:43:00  tlevshin
#@(#)get rid of reminder to restart launcher after changing local disk config
#@(#)
#@(#)Revision 1.19  2001/05/30 16:49:18  tlevshin
#@(#)*** empty log message ***
#@(#)
#@(#)Revision 1.18  2001/05/29 21:45:09  tlevshin
#@(#)fixed typo for remove process type
#@(#)
#@(#)Revision 1.17  2001/05/03 19:09:15  tlevshin
#@(#) fixed bugs in admin, change GuiBase to handle None in infoFormat
#@(#)
#@(#)Revision 1.16  2001/03/28 19:15:58  tlevshin
#@(#)added double list for action
#@(#)
#@(#)Revision 1.15  2001/03/27 20:29:54  tlevshin
#@(#)
#@(#)added double list for allow/disallow nodes, aceptable pt etc
#@(#)
#@(#)Revision 1.14  2001/03/18 20:22:56  tlevshin
#@(#)*** empty log message ***
#@(#)
#@(#)Revision 1.13  2001/03/18 19:58:47  tlevshin
#@(#)add authorized users, allow/disallow nodes to process type and queue
#@(#)
#@(#)Revision 1.12  2000/11/15 22:38:34  tlevshin
#@(#)checkAction (checkbutton returns string "1", or "")
#@(#)
#@(#)Revision 1.11  2000/10/25 21:17:45  tlevshin
#@(#)added removing resources to GuiAdmin
#@(#)implemented frozen screen and refresh button
#@(#)
#@(#)Revision 1.10  2000/09/22 14:39:25  tlevshin
#@(#)bug fixes
#@(#)
#@(#)Revision 1.9  2000/09/21 23:28:35  tlevshin
#@(#)*** empty log message ***
#@(#)
#@(#)Revision 1.8  2000/09/21 17:14:30  tlevshin
#@(#)*** empty log message ***
#@(#)
#@(#)Revision 1.7  2000/09/20 23:13:27  tlevshin
#@(#)bug fixes, admin improvments
#@(#)
#@(#)Revision 1.6  2000/09/13 17:17:25  tlevshin
#@(#)get rid of debuging prints
#@(#)
#@(#)Revision 1.5  2000/09/13 17:10:17  tlevshin
#@(#)modified gui according changes in api
#@(#)
#@(#)Revision 1.4  2000/09/11 17:31:58  tlevshin
#@(#)implemented setLocalDisks, fixed several bugs
#@(#)
#@(#)Revision 1.3  2000/09/01 13:43:14  tlevshin
#@(#)add range of node in Add/RemoveNode dialog
#@(#)
#@(#)Revision 1.2  2000/08/31 22:29:26  tlevshin
#@(#)some changes in Admin
#@(#)
#@(#)Revision 1.1  2000/08/24 22:14:12  tlevshin
#@(#) initial implemetation of dynamic administrator
#@(#)

from GuiBase import *
from FBS_API import FBSClient, FBSError
import string
import socket


#*************************************
#Class Administrator: allow to change*
#some configuration parameters       *  
#using FBS_API                       * 
#*************************************

class   List(Listbox):
        Options = {
                'vscroll' : ('VScrollEnabled', 1),
                'hscroll' : ('HScrollEnabled', 1)
        }

        def __init__(self, frame=None,cnf={}, **kw):
                if frame == None:
                        frame = Frame()
                        frame.pack(expand=YES, fill=BOTH)

                # set defaults
                for k, (fn, v) in self.Options.items():
                        self.__dict__[fn] = v

                # separate canvas options from our own
                cparams = {}
                for k, v in cnf.items() + kw.items():
                        if not self.Options.has_key(k):
                                cparams[k] = v
                        else:
                                fn, val = self.Options[k]
                                self.__dict__[fn] = v
                Listbox.__init__(self, frame, cparams)
                self.bind("<ButtonRelease-1>",self.select)
                frame.grid_columnconfigure(0, weight=1)
                frame.grid_rowconfigure(0, weight=1)
                self.grid(row=0, column=0, sticky='nswe')
                self.HScr = None
                if self.HScrollEnabled:
                        self.HScr = Scrollbar(frame, command=self.xview,
                                orient='horizontal')
                        self.configure(xscrollcommand = self.HScr.set)
                self.VScr = None
                if self.VScrollEnabled:
                        self.VScr = Scrollbar(frame, command=self.yview,
                                orient='vertical')
                        self.configure(yscrollcommand = self.VScr.set)
                self.bind('<Configure>', self.configureCbk)
                self.VShown = 0
                self.HShown = 0
                self.reply=[]
                self.config(selectmode=EXTENDED,setgrid=1)
                self.h=int(self.cget('height'))
                self.w=int(self.cget('width'))
        def resized(self):
                # to be called by subclass when drawn picture size changes
                # to check whether scroll bars need to be show or hidden
                #print 'resized'
                self.checkVisibility()

        def configureCbk(self, event):
                #print 'cfg cbk:', event.height, event.width
                self.checkVisibility(event.height, event.width)
	def checkVisibility(self, h=None, w=None):
            #print w,self.xview(),h,self.yview()
            if not h:
                if self.size()>self.h:
                    self.showVScr()
                else:
                    self.hideVScr()
            else:
                if self.yview()[1]<1.0:
                    self.showVScr()
                else:
                    self.hideVScr()
            if not w:
                for line in self.get(0,self.size()):
                    if len(line)>self.w:
                        self.showHScr()
                        return
                self.hideHScr()
            else:
                if self.xview()[1]<1.0:
                    self.showHScr()
                else:
                    self.hideHScr()
        def     showVScr(self):
                #print 'show V'
                if self.VScr and not self.VShown:
                        #print 'show V'
                        self.VScr.grid(row=0, column=1, sticky='ns')
                        self.VShown = 1

        def     hideVScr(self):
                #print 'hide V'

                if self.VScr and self.VShown:
                        #print 'hide V'
                        self.VScr.grid_forget()
                        self.VShown = 0

        def     showHScr(self):
                #print 'show H'
                if self.HScr and not self.HShown:
                        #print 'show H'
                        self.HScr.grid(row=1, column=0, sticky='we')
                        self.HShown = 1
        def     hideHScr(self):
                if self.HScr and self.HShown:
                        self.HScr.grid_forget()
                        self.HShown = 0

        def modifyList(self,infolist,action="replace"):
            if action=="replace":
                self.delete(0,END)
            try:
                lenInfo=len(infolist)
            except:
                lenInfo=0

            if action in ["replace","insert"]:
                min=0
            elif action=="append":
                min=self.size()
            else:
                #print "unknown action",action
                return
	    if not lenInfo:
		self.resized()
		return
	    for i in range(min,lenInfo):
                self.insert(i,infolist[i])
            self.reply.append(self.get(0))
            self.resized()
            self.selection_set(0)
        def select(self,event):
            index=self.curselection()
            self.reply=[]
            for ind in index:
                self.reply.append(self.get(string.atoi(ind)))
            #print self.reply

class DblList:
    def __init__(self,parent,rinfo=[],rlbl="",linfo=[],llbl=""):
	self.parent=parent
	self.rinfo=rinfo
	self.linfo=linfo
	frame=Frame(self.parent)
        frame.pack(side=TOP,expand=YES,fill=BOTH)
        fr=Frame(frame)
        fr.pack(side=RIGHT,expand=YES,fill=BOTH)
        f1=Frame(fr)
        f1.pack(side=TOP,expand=YES,fill=BOTH)
        Label(f1,text=rlbl,foreground='black').\
		     pack(side=TOP,anchor=W,expand=NO)
        f2=Frame(fr)
        f2.pack(side=BOTTOM,expand=YES,fill=BOTH)
        self.listRight=List(f2,{'font':'10x20','bg':'pink',\
                                   'fg':'black','exportselection':0,\
                                   'relief':SUNKEN})

        fr=Frame(frame)
        fr.pack(side=LEFT,expand=YES,fill=BOTH)
        f1=Frame(fr)
        f1.pack(side=TOP,expand=YES,fill=BOTH)
        Label(f1,text=llbl,foreground='black').\
                                 pack(side=TOP,anchor=W,expand=NO)
        f2=Frame(fr)
	f2.pack(side=BOTTOM,expand=YES,fill=BOTH)
        self.listLeft=List(f2,{'font':'10x20','bg':'pink',\
                                  'fg':'black','exportselection':0})
        self.listLeft.modifyList(linfo)
        self.listRight.modifyList(rinfo)
        frCntr=Frame(frame)
        frCntr.pack(side=BOTTOM,anchor=CENTER,padx='3m', pady='20m')
        self.butDel=Button(frCntr,text="X",command=self.delete)
        self.butDel.pack(side=BOTTOM,anchor=CENTER,fill=BOTH)
        self.butLeft=Button(frCntr,text="-->",command=self.right)
        self.butLeft.pack(side=BOTTOM,anchor=CENTER,fill=BOTH)

    def delete(self):
        for cmpnt in self.listRight.reply:
	    if cmpnt in self.rinfo:
		self.rinfo.remove(cmpnt)
        self.listRight.modifyList(self.rinfo)
    def right(self):
        for cmpnt in self.listLeft.reply:
            if cmpnt not in self.rinfo:
                self.rinfo.append(cmpnt)
        self.listRight.modifyList(self.rinfo)
    def add(self,info):
	self.rinfo=[]
	for cmpnt in info:
                self.rinfo.append(cmpnt)
        self.listRight.modifyList(self.rinfo)

class Administrator:
    def __init__(self,master,fc,funcName,pref):
	self.fc=fc
	self.title=funcName
	self.master=master
	self.cancel=1
	self.funcName=funcName
	self.top=None
	if self.funcName=='verify':
	    self.verify(pref)
	    return
	self.setArg()
	self.getValue()
    
	
    def setArg(self):
	self.funcDict={
	    "createLocalResource":{"title":"Create Local Resource",\
			    "ArgList":[("name","","local resource name",\
				       "(string)")]},\
	    "removeLocalResource":{"title":"Remove Local Resource",\
			    "ArgList":[("name","","local resources",\
				       "(string)")]},\
	    "createGlobalResource":{"title":"Create Global Resource",\
				 "ArgList":[("name","","global resource name",\
					     "(string)"),\
				       ('capacity','int',"resource capacity",\
					"(integer)")]},\
	    "removeGlobalResource":{"title":"Remove Global Resource",\
				 "ArgList":[("name","","global resources",\
					     "(string)")]},\
	    "setGlobalResource":{"title":"Set Global Resource",\
			 "ArgList":[("name",'',"Availble Global Resources:"),\
				    ('capacity','int',"resource capacity",\
				     "(integer)")]},\
	    "createRsrcPool":{"title":"Create Resource Pool",\
		      "ArgList":[("name",'',"pool name","(string)"),\
				 ("rsrc_lst",[],"resources",\
				  "(<resource name>,...)")]},\
	    "removeRsrcPool":{"title":"Remove Resource Pool",\
		      "ArgList":[("name",'',"pools","(string)")]},\
	    "setRsrcPool":{"title":"Set Resource Pool",\
		    "ArgList":[("name",'',"Available Pools:"),\
			       ("rsrc_lst",[],"resources",\
				"(<resource name>,...)")]},\
	    "createNodeClass":{"title":"Create Node Calss",\
		       "ArgList":[("name",'',"node class name","(string)"),\
				  ("rsrc_dict",{},'resources:',\
				   "(<resource name>=<capacity>,...)"),\
				  ("lcl_disk",{},'local disks',\
				   '(<disk name>=<root directory>,...)')]},\
	    "removeNodeClass":{"title":"Remove Node Calss",\
		       "ArgList":[("name",'',"node classes","(string)")]},\
	    "setRsrcCap":{"title":"Set Resource Capacity",\
		  "ArgList":[("name",'int',"Available Node Classes:"),\
			     ("rsrc_dict",{},'resources:',\
			      "(<resource name>=<capacity>,...)")]},\
	    "setLocalDisks":{"title":"Set Local Disks",\
		     "ArgList":[('name','',"Available Node Classes:"),\
				("lcl_disk",{},'local disks',\
				 '(<disk name>=<root directory>,...)')]},\
	    "addNode":{"title":"Add Node",\
	       "ArgList":[('name','','Available Node Classes:'),\
			  ('node_rng','range','nodes',\
			   '<node name>,..or/and <node base name> num1 num2')]},\
	    "removeNode":{"title":"Remove Node",\
		  "ArgList":[('name','','Available Node Classes:'),\
			     ('node_rng','range','nodes',\
			      '<node name>,..or/and <node base name> num1 num2')]},\
	    "createProcessType":{"title":"Create Process Type",\
			 "ArgList":[('name','','process type name',"(string)"),\
				    ('srsrc_dict',{},'section resources',\
				     '(<resource name>=<capacity>,...)'),\
				    ('prsrc_dict',{},'process resources',\
				     '(<resource name>=<capacity>,...)'),\
				    ('qrsrc_dict',{},'resource quota',\
				     '(<resource name>=<quota>,...)'),\
				    ('maxInc','int',\
				     'maximum allowed priority increment',\
				     '(integer)'),
				    ('maxNodeCount','int',\
				     'maximum node count','(integer)'),\
				    ('CpuTimeLimit','int','cpu time limit',\
				     '(intger)'),\
				    ('RealTimeLimit','int','real time limit',\
				     '(integer)'),]},\
	    "removeProcessType":{"title":"Remove Process Type",\
			 "ArgList":[('name','','process types',"(string)")]},\
	    "setSectRsrcDefs":{"title":"Set Section Resources",\
		      "ArgList":[('name','','Available Process Types:'),\
				 ('prsrc_dict',{},'section resources',\
				  '(<resource name>=<capacity>,...)')]},\
	    "setProcRsrcDefs":{"title":"Set Process Resources",\
		       "ArgList":[('name','','Available Process Types:'),\
				  ('prsrc_dict',{},'process resources',\
				   '(<resource name>=<capacity>,...)')]},\
	    "setRsrcQuota":{"title":"Set Resource Quota",\
		    "ArgList":[('name','','Available Process Types:'),\
			       ('qrsrc_dict',{},'resource quota',\
				'(<resource name>=<quota>,...)')]},\
	    "setMaxPrioInc":{"title":"Set Maximum Priority Inc",\
		     "ArgList":[('name','','Available Process Types:'),\
				('maxInc','int',\
				 'maximum allowed priority increment',\
				 '(integer)')]},\
	    "setUsers":{"title":"Set Authorized Users",\
		       "ArgList":[('name','','Available Process Types:'),\
				  ('Users',[],'authorized users',\
				   "(<user name>,... or <*>)")]},\
	   		
	    "allowNodes":{"title":"Set Nodes Allowed for Submission",\
		       "ArgList":[('name','','Available Process Types:'),\
				  ('NodesAllow',[],'allowed nodes',\
				   "(<node name>,... or <*>)")]},\
	    
	    "disallowNodes":{"title":"Set Nodes Disallowed for Submission",\
		       "ArgList":[('name','','Available Process Types:'),\
				  ('NodesDisAllow',[],'disallowed nodes',\
				   "(<node name>,... or <*>)")]},\
	    "setMaxNodeCount":{"title":"Set Max Node Count",\
		      "ArgList":[('name','','Available Process Types:'),\
				  ('maxNodeCount','int',\
				   'maximum node count',\
				   '(integer)')]},\
	    "setCPUTimeLimit":{"title":"Set CPU Time Limit",\
		       "ArgList":[('name','','Available Process Types:'),\
				  ('CPUTimeLimit','int',\
				   'cpu time limit',\
				   '(integer)')]},\
	    "setRealTimeLimit":{"title":"Set Real Time Limit",\
		       "ArgList":[('name','','Available Process Types:'),\
				  ('RealTimeLimit','int','real time limit',\
				   '(integer)')]},\
    
	    "createQueue":{"title":"Create Queue",\
		   "ArgList":[('name','',"queue name","(string)"),\
			      ('type','',"Available Process Types:")]},\
	    "removeQueue":{"title":"Remove Queue",\
		   "ArgList":[('name','',"queues","(string)")]},\
	    "update":{"title":"Set Queue Parameters",\
		      "ArgList":[('name','',"Available Queues:"),\
			 ('DefProcType','','default process type',"(string)"),\
                         
			 ('Users',[],'authorized users',"(<user name>,,... or <*>)"),\
			 ('QPGap','int',"queue priority gap",'(integer)'),\
			 ("QPInc",'int',"queue priority increment",'(integer)'),\
			 ('QPDec','int','queue priority decrement','(intger)'),\
			 ("MaxQPrio",'int',"maximal queue priority",'(intger)'),\
			 ("MinQPrio",'int',"minimal queue priority",'(intger)'),\
			 ("SPGap",'int',"section priority gap",'(integer)'),\
			 ("MaxSPrio",'int',"maximal section priority",\
			  '(intger)'),\
			 ('Prio','int','priority','(intger)'),\
			 ('RealTimeLimit','int','real time limit','(intger)'),\
			 ('CPUTimeLimit','int','cpu time limit','(integer)'),\
			 ('ProcTypes',[],'acceptable process types',\
			  "(<process type>,... or <*>)")]},\
	    "holdQueue":{"title":"Hold Queues",\
			 "ArgList":[("queue_name",[],"Available Queues:")]},\
	    "releaseQueue":{"title":"Release Queues",\
			 "ArgList":[("queue_name",[],"Available Queues:")]},\
	    "lockQueue":{"title":"Lock Queues",\
			 "ArgList":[("queue_name",[],"Available Queues:")]},\
	    "unlockQueue":{"title":"Unlock Queues",\
			 "ArgList":[("queue_name",[],"Available Queues:")]},\

	    "holdNode":{"title":"Hold Nodes",\
			 "ArgList":[("node_name",[],"Available Nodes:"),\
				    ("reason","","reason for holding nodes",\
				     '(string)')]},\
	    "releaseNode":{"title":"Release Nodes",\
			 "ArgList":[("node_name",[],"Available Nodes:")]}
	    }
	self.argList=self.funcDict[self.funcName]["ArgList"]
	for tup in self.argList:
	    self.__dict__[tup[0]]=""
	
    
	    
    def createButtons(self,text,ind,list,type="radio"):
	global act
	f=Frame(self.top)
	f.pack(anchor=W,expand=YES,fill=X)
	Label(f,text=text,background='white',\
	      foreground='black').pack\
	      (side=TOP,anchor=W)
	i=0
	k=0
	act=[]
	dict={}
	fr=Frame(f)
	fr.pack(side=LEFT)
	for name in list:
	    if i==5:
		fr=Frame(f)
		fr.pack(side=LEFT,anchor=NW)
		i=0
	    if type=="radio":
		r=Radiobutton(fr,text=name,variable=s[ind],value=name,\
			      anchor=W,command=self.update)
	    elif type=="check":
		dict[name]=""
		s1=StringVar()
		s1.set(dict[name])
		if not k:
		    act=[s1]
		else:
		    act.append(s1)
		r=Checkbutton(fr,text=name,variable=act[k],\
			      anchor=W)
		if k==len(list):
		    break
		k=k+1
	    r.pack(fill=X)
	    i=i+1

    def update(self):
	name=s[0].get()
	if  self.funcName in ["update"]:
	    try:
		
		obj=self.fc.getQueue(name)
	
	    except KeyError,reason:
		tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  reason)
		return
	    except ValueError,reason:
		tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  reason)
		return
	    except FBSError,reason:
		tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  reason)
		return
	    except socket.error:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),\
				  "Lost connection with Batch Manager")	    
		return
	    i=1
	    l=0
	    for item in self.argList[1:]:
		if item[0]=='ProcTypes':
		     self.List.add(obj.__dict__[item[0]])
		     continue
		if item[1]==[]:
		    s[i].set(string.joinfields(obj.__dict__[item[0]],','))
		else:
		    s[i].set(obj.__dict__[item[0]])
		i=i+1
	    return
	else:	
	    if self.funcName in ["setGlobalResource"]:
		tmp=self.fc.getGlobalResource(name)
		s[1].set(tmp[1])
		return
	    elif  self.funcName in ["setSectRsrcDefs","setProcRsrcDefs",\
				    "setRsrcQuota","setMaxPrioInc",\
				    "setMaxNodeCount","setCPUTimeLimit",\
				    "setRealTimeLimit",\
				    "setUsers","allowNodes","disallowNodes"]:
		try:
			pt=self.fc.getProcessType(name)
		except KeyError,reason:
		    tkMessageBox.showinfo('Dynamic Config Failure'+\
					  getCluster(),reason)
		    return
		except ValueError,reason:
		    tkMessageBox.showinfo('Dynamic Config Failure'+\
					  getCluster(),reason)
		    return
		except FBSError,reason:
		    tkMessageBox.showinfo('Dynamic Config Failure'+\
					  getCluster(),reason)
		    return
		except socket.error:
		    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),\
				 "Lost connection with Batch Manager")	
		    return
		trMap={"setProcRsrcDefs":"ProcRsrcDefaults",\
		       "setSectRsrcDefs":"SectRsrcDefaults",\
		       "setRsrcQuota":"RsrcQuota",\
		       "setMaxPrioInc":"MaxPrioInc",\
		       "setMaxNodeCount":"MaxNodeCount",\
		       "setCPUTimeLimit":"CPUTimeLimit",\
		       "setRealTimeLimit":"RealTimeLimit",\
		       "setUsers":"Users","allowNodes":"NodesAllow",\
		       "disallowNodes":"NodesDisallow"}
		
		val=trMap[self.funcName]
		if self.funcName in ["setMaxPrioInc","setMaxNodeCount",\
				     "setCPUTimeLimit",  "setRealTimeLimit"]:
		    s[1].set(pt.__dict__[val])
		    return
		if self.funcName in ["setUsers"]:
		    tmp=string.joinfields(pt.__dict__[val],',')
		    s[1].set(tmp)
		    return
		elif self.funcName in ["allowNodes","disallowNodes"]:
		    self.List.add(pt.__dict__[val])
		    return
		else:
		    tmp=repr(pt.__dict__[val])
	    elif self.funcName=="setRsrcPool":
		tmp=repr(self.fc.getResourcePool(name))
	    
	    elif self.funcName in  ["setRsrcCap"]:
		nc=self.fc.getNodeClass(name)
		tmp=repr(nc.ResourceCap)
	    elif  self.funcName in  ["setLocalDisks"]:
		nc=self.fc.getNodeClass(name)
		self.oldLocalDisks=nc.LocalDisks
		tmp=repr(nc.LocalDisks)
	    elif  self.funcName in ["removeNode"]:
		tmp=""
		for node in self.fc.getNodeList(name):
		    tmp="%s,%s" % (tmp,node)
		s[1].set(tmp[1:])
		return
	    else:
		return
	    tmp1=""
	    for i  in range(1,len(tmp[:-1])):
		if tmp[i] in ["'",'"'," "]:
		    continue
		if tmp[i]==":":
		    ch="="
		else:
		    ch=tmp[i]
		tmp1=tmp1+ch
	    s[1].set(tmp1)


    def setValue(self,s):
	self.top = Toplevel(self.master)
	self.top.title(self.funcDict[self.funcName]["title"]+getCluster())
	self.frame=Frame(self.top)
	self.frame.pack(side='left',expand=YES,fill=BOTH)
	i=0
	if string.find(self.funcName,"create"):
	    try:
		if self.funcName in ["removeProcessType","setSectRsrcDefs",\
				     "setProcRsrcDefs",\
				     "setRsrcQuota","setMaxPrioInc",
				     "setMaxNodeCount","setCPUTimeLimit",\
				     "setRealTimeLimit",\
				     "setUsers","allowNodes","disallowNodes"]:
		    lst=self.fc.getProcessTypeList()
		elif  self.funcName in ["removeQueue","update","holdQueue",\
					"releaseQueue",\
					"lockQueue","unlockQueue"]:
		    lst=self.fc.getQueueList()
		elif  self.funcName in ["holdNode","releaseNode"]:
		    lst=self.fc.getNodeList()
		elif self.funcName in  ["removeNodeClass","removeNode",\
					"addNode",\
					"setRsrcCap","setLocalDisks"]:
		    lst=self.fc.getNodeClassList()
		elif self.funcName in ["removeGlobalResource",\
				       "setGlobalResource"]:
		    lst=self.fc.getGlobalRsrcList()
		elif self.funcName in ["removeLocalResource"]:
		    lst=self.fc.getLocalRsrcList()
		elif self.funcName in ["removeRsrcPool","setRsrcPool"]:
		    lst=self.fc.getGlobalPoolList()+\
			 self.fc.getLocalPoolList()
	    except ValueError,reason:
		tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
					       reason)
		return
	
	    except KeyError,reason:
		tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  reason)
		return 
	
	    except FBSError,reason:
		tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  reason)
		return 
	    except socket.error:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),\
				  "Lost connection with Batch Manager")
		return
	#	self.createButtons(self.argList[0][2],0,lst,'check')
	    if self.funcName in ["holdQueue","releaseQueue",\
				 "lockQueue","unlockQueue",\
				 "holdNode","releaseNode",\
				 "removeQueue","removeNodeClass",\
				 "removeProcessType","removeLocalResource",\
				 "removeGlobalResource","removeRsrcPool"]:
		rinfo=[]
		linfo=[]
		llbl=""
		rlbl=""
		f=Frame(self.top)
		f.pack(anchor=W,expand=YES,fill=X)
		if self.funcName=='holdQueue':
		    for qn in lst:
			q=self.fc.getQueue(qn)
			if q.IsHeld:
			    rinfo.append(qn)
		    rlbl="Held Queues:"
		    linfo=lst
		    llbl='Available Queues:'
		elif self.funcName=='releaseQueue':
		    for qn in lst:
			q=self.fc.getQueue(qn)
			if q.IsHeld:
			    linfo.append(qn)
		    llbl="Held Queues:"
		    rlbl="Released Queues:"
		elif self.funcName=='lockQueue':
		     for qn in lst:
			 q=self.fc.getQueue(qn)
			 if q.IsLocked:
			    rinfo.append(qn)
		     rlbl="Locked Queues:"
		     linfo=lst
		     llbl='Available Queues:'
		elif self.funcName=='unlockQueue':
		    for qn in lst:
			q=self.fc.getQueue(qn)
			if q.IsLocked:
			    linfo.append(qn)
		    llbl="Locked Queues:"
		    rlbl="Released Queues:"
		elif self.funcName=="holdNode":
		    for nn in lst:
			n=self.fc.getNode(nn)
			if n.IsHeld:
			    rinfo.append(nn)
		    rlbl="Held Nodes:"
		    linfo=lst
		    llbl="Available Nodes:"
		elif self.funcName=="releaseNode":
		    for nn in lst:
			n=self.fc.getNode(nn)
			if n.IsHeld:
			    linfo.append(nn)
		    llbl="Held Nodes:"
		    rlbl="Released Nodes:"
		elif self.funcName in ["removeQueue",\
				       "removeNodeClass",\
				 "removeProcessType","removeLocalResource",\
				 "removeGlobalResource","removeRsrcPool"]:
		    linfo=lst
		    llbl='Available %s:' % (self.argList[0][2])
		    rlbl='Selected for deletion:'
		self.createList(f,rinfo=rinfo,rlbl=rlbl,\
				linfo=linfo,llbl=llbl)
	    else:
		self.createButtons(self.argList[0][2],0,lst)
	    i=1
	if self.funcName=="createQueue":
	    lst=self.fc.getProcessTypeList()
	    if not len(lst):
		tkMessageBox.showinfo('Dynamic Config Warning'+\
				      getCluster(),\
				      "Please, create Process Type first!")
		return
	for tup in self.argList[i:]:
	    if self.funcName=="createQueue" and i==1:
		self.createButtons(self.argList[1][2],1,lst)
		i=i+1
		continue
	    f=Frame(self.top)
	    f.pack(anchor=W,expand=YES,fill=X)
	    word=tup[2]
	    if len(tup)==4:
		word=word+tup[3]
	    width=40
	    w=len(word)
	    if w > width:
		width=w
	    if  self.funcName=="update" and tup[0]=='ProcTypes':
		self.createList(f,rinfo=[],rlbl="Acceptable Process Types:",\
				linfo=['*']+self.fc.getProcessTypeList(),\
				llbl='Available Process Types:')	
	    elif self.funcName=='allowNodes':
		self.createList(f,rinfo=[],rlbl="Allowed Nodes:",\
				linfo=['*']+self.fc.getNodeList(),\
				llbl='Available Nodes:')
	    elif self.funcName=='disallowNodes':
		self.createList(f,rinfo=[],rlbl="Disallowed Nodes:",\
				linfo=['*']+self.fc.getNodeList(),\
				llbl='Available Nodes:')
	    else:
		Label(f,text=word+':',relief=RIDGE,width=width,background='white',\
		      foreground='black').pack(side=LEFT,padx=2,pady=1,ipadx=2,ipady=2)
		e=Entry(f,textvariable=s[i], relief=SUNKEN,
		       background='pink',width=20)
		e.pack(side=RIGHT,expand=YES,fill=X)
		e['textvariable']=s[i]
	    i=i+1
    	ButtonCheck(self.top,self,0,'OK','left')
	ButtonCheck(self.top,self,1,'Cancel','right')

    def getValue(self):
	global s
	s=[]
	i=0
	for tup in self.argList:
	    s1=StringVar()
	    s1.set(self.__dict__[tup[0]])
	    s.append(s1)
	    i=i+1
	self.setValue(s)

    def checkQueue(self):
	name=s[0].get()
	try:
	    if self.funcName=="createQueue":
		if not len(name):
		     tkMessageBox.showinfo('Dynamic Config Failure'+\
				       getCluster(),\
				       "Please, enter queue name")
		     return 1
		procType=s[1].get()
		if not len(procType):
			procType=None
		qi=self.fc.createQueue(name,procType)
	    else:
		qi=self.fc.getQueue(name)
	except ValueError,reason:
	    tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  reason)
	    return 1
	
	except KeyError,reason:
	    tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  reason)
	    return 1
	
	except FBSError:
	    tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  'You have to select Queue name')
	    return 1
	except:
	     tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  'Error %s ,%s' % \
				   (sys.exc_type,sys.exc_value))
	     return 1
	if self.funcName=="createQueue": return 0
	try:
	    i=1
	    for tup in self.argList[1:]:
		if tup[0]=='ProcTypes':
		    qi.__dict__[tup[0]]=self.List.rinfo+[]
		    continue
		tp=tup[1]
		if tp=='int':
		    val=s[i].get()
		    try:
			val=string.atoi(val)
		    except:
			if len(val)>0:
			    tkMessageBox.showinfo('Dynamic Config Failure'+\
				     getCluster(),\
				     "Value of %s should be integer" % \
				    self.argList[i][2])
			    return 1
			else:
			    val=qi.__dict__[tup[0]]
		elif tp=='':
		    val=s[i].get()
		    if not len(val):
			tkMessageBox.showinfo('Dynamic Config Failure'+\
				      getCluster(),\
				      "%s  should be set" % (tup[2],))
			return 1
		elif tp==[] :
		    val=string.splitfields(s[i].get(),',')
		else:
		    tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				      'Not a valid type')
		    return 1
		    
		qi.__dict__[tup[0]]=val
		i=i+1
	    retVal,reason=qi.update()
	    if retVal:
		return 0
	    else:
		tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				      reason)
		return 1
	except KeyError,reason:
	    tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  reason)
	    return 1
	except FBSError,reason:
	    tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),reason)
	    return 1
	except socket.error:
	    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),\
				  "Lost connection with Batch Manager")
	    return 1
    def getRsrcDict(self,var):
	  rsrcDict={}
	  if var==None or var=="None" or var=="":
	      return 0,rsrcDict
	  rsrc=string.splitfields(var,',')
	  for pair in rsrc:
	      try:
		  tmp=string.splitfields(pair,'=')
		  key=string.strip(tmp[0])
		  val=string.strip(tmp[1])
		  if string.find(val,'None')>=0:
		      rsrcDict[key]=None
		  elif len(val)==0:
		      rsrcDict[key]=None
		  else:
		      try:
			  if self.funcName=="setLocalDisks":
			      rsrcDict[key]=val
			  else:
			      rsrcDict[key]=string.atoi(val)
		      except ValueError:
			  tkMessageBox.showinfo('Dynamic Config Failure'\
						+getCluster(),\
						"Value %s should be integer or None" \
						% key)
			  return 1,rsrcDict
	      except:
		  tkMessageBox.showinfo('Dynamic Config Failure'\
					+getCluster(),\
				       "Should enter resources: <name>=<capacity>,..." )
		  return 1,rsrcDict
	  return 0,rsrcDict
    def checkProcType(self):
	name=s[0].get()
	i=1
	if  self.funcName=="createProcessType":
	    if not len(name):
		tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  'You have to enter process type name')
		return 1
	    try:
		if name in self.fc.getProcessTypeList():
		    tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  'Process type name %s already exists' % name)
		    return 1
		retVal,secRsrcDict=self.getRsrcDict(s[1].get())
		if retVal:
		    return 1
		for glblRsrc in secRsrcDict.keys(): 
		    res=self.fc.getGlobalResource(glblRsrc)
		retVal,procRsrcDict=self.getRsrcDict(s[2].get())
		if retVal:
		    return 1
		lst=self.fc.getLocalRsrcList()
		for lclRsrc in procRsrcDict.keys(): 
		    if lclRsrc not in lst:
			raise KeyError,"Inavlid local resource %s" % lclRsrc
		if not len(procRsrcDict):
		    if not tkMessageBox.askokcancel("Dynamic Config Warning"+\
			  getCluster(),"Do you really want to create the process type without local resources?"):
			return 1
		retVal,quotaRsrcDict=self.getRsrcDict(s[3].get())
		if retVal:
		    return 1
		lst=self.fc.getLocalRsrcList()+self.fc.getGlobalRsrcList()
		for rsrc in quotaRsrcDict.keys(): 
		    if rsrc not in lst:
			raise KeyError,"Inavlid resource %s" % rsrc
		param={'maxInc':None,'maxNodeCount':None,'CPUTimeLimit':-1,\
		       'RealTimeLimit':-1}
		k=4
		for key  in ['maxInc','maxNodeCount','CPUTimeLimit','RealTimeLimit']:
		    var=s[k].get()
		    if var!="":
			try:
			    param[key]=string.atoi(var)
			except ValueError:
			    tkMessageBox.showinfo('Dynamic Config Failure'\
					      +getCluster(),\
					      "The value of this parameter should be integer or %s" % (param[key],))
			    return 1
		    k=k+1
		pt=self.fc.createProcessType(name)
		if len(secRsrcDict):
		    retVal,reason=pt.setSectRsrcDefs(secRsrcDict)
		    if not retVal:
			tkMessageBox.showinfo('Dynamic Config Failure'\
					      +getCluster(),\
					      reason+"Process type %s has been created" 
						  % name)
			return 0
		if len(procRsrcDict):
		    retVal,reason=pt.setProcRsrcDefs(procRsrcDict)
		    if not  retVal:
			tkMessageBox.showinfo('Dynamic Config Failure'\
					  +getCluster(),\
					      reason+"Process type %s is created" 
					      % name)
			return 0
		if len(quotaRsrcDict):
		    retVal,reason=pt.setRsrcQuota(quotaRsrcDict)
		    if not retVal:
			tkMessageBox.showinfo('Dynamic Config Failure'\
					      +getCluster(),\
					      reason+"Process type %s is created" 
					      % name)
			return 0	
		i=0
		funcName=["MaxPrioInc","MaxNodeCount","CPUTimeLimit",\
			  "RealTimeLimit"]
		for key in ['maxInc','maxNodeCount','CPUTimeLimit',\
			    'RealTimeLimit']:
		    func="pt.set%s(%s)"%(funcName[i],param[key])
		    retVal,reason=eval(func)
		    if not retVal:
			tkMessageBox.showinfo('Dynamic Config Failure'\
					      +getCluster(),\
					      reason+"Process type %s is created" 
					      % name)
			return 0
		    i=i+1
		return 0
	    except KeyError,reason:
		tkMessageBox.showinfo('Dynamic Config Failure'+\
				      getCluster(),reason)
		
		return 1
	    except ValueError,reason:
		tkMessageBox.showinfo('Dynamic Config Failure'+\
				      getCluster(),reason)
		return 1
	    except socket.error:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),\
				      "Lost connection with Batch Manager")
		return 1
	    except FBSError:
		tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				      'Failed to create process type')
		return 1
	    except:
		tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				      'Something is terribly wrong!')
		return 1

	else:
	    try:
		pt=self.fc.getProcessType(name)
	    except KeyError,reason:
		tkMessageBox.showinfo('Dynamic Config Failure'+\
				      getCluster(),reason)
		return 1
	    except ValueError,reason:
		tkMessageBox.showinfo('Dynamic Config Failure'+\
				      getCluster(),reason)
		return 1
	    except socket.error:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),\
				      "Lost connection with Batch Manager")
		return 1
	    except FBSError:
		tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				      'You have to select Process type')
		return 1
	    except:
		tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				      'You have to select Process type')
		return 1

	return self.checkValue(pt,1)

    def checkNodeClass(self):
	node_class=s[0].get()
	if self.funcName=="createNodeClass":
	    if not len(node_class):
		tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  'You have to enter node class name')
		return 1
	    try:
		if node_class in self.fc.getNodeClassList():
		    tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  'Node class name %s already exists' % \
					  node_class)
		    return 1
		retVal,rsrcDict=self.getRsrcDict(s[1].get())
		if retVal:
		    return 1
		lst=self.fc.getLocalRsrcList()
		for lclRsrc in rsrcDict.keys(): 
		    if lclRsrc not in lst:
			raise KeyError,"Inavlid local resource %s" % lclRsrc
		self.funcName="setLocalDisks"   
		retVal,lclDiskDict=self.getRsrcDict(s[2].get())
		self.funcName="createNodeClass"
		if retVal:
		    return 1
		for disk in lclDiskDict.keys(): 
		    if disk not in rsrcDict.keys():
			raise KeyError,"The node class %s does not have the resource %s" % (node_class,disk)
		if not len(rsrcDict):
		    if not tkMessageBox.askokcancel("Dynamic Config Warning"+\
						    getCluster(),"Do you really want to create the node class with empty resource?"):
			return 1
		    if len(lclDiskDict):
			tkMessageBox.showinfo('Dynamic Config Failure'\
					      +getCluster(),"Local disks should be listed as a resource of the node class!")  
			return 1
		else:
		    if not len(lclDiskDict):
			if not tkMessageBox.askokcancel("Dynamic Config Warning"+\
			  getCluster(),"Do you really want to create the node class without local disks?"):
			    return 1
		nc=self.fc.createNodeClass(node_class)
		if len(rsrcDict):
		    retVal,reason=nc.setRsrcCap(rsrcDict)
		    if not retVal:
			tkMessageBox.showinfo('Dynamic Config Failure'\
					      +getCluster(),\
					      reason+"; Node Class %s has been created" 
						  % node_class)
			return 0
		if len(lclDiskDict):
		    retVal,reason=nc.setLocalDisks(lclDiskDict)
		    if not retVal:
			tkMessageBox.showinfo('Dynamic Config Failure'\
					      +getCluster(),\
					      reason+"; Node Class %s has been created" 
						  % node_class)
		return 0
	    except KeyError,reason:
		tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  reason)
		return 1
	    except ValueError,reason:
		tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  reason)
		return 1
	    except FBSError,reason:
		tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  reason)
		return 1
	    except socket.error:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),\
				  "Lost connection with Batch Manager")
		return 1
	else:
	    try:
		nc=self.fc.getNodeClass(node_class)
	    except FBSError:
		tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				  'You have to select Node class')
		return 1
	    if self.funcName in ["removeNode","addNode"]:
		list=self.argList
		val=string.splitfields(s[1].get(),',')
		rt=0
		nodeList=[]
		for item in val:
		    node=string.strip(item)
		    if string.find(node," ")>0:
			rangeList=string.splitfields(node," ")
			if len(rangeList)==3:
			    try:
				min=string.atoi(rangeList[1])
				max=string.atoi(rangeList[2])+1
				base=rangeList[0]
			    except:
				tkMessageBox.showinfo('Dynamic Config Failure'\
						      +getCluster(),\
						      "Syntax: node_base_name MinNum MaxNum")
				return 1
			    for i in range(min,max):
				node=base+repr(i)
				nodeList.append(node)
		    else:
			nodeList.append(node)
	    
		for node in nodeList:
		    try:
			socket.gethostbyname(node)
		    except socket.error:
		        tkMessageBox.showinfo('Dynamic Config Failure'\
					      +getCluster(),\
					      "Invalid host name: %s" % node)
			return 1
		    try:
			func="nc.%s('%s')"%(self.funcName,node)
			retVal,reason=eval(func)
			if not retVal:
			    tkMessageBox.showinfo('Dynamic Config Failure'\
						  +getCluster(),\
						  reason)
			    rt=1
		    except KeyError,reason:
			tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
					      reason)
			rt=1
		    except ValueError,reason:
			tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
					      reason)
			rt=1
		    except socket.error:
			tkMessageBox.showinfo('FBS_BATCH'+getCluster(),\
				     "Lost connection with Batch Manager")
			return 1
		if not rt:
		    return 0
		else:
		    return 1
	    retVal=self.checkValue(nc,1)
	return retVal

    def checkValue(self,obj,cnt):
	i=cnt
	try:
	    func="obj.%s("%self.funcName
	    for tup in  self.argList[cnt:]:
		tp=tup[1]
		if tp=="":
		    str=s[i].get()
		    if not len(str):
			tkMessageBox.showinfo('Dynamic Config Failure'+\
				getCluster(),'Please, supply required information')
			return 1
		    func="%s'%s'," % (func,s[i].get())
		if tp=='int':
		    var=s[i].get()
		    if var=="": var="0"
		    try:
			func="%s%d," % (func,string.atoi(var))
		    except ValueError:
			tkMessageBox.showinfo('Dynamic Config Failure'+\
				getCluster(),'Please, insert integer value')
			return 1		
		elif type(tp)==type([]):
		    if self.funcName in ['allowNodes','disallowNodes']:
			rsrcList=self.List.rinfo
		    else:
			rsrc=s[i].get()
			if len(rsrc):
			    rsrcList=string.splitfields(rsrc,',')
			else:
			    rsrcList=[]
		    func="%s%s," % (func,rsrcList)
		elif type(tp)==type({}):
		    var=s[i].get()
		    retVal,rsrcDict=self.getRsrcDict(var)
		    if retVal:
			return 1
		    func="%s%s," % (func,rsrcDict)
		i=i+1
	    
	    func=func[:-1]+")"
	    #print func
	    try:
		retVal,reason=eval(func)
		if retVal:
		    return 0
		else:
		    tkMessageBox.showinfo('Dynamic Config Failure'+\
					  getCluster(),reason)
		    return 1
	    except KeyError,reason:
		tkMessageBox.showinfo('Dynamic Config Failure'+\
					  getCluster(),reason)
		return 1
	    except FBSError,reason:
		tkMessageBox.showinfo('Dynamic Config Failure'+\
					  getCluster(),reason)
		return 1
	    except:
		tkMessageBox.showinfo('Dynamic Config Failure'+\
					  getCluster())
		return 1
	except socket.error:
	    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),\
				  "Lost connection with Batch Manager")
	    return 1
    def checkAction(self):
	if self.funcName=="holdNode":
	    heldReason=s[1].get()
	    if not len(heldReason):
		 tkMessageBox.showinfo('Action Failed'+\
			   getCluster(),"Please, enter why the nodes are held!")
		 return 1
	for name in self.List.rinfo:
	    if self.funcName=="holdNode":
		func="self.fc.%s('%s','%s')" % (self.funcName,name,heldReason)
	    else:
		func="self.fc.%s('%s')" % (self.funcName,name)
	    try:
		retVal,reason=eval(func)
		if not retVal:
		    tkMessageBox.showinfo('Action Failed'+\
					  getCluster(),reason)
		    return 1
	    except KeyError,reason:
		tkMessageBox.showinfo('Action Failed'+\
					  getCluster(),reason)
		return 1
	    except FBSError,reason:
		tkMessageBox.showinfo('Action Failed'+\
					  getCluster())
		return 1
	    except socket.error:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),\
				      "Lost connection with Batch Manager")	
		return 1
	    except:
		tkMessageBox.showinfo('Action Failed'+getCluster(),\
				      "Something is terribly wrong!")
		return 1
	return 0
		

    def check(self):
	i=0
	if self.funcName in ["createQueue","update"]:
	    return self.checkQueue()
	elif self.funcName in ["createProcessType","setSectRsrcDefs",\
			       "setProcRsrcDefs",\
			       "setRsrcQuota","setMaxPrioInc",\
			       "setUsers","allowNodes","disallowNodes",\
			       "setMaxNodeCount","setCPUTimeLimit",\
			       "setRealTimeLimit"]:
	    return self.checkProcType()
	elif self.funcName in ["createNodeClass","removeNode","addNode",\
			       "setRsrcCap","setLocalDisks"]:
	    return self.checkNodeClass()
	elif self.funcName in ["holdQueue","releaseQueue","lockQueue",\
			       "unlockQueue","holdNode","releaseNode",\
			       "removeQueue","removeNodeClass",\
			       "removeProcessType","removeLocalResource",\
			       "removeGlobalResource","removeRsrcPool"]:
	     return self.checkAction()
	else:
	    if self.funcName in ["removeGlobalResource","setGlobalResource",\
				 "setRsrcPool"]:
		if len(s[0].get())==0:
		    tkMessageBox.showinfo('Dynamic Config Failure'+getCluster(),\
				 'You have to select from radiobutton list')
		    return 1
	    return self.checkValue(self.fc,0)
    def verify(self,pref):
	tmp=os.popen('fbs chkcfg','r').readlines()
	info=[]
	for line in tmp:
	    info.append(line[:-1])
	DisplayTmp("Result:",info,"Checking FBS Configuration",self.master,\
		   pref)
    def createList(self,f,rinfo=[],rlbl="",linfo=[],llbl=""):
	f1=Frame(f)
	f1.pack(side=BOTTOM)
	f1.pack(anchor=W,expand=YES,fill=X)
	f2=Frame(f1)
	f2.pack(side=LEFT)
	self.List=DblList(f2,rinfo=rinfo,rlbl=rlbl,linfo=linfo,llbl=llbl)
    def destroy(self):
	try:
	    self.top.destroy()
	except:
	    pass
