#@(#)$Id: GuiCpu.py,v 1.11 2001/06/11 22:09:18 tlevshin Exp $
#@(#)$Author: tlevshin $
#@(#)$Log: GuiCpu.py,v $
#@(#)Revision 1.11  2001/06/11 22:09:18  tlevshin
#@(#)fixed append((tup1,tup2..)) in order to work in python2.1
#@(#)fixed history option
#@(#)
#@(#)Revision 1.10  2000/10/25 21:17:45  tlevshin
#@(#)added removing resources to GuiAdmin
#@(#)implemented frozen screen and refresh button
#@(#)
#@(#)Revision 1.9  2000/10/18 16:04:55  tlevshin
#@(#)fixed problem with double showing of down & held vonde in "List of bad.."
#@(#)
#@(#)Revision 1.8  2000/09/21 23:28:36  tlevshin
#@(#)*** empty log message ***
#@(#)
#@(#)Revision 1.7  2000/06/12 16:42:13  tlevshin
#@(#)*** empty log message ***
#@(#)
#@(#)Revision 1.6  2000/06/12 16:38:11  tlevshin
#@(#)fixed bugs #56724 and #75391
#@(#)
#@(#)Revision 1.5  2000/06/05 15:51:32  tlevshin
#@(#)replace FBSError to socket.error
#@(#)
#@(#)Revision 1.4  2000/05/30 22:07:23  tlevshin
#@(#)"held" node wil appear in "down" list
#@(#)
#@(#)Revision 1.3  2000/05/03 18:59:26  tlevshin
#@(#)bug fixes
#@(#)
#@(#)Revision 1.2  2000/03/24 22:03:10  tlevshin
#@(#)bug fixing
#@(#)
#@(#)Revision 1.1  2000/03/22 21:54:15  tlevshin
#@(#)modified Gui version using new Api
#@(#)

#***********************************************
#*   Farms Batch Gui                           *
#*   Cpu Config Class                          *
#*   Cpu Status Class                          *
#***********************************************  
from GuiBase import *
from FBS_API import FBSClient

#******************************************************************
class ButtonMod(ButtonBase):
    def __init__(self,frame,top,name):
	ButtonBase.__init__(self,frame,name)
	self.top=top

    def action(self):
	self.top.getCpu(string.split(self.top.list.reply))
#******************************************************************

#******************************************************************
class ButtonNode(ButtonBase):
    def __init__(self,frame,top,name,type,side="left",anchor='nw',fill='x',\
		 foreground='black',backgroud='grey'):
	ButtonBase.__init__(self,frame,name,side,anchor,fill,foreground,\
			    backgroud)
	self.top=top
	self.node=name
	self.type=type

    def action(self):
	self.top.status(self.node,self.type)
#******************************************************************

#******************************************************************
class ButtonDisplay(ButtonBase):
    def __init__(self,frame,top,name,side="left"):
	ButtonBase.__init__(self,frame,name,side)
	self.top=top

    def action(self):
	self.top.displayAllNodes()
#******************************************************************

#******************************************************************
class ButtonSpec(ButtonBase):
    def __init__(self,frame,top,name,side="left"):
	ButtonBase.__init__(self,frame,name,side)
	self.top=top

    def action(self):
	self.top.displaySpec()
#******************************************************************

#******************************************************************
#Class BadCpuList - widget for display of "down node" buttons     *
#and their status                                                 *
#******************************************************************
class BadCpuList:
    def __init__(self,frame,fc,pref):
	self.frame=frame
	self.fc=fc
	self.pref=pref

    def makelist(self,nodedict):
	for name in nodedict.keys():
	    list=nodedict[name]
	    k=0
	    for i in range(len(list)):
		if k==0:
		    fr=Frame(self.frame)
		    fr.pack(side=TOP,expand=YES,fill=BOTH)
		    fr.config(bd=4)
		    if i==0:
			Label(fr,text=name+"    ",foreground='black').pack(side=TOP,anchor=W,expand=YES)
		ButtonNode(fr,self,list[i],name,'left','nw','x','black','red')
		k=k+1
		if k>5:
		    k=0

    def status(self,name,type):
	info=[]
        try:
	    nlist=self.fc.getNodeList(type)
	except KeyError:
	    nlist=[]
        except socket.error:
	    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
	    return []
	except:
	    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
	    return []
        for nm in nlist:
	    if name==nm:
		h=self.fc.getNode(name)
		title=name+"("+type+")"
		label=""
		if h.IsUp:
		    status="up"
		else:
		    status="down"
		if h.IsHeld:
		    status="held"
		    
		info.append(strFormat("Status: ")+status)
		if not h.IsUp or h.IsHeld:
		    info.append(strFormat("Reason: ")+h.HoldReason)
		info.append(strFormat("#_Proc_Run  "+repr(len(h.Processes))))
		info.append(strFormat("Process_Id "+repr(h.Processes)))
		break
        DisplayTmp(None,info,title,self.frame,self.pref)



#******************************************************************
# Class DisplayAllNodes - widget for display all nodes and their  *
# status                                                          *
#******************************************************************
class DisplayAllNodes(Screen):
    def __init__(self,master,title,fc,pref):
	self.fc=fc
	self.title=title
	Screen.__init__(self,master,title,None,None,'top',pref)

    def menubar(self):
	fr=Frame(self.top)
	fr.pack(side=BOTTOM,fill=X)
	ButtonQuit(fr,self.top,'Quit','bottom','center','y')

    def get_info(self):
	try:
	    nodeL=self.fc.getNodeList(self.title)
	except KeyError:
	    nodeL=[]

	except socket.error:
	    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
	    return []
	except:
	    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
	    return []
	info=[]
	label=("Node_Name"," Status","#_Proc_Run"," Process_Id")
	for name in nodeL:
	    h=self.fc.getNode(name)
	    if h.IsUp:
		status="up"
	    else:
		status="down"
	    if h.IsHeld:
		status="held"
	    info.append((name,\
			 status,repr(len(h.Processes)),\
			 repr(h.Processes)))
	self.info,self.label=infoFormat(info,label)
	self.info.sort()
#******************************************************************
# Class CpuConfig - widget for display node configuration         *
#******************************************************************
class CpuConfig(Screen):
    def __init__(self,master,fc,pref):
	self.fc=fc
	Screen.__init__(self,master,"NODE LIST",None,None,'bottom',pref)

    def menubar(self):
	fr=Frame(self.top)
	fr.pack(side=TOP,fill=X)
	ButtonSpec(fr,self,'Display')
	ButtonRefresh(fr,self,'Refresh')
	ButtonPref(fr,self,'Preference')
	ButtonPrint(fr,self,'Print')
	ButtonSave(fr,self,'Save')
	ButtonQuit(fr,self.top,'Quit')

    def get_info(self):
	try:
	    classL=self.fc.getNodeClassList()
	except socket.error:
	    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
	    return []
	except:
	    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
	    return []
	info=[]
	label=("NODE_NAME","NODE_CLASS","NODE_STATUS")
	for className in classL:
	    try:
		nodeL=self.fc.getNodeList(className)
		for name in nodeL:
			nc=self.fc.getNode(name)
			if nc.IsUp:
			    status="up"
			else:
			    status="down"
			if nc.IsHeld:
			    status="%s:held" %(status,)
			info.append((name,className,status))
	    except socket.error:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
		return []
	    except:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
		return []
	self.info,self.label=infoFormat(info,label)
	self.info.sort()

    def displaySpec(self):
	label=("RESOURCE_NAME","CAPACITY","USED")
	for reply in self.list.reply:
		name=string.split(reply)[0]
		info=[]
		node=self.fc.getNode(name)
		for rsrcName,value in node.Resources.items():
		    s=(rsrcName,repr(value[1]),repr(value[0]))
		    info.append(s)
		info,tmpLbl=infoFormat(info,label)
		info.sort()
		DisplayTmp(tmpLbl,info,"Node %s" % name,\
				self.top,self.pref)


   

		
#**************************************************************  	    	    
# Class CpuStatus - widget for display queue/node relationship*
#**************************************************************     
class CpuStatus(Screen):
    def __init__(self,master,fc,pref):
	self.fc=fc
	self.frame=None
	self.down={}
	self.new_down={}
	self.downTop=None
	self.Monitor=Monitor()
	Screen.__init__(self,master,"NODE STATUS",None,None,'bottom',pref)
	self.displayDown()

    def destroyAll(self):
	self.Monitor.killChild()
	self.updt=1
	self.top.destroy()

    def displayDown(self):
	if self.frame==None:return
	if self.new_down==self.down:
	    return
	else:
	    self.down=self.new_down
	    self.createBadNodes()
	
    def createBadNodes(self):
	if self.downTop:
	    self.downTop.destroy()
	if not len(self.down):
	    return
	self.downTop = Toplevel(self.frame)
	self.downTop.title("LIST OF DOWN NODES"+getCluster())
	self.downFrame=Frame(self.downTop)
	self.downFrame.pack(side=TOP,expand=YES,fill=BOTH)
	self.downNodeL=BadCpuList(self.downFrame,self.fc,self.pref)
	self.downNodeL.makelist(self.down)

    def displayAllNodes(self):
	for reply in self.list.reply:
		t=string.split(reply)[0]
		DisplayAllNodes(self.frame,t,self.fc,self.pref)

    def menubar(self):
	fr=Frame(self.top)
	fr.pack(side=TOP,fill=X)
	ButtonDisplay(fr,self,'Display')
	ButtonMonitor(fr,self,'Monitor')
	ButtonRefresh(fr,self,'Refresh')
	ButtonPref(fr,self,'Preference')
	ButtonPrint(fr,self,'Print')
	ButtonSave(fr,self,'Save')
	ButtonDestroy(fr,self.top,'Quit',self.Monitor)

    def hostlist(self):
	for reply in self.list.reply:
	    t=string.split(reply)[0]
	    try:
	   	nL = self.fc.getNodeList(t)
	    except KeyError:
		nL=[]
	    except socket.error:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
		return
	    except:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
		return
	    host=[]
	    for name in nL:
		idx=string.find(name,'.')
		if idx >0:
		    name=name[:idx]
		
		host.append(name)
	    host.sort()
	    self.Monitor.startChild(host)

				      
    def get_info(self):
	self.Monitor.checkChild()
	self.new_down={}    
	info=[]
	label=("Node_Class","#_Run_Proc","#_Node_Up","#_Node")
	try:
	    tlist=self.fc.getNodeClassList()
	except socket.error:
	    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
	    return []
	except:
	    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
	    return []

	for typeN in tlist:
	    runProc=0
	    nodeUp=0
	    try:
	    	nodeL=self.fc.getNodeList(typeN)
	    except KeyError:
		nodeL=[]
	    except socket.error:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
		return []
	    except:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
		return []  
	    node=len(nodeL)             
	    downL=[]
	    for name in nodeL:
		h=self.fc.getNode(name)
		jn=len(h.Processes)
		runProc=runProc+jn
		if h.IsUp:
		    if not h.IsHeld:
		    	nodeUp=nodeUp+1
		else:
		    downL.append(h.Name)
		if h.IsHeld:
		    if h.Name not in downL:
			downL.append(h.Name)
	    s=(typeN,"("+repr(runProc)+") ",repr(nodeUp), repr(node))
	    if nodeUp<node:
		self.new_down[typeN]=downL
	    info.append(s)
	self.info,self.label=infoFormat(info,label)
	self.displayDown()

    def delete(self):
	for i in range(len(self.info)):
	    if self.info[i] in self.list.reply:
		del self.info[i]
		break
	self.redisplay()
 #****************************************************************




