#
# @(#) $Id: JobFinder.py,v 1.12 2000/10/26 17:03:25 ivm Exp $
#
# $Author: ivm $
#
# $Log: JobFinder.py,v $
# Revision 1.12  2000/10/26 17:03:25  ivm
# Added additional checks for resources and ptypes before removal
# Added "remove" functions to farm_config
#
# Revision 1.10  2000/10/06 18:11:27  ivm
# Fixed syntax error in JobFinder
# Removed splitcfg from fbs
#
# Revision 1.8  2000/06/14 20:25:54  ivm
# Return None from JobFinder.getSection() if only section
# name is specified.
#
# Revision 1.7  2000/03/09 20:19:23  ivm
# *** empty log message ***
#
# Revision 1.6  2000/02/24 15:24:31  ivm
# Added JobFinder.checkTimes(), Timer class
#
# Revision 1.4  2000/02/09 23:43:47  tlevshin
# getSection returns None if section is not found
#
# Revision 1.3  2000/02/08 09:47:17  ivm
# Fixed bug with job/section id decoding
#
# Revision 1.2  2000/01/28 15:22:15  ivm
# Reser job id to 1 after 99999
#
# Revision 1.1  1999/12/24 17:10:27  ivm
# Added files
#
#

import bmgr_global
import fbs_misc
import sys

class	JobFinder:
	def __init__(self):
		self.Jobs = {}
		
	def __setitem__(self, jid, job):
		self.Jobs[jid] = job
		
	def __delitem__(self, jid):
		#print 'JobFinder.del(%s)' % jid
		try:	del self.Jobs[jid]
		except:
			#print 'JobFinder.del(%s)' % jid, sys.exc_type, sys.exc_value
			pass
					
	def __getitem__(self, jid):
		return self.Jobs[jid]
		
	def jobs(self):
		return self.Jobs.keys()

	def hasJob(self, jid):
		return self.Jobs.has_key(jid)
		
	def getSection(self, jsid, sname=None):
		# first argument is either job or section id
		# if it's job id (does not have dot), then second argument
		# is section name, otherwise second argument is ignored
		try:
			ids = fbs_misc.decodeDotID(jsid)
			if len(ids) >= 2:
				jid, sname = ids
			else:
				jid = ids[0]
			return self[jid][sname]
		except: return None

	def nextJobID(self):
		while 1:
			i = bmgr_global.G_JobDB.nextJobID()
			if not self.Jobs.has_key(i):
				return i
				
	def checkTimes(self):
		for j in self.Jobs.values():
			j.checkTimes()

	def procTypeInUse(self, ptn):
		for j in self.Jobs.values():
			for sn in j.sections():
				s = j[sn]
				if s.ProcType == ptn:
					return j.ID
		return None
		
	def resourceInUse(self, rn):
		for j in self.Jobs.values():
			for sn in j.sections():
				s = j[sn]
				if s.PerProcLocal.has_key(rn) or \
						s.PerProcGlobal.has_key(rn) or \
						s.PerSectGlobal.has_key(rn):
					return j.ID
		return None
		
