import os
from TCPServer import TCPServer

class	ClientHandlerStub:
	def __init__(self, sock, addr):
		self.Sock = sock
		self.Address = addr

	def spawnAndRun(self, closeStdio = 1):
		pid = os.fork()
		if pid:
			# parent or error
			self.Sock.close()
			#print 'parent: child #%s spawned' % pid
			return pid
		else:
			# child
			#for fd in range(1024):
			#	if fd != self.Sock.fileno():
			#		if not closeStdio and fd < 3:
			#			os.close(fd)
			self.run()
			return 0

	# Overridables
	def rejectConnection(self):
		pass
		
	def run(self):
		pass
		
class	LimitedTCPServer(TCPServer):
	def __init__(self, port, sel, maxclients = None):
		TCPServer.__init__(self, port, sel)
		self.MaxClients = maxclients
		self.Handlers = {}		# pid -> Handler stub object
		self.ShutDown = 0
		self.Sel = sel
		
	def createClientInterface(self, sock, peer, sel):
		#print 'createClientInterface...'
		h = self.createClientHandler(sock, peer)
		if self.MaxClients == None or len(self.Handlers) < self.MaxClients:
			pid = h.spawnAndRun()
			if pid > 0:
				self.Handlers[pid] = h
			elif pid == 0:
				# child:	exit after spawn
				self.shutDown()
		else:
			h.rejectConnection()

	def shutDown(self):
		self.ShutDown = 1

	def checkHandlerExits(self):
		while 1:
			try:	pid, sts = os.waitpid(-1, os.WNOHANG)
			except: return
			if pid <= 0:	return
			if self.Handlers.has_key(pid):
				del self.Handlers[pid]

	def run(self):
		while not self.ShutDown:
			self.Sel.select(10)
			self.checkHandlerExits()
			self.idle()

	# overridables
	def createClientHandler(self, sock, peer):
		return ClientHandlerStub(sock, peer)

	def idle(self):
		pass
