#
# @(#) $Id: NetIF.py,v 1.131 2003/09/22 19:49:27 ivm Exp $
#
# $Author: ivm $
#
# $Log: NetIF.py,v $
# Revision 1.131  2003/09/22 19:49:27  ivm
# Allow authorized users to hold/release queue.
#
# Revision 1.130  2003/08/20 18:58:57  ivm
# Implemented CPU power, round-robin-over-users scheduling inside queuei,
# other minor things.
#
# Revision 1.129  2003/01/14 22:05:03  ivm
# Implemented node class power
#
# Revision 1.128  2002/06/19 16:52:53  ivm
# Fixed some bugs
#
# Revision 1.127  2001/11/20 19:42:14  ivm
# Implemented CPU and real time limits for proc. type
# Fixed launcher reconfiguration bug
#
# Revision 1.126  2001/10/12 17:02:41  ivm
# Removed some debug log from NetIF
# Use map(), filter() in Queue, Scheduler
#
# Revision 1.125  2001/09/10 20:44:31  ivm
# Removed debug print-outs
#
# Revision 1.124  2001/08/23 19:05:53  ivm
# Implemented search with feedback RM algorithm
# Added -v option to status.py
# Fixed handling of time limits in FBSSectionInfo
#
# Revision 1.123  2001/06/21 15:47:59  ivm
# Catch errors in recv_auth()
#
# Revision 1.122  2001/06/12 19:47:52  ivm
# Updated for Python v2.1
#
# Revision 1.121  2001/06/01 14:45:38  ivm
# Fixed some bugs
#
# Revision 1.120  2001/05/29 21:49:09  ivm
# Fixed bug in remove proc type
#
# Revision 1.119  2001/05/25 21:39:36  ivm
# Implemented hold node and disconnect
#
# Revision 1.118  2001/05/11 15:09:00  ivm
# Fixed many bugs
#
# Revision 1.116  2001/04/20 17:41:25  ivm
# Fixed numerous bugs
#
# Revision 1.115  2001/04/03 14:17:02  ivm
# Reverted back to 1.113 to move event manager interface to EventManager
#
# Revision 1.113  2001/03/19 15:14:51  ivm
# Return only non-zero usage resources for ProcTypeInfo
# Added users, nodes, ptypes to UI commands
#
# Revision 1.112  2001/03/15 21:47:54  ivm
# Implemented "on nodes"
# Fixed protocol version handling in lch, lchif
#
# Revision 1.110  2001/03/12 19:28:37  ivm
# Added "object ownersip" feature
#
# Revision 1.109  2001/02/26 22:28:33  ivm
# Fixed kill.py
# Added RELEASE message sent from LchIF to launcher to clear held status
#
# Revision 1.108  2001/02/05 20:24:31  ivm
# Fixed bug
#
# Revision 1.106  2001/01/24 22:25:50  ivm
# Added SENDAUTH command to k5 authentication protocol
#
# Revision 1.105  2001/01/03 15:47:14  ivm
# Made queue status (locked/held) persistent
#
# Revision 1.104  2000/12/12 19:22:10  ivm
# Removed debug print-out
# Fixed numerous errors in man pages
#
# Revision 1.103  2000/11/14 23:13:44  ivm
# Polished Scheduler
# Fixed Username in job creation in NetIF
#
# Revision 1.102  2000/11/10 15:41:42  ivm
# Fixed Stats.so building
# Fixed bug in RM with nullifying usage
# Print exception information in submit
# Improved queues print-out
#
# Revision 1.100  2000/11/09 15:24:46  ivm
# Fixed getJobList
#
# Revision 1.96  2000/11/06 15:40:16  ivm
# Modified Scheduler and Queue to use new normalization algorithm
#
# Revision 1.95  2000/11/03 21:16:43  ivm
# Tested RM pack, spread features
# Print detailed error message on ValueError in submit.py
# Fixed getJob w.r.t. Username
#
# Revision 1.94  2000/10/31 16:33:23  ivm
# accept "yes"/"no" as value for kerberos/required cfg. parameter
#
# Revision 1.92  2000/10/26 17:03:26  ivm
# Added additional checks for resources and ptypes before removal
# Added "remove" functions to farm_config
#
# Revision 1.89  2000/10/20 19:53:35  ivm
# Renamed cfg field to client_auth_required
#
# Revision 1.88  2000/10/20 19:51:00  ivm
# Added misccmodule
# Call initgroups() before setgid() setuid() in launcher
# Copy kinit stderr, stdout to process stderr, stdout
#
# Revision 1.87  2000/10/11 19:36:58  ivm
# Added FBSNodeInfo.holdNode()
# Implemented credentials creation by Launcher
#
# Revision 1.85  2000/10/02 19:14:13  ivm
# Cosmetics in NetIF error messages
# Repeat waitpid() again and again in Launcher
#
# Revision 1.83  2000/10/02 14:06:07  ivm
# Fixed some bugs
# Added sgimodule
#
# Revision 1.82  2000/09/27 20:18:36  ivm
# Renamed Scheduler.canRun() to trigger()
#
# Revision 1.81  2000/09/26 16:27:37  ivm
# Fixed some bugs
#
# Revision 1.80  2000/09/15 16:10:44  ivm
# Added templates/farm.cfg.template
# Added history and header records to farm.cfg
# Removed farm.cfg sets from fbs.cfg.example
#
# Revision 1.79  2000/09/12 15:00:00  ivm
# Implemented createLocalResource method and all related changes
#
# Revision 1.78  2000/09/08 15:30:49  ivm
# Fixed bug with RM.getNodeClass in NetIF
# Added kill_all "python.*launcher.py" to shutdown_lch
# Removed $FBSNG_DIR/bin from PYTHONPATH
#
# Revision 1.77  2000/09/07 17:54:52  ivm
# Implemented dynamic modification of local scratch disk mapping
#
# Revision 1.75  2000/09/05 16:12:14  ivm
# Fixed bug in farm_config
# Use serialize module to send node info
#
# Revision 1.74  2000/08/30 19:52:40  ivm
# Disconnect node on removal
# Fixed Usage printing in config
#
# Revision 1.73  2000/08/24 20:09:21  ivm
# Fixed chkcfg
# Implemented RM.addLocalResource
#
# Revision 1.71  2000/08/22 18:53:11  ivm
# Removed debug print-outs
#
# Revision 1.70  2000/08/21 21:28:22  ivm
# Fixed some bugs
#
# Revision 1.68  2000/08/21 19:01:33  ivm
# Added History as a global object
#
# Revision 1.67  2000/08/18 21:15:40  ivm
# Implemented dynamic re-configuration
#
# Revision 1.65  2000/08/08 14:18:56  ivm
# Implemented pool dictionaries for SectionInfo and ProcessInfo
#
# Revision 1.64  2000/08/03 21:17:47  ivm
# Fixed bugs, added traceback print-out in NetIF
#
# Revision 1.63  2000/08/03 19:35:35  ivm
# Fixed some bugs
#
# Revision 1.62  2000/08/03 15:39:33  ivm
# Fixed some bugs
#
# Revision 1.61  2000/08/02 16:36:05  ivm
# Fixed numerous bugs
#
# Revision 1.60  2000/08/02 15:01:06  ivm
# Use new RM
#
# Revision 1.59  2000/07/19 15:36:10  ivm
# Fixed typo in Install.txt
# Send CPUTime from Section.Process as ACPUTime
#
# Revision 1.58  2000/07/17 17:25:10  ivm
# Added queue locking/unlocking
# Generate KeyError if queue not found in hold/releaseQueue
#
# Revision 1.57  2000/07/05 15:57:24  ivm
# Do not allow empty jobs
#
# Revision 1.56  2000/06/26 16:33:53  ivm
# Fixed process time printing in Section
# Fixed archive interval calculation in Section
# Fixed command retrieval from Section
#
# Revision 1.54  2000/06/21 14:43:27  ivm
# Added killJob()
# Optimized EXITED/DEL part of launcher protocol
#
# Revision 1.53  2000/06/19 21:27:27  ivm
# Generate KeyErrors in API get...resource() methods
#
# Revision 1.52  2000/06/19 14:54:14  ivm
# Added fields to QueueInfo
# Fixed LCH,LCHIF
#
# Revision 1.50  2000/06/12 18:32:16  ivm
# Removed hold/release/kill job methods
#
# Revision 1.49  2000/06/08 18:32:44  ivm
# Order sections by JDFSeq in FBSJobInfo.sections()
#
# Revision 1.48  2000/06/05 20:45:24  ivm
# Mase sure numeric section names come out as strings
# Restore signals in JobDB
# Fixed pid file name in Launcher
# Fixed memory leak in NetIF
#
# Revision 1.47  2000/05/31 15:13:08  ivm
# Removed debug messages from NetIF, fixed Queue.
# Implemented probing in LaucherIF
#
# Revision 1.46  2000/05/08 20:49:55  ivm
# Fixed some bugs,
# Implemented totals for local resource utilization
#
# Revision 1.45  2000/04/21 21:27:43  ivm
# Fixed FBSProcTypeInfo
#
# Revision 1.43  2000/04/20 21:18:42  ivm
# Fixed inter-queue scheduling
#
# Revision 1.40  2000/04/17 15:48:55  ivm
# Made modifications for LogClient
#
# Revision 1.39  2000/04/10 15:26:55  ivm
# Added FBSClient.getProcess()
#
# Revision 1.38  2000/04/10 15:06:20  ivm
# Fixed sect->s
#
# Revision 1.37  2000/04/10 14:45:28  ivm
# Fixed G_FarmConfig
#
# Revision 1.36  2000/04/07 21:14:02  ivm
# Implemented incSectPrio()
#
# Revision 1.35  2000/04/06 15:21:42  ivm
# Added Class to NodeInfo
#
# Revision 1.34  2000/04/04 14:45:23  ivm
# Added UID validation
#
# Revision 1.31  2000/03/30 20:53:11  ivm
# Added Scheduler.canRun() to NetIF and LchIF
#
# Revision 1.30  2000/03/30 17:21:55  ivm
# Fixed some bugs in scheduler
# Use fast list send in API-NetIF
#
# Revision 1.28  2000/03/28 16:44:50  ivm
# Fixed some bug
#
# Revision 1.27  2000/03/24 20:24:19  ivm
# Removed debug print-out
#
# Revision 1.23  2000/03/22 19:35:25  ivm
# Implemented hold/release node/job/section
#
# Revision 1.21  2000/03/14 16:37:56  ivm
# Fixed FBSNodeInfo.py
# Added HOLD_TIME to SectParam
#
# Revision 1.18  2000/03/09 20:19:23  ivm
# *** empty log message ***
#
# Revision 1.15  2000/03/06 21:15:29  ivm
# Added queue held/released status
#
# Revision 1.12  2000/02/28 17:10:41  ivm
# Fixed some bugs
#
# Revision 1.10  2000/02/25 18:17:50  ivm
# Added NetIF commands
#
# Revision 1.9  2000/02/21 18:36:54  ivm
# Fixed bugs in KILL
#
# Revision 1.7  2000/02/17 21:05:11  ivm
# Fixed some bugs
#
# Revision 1.6  2000/02/09 21:00:44  tlevshin
# NetIf should pass UID,GID to SectParam
#
# Revision 1.5  2000/02/01 16:01:16  ivm
# Fixed some bugs
# Added GETJOB command
#
# Revision 1.4  2000/01/31 21:39:23  ivm
# Fixed more trivial bugs
#
# Revision 1.2  2000/01/24 17:23:26  ivm
# Added call to SectParam.addDefaults()
#
#

import Parser
import sys
from TCPServer import TCPServer
from SockStream import *
import bmgr_global
from JobSection import *
from SectParam import *
import fbs_misc
import RM
from socket import *
import serialize
from Queue import *
import fnmatch

#from Tracer import *

NetIF_k5imported = 1
try:	import krb5
except: NetIF_k5imported = 0
else:	print 'krb5 imported'

class	NetworkClient:
	def __init__(self, netif, sock, addr, sel):
		self.NetIF = netif
		self.Sock = sock
		self.Str = SockStream(sock, '\n')
		self.Sel = sel
		self.Sel.register(self, rd = self.Sock.fileno())
		self.Addr = addr
		self.InSection = 0
		self.InSubmit = 0
		self.Job = None
		self.UID = -1
		self.GID = -1
		self.ID = ''
		self.JobID = None
		self.SectPar = None
		self.SectName = ''
		self.Username = 'unknown'		# as it comes from client
		self.K5Username = None			# verified with K5, if required
		self.K5Principal = None

	def saveFarmConfig(self, msg = ''):
		bmgr_global.G_FarmCfg.save(hist_record = '%s: %s' % (self.Username,
					msg))

	def log(self, lvl, msg):
		bmgr_global.G_LogClient.log(lvl, 0, 'NetIF(%s,%s): %s' % 
				(self.Addr, self.Username, msg))

	def kickSch(self):
		bmgr_global.G_Scheduler.trigger()

	def kAuth(self):
		if not self.NetIF.k5Required():
			self.K5Username = self.Username
			return 1, self.K5Username
		if self.K5Username:
			return 1, self.K5Username
		if not NetIF_k5imported:
			return 0, 'krb5 module not imported'
		sp = self.NetIF.k5SvcPrincipal()
		#print 'sending <K5AUTH %s %s>' % (sp.service, sp.host)
		ans = self.Str.sendAndRecv('K5AUTH %s %s' % (sp.service, sp.host))
		if not ans or ans != 'OK':
			return 0, 'Authentication refused by client: %s' % ans
		self.Str.send('SENDAUTH')
		try:
			ac = krb5.recv_auth(self.Sock, sp)
			princ = ac.remote.name()
		except krb5.Krb5Error, val:
			return 0, 'KRB5 error: %s' % val.message
		except:
			msg = 'Error in krb5.recv_auth(): %s %s' % (
				sys.exc_type, sys.exc_value)
			fbs_misc.printTraceback()
			return 0, msg
		self.K5Principal = princ
		if self.NetIF.checkUserPrincipal(princ, self.Username):
			self.log('I','Authentiacted K5 principal <%s> as username <%s>' %
				(princ, self.Username))
			self.K5Username = self.Username
			return 1, self.Username
		else:
			self.log('I','Authentiaction of K5 principal <%s> as username <%s> denied' %
				(princ, self.Username))
			return 0, 'Username mismatch: <%s> vs. K5 principal:<%s>' % \
					(self.Username, princ)
		

	def trustedClient(self):
		allow_lst = bmgr_global.G_ServerCfg.getValueList('bmgr','*','allow_submit')
		if allow_lst == None:
			allow_lst = ['*']
		deny_lst = bmgr_global.G_ServerCfg.getValueList('bmgr','*','deny_submit')
		if deny_lst == None:
			deny_lst = []
		# get client official address and node name
		ipaddr = self.Addr[0]
		try:	ipname = gethostbyaddr(ipaddr)[0]
		except: return 0		# unknown address, play it safe
		
		# 1. see if the client is in deny list
		for x in deny_lst:
			if fbs_misc.ipMatch(ipname, x) or fbs_misc.ipMatch(ipaddr, x):
				return 0
		
		# 2. allow only if in allow list
		allowed = 0
		for x in allow_lst:
			if fbs_misc.ipMatch(ipname, x) or fbs_misc.ipMatch(ipaddr, x):
				allowed = 1
				break
		return allowed


	def submitAllowed(self):
		return self.Username == self.K5Username and self.trustedClient()

	def isAdmin(self):
		if not self.submitAllowed():	return 0
		lst = bmgr_global.G_ServerCfg.getValueList('bmgr','*','admin_list')
		if lst == None:
			return 1		# by default, make it wide open
		if not (self.UID in lst) and not (self.Username in lst):
			return 0
		if self.NetIF.k5Required():
			if self.Username != self.K5Username:
				return 0
			if not (self.Username in lst):
				return 0
		return 1
		
	def doRead(self, fd, sel):
		#T.trace('doRead: begin')
		if fd != self.Sock.fileno():
			return
		self.Str.readMore(1000)
		while self.connected() and not self.Str.eof() and self.Str.msgReady():
			msg = self.Str.getMsg()
			if msg == None:
				continue
			msg = string.strip(msg)
			#self.log('D', 'rcvd:<%s>' % msg)
			words = Parser.parseWords(msg)
			if not words:	continue
			if self.InSubmit:
				#try:	
				self.continueSubmit(words, msg)
				#except:
				#	self.disconnect(sys.exc_value)
				#	return
				continue
			if words[0] == 'HELLO':
				# HELLO <id> <UID> <GID> [<username>]
				if len(words) < 4:
					self.errorDiconnect('Usage: HELLO <id> <UID> <GID> <username>')
				self.ID = words[1]
				self.UID = words[2]
				self.GID = words[3]
				if len(words) > 4:
					self.Username = words[4]
				# send options
				if self.NetIF.k5Required():
					kauth = 'yes'
				else:
					kauth = 'no'
				if self.trustedClient():
					trusted = 'yes'
				else:
					trusted = 'no'
				self.Str.send('OK k5_auth:%s trusted_client:%s' % (kauth, trusted))
				#self.log('I', 'client: %s %s %s' % (self.ID, self.UID, self.GID))
				continue
			elif self.UID == -1 or self.GID == -1:
				self.disconnect('Say HELLO first')
				continue

			if words[0] == 'SUBMIT':
				# SUBMIT
				# check if they are allowed to submit
				if not self.trustedClient():
					self.disconnect('Job submission is not allowed from client node')
					continue
				#print 'Calling kAuth...'
				sts, reason = self.kAuth()
				if not sts:
					self.disconnect('Client authentication failed: %s' % reason)
					continue
				self.InSubmit = 1
				self.InSection = 0
				self.JobID = bmgr_global.G_JobFinder.nextJobID()
				self.Job = Job(self.JobID, self.UID, self.GID, self.Username)
				self.Str.send('OK')
			elif self.CmdDispatch.has_key(words[0]):
				#T.trace('doRead: dispatch begin')
				ans = self.CmdDispatch[words[0]](self, msg)
				#T.trace('doRead: dispatch end')
				if ans != None:
					self.Str.send(ans)
			else:
				self.disconnect('Unknown command')
		if self.connected() and self.Str.eof():
			self.disconnect()
		#T.trace('doRead: end')

	def getProcType(self, msg):
		# GETPT <proc_type>
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR Usage: GETPT <proc_type>'
		pt = words[1]
		try:
			ptype = bmgr_global.G_ProcTypeFinder[pt]
		except:
			return 'NF Process type <%s> not found' % pt
		dict = {}
		dict['quota'] = ptype.Quota
		dict['sdef'] = ptype.SDefs
		dict['pdef'] = ptype.PDefs
		dict['usage'] = ptype.getUsageDict()
		dict['nodesa'] = ptype.NodesAllow
		dict['nodesd'] = ptype.NodesDisallow
		dict['users'] = ptype.Users
		dict['maxpi'] = ptype.MaxPrioInc
		dict['maxnodes'] = ptype.MaxNodes
		dict['ncount'] = ptype.currentNodeCount()
		dict['realtime'] = ptype.RealTimeLimit
		dict['cputime'] = ptype.CPUTimeLimit
		dict['nice'] = ptype.MinNice
		return 'OK %s' % serialize.serialize(dict)
			
	def junk_getProcTypeUsage(self, msg):
		# GETPTUSG <proc_type>
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR Usage: GETPTUSG <proc_type>'
		pt = words[1]
		lrlst = bmgr_global.G_ResourceManager.getLocalList()
		grlst = bmgr_global.G_ResourceManager.getGlobalList()
		dict = {}
		for rn in lrlst:
			try:	usg, qta = \
				bmgr_global.G_ResourceManager.getLocalResource('', rn, pt)
			except:
				continue
			dict[rn] = (usg, qta)
		for rn in grlst:
			try:	usg, qta = \
				bmgr_global.G_ResourceManager.getGlobalResource(rn, pt)
			except:
				continue
			dict[rn] = (usg, qta)
		lst = fbs_misc.serializeDict(dict)		
		self.sendData(lst, '.')		
		return None
				
	def getProcess(self, msg):
		# GETPROC <sectid> <procno>
		words = Parser.parseWords(msg)
		if len(words) < 3:
			return 'ERR Usage: GETPROC <sectid> <procno>'
		sid = words[1]
		procno = words[2]
		s = bmgr_global.G_JobFinder.getSection(sid)
		if s == None:
			return 'NF Section <%s> not found' % sid
		#print s.Procs
		p = s.getProcess(procno)
		if p == None:
			return 'NF Process #%s not found' % procno
		lrdstr = ''
		if p.localRsrcDict:
			for k, v in p.localRsrcDict.items():
				lrdstr = lrdstr + '%s:%s ' % (k,v)
		grdstr = ''
		if p.globalRsrcDict:
			for k, v in p.globalRsrcDict.items():
				grdstr = grdstr + '%s:%s ' % (k,v)
		lst = fbs_misc.serializeObject(p, 
			ignore_fields=['ProcNo','CPUTime','localRsrcDict','globalRsrcDict'],
			Command = s.SectParam.Exec, ACPUTime = p.CPUTime,
			LPDStr = lrdstr, GPDStr = grdstr)
		self.sendData(lst, '.')
		return None
		
	def getGlobalRsrc(self, msg):
		# GETGRSRC <rname> [<proc_type>]
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR Usage: GETGRSRC <rname> [<proc_type>]'
		rn = words[1]
		pt = None
		if len(words) > 2:	pt = words[2]
		try:
			#print 'getGlobalResource(%s, %s)' % (rn, pt)	
			usage, cap = bmgr_global.G_ResourceManager.getGlobalResource(rn, pt)
		except RM.Invalid_ProcType:
			#print 'Invalid process type'
			return 'NF process type <%s> not found' % pt
		except RM.Invalid_Resource:
			return 'NF Invalid resource <%s>' % rn
		except:
			return 'ERR Resource Manager error %s %s' %(
				sys.exc_type, sys.exc_value)
		return 'OK %d %s' % (usage, cap)
			
	def getLocalRsrc(self, msg):
		# GETLRSRC <rname> (<proc_type>|*) [<node>]
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR Usage: GETLRSRC <rname> [<proc_type>|* <node>]'
		rn = words[1]
		rt = bmgr_global.G_ResourceManager.resourceType(rn)
		if not rt in ['l','lp']:
			return 'NF Invalid local resource <%s>' % rn
		if len(words) <= 2:
			pt = '*'
		else:
			pt = words[2]
		nname = ''
		if pt == '*':	
			pt = None
			if len(words) > 3:	nname = words[3]
		usage = 0
		cap = 0
		try:
			#print 'getLocalResource(%s, %s, %s) ->' % (nname, rn, pt)
			usage, cap = bmgr_global.G_ResourceManager.getLocalResource(
					nname, rn, pt)
			#print usage, cap
		except RM.Invalid_ProcType:
			return 'NF process type <%s> not found' % pt
		except RM.Invalid_Resource:
			return 'NF Invalid local resource <%s>' % rn
		except RM.Unknown_Host:
			return 'NF Unknown node <%s>' % nname
		except:
			#print 'NetIF.getLocalRsrc(%s)' % msg
			fbs_misc.printTraceback()
			return 'ERR Resource Manager error %s %s' %(
				sys.exc_type, sys.exc_value)
		return 'OK %s %s' % (usage, cap)
			
	def lockQueue(self, msg):
		# LCKQ <qname>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR F Usage: LCKQ <qname>'
		qn = words[1]
		if not bmgr_global.G_QueueFinder.hasQueue(qn):
			return 'NF Queue <%s> not found' % qn
		q = bmgr_global.G_QueueFinder[qn]
		# check permissions here
		q.lock()
		self.log('I', 'lock queue <%s>' % qn)
		self.saveFarmConfig('lock queue <%s>' % qn)
		return 'OK'

	def unlockQueue(self, msg):
		# UNLCKQ <qname>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR F Usage: UNLCKQ <qname>'
		qn = words[1]
		if not bmgr_global.G_QueueFinder.hasQueue(qn):
			return 'NF Queue <%s> not found' % qn
		q = bmgr_global.G_QueueFinder[qn]
		# check permissions here
		q.unlock()
		self.log('I', 'unlock queue <%s>' % qn)
		self.saveFarmConfig('unlock queue <%s>' % qn)
		return 'OK'

	def holdQueue(self, msg):
		# HOLDQ <qname>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR F Usage: HOLDQ <qname>'
		qn = words[1]
		if not bmgr_global.G_QueueFinder.hasQueue(qn):
			return 'NF Queue <%s> not found' % qn
		q = bmgr_global.G_QueueFinder[qn]
		sts, reason = q.hold(self.isAdmin(), self.Username)
		if not sts:
			return reason
		self.log('I', 'hold queue <%s>' %  qn)
		self.saveFarmConfig('hold queue <%s>' % qn)
		self.kickSch()
		return 'OK'

	def releaseQueue(self, msg):
		# RELQ <qname>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR F Usage: RELQ <qname>'
		qn = words[1]
		if not bmgr_global.G_QueueFinder.hasQueue(qn):
			return 'ERR E Queue %s not found' % qn
		q = bmgr_global.G_QueueFinder[qn]
		sts, reason = q.release(self.isAdmin(), self.Username)
		if not sts:
			return reason
		self.log('I', 'release queue <%s>' % qn)
		self.saveFarmConfig('release queue <%s>' % qn)
		self.kickSch()
		return 'OK'

	def getQueues(self, msg):
		# GETQS
		return 'OK %s' % string.join(bmgr_global.G_QueueFinder.queues())
		
	def getQueue(self, msg):
		# GETQ <qname>
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR F Usage: GETQ <qname>'
		qn = words[1]
		if not bmgr_global.G_QueueFinder.hasQueue(qn):
			return 'NF Queue <%s> not found' % qn
		q = bmgr_global.G_QueueFinder[qn]
		slst = []
		ssts = {}
		sprio = {}
		for sid in q.sections():
			try:	s = bmgr_global.G_JobFinder.getSection(sid)
			except: pass
			else:
				if s != None:
					slst.append(sid)
					ssts[sid] = s.state()
					sprio[sid] = s.Prio
		dict = {'SectState':ssts, 'SectPrio':sprio, 'Sections':slst}
		for k, v in q.__dict__.items():
			if not k in ['Name','MasterList','MaxIndex']:
				dict[k] = v
		return 'OK %s' % serialize.serialize(dict)

	def incSectPrio(self, msg):
		# INCSPRIO <sid> <increment>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason

		words = Parser.parseWords(msg)
		if len(words) < 3 or type(words[2]) != type(1):
			return 'ERR F Usage: INCPRIO <sid> <increment>'
		sid = words[1]
		inc = words[2]
		s = bmgr_global.G_JobFinder.getSection(sid)
		if s == None:
			return 'NF Section <%s> not found' % sid
		if not (self.submitAllowed() and self.UID == s.UID) and not self.isAdmin():
			return 'PERM Permission denied'
		try:	
			pt = bmgr_global.G_ProcTypeFinder[s.ProcType]
			maxinc = pt.MaxPrioInc
		except: maxinc = None
		if maxinc != None:
			if inc + s.PrioInc > maxinc:
				return 'PERM Would exceed priority increment limit'
		old_prio = s.Prio
		qn = s.Queue
		try:	q = bmgr_global.G_QueueFinder[qn]
		except:
			return 'ERR E Internal error: queue <%s> not found' % qn
		q.incSectPrio(s, inc)
		if s.Prio != old_prio:
			s.PrioInc = s.PrioInc + s.Prio - old_prio
			bmgr_global.G_JobDB.saveSection(s)
		return 'OK'

	def killSection(self, msg):
		# KILLSECT <sid> [now]
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		words = string.split(msg)
		#print 'killSection(%s) :' % msg, words
		if len(words) < 2:
			return 'ERR Usage: KILLSECT <sid> [now]'
		sid = words[1]
		s = bmgr_global.G_JobFinder.getSection(sid)
		if s == None:
			return 'NF Section <%s> not found' % sid
		if not (self.submitAllowed() and s.Username == self.Username) and not self.isAdmin():
			return 'PERM Permission denied'
		else:
			now = 0
			if len(words) > 2 and words[2] == 'now':
				now = 1
			self.log('I','Kill section <%s> now:%s' % (sid, now))
			sts, reason = s.kill(now)
			if sts:
				return 'OK'
			else:
				return 'ERR %s' % reason

	def getJob(self, msg):
		# GETJOB jid
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR F Usage: GETJOB <jid>'
		jid = words[1]
		if bmgr_global.G_JobFinder.hasJob(jid):
			j = bmgr_global.G_JobFinder[jid]
			# state uid gid sect1 sect2 ...
			state = 'ended'
			for sn in j.sections():
				st = j[sn].state()
				if st == 'running':
					state = 'running'
					break
				if st in ['waiting','ready']:
					state = 'pending'
			#print 'Username = <%s>' % j.Username
			str = 'OK %s %d %d %s ' % (state, j.UID, j.GID, j.Username)
			for sn in j.sections():
				str = str + ('%s:%s ' % (sn, j[sn].SectParam.JDFSeq))
			return str
		else:
			return 'NF Job <%s> not found' % jid

	def getJobs(self, msg):
		# GETJOBS <uid or -1> <gid or -1>
		words = Parser.parseWords(msg)
		if len(words) < 4:
			return 'ERR F Usage: GETJOBS <username> <uid> <gid>'
		uid = words[2]
		if uid < 0:	uid = None
		gid = words[3]
		if gid < 0:	gid = None
		username = words[1]
		if username == 'None':	 username = None
		lst = []
		for jid in bmgr_global.G_JobFinder.jobs():
			j = bmgr_global.G_JobFinder[jid]
			if (uid == None or uid == j.UID) and\
				(gid == None or gid == j.GID) and\
				(username == None or username == j.Username):
					lst.append(jid)
		return 'OK %s' % string.join(lst)

	def killJob(self, msg):
		# KILLJOB <now> <jid> ...
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		words = string.split(msg)
		if len(words) < 3:
			return 'ERR F Usage: KILLJOB <now> <jid> ...'
		try:
			now = string.atoi(words[1])
		except:
			return 'ERR F Usage: KILLJOB <now> <jid> ...'
		sts = 'OK'
		for jid in words[2:]:
			if bmgr_global.G_JobFinder.hasJob(jid):
				j = bmgr_global.G_JobFinder[jid]
				if not (self.submitAllowed() and j.Username == self.Username) and not self.isAdmin():
					sts = 'PERM Permission denied'
					return sts
				j.kill(now)
			else:
				if sts == 'OK':
					sts = 'W Job not found: %s ' % jid
				else:
					sts = '%s %s' % (sts, jid)
			self.log('I', 'Kill job <%s> now:%s' % (jid, now))
		return sts

	def getSection(self, msg):
		# GETSECT <sid>
		#T.trace('getSection: begin')
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR F Usage: GETSECT <sid>'
		sid = words[1]
		s = bmgr_global.G_JobFinder.getSection(sid)
		if s == None:
			return 'ERR NF section <%s> not found' % sid
		lst = s.SectParam.dump()
		lst.append('SUB_TIME = %s' % fbs_misc.encodeTime(s.SubTime))
		if s.StartTime:
			lst.append('START_TIME = %s' % fbs_misc.encodeTime(s.StartTime))
		if s.EndTime:
			lst.append('END_TIME = %s' % fbs_misc.encodeTime(s.EndTime))
		lst.append('PRIO = %d' % s.Prio)
		lst.append('PRIO_INC = %s' % s.PrioInc)
		lst.append('STATE = %s' % s.state())
		lst.append('QINDEX = %d' % s.QIndex)
		if s.ExitCode != None:
			lst.append('EXITCODE = %d' % s.ExitCode)
		if s.sectRsrcDict:
			str = 'SECT_POOL_DICT = '
			for k, v in s.sectRsrcDict.items():
				str = str + '%s:%s ' % (k,v)
			lst.append(str)
		stats = []
		for i in range(s.NProc):
			try:	p = s.getProcess(i+1)
			except: stats.append('unknown')
			else:	stats.append(p.Status)
		lst.append('PSTATS = %s' % string.join(stats))
		#T.trace('getSection: before sendData()')
		self.sendData(lst, '.')
		#T.trace('getSection: end')
		return None

	def holdSection(self, msg):
		# HOLDSECT <sid> [<time>]
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		words,tstr = Parser.parseWords(msg, maxWords = 2, cvtInts = 0)
		if len(words) < 2:
			return 'ERR F Usage: HOLDSECT <sid> [<time>]'
		sid = words[1]
		t = -1
		if tstr:	t = fbs_misc.decodeTime(tstr)
		s = bmgr_global.G_JobFinder.getSection(sid)
		if s == None:
			return 'NF Section <%s> not found' % sid
		if not (self.submitAllowed and s.Username == self.Username) and not self.isAdmin():
			return 'PERM Permission denied.'
		if not s.state() in ['ready','waiting']:
			return 'W Section is not pending'
		s.hold(t)
		self.log('I', 'hold section <%s> until <%s>' % (sid, tstr))
		return 'OK'

	def releaseSection(self, msg):
		# RELSECT <sid>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR F Usage: RELSECT <sid>'
		sid = words[1]
		s = bmgr_global.G_JobFinder.getSection(sid)
		if s == None:
			return 'NF Section %s not found' % sid
		if not (self.submitAllowed() and s.Username == self.Username) and not self.isAdmin():
			return 'PERM Permission denied.'
		s.release()
		self.log('I', 'release section <%s>' % sid)
		self.kickSch()
		return 'OK'

	def getNodeClass(self, msg):
		# GETNC <name>
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR F Usage: GETNC <name>'
		ncn = words[1]
		try:	cap, nlist, ldsks, power = bmgr_global.G_ResourceManager.getNodeClass(ncn)
		except KeyError, msg: 
			return 'NF %s' % msg
		except:
			return 'ERR E Error: %s %s' % (sys.exc_type, sys.exc_value)
		#print ncn, ldsks
		return 'OK %s' % serialize.serialize((cap, nlist, ldsks, power))


	def getNode(self, msg):
		# GETNODE <name>
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR F Usage: GETNODE <name>'
		nname = words[1]
		try:
			isup = bmgr_global.G_ResourceManager.nodeIsUp(nname)
		except:
			#print 'Node not found: ', sys.exc_type, sys.exc_value
			return 'NF Node <%s> unknown' % nname
		#print 'Node %s status is ' % nname, sts
		held, reason = bmgr_global.G_ResourceManager.nodeIsHeld(nname)
		# get resource information
		# 1. get node class name
		try:	cn = bmgr_global.G_ResourceManager.getClassOfNode(nname)
		except:
			#print 'Node class not found: ', sys.exc_type, sys.exc_value
			return 'NF Node <%s> not found' % nname
		# 2. get capacity
		try:	rc, junk, junk, power = bmgr_global.G_ResourceManager.getNodeClass(cn)
		except: 
			#print 'Capacity not found: ', sys.exc_type, sys.exc_value
			return 'NF Node class <%s> not found' % cn

		# 3. get resource utilization figures from resource manager
		rsrc_dict = {}
		for rn in rc.keys():
			rsrc_dict[rn] = bmgr_global.G_ResourceManager.getLocalResource(nname, rn)
				
		# now get process ids from LauncherIF
		plst = bmgr_global.G_LauncherIF.getProcList(nname)

		return 'OK %s' % serialize.serialize((cn, isup, held, reason, rsrc_dict, plst))

	def holdNode(self, msg):
		# HOLDNODE [-d] <name> <reason>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = string.split(msg, None, 2)
		if len(words) != 3:
			return 'ERR F Usage: HOLDNODE [-d] <name> <reason>'
		disconnect = 0
		nname = words[1]
		reason = words[2]
		if words[1] == '-d':
			disconnect = 1
			words = string.split(reason, None, 1)
			if len(words) != 2:
				return 'ERR F Usage: HOLDNODE [-d] <name> <reason>'
			nname = words[0]
			reason = words[1]
		self.log('I', 'hold node <%s> disconnect: %d, reason: <%s>' % \
			(nname, disconnect, reason))

		if self.K5Principal:
			reason = '%s(%s), %s: %s' % (self.Username, self.K5Principal,
				time.ctime(time.time()), reason)
		else:
			reason = '%s, %s: %s' % (self.Username,
				time.ctime(time.time()), reason)
			
		try:		bmgr_global.G_ResourceManager.holdNode(nname, reason)
		except:
			return 'NF Node <%s> not found' % nname
		if disconnect:
			bmgr_global.G_LauncherIF.disconnectNode(nname)
		return 'OK'

	def releaseNode(self, msg):
		# RELNODE <name>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR F Usage: RELNODE <name>'
		nname = words[1]
		try:		bmgr_global.G_ResourceManager.releaseNode(nname)
		except:
			return 'NF Node <%s> not found' % nname
		self.log('I', 'release node <%s>' % nname)
		bmgr_global.G_LauncherIF.releaseNode(nname)
		self.kickSch()
		return 'OK'
	
	def disconnect(self, errmsg = ''):
		#self.log('I','Disconnect: <%s>' % errmsg)
		if errmsg:
			self.Str.send('ERR %s' % errmsg)
		self.Sel.unregister(rd = self.Sock.fileno())
		self.Sock.close()
		self.Str = None
		self.Sock = None

	def connected(self):
		return self.Str != None
		
	def continueSubmit(self, words, line):
		#print 'continueSubmit: words = ', words
		if words[0] == 'SECTION':
			# SECTION <sectname>
			if len(words) < 2:
				self.disconnect('Usage: SECTION <section name>')
			self.newSection(words[1:])
		elif words[0] == 'EOJ':
			self.endOfJob()
		else:
			self.continueSection(line)

	def endOfSection(self):
		qn = self.SectPar.Queue
		if not qn:
			return 'NF', 'Queue must be specified'
		if not bmgr_global.G_QueueFinder.hasQueue(qn):
			return 'NF', 'Queue <%s> does not exist' % qn
		q = bmgr_global.G_QueueFinder[qn]
		if q.isLocked():
			return 'ERR', 'Queue <%s> is locked' % qn
		try:	self.SectPar.addDefaults()
		except:
			return 'ERR', '%s' % sys.exc_value
		#print self.isAdmin()
		sts, reason = self.SectPar.validatePermissions(self.isAdmin())
		#print 'valperm: %s %s' % (sts, reason)
		if sts != 'OK':
			#print 'eos: returning %s %s' % (sts, reason)
			return sts, reason
		sect = Section(fbs_misc.encodeSectionID(self.JobID, self.SectName),
			params = self.SectPar)
		#print 'endOfSection: username = <%s>' % self.SectPar.Username
		self.Job[self.SectName] = sect
		self.SectPar = None
		return 'OK',''
		
	def newSection(self, words):
		#print self.Job
		if self.Job == None:
			self.disconnect('Use SUBMIT first')
			return
		if self.SectPar != None:
			sts, reason = self.endOfSection()
			if sts != 'OK':
				self.Job = None
				self.SectPar = None
				self.InSubmit = 0
				self.InSection = 0
				self.disconnect('%s %s' % (sts, reason))
				return
		sname = '%s' % words[0] 	# force int -> string
		if '.' in sname or ' ' in sname:
			return 'ERR Invalid section name <%s>' % sname
		#print self.Job.sections()
		if self.Job.hasSection(sname):
			self.disconnect('Duplicating section name %s' % sname)
			return
		self.SectName = sname
		self.SectPar = SectParam()
		self.SectPar.UID=self.UID
		self.SectPar.GID=self.GID		
		self.SectPar.Username = self.Username
		self.InSection = 1
		#print 'newSection() done'
		
	def continueSection(self, txt):
		try:	self.SectPar.parseLine(txt)
		except: 
			self.disconnect('Error parsing line <%s>: %s %s' % 
				(txt, sys.exc_type, sys.exc_value))
			fbs_misc.printTraceback()
			return
		
	def endOfJob(self):
		if self.SectPar == None:
			self.Job = None
			self.SectPar = None
			self.InSubmit = 0
			self.InSection = 0
			self.disconnect('Empty job')
			return
		sts, reason = self.endOfSection()
		if sts != 'OK':
			self.Job = None
			self.SectPar = None
			self.InSubmit = 0
			self.InSection = 0
			self.disconnect('%s %s' % (sts, reason))
			#print 'disconnected'
			return
		bmgr_global.G_JobFinder[self.JobID] = self.Job		
		try:	self.Job.submit()
		except ValueError, txt:
			self.Job = None
			self.SectPar = None
			self.InSubmit = 0
			self.InSection = 0
			self.disconnect('%s' % txt)
			return
		for sid in self.Job.sections():
			bmgr_global.G_JobDB.saveSection(self.Job[sid])
		self.Job = None
		self.SectPar = None
		self.Str.send('OK %s' % self.JobID)
		#self.disconnect()
		self.InSubmit = 0
		self.InSection = 0
		self.kickSch()

	def sendData(self, lst, eod):
		#T.trace('sendData: begin')
		head = 'DATA %s' % eod
		self.Str.send([head] + lst + [eod])
		#T.trace('sendData(): sent <%s>' % lst)
		
	# dynamic re-configuration messages
			
	def addNodeClass(self, msg):
		# ADDNC <ptname>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR E Usage: ADDNC <name>'
		ncn = words[1]
		try:	bmgr_global.G_ResourceManager.addNodeClass(ncn)
		except ValueError, msg:
			return 'ERR %s' % msg
		self.log('I', 'create node class <%s>' % ncn)
		self.saveFarmConfig('added node class %s' % ncn)
		return 'OK'

	def remNodeClass(self, msg):
		# REMNC <ptname>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR E Usage: REMNC <name>'
		ncn = words[1]
		try:	bmgr_global.G_ResourceManager.removeNodeClass(ncn)
		except KeyError, txt:
			return 'NF %s' % txt
		except ValueError, txt:
			return 'ERR %s' % txt
		self.log('I', 'removed node class <%s>' % ncn)
		self.saveFarmConfig('removed node class %s' % ncn)
		return 'OK'
		
	def setNodeClass(self, msg):
		# SETNC <ncname> RSRC <rsrc dict>
		# SETNC <ncname> LDSK <local disks dict>
		# SETNC <ncname> POWER <power>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words, rest = Parser.parseWords(msg, maxWords = 3)
		if len(words) < 3 or not rest:
			return 'ERR E Usage: SETNC <ncname> <what> <value>'
		ncn = words[1]
		what = words[2]
		if what == 'RSRC':
			value, rest = serialize.deserialize(rest)
			if type(value) != type({}):
				return 'ERR E valueionary is required'
			try:	bmgr_global.G_ResourceManager.setNodeClassRsrc(ncn, value)
			except KeyError, msg:
				return 'NF %s' % msg
			except ValueError, msg:
				return 'ERR %s' % msg
			self.saveFarmConfig('modified resources for node class %s: %s' % 
				(ncn, value))
		elif what == 'LDSK':
			value, rest = serialize.deserialize(rest)
			if type(value) != type({}):
				return 'ERR E valueionary is required'
			try:	bmgr_global.G_ResourceManager.setNodeClassLDisks(ncn, value)
			except KeyError, msg:
				return 'NF %s' % msg
			except ValueError, msg:
				return 'ERR %s' % msg
			self.saveFarmConfig('modified local disks for node class %s: %s' %
				(ncn, value))
		elif what == 'POWER':
			value, rest = serialize.deserialize(rest)
			if type(value) == type(1):
				value = float(value)
			if type(value) != type(1.0):
				return 'ERR E floating point value value required'
			try:	bmgr_global.G_ResourceManager.setNodeClassPower(ncn, value)
			except KeyError, msg:
				return 'NF %s' % msg
			except ValueError, msg:
				return 'ERR %s' % msg
			self.saveFarmConfig('modified value for node class %s: %s' %
				(ncn, value))
		else:
			return 'ERR E Unknown argument <%s>' % what
		self.log('I', 'modify node class <%s>/<%s>=<%s>' % (ncn, what, value))
		return 'OK'

	def addProcType(self, msg):
		# ADDPT <ptname>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR E Usage: ADDPT <ptname>'
		pt = words[1]
		try:	bmgr_global.G_ProcTypeFinder.addProcType(pt)
		except ValueError, msg:
			return 'ERR %s' % msg
		bmgr_global.G_ProcTypeFinder[pt].setUsers([])
		self.saveFarmConfig('added process type %s' % pt)
		self.log('I', 'create process type <%s>' % pt)
		return 'OK'

	def remProcType(self, msg):
		# REMPT <ptname>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR E Usage: REMPT <ptname>'
		ptn = words[1]

		# check if any pending section needs it
		jid = bmgr_global.G_JobFinder.procTypeInUse(ptn)
		if jid:
			return 'ERR Process type <%s> used by job <%s>' % (ptn, jid)

		# check if any queue needs it
		qn = bmgr_global.G_QueueFinder.procTypeInUse(ptn)
		if qn:
			return 'ERR Process type <%s> is default for queue <%s>' % (ptn, qn)

		try:	sts, reason = bmgr_global.G_ProcTypeFinder.remProcType(ptn)
		except KeyError, txt:
			return 'NF %s' % txt
		except ValueError, txt:
			return 'ERR %s' % txt
		if not sts:
			return 'ERR %s' % reason
		self.saveFarmConfig('removed process type %s' % ptn)
		self.log('I', 'removed process type <%s>' % ptn)
		return 'OK'

	def setProcType(self, msg):
		# SETPT <proctype> QUOTA <quota dict>
		# SETPT <proctype> PRDEF <proc defaults dict>
		# SETPT <proctype> SRDEF <sect defaults dict>
		# SETPT <proctype> MAXPI <value>
		# SETPT <proctype> NODESA <node> ...
		# SETPT <proctype> NODESD <node> ...
		# SETPT <proctype> USERS <username> ...
		# SETPT <proctype> MAXNODES <n>
		# SETPT <proctype> NICE <min nice>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		admin = self.isAdmin()
		words, rest = Parser.parseWords(msg, maxWords = 3)
		if len(words) < 3 or not rest:
			return 'ERR E Usage: SETPT <ptname> <what> <value>'
		ptn = words[1]
		what = words[2]
		val, rest = serialize.deserialize(rest)
		try:
			pt = bmgr_global.G_ProcTypeFinder[ptn]
		except KeyError, msg:
			return 'NF %s' % msg
		
		sts, reason = pt.setParams(admin, self.Username, what, val)
		if sts != 'OK':
			self.log('I', 'proc type modification failed: %s %s %s' % (ptn, what, val))
			return '%s %s' % (sts, reason)
		self.saveFarmConfig('modified %s for process type %s: %s' %
			(what, ptn, val))
		self.log('I', 'modify process type <%s>: %s %s' % (ptn, what, val))
		return 'OK'

	def addNode(self, msg):
		# ADDNODE <class> <node>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = string.split(msg)
		if len(words) < 3:
			return 'ERR E Usage: ADDNODE <class> <node>'
		nn = words[2]
		cn = words[1]
		try:
			bmgr_global.G_ResourceManager.addNode(cn, nn)
		except ValueError, txt:
			return 'ERR E %s' % txt
		except KeyError, txt:
			return 'NF %s' % txt
		self.log('I', 'add node <%s> to <%s>' % (nn, cn))
		self.saveFarmConfig('added node %s to class %s' % (nn, cn))
		return 'OK'

	def remNode(self, msg):
		# REMNODE <node>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR E Usage: REMNODE <node>'
		nn = words[1]
		if bmgr_global.G_LauncherIF.getProcList(nn):
			return 'ERR Node <%s> is in use' % nn
		bmgr_global.G_LauncherIF.disconnectNode(nn)
		try:
			bmgr_global.G_ResourceManager.removeNode(nn)
		except ValueError, txt:
			return 'ERR E %s' % txt
		except KeyError, txt:
			return 'NF %s' % txt
		self.log('I', 'remove node <%s>' % nn)
		self.saveFarmConfig('removed node %s' % nn)
		return 'OK'

	def addGlobalResource(self, msg):
		# ADDGR <name> <cap>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = Parser.parseWords(msg)
		if len(words) < 3:
			return 'ERR E Usage: ADDGR <name> <cap>'
		gr = words[1]
		cap = words[2]
		try:
			bmgr_global.G_ResourceManager.addGlobalResource(gr, cap)
		except ValueError, txt:
			return 'ERR E %s' % txt
		except KeyError, txt:
			return 'NF %s' % txt
		self.log('I', 'create global resource <%s>:<%s>' % (gr, cap))
		self.saveFarmConfig('added global resource %s:%s' % (gr, cap))
		return 'OK'

	def addLocalResource(self, msg):
		# ADDLR <name>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = Parser.parseWords(msg)
		if len(words) < 2:
			return 'ERR E Usage: ADDLR <name>'
		rn = words[1]
		try:
			bmgr_global.G_ResourceManager.addLocalResource(rn)
		except ValueError, txt:
			return 'ERR E %s' % txt
		except KeyError, txt:
			return 'NF %s' % txt
		self.log('I', 'create local resource <%s>' % rn)
		self.saveFarmConfig('added local resource %s' % rn)
		return 'OK'


	def setGlobalResource(self, msg):
		# SETGR <name> <cap>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = Parser.parseWords(msg)
		if len(words) < 3:
			return 'ERR E Usage: SETGR <name> <cap>'
		gr = words[1]
		cap = words[2]
		try:
			bmgr_global.G_ResourceManager.setGlobalResource(gr, cap)
		except ValueError, txt:
			return 'ERR E %s' % txt
		except KeyError, txt:
			return 'NF %s' % txt
		self.log('I', 'modify global resource <%s>: <%s>' % (gr, cap))
		self.saveFarmConfig('set global resource %s capacity to %s' %
			(gr, cap))
		return 'OK'

	def remGlobalResource(self, msg):
		# REMGR <name>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR E Usage: REMGR <name>'
		gr = words[1]
		jid = bmgr_global.G_JobFinder.resourceInUse(gr)
		if jid:
			return 'ERR Resource <%s> requested by job <%s>' % (gr, jid)
		try:
			bmgr_global.G_ResourceManager.removeGlobalResource(gr)
		except ValueError, txt:
			return 'ERR E %s' % txt
		except KeyError, txt:
			return 'NF %s' % txt
		self.log('I', 'removed global resource <%s>' % gr)
		self.saveFarmConfig('removed global resource %s' % gr)
		return 'OK'

	def remLocalResource(self, msg):
		# REMLR <name>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR E Usage: REMGR <name>'
		rn = words[1]
		jid = bmgr_global.G_JobFinder.resourceInUse(rn)
		if jid:
			return 'ERR Resource <%s> requested by job <%s>' % (rn, jid)
		try:
			bmgr_global.G_ResourceManager.removeLocalResource(rn)
		except ValueError, txt:
			return 'ERR %s' % txt
		except KeyError, txt:
			return 'NF %s' % txt
		self.log('I', 'removed local resource <%s>' % rn)
		self.saveFarmConfig('removed local resource %s' % rn)
		return 'OK'

	def remRsrcPool(self, msg):
		# REMRP <name>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR E Usage: REMRP <name>'
		rp = words[1]
		jid = bmgr_global.G_JobFinder.resourceInUse(rp)
		if jid:
			return 'ERR Pool <%s> requested by job <%s>' % (rp, jid)
		try:
			bmgr_global.G_ResourceManager.removeRsrcPool(rp)
		except ValueError, txt:
			return 'ERR E %s' % txt
		except KeyError, txt:
			return 'NF %s' % txt
		self.log('I', 'removed resource pool <%s>' % rp)
		self.saveFarmConfig('removed resource pool %s' % rp)
		return 'OK'

	def getRsrcPool(self, msg):
		# GETRP <name>
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR E Usage: GETRP <name>'
		rp = words[1]
		try:
			lst = bmgr_global.G_ResourceManager.getRsrcPool(rp)
		except ValueError, txt:
			return 'ERR E %s' % txt
		except KeyError, txt:
			return 'NF %s' % txt
		return 'OK %s' % string.join(lst)

	def addRsrcPool(self, msg):
		# ADDRP <name> <ur> ...
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = string.split(msg)
		if len(words) < 3:
			return 'ERR E Usage: ADDRP <name> <ur> ...'
		rp = words[1]
		lst = words[2:]
		try:
			bmgr_global.G_ResourceManager.addRsrcPool(rp, lst)
		except ValueError, txt:
			return 'ERR E %s' % txt
		except KeyError, txt:
			return 'NF %s' % txt
		self.log('I', 'create resource pool <%s>: %s' % (rp, string.join(lst)))
		self.saveFarmConfig('added resource pool %s: %s' % (rp, string.join(lst)))
		return 'OK'

	def setRsrcPool(self, msg):
		# SETRP <name> <ur> ...
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = string.split(msg)
		if len(words) < 3:
			return 'ERR E Usage: SETRP <name> <ur> ...'
		rp = words[1]
		lst = words[2:]
		try:
			bmgr_global.G_ResourceManager.setRsrcPool(rp, lst)
		except ValueError, txt:
			return 'ERR E %s' % txt
		except KeyError, txt:
			return 'NF %s' % txt
		self.log('I', 'modify resource pool <%s>: %s' % (rp, string.join(lst)))
		self.saveFarmConfig('set resource pool %s to %s' % (rp, lst))
		return 'OK'

	def getLocalPoolList(self, msg):
		return 'OK %s' % string.join(bmgr_global.G_ResourceManager.getLocalPoolList())

	def getGlobalPoolList(self, msg):
		return 'OK %s' % string.join(bmgr_global.G_ResourceManager.getGlobalPoolList())

	def getGlobalRsrcList(self, msg):
		return 'OK %s' % string.join(bmgr_global.G_ResourceManager.getGlobalList())

	def getLocalRsrcList(self, msg):
		return 'OK %s' % string.join(bmgr_global.G_ResourceManager.getLocalList())

	def getNodeClassList(self, msg):
		return 'OK %s' % string.join(bmgr_global.G_ResourceManager.getNodeClassList())

	def getProcTypeList(self, msg):
		return 'OK %s' % string.join(bmgr_global.G_ProcTypeFinder.keys())

	def getNodeList(self, msg):
		# GETNODEL	[<class>]
		ncn = None
		words = string.split(msg)
		if len(words) > 1:
			ncn = words[1]
		try:	
			lst = bmgr_global.G_ResourceManager.getNodeList(ncn)
		except KeyError, txt:
			return 'NF %s' % txt
		return 'OK %s' % string.join(lst)
		
	def setQueueParams(self, msg):
		# SETQUE <name> <args>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		words, rest = Parser.parseWords(msg, maxWords=2)
		if len(words) < 2:
			return 'ERR Usage: SETQUE <name> <args>'
		qn = words[1]
		try:	q = bmgr_global.G_QueueFinder[qn]
		except:
			return 'NF Queue <%s> not found'
		isAdmin = self.isAdmin()
		try:	dict, junk = serialize.deserialize(rest)
		except:
			return 'ERR argument syntax error'
		sts, reason = q.setParams(dict, isAdmin, self.Username)
		if sts != 'OK':
			return '%s %s' % (sts, reason)
		self.log('I', 'modify queue <%s>: %s' % (qn, dict))
		self.saveFarmConfig('modified queue %s parameters: %s' % (qn, dict))
		return 'OK'

	def addQueue(self, msg):
		# ADDQ <name> [<defpt>]
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		admin = self.isAdmin()
		if not admin:
			return 'PERM Permission denied'

		words = string.split(string.strip(msg))
		if len(words) < 2:
			return 'ERR E Usage: ADDQ <name> [<default pt>]'
		qn = words[1]
		dpt = None
		if len(words) > 2:
			dpt = words[2]
		if bmgr_global.G_QueueFinder.hasQueue(qn):
			return 'ERR E Queue <%s> already exists' % qn
		if dpt:
			try:	bmgr_global.G_ProcTypeFinder[dpt]
			except:
				return 'NF Process type <%s> not found' % dpt
		q = Queue(qn)
		if dpt: 	q.setParams({'DefProcType':dpt}, admin, self.Username)
		q.lock()
		bmgr_global.G_QueueFinder[qn] = q
		self.log('I', 'create queue <%s>: <%s>' % (qn, dpt))
		self.saveFarmConfig('added queue %s with process type %s' % (qn, dpt))
		return 'OK'
			
	def remQueue(self, msg):
		# REMQ <name>
		sts, reason = self.kAuth()
		if not sts:
			return 'PERM Client authentication failed: %s' % reason
		if not self.isAdmin():
			return 'PERM Permission denied'
		words = string.split(msg)
		if len(words) < 2:
			return 'ERR E Usage: REMQ <name>'
		qn = words[1]
		if not bmgr_global.G_QueueFinder.hasQueue(qn):
			return 'NF Queue <%s> not found' % qn
		q = bmgr_global.G_QueueFinder[qn]
		if not q.isEmpty():
			return 'ERR Queue <%s> is not empty' % qn
		del bmgr_global.G_QueueFinder[qn]
		self.log('I', 'removed queue <%s>' % qn)
		self.saveFarmConfig('removed queue %s' % qn)
		return 'OK'

	# 
	# !!! This dictionary must go after all mentioned met;hods !!!
	#
	CmdDispatch = {
		'LCKQ': 	lockQueue,
		'UNLCKQ':	unlockQueue,
		'KILLSECT':	killSection,
		'KILLJOB':	killJob,
		'GETJOBS':	getJobs,
		'GETJOB':	getJob,
		'GETSECT':	getSection,
		'GETNODE':  getNode,
		'ADDNODE':  addNode,
		'REMNODE':  remNode,
		'GETNODEL': getNodeList,
		'GETGRSRC': getGlobalRsrc,
		'GETLRSRC': getLocalRsrc,
		'HOLDSECT':	holdSection,
		'HOLDNODE':	holdNode,
		'RELSECT':	releaseSection,
		'RELNODE':	releaseNode,
		'INCSPRIO':	incSectPrio,
		'GETQ': 	getQueue,
		'SETQ': 	setQueueParams,
		'ADDQ': 	addQueue,
		'REMQ': 	remQueue,
		'GETQS':	getQueues,
		'HOLDQ':	holdQueue,
		'RELQ': 	releaseQueue,
		'GETPROC':	getProcess,
		#'GETPTUSG': getProcTypeUsage,
		'GETNC':	getNodeClass,
		'ADDNC':	addNodeClass,
		'REMNC':	remNodeClass,
		'SETNC':	setNodeClass,
		'GETPT':	getProcType,
		'ADDPT':	addProcType,
		'REMPT':	remProcType,
		'SETPT':	setProcType,
		'ADDGR':	addGlobalResource,
		'SETGR':	setGlobalResource,
		'ADDLR':	addLocalResource,
		'REMLR':	remLocalResource,
		'REMGR':	remGlobalResource,
		'ADDRP':	addRsrcPool,
		'SETRP':	setRsrcPool,
		'GETRP':	getRsrcPool,
		'GETLPL':	getLocalPoolList,
		'GETGPL':	getGlobalPoolList,
		'REMRP':	remRsrcPool,
		'GETLRL':	getLocalRsrcList,
		'GETGRL':	getGlobalRsrcList,
		'GETNCL':	getNodeClassList,
		'GETPTL':	getProcTypeList
	}

class	NetworkIF(TCPServer):
	def __init__(self, cfg, sel):
		self.Port = cfg.getValue('bmgr','*','api_port')
		if self.Port == None:
			raise ValueError, 'Batch Manager API port must be specified'
		self.Sel = sel
		self.K5Required = cfg.getValue('kerberos','*','client_auth_required', 'no')
		#print 'krb required:', self.K5Required
		self.K5Required = (self.K5Required == 'yes') or (self.K5Required == 1)
		self.Cfg = cfg
		if self.K5Required:
			self.initK5(cfg)
		TCPServer.__init__(self, self.Port, sel, enabled = 0)

	def initK5(self, cfg):
		#print 'initK5 started...'
		sys.stdout.flush()
		if not NetIF_k5imported:
			raise NameError, 'Module krb5 not found'
		princ = cfg.getValue('kerberos','*','principal','fbs')
		lst = string.split(princ,'/',1)
		if len(lst) > 1:
			self.K5SvcPrinc = krb5.get_svc_principal(lst[0], lst[1])
		else:
			self.K5SvcPrinc = krb5.get_svc_principal(princ)
		
		self.K5KeyTabFile = cfg.getValue('kerberos','*','keytab')
		if self.K5KeyTabFile == None:
			raise ValueError, 'K5 keytab file must be configured'
		krb5.kt_resolve(self.K5KeyTabFile)
		#print 'initK5 done'
		sys.stdout.flush()

	def log(self, lvl, msg):
		bmgr_global.G_LogClient.log(lvl, 0, 'NetIF: %s' % msg)
	
	def createClientInterface(self, sock, addr, sel):
		#self.log('I','Connection request from %s' % repr(addr))
		NetworkClient(self, sock, addr, sel)

	def enable(self):
		self.log('I','Enabled at port %s' % self.Port)
		self.enableServer()

	def k5Required(self):
		return self.K5Required
		
	def k5SvcPrincipal(self):
		return self.K5SvcPrinc
		
	def k5UserName(self, princ):
		try:
			uh, r = tuple(string.split(princ,'@'))
		except:
			return None
		if string.lower(r) != string.lower(krb5.get_default_realm()):
			return None
		try:
			un = string.split(uh,'/')[0]
		except:
			return None
		return un

	def checkUserPrincipal(self, princ, username):
		princlist = self.Cfg.getValueList('user_profile',username,
			'principals')
		if not princlist:
			return self.k5UserName(princ) == username
		princlist = princlist[:]
		deflist = self.Cfg.getValueList('user_profile','***',
				'principals')
		if not deflist: deflist = []
		deflist = deflist[:]
		if princlist[0] == '+':
			princlist = princlist[1:] + deflist
			for pr in princlist:
				pr = string.replace(pr, '%u', username)
				if fnmatch.fnmatch(princ, pr):
					return 1
		elif princlist[0] == '-':
			match = 0
			for pr in deflist:
				pr = string.replace(pr, '%u', username)
				if fnmatch.fnmatch(princ, pr):
					match = 1
					break
			if match:
				for pr in princlist[1:]:
					pr = string.replace(pr, '%u', username)
					if fnmatch.fnmatch(princ, pr):
						return 0
			return match
		else:
			for pr in princlist:
				pr = string.replace(pr, '%u', username)
				if fnmatch.fnmatch(princ, pr):
					return 1
		return 0
		
	#def k5KeyTabFile(self):
	#	return self.K5KeyTabFile
		
