#
# @(#) $Id: PTypeFinder.py,v 1.6 2001/09/10 20:44:31 ivm Exp $
#
# $Log: PTypeFinder.py,v $
# Revision 1.6  2001/09/10 20:44:31  ivm
# Removed debug print-outs
#
# Revision 1.5  2001/06/12 19:47:52  ivm
# Updated for Python v2.1
#
# Revision 1.4  2001/05/29 21:49:10  ivm
# Fixed bug in remove proc type
#
# Revision 1.3  2001/05/11 13:46:20  ivm
# Fixed bugs with PT and Queue creation
#
# Revision 1.2  2001/03/13 15:59:01  ivm
# Fixed bugs in object ownership
#
# Revision 1.1  2001/03/12 19:28:37  ivm
# Added "object ownersip" feature
#
#



from PType import *
import bmgr_global


class	ProcTypeFinder:
	def __init__(self, cfg):
		self.PTypes = {}
		#print cfg.ids('proc_type')
		for ptn in cfg.ids('proc_type'):
			#print 'creating ProcType %s' % ptn
			pt = ProcType(ptn, cfg)
			#print 'ProcType %s created' % ptn
			self.PTypes[ptn] = pt
		#print 'PTFinder created'
			
	def __getitem__(self, ptn):
		return self.PTypes[ptn]
		
	def remProcType(self, ptn):
		usg = self[ptn].getUsageDict()
		if len(usg):
			return 0, 'Process type in use'
		del self.PTypes[ptn]
		return 1, 'OK'
		

	def items(self):
		return self.PTypes.items()
		
	def values(self):
		return self.PTypes.values()

	def has_key(self, ptn):
		return self.PTypes.has_key(ptn)

	def keys(self):
		return self.PTypes.keys()

	def currentConfig(self, add_to = None):
		# returns a dictionary:
		# set_type -> 
		#	{ set_id or '' ->
		#		{ field -> value or [values] or dict }
		if add_to == None:
			cfg_dict = {}
		else:
			cfg_dict = add_to
		set_dict = {}
		for ptn, pt in self.PTypes.items():
			set_dict[ptn] = pt.configDict()
		cfg_dict['proc_type'] = set_dict
		return cfg_dict

	def addProcType(self, ptn):
		if self.PTypes.has_key(ptn):
			raise ValueError, 'Process type <%s> already exists' % ptn
		pt = ProcType(ptn)
		pt.setUsers([])
		self.PTypes[ptn] = pt
		bmgr_global.G_ResourceManager.initProcType(pt)
		
