#
# @(#) $Id: QueueFinder.py,v 1.6 2000/10/26 17:03:26 ivm Exp $
#
# $Author: ivm $
#
# $Log: QueueFinder.py,v $
# Revision 1.6  2000/10/26 17:03:26  ivm
# Added additional checks for resources and ptypes before removal
# Added "remove" functions to farm_config
#
# Revision 1.5  2000/08/18 21:15:40  ivm
# Implemented dynamic re-configuration
#
# Revision 1.4  2000/01/31 21:39:24  ivm
# Fixed more trivial bugs
#
# Revision 1.2  2000/01/06 15:21:31  ivm
# empty
#
# Revision 1.1  1999/12/24 17:10:27  ivm
# Added files
#
#

from Queue import *

class	QueueFinder:
	def __init__(self, cfg):
		self.Queues = {}
		for qn in cfg.ids('queue'):
			self.Queues[qn] = Queue(qn, cfg)
	
	def __getitem__(self, qname):
		return self.Queues[qname]
		
	def __setitem__(self, qname, q):
		self.Queues[qname] = q
		
	def __delitem__(self, qname):
		del self.Queues[qname]
		
	def queues(self):
		return self.Queues.keys()
		
	def hasQueue(self, qname):
		return self.Queues.has_key(qname)

	def currentConfig(self, add_to = None):
		# returns a dictionary:
		# set_type -> 
		#	{ set_id or '' ->
		#		{ field -> value or [values] or dict }
		
		if add_to == None:
			cfg_dict = {}
		else:
			cfg_dict = add_to
		
		set_dict = {}
		for qn, q in self.Queues.items():
			set_dict[qn] = q.configDict()
		cfg_dict['queue'] = set_dict
		return cfg_dict
		
	def procTypeInUse(self, ptn):
		for q in self.Queues.values():
			if q.DefProcType == ptn:
				return q.Name
		return None
