#
# @(#) $Id: Tracer.py,v 1.2 2001/10/24 18:34:37 ivm Exp $
#
# $Log: Tracer.py,v $
# Revision 1.2  2001/10/24 18:34:37  ivm
# Implemented ProcType.max_nodes
# Fixed section priority incrementing
#
# Revision 1.1  2000/03/29 22:58:41  ivm
# Added Tracer
#
#

import time

class	Tracer:
	def __init__(self):
		self.Trace = []
		self.T0 = time.time()
		
	def clear(self):
		self.Trace = []
		
	def start(self):
		self.T0 = time.time()
		
	def trace(self, point):
		self.Trace.append((time.time() - self.T0, point))
		
	def show(self):
		tlast = 0
		for t, p in self.Trace:
			print '%f %f %s' % (t, t-tlast, p)
			tlast = t
	
	def dump(self):
		lst = []
		for t, p in self.Trace:
			lst.append((t, p))
		return lst
		

T = Tracer()
