#
# @(#) $Id: bmgr.py,v 1.25 2001/06/12 19:47:52 ivm Exp $
#
# $Author: ivm $
#
# $Log: bmgr.py,v $
# Revision 1.25  2001/06/12 19:47:52  ivm
# Updated for Python v2.1
#
# Revision 1.24  2001/04/03 16:04:31  ivm
# Fixed and tested Events
#
# Revision 1.22  2001/03/26 19:43:05  ivm
# Added EventManager
#
# Revision 1.21  2001/03/13 15:59:01  ivm
# Fixed bugs in object ownership
#
# Revision 1.20  2001/03/12 19:28:38  ivm
# Added "object ownersip" feature
#
# Revision 1.19  2001/02/05 15:49:28  ivm
# Call history.archive first time in 1 hour after start
#
# Revision 1.18  2001/01/31 20:44:43  ivm
# Make Timer more tolerant to system clock shifts
#
# Revision 1.17  2001/01/22 16:52:38  ivm
# Notify all sections mentioned by launcher on node-up
#
# Revision 1.15  2000/12/21 18:04:46  ivm
# Call LogClient.idle()
#
# Revision 1.14  2000/11/13 21:44:49  ivm
# Implemented invariance on elapsed time and section size
#
# Revision 1.13  2000/10/06 00:27:44  ivm
# Fixed bug in Lchif.nodeUp() with unsubscribe
# Use PID in bmgr's id for logger
#
# Revision 1.12  2000/10/05 15:22:20  ivm
# Added more logs to bmgr
#
# Revision 1.11  2000/10/04 15:02:15  ivm
# Moved farm_name to fbs.cfg/global
# Added missing fields to fbs.cfg example
# Copy global set in splitcfg
#
# Revision 1.10  2000/08/21 19:01:34  ivm
# Added History as a global object
#
# Revision 1.9  2000/08/18 21:15:40  ivm
# Implemented dynamic re-configuration
#
# Revision 1.8  2000/08/01 21:49:07  ivm
# Use RM.py instead or ResMgr.py
#
# Revision 1.7  2000/06/29 19:07:33  ivm
# Process signals (SIGINT, SIGHUP) only at "quiet" times
#
# Revision 1.5  2000/05/31 15:13:09  ivm
# Removed debug messages from NetIF, fixed Queue.
# Implemented probing in LaucherIF
#
# Revision 1.4  2000/05/24 22:25:00  ivm
# Do not catch all exceptions. Die instead.
#
# Revision 1.3  2000/05/23 22:02:15  ivm
# Check for non-existing job db root specification
#
# Revision 1.2  2000/05/08 15:49:10  ivm
# Separated Main.py history from bmgr.py's
#
# Revision 1.1  2000/05/08 15:48:13  ivm
# Renamed Main.py bmgr.py
#
# ------------ Main.py history ---------------
#
# Revision 1.17  2000/04/21 20:42:08  ivm
# *** empty log message ***
#
# Revision 1.16  2000/04/17 15:48:55  ivm
# Made modifications for LogClient
#
# Revision 1.15  2000/04/10 20:28:41  ivm
# Fixed some bugs
#
# Revision 1.14  2000/04/07 21:14:02  ivm
# Implemented incSectPrio()
#
# Revision 1.13  2000/03/30 21:05:02  ivm
# Removed debug print-outs
#
# Revision 1.12  2000/03/30 17:21:54  ivm
# Fixed some bugs in scheduler
# Use fast list send in API-NetIF
#
# Revision 1.10  2000/03/28 20:02:21  ivm
# Modified History and implemented some history functionality in FBSClient
#
# Revision 1.9  2000/03/10 16:13:57  ivm
# Dump traceback if exception generated by fcn() in Timer.run()
#
# Revision 1.8  2000/03/07 17:28:28  ivm
# Fixed Timer
#
# Revision 1.7  2000/02/24 15:24:31  ivm
# Added JobFinder.checkTimes(), Timer class
#
# Revision 1.6  2000/02/09 21:40:40  tlevshin
# *** empty log message ***
#
# Revision 1.5  2000/02/09 20:59:49  tlevshin
# import new Resource Manager
# Resource Manager should be initiated before LIF
#
# Revision 1.4  2000/01/31 21:39:23  ivm
# Fixed more trivial bugs
#
#

import bmgr_global
import time
from JobDB import *
from Scheduler import *
from JobFinder import *
from PTypeFinder import *
from EventMgr import EventManager
from RM import *
from QueueFinder import *
from lchif import *
from NetIF import *
from config import *
from LogClient import *
from Timer import Timer
import sys
import signal
from farmcfg import *
from History import *

#from Tracer import *

Version = '$Id: bmgr.py,v 1.25 2001/06/12 19:47:52 ivm Exp $'

Sel = Selector()

GotStopSignal = 0

def handle_signal(signo, env):
	global GotStopSignal
	GotStopSignal = signo
	set_signals()

def set_signals():
	signal.signal(signal.SIGINT, handle_signal)
	signal.signal(signal.SIGHUP, handle_signal)


def main(args):
	#import getopt
	import os
	import socket
	import fbs_misc
			
	print 'Creating global objects...'
	bmgr_global.G_ServerCfg = ConfigFile(os.environ['FBS_CONFIG'])	
	print 'G_ServerCfg created'
	bmgr_global.G_FarmCfg = FarmCfg(os.environ['FBS_FARM_CONFIG'])
	print 'G_FarmCfg created'
	bmgr_global.G_JobFinder = JobFinder()
	print 'G_JobFinder created'
	bmgr_global.G_QueueFinder = QueueFinder(bmgr_global.G_FarmCfg)
	print 'G_QueueFinder created'
	bmgr_global.G_Scheduler = Scheduler(bmgr_global.G_ServerCfg)
	print 'G_Scheduler created'
	bmgr_global.G_ProcTypeFinder = ProcTypeFinder(bmgr_global.G_FarmCfg)
	print 'G_ProcTypeFinder created'
	bmgr_global.G_ResourceManager = ResourceManager(bmgr_global.G_FarmCfg)
	print 'G_ResourceManager created'
	bmgr_global.G_LauncherIF = LauncherIF(bmgr_global.G_ServerCfg, Sel)
	print 'G_LauncherIF created'
	bmgr_global.G_NetworkIF = NetworkIF(bmgr_global.G_ServerCfg, Sel)
	print 'G_NetworkIF created'
	bmgr_global.G_EventManager = EventManager(bmgr_global.G_ServerCfg, Sel)
	print 'G_EventManager created'
	bmgr_global.G_HistoryDB = History(bmgr_global.G_ServerCfg)
	print 'G_HistoryDB created'

	try:	bmgr_global.G_JobDB = FBSDB(bmgr_global.G_ServerCfg, 1)
	except:
		print 'Error opening Job database: ', sys.exc_type, sys.exc_value
		sys.exit(1)
		
	hn = socket.gethostname()
	farm_name = bmgr_global.G_ServerCfg.getValue('global','*','farm_name',hn)
	log_ign = bmgr_global.G_ServerCfg.getValue('bmgr','*','log_ignore','')
	bmgr_global.G_LogClient = LogClient(bmgr_global.G_ServerCfg,
			'bmgr', '%s.%d' % (hn, os.getpid()), log_ign)

	logc = bmgr_global.G_LogClient
	logc.log('I',0,'BMGR pid: %s version: %s' % (os.getpid(), Version))

	timer = Timer()

	logc.log('I',0,'Restoring JobDB ...')
	print 'Restoring JobDB...'
	bmgr_global.G_JobDB.restore()
	logc.log('I',0, 'Restored %d jobs' % len(bmgr_global.G_JobFinder.jobs()))
	print 'Restored %d jobs' % len(bmgr_global.G_JobFinder.jobs())
	bmgr_global.G_LauncherIF.enable()
	logc.log('I',0,'LchIF enabled')
	print 'LauncherIF enabled'
	bmgr_global.G_NetworkIF.enable()
	logc.log('I',0,'NetIF enabled')
	print 'NetworkIF enabled'

	t = time.time()
	tmo = bmgr_global.G_ServerCfg.getValue('bmgr','*','recovery_timeout',180)
	
	while time.time() < t + tmo:
		if GotStopSignal:
			logc.log('I',0,'Interrupted by signal %d' % GotStopSignal)
			logc.log('I',0,'Interrupted by signal %d' % GotStopSignal)
			logc.log('I',0,'Interrupted by signal %d' % GotStopSignal)
			print 'Interrupted by signal %d' % GotStopSignal
			sys.stdout.flush()
			return
		Sel.select(10)

	print 'End recovery...'
	logc.log('I',0,'End recovery')
	for jid in bmgr_global.G_JobFinder.jobs():
		bmgr_global.G_JobFinder[jid].endRecovery()
	
	bmgr_global.G_Scheduler.enable()
	print 'Scheduler enabled'
	logc.log('I',0, 'Scheduler enabled')

	timer.add(bmgr_global.G_Scheduler.run, 0, 10)
	timer.add(bmgr_global.G_JobFinder.checkTimes, 0, 60)
	timer.add(bmgr_global.G_LauncherIF.probe, 0, 30*60) 	# twice per hour
	timer.add(bmgr_global.G_HistoryDB.archive,
			time.time() + 60*60,	# first time in 1 hour after start
			24*60*60) 				# once per day

	while 1:
		if GotStopSignal:
			logc.log('I',0,'Interrupted by signal %d' % GotStopSignal)
			logc.log('I',0,'Interrupted by signal %d' % GotStopSignal)
			logc.log('I',0,'Interrupted by signal %d' % GotStopSignal)
			print 'Interrupted by signal %d' % GotStopSignal
			break
		#T.clear()
		#T.start()
		#T.trace('Main: begin select')
		Sel.select(10)
		#T.show()
		#print '------------------------'
		#print 'timer.run...', time.time() - t
		#t = time.time()
		#try:		timer.run()
		#except: fbs_misc.printTraceback()	# replace with dumpTraceback()
		timer.run()
		logc.idle()
		sys.stdout.flush()
	logc.idle()

if __name__ == '__main__':
	import sys
	set_signals()
	main(sys.argv[1:])
	sys.stdout.flush()
	sys.stderr.flush()
