# @(#) $Id: cprio.py,v 1.3 2001/10/31 22:30:28 ivm Exp $
#
# $Log: cprio.py,v $
# Revision 1.3  2001/10/31 22:30:28  ivm
# Optimized node list sorting for ptypes with node limit
#
# Revision 1.2  2000/06/19 14:12:02  fromm
# .
#
# Revision 1.1  2000/06/06 16:10:39  fromm
# .
#

from FBS_API import *
import fbs_misc
import string
import sys
import getopt
import time 

usage = 'USAGE: cprio.py [-i <val>|-d <val>] (<jobid>|<section id>) ...'
		    
fbs_client = FBSClient()

#################################################################################

def chgprio(sid,val):
    try:
       rc,reason = fbs_client.incSectPrio(sid,val)
    except KeyError:
       print 'Section ' + sid + ' not found'
    if not rc:
       print 'Section %s: %s' % (sid, reason)

#################################################################################

try:
    optlist,args = getopt.getopt(sys.argv[1:],"i:d:h")
except getopt.error,error_msg:
    print error_msg
    sys.exit(2)

delta = 0
for opt, val in optlist:
	if opt == '-i': 	delta = int(val)
	elif opt == '-d':	delta = -int(val)
	elif opt == '-h':
		print usage
		sys.exit(2)

slst = []   
for jsid in args:
	tup = fbs_misc.decodeDotID(jsid)
	if len(tup) == 1:
		try:	j = fbs_client.getJob(jsid)
		except KeyError:
			print 'Job %s not found' % jsid
			continue
		for sn in j.sections():
			sid = fbs_misc.encodeSectionID(jsid, sn)
			slst.append(sid)
	else:
		slst.append(jsid)

for sid in slst:
	chgprio(sid, delta)
	
