#
# @(#) $Id: farm_sysmon.py,v 1.1 2000/09/29 16:23:01 fromm Exp $
#
# $Log: farm_sysmon.py,v $
# Revision 1.1  2000/09/29 16:23:01  fromm
# New.
#
# Revision 1.12  1999/11/18 22:51:38  fromm
# Took out usage when error occurs
#
# Revision 1.11  1999/08/03 22:19:14  fromm
# Fixed bug with -g option.
#
# Revision 1.10  1999/07/23 19:58:38  fromm
# usage
#
# Revision 1.9  1999/07/21 19:34:33  fromm
# Fixed usage
#
# Revision 1.8  1999/07/02 18:51:55  fromm
# Added --help to display usage
#
# Revision 1.7  1999/06/29 18:12:08  fromm
# Fixed usage
#
# Revision 1.6  1999/06/28 21:34:52  fromm
# Fixed usage message.
#
# Revision 1.5  1999/06/16 21:29:53  fromm
# Fixed usage stmt.
#
# Revision 1.4  1999/06/11 14:21:32  ivm
# Added RCS Log records
#
#Revision 1.3  1999/06/07 18:36:49  fromm
#Fixed usage.
#
#Revision 1.2  1999/04/09 20:20:08  fromm
#Misc changes
#
####################################################################
#                                                                  #
# farm_monitor:                                                    #
#    Display monitoring information in ASCII format.               #
#                                                                  #
# Options:                                                         #
#   -c: Print CPU                                                  #
#   -p: print PAGE                                                 #
#   -s: print SWAP                                                 #
#   -i: print INTR                                                 #
#   -d: print DISK                                                 #
#   -x: print CNTXT                                                #
#   -l: print LOAD                                                 #
#   -T: print TPKTS                                                #
#   -I: print IPKTS                                                #
#   -O: print OPKTS                                                #
#   -C: print COLLS                                                #
#   -e: print ERRS                                                 #
#   -a: print all information                                      #
#   -r secs: print output every secs seconds                       #
#   -n number: When -r used, causes data to be printed number times#
#   -g: print a glossary of fields:  The titles of the columns     #
#       are printed out, delimited by |                            #
#   -u: Print usage                                                #
#                                                                  #
####################################################################

import Stats
import time
import getopt
import sys
import socket
from string import *

usage = "USAGE:farms sysmon [-cpsidxlTIOCeadgu][-r secs][-n repeat_number][--help][host]"
fields = ["CPU","PAGE","SWAP","INTR","DISK","CNTXT","LOAD","TPKTS","IPKTS","OPKTS", \
	  "COLLS","ERRS"]

######################################################################
#                                                                    #
# Options:                                                           #
#                                                                    #
#    Class to get user options.                                      #
#                                                                    #
###################################################################### 

class Options:

    def __init__(self):
	self.dict = {}
	self.dict['CPU'] = 'off'
	self.dict['PAGE'] = 'off'
	self.dict['SWAP'] = 'off'
	self.dict['INTR'] = 'off'
	self.dict['DISK'] = 'off'
	self.dict['CNTXT'] = 'off'
	self.dict['LOAD'] = 'off'
	self.dict['TPKTS'] = 'off'
	self.dict['IPKTS'] = 'off'
	self.dict['OPKTS'] = 'off'
	self.dict['COLLS'] = 'off'
	self.dict['ERRS'] = 'off'
	self.dict['ALL'] = 'off'  
	self.dict['DUMP'] = 'off'  
	self.dict["REPEAT"] = 0
	self.dict["REPEAT_N"] = 0
	self.dict["GLOSSARY"] = 'off'
	self.dict["HOST"] = []
	self.dict["USAGE"] = 'off'
	self.process_options()


    ######################################################################
    #                                                                    #
    # process_options():                                                 #
    #                                                                    #
    #    Fill in dictionary of selected options.                         #
    #                                                                    #
    ###################################################################### 

    def process_options(self):
	
	try:
	    optlist,args = getopt.getopt(sys.argv[1:],"cpsdxlTiIOeDCagn:r:",['help'])
	except getopt.error,error_msg:
            print "farms sysmon: " + error_msg
            print "Try \'farms sysmon help\' for more information"
	    sys.exit(0)
	
	for opt_element in optlist:

	    if opt_element[0] == '-a':
		self.dict['CPU'] = 'on'
		self.dict['PAGE'] = 'on'
		self.dict['SWAP'] = 'on'
		self.dict['INTR'] = 'on'
		self.dict['DISK'] = 'on'
		self.dict['CNTXT'] = 'on'
		self.dict['LOAD'] = 'on'
		self.dict['TPKTS'] = 'on'
		self.dict['IPKTS'] = 'on'
		self.dict['OPKTS'] = 'on'
		self.dict['COLLS'] = 'on'
		self.dict['ERRS'] = 'on'

	    elif opt_element[0] == '-c':
		self.dict['CPU'] = 'on'

	    elif opt_element[0] == '-p':
		self.dict['PAGE'] = 'on'

	    elif opt_element[0] == '-s':
		self.dict['SWAP'] = 'on'

	    elif opt_element[0] == '-i':
		self.dict['INTR'] = 'on'

	    elif opt_element[0] == '-d':
		self.dict['DISK'] = 'on'

	    elif opt_element[0] == '-x':
		self.dict['CNTXT'] = 'on'

	    elif opt_element[0] == '-l':
		self.dict['LOAD'] = 'on'

	    elif opt_element[0] == '-T':
		self.dict['TPKTS'] = 'on'

	    elif opt_element[0] == '-I':		
		self.dict['IPKTS'] = 'on'

	    elif opt_element[0] == '-O':
		self.dict['OPKTS'] = 'on'

	    elif opt_element[0] == '-C':
		self.dict['COLLS'] = 'on'

	    elif opt_element[0] == '-e':
		self.dict['ERRS'] = 'on'
	    
	    elif opt_element[0] == '-g':
		self.dict['GLOSSARY'] = 'on'

	    elif opt_element[0] == '-r':
		self.dict["REPEAT"] = atoi(opt_element[1])

	    elif opt_element[0] == '-D':
		self.dict["DUMP"] = 'on'

	    elif opt_element[0] == '-n':
		self.dict["REPEAT_N"] = atoi(opt_element[1])

	    elif opt_element[0] == '--help':
		self.dict["USAGE"] = 'on'

	if len(args) == 0:
	    self.dict['HOST'] = socket.gethostname()
	else:
	    self.dict['HOST'] = args[0]
		
	
######################################################################
#                                                                    #
# RemoteStat:                                                        #
#                                                                    #
###################################################################### 
			      

class RemoteStat:

    def __init__(self,hostname,update=1):
	self.hostname = hostname
	self.update = update
	self.status = Stats.connect(self.hostname)

    def getStat(self):
	if self.status:
	    return None
	else:
	    return Stats.getStat(self.hostname)


#####################################################################
#                                                                   #
# create_print_list()                                               #
#                                                                   #
##################################################################### 


def create_print_list(list,opts):

    if opts.dict['ALL'] == 'on':
	return (list)

    new_list = []

    i=0
    for field in fields:
	if (opts.dict[field] == 'on'):
	    new_list = new_list + [list[i]]
	i = i+1
    
    return new_list

#-------------------------------------------------------------------#
#                                                                   #
# blanks():  Return a blank line consisting of n characters.        #
#                                                                   #
#-------------------------------------------------------------------#

def blank_str(n):
    blanks = ""
    for i in range(n):
	blanks = blanks + ' '
    return blanks


#####################################################################
#                                                                   #
# print_heading()                                                   #
#                                                                   #
##################################################################### 

def print_heading(opts):

    print 'HOST: ',opts.dict['HOST']

    hdg_line = ""

    for field in fields:
	if (opts.dict[field] == 'on'):
	    blanks = ""
	    for i in range(8 - len(field)):
		blanks = blanks + ' '
	    hdg_line = hdg_line + field + blanks
		
    print hdg_line


#--------------------------------------------------------------------#
#                                                                    # 
# main starts here                                                   #
#                                                                    #
#--------------------------------------------------------------------#

opts = Options()
if opts.dict["USAGE"] == 'on':
    print usage
    sys.exit(0)
    
stat = RemoteStat(opts.dict['HOST'],opts.dict['REPEAT'])

if opts.dict['GLOSSARY'] == 'on':
    glossary_line = ''
    for field in fields:
	if (opts.dict[field] == 'on'):
	    glossary_line = glossary_line + field + "|"
    print glossary_line
    sys.exit(0)

if opts.dict['DUMP'] == 'off':
    print_heading(opts)

print_line = ""

if opts.dict["REPEAT"] > 0:
    repeat='yes'
else:
    repeat='no'
    opts.dict["REPEAT"] = 1
		      
#
# Throw away the first getStat.
#

status = stat.getStat()

n = 0

while 1:

    time.sleep(opts.dict["REPEAT"])
    status = stat.getStat()
    status_list = split(status)
    print_list = create_print_list(status_list,opts)
    print_line = ""

    for item in print_list:

	if opts.dict['DUMP'] == 'off':
	    blanks = blank_str(8 - len(item))
	    print_line = print_line + item + blanks
	else:
	    print_line = print_line + item + '|'

    print print_line 

    n = n + 1
    if repeat == 'no': 
	break
    elif opts.dict['REPEAT_N'] > 0:
	if n >= opts.dict['REPEAT_N']:
	    break



