#
# @(#) $Id: fbs_misc.py,v 1.23 2001/06/12 19:47:53 ivm Exp $
#
# $Author: ivm $
#
# $Log: fbs_misc.py,v $
# Revision 1.23  2001/06/12 19:47:53  ivm
# Updated for Python v2.1
#
# Revision 1.22  2000/09/27 19:56:36  ivm
# Fixed bug with line
#
# Revision 1.20  2000/09/27 15:18:55  ivm
# Added sendMail
#
# Revision 1.19  2000/08/14 20:48:31  ivm
# Make star ('*') accept everything
#
# Revision 1.18  2000/08/14 20:32:06  ivm
# Added ipMatch functions
#
# Revision 1.17  2000/06/27 19:42:02  ivm
# Send hold time as string, not floating point number
#
# Revision 1.16  2000/05/30 16:26:29  ivm
# Fixed expandPattern()
#
# Revision 1.14  2000/04/21 21:27:44  ivm
# Fixed FBSProcTypeInfo
#
# Revision 1.13  2000/04/19 14:37:27  ivm
# decode 'forever' as -1, not -1.0
#
# Revision 1.12  2000/04/10 16:24:31  ivm
# Added stripDomain() and appendDomain()
#
# Revision 1.11  2000/04/10 14:28:06  ivm
# Added deserializeDict
#
# Revision 1.10  2000/03/23 16:27:18  ivm
# Fixed bugs
#
# Revision 1.9  2000/03/14 16:38:56  ivm
# *** empty log message ***
#
# Revision 1.7  2000/03/06 21:32:52  ivm
# Fixed bug in serializeObject
#
# Revision 1.6  2000/03/06 21:26:42  ivm
# Handle empty strings
#
# Revision 1.4  2000/01/26 19:53:43  ivm
# Added encodeProcID
#
# Revision 1.3  2000/01/24 17:36:39  ivm
# Added dictionary manipulation functions
#
# Revision 1.2  2000/01/20 22:31:46  ivm
# *** empty log message ***
#
#

import string
import sys
import pwd
import cvtime
import re
import os

def sendMail(cmd, subject, addrs, msg, faddr='', reply_to=''):
# sends e-mail using external command such as ATT "mail" or
# "sendmail". "Mail" will do too, but with certain limitations.
# External command is passed as first parameter.
# <addrs> can be either string with recipient address or
# list of strings for multiple recipients.
# <msg> can be either
#	string possibly containing new-line characters, or
#	list of strings. In this case, each element of the list
#	will be sent as separate line of the message.
#	
# No line reporesented by <msg> should start with '~' or be a single
# dot (.) character string.
#
# Optionally, "From" address can "Reply-to" address can be passed
# as <faddr> and <reply_to> arguments.

	if type(addrs) != type([]):
		addrs = [addrs]
	if type(msg) != type([]):
		msg = [msg]
	line = '%s %s' % (cmd, string.join(addrs))
	#print line
	try:
		p = os.popen(line, 'w')
		if subject:
			p.write('Subject: %s\n' % subject)
		if faddr:
			p.write('From: %s\n' % faddr)
		if reply_to:
			p.write('Reply-to: %s\n' % reply_to)
		p.write('\n')
		for l in msg:
			p.write('%s\n' % l)
		p.close()
	except:
		return 0, '%s %s' % (sys.exc_type, sys.exc_value)
	return 1, 'OK'
		

def replaceStr(str, x, y):
#
# replaces all occurances of x in str with y
#
	i = string.find(str, x)
	lx = len(x)
	ly = len(y)
	while i >= 0:
		str = str[:i] + y + str[i+lx:]
		i = string.find(str, x, i+ly)
	return str

def expandPattern(uid, ptrn, jid, sname, defFN, procno=None):
#
# expands pattern used for SECT_STDOUT, STDERR, STDOUT
# into filename.
# format sequences:
#	%j - section id
#	%n - procno if not None, otherwise %n is ignored
#	%S - section name
#	%J - job id
# If ptrn ends with '/', defFN will be appended. Otherwise, defFN
# is ignored. defFN may contain format sequences.
# Unless ptrn starts with '/', it is considered to be relative
# to user's home area. uid will be used to find it. Otherwise, uid is ignored.
#
	sid = encodeSectionID(jid, sname)
	# make sure they are strings:
	if procno != None:
		procno = '%s' % procno
	jid = '%s' % jid
	if ptrn == '.':
		ptrn = './'
	if ptrn[0] != '/':
		pwrec = pwd.getpwuid(uid)
		home = pwrec[5]
		ptrn = home + '/' + ptrn
	if ptrn[-1] == '/':
		ptrn = ptrn + defFN
	str = ptrn
	if procno != None:
		str = replaceStr(str, '%n', procno)
	str = replaceStr(str, '%j', sid)
	str = replaceStr(str, '%S', sname)
	str = replaceStr(str, '%J', jid)
	return str

def stripDomain(hn, dn):
# splits full host name into hostname, domain
# examples:
#	fnpca.fnal.gov, fnal.gov	-> fnpca, fnal.gov
#	fnpca, fnal.gov				-> fnpca, ''
#	fnpca.qq.fnal.gov, fnal.gov -> fnpca.qq, fnal.gov

	hn = string.strip(hn)
	dn = string.strip(dn)
	if hn[-len(dn)-1:] == '.' + dn:
		hn = hn[:-len(dn)-1]
	else:
		dn = ''
	return hn, dn

def appendDomain(hn, dn):
# appends domain name to host name if not there yet
# examples:
#	fnpca, fnal.gov				-> fnpca.fnal.gov
#	fnpca.fnal.gov, fnal.gov	-> fnpca.fnal.gov
	hn = string.strip(hn)
	dn = string.strip(dn)
	if hn[-len(dn)-1:] != '.' + dn:
		hn = hn + '.' + dn
	return hn

def decodeDotID(str):
	items = string.split(str, '.')
	if len(items) > 2:
		try:	items[2] = string.atoi(items[2])
		except: pass
	return tuple(items[:3])

def encodeSectionID(jobID, sectName):
	return '%s.%s' % (jobID, sectName)

def encodeProcID(jobid, sname, procNo):
	return '%s.%s.%s' % (jobid, sname, procNo)

def mergeDict(d1, d2):
	# Merges dictionaries d1 and d2 into one.
	# Dictionaties are supposed to have integer values
	# if both dictionaries have same key, the resulting value
	# will be maximum of the two.
	# d[k] = max(d1[k], d2[k])
	
	d = {}
	# deep copy d1
	for k, v in d1.items():
		d[k] = v
	
	# add d2
	for k, v in d2.items():
		if not d.has_key(k) or d[k] < v:	d[k] = v

	return d
	
def addDict(self, d1, d2, mult = 1):
	# returns d1 + d2 * mult
	d = 0
	for k, v in d1.items():
		d[k] = v
	for k, v in d2.items():
		try:	u = d[k]
		except: u = 0
		d[k] = u + mult * v
	return d
			
def encodeTime(t):
	if t == None:	return 'None'
	if type(t) == type(1.0):
		t = int(t)
	if type(t) == type(1):
		if t == -1:
			return 'forever'
		return cvtime.dateTime2Str(t)
	if type(t) == type(''):
		return t
	return None
		
def decodeTime(s):
	s = string.strip(s)
	if s == 'None': return None
	if s == 'forever':
		return -1
	if type(s) == type(''):
		return cvtime.parseDateTime(s)
	return None
	
def serializeObject(obj = None, serialize_fields = None, ignore_fields = [], 
				**extra):
	lst = []
	if obj != None:
		if type(obj) == type({}):
			lst = serializeDict(obj, serialize_fields, ignore_fields)
		else:
			lst = serializeDict(obj.__dict__, serialize_fields, ignore_fields)
	lst = lst + serializeDict(extra)
	return lst

def serializeDict(dict, serialize_fields = None, ignore_fields = [], 
				**extra):
	lst = []
	if serialize_fields == None:
		fields = dict.keys()
	else:
		fields = serialize_fields

	for f in fields:
		if not f in ignore_fields:
			lst.append(serializeField(f, dict[f]))
	
	for k, v in extra.items():
		lst.append(serializeField(k, v))
	return lst
	
def serializeField(f, v):
		if type(v) == type(1):
			return	'%s = I %d' % (f,v)
		elif type(v) == type(''):
			return	'%s = S %s' % (f,v)
		elif type(v) == type(1.1):
			return	'%s = F %f' % (f,v)
		elif v == None:
			return	'%s = N' % f
		elif type(v) == type([]):
			str = 'L?'
			if v:
				x = v[0]
				if type(x) == type(1):		str = 'LI'
				elif type(x) == type(''):	str = 'LS'
				elif type(x) == type(1.1):	str = 'LF'
			for x in v:
				str = str + ' %s' % x
			return	'%s = %s' % (f, str)
		elif type(v) == type(()):
			str = '%s = T' % f
			for x in v:
				if type(x) == type(1):		str = str + ' I %d' % x
				elif type(x) == type(''):	str = str + ' S %s' % x
				elif type(x) == type(1.1):	str = str + ' F %f' % x
				elif x == None: 			str = str + ' N'
				else:
					raise ValueError, 'Unknown field type %s' % type(x)
			return	str
		else:
			raise ValueError, 'Unknown field type %s' % type(v)

def deserializeObject(obj, lst, fields = None):
	if fields == None:
		fields = obj.__dict__.keys()

	dict = deserializeDict(lst)
	for fn in fields:
		if dict.has_key(fn):
			obj.__dict__[fn] = dict[fn]	

def deserializeDict(lst):
	dict = {}
	for l in lst:
		l = string.strip(l)
		words = string.split(l)
		if len(words) < 3:		continue
		if words[1] != '=': 	continue
		fn = words[0]
		ft = words[2]
		if ft in ['I','S','F'] and len(words) < 4:	continue
		if ft == 'I':	dict[fn] = string.atoi(words[3])
		elif ft == 'F':	dict[fn] = string.atof(words[3])
		elif ft == 'S':	
			inx = string.find(l, '=')
			rest = string.strip(l[inx+1:])
			rest = string.strip(rest[1:])	# cut S out
			dict[fn] = rest
		elif ft[0] == 'L':
			lst = []
			if ft == 'LI':
				for w in words[3:]:
					lst.append(string.atoi(w))
				dict[fn] = lst
			elif ft == 'LF':
				for w in words[3:]:
					lst.append(string.atof(w))
				dict[fn] = lst
			elif ft == 'LS':
				lst = []
				for w in words[3:]:
					if w == "''":
						w = ''
					lst.append(w)
				dict[fn] = lst
		elif ft == 'T':
			words = words[3:]
			i = 0
			tup = ()
			while i < len(words):
				t = words[i]
				i = i + 1
				if t == 'N':
					v = None
				elif i < len(words):
					if t == 'I':	
						v = string.atoi(words[i])
					elif t == 'F' and i < len(words):	
						v = string.atof(words[i])
					elif t == 'S' and i < len(words):	
						v = words[i]
						if v == "''":	v = ''
					else:
						v = words[i]
					i = i + 1
				tup = tup + (v,)
			dict[fn] = tup
		elif ft == 'N':
			dict[fn] = None
		else:
			raise 'Unknown field type <%s>' % ft
	return dict

			
def printTraceback():
	et, ev, tr = sys.exc_info()
	if ev == None:
		ev = ''
	print '%s: %s' % (et, ev)
	while tr != None:
		fr = tr.tb_frame
		co = fr.f_code
		print 'File %s:%d in %s' % (
			co.co_filename, tr.tb_lineno, co.co_name)
		tr = tr.tb_next
	print '<-- end of traceback dump -->'
	
def dumpTraceback():
	lst = []
	et, ev, tr = sys.exc_info()
	while tr != None:
		fr = tr.tb_frame
		co = fr.f_code
		lst.append( 'File %s:%d in %s' % 
			(co.co_filename, tr.tb_lineno, co.co_name) )
		tr = tr.tb_next
	return lst
	
#
# IP name/address matching functions
#
def ipMatch(node, pattern):
	# dispatches to one of 3 functions:
	# ipMatchStar	for patterns beginning or ending with '*' e.g. *.fnal.gov
	# ipMatchRE 	for patterns with one or more of []() e.g. fnpc[a-d].fnal.gov
	# ipMatchRange	for patterns with {} e.g. fnpc{100-120}.fnal.gov
	if pattern[0] == '*' or pattern[-1] == '*':
		return ipMatchStar(node, pattern)
	elif string.find(pattern,'{') >= 0:
		return ipMatchRange(node, pattern)
	elif string.find(pattern,'[') >= 0 or string.find(pattern,'(') > 0:
		return ipMatchRE(node, pattern)
	else:
		return node == pattern
		
def ipMatchStar(node, pattern):
	if pattern == '*':
		return 1
	if pattern[0] == '*':
		return pattern[1:] == node[-(len(pattern)-1):]
	else:
		return pattern[:-1] == node[:len(pattern)-1]

def ipMatchRange(node, pattern):
	# expect pattern to have only one range in form {<int>-<int>}
	# expand pattern into list of node names:
	#   {1-100} -> 1,2,3,...10,11,12,...100
	#	{001-100} -> 001,002,...100
	ib1 = string.find(pattern,'{')
	if ib1 < 0:
		return 0
	ib2 = string.find(pattern, '}', ib1)
	if ib2 < 0:
		return 0
	prefix = pattern[:ib1]
	suffix = pattern[ib2+1:]
	rng = pattern[ib1+1:ib2]
	tup = tuple(string.split(rng,'-'))
	if len(tup) != 2:
		return 0
	s1, s2 = tup
	try:
		i1 = string.atoi(s1)
		i2 = string.atoi(s2)
	except:
		return 0
	if i1 > i2:
		return 0
	if len(s1) == len(s2) and s1[0] == '0':
		fmt = '%%0%dd' % len(s1)
	else:
		fmt = '%d'
	for i in range(i1, i2+1):
		if node == prefix + (fmt % i) + suffix:
			return 1
	return 0
	
def ipMatchRE(node, pattern):
	re.match(pattern, node) != None
