#
# @(#) $Id: ff_db.py,v 1.3 2000/05/30 17:01:46 ivm Exp $
#
# $Log: ff_db.py,v $
# Revision 1.3  2000/05/30 17:01:46  ivm
# Implemented checksums
#
# Revision 1.2  2000/04/07 21:14:48  ivm
# Fixed bugs
#
# Revision 1.1  2000/04/06 21:05:59  ivm
# Added JobDB.py ff_db.py
#
#

import fbs_misc
import glob
import os
import futil
import string

class	FF_DB:	
	Version = '1'
	
	def __init__(self, root, create = 0):
		while root != '/' and root[-1] == '/':
			root = root[:-1]
		self.RootDir = root
		self.VarsFN = root + '/.vars'
		if create:
			try:	os.mkdir(self.RootDir)
			except: pass
		try:	vf = open(self.VarsFN,'r')
		except: vf = None
		if vf == None and create:
			f = open(self.VarsFN,'w')
			f.close()
			vf = open(self.VarsFN,'r')
		self.Vars = fbs_misc.deserializeDict(vf.readlines())
		vf.close()

	def crc(self, str):
		x = 0
		for c in str:
			ic = ord(c)
			up = x / 0x1000000
			x = (x * 100) & 0xFFFFFF
			x = x ^ ic ^ up
		return x
	
	def makeDir(self, dname):
		try:	os.mkdir(dname)
		except: pass

	# Variable hadnling
	def __getitem__(self, vn):	# get variable value
		return self.Vars[vn]
		
	def __setitem__(self, vn, vv):
		self.Vars[vn] = vv
		self.saveVars()
	
	def __delitem__(self, vn):
		del self.Vars[vn]
		self.saveVars()

	def saveVars(self):
		f = open(self.VarsFN,'w')
		for l in fbs_misc.serializeDict(self.Vars):
			f.write(l+'\n')
		f.close()

	def saveData(self, dir, name, data):
		if dir[0] == '.':
			raise ValueError, 'Directory name must not start with dot'
		dir = '%s/%s' % (self.RootDir, dir)
		self.makeDir(dir)
		f = open('%s/%s' % (dir, name) ,'w')
		chk = self.crc(data)
		f.write('FFDBV %s\n' % self.Version)
		f.write('%d %d\n' % (len(data), chk))
		f.write(data)
		f.close()
	
	def restoreData(self, dir, name):
		dir = '%s/%s' % (self.RootDir, dir)
		f = open('%s/%s' % (dir, name) ,'r')
		data = ''
		# check version
		v = '0'
		l = f.readline()
		data = l
		if l:
			lst = string.split(l)
			if len(lst) >= 2 and lst[0] == 'FFDBV':
				v = lst[1]
				data = ''
		dl = 0
		chk = 0
		if v >= '1':
			l = f.readline()
			lst = string.split(l)
			dl = string.atoi(lst[0])
			chk = string.atoi(lst[1])
		x = f.read(1000)
		while x:
			data = data + x
			x = f.read(1000)
		f.close()
		if v >= '1':
			if len(data) != dl or self.crc(data) != chk:
				raise IOError, 'Data corruption detected'
		return data

	def dirs(self):
		return glob.glob1(self.RootDir,'*')
		
	def files(self, dir):
		dir = '%s/%s' % (self.RootDir, dir)
		return glob.glob1(dir,'*')
	
	def delDir(self, dir, delFiles = 0):
		dir = '%s/%s' % (self.RootDir, dir)
		if delFiles:
			futil.rmdirrec(dir)
		else:
			os.rmdir(dir)
		
	def delFile(self, dir, name):
		path = '%s/%s/%s' % (self.RootDir, dir, name)
		os.remove(path)
		
if __name__ == '__main__':
	db = FF_DB('./ffdb',1)
	
