#
# @(#) $Id: hosts.py,v 1.9 2003/08/20 18:58:58 ivm Exp $
#
# $Log: hosts.py,v $
# Revision 1.9  2003/08/20 18:58:58  ivm
# Implemented CPU power, round-robin-over-users scheduling inside queuei,
# other minor things.
#
# Revision 1.8  2000/12/12 19:22:11  ivm
# Removed debug print-out
# Fixed numerous errors in man pages
#
# Revision 1.7  2000/09/06 20:25:02  fromm
# took out dazed and confused.
#
# Revision 1.6  2000/05/31 15:04:04  fromm
# .
#
# Revision 1.5  2000/05/04 20:23:37  fromm
# .
#
# Revision 1.4  2000/04/25 18:31:30  fromm
# .
#
# Revision 1.3  2000/04/18 13:18:41  fromm
# cuz
#
# Revision 1.2  2000/04/06 16:17:39  fromm
# i dunno
#

from FBS_API import *
from string import *
import sys
import getopt

fbs_client = FBSClient()

long_flag = 'off'
down_flag = 'off'
held_flag = 'off'
type_flag = 'off'
node_class = None

def eligible_nodes(node_list):
    ret_list = []
    for node in node_list:
        try:
           ni = fbs_client.getNode(node)
        except KeyError:
           print 'Node <%s> not found' % node
           sys.exit(1)
        if down_flag == 'on' and ni.IsUp == 1:
                continue
        if held_flag == 'on' and ni.IsHeld == 0:
                continue
        ret_list.append(ni)
    return ret_list
        


def short_report(host_list):
    print ' %-18s %-8s %-11s %s' % \
          ('HOST','STATUS','CLASS','PROCESSES')
    print ' %-18s %-8s %-11s %s' % \
          ('----','------','-----','----------------------')
    for host in host_list:
        status = 'up'
        if not host.IsUp:   status = 'down'
        if host.IsHeld:     status = status + ':held'
        proclst = '%s:' % len(host.Processes)
        for pid in host.Processes:
            if len(proclst + pid) > 37:
                proclst = proclst + ' ...'
                break
            else:
                proclst = proclst + ' %s' % pid
            
        print ' %-18s %-8s %-11s %s' % \
              (host.Name,status,host.Class,proclst)
        
def long_report(host_list):
    for host in host_list:
        print '---------------------------------------------------------------------'
        status = 'up'
        if not host.IsUp:   status = 'down'
        if host.IsHeld:     status = status + ':held'
        
        print 'HOST: %-18s CLASS: %-16s STATUS: %-10s' % \
              (host.Name,host.Class,status,)
        if host.IsHeld == 1:
            print 'REASON HELD: ',host.HoldReason

        rsrc = ''
        for k, v in host.Resources.items():
            usg, cap = v
            str = '%s:' % k
            if cap == None:
                str = str + ('%s/(attr) ' % usg)
            else:
                str = str + ('%s/%s ' % (usg, cap))
            rsrc = rsrc + str
        print 'RESOURCES: ',rsrc
        l = 'PROCESSES: '
        for pid in host.Processes:
            if len(l) > 60:
                print l
                l = '  '
            l = l + '%s ' % pid
        print l
        
def cmpNodes(x, y):
	ix = len(x)
	while ix > 0:
		if x[ix-1] in '0123456789':
			ix = ix -1
		else:
			break
	px = x[:ix]
	try:	nx = int(x[ix:])
	except: nx = 0
	iy = len(y)
	while iy > 0:
		if y[iy-1] in '0123456789':
			iy = iy -1
		else:
			break
	py = y[:iy]
	try:	ny = int(y[iy:])
	except: ny = 0
	return cmp(px, py) or cmp(nx, ny)


#--------------------#
#                    #
# main starts here.  #
#                    #
#--------------------#

try:
   optlist,args = getopt.getopt(sys.argv[1:],"dc:hr:l",['help'])
except getopt.error,error_msg:
   print error_msg
   print "Try \'fbs nodes help\' for more information"
   sys.exit(1)

long_option = 'false'
for opt in optlist:
    if opt[0] == '-l':
        long_flag = 'on'
    elif opt[0] == '-d':
        down_flag = 'on'
    elif opt[0] == '-h':
        held_flag = 'on'
    elif opt[0] == '-c':
        node_class = opt[1]
    if opt[0] == '--help':
        print "USAGE: python hosts.py [-h] [-d] [-l] (-c <class>|<node> ...)"
        sys.exit(0)

node_list = []
if node_class:
    try:    nci = fbs_client.getNodeClass(node_class)
    except  KeyError:
        print 'Unknown node class <%s>' % node_class
        sys.exit(1)
    except  FBSError, txt:
        print txt
        sys.exit(1)
    node_list = nci.Nodes[:]
elif not args:
    try: node_list = fbs_client.getNodeList()
    except  FBSError, txt:
        print txt
        sys.exit(1)
else:
    node_list = args

node_list.sort(cmpNodes)
    
node_info_list = eligible_nodes(node_list)

if long_flag == 'on':
    long_report(node_info_list)
else:
    short_report(node_info_list)











