#
# @(#) $Id: jobadmin.py,v 1.9 2000/06/28 19:06:43 fromm Exp $
#
# $Log: jobadmin.py,v $
# Revision 1.9  2000/06/28 19:06:43  fromm
# .
#
# Revision 1.8  2000/06/22 16:18:34  fromm
# .
#
# Revision 1.7  2000/06/15 15:36:41  fromm
# .
#
# Revision 1.5  2000/06/12 20:24:19  fromm
# .
#
# Revision 1.4  2000/04/25 18:31:30  fromm
# .
#
# Revision 1.3  2000/04/18 13:18:53  fromm
# cuz
#
# Revision 1.2  2000/04/06 21:51:32  fromm
# cuz
#
# Revision 1.1  2000/04/06 16:18:00  fromm
# idunno
#

from FBS_API import *
from fbs_misc import *
from string import *
import sys
import getopt
usage = 'USAGE: farms jobadmin [-R|-H -r <reason>]  -t <time_str> job|section ...'

fbs_client = FBSClient()

try:
    optlist,args = getopt.getopt(sys.argv[1:],"RHr:t:",['help'])
except getopt.error,error_msg:
    print "farms jobadmin: " + error_msg
    print "Try \'farms jobadmin help\' for more information"
    sys.exit(1)

hold_flag = 'off'
reason = 'Unknown'
rel_flag = 'off'
time_flag = 'off'

for opt in optlist:
    if (opt[0] == '-R'):
        rel_flag = 'on'
    elif (opt[0] == '-H'):
        hold_flag = 'on'
    elif (opt[0] == '-r'):
	reason = opt[1]
    elif (opt[0] == '-t'):
	time_flag = 'on'
	time_str = opt[1]

if (rel_flag == 'on' and hold_flag == 'on'):
    print "Make up your mind, I can't do both..."

if len(args) == 0:
    print "No jobs/sections specified to take action on, exiting..."
    sys.exit(-1)

if (rel_flag == 'on'):

    for job in args:

	jobtuple = decodeDotID(job)

	if (len(jobtuple) == 1):
            j = fbs_client.getJob(jobtuple[0])
            for blah in j.sections():
               sectid = jobtuple[0] + '.' + blah
	       try:
		  fbs_client.releaseSection(sectid)
	       except KeyError:
		  print 'Section not found...'
		  sys.exit(1) 
               except FBSError:
		  print 'Not authorized to mess with that...'
		  sys.exit(1) 
               except socket.error:
                  print 'Error - is the bmgr running?'
                  sys.exit(1)
                
	    sys.exit(0) 
	    
	else:

	    sect = encodeSectionID(jobtuple[0],jobtuple[1])
	    try:
		fbs_client.releaseSection(sect)
	    except KeyError:
		print 'Section not found..'
		sys.exit(1)
            except FBSError:
                print 'Not authorized to mess with that...'
		sys.exit(1)
	    sys.exit(0)

elif (hold_flag == 'on'):

    for job in args:

	jobtuple = decodeDotID(job)

	if (len(jobtuple) == 1):

	    if time_flag == 'on':
                j = fbs_client.getJob(jobtuple[0])
                for blah in j.sections():
                    sectid = fbs_misc.encodeSectionID(jobtuple[0],blah)
		    try:
		        fbs_client.holdSection(sectid,time_str)
		    except KeyError:
		        print "Section " + sectid + "not found.."
		        sys.exit(1)
		sys.exit(0)

	    else:
                j = fbs_client.getJob(jobtuple[0])
                for blah in j.sections():
                    sectid = fbs_misc.encodeSectionID(jobtuple[0],blah)
	 	    try:
		        fbs_client.holdSection(sectid)
		    except KeyError:
		        print "Section " + sectid + "not found.."
		        sys.exit(1)
		sys.exit(0)

	else:
	    sect = encodeSectionID(jobtuple[0],jobtuple[1])
	   
            if time_flag == 'on':
	       try:
		  rc,msg = fbs_client.holdSection(sect,time_str)  
	       except KeyError:
		  print 'Section not found'
		  sys.exit(1)
               except ValueError,val:
                  print val
                  sys.exit(1)
               sys.exit(0)

	    try:
		m = fbs_client.holdSection(sect)  
	    except KeyError:
		print 'Section not found'
		sys.exit(1)

	    if m[0] != 0:
               print m[1]

	    sys.exit(0)

else:

    print "No action specified, no action taken..."
    sys.exit(-1)

sys.exit(0)















