# @(#) $Id: kill.py,v 1.17 2003/08/22 16:19:39 ivm Exp $
#
# $Log: kill.py,v $
# Revision 1.17  2003/08/22 16:19:39  ivm
# Minor things
#
# Revision 1.16  2001/11/20 19:42:15  ivm
# Implemented CPU and real time limits for proc. type
# Fixed launcher reconfiguration bug
#
# Revision 1.15  2001/05/11 15:09:00  ivm
# Fixed many bugs
#
# Revision 1.14  2001/02/26 22:28:34  ivm
# Fixed kill.py
# Added RELEASE message sent from LchIF to launcher to clear held status
#
# Revision 1.13  2001/02/06 20:09:28  ivm
# Fixed syntax errors
#
# Revision 1.12  2001/02/06 18:25:25  ivm
# Fixed yet another memory mishadnling in farm_history, simplified syntax
# Added canceled() dependency type
# Added job ranges in kill.py
# Show processes for just ended sections
# Fixed decoding of status/signal/core in Section
#
# Revision 1.11  2000/10/27 16:04:49  fromm
# bug fix
#
# Revision 1.10  2000/10/27 15:23:00  ivm
# Fixed syntax errors
#
# Revision 1.9  2000/10/24 16:05:14  ivm
# Send Exec to BMGR as serialized list, not string
# Call killJob, not killSection, killSection, ... in kill.py
#
# Revision 1.8  2000/06/09 15:37:57  ivm
# Added RCS log records
# Added cprio.py to Makefile
# Replaces FBSJobInfo.Sections with sections()
#
# Revision 1.7  2000/05/08 21:26:20  fromm
# .
#
# Revision 1.5  2000/04/25 18:31:31  fromm
# .
#
# Revision 1.4  2000/04/06 19:48:24  fromm
# cuz.
#
# Revision 1.3  2000/04/05 21:34:06  fromm
# added immediate
#

from FBS_API import *
from fbs_misc import *
from string import *
import sys
import getopt
import time 

usage = """
USAGE: python kill.py [-s section_name] [-i] [--help] (<jobid>|<sectid>) ..."""

kill_immediate_flag = 0
                    
fbs_client = FBSClient()

usage = 'USAGE: kill.py [-s section_name][-i][--help] (jobid|sect.jobid) ...'
                    
try:
    optlist,args = getopt.getopt(sys.argv[1:],"s:i")
except getopt.error,error_msg:
    print error_msg
    sys.exit(1)

section_list = []

for opt in optlist:
    if opt[0] == '-s':
        section_list = string.split(opt[1])
    elif opt[0] == '-i':
        kill_immediate_flag = 1
    elif opt[0] == '--help':
        print usage
        sys.exit(0)
    else:
        print "Invalid option: ",opt[0], " supplied - bye..."
        sys.exit(1)
    
if len(args) == 0: 
    print 'Please specify job and optional section name to cancel...'
    sys.exit(1)

#
# If the section was supplied on the argument list, then it will be used as the
# section name for any job supplied that is not of the form <sect>.<jobid>.  In
# these cases, <sect> will be used as the section
#

sids = []
jids = []
curjobs = None


for arg in args:
	if string.find(arg, '.') > 0:
		# section id
		sids.append(arg)
	elif string.find(arg, '-') >= 0:
		if curjobs == None:
			curjobs = fbs_client.getJobList()
		begin, end = tuple(string.split(arg, '-'))[:2]
		if begin:
			try:	begin = string.atoi(begin)
			except:
				print 'can not parse job range specification <%s>' % arg
				continue
		else:
			begin = None	
		if end:
			try:	end = string.atoi(end)
			except:
				print 'can not parse job range specification <%s>' % arg
				continue
		else:
			end = None	
		for jid in curjobs:
			xjid = string.atoi(jid)
			if begin != None and xjid < begin:	continue
			if end != None and xjid > end:		continue
			if section_list:
				for sn in section_list:
					sid = encodeSectionID(jid, sn)
					sids.append(sid)
			else:
				jids.append(jid)
	else:
		if section_list:
			for sn in section_list:
				sid = encodeSectionID(arg, sn)
				sids.append(sid)
		else:
			jids.append(arg)
		

for sid in sids:
	print 'Killing section <%s> ... ' % sid,
	try:	sts, reason = fbs_client.killSection(sid, kill_immediate_flag)
	except FBSError, txt:
		sts = 0
		reason = txt
	except KeyError:
		sts = 0
		reason = 'section not found'
	if not sts:
		print 'failed: ', reason
	else:
		print 'OK'

jids.sort(lambda x,y: cmp(y,x))

for jid in jids:
	print 'Killing job <%s> ... ' % jid,
	try:	sts, reason = fbs_client.killJob(jid, kill_immediate_flag)
	except FBSError, txt:
		sts = 0
		reason = txt
	except KeyError:
		sts = 0
		reason = 'job not found'
	print reason
