#
# @(#) $Id: logd.py,v 1.8 2001/06/18 19:21:27 ivm Exp $
#
# $Log: logd.py,v $
# Revision 1.8  2001/06/18 19:21:27  ivm
# Fixed reference to OSError
#
# Revision 1.7  2001/06/12 19:47:53  ivm
# Updated for Python v2.1
#
# Revision 1.6  2001/03/13 15:59:01  ivm
# Fixed bugs in object ownership
#
# Revision 1.5  2000/09/27 20:19:52  ivm
# Use global/mail_command cfg. parameter
#
# Revision 1.4  2000/09/27 16:15:41  ivm
# Fixed syntax error
#
# Revision 1.2  2000/04/12 16:00:04  ivm
# Works with Launcher
#
#

import errno
import os
import config
import time
import sys
from socket import *
import select
import string
import signal
import Selector
import fbs_misc

#from HealthMonitorSrv import   HealthMonitorSrv
LogdError = 'Logd error'

class	Mailer:
	def __init__(self, cfg):
		hn = gethostname()
		self.AdminAddress = cfg.getValue('logd','*','admin_address')
		self.MailCmd = cfg.getValue('global','*','mail_command', '/bin/mail')
		self.Delay = cfg.getValue('logd','*','email_wait', 30*60)
		if self.Delay == None:
			self.Delay = 30*60		# half an hour
		self.LastSent = {}
		
	def send(self, msg):
		if self.AdminAddress == None:
			return
		if self.LastSent.has_key(msg):
			t = self.LastSent[msg]
			if t > time.time() - self.Delay:	return
		subject = 'Log Daemon error'
		faddr = 'FBSNG_Log_Daemon@%s' % gethostname()
		msg = msg + '\n-----------------------------------------------\n'
		msg = msg + \
			'This message was generated by FBSNG Log daemon running on %s.\n' % \
			gethostname()
		msg = msg + 'Do not reply to this message.\n'
		fbs_misc.sendMail(self.MailCmd, subject, self.AdminAddress, msg,
			faddr=faddr)
		if len(self.LastSent) > 1000:
			self.LastSent = {}
		self.LastSent[msg] = time.time()
		
class	Client:
	def __init__(self, logd, addr, seq, typ, ident):
		self.Logd = logd
		self.Dir = '%s/%s' % (self.Logd.LogRoot, typ)
		try:	os.mkdir(self.Dir)
		except os.error, val:
			code, text = val
			if code != errno.EEXIST:
				msg = 'Can not create directory %s: %s' % (
					self.Dir, val)
				self.Logd.sendError(msg)
		except:
			msg = 'Can not create directory %s: %s %s' % (
				self.Dir, sys.exc_type, sys.exc_value)
			self.Logd.sendError(msg)
		self.FileBase = '%s/%s.%s' % (self.Dir, typ, ident)
		self.Seq = seq
		self.Addr = addr
		self.LastHeard = 0
		self.Type = typ
		self.Ident = ident
		
	def logMsg(self, msg):
		# decode a message
		#print 'logMsg(%s)' % msg
		self.LastHeard = time.time()
		lst = string.split(msg, ',')
		if len(lst) < 5:	
			self.Logd.send('?',self.Addr)
			return
		seq, dummy, dummy, dummy, level = tuple(lst[:5])
		level = string.strip(level)
		try:	seq = string.atoi(seq)
		except: return
		if seq == self.Seq:
			self.Logd.send('%d' % seq, self.Addr)
			self.Seq = self.Seq + 1
			if not level in self.Logd.Ignore:
				# log the message
				t = time.time()
				fn = '%s.%s.log' % (self.FileBase,
		        	  time.strftime("%Y%m%d",time.localtime(t)))
				try:	f = open(fn, 'a')
				except:
					msg = 'Error opening <%s>\n%s\n%s\n' % (fn,
						sys.exc_type, sys.exc_value)
					self.Logd.sendError(msg)
					return
				try:	
					f.write('%s: %s\n' % (level, msg))
					f.flush()
				except:
					msg = 'Error writing <%s>\n%s\n%s\n' % (fn,
						sys.exc_type, sys.exc_value)
					self.Logd.sendError(msg)
				f.close()
		elif seq < self.Seq:
			self.Logd.send('%d' % seq, self.Addr)
		elif seq > self.Seq:
			# ignore
			pass
			
	def setSeq(self, seq):
		self.Seq = seq
		self.LastHeard = time.time()

	def sameClient(self, typ, ident):
		return self.Type == typ and self.Ident == ident

class	LogDaemon(Selector.Process):
	def __init__(self, cfg,sel):
	        Selector.Process.__init__(self)
		# cfg is a ConfigFile object
		self.getCfg(cfg)
		self.Sock = socket(AF_INET, SOCK_DGRAM)
		self.Sock.setsockopt(SOL_SOCKET, SO_REUSEADDR, 1)
		self.Sock.bind(('',self.Port))
		self.Clients = {}		# indexed by addr
		self.Mailer = Mailer(cfg)
		self.HighWater = 1500
		self.LowWater = 1000
		sel.register(self,rd = self.Sock.fileno())
	def doRead(self, fd,selector):
	    if self.Sock.fileno() != fd:
		return
	    self.run()

	def sendError(self, msg):
		self.Mailer.send(msg)

	def send(self, msg, addr):
		#print 'Send <%s> to <%s>' % (msg, addr)
		try:	self.Sock.sendto(msg, addr)
		except: pass

	def _cmpClients(self, c1, c2):
		if c1.LastHeard > c2.LastHeard:
			return -1
		elif c1.LastHeard == c2.LastHeard:
			return 0
		else:
			return 1

	def purgeClients(self):
		lst = self.Clients.values()
		lst.sort(self._cmpClients)
		for c in lst[self.LowWater:]:
			del self.Clients[c.Addr]
			
	def getCfg(self, cfg):
		hn = gethostname()
		self.LogRoot = cfg.getValue('logd','*','log_dir')
		#
		# Get configuration
		if self.LogRoot == None:
			raise LogdError, 'log_dir is unspecified in config file'
		if self.LogRoot[-1] != '/':
			self.LogRoot = self.LogRoot + '/'
		self.Port = cfg.getValue('logd','*','server_port')
		if self.Port == None:
			raise LogdError, 'server_port is unspecified in config file'
		self.Ignore = cfg.getValue('logd','*','ignor_codes')
		if self.Ignore == None:
			self.Ignore = ''
		
	def setIgnore(self, str):
		self.Ignore = str
		
	def setLogRoot(self, path):
		self.LogRoot = path
		
	def run(self):
			if len(self.Clients) > self.HighWater:
				self.purgeClients()
				
			try:	msg, addr = self.Sock.recvfrom(10000)
			except: return

			#print 'Recvd <%s>' % msg

			if not self.Clients.has_key(addr):
				if msg[0] == '$':	return
				elif msg[0] != '@':
					#print 'Send <?>'
					try:	self.send('?', addr)
					except: pass
					return

			if msg[0] == '$':		# good bye from client
				del self.Clients[addr]
			
			elif msg[0] == '@': 	# Hello: @ seq type id
				lst = string.split(msg)
				if len(lst) < 4:	return
				dummy, seq, typ, ident = tuple(lst[:4])
				try:	seq = string.atoi(lst[1])
				except: return
				if not self.Clients.has_key(addr) or \
					not self.Clients[addr].sameClient(typ, ident):
					self.Clients[addr] = Client(self, addr, seq, typ, ident)
				self.Clients[addr].setSeq(seq)
			else:
				# regular message, pass it to the Client object
				self.Clients[addr].logMsg(msg)
	
if __name__ == '__main__':
	import getopt
	import sys
	from config import ConfigFile
	
	cfg = None
	ignore = None
	root = None
	usage = 'Usage: logd.py -c <config_file> [-i <ignore>] [-r <log_root>]'
	try:	opts, args = getopt.getopt(sys.argv[1:], 'c:i:r:')
	except:
		print usage
		sys.exit(2)
	
	for opt, val in opts:
		if opt == '-c':
			cfg = ConfigFile(val)
		elif opt == '-i':
			ignore = val
		elif opt == '-r':
			root = val
	
	if cfg == None:
		print usage
		sys.exit(3)
	sel=Selector.Selector()
	#port=cfg[('logd','*','health_port')]
	#if port:
	#    health=HealthMonitorSrv(port,sel)
	ld = LogDaemon( cfg,sel )
	if root != None:
		ld.setLogRoot(root)
	if ignore != None:
		ld.setIgnore(ignore)
	
	while 1:
		sel.select(5)
