#
# @(#) $Id: proc_types.py,v 1.8 2001/11/26 17:56:37 ivm Exp $
#
# proc_types.py: Display configuration/usage information about process
# types
# Usage:
#	python proc_types [-l] [-r] [<proc_type> ...]
#		-l - long output
#		-r - display current resource utilization
# $Log: proc_types.py,v $
# Revision 1.8  2001/11/26 17:56:37  ivm
# Implemented ptype.timelimits, ptype.maxnodes in API, NetIF, SectParam, UI
# Other minor improvements
#
# Revision 1.7  2001/03/19 15:32:01  ivm
# Fixed syntax errors in proc_types and queues
#
# Revision 1.5  2000/09/29 15:26:36  ivm
# Cosmetics
#
# Revision 1.4  2000/06/22 18:58:19  ivm
# Report syntax error in intelligent way in proc_types and resources.
# Pass strings as they are to proc_types and resources
#
# Revision 1.3  2000/05/24 15:16:07  ivm
# Catch socket error
#
# Revision 1.2  2000/05/08 20:49:56  ivm
# Fixed some bugs,
# Implemented totals for local resource utilization
#
# Revision 1.1  2000/04/24 21:40:22  ivm
# Added proc_types.py
#
#

from FBS_API import *
import string

Long_opt = 0
Rsrc_opt = 0
Usage_opt = 0
Quota_opt = 0


def print_head():
	if not Long_opt:
		print '%-16.16s %10.10s %s' % ('Name', 'Max Pr Inc', 'Resources')
		print '%-16.16s %10.10s %s' % ('----', '----------', '--------------')

def print_tail():
	pass
	
Fill = ' ' * 28

def dict2str(dict, noneStr = ''):
	str = ''
	for rn, v in dict.items():
		if v == None:
			v = noneStr
			str = str + ('%s%s ' % (rn, v))
		else:
			str = str + '%s:%s ' % (rn, v)
	return string.strip(str)

def dt2str(t, default='N/A'):
	if type(t) != type(1) and type(t) != type(1.0):
		return '%s' % t
	if t < 0:
		return default
	t0 = int(t)
	t = t0
	d = t/(24*3600)
	t = t % (24*3600)
	h = t/3600
	t = t % 3600
	m = t/60
	s = t % 60
	if d > 0:
		return '%d seconds (%d days, %d hours, %d minutes)' % (t0,d,h,m)
	else:
		return '%d seconds (%d hours, %d minutes, %d seconds)' % (t0,h,m,s)

def print_long(pti):
	print '-----------------------------------------------------------------'
	print 'Process Type                 : %s' % pti.Name
	print 'Default Process Resources    : %s' % dict2str(pti.ProcRsrcDefaults)
	print 'Default Section Resources    : %s' % dict2str(pti.SectRsrcDefaults)
	print 'Resource Usage Quota         : %s' % dict2str(pti.RsrcQuota)
	print 'Resources in use             : %s' % dict2str(pti.RsrcUsage)
	print 'Maximum Priority Increment   : %s' % pti.MaxPrioInc
	print 'Process CPU time limit       : %s' % dt2str(pti.CPUTimeLimit, '(no limit)')
	print 'Process elapsed time limit   : %s' % dt2str(pti.RealTimeLimit, '(no limit)')
	print 'Allowed on nodes             : %s' % string.join(pti.NodesAllow)
	print 'Disallowed on nodes          : %s' % string.join(pti.NodesDisallow)
	print 'Node count (current/max)     : %s/%s' % (pti.CurrentNodeCount,
				pti.MaxNodeCount)
	print 'Authorized users             : %s' % string.join(pti.Users)
	print ''


	
def print_short(pti):
	pinc = pti.MaxPrioInc
	if pinc == None:
		pinc = '-'
	str = '%-16.16s %10.10s ' % (pti.Name, pinc)
	new_line = 0
	extra = ''
	if Rsrc_opt:
		if pti.ProcRsrcDefaults:
			if new_line:	extra = extra + '\n' + Fill
			extra = extra + 'PrcDef: ' + dict2str(pti.ProcRsrcDefaults)
			new_line = 1
		if pti.SectRsrcDefaults:
			if new_line:	extra = extra + '\n' + Fill
			extra = extra + 'SctDef: ' + dict2str(pti.SectRsrcDefaults)
			new_line = 1
	if Quota_opt:
		if pti.RsrcQuota:
			if new_line:	extra = extra + '\n' + Fill
			extra = extra + 'Quota:  ' + dict2str(pti.RsrcQuota)
			new_line = 1
	if Usage_opt:
		if pti.RsrcUsage:
			if new_line:	extra = extra + '\n' + Fill
			extra = extra + 'Usage:  ' + dict2str(pti.RsrcUsage)
			new_line = 1
	print str + extra
				
				

if __name__ == '__main__':
	import sys
	import getopt
	import socket
	
	try:	optlist, ptlst = getopt.getopt(sys.argv[1:],'lruq')
	except getopt.error, msg:
		print 'Command syntax error: ', msg
		print 'Use "fbs ptypes help" for help'
		sys.exit(1)

	All_opts = 1
	for opt, val in optlist:
		if opt == '-l':
			Long_opt = 1
			All_opts = 0
		elif opt == '-r':
			Rsrc_opt = 1
			All_opts = 0
		elif opt == '-u':
			Usage_opt = 1
			All_opts = 0
		elif opt == '-q':
			Quota_opt = 1
			All_opts = 0

	if All_opts:
			Rsrc_opt = 1
			Usage_opt = 1
			Quota_opt = 1
		
	
	try:	
		fc = FBSClient()
		if not ptlst:
			ptlst = fc.getProcessTypeList()

		# print header
		if ptlst:	print_head()		

		for pt in ptlst:
			pti = fc.getProcessType(pt)
			if Long_opt:
				print_long(pti)
			else:
				print_short(pti)
		if ptlst:	print_tail()
	except socket.error:
		print 'Can not connect to BMGR. Try again later.'
		
		
