#
# @(#) $Id: resources.py,v 1.11 2000/09/12 15:00:01 ivm Exp $
#
# $Log: resources.py,v $
# Revision 1.11  2000/09/12 15:00:01  ivm
# Implemented createLocalResource method and all related changes
#
# Revision 1.10  2000/09/07 17:54:55  ivm
# Implemented dynamic modification of local scratch disk mapping
#
# Revision 1.9  2000/08/22 17:28:16  ivm
# Fixed bug in RM.getLocalRsrc with attributes on down nodes
# Added "show" functionality to config
#
# Revision 1.8  2000/08/03 15:39:34  ivm
# Fixed some bugs
#
# Revision 1.7  2000/06/26 21:29:23  ivm
# Check for spaces in names
#
# Revision 1.6  2000/06/22 18:58:19  ivm
# Report syntax error in intelligent way in proc_types and resources.
# Pass strings as they are to proc_types and resources
#
# Revision 1.5  2000/06/12 18:48:15  ivm
# Catch and deal with 'unknown process type' error
#
# Revision 1.4  2000/05/24 15:16:07  ivm
# Catch socket error
#
# Revision 1.3  2000/05/08 20:54:08  ivm
# Fixed show_rsrc
#
# Revision 1.1  2000/04/25 16:07:50  ivm
# Added resources.py
#
#

# Usage: python resources.py 
#          [-g] [-l] 	-- list resources
#          -n <node> [<resource> ...]
#                       -- show resource(s) usage on the node
#          -p <proc_type> [<resource> ...]
#                       -- show resource(s) usage by process type

from FBS_API import *
import string

def show_rsrc(opts, args):
	fc=FBSClient()
	#print opts
	do_g = opts.has_key('-g')
	do_l = opts.has_key('-l')
	lst = args
	glst = fc.getGlobalRsrcList()
	glst.sort()
	gplst = fc.getGlobalPoolList()
	gplst.sort()
	llst = fc.getLocalRsrcList()
	llst.sort()
	lplst = fc.getLocalPoolList()
	lplst.sort()
	if not do_g and not do_l and not lst:
		do_g, do_l = 1, 1
	if not lst:
		if do_g:
			lst = lst + glst + gplst
		if do_l:
			lst = lst + llst + lplst
	print '%-16.16s %4.4s %5.5s %8.8s' % ('Resource','Type','Usage','Capacity')
	print '%-16.16s %4.4s %5.5s %8.8s' % ('-----------','----','-----','--------')
	for rn in lst:
		if string.find(rn, ' ') >= 0:
			print 'Invalid resource name <%s>' % rn
		else:
			extra = ''
			if rn in glst:
				u, c = fc.getGblRsrcUsage(rn)
				t = 'G'
			elif rn in gplst:
				u, c = fc.getGblRsrcUsage(rn)
				t = 'G'
				extra = '(pool: %s)' % string.join(fc.getResourcePool(rn))
			elif rn in llst:
				u, c = fc.getLclRsrcUsage(rn)
				t = 'L'
			elif rn in lplst:
				u, c = fc.getLclRsrcUsage(rn)
				t = 'L'
				extra = '(pool: %s)' % string.join(fc.getResourcePool(rn))
			else:
				u, c = '?', '?'
				t = '?'
			if c == None:
				c = 'attr'
			print '%-16.16s %4.4s %5.5s %8.8s %s' % (rn, t, u, c, extra)

def show_proc_type(opts, args):
	fc=FBSClient()
	pt = opts['-p']
	if string.find(pt,' ') >= 0:
		print 'Invalid process type name <%s>' % pt
		return
	try:	pt = fc.getProcessType(pt)
	except KeyError:
		print 'Invalid process type name <%s>' % pt
		return
		
	lst = args
	do_g = opts.has_key('-g')
	do_l = opts.has_key('-l')
	glst = fc.getGlobalRsrcList()
	glst.sort()
	gplst = fc.getGlobalPoolList()
	gplst.sort()
	llst = fc.getLocalRsrcList()
	llst.sort()
	lplst = fc.getLocalPoolList()
	lplst.sort()
	if not do_g and not do_l and not lst:
		do_g, do_l = 1, 1
	if not lst:
		if do_g:
			lst = lst + glst + gplst
		if do_l:
			lst = lst + llst + lplst
	print '%-16.16s %4.4s %5.5s %5.5s' % ('Resource','Type','Usage','Quota')
	print '%-16.16s %4.4s %5.5s %5.5s' % ('-----------','----','-----','-----')
	for rn in lst:
		try:	qta = pt.RsrcQuota[rn]
		except: qta = '-'
		try:	usg = pt.RsrcUsage[rn]
		except: usg = 0
		if rn in llst:
			type = 'L'
		elif rn in glst:
			type = 'G'
		elif rn in gplst:
			type = 'GP'
		elif rn in lplst:
			type = 'LP'
		else:
			usg, qta = '?', '?'
			type = '?'
		
		print '%-16.16s %4.4s %5.5s %5.5s' % (rn, type, usg, qta)

def show_node(opts, args):
	fc=FBSClient()
	nn = opts['-n']
	if string.find(nn,' ') >= 0:
		print 'Invalid node name <%s>' % nn
		return
	lst = args
	llst = fc.getLocalRsrcList()
	llst.sort()
	#print llst
	if not lst:	lst = llst
	print '%-16.16s %8.8s %8.8s' % ('Resource','In Use','Capacity')
	print '%-16.16s %8.8s %8.8s' % ('---------','--------','--------')
	for rn in lst:
		if rn in llst:
			try:	usg, cap = fc.getLclRsrcUsage(rn, nn)
			except: continue
			if cap == None: cap = '(attr)'
		else:
			usg, cap = '?', '?'
		#if cap:
		print '%-16.16s %8.8s %8.8s' % (rn, usg, cap)



def main(argv):
	import getopt

	opts = {}	
	
	try:	optl, args = getopt.getopt(argv[1:],'gln:p:')
	except getopt.error, msg:
		print 'Command syntax error: %s' % msg
		print 'Use "fbs resources help" for help'
		return
	for o,v in optl:
		opts[o] = v
		
	if opts.has_key('-p'):
		show_proc_type(opts, args)
	elif opts.has_key('-n'):
		show_node(opts, args)
	else:
		show_rsrc(opts, args)

if __name__ == '__main__':
	import sys
	import socket
	try:	main(sys.argv)
	except socket.error:
		print 'Can not connect to BMGR. Try again later.'
