# # @(#) $Id: submit.py,v 1.25 2003/08/22 17:25:09 ivm Exp $
#
# $Log: submit.py,v $
# Revision 1.25  2003/08/22 17:25:09  ivm
# Tested min. nice for proctype
#
# Revision 1.24  2003/04/30 19:07:44  ivm
# Added -1
#
# Revision 1.23  2001/12/13 18:13:28  ivm
# Implemented positional arguments in "submit" command
# Added "blocked" status to "queues"
# Updates Users Guide with new "exec" args and positional args of "submit"
# Implemented process start time comparison in launcher
#
# Revision 1.22  2001/08/28 21:01:10  ivm
# Fixed RM.setRsrcPool()
# Added time limits to queue display in queues.py and "fbs config"
# Print correct error messages in submit
#
# Revision 1.21  2001/05/29 20:12:21  ivm
# Added missing fields
#
# Revision 1.20  2000/11/30 20:23:19  ivm
# Fixed bugs
# Made Scheduler more conservative about unknown queues/ptypes
# Use /tmp/launcher.pid for launcher inter-locking
#
# Revision 1.19  2000/11/10 15:41:44  ivm
# Fixed Stats.so building
# Fixed bug in RM with nullifying usage
# Print exception information in submit
# Improved queues print-out
#
# Revision 1.18  2000/11/03 21:16:44  ivm
# Tested RM pack, spread features
# Print detailed error message on ValueError in submit.py
# Fixed getJob w.r.t. Username
#
# Revision 1.17  2000/07/05 16:54:56  fromm
# .
#
# Revision 1.16  2000/07/03 21:16:04  fromm
# .
#
# Revision 1.12  2000/06/28 20:53:44  fromm
# .
#
# Revision 1.11  2000/06/28 20:20:15  fromm
# .
#
# Revision 1.10  2000/06/15 16:41:26  fromm
# .
#
# Revision 1.9  2000/05/09 20:57:44  fromm
# .
#
# Revision 1.6  2000/05/03 20:56:51  fromm
# .
#
# Revision 1.4  2000/04/25 18:31:31  fromm
# .
#
# Revision 1.3  2000/04/03 15:54:29  fromm
# Misc.
#
#
# submit.py
# usage:
# setenv FBS_CONFIG ...
# submit.py file.jdf

from FBS_API import *
from string import *
import sys
import getopt

usage = 'USAGE: python submit.py [-1] [-w [-t <timeout>]] [-o <override_str>] [<jdf_file>]'
keyword_mapping = {'SECTION':'Name',
                   'EXEC':'Exec',
                   'QUEUE':'Queue',
                   'NUMPROC':'NumProc',
                   'STDOUT':'Stdout',
                   'STDERR':'Stderr',
                   'NEED':'Need',
                   'MAILTO': 'MailTo',
                   'HOLD_TIME': 'HoldTime',
                   'AFTER': 'HoldTime',
                   'PROC_TYPE':'ProcType',
                   'PROC_RESOURCES':'PerProcRsrc',
                   'SECT_RESOURCES':'PerSectRsrc',
                   'SECT_STDOUT':'SectOutput',
                        'DEPEND':'Depend',
                        'LEADER_ONLY':'LeaderOnly',
                        'PRIO_INC':'PrioInc',
                        'PLACEMENT':'Placement',
                        'ON_NODES':'OnNodes',
                   'NICE':'Nice'}
                   

##############################################################################
#                                                                            #
# next_keyword():                                                            #
#   used by parse_override to get the <keyword> of a <keyword>=<value> pair. #
#                                                                            #
##############################################################################


def next_keyword(s,cursor):

    if cursor >= len(s):
       return ("",-1)

    while (s[cursor] in whitespace):
        cursor = cursor + 1

    ix = find(s[cursor:],'=')

    if ix < 0:
        print "At about column " + str(cursor) +  \
              " of the override string, I detected an error."
        sys.exit(-1)

#
# Allow for whitespace between keyword and = sign.
#

    while s[cursor+ix-1] in whitespace:
       ix = ix - 1

    scanned_keyword = s[cursor:cursor+ix]
    for keyword in keyword_mapping.keys():
        keyword_len = len(keyword)
        if scanned_keyword == keyword:
#       if s[cursor:cursor + keyword_len] == keyword:
           return (keyword,cursor + len(keyword))

    for keyword in keyword_mapping.keys():
        keyword_len = len(keyword)

        if s[cursor:cursor + keyword_len] == keyword:
            print 'Parse failed of override string after I encountered keyword ' + keyword
            print 'Check for a missing = sign after ' + keyword
            sys.exit(-1)

    print 'At about column ' + str(cursor) + \
          ' of the override string I expected to find a keyword but found "' \
          + scanned_keyword + '" instead'
    sys.exit(-1)


##############################################################################
#                                                                            #
# next_value():                                                              #
#   used by parse_override to get the <value. of a <keyword>=<value> pair. A #
#   <value> is a non-whitespace string, or a string with whitespace that is  #
#   enclosed in single quotes.                                               #
#                                                                            #
##############################################################################

def next_value(s,cursor):

    quoted_string = 'no'

    while s[cursor] != '=':
        cursor = cursor + 1

    cursor = cursor + 1

    if cursor >= len(s):
       print "At end of override string I detected an error..."
       sys.exit(-1)
    
    if s[cursor] == "'":
       quoted_string = 'yes'
       cursor = cursor + 1

    if quoted_string == 'no':
       temp = split(s[cursor:])
       cursor = cursor + len(temp[0])
       return (temp[0],cursor)

#
# look for closing quote
#
    end_cursor = cursor + 1
    while s[end_cursor] != "'":
        if s[end_cursor] == "\\":
           end_cursor = end_cursor + 2
        else:
           end_cursor = end_cursor + 1
        if end_cursor >= len(s):
           print "Error in override: Found begin quote but no end quote..."
           sys.exit(0)
#
# Return the string and the location of the cursor, which needs to be incremented
# by 1 so as not to point to the ending quote.

    return(s[cursor:end_cursor],end_cursor + 1)


########################################################################
#                                                                      #
# If an override string was supplied, this is used to parse it.        #
#                                                                      #
########################################################################

def parse_override(override_string):

    override_dict = {}
    cursor = 0

    while cursor>=0:

       if cursor >= len(override_string):
          return override_dict

       keyword,cursor = next_keyword(override_string,cursor)
       
       if cursor >=0:
          value,cursor = next_value(override_string,cursor)
          override_dict[keyword] = value
       else:
          print "Expected a keyword, found " + value
          sys.exit(-1)
          return override_dict


#
# main
# 

fbs_client = FBSClient()

override_dict = {}
debug_flag = 'off'
wait_flag = 'off'
timeout_flag = 'off'
override_flag = 'off'
optlist = []
job_id_only = 0

try:
    optlist,args = getopt.getopt(sys.argv[1:],"t:wo:1",['help'])
except getopt.error,error_msg:
    print "fbs submit: " + error_msg
    print "Try \'fbs submit help\' for more information"
    sys.exit(1)


for opt in optlist:

    if opt[0] == '-w':
        wait_flag = 'on'

    elif opt[0] == '-1':
        job_id_only = 1    

    elif opt[0] == '-t':
        timeout_flag = 'on'
        wait_flag = 'on'
        try:
            timeout_value = atoi(opt[1])
        except:
            print "Invalid timeout value supplied..."
            sys.exit(-1)

    elif opt[0] == '-o':

        override_flag = 'on'
        if (len(opt[1]) > 0):
            d = parse_override(opt[1])
            if "SECTION" in d.keys():
                section_name = d["SECTION"]
                del d["SECTION"]
                override_dict[section_name] = d
            else:
                override_dict["ALL"] = d

    elif opt[0] == '--help':
        print usage

#if len(args) > 1: 
#    print "I only expect 1 argument - the name of the JDF file..."
#    sys.exit(1)
   
if len(args) == 0:
   if override_flag == 'off':
      print 'Must supply either a JDF file or an override string...'
      sys.exit(1) 
#
# JDF supplied
#
if len(args) > 0:
    try:
       jdf = FBSJobDesc(args[0], args[1:])
    except ValueError, val:
       print "Error in JDF: ", val
       sys.exit(1)
    except SyntaxError,args:
       print 'Error on line #%d: <%s>: %s' % (args.args)
       sys.exit(1)
    except IOError:
       print "JDF file " + args[0] + " not found."
       sys.exit(1)
    except:
       print sys.exc_type, sys.exc_value
       sys.exit(1)
           
    #
    # Check for overrides
    #
    
    if override_flag == 'on':
        if "ALL" in override_dict.keys():
            for section_name in jdf.sections():
                sectionDesc = jdf.getSection(section_name)
                for key in override_dict["ALL"].keys():
                    field = keyword_mapping[key]
                    val = override_dict["ALL"][key]
                    if type(sectionDesc.__dict__[field]) == type(1):
                        sectionDesc.__dict__[field] = int(val)
                    else:
                        sectionDesc.__dict__[field] = val
        for section_name in override_dict.keys():
            if section_name == 'ALL':     
               continue
            if section_name not in jdf.sections():
               SectionDesc = {}
               d = override_dict[section_name]
               SectionDesc[section_name] = FBSSectionDesc(section_name,d)
               jdf.addSection(SectionDesc[section_name])
            else:
               sectionDesc = jdf.getSection(section_name)
               for key in override_dict[section_name].keys():
                  field = keyword_mapping[key]
                  val = override_dict[section_name][key]
                  if type(sectionDesc.__dict__[field]) == type(1):
                     sectionDesc.__dict__[field] = int(val)
                  else:
                     sectionDesc.__dict__[field] = val
    try:
       sts, id = fbs_client.submitJob(jdf)
    except FBSError, txt:
                print txt
                sys.exit(1)
    except:
       print "Submit failed: %s %s" % (sys.exc_type, sys.exc_value)
       sys.exit(1)

    if sts:
        if job_id_only:
            print id
        else:
            print 'Farm Job ' + id + ' has been submitted...'
    else:
        print 'Error: %s' % id
        sys.exit(-1)

    if wait_flag == 'on':
       if timeout_flag == 'on':
          wait_cmd = 'fbs wait -t ' + str(timeout_value) + ' ' + str(id)
       else:
          wait_cmd = 'fbs wait ' + str(id)
       rc = os.system(wait_cmd)
       rc = rc >> 8
       sys.exit(rc)
    else:
       sys.exit(0)

#
# No JDF supplied
#

SectionDesc = {}
jdf = FBSJobDesc()

for section_name in override_dict.keys():

    if "DEPEND" in override_dict[section_name].keys():
        depend_string = override_dict[section_name]["DEPEND"]
        del override_dict[section_name]["DEPEND"]
    d = override_dict[section_name]
    SectionDesc[section_name] = FBSSectionDesc(section_name,d)
#   SectionDesc[section_name].addDependency 
    jdf.addSection(SectionDesc[section_name])

try:
   sts, id = fbs_client.submitJob(jdf)
except FBSError, txt:
        print txt
        sys.exit(1)
except:
        print "Submit failed: %s %s" % (sys.exc_type, sys.exc_value)
        sys.exit(1)

if sts:
    if job_id_only:
        print id
    else:
        print 'Farm Job ' + id + ' has been submitted...'
else:
   print 'Error: %s' % id
   sys.exit(-1)

if wait_flag == 'on':
    if timeout_flag == 'on':
        wait_cmd = 'fbs wait -t ' + str(timeout_value) + ' ' + str(id)
    else:
        wait_cmd = 'fbs wait ' + str(id)
    rc = os.system(wait_cmd)
    print rc









