#
# @(#) $Id: wait.py,v 1.11 2001/06/08 15:27:37 ivm Exp $
#
# $Log: wait.py,v $
# Revision 1.11  2001/06/08 15:27:37  ivm
# Rewrote entirely
#
#

from FBS_API import *
import fbs_misc
import sys
import string
import getopt
import time

class	MyEventListener(FBSEventListener):
	def __init__(self, fc, jsid):
		FBSEventListener.__init__(self)
		tup = fbs_misc.decodeDotID(jsid)
		self.NActive = 0
		self.NPresent = 0
		self.ExitStatus = 0
		if len(tup) == 2:
			# section id
			try:	self.subscribe(jsid)
			except KeyError:
				pass
			else:
				self.NPresent = 1
				if self.sectionState(jsid) in ["ready","waiting","running"]:
					self.NActive = 1
		else:
			self.NPresent = 0
			self.NActive = 0
			try:	j = fc.getJob(jsid)
			except KeyError:
				pass
			else:
				for sn in j.sections():
					sid = fbs_misc.encodeSectionID(jsid, sn)
					try:	self.subscribe(sid)
					except KeyError:
						pass
					else:
						self.NPresent = self.NPresent + 1
						if self.sectionState(sid) in ["ready","waiting","running"]:
							self.NActive = self.NActive + 1

	def allDeleted(self):
		return self.NPresent <= 0

	def allFinished(self):
		return self.NActive <= 0
		
	def sectionDeleted(self, sid):
		self.NPresent = self.NPresent - 1
		
	def sectionStateChanged(self, sid, old, new):
		if not new in ["ready","waiting","running"]:
			self.NActive = self.NActive - 1
			if new != "done":
				self.ExitStatus = 1
			

usage = 'python wait.py [-t <timeout>] [-d] (<jobid>|<sectid>)'
optlist = []

try:
    optlist,args = getopt.getopt(sys.argv[1:],"dt:")
except getopt.error,error_msg:
    print error_msg
    sys.exit(2)

tmo = None
wait_for_del = 0
for opt, val in optlist:
	if opt == '-t':
		tmo = string.atoi(val)
	elif opt == '-d':
		wait_for_del = 1
		
if len(args) != 1:
	print "Invalid usage. See 'fbs wait help'"
	sys.exit(2)
	
fbs_client = FBSClient()
evl = MyEventListener(fbs_client, args[0])
done = 0
t0 = time.time()
t1 = None
if tmo != None:
	t1 = t0 + tmo
	
while not evl.allDeleted():
	if t1 == None:
		evl.wait(1)
	else:
		if time.time() >= t1:
			sys.exit(137)			# time-out
		evl.wait(1, int(t1 - time.time() + 1))
	if not wait_for_del and evl.allFinished():
		break
sys.exit(evl.ExitStatus)


