#!/bin/sh
# fbsng-jobmanger installer.
#-----------------------------------------------------------
#
#
FBSQueue=$1
ups_dir=`env | grep SETUPS_DIR | awk -F= '{print $2}'`
ls -1 $ups_dir/setups.sh
if [ $? -ne 0  ]; then
  echo "ERROR: UPS environment not set properly exiting...."
  exit 1
fi
#
echo GLOBUS_PATH=$GLOBUS_PATH
ls -1 $GLOBUS_PATH/etc/globus-user-env.csh
if [ $? -ne 0  ]; then
  echo "ERROR: Globus environment not set properly exiting...."
  exit 1
fi
#
#
cat > $GLOBUS_LOCATION/libexec/fbsng_globus.sh << _EOF_
#!/bin/sh
ups_dir=$ups_dir
. ${ups_dir}/setups.sh 
setup fbsng
cmd=\$1
shift
fbs \$cmd "\$@"
_EOF_
#
#
#
#
FBSCmd=$GLOBUS_LOCATION/libexec/fbsng_globus.sh
#
#
if [ ! -z  $FBSQueue  ]; then
           cat fbsng.pm.in | \
           sed "s&@FBSCMD@&$FBSCmd&g" | \
           sed "s&@DEFAULT_QUEUE@&$FBSQueue&g"  \
                          > $GLOBUS_LOCATION/lib/perl/Globus/GRAM/JobManager/fbsng.pm 
else
   FBSQueue=Test

   echo "FBSQueue: not provided on command line setting it to "Test"...." 
   echo "You can always change in $GLOBUS_LOCATION/lib/perl/Globus/GRAM/JobManager/fbsng.pm"
fi
cat fbsng.pm.in | \
   sed "s&@FBSCMD@&$FBSCmd&g" | \
   sed "s&@DEFAULT_QUEUE@&$FBSQueue&g"  \
       > $GLOBUS_LOCATION/lib/perl/Globus/GRAM/JobManager/fbsng.pm
#
#
cat > $GLOBUS_LOCATION/etc/grid-services/jobmanager-fbsng<<_EOF_
stderr_log,local_cred - $GLOBUS_LOCATION/libexec/globus-job-manager globus-job-manager -conf $GLOBUS_LOCATION/etc/globus-job-manager.conf -type fbsng -rdn jobmanager-fbsng -machine-type unknown -publish-jobs
 
_EOF_
 
#
echo fbsng jobmanager installed
echo please edit $GLOBUS_LOCATION/lib/perl/Globus/GRAM/JobManager/fbsng.pm
echo If you need any changes

exit 
