/* SPDX-License-Identifier: MIT */
/*
 * Copyright 2022 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef _dpcs_3_1_4_SH_MASK_HEADER
#define _dpcs_3_1_4_SH_MASK_HEADER


// addressBlock: dpcssys_cr0_rdpcstxcrind
//DPCSSYS_CR0_SUP_DIG_IDCODE_LO
//DPCSSYS_CR0_SUP_DIG_IDCODE_HI
//DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__REF_CLK_EN__SHIFT                                                 0x0
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__REF_CLK_EN_OVRD_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__REF_USE_PAD__SHIFT                                                0x2
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__REF_USE_PAD_OVRD_EN__SHIFT                                        0x3
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__REF_CLK_RANGE__SHIFT                                              0x4
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__REF_CLK_RANGE_OVRD_EN__SHIFT                                      0x7
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__BG_EN__SHIFT                                                      0x8
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__BG_EN_OVRD_EN__SHIFT                                              0x9
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__HDMIMODE_EN__SHIFT                                                0xa
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__HDMIMODE_ENABLE_OVRD_EN__SHIFT                                    0xb
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__SUP_PRE_HP_OVRD__SHIFT                                            0xc
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__SUP_PRE_HP_OVRD_EN__SHIFT                                         0xd
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__REF_CLK_EN_MASK                                                   0x0001L
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__REF_CLK_EN_OVRD_EN_MASK                                           0x0002L
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__REF_USE_PAD_MASK                                                  0x0004L
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__REF_USE_PAD_OVRD_EN_MASK                                          0x0008L
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__REF_CLK_RANGE_MASK                                                0x0070L
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__REF_CLK_RANGE_OVRD_EN_MASK                                        0x0080L
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__BG_EN_MASK                                                        0x0100L
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__BG_EN_OVRD_EN_MASK                                                0x0200L
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__HDMIMODE_EN_MASK                                                  0x0400L
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__HDMIMODE_ENABLE_OVRD_EN_MASK                                      0x0800L
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__SUP_PRE_HP_OVRD_MASK                                              0x1000L
#define DPCSSYS_CR0_SUP_DIG_REFCLK_OVRD_IN__SUP_PRE_HP_OVRD_EN_MASK                                           0x2000L
//DPCSSYS_CR0_SUP_DIG_MPLLA_DIV_CLK_OVRD_IN
#define DPCSSYS_CR0_SUP_DIG_MPLLA_DIV_CLK_OVRD_IN__MPLLA_DIV_CLK_EN__SHIFT                                    0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_DIV_CLK_OVRD_IN__MPLLA_DIV_MULTIPLIER__SHIFT                                0x1
#define DPCSSYS_CR0_SUP_DIG_MPLLA_DIV_CLK_OVRD_IN__MPLLA_DIV_OVRD_EN__SHIFT                                   0x9
#define DPCSSYS_CR0_SUP_DIG_MPLLA_DIV_CLK_OVRD_IN__RESERVED_15_10__SHIFT                                      0xa
#define DPCSSYS_CR0_SUP_DIG_MPLLA_DIV_CLK_OVRD_IN__MPLLA_DIV_CLK_EN_MASK                                      0x0001L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_DIV_CLK_OVRD_IN__MPLLA_DIV_MULTIPLIER_MASK                                  0x01FEL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_DIV_CLK_OVRD_IN__MPLLA_DIV_OVRD_EN_MASK                                     0x0200L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_DIV_CLK_OVRD_IN__RESERVED_15_10_MASK                                        0xFC00L
//DPCSSYS_CR0_SUP_DIG_MPLLA_HDMI_CLK_OVRD_IN
#define DPCSSYS_CR0_SUP_DIG_MPLLA_HDMI_CLK_OVRD_IN__MPLLA_HDMI_PIXEL_CLK_DIV__SHIFT                           0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_HDMI_CLK_OVRD_IN__MPLLA_HDMI_DIV__SHIFT                                     0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLA_HDMI_CLK_OVRD_IN__MPLLA_HDMI_OVRD_EN__SHIFT                                 0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLA_HDMI_CLK_OVRD_IN__RESERVED_15_6__SHIFT                                      0x6
#define DPCSSYS_CR0_SUP_DIG_MPLLA_HDMI_CLK_OVRD_IN__MPLLA_HDMI_PIXEL_CLK_DIV_MASK                             0x0003L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_HDMI_CLK_OVRD_IN__MPLLA_HDMI_DIV_MASK                                       0x001CL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_HDMI_CLK_OVRD_IN__MPLLA_HDMI_OVRD_EN_MASK                                   0x0020L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_HDMI_CLK_OVRD_IN__RESERVED_15_6_MASK                                        0xFFC0L
//DPCSSYS_CR0_SUP_DIG_MPLLB_DIV_CLK_OVRD_IN
#define DPCSSYS_CR0_SUP_DIG_MPLLB_DIV_CLK_OVRD_IN__MPLLB_DIV_CLK_EN__SHIFT                                    0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_DIV_CLK_OVRD_IN__MPLLB_DIV_MULTIPLIER__SHIFT                                0x1
#define DPCSSYS_CR0_SUP_DIG_MPLLB_DIV_CLK_OVRD_IN__MPLLB_DIV_OVRD_EN__SHIFT                                   0x9
#define DPCSSYS_CR0_SUP_DIG_MPLLB_DIV_CLK_OVRD_IN__RESERVED_15_10__SHIFT                                      0xa
#define DPCSSYS_CR0_SUP_DIG_MPLLB_DIV_CLK_OVRD_IN__MPLLB_DIV_CLK_EN_MASK                                      0x0001L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_DIV_CLK_OVRD_IN__MPLLB_DIV_MULTIPLIER_MASK                                  0x01FEL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_DIV_CLK_OVRD_IN__MPLLB_DIV_OVRD_EN_MASK                                     0x0200L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_DIV_CLK_OVRD_IN__RESERVED_15_10_MASK                                        0xFC00L
//DPCSSYS_CR0_SUP_DIG_MPLLB_HDMI_CLK_OVRD_IN
#define DPCSSYS_CR0_SUP_DIG_MPLLB_HDMI_CLK_OVRD_IN__MPLLB_HDMI_PIXEL_CLK_DIV__SHIFT                           0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_HDMI_CLK_OVRD_IN__MPLLB_HDMI_DIV__SHIFT                                     0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLB_HDMI_CLK_OVRD_IN__MPLLB_HDMI_OVRD_EN__SHIFT                                 0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLB_HDMI_CLK_OVRD_IN__RESERVED_15_6__SHIFT                                      0x6
#define DPCSSYS_CR0_SUP_DIG_MPLLB_HDMI_CLK_OVRD_IN__MPLLB_HDMI_PIXEL_CLK_DIV_MASK                             0x0003L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_HDMI_CLK_OVRD_IN__MPLLB_HDMI_DIV_MASK                                       0x001CL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_HDMI_CLK_OVRD_IN__MPLLB_HDMI_OVRD_EN_MASK                                   0x0020L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_HDMI_CLK_OVRD_IN__RESERVED_15_6_MASK                                        0xFFC0L
//DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_EN__SHIFT                                                  0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_DIV5_CLK_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_TX_CLK_DIV__SHIFT                                          0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__OVRD_EN__SHIFT                                                   0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_V2I__SHIFT                                                 0x6
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_STANDBY__SHIFT                                             0x8
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_FREQ_VCO__SHIFT                                            0x9
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_CAL_FORCE__SHIFT                                           0xb
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLL_FRACN_EN__SHIFT                                             0xc
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_CLK_SYNC_OVRD__SHIFT                                       0xd
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_CLK_SYNC_OVRD_EN__SHIFT                                    0xe
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__RESERVED_15_15__SHIFT                                            0xf
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_EN_MASK                                                    0x0001L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_DIV5_CLK_EN_MASK                                           0x0002L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_TX_CLK_DIV_MASK                                            0x001CL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__OVRD_EN_MASK                                                     0x0020L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_V2I_MASK                                                   0x00C0L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_STANDBY_MASK                                               0x0100L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_FREQ_VCO_MASK                                              0x0600L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_CAL_FORCE_MASK                                             0x0800L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLL_FRACN_EN_MASK                                               0x1000L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_CLK_SYNC_OVRD_MASK                                         0x2000L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__MPLLA_CLK_SYNC_OVRD_EN_MASK                                      0x4000L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_0__RESERVED_15_15_MASK                                              0x8000L
//DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_1
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_1__MPLLA_MULTIPLIER__SHIFT                                          0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_1__RESERVED_15_12__SHIFT                                            0xc
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_1__MPLLA_MULTIPLIER_MASK                                            0x0FFFL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_1__RESERVED_15_12_MASK                                              0xF000L
//DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_2
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_2__MPLLA_SSC_EN__SHIFT                                              0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_2__MPLLA_SSC_OVRD_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_2__MPLLA_SSC_UP_SPREAD__SHIFT                                       0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_2__MPLLA_PMIX_EN__SHIFT                                             0x3
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_2__MPLLA_WORD_DIV2_EN__SHIFT                                        0x4
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_2__MPLLA_FRACN_CFG_UPDATE_EN__SHIFT                                 0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_2__RESERVED_15_6__SHIFT                                             0x6
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_2__MPLLA_SSC_EN_MASK                                                0x0001L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_2__MPLLA_SSC_OVRD_EN_MASK                                           0x0002L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_2__MPLLA_SSC_UP_SPREAD_MASK                                         0x0004L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_2__MPLLA_PMIX_EN_MASK                                               0x0008L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_2__MPLLA_WORD_DIV2_EN_MASK                                          0x0010L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_2__MPLLA_FRACN_CFG_UPDATE_EN_MASK                                   0x0020L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_2__RESERVED_15_6_MASK                                               0xFFC0L
//DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_PEAK_1
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_PEAK_1__MPLLA_SSC_PEAK_15_0__SHIFT                                      0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_PEAK_1__MPLLA_SSC_PEAK_15_0_MASK                                        0xFFFFL
//DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_PEAK_2
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_PEAK_2__MPLLA_SSC_PEAK_19_16__SHIFT                                     0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_PEAK_2__RESERVED_15_4__SHIFT                                            0x4
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_PEAK_2__MPLLA_SSC_PEAK_19_16_MASK                                       0x000FL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_PEAK_2__RESERVED_15_4_MASK                                              0xFFF0L
//DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_STEPSIZE_1
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_STEPSIZE_1__MPLLA_SSC_STEPSIZE_15_0__SHIFT                              0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_STEPSIZE_1__MPLLA_SSC_STEPSIZE_15_0_MASK                                0xFFFFL
//DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_STEPSIZE_2
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_STEPSIZE_2__MPLLA_SSC_STEPSIZE_20_16__SHIFT                             0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_STEPSIZE_2__RESERVED_15_5__SHIFT                                        0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_STEPSIZE_2__MPLLA_SSC_STEPSIZE_20_16_MASK                               0x001FL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_STEPSIZE_2__RESERVED_15_5_MASK                                          0xFFE0L
//DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_3
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_3__MPLLA_FRACN_QUOT__SHIFT                                          0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_3__MPLLA_FRACN_QUOT_MASK                                            0xFFFFL
//DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_4
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_4__MPLLA_FRACN_REM__SHIFT                                           0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_4__MPLLA_FRACN_REM_MASK                                             0xFFFFL
//DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_5
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_5__MPLLA_FRACN_DEN__SHIFT                                           0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_OVRD_IN_5__MPLLA_FRACN_DEN_MASK                                             0xFFFFL
//DPCSSYS_CR0_SUP_DIG_MPLLA_CP_OVRD_IN
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_OVRD_IN__MPLLA_CP_PROP__SHIFT                                            0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_OVRD_IN__MPLLA_CP_INT__SHIFT                                             0x7
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_OVRD_IN__RESERVED_15_14__SHIFT                                           0xe
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_OVRD_IN__MPLLA_CP_PROP_MASK                                              0x007FL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_OVRD_IN__MPLLA_CP_INT_MASK                                               0x3F80L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_OVRD_IN__RESERVED_15_14_MASK                                             0xC000L
//DPCSSYS_CR0_SUP_DIG_MPLLA_CP_GS_OVRD_IN
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_GS_OVRD_IN__MPLLA_CP_PROP_GS__SHIFT                                      0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_GS_OVRD_IN__MPLLA_CP_PROP_GS_OVR_EN__SHIFT                               0x7
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_GS_OVRD_IN__MPLLA_CP_INT_GS__SHIFT                                       0x8
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_GS_OVRD_IN__MPLLA_CP_INT_GS_OVR_EN__SHIFT                                0xf
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_GS_OVRD_IN__MPLLA_CP_PROP_GS_MASK                                        0x007FL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_GS_OVRD_IN__MPLLA_CP_PROP_GS_OVR_EN_MASK                                 0x0080L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_GS_OVRD_IN__MPLLA_CP_INT_GS_MASK                                         0x7F00L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_GS_OVRD_IN__MPLLA_CP_INT_GS_OVR_EN_MASK                                  0x8000L
//DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_EN__SHIFT                                                  0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_DIV5_CLK_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_TX_CLK_DIV__SHIFT                                          0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__OVRD_EN__SHIFT                                                   0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_V2I__SHIFT                                                 0x6
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_STANDBY__SHIFT                                             0x8
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_FREQ_VCO__SHIFT                                            0x9
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_CAL_FORCE__SHIFT                                           0xb
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLL_FRACN_EN__SHIFT                                             0xc
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_CLK_SYNC_OVRD__SHIFT                                       0xd
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_CLK_SYNC_OVRD_EN__SHIFT                                    0xe
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__RESERVED_15_15__SHIFT                                            0xf
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_EN_MASK                                                    0x0001L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_DIV5_CLK_EN_MASK                                           0x0002L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_TX_CLK_DIV_MASK                                            0x001CL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__OVRD_EN_MASK                                                     0x0020L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_V2I_MASK                                                   0x00C0L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_STANDBY_MASK                                               0x0100L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_FREQ_VCO_MASK                                              0x0600L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_CAL_FORCE_MASK                                             0x0800L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLL_FRACN_EN_MASK                                               0x1000L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_CLK_SYNC_OVRD_MASK                                         0x2000L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__MPLLB_CLK_SYNC_OVRD_EN_MASK                                      0x4000L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_0__RESERVED_15_15_MASK                                              0x8000L
//DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_1
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_1__MPLLB_MULTIPLIER__SHIFT                                          0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_1__RESERVED_15_12__SHIFT                                            0xc
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_1__MPLLB_MULTIPLIER_MASK                                            0x0FFFL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_1__RESERVED_15_12_MASK                                              0xF000L
//DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_2
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_2__MPLLB_SSC_EN__SHIFT                                              0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_2__MPLLB_SSC_OVRD_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_2__MPLLB_SSC_UP_SPREAD__SHIFT                                       0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_2__MPLLB_PMIX_EN__SHIFT                                             0x3
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_2__MPLLB_WORD_DIV2_EN__SHIFT                                        0x4
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_2__MPLLB_FRACN_CFG_UPDATE_EN__SHIFT                                 0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_2__RESERVED_15_6__SHIFT                                             0x6
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_2__MPLLB_SSC_EN_MASK                                                0x0001L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_2__MPLLB_SSC_OVRD_EN_MASK                                           0x0002L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_2__MPLLB_SSC_UP_SPREAD_MASK                                         0x0004L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_2__MPLLB_PMIX_EN_MASK                                               0x0008L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_2__MPLLB_WORD_DIV2_EN_MASK                                          0x0010L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_2__MPLLB_FRACN_CFG_UPDATE_EN_MASK                                   0x0020L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_2__RESERVED_15_6_MASK                                               0xFFC0L
//DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_PEAK_1
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_PEAK_1__MPLLB_SSC_PEAK_15_0__SHIFT                                      0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_PEAK_1__MPLLB_SSC_PEAK_15_0_MASK                                        0xFFFFL
//DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_PEAK_2
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_PEAK_2__MPLLB_SSC_PEAK_19_16__SHIFT                                     0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_PEAK_2__RESERVED_15_4__SHIFT                                            0x4
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_PEAK_2__MPLLB_SSC_PEAK_19_16_MASK                                       0x000FL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_PEAK_2__RESERVED_15_4_MASK                                              0xFFF0L
//DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_STEPSIZE_1
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_STEPSIZE_1__MPLLB_SSC_STEPSIZE_15_0__SHIFT                              0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_STEPSIZE_1__MPLLB_SSC_STEPSIZE_15_0_MASK                                0xFFFFL
//DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_STEPSIZE_2
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_STEPSIZE_2__MPLLB_SSC_STEPSIZE_20_16__SHIFT                             0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_STEPSIZE_2__RESERVED_15_5__SHIFT                                        0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_STEPSIZE_2__MPLLB_SSC_STEPSIZE_20_16_MASK                               0x001FL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_STEPSIZE_2__RESERVED_15_5_MASK                                          0xFFE0L
//DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_3
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_3__MPLLB_FRACN_QUOT__SHIFT                                          0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_3__MPLLB_FRACN_QUOT_MASK                                            0xFFFFL
//DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_4
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_4__MPLLB_FRACN_REM__SHIFT                                           0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_4__MPLLB_FRACN_REM_MASK                                             0xFFFFL
//DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_5
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_5__MPLLB_FRACN_DEN__SHIFT                                           0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_OVRD_IN_5__MPLLB_FRACN_DEN_MASK                                             0xFFFFL
//DPCSSYS_CR0_SUP_DIG_MPLLB_CP_OVRD_IN
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_OVRD_IN__MPLLB_CP_PROP__SHIFT                                            0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_OVRD_IN__MPLLB_CP_INT__SHIFT                                             0x7
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_OVRD_IN__RESERVED_15_14__SHIFT                                           0xe
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_OVRD_IN__MPLLB_CP_PROP_MASK                                              0x007FL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_OVRD_IN__MPLLB_CP_INT_MASK                                               0x3F80L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_OVRD_IN__RESERVED_15_14_MASK                                             0xC000L
//DPCSSYS_CR0_SUP_DIG_MPLLB_CP_GS_OVRD_IN
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_GS_OVRD_IN__MPLLB_CP_PROP_GS__SHIFT                                      0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_GS_OVRD_IN__MPLLB_CP_PROP_GS_OVR_EN__SHIFT                               0x7
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_GS_OVRD_IN__MPLLB_CP_INT_GS__SHIFT                                       0x8
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_GS_OVRD_IN__MPLLB_CP_INT_GS_OVR_EN__SHIFT                                0xf
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_GS_OVRD_IN__MPLLB_CP_PROP_GS_MASK                                        0x007FL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_GS_OVRD_IN__MPLLB_CP_PROP_GS_OVR_EN_MASK                                 0x0080L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_GS_OVRD_IN__MPLLB_CP_INT_GS_MASK                                         0x7F00L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_GS_OVRD_IN__MPLLB_CP_INT_GS_OVR_EN_MASK                                  0x8000L
//DPCSSYS_CR0_SUP_DIG_SUP_OVRD_IN
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_IN__PRESCALER_OVRD_EN__SHIFT                                             0x0
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_IN__RTUNE_REQ__SHIFT                                                     0x1
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_IN__RTUNE_OVRD_EN__SHIFT                                                 0x2
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_IN__TX_CAL_CODE__SHIFT                                                   0x3
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_IN__TX_CAL_CODE_EN__SHIFT                                                0x7
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_IN__REF_ALT_CLK_LP_SEL_OVRD__SHIFT                                       0x8
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_IN__REF_ALT_CLK_LP_SEL_OVRD_EN__SHIFT                                    0x9
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_IN__PRESCALER_OVRD_EN_MASK                                               0x0001L
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_IN__RTUNE_REQ_MASK                                                       0x0002L
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_IN__RTUNE_OVRD_EN_MASK                                                   0x0004L
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_IN__TX_CAL_CODE_MASK                                                     0x0078L
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_IN__TX_CAL_CODE_EN_MASK                                                  0x0080L
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_IN__REF_ALT_CLK_LP_SEL_OVRD_MASK                                         0x0100L
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_IN__REF_ALT_CLK_LP_SEL_OVRD_EN_MASK                                      0x0200L
//DPCSSYS_CR0_SUP_DIG_PRESCALER_OVRD_IN
#define DPCSSYS_CR0_SUP_DIG_PRESCALER_OVRD_IN__DCO_RANGE__SHIFT                                               0x0
#define DPCSSYS_CR0_SUP_DIG_PRESCALER_OVRD_IN__DCO_FINETUNE__SHIFT                                            0x2
#define DPCSSYS_CR0_SUP_DIG_PRESCALER_OVRD_IN__REF_CLK_MPLLB_DIV__SHIFT                                       0x8
#define DPCSSYS_CR0_SUP_DIG_PRESCALER_OVRD_IN__REF_CLK_MPLLA_DIV__SHIFT                                       0xb
#define DPCSSYS_CR0_SUP_DIG_PRESCALER_OVRD_IN__REF_CLKDET_RESULT__SHIFT                                       0xe
#define DPCSSYS_CR0_SUP_DIG_PRESCALER_OVRD_IN__REF_CLKDET_EN__SHIFT                                           0xf
#define DPCSSYS_CR0_SUP_DIG_PRESCALER_OVRD_IN__DCO_RANGE_MASK                                                 0x0003L
#define DPCSSYS_CR0_SUP_DIG_PRESCALER_OVRD_IN__DCO_FINETUNE_MASK                                              0x00FCL
#define DPCSSYS_CR0_SUP_DIG_PRESCALER_OVRD_IN__REF_CLK_MPLLB_DIV_MASK                                         0x0700L
#define DPCSSYS_CR0_SUP_DIG_PRESCALER_OVRD_IN__REF_CLK_MPLLA_DIV_MASK                                         0x3800L
#define DPCSSYS_CR0_SUP_DIG_PRESCALER_OVRD_IN__REF_CLKDET_RESULT_MASK                                         0x4000L
#define DPCSSYS_CR0_SUP_DIG_PRESCALER_OVRD_IN__REF_CLKDET_EN_MASK                                             0x8000L
//DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__RTUNE_ACK__SHIFT                                                    0x0
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__RTUNE_ACK_OVRD_EN__SHIFT                                            0x1
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__MPLLA_STATE__SHIFT                                                  0x2
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__MPLLA_STATE_OVRD_EN__SHIFT                                          0x3
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__MPLLB_STATE__SHIFT                                                  0x4
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__MPLLB_STATE_OVRD_EN__SHIFT                                          0x5
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__BG_LANE_STATE__SHIFT                                                0x6
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__BG_LANE_STATE_OVRD_EN__SHIFT                                        0x7
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__BG_SUP_STATE__SHIFT                                                 0x8
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__BG_SUP_STATE_OVRD_EN__SHIFT                                         0x9
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__REF_CLK_ACK__SHIFT                                                  0xa
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__RESERVED_15_11__SHIFT                                               0xb
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__RTUNE_ACK_MASK                                                      0x0001L
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__RTUNE_ACK_OVRD_EN_MASK                                              0x0002L
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__MPLLA_STATE_MASK                                                    0x0004L
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__MPLLA_STATE_OVRD_EN_MASK                                            0x0008L
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__MPLLB_STATE_MASK                                                    0x0010L
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__MPLLB_STATE_OVRD_EN_MASK                                            0x0020L
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__BG_LANE_STATE_MASK                                                  0x0040L
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__BG_LANE_STATE_OVRD_EN_MASK                                          0x0080L
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__BG_SUP_STATE_MASK                                                   0x0100L
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__BG_SUP_STATE_OVRD_EN_MASK                                           0x0200L
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__REF_CLK_ACK_MASK                                                    0x0400L
#define DPCSSYS_CR0_SUP_DIG_SUP_OVRD_OUT__RESERVED_15_11_MASK                                                 0xF800L
//DPCSSYS_CR0_SUP_DIG_LVL_OVRD_IN
#define DPCSSYS_CR0_SUP_DIG_LVL_OVRD_IN__RX_VREF_CTRL__SHIFT                                                  0x0
#define DPCSSYS_CR0_SUP_DIG_LVL_OVRD_IN__RX_VREF_CTRL_EN__SHIFT                                               0x3
#define DPCSSYS_CR0_SUP_DIG_LVL_OVRD_IN__SUP_RX_VCO_VREF_SEL_OVR__SHIFT                                       0x8
#define DPCSSYS_CR0_SUP_DIG_LVL_OVRD_IN__SUP_RX_VCO_VREF_SEL_OVR_EN__SHIFT                                    0xb
#define DPCSSYS_CR0_SUP_DIG_LVL_OVRD_IN__RESERVED_15_12__SHIFT                                                0xc
#define DPCSSYS_CR0_SUP_DIG_LVL_OVRD_IN__RX_VREF_CTRL_MASK                                                    0x0007L
#define DPCSSYS_CR0_SUP_DIG_LVL_OVRD_IN__RX_VREF_CTRL_EN_MASK                                                 0x0008L
#define DPCSSYS_CR0_SUP_DIG_LVL_OVRD_IN__SUP_RX_VCO_VREF_SEL_OVR_MASK                                         0x0700L
#define DPCSSYS_CR0_SUP_DIG_LVL_OVRD_IN__SUP_RX_VCO_VREF_SEL_OVR_EN_MASK                                      0x0800L
#define DPCSSYS_CR0_SUP_DIG_LVL_OVRD_IN__RESERVED_15_12_MASK                                                  0xF000L
//DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__MPLLA_EN__SHIFT                                                  0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__MPLLA_DIV5_CLK_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__MPLLA_TX_CLK_DIV__SHIFT                                          0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__MPLLA_V2I__SHIFT                                                 0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__MPLLA_STANDBY__SHIFT                                             0x7
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__MPLLA_FREQ_VCO__SHIFT                                            0x8
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__MPLLA_CAL_FORCE__SHIFT                                           0xa
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__MPLLA_FRACN_EN__SHIFT                                            0xb
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__RESERVED_15_12__SHIFT                                            0xc
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__MPLLA_EN_MASK                                                    0x0001L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__MPLLA_DIV5_CLK_EN_MASK                                           0x0002L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__MPLLA_TX_CLK_DIV_MASK                                            0x001CL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__MPLLA_V2I_MASK                                                   0x0060L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__MPLLA_STANDBY_MASK                                               0x0080L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__MPLLA_FREQ_VCO_MASK                                              0x0300L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__MPLLA_CAL_FORCE_MASK                                             0x0400L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__MPLLA_FRACN_EN_MASK                                              0x0800L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_0__RESERVED_15_12_MASK                                              0xF000L
//DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_1
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_1__MPLLA_MULTIPLIER__SHIFT                                          0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_1__RESERVED_15_12__SHIFT                                            0xc
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_1__MPLLA_MULTIPLIER_MASK                                            0x0FFFL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_1__RESERVED_15_12_MASK                                              0xF000L
//DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_2
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_2__MPLLA_SSC_EN__SHIFT                                              0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_2__MPLLA_SSC_UP_SPREAD__SHIFT                                       0x1
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_2__MPLLA_PMIX_EN__SHIFT                                             0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_2__MPLLA_WORD_DIV2_EN__SHIFT                                        0x3
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_2__MPLLA_FRACN_CFG_UPDATE_EN__SHIFT                                 0x4
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_2__MPLLA_CLK_SYNC__SHIFT                                            0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_2__RESERVED_15_6__SHIFT                                             0x6
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_2__MPLLA_SSC_EN_MASK                                                0x0001L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_2__MPLLA_SSC_UP_SPREAD_MASK                                         0x0002L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_2__MPLLA_PMIX_EN_MASK                                               0x0004L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_2__MPLLA_WORD_DIV2_EN_MASK                                          0x0008L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_2__MPLLA_FRACN_CFG_UPDATE_EN_MASK                                   0x0010L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_2__MPLLA_CLK_SYNC_MASK                                              0x0020L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_2__RESERVED_15_6_MASK                                               0xFFC0L
//DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_3
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_3__MPLLA_SSC_PEAK_15_0__SHIFT                                       0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_3__MPLLA_SSC_PEAK_15_0_MASK                                         0xFFFFL
//DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_4
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_4__MPLLA_SSC_PEAK_19_16__SHIFT                                      0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_4__RESERVED_15_4__SHIFT                                             0x4
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_4__MPLLA_SSC_PEAK_19_16_MASK                                        0x000FL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_4__RESERVED_15_4_MASK                                               0xFFF0L
//DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_5
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_5__MPLLA_SSC_STEPSIZE_15_0__SHIFT                                   0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_5__MPLLA_SSC_STEPSIZE_15_0_MASK                                     0xFFFFL
//DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_6
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_6__MPLLA_SSC_STEPSIZE_20_16__SHIFT                                  0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_6__RESERVED_15_4__SHIFT                                             0x4
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_6__MPLLA_SSC_STEPSIZE_20_16_MASK                                    0x000FL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_ASIC_IN_6__RESERVED_15_4_MASK                                               0xFFF0L
//DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__MPLLB_EN__SHIFT                                                  0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__MPLLB_DIV5_CLK_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__MPLLB_TX_CLK_DIV__SHIFT                                          0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__MPLLB_V2I__SHIFT                                                 0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__MPLLB_STANDBY__SHIFT                                             0x7
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__MPLLB_FREQ_VCO__SHIFT                                            0x8
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__MPLLB_CAL_FORCE__SHIFT                                           0xa
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__MPLLB_FRACN_EN__SHIFT                                            0xb
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__RESERVED_15_12__SHIFT                                            0xc
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__MPLLB_EN_MASK                                                    0x0001L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__MPLLB_DIV5_CLK_EN_MASK                                           0x0002L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__MPLLB_TX_CLK_DIV_MASK                                            0x001CL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__MPLLB_V2I_MASK                                                   0x0060L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__MPLLB_STANDBY_MASK                                               0x0080L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__MPLLB_FREQ_VCO_MASK                                              0x0300L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__MPLLB_CAL_FORCE_MASK                                             0x0400L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__MPLLB_FRACN_EN_MASK                                              0x0800L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_0__RESERVED_15_12_MASK                                              0xF000L
//DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_1
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_1__MPLLB_MULTIPLIER__SHIFT                                          0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_1__RESERVED_15_12__SHIFT                                            0xc
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_1__MPLLB_MULTIPLIER_MASK                                            0x0FFFL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_1__RESERVED_15_12_MASK                                              0xF000L
//DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_2
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_2__MPLLB_SSC_EN__SHIFT                                              0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_2__MPLLB_SSC_UP_SPREAD__SHIFT                                       0x1
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_2__MPLLB_PMIX_EN__SHIFT                                             0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_2__MPLLB_WORD_DIV2_EN__SHIFT                                        0x3
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_2__MPLLB_FRACN_CFG_UPDATE_EN__SHIFT                                 0x4
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_2__MPLLB_CLK_SYNC__SHIFT                                            0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_2__RESERVED_15_6__SHIFT                                             0x6
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_2__MPLLB_SSC_EN_MASK                                                0x0001L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_2__MPLLB_SSC_UP_SPREAD_MASK                                         0x0002L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_2__MPLLB_PMIX_EN_MASK                                               0x0004L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_2__MPLLB_WORD_DIV2_EN_MASK                                          0x0008L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_2__MPLLB_FRACN_CFG_UPDATE_EN_MASK                                   0x0010L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_2__MPLLB_CLK_SYNC_MASK                                              0x0020L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_2__RESERVED_15_6_MASK                                               0xFFC0L
//DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_3
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_3__MPLLB_SSC_PEAK_15_0__SHIFT                                       0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_3__MPLLB_SSC_PEAK_15_0_MASK                                         0xFFFFL
//DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_4
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_4__MPLLB_SSC_PEAK_19_16__SHIFT                                      0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_4__RESERVED_15_4__SHIFT                                             0x4
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_4__MPLLB_SSC_PEAK_19_16_MASK                                        0x000FL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_4__RESERVED_15_4_MASK                                               0xFFF0L
//DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_5
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_5__MPLLB_SSC_STEPSIZE_15_0__SHIFT                                   0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_5__MPLLB_SSC_STEPSIZE_15_0_MASK                                     0xFFFFL
//DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_6
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_6__MPLLB_SSC_STEPSIZE_20_16__SHIFT                                  0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_6__RESERVED_15_4__SHIFT                                             0x4
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_6__MPLLB_SSC_STEPSIZE_20_16_MASK                                    0x000FL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_ASIC_IN_6__RESERVED_15_4_MASK                                               0xFFF0L
//DPCSSYS_CR0_SUP_DIG_MPLLA_DIV_CLK_ASIC_IN
#define DPCSSYS_CR0_SUP_DIG_MPLLA_DIV_CLK_ASIC_IN__MPLLA_DIV_CLK_EN__SHIFT                                    0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_DIV_CLK_ASIC_IN__MPLLA_DIV_MULTIPLIER__SHIFT                                0x1
#define DPCSSYS_CR0_SUP_DIG_MPLLA_DIV_CLK_ASIC_IN__RESERVED_15_9__SHIFT                                       0x9
#define DPCSSYS_CR0_SUP_DIG_MPLLA_DIV_CLK_ASIC_IN__MPLLA_DIV_CLK_EN_MASK                                      0x0001L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_DIV_CLK_ASIC_IN__MPLLA_DIV_MULTIPLIER_MASK                                  0x01FEL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_DIV_CLK_ASIC_IN__RESERVED_15_9_MASK                                         0xFE00L
//DPCSSYS_CR0_SUP_DIG_MPLLA_HDMI_CLK_ASIC_IN
#define DPCSSYS_CR0_SUP_DIG_MPLLA_HDMI_CLK_ASIC_IN__MPLLA_HDMI_PIXEL_CLK_DIV__SHIFT                           0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_HDMI_CLK_ASIC_IN__MPLLA_HDMI_DIV__SHIFT                                     0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLA_HDMI_CLK_ASIC_IN__RESERVED_15_5__SHIFT                                      0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLA_HDMI_CLK_ASIC_IN__MPLLA_HDMI_PIXEL_CLK_DIV_MASK                             0x0003L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_HDMI_CLK_ASIC_IN__MPLLA_HDMI_DIV_MASK                                       0x001CL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_HDMI_CLK_ASIC_IN__RESERVED_15_5_MASK                                        0xFFE0L
//DPCSSYS_CR0_SUP_DIG_MPLLB_DIV_CLK_ASIC_IN
#define DPCSSYS_CR0_SUP_DIG_MPLLB_DIV_CLK_ASIC_IN__MPLLB_DIV_CLK_EN__SHIFT                                    0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_DIV_CLK_ASIC_IN__MPLLB_DIV_MULTIPLIER__SHIFT                                0x1
#define DPCSSYS_CR0_SUP_DIG_MPLLB_DIV_CLK_ASIC_IN__RESERVED_15_9__SHIFT                                       0x9
#define DPCSSYS_CR0_SUP_DIG_MPLLB_DIV_CLK_ASIC_IN__MPLLB_DIV_CLK_EN_MASK                                      0x0001L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_DIV_CLK_ASIC_IN__MPLLB_DIV_MULTIPLIER_MASK                                  0x01FEL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_DIV_CLK_ASIC_IN__RESERVED_15_9_MASK                                         0xFE00L
//DPCSSYS_CR0_SUP_DIG_MPLLB_HDMI_CLK_ASIC_IN
#define DPCSSYS_CR0_SUP_DIG_MPLLB_HDMI_CLK_ASIC_IN__MPLLB_HDMI_PIXEL_CLK_DIV__SHIFT                           0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_HDMI_CLK_ASIC_IN__MPLLB_HDMI_DIV__SHIFT                                     0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLB_HDMI_CLK_ASIC_IN__RESERVED_15_5__SHIFT                                      0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLB_HDMI_CLK_ASIC_IN__MPLLB_HDMI_PIXEL_CLK_DIV_MASK                             0x0003L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_HDMI_CLK_ASIC_IN__MPLLB_HDMI_DIV_MASK                                       0x001CL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_HDMI_CLK_ASIC_IN__RESERVED_15_5_MASK                                        0xFFE0L
//DPCSSYS_CR0_SUP_DIG_ASIC_IN
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__PHY_RESET__SHIFT                                                         0x0
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__REF_CLK_EN__SHIFT                                                        0x1
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__REF_USE_PAD__SHIFT                                                       0x2
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__TEST_BURNIN__SHIFT                                                       0x3
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__TEST_POWERDOWN__SHIFT                                                    0x4
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__RTUNE_REQ__SHIFT                                                         0x5
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__RTUNE_ACK__SHIFT                                                         0x6
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__MPLLA_STATE__SHIFT                                                       0x7
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__MPLLB_STATE__SHIFT                                                       0x8
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__TEST_TX_REF_CLK_EN__SHIFT                                                0x9
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__REF_ALT_CLK_LP_SEL__SHIFT                                                0xa
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__RESERVED_15_11__SHIFT                                                    0xb
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__PHY_RESET_MASK                                                           0x0001L
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__REF_CLK_EN_MASK                                                          0x0002L
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__REF_USE_PAD_MASK                                                         0x0004L
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__TEST_BURNIN_MASK                                                         0x0008L
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__TEST_POWERDOWN_MASK                                                      0x0010L
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__RTUNE_REQ_MASK                                                           0x0020L
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__RTUNE_ACK_MASK                                                           0x0040L
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__MPLLA_STATE_MASK                                                         0x0080L
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__MPLLB_STATE_MASK                                                         0x0100L
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__TEST_TX_REF_CLK_EN_MASK                                                  0x0200L
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__REF_ALT_CLK_LP_SEL_MASK                                                  0x0400L
#define DPCSSYS_CR0_SUP_DIG_ASIC_IN__RESERVED_15_11_MASK                                                      0xF800L
//DPCSSYS_CR0_SUP_DIG_LVL_ASIC_IN
#define DPCSSYS_CR0_SUP_DIG_LVL_ASIC_IN__RX_VREF_CTRL__SHIFT                                                  0x0
#define DPCSSYS_CR0_SUP_DIG_LVL_ASIC_IN__SUP_RX_VCO_VREF_SEL__SHIFT                                           0x6
#define DPCSSYS_CR0_SUP_DIG_LVL_ASIC_IN__RESERVED_15_9__SHIFT                                                 0x9
#define DPCSSYS_CR0_SUP_DIG_LVL_ASIC_IN__RX_VREF_CTRL_MASK                                                    0x0007L
#define DPCSSYS_CR0_SUP_DIG_LVL_ASIC_IN__SUP_RX_VCO_VREF_SEL_MASK                                             0x01C0L
#define DPCSSYS_CR0_SUP_DIG_LVL_ASIC_IN__RESERVED_15_9_MASK                                                   0xFE00L
//DPCSSYS_CR0_SUP_DIG_BANDGAP_ASIC_IN
#define DPCSSYS_CR0_SUP_DIG_BANDGAP_ASIC_IN__BG_EN__SHIFT                                                     0x0
#define DPCSSYS_CR0_SUP_DIG_BANDGAP_ASIC_IN__RESERVED_15_1__SHIFT                                             0x1
#define DPCSSYS_CR0_SUP_DIG_BANDGAP_ASIC_IN__BG_EN_MASK                                                       0x0001L
#define DPCSSYS_CR0_SUP_DIG_BANDGAP_ASIC_IN__RESERVED_15_1_MASK                                               0xFFFEL
//DPCSSYS_CR0_SUP_DIG_MPLLA_CP_ASIC_IN
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_ASIC_IN__MPLLA_CP_PROP__SHIFT                                            0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_ASIC_IN__MPLLA_CP_INT__SHIFT                                             0x7
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_ASIC_IN__RESERVED_15_14__SHIFT                                           0xe
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_ASIC_IN__MPLLA_CP_PROP_MASK                                              0x007FL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_ASIC_IN__MPLLA_CP_INT_MASK                                               0x3F80L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_ASIC_IN__RESERVED_15_14_MASK                                             0xC000L
//DPCSSYS_CR0_SUP_DIG_MPLLA_CP_GS_ASIC_IN
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_GS_ASIC_IN__MPLLA_CP_PROP_GS__SHIFT                                      0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_GS_ASIC_IN__MPLLA_CP_INT_GS__SHIFT                                       0x7
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_GS_ASIC_IN__RESERVED_15_14__SHIFT                                        0xe
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_GS_ASIC_IN__MPLLA_CP_PROP_GS_MASK                                        0x007FL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_GS_ASIC_IN__MPLLA_CP_INT_GS_MASK                                         0x3F80L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_CP_GS_ASIC_IN__RESERVED_15_14_MASK                                          0xC000L
//DPCSSYS_CR0_SUP_DIG_MPLLB_CP_ASIC_IN
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_ASIC_IN__MPLLB_CP_PROP__SHIFT                                            0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_ASIC_IN__MPLLB_CP_INT__SHIFT                                             0x7
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_ASIC_IN__RESERVED_15_14__SHIFT                                           0xe
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_ASIC_IN__MPLLB_CP_PROP_MASK                                              0x007FL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_ASIC_IN__MPLLB_CP_INT_MASK                                               0x3F80L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_ASIC_IN__RESERVED_15_14_MASK                                             0xC000L
//DPCSSYS_CR0_SUP_DIG_MPLLB_CP_GS_ASIC_IN
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_GS_ASIC_IN__MPLLB_CP_PROP_GS__SHIFT                                      0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_GS_ASIC_IN__MPLLB_CP_INT_GS__SHIFT                                       0x7
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_GS_ASIC_IN__RESERVED_15_14__SHIFT                                        0xe
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_GS_ASIC_IN__MPLLB_CP_PROP_GS_MASK                                        0x007FL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_GS_ASIC_IN__MPLLB_CP_INT_GS_MASK                                         0x3F80L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_CP_GS_ASIC_IN__RESERVED_15_14_MASK                                          0xC000L
//DPCSSYS_CR0_SUP_ANA_PRESCALER_CTRL
#define DPCSSYS_CR0_SUP_ANA_PRESCALER_CTRL__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_SUP_ANA_PRESCALER_CTRL__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_SUP_ANA_RTUNE_CTRL
#define DPCSSYS_CR0_SUP_ANA_RTUNE_CTRL__RESERVED_15_8__SHIFT                                                  0x8
#define DPCSSYS_CR0_SUP_ANA_RTUNE_CTRL__RESERVED_15_8_MASK                                                    0xFF00L
//DPCSSYS_CR0_SUP_ANA_BG1
#define DPCSSYS_CR0_SUP_ANA_BG1__RESERVED_15_8__SHIFT                                                         0x8
#define DPCSSYS_CR0_SUP_ANA_BG1__RESERVED_15_8_MASK                                                           0xFF00L
//DPCSSYS_CR0_SUP_ANA_BG2
#define DPCSSYS_CR0_SUP_ANA_BG2__RESERVED_15_8__SHIFT                                                         0x8
#define DPCSSYS_CR0_SUP_ANA_BG2__RESERVED_15_8_MASK                                                           0xFF00L
//DPCSSYS_CR0_SUP_ANA_SWITCH_PWR_MEAS
#define DPCSSYS_CR0_SUP_ANA_SWITCH_PWR_MEAS__RESERVED_15_8__SHIFT                                             0x8
#define DPCSSYS_CR0_SUP_ANA_SWITCH_PWR_MEAS__RESERVED_15_8_MASK                                               0xFF00L
//DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_OVRD
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_OVRD__OVRD_SEL__SHIFT                                     0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_OVRD__MPLL_FBDIGCLK_EN__SHIFT                             0x1
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_OVRD__MPLL_PCLK_EN__SHIFT                                 0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_OVRD__FAST_MPLL_PWRUP__SHIFT                              0x3
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_OVRD__FAST_MPLL_LOCK__SHIFT                               0x4
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_OVRD__DTB_SEL__SHIFT                                      0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_OVRD__DIV10_EN__SHIFT                                     0xa
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_OVRD__RESERVED__SHIFT                                     0xc
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_OVRD__OVRD_SEL_MASK                                       0x0001L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_OVRD__MPLL_FBDIGCLK_EN_MASK                               0x0002L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_OVRD__MPLL_PCLK_EN_MASK                                   0x0004L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_OVRD__FAST_MPLL_PWRUP_MASK                                0x0008L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_OVRD__FAST_MPLL_LOCK_MASK                                 0x0010L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_OVRD__DTB_SEL_MASK                                        0x03E0L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_OVRD__DIV10_EN_MASK                                       0x0400L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_OVRD__RESERVED_MASK                                       0xF000L
//DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__FSM_STATE__SHIFT                                         0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_R_LANES__SHIFT                                      0x4
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_L_LANES__SHIFT                                      0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_PCLK_EN__SHIFT                                      0x6
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_OUTPUT_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_FBCLK_EN__SHIFT                                     0x8
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_CAL__SHIFT                                          0x9
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_RST__SHIFT                                          0xa
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_ANA_EN__SHIFT                                       0xb
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_LOCK__SHIFT                                         0xc
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__RESERVED_15_13__SHIFT                                    0xd
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__FSM_STATE_MASK                                           0x000FL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_R_LANES_MASK                                        0x0010L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_L_LANES_MASK                                        0x0020L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_PCLK_EN_MASK                                        0x0040L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_OUTPUT_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_FBCLK_EN_MASK                                       0x0100L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_CAL_MASK                                            0x0200L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_RST_MASK                                            0x0400L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_ANA_EN_MASK                                         0x0800L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__MPLL_LOCK_MASK                                           0x1000L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_STAT__RESERVED_15_13_MASK                                      0xE000L
//DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_DAC_MAXRANGE
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_DAC_MAXRANGE__MAX_RANGE__SHIFT                            0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_DAC_MAXRANGE__DAC_IN__SHIFT                               0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_DAC_MAXRANGE__RESERVED_15_10__SHIFT                       0xa
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_DAC_MAXRANGE__MAX_RANGE_MASK                              0x001FL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_DAC_MAXRANGE__DAC_IN_MASK                                 0x03E0L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_DAC_MAXRANGE__RESERVED_15_10_MASK                         0xFC00L
//DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_LOCK
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_LOCK__LOCK_TIME__SHIFT                             0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_LOCK__STABLE_TIME__SHIFT                           0x8
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_LOCK__RESERVED_15_14__SHIFT                        0xe
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_LOCK__LOCK_TIME_MASK                               0x00FFL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_LOCK__STABLE_TIME_MASK                             0x3F00L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_LOCK__RESERVED_15_14_MASK                          0xC000L
//DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS__GEARSHIFT_TIME__SHIFT                             0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS__PRESET_TIME__SHIFT                                0x8
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS__GEARSHIFT_TIME_MASK                               0x00FFL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS__PRESET_TIME_MASK                                  0xFF00L
//DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE__PWRDN_WAIT_TIME__SHIFT                0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE__PCLK_EN_TIME__SHIFT                   0x6
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE__RESERVED_15_12__SHIFT                 0xc
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE__PWRDN_WAIT_TIME_MASK                  0x003FL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE__PCLK_EN_TIME_MASK                     0x0FC0L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE__RESERVED_15_12_MASK                   0xF000L
//DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE_2
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE_2__PCLK_DIS_TIME__SHIFT                0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE_2__PWRDN_TIME__SHIFT                   0x6
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE_2__RESERVED_15_12__SHIFT               0xc
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE_2__PCLK_DIS_TIME_MASK                  0x003FL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE_2__PWRDN_TIME_MASK                     0x0FC0L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE_2__RESERVED_15_12_MASK                 0xF000L
//DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_CAL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_CAL__MPLL_CAL__SHIFT                                      0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_CAL__MPLL_CAL_OVRD_EN__SHIFT                              0x1
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_CAL__RESERVED_15_2__SHIFT                                 0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_CAL__MPLL_CAL_MASK                                        0x0001L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_CAL__MPLL_CAL_OVRD_EN_MASK                                0x0002L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_CAL__RESERVED_15_2_MASK                                   0xFFFCL
//DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_ANA_DAC_OUT
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_ANA_DAC_OUT__MPLL_ANA_DAC_OUT__SHIFT                      0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_ANA_DAC_OUT__RESERVED_15_5__SHIFT                         0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_ANA_DAC_OUT__MPLL_ANA_DAC_OUT_MASK                        0x001FL
#define DPCSSYS_CR0_SUP_DIG_MPLLA_MPLL_PWR_CTL_MPLL_ANA_DAC_OUT__RESERVED_15_5_MASK                           0xFFE0L
//DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_GEN_SPREAD_TYPE
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_GEN_SPREAD_TYPE__SPREAD_TYPE__SHIFT                                     0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_GEN_SPREAD_TYPE__OVR_EN__SHIFT                                          0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_GEN_SPREAD_TYPE__RESERVED_15_3__SHIFT                                   0x3
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_GEN_SPREAD_TYPE__SPREAD_TYPE_MASK                                       0x0003L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_GEN_SPREAD_TYPE__OVR_EN_MASK                                            0x0004L
#define DPCSSYS_CR0_SUP_DIG_MPLLA_SSC_GEN_SPREAD_TYPE__RESERVED_15_3_MASK                                     0xFFF8L
//DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_OVRD
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_OVRD__OVRD_SEL__SHIFT                                     0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_OVRD__MPLL_FBDIGCLK_EN__SHIFT                             0x1
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_OVRD__MPLL_PCLK_EN__SHIFT                                 0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_OVRD__FAST_MPLL_PWRUP__SHIFT                              0x3
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_OVRD__FAST_MPLL_LOCK__SHIFT                               0x4
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_OVRD__DTB_SEL__SHIFT                                      0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_OVRD__DIV10_EN__SHIFT                                     0xa
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_OVRD__RESERVED__SHIFT                                     0xc
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_OVRD__OVRD_SEL_MASK                                       0x0001L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_OVRD__MPLL_FBDIGCLK_EN_MASK                               0x0002L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_OVRD__MPLL_PCLK_EN_MASK                                   0x0004L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_OVRD__FAST_MPLL_PWRUP_MASK                                0x0008L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_OVRD__FAST_MPLL_LOCK_MASK                                 0x0010L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_OVRD__DTB_SEL_MASK                                        0x03E0L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_OVRD__DIV10_EN_MASK                                       0x0400L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_OVRD__RESERVED_MASK                                       0xF000L
//DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__FSM_STATE__SHIFT                                         0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_R_LANES__SHIFT                                      0x4
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_L_LANES__SHIFT                                      0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_PCLK_EN__SHIFT                                      0x6
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_OUTPUT_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_FBCLK_EN__SHIFT                                     0x8
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_CAL__SHIFT                                          0x9
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_RST__SHIFT                                          0xa
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_ANA_EN__SHIFT                                       0xb
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_LOCK__SHIFT                                         0xc
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__RESERVED_15_13__SHIFT                                    0xd
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__FSM_STATE_MASK                                           0x000FL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_R_LANES_MASK                                        0x0010L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_L_LANES_MASK                                        0x0020L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_PCLK_EN_MASK                                        0x0040L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_OUTPUT_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_FBCLK_EN_MASK                                       0x0100L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_CAL_MASK                                            0x0200L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_RST_MASK                                            0x0400L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_ANA_EN_MASK                                         0x0800L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__MPLL_LOCK_MASK                                           0x1000L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_STAT__RESERVED_15_13_MASK                                      0xE000L
//DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_DAC_MAXRANGE
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_DAC_MAXRANGE__MAX_RANGE__SHIFT                            0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_DAC_MAXRANGE__DAC_IN__SHIFT                               0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_DAC_MAXRANGE__RESERVED_15_10__SHIFT                       0xa
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_DAC_MAXRANGE__MAX_RANGE_MASK                              0x001FL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_DAC_MAXRANGE__DAC_IN_MASK                                 0x03E0L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_DAC_MAXRANGE__RESERVED_15_10_MASK                         0xFC00L
//DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_LOCK
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_LOCK__LOCK_TIME__SHIFT                             0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_LOCK__STABLE_TIME__SHIFT                           0x8
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_LOCK__RESERVED_15_14__SHIFT                        0xe
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_LOCK__LOCK_TIME_MASK                               0x00FFL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_LOCK__STABLE_TIME_MASK                             0x3F00L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_LOCK__RESERVED_15_14_MASK                          0xC000L
//DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS__GEARSHIFT_TIME__SHIFT                             0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS__PRESET_TIME__SHIFT                                0x8
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS__GEARSHIFT_TIME_MASK                               0x00FFL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS__PRESET_TIME_MASK                                  0xFF00L
//DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE__PWRDN_WAIT_TIME__SHIFT                0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE__PCLK_EN_TIME__SHIFT                   0x6
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE__RESERVED_15_12__SHIFT                 0xc
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE__PWRDN_WAIT_TIME_MASK                  0x003FL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE__PCLK_EN_TIME_MASK                     0x0FC0L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE__RESERVED_15_12_MASK                   0xF000L
//DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE_2
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE_2__PCLK_DIS_TIME__SHIFT                0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE_2__PWRDN_TIME__SHIFT                   0x6
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE_2__RESERVED_15_12__SHIFT               0xc
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE_2__PCLK_DIS_TIME_MASK                  0x003FL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE_2__PWRDN_TIME_MASK                     0x0FC0L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_TIMERS_PCLK_STABLE_2__RESERVED_15_12_MASK                 0xF000L
//DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_CAL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_CAL__MPLL_CAL__SHIFT                                      0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_CAL__MPLL_CAL_OVRD_EN__SHIFT                              0x1
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_CAL__RESERVED_15_2__SHIFT                                 0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_CAL__MPLL_CAL_MASK                                        0x0001L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_CAL__MPLL_CAL_OVRD_EN_MASK                                0x0002L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_CAL__RESERVED_15_2_MASK                                   0xFFFCL
//DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_ANA_DAC_OUT
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_ANA_DAC_OUT__MPLL_ANA_DAC_OUT__SHIFT                      0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_ANA_DAC_OUT__RESERVED_15_5__SHIFT                         0x5
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_ANA_DAC_OUT__MPLL_ANA_DAC_OUT_MASK                        0x001FL
#define DPCSSYS_CR0_SUP_DIG_MPLLB_MPLL_PWR_CTL_MPLL_ANA_DAC_OUT__RESERVED_15_5_MASK                           0xFFE0L
//DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_GEN_SPREAD_TYPE
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_GEN_SPREAD_TYPE__SPREAD_TYPE__SHIFT                                     0x0
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_GEN_SPREAD_TYPE__OVR_EN__SHIFT                                          0x2
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_GEN_SPREAD_TYPE__RESERVED_15_3__SHIFT                                   0x3
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_GEN_SPREAD_TYPE__SPREAD_TYPE_MASK                                       0x0003L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_GEN_SPREAD_TYPE__OVR_EN_MASK                                            0x0004L
#define DPCSSYS_CR0_SUP_DIG_MPLLB_SSC_GEN_SPREAD_TYPE__RESERVED_15_3_MASK                                     0xFFF8L
//DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_0
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_0__BG_SUP_EN_TIME__SHIFT                                    0x0
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_0__FAST_BG_WAIT__SHIFT                                      0x9
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_0__RESERVED_15_10__SHIFT                                    0xa
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_0__BG_SUP_EN_TIME_MASK                                      0x01FFL
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_0__FAST_BG_WAIT_MASK                                        0x0200L
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_0__RESERVED_15_10_MASK                                      0xFC00L
//DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_1
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_1__BG_LANE_EN_TIME__SHIFT                                   0x0
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_1__RESERVED_15_9__SHIFT                                     0x9
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_1__BG_LANE_EN_TIME_MASK                                     0x01FFL
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_1__RESERVED_15_9_MASK                                       0xFE00L
//DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_2
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_2__BG_KICK_START_EN_TIME__SHIFT                             0x0
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_2__BG_SUP_STATE_UPD_EN__SHIFT                               0x8
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_2__RESERVED_15_9__SHIFT                                     0x9
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_2__BG_KICK_START_EN_TIME_MASK                               0x00FFL
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_2__BG_SUP_STATE_UPD_EN_MASK                                 0x0100L
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_BG_PWRUP_TIME_2__RESERVED_15_9_MASK                                       0xFE00L
//DPCSSYS_CR0_SUP_DIG_CLK_RST_REF_PWRUP_TIME_0
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_REF_PWRUP_TIME_0__REF_VREG_FAST_START_TIME__SHIFT                         0x0
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_REF_PWRUP_TIME_0__FAST_REF_WAIT__SHIFT                                    0x5
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_REF_PWRUP_TIME_0__RESERVED_15_6__SHIFT                                    0x6
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_REF_PWRUP_TIME_0__REF_VREG_FAST_START_TIME_MASK                           0x001FL
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_REF_PWRUP_TIME_0__FAST_REF_WAIT_MASK                                      0x0020L
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_REF_PWRUP_TIME_0__RESERVED_15_6_MASK                                      0xFFC0L
//DPCSSYS_CR0_SUP_DIG_CLK_RST_REF_VPHUD
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_REF_VPHUD__SUP_ANA_VPHUD_SELVPH_I__SHIFT                                  0x0
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_REF_VPHUD__SUP_ANA_VPHUD_EN_I__SHIFT                                      0x1
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_REF_VPHUD__RESERVED_15_2__SHIFT                                           0x2
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_REF_VPHUD__SUP_ANA_VPHUD_SELVPH_I_MASK                                    0x0001L
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_REF_VPHUD__SUP_ANA_VPHUD_EN_I_MASK                                        0x0002L
#define DPCSSYS_CR0_SUP_DIG_CLK_RST_REF_VPHUD__RESERVED_15_2_MASK                                             0xFFFCL
//DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG__RX_CAL_EN__SHIFT                                                    0x0
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG__FAST_RTUNE__SHIFT                                                   0x1
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG__TX_CAL_EN__SHIFT                                                    0x2
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG__SUP_ANA_TERM_CTRL__SHIFT                                            0x3
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG__RX_CAL_EN_MASK                                                      0x0001L
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG__FAST_RTUNE_MASK                                                     0x0002L
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG__TX_CAL_EN_MASK                                                      0x0004L
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG__SUP_ANA_TERM_CTRL_MASK                                              0x0038L
//DPCSSYS_CR0_SUP_DIG_RTUNE_STAT
#define DPCSSYS_CR0_SUP_DIG_RTUNE_STAT__STAT__SHIFT                                                           0x0
#define DPCSSYS_CR0_SUP_DIG_RTUNE_STAT__DTB_RTUNE__SHIFT                                                      0xa
#define DPCSSYS_CR0_SUP_DIG_RTUNE_STAT__RESERVED_15_12__SHIFT                                                 0xc
#define DPCSSYS_CR0_SUP_DIG_RTUNE_STAT__STAT_MASK                                                             0x03FFL
#define DPCSSYS_CR0_SUP_DIG_RTUNE_STAT__DTB_RTUNE_MASK                                                        0x0C00L
#define DPCSSYS_CR0_SUP_DIG_RTUNE_STAT__RESERVED_15_12_MASK                                                   0xF000L
//DPCSSYS_CR0_SUP_DIG_RTUNE_RX_SET_VAL
#define DPCSSYS_CR0_SUP_DIG_RTUNE_RX_SET_VAL__RX_SET_VAL__SHIFT                                               0x0
#define DPCSSYS_CR0_SUP_DIG_RTUNE_RX_SET_VAL__RESERVED_15_6__SHIFT                                            0x6
#define DPCSSYS_CR0_SUP_DIG_RTUNE_RX_SET_VAL__RX_SET_VAL_MASK                                                 0x003FL
#define DPCSSYS_CR0_SUP_DIG_RTUNE_RX_SET_VAL__RESERVED_15_6_MASK                                              0xFFC0L
//DPCSSYS_CR0_SUP_DIG_RTUNE_TXDN_SET_VAL
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TXDN_SET_VAL__TXDN_SET_VAL__SHIFT                                           0x0
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TXDN_SET_VAL__RESERVED_15_10__SHIFT                                         0xa
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TXDN_SET_VAL__TXDN_SET_VAL_MASK                                             0x03FFL
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TXDN_SET_VAL__RESERVED_15_10_MASK                                           0xFC00L
//DPCSSYS_CR0_SUP_DIG_RTUNE_TXUP_SET_VAL
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TXUP_SET_VAL__TXUP_SET_VAL__SHIFT                                           0x0
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TXUP_SET_VAL__RESERVED_15_10__SHIFT                                         0xa
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TXUP_SET_VAL__TXUP_SET_VAL_MASK                                             0x03FFL
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TXUP_SET_VAL__RESERVED_15_10_MASK                                           0xFC00L
//DPCSSYS_CR0_SUP_DIG_RTUNE_RX_STAT
#define DPCSSYS_CR0_SUP_DIG_RTUNE_RX_STAT__RX_STAT__SHIFT                                                     0x0
#define DPCSSYS_CR0_SUP_DIG_RTUNE_RX_STAT__RESERVED_15_6__SHIFT                                               0x6
#define DPCSSYS_CR0_SUP_DIG_RTUNE_RX_STAT__RX_STAT_MASK                                                       0x003FL
#define DPCSSYS_CR0_SUP_DIG_RTUNE_RX_STAT__RESERVED_15_6_MASK                                                 0xFFC0L
//DPCSSYS_CR0_SUP_DIG_RTUNE_TXDN_STAT
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TXDN_STAT__TXDN_STAT__SHIFT                                                 0x0
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TXDN_STAT__RESERVED_15_10__SHIFT                                            0xa
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TXDN_STAT__TXDN_STAT_MASK                                                   0x03FFL
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TXDN_STAT__RESERVED_15_10_MASK                                              0xFC00L
//DPCSSYS_CR0_SUP_DIG_RTUNE_TXUP_STAT
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TXUP_STAT__TXUP_STAT__SHIFT                                                 0x0
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TXUP_STAT__RESERVED_15_10__SHIFT                                            0xa
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TXUP_STAT__TXUP_STAT_MASK                                                   0x03FFL
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TXUP_STAT__RESERVED_15_10_MASK                                              0xFC00L
//DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG_CNT0
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG_CNT0__RT_RESULT_TIME__SHIFT                                          0x0
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG_CNT0__RT_EVAL_TIME__SHIFT                                            0x4
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG_CNT0__RT_RST_TIME__SHIFT                                             0x8
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG_CNT0__RT_ACK_TIME__SHIFT                                             0xc
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG_CNT0__RT_RESULT_TIME_MASK                                            0x000FL
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG_CNT0__RT_EVAL_TIME_MASK                                              0x00F0L
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG_CNT0__RT_RST_TIME_MASK                                               0x0F00L
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG_CNT0__RT_ACK_TIME_MASK                                               0xF000L
//DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG_CNT1
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG_CNT1__RT_TXDN_SETTLE_TIME__SHIFT                                     0x0
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG_CNT1__RT_PWRUP_TIME__SHIFT                                           0x4
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG_CNT1__RESERVED_15_9__SHIFT                                           0x9
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG_CNT1__RT_TXDN_SETTLE_TIME_MASK                                       0x000FL
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG_CNT1__RT_PWRUP_TIME_MASK                                             0x01F0L
#define DPCSSYS_CR0_SUP_DIG_RTUNE_CONFIG_CNT1__RESERVED_15_9_MASK                                             0xFE00L
//DPCSSYS_CR0_SUP_DIG_RTUNE_TX_CAL_CODE
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TX_CAL_CODE__VALUE__SHIFT                                                   0x0
#define DPCSSYS_CR0_SUP_DIG_RTUNE_TX_CAL_CODE__VALUE_MASK                                                     0x000FL
//DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_WORD_CLK_EN__SHIFT                                    0x0
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_HDMI_CLK_EN__SHIFT                                    0x1
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_DIV_CLK_EN__SHIFT                                     0x2
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_OUTPUT_EN__SHIFT                                      0x3
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_CLK_EN_OVRD_EN__SHIFT                                 0x4
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_OUTPUT_L_EN__SHIFT                                    0x5
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_OUTPUT_R_EN__SHIFT                                    0x6
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_ANA_EN__SHIFT                                         0x7
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_RST__SHIFT                                            0x8
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_CAL__SHIFT                                            0x9
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_DIV5_CLK_EN__SHIFT                                    0xa
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_DIV10_CLK_EN__SHIFT                                   0xb
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_FBCLK_EN__SHIFT                                       0xc
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_GEARSHIFT_EN__SHIFT                                   0xd
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_STANDBY__SHIFT                                        0xe
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__OVRD_SEL__SHIFT                                             0xf
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_WORD_CLK_EN_MASK                                      0x0001L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_HDMI_CLK_EN_MASK                                      0x0002L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_DIV_CLK_EN_MASK                                       0x0004L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_OUTPUT_EN_MASK                                        0x0008L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_CLK_EN_OVRD_EN_MASK                                   0x0010L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_OUTPUT_L_EN_MASK                                      0x0020L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_OUTPUT_R_EN_MASK                                      0x0040L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_ANA_EN_MASK                                           0x0080L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_RST_MASK                                              0x0100L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_CAL_MASK                                              0x0200L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_DIV5_CLK_EN_MASK                                      0x0400L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_DIV10_CLK_EN_MASK                                     0x0800L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_FBCLK_EN_MASK                                         0x1000L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_GEARSHIFT_EN_MASK                                     0x2000L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__MPLLA_STANDBY_MASK                                          0x4000L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_0__OVRD_SEL_MASK                                               0x8000L
//DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_1
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_1__MPLLA_ANA_INT__SHIFT                                        0x0
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_1__RESERVED_15_10__SHIFT                                       0xa
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_1__MPLLA_ANA_INT_MASK                                          0x03FFL
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_1__RESERVED_15_10_MASK                                         0xFC00L
//DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_2
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_2__MPLLA_CP_PROP__SHIFT                                        0x0
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_2__MPLLA_CP_INT__SHIFT                                         0x7
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_2__RESERVED_15_14__SHIFT                                       0xe
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_2__MPLLA_CP_PROP_MASK                                          0x007FL
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_2__MPLLA_CP_INT_MASK                                           0x3F80L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_OVRD_OUT_2__RESERVED_15_14_MASK                                         0xC000L
//DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_WORD_CLK_EN__SHIFT                                    0x0
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_HDMI_CLK_EN__SHIFT                                    0x1
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_DIV_CLK_EN__SHIFT                                     0x2
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_OUTPUT_EN__SHIFT                                      0x3
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_CLK_EN_OVRD_EN__SHIFT                                 0x4
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_OUTPUT_L_EN__SHIFT                                    0x5
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_OUTPUT_R_EN__SHIFT                                    0x6
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_ANA_EN__SHIFT                                         0x7
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_RST__SHIFT                                            0x8
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_CAL__SHIFT                                            0x9
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_DIV5_CLK_EN__SHIFT                                    0xa
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_DIV10_CLK_EN__SHIFT                                   0xb
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_FBCLK_EN__SHIFT                                       0xc
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_GEARSHIFT_EN__SHIFT                                   0xd
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_STANDBY__SHIFT                                        0xe
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__OVRD_SEL__SHIFT                                             0xf
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_WORD_CLK_EN_MASK                                      0x0001L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_HDMI_CLK_EN_MASK                                      0x0002L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_DIV_CLK_EN_MASK                                       0x0004L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_OUTPUT_EN_MASK                                        0x0008L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_CLK_EN_OVRD_EN_MASK                                   0x0010L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_OUTPUT_L_EN_MASK                                      0x0020L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_OUTPUT_R_EN_MASK                                      0x0040L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_ANA_EN_MASK                                           0x0080L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_RST_MASK                                              0x0100L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_CAL_MASK                                              0x0200L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_DIV5_CLK_EN_MASK                                      0x0400L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_DIV10_CLK_EN_MASK                                     0x0800L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_FBCLK_EN_MASK                                         0x1000L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_GEARSHIFT_EN_MASK                                     0x2000L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__MPLLB_STANDBY_MASK                                          0x4000L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_0__OVRD_SEL_MASK                                               0x8000L
//DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_1
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_1__MPLLB_ANA_INT__SHIFT                                        0x0
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_1__RESERVED_15_10__SHIFT                                       0xa
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_1__MPLLB_ANA_INT_MASK                                          0x03FFL
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_1__RESERVED_15_10_MASK                                         0xFC00L
//DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_2
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_2__MPLLB_CP_PROP__SHIFT                                        0x0
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_2__MPLLB_CP_INT__SHIFT                                         0x7
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_2__RESERVED_15_14__SHIFT                                       0xe
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_2__MPLLB_CP_PROP_MASK                                          0x007FL
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_2__MPLLB_CP_INT_MASK                                           0x3F80L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_OVRD_OUT_2__RESERVED_15_14_MASK                                         0xC000L
//DPCSSYS_CR0_SUP_DIG_ANA_RTUNE_OVRD_OUT
#define DPCSSYS_CR0_SUP_DIG_ANA_RTUNE_OVRD_OUT__RTUNE_COMP_RST__SHIFT                                         0x0
#define DPCSSYS_CR0_SUP_DIG_ANA_RTUNE_OVRD_OUT__RTUNE_MODE__SHIFT                                             0x1
#define DPCSSYS_CR0_SUP_DIG_ANA_RTUNE_OVRD_OUT__RTUNE_EN__SHIFT                                               0x3
#define DPCSSYS_CR0_SUP_DIG_ANA_RTUNE_OVRD_OUT__RTUNE_VALUE__SHIFT                                            0x4
#define DPCSSYS_CR0_SUP_DIG_ANA_RTUNE_OVRD_OUT__RTUNE_OVRD_EN__SHIFT                                          0xe
#define DPCSSYS_CR0_SUP_DIG_ANA_RTUNE_OVRD_OUT__RESERVED_15_15__SHIFT                                         0xf
#define DPCSSYS_CR0_SUP_DIG_ANA_RTUNE_OVRD_OUT__RTUNE_COMP_RST_MASK                                           0x0001L
#define DPCSSYS_CR0_SUP_DIG_ANA_RTUNE_OVRD_OUT__RTUNE_MODE_MASK                                               0x0006L
#define DPCSSYS_CR0_SUP_DIG_ANA_RTUNE_OVRD_OUT__RTUNE_EN_MASK                                                 0x0008L
#define DPCSSYS_CR0_SUP_DIG_ANA_RTUNE_OVRD_OUT__RTUNE_VALUE_MASK                                              0x3FF0L
#define DPCSSYS_CR0_SUP_DIG_ANA_RTUNE_OVRD_OUT__RTUNE_OVRD_EN_MASK                                            0x4000L
#define DPCSSYS_CR0_SUP_DIG_ANA_RTUNE_OVRD_OUT__RESERVED_15_15_MASK                                           0x8000L
//DPCSSYS_CR0_SUP_DIG_ANA_STAT
#define DPCSSYS_CR0_SUP_DIG_ANA_STAT__RT_ANA_COMP_RESULT__SHIFT                                               0x0
#define DPCSSYS_CR0_SUP_DIG_ANA_STAT__REF_ANA_CLKDET_RESULT__SHIFT                                            0x1
#define DPCSSYS_CR0_SUP_DIG_ANA_STAT__RESERVED_15_2__SHIFT                                                    0x2
#define DPCSSYS_CR0_SUP_DIG_ANA_STAT__RT_ANA_COMP_RESULT_MASK                                                 0x0001L
#define DPCSSYS_CR0_SUP_DIG_ANA_STAT__REF_ANA_CLKDET_RESULT_MASK                                              0x0002L
#define DPCSSYS_CR0_SUP_DIG_ANA_STAT__RESERVED_15_2_MASK                                                      0xFFFCL
//DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__BG_EN__SHIFT                                                     0x0
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__BG_FAST_START__SHIFT                                             0x1
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__BG_KICK_START__SHIFT                                             0x2
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__BG_OVRD_EN__SHIFT                                                0x3
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__ANA_ASYNC_RST__SHIFT                                             0x4
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__ANA_ASYNC_RST_OVRD_EN__SHIFT                                     0x5
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__REF_VREG_FAST_START__SHIFT                                       0x6
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__REF_VREG_FAST_START_OVRD_EN__SHIFT                               0x7
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__REF_VREG_REF_SEL__SHIFT                                          0x8
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__REF_VREG_REF_SEL_OVRD_EN__SHIFT                                  0xa
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__RESERVED_15_11__SHIFT                                            0xb
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__BG_EN_MASK                                                       0x0001L
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__BG_FAST_START_MASK                                               0x0002L
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__BG_KICK_START_MASK                                               0x0004L
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__BG_OVRD_EN_MASK                                                  0x0008L
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__ANA_ASYNC_RST_MASK                                               0x0010L
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__ANA_ASYNC_RST_OVRD_EN_MASK                                       0x0020L
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__REF_VREG_FAST_START_MASK                                         0x0040L
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__REF_VREG_FAST_START_OVRD_EN_MASK                                 0x0080L
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__REF_VREG_REF_SEL_MASK                                            0x0300L
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__REF_VREG_REF_SEL_OVRD_EN_MASK                                    0x0400L
#define DPCSSYS_CR0_SUP_DIG_ANA_BG_OVRD_OUT__RESERVED_15_11_MASK                                              0xF800L
//DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_PMIX_OVRD_OUT
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_PMIX_OVRD_OUT__MPLLA_PMIX_SEL__SHIFT                                    0x0
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_PMIX_OVRD_OUT__MPLLA_PMIX_EN__SHIFT                                     0x6
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_PMIX_OVRD_OUT__MPLLA_PMIX_SEL_OVRD_EN__SHIFT                            0x7
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_PMIX_OVRD_OUT__MPLLA_PMIX_EN_OVRD_EN__SHIFT                             0x8
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_PMIX_OVRD_OUT__RESERVED_15_9__SHIFT                                     0x9
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_PMIX_OVRD_OUT__MPLLA_PMIX_SEL_MASK                                      0x003FL
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_PMIX_OVRD_OUT__MPLLA_PMIX_EN_MASK                                       0x0040L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_PMIX_OVRD_OUT__MPLLA_PMIX_SEL_OVRD_EN_MASK                              0x0080L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_PMIX_OVRD_OUT__MPLLA_PMIX_EN_OVRD_EN_MASK                               0x0100L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLA_PMIX_OVRD_OUT__RESERVED_15_9_MASK                                       0xFE00L
//DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_PMIX_OVRD_OUT
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_PMIX_OVRD_OUT__MPLLB_PMIX_SEL__SHIFT                                    0x0
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_PMIX_OVRD_OUT__MPLLB_PMIX_EN__SHIFT                                     0x6
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_PMIX_OVRD_OUT__MPLLB_PMIX_SEL_OVRD_EN__SHIFT                            0x7
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_PMIX_OVRD_OUT__MPLLB_PMIX_EN_OVRD_EN__SHIFT                             0x8
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_PMIX_OVRD_OUT__RESERVED_15_9__SHIFT                                     0x9
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_PMIX_OVRD_OUT__MPLLB_PMIX_SEL_MASK                                      0x003FL
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_PMIX_OVRD_OUT__MPLLB_PMIX_EN_MASK                                       0x0040L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_PMIX_OVRD_OUT__MPLLB_PMIX_SEL_OVRD_EN_MASK                              0x0080L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_PMIX_OVRD_OUT__MPLLB_PMIX_EN_OVRD_EN_MASK                               0x0100L
#define DPCSSYS_CR0_SUP_DIG_ANA_MPLLB_PMIX_OVRD_OUT__RESERVED_15_9_MASK                                       0xFE00L
//DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_OVRD_IN
#define DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_OVRD_IN__LANE_TX2RX_SER_LB__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_OVRD_IN__LANE_RX2TX_PAR_LB__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_OVRD_IN__EN__SHIFT                                                    0x2
#define DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_OVRD_IN__RX_ACJTAG_EN__SHIFT                                          0x3
#define DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_OVRD_IN__RESERVED_15_4__SHIFT                                         0x4
#define DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_OVRD_IN__LANE_TX2RX_SER_LB_MASK                                       0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_OVRD_IN__LANE_RX2TX_PAR_LB_MASK                                       0x0002L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_OVRD_IN__EN_MASK                                                      0x0004L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_OVRD_IN__RX_ACJTAG_EN_MASK                                            0x0008L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_OVRD_IN__RESERVED_15_4_MASK                                           0xFFF0L
//DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__REQ__SHIFT                                                   0x0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__REQ_OVRD_EN__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__PSTATE__SHIFT                                                0x2
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__PSTATE_OVRD_EN__SHIFT                                        0x4
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__RATE__SHIFT                                                  0x5
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__RATE_OVRD_EN__SHIFT                                          0x8
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__WIDTH__SHIFT                                                 0x9
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__WIDTH_OVRD_EN__SHIFT                                         0xb
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__MPLLB_SEL__SHIFT                                             0xc
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__MPLLB_SEL_OVRD_EN__SHIFT                                     0xd
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__DATA_EN__SHIFT                                               0xe
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__DATA_EN_OVRD_EN__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__REQ_MASK                                                     0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__REQ_OVRD_EN_MASK                                             0x0002L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__PSTATE_MASK                                                  0x000CL
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__PSTATE_OVRD_EN_MASK                                          0x0010L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__RATE_MASK                                                    0x00E0L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__RATE_OVRD_EN_MASK                                            0x0100L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__WIDTH_MASK                                                   0x0600L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__WIDTH_OVRD_EN_MASK                                           0x0800L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__MPLLB_SEL_MASK                                               0x1000L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__MPLLB_SEL_OVRD_EN_MASK                                       0x2000L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__DATA_EN_MASK                                                 0x4000L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_0__DATA_EN_OVRD_EN_MASK                                         0x8000L
//DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__NYQUIST_DATA__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__DISABLE__SHIFT                                               0x1
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__BEACON_EN__SHIFT                                             0x2
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__EN__SHIFT                                                    0x3
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__TX_MAIN_CURSOR__SHIFT                                        0x4
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__MAIN_OVRD_EN__SHIFT                                          0xa
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__ASYNC_DRV_EN__SHIFT                                          0xb
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__ASYNC_DRV_OVRD_EN__SHIFT                                     0xc
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__TX_VREGDRV_BYP_OVRD__SHIFT                                   0xd
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__TX_VREGDRV_BYP_OVRD_EN__SHIFT                                0xe
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__RESERVED_15_15__SHIFT                                        0xf
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__NYQUIST_DATA_MASK                                            0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__DISABLE_MASK                                                 0x0002L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__BEACON_EN_MASK                                               0x0004L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__EN_MASK                                                      0x0008L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__TX_MAIN_CURSOR_MASK                                          0x03F0L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__MAIN_OVRD_EN_MASK                                            0x0400L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__ASYNC_DRV_EN_MASK                                            0x0800L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__ASYNC_DRV_OVRD_EN_MASK                                       0x1000L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__TX_VREGDRV_BYP_OVRD_MASK                                     0x2000L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__TX_VREGDRV_BYP_OVRD_EN_MASK                                  0x4000L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_1__RESERVED_15_15_MASK                                          0x8000L
//DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_2
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_2__TX_PRE_CURSOR__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_2__PRE_OVRD_EN__SHIFT                                           0x6
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_2__TX_POST_CURSOR__SHIFT                                        0x7
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_2__POST_OVRD_EN__SHIFT                                          0xd
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_2__HDMIMODE_EN__SHIFT                                           0xe
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_2__HDMIMODE_ENABLE_OVRD_EN__SHIFT                               0xf
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_2__TX_PRE_CURSOR_MASK                                           0x003FL
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_2__PRE_OVRD_EN_MASK                                             0x0040L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_2__TX_POST_CURSOR_MASK                                          0x1F80L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_2__POST_OVRD_EN_MASK                                            0x2000L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_2__HDMIMODE_EN_MASK                                             0x4000L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_2__HDMIMODE_ENABLE_OVRD_EN_MASK                                 0x8000L
//DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__CLK_RDY__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__CLK_RDY_OVRD_EN__SHIFT                                       0x1
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__DETECT_RX_REQ__SHIFT                                         0x2
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__DETECT_RX_REQ_OVRD_EN__SHIFT                                 0x3
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__INVERT__SHIFT                                                0x4
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__INVERT_OVRD_EN__SHIFT                                        0x5
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__LPD__SHIFT                                                   0x6
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__LPD_OVRD_EN__SHIFT                                           0x7
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__TX_DC_COUP_EN__SHIFT                                         0x8
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__TX_DC_COUP_EN_OVRD_EN__SHIFT                                 0x9
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__PMA_EXTENDED_FIFO_EN__SHIFT                                  0xa
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__PMA_EXTENDED_FIFO_EN_OVRD_EN__SHIFT                          0xb
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__TX_MPHY_MODE_EN__SHIFT                                       0xc
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__TX_MPHY_MODE_EN_OVRD_EN__SHIFT                               0xd
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__RESERVED_15_14__SHIFT                                        0xe
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__CLK_RDY_MASK                                                 0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__CLK_RDY_OVRD_EN_MASK                                         0x0002L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__DETECT_RX_REQ_MASK                                           0x0004L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__DETECT_RX_REQ_OVRD_EN_MASK                                   0x0008L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__INVERT_MASK                                                  0x0010L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__INVERT_OVRD_EN_MASK                                          0x0020L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__LPD_MASK                                                     0x0040L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__LPD_OVRD_EN_MASK                                             0x0080L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__TX_DC_COUP_EN_MASK                                           0x0100L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__TX_DC_COUP_EN_OVRD_EN_MASK                                   0x0200L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__PMA_EXTENDED_FIFO_EN_MASK                                    0x0400L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__PMA_EXTENDED_FIFO_EN_OVRD_EN_MASK                            0x0800L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__TX_MPHY_MODE_EN_MASK                                         0x1000L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__TX_MPHY_MODE_EN_OVRD_EN_MASK                                 0x2000L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_3__RESERVED_15_14_MASK                                          0xC000L
//DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_4
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_4__RESET__SHIFT                                                 0x0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_4__RESET_OVRD_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_4__RESET_MASK                                                   0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_4__RESET_OVRD_EN_MASK                                           0x0002L
//DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT__TX_ACK__SHIFT                                                 0x0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT__EN_TX_ACK__SHIFT                                              0x1
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT__DETRX_RESULT__SHIFT                                           0x2
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT__EN_DETRX_RESULT__SHIFT                                        0x3
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT__RESERVED_15_4__SHIFT                                          0x4
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT__TX_ACK_MASK                                                   0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT__EN_TX_ACK_MASK                                                0x0002L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT__DETRX_RESULT_MASK                                             0x0004L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT__EN_DETRX_RESULT_MASK                                          0x0008L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT__RESERVED_15_4_MASK                                            0xFFF0L
//DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__ACK__SHIFT                                                  0x0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__ACK_OVRD_EN__SHIFT                                          0x1
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__ADAPT_STS__SHIFT                                            0x2
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__ADAPT_STS_OVRD_EN__SHIFT                                    0x4
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__RX_ASYNC_DATA__SHIFT                                        0x5
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__RX_ASYNC_DATA_OVRD_EN__SHIFT                                0x6
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__RX_SQ_WEAKKEEP_OUT__SHIFT                                   0x7
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__RX_SQ_WEAKKEEP_OUT_OVRD_EN__SHIFT                           0x8
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__RESERVED_15_9__SHIFT                                        0x9
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__ACK_MASK                                                    0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__ACK_OVRD_EN_MASK                                            0x0002L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__ADAPT_STS_MASK                                              0x000CL
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__ADAPT_STS_OVRD_EN_MASK                                      0x0010L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__RX_ASYNC_DATA_MASK                                          0x0020L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__RX_ASYNC_DATA_OVRD_EN_MASK                                  0x0040L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__RX_SQ_WEAKKEEP_OUT_MASK                                     0x0080L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__RX_SQ_WEAKKEEP_OUT_OVRD_EN_MASK                             0x0100L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_OVRD_OUT_0__RESERVED_15_9_MASK                                          0xFE00L
//DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_ASIC_IN
#define DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_ASIC_IN__LANE_TX2RX_SER_LB__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_ASIC_IN__LANE_RX2TX_PAR_LB__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_ASIC_IN__RESERVED_15_2__SHIFT                                         0x2
#define DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_ASIC_IN__LANE_TX2RX_SER_LB_MASK                                       0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_ASIC_IN__LANE_RX2TX_PAR_LB_MASK                                       0x0002L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_LANE_ASIC_IN__RESERVED_15_2_MASK                                           0xFFFCL
//DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__CLK_RDY__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__RESET__SHIFT                                                 0x1
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__INVERT__SHIFT                                                0x2
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__DATA_EN__SHIFT                                               0x3
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__REQ__SHIFT                                                   0x4
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__LPD__SHIFT                                                   0x5
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__PSTATE__SHIFT                                                0x6
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__RATE__SHIFT                                                  0x8
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__WIDTH__SHIFT                                                 0xb
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__MPLLB_SEL__SHIFT                                             0xd
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__DETECT_RX_REQ__SHIFT                                         0xe
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__DISABLE__SHIFT                                               0xf
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__CLK_RDY_MASK                                                 0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__RESET_MASK                                                   0x0002L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__INVERT_MASK                                                  0x0004L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__DATA_EN_MASK                                                 0x0008L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__REQ_MASK                                                     0x0010L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__LPD_MASK                                                     0x0020L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__PSTATE_MASK                                                  0x00C0L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__RATE_MASK                                                    0x0700L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__WIDTH_MASK                                                   0x1800L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__MPLLB_SEL_MASK                                               0x2000L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__DETECT_RX_REQ_MASK                                           0x4000L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_0__DISABLE_MASK                                                 0x8000L
//DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_1
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_1__BEACON_EN__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_1__TX_MAIN_CURSOR__SHIFT                                        0x1
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_EN__SHIFT                                           0x7
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_DATA__SHIFT                                         0x8
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_DRV_EN__SHIFT                                       0x9
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_1__TX_VREGDRV_BYP__SHIFT                                        0xa
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_1__BEACON_EN_MASK                                               0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_1__TX_MAIN_CURSOR_MASK                                          0x007EL
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_EN_MASK                                             0x0080L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_DATA_MASK                                           0x0100L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_DRV_EN_MASK                                         0x0200L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_1__TX_VREGDRV_BYP_MASK                                          0x0400L
//DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_2
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_2__TX_PRE_CURSOR__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_2__TX_POST_CURSOR__SHIFT                                        0x6
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_2__RESERVED_15_12__SHIFT                                        0xc
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_2__TX_PRE_CURSOR_MASK                                           0x003FL
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_2__TX_POST_CURSOR_MASK                                          0x0FC0L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_IN_2__RESERVED_15_12_MASK                                          0xF000L
//DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_OUT
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_OUT__TX_ACK__SHIFT                                                 0x0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_OUT__DETRX_RESULT__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_OUT__RESERVED_15_2__SHIFT                                          0x2
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_OUT__TX_ACK_MASK                                                   0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_OUT__DETRX_RESULT_MASK                                             0x0002L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_ASIC_OUT__RESERVED_15_2_MASK                                            0xFFFCL
//DPCSSYS_CR0_LANE0_DIG_ASIC_RX_ASIC_OUT_0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_ASIC_OUT_0__ACK__SHIFT                                                  0x0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_ASIC_OUT_0__VALID__SHIFT                                                0x1
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_ASIC_OUT_0__ADAPT_STS__SHIFT                                            0x2
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_ASIC_OUT_0__RESERVED_15_4__SHIFT                                        0x4
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_ASIC_OUT_0__ACK_MASK                                                    0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_ASIC_OUT_0__VALID_MASK                                                  0x0002L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_ASIC_OUT_0__ADAPT_STS_MASK                                              0x000CL
#define DPCSSYS_CR0_LANE0_DIG_ASIC_RX_ASIC_OUT_0__RESERVED_15_4_MASK                                          0xFFF0L
//DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__RPTR_EN_MASTER_LANE__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__RPTR_EN_MASTER_LANE_OVRD_EN__SHIFT                           0x1
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_EN_OTHER_LANE__SHIFT                                 0x2
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_EN_OTHER_LANE_OVRD_EN__SHIFT                         0x3
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_STATE_MASTER_LANE__SHIFT                             0x4
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_STATE_MASTER_LANE_OVRD_EN__SHIFT                     0x5
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__SHIFT_MASTER_LANE__SHIFT                                     0x6
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__SHIFT_MASTER_LANE_ORVD_EN__SHIFT                             0x7
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__SHIFT_ACK_OTHER_LANE__SHIFT                                  0x8
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__SHIFT_ACK_OTHER_LANE_OVRD_EN__SHIFT                          0x9
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__LANE_MASTER__SHIFT                                           0xa
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__LANE_MASTER_OVRD_IN_EN__SHIFT                                0xb
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__TX_DWORD_CLK_SYNC_OVRD__SHIFT                                0xc
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__TX_DWORD_CLK_SYNC_OVRD_EN__SHIFT                             0xd
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__RESERVED_15_14__SHIFT                                        0xe
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__RPTR_EN_MASTER_LANE_MASK                                     0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__RPTR_EN_MASTER_LANE_OVRD_EN_MASK                             0x0002L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_EN_OTHER_LANE_MASK                                   0x0004L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_EN_OTHER_LANE_OVRD_EN_MASK                           0x0008L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_STATE_MASTER_LANE_MASK                               0x0010L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_STATE_MASTER_LANE_OVRD_EN_MASK                       0x0020L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__SHIFT_MASTER_LANE_MASK                                       0x0040L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__SHIFT_MASTER_LANE_ORVD_EN_MASK                               0x0080L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__SHIFT_ACK_OTHER_LANE_MASK                                    0x0100L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__SHIFT_ACK_OTHER_LANE_OVRD_EN_MASK                            0x0200L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__LANE_MASTER_MASK                                             0x0400L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__LANE_MASTER_OVRD_IN_EN_MASK                                  0x0800L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__TX_DWORD_CLK_SYNC_OVRD_MASK                                  0x1000L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__TX_DWORD_CLK_SYNC_OVRD_EN_MASK                               0x2000L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_IN_5__RESERVED_15_14_MASK                                          0xC000L
//DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__RPTR_EN_OUT__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__RPTR_EN_OUT_OVRD_EN__SHIFT                                  0x1
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_EN_OUT__SHIFT                                       0x2
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_EN_OUT_OVRD_EN__SHIFT                               0x3
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_STATE_OUT__SHIFT                                    0x4
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_STATE_OUT_OVRD_EN__SHIFT                            0x5
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_OUT__SHIFT                                            0x6
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_OUT_OVRD_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_ACK_OUT__SHIFT                                        0x8
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_ACK_OUT_OVRD_EN__SHIFT                                0x9
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__RESERVED_15_10__SHIFT                                       0xa
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__RPTR_EN_OUT_MASK                                            0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__RPTR_EN_OUT_OVRD_EN_MASK                                    0x0002L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_EN_OUT_MASK                                         0x0004L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_EN_OUT_OVRD_EN_MASK                                 0x0008L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_STATE_OUT_MASK                                      0x0010L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_STATE_OUT_OVRD_EN_MASK                              0x0020L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_OUT_MASK                                              0x0040L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_OUT_OVRD_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_ACK_OUT_MASK                                          0x0100L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_ACK_OUT_OVRD_EN_MASK                                  0x0200L
#define DPCSSYS_CR0_LANE0_DIG_ASIC_TX_OVRD_OUT_1__RESERVED_15_10_MASK                                         0xFC00L
//DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_REFGEN_EN__SHIFT                              0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_VCM_HOLD__SHIFT                               0x1
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_CLK_EN__SHIFT                                 0x2
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_WORD_CLK_EN__SHIFT                            0x3
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_RESET__SHIFT                                  0x4
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_SERIAL_EN__SHIFT                              0x5
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_DIG_CLK_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_DATA_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ALLOW_RXDET__SHIFT                                0x8
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_DCC_COMP_CAL_EN__SHIFT                        0x9
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__RESERVED_15_10__SHIFT                                   0xa
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_REFGEN_EN_MASK                                0x0001L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_VCM_HOLD_MASK                                 0x0002L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_CLK_EN_MASK                                   0x0004L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_WORD_CLK_EN_MASK                              0x0008L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_RESET_MASK                                    0x0010L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_SERIAL_EN_MASK                                0x0020L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_DIG_CLK_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_DATA_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ALLOW_RXDET_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_DCC_COMP_CAL_EN_MASK                          0x0200L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0__RESERVED_15_10_MASK                                     0xFC00L
//DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_REFGEN_EN__SHIFT                            0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_VCM_HOLD__SHIFT                             0x1
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_CLK_EN__SHIFT                               0x2
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_WORD_CLK_EN__SHIFT                          0x3
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_RESET__SHIFT                                0x4
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_SERIAL_EN__SHIFT                            0x5
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_DIG_CLK_EN__SHIFT                               0x6
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_DATA_EN__SHIFT                                  0x7
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ALLOW_RXDET__SHIFT                              0x8
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_DCC_COMP_CAL_EN__SHIFT                      0x9
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__RESERVED_15_10__SHIFT                                  0xa
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_REFGEN_EN_MASK                              0x0001L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_VCM_HOLD_MASK                               0x0002L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_CLK_EN_MASK                                 0x0004L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_WORD_CLK_EN_MASK                            0x0008L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_RESET_MASK                                  0x0010L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_SERIAL_EN_MASK                              0x0020L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_DIG_CLK_EN_MASK                                 0x0040L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_DATA_EN_MASK                                    0x0080L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ALLOW_RXDET_MASK                                0x0100L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_DCC_COMP_CAL_EN_MASK                        0x0200L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P0S__RESERVED_15_10_MASK                                    0xFC00L
//DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_REFGEN_EN__SHIFT                              0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_VCM_HOLD__SHIFT                               0x1
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_CLK_EN__SHIFT                                 0x2
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_WORD_CLK_EN__SHIFT                            0x3
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_RESET__SHIFT                                  0x4
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_SERIAL_EN__SHIFT                              0x5
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_DIG_CLK_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_DATA_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ALLOW_RXDET__SHIFT                                0x8
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_DCC_COMP_CAL_EN__SHIFT                        0x9
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__RESERVED_15_10__SHIFT                                   0xa
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_REFGEN_EN_MASK                                0x0001L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_VCM_HOLD_MASK                                 0x0002L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_CLK_EN_MASK                                   0x0004L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_WORD_CLK_EN_MASK                              0x0008L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_RESET_MASK                                    0x0010L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_SERIAL_EN_MASK                                0x0020L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_DIG_CLK_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_DATA_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ALLOW_RXDET_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_DCC_COMP_CAL_EN_MASK                          0x0200L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P1__RESERVED_15_10_MASK                                     0xFC00L
//DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_REFGEN_EN__SHIFT                              0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_VCM_HOLD__SHIFT                               0x1
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_CLK_EN__SHIFT                                 0x2
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_WORD_CLK_EN__SHIFT                            0x3
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_RESET__SHIFT                                  0x4
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_SERIAL_EN__SHIFT                              0x5
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_DIG_CLK_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_DATA_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ALLOW_RXDET__SHIFT                                0x8
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ALLOW_VBOOST__SHIFT                               0x9
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_DCC_COMP_CAL_EN__SHIFT                        0xa
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__RESERVED_15_11__SHIFT                                   0xb
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_REFGEN_EN_MASK                                0x0001L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_VCM_HOLD_MASK                                 0x0002L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_CLK_EN_MASK                                   0x0004L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_WORD_CLK_EN_MASK                              0x0008L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_RESET_MASK                                    0x0010L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_SERIAL_EN_MASK                                0x0020L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_DIG_CLK_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_DATA_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ALLOW_RXDET_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ALLOW_VBOOST_MASK                                 0x0200L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_DCC_COMP_CAL_EN_MASK                          0x0400L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PSTATE_P2__RESERVED_15_11_MASK                                     0xF800L
//DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_0__TX_REFGEN_EN_TIME__SHIFT                             0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_0__TX_CLK_EN__SHIFT                                     0x8
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_0__TX_REFGEN_EN_TIME_MASK                               0x00FFL
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_0__TX_CLK_EN_MASK                                       0xFF00L
//DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_1
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_1__TX_VCM_HOLD_TIME_14_0__SHIFT                         0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_1__SKIP_TX_VCM_HOLD_WAIT__SHIFT                         0xf
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_1__TX_VCM_HOLD_TIME_14_0_MASK                           0x7FFFL
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_1__SKIP_TX_VCM_HOLD_WAIT_MASK                           0x8000L
//DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_2
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_2__TX_VBOOST_DIS_TIME_12_0__SHIFT                       0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_2__DTB_SEL__SHIFT                                       0xd
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_2__TX_VBOOST_DIS_TIME_12_0_MASK                         0x1FFFL
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_2__DTB_SEL_MASK                                         0xE000L
//DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_3
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__TX_VCM_HOLD_TIME_17_15__SHIFT                        0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__TX_VBOOST_DIS_TIME_13__SHIFT                         0x3
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__RESERVED_15_4__SHIFT                                 0x4
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__TX_VCM_HOLD_TIME_17_15_MASK                          0x0007L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__TX_VBOOST_DIS_TIME_13_MASK                           0x0008L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__RESERVED_15_4_MASK                                   0xFFF0L
//DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_4
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_4__TX_VCM_HOLD_GS_TIME__SHIFT                           0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_4__SKIP_TX_VCM_HOLD_GS_PULSE__SHIFT                     0xf
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_4__TX_VCM_HOLD_GS_TIME_MASK                             0x7FFFL
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_4__SKIP_TX_VCM_HOLD_GS_PULSE_MASK                       0x8000L
//DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_5
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_RXDET_TIME__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__FAST_TX_RXDET__SHIFT                                 0xa
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_RESET_TIME__SHIFT                                 0xb
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_SERIAL_EN_TIME__SHIFT                             0xd
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__RESERVED_15_15__SHIFT                                0xf
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_RXDET_TIME_MASK                                   0x03FFL
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__FAST_TX_RXDET_MASK                                   0x0400L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_RESET_TIME_MASK                                   0x1800L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_SERIAL_EN_TIME_MASK                               0x6000L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__RESERVED_15_15_MASK                                  0x8000L
//DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_CR_BANK_ADDR
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_CR_BANK_ADDR__ADDR__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_CR_BANK_ADDR__ADDR_MASK                                           0xFFFFL
//DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_CR_BANK_DATA
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_CR_BANK_DATA__DATA__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_CR_BANK_DATA__DATA_MASK                                           0xFFFFL
//DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_CTRL
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_CTRL__CTRL__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_CTRL__RESERVED_15_8__SHIFT                                    0x8
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_CTRL__CTRL_MASK                                               0x00FFL
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_CTRL__RESERVED_15_8_MASK                                      0xFF00L
//DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_RANGE
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_RANGE__CTRL__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_RANGE__RESERVED_15_2__SHIFT                                   0x2
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_RANGE__CTRL_MASK                                              0x0003L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_RANGE__RESERVED_15_2_MASK                                     0xFFFCL
//DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_SEL
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_SEL__SEL__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_SEL__REQ__SHIFT                                               0x3
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_SEL__CTRL_UPD__SHIFT                                          0x4
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_SEL__RANGE_UPD__SHIFT                                         0x5
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_SEL__BIN_HOT__SHIFT                                           0x6
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_SEL__SEL_MASK                                                 0x0007L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_SEL__REQ_MASK                                                 0x0008L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_SEL__CTRL_UPD_MASK                                            0x0010L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_SEL__RANGE_UPD_MASK                                           0x0020L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_SEL__BIN_HOT_MASK                                             0x0040L
//DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_ACK
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_ACK__ACK__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_ACK__RESERVED_15_1__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_ACK__ACK_MASK                                                 0x0001L
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_ACK__RESERVED_15_1_MASK                                       0xFFFEL
//DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_ADDR
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_ADDR__ADDR__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_PWRCTL_DCC_DAC_ADDR__ADDR_MASK                                               0xFFFFL
//DPCSSYS_CR0_LANE0_DIG_TX_CLK_ALIGN_TX_CTL_0
#define DPCSSYS_CR0_LANE0_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_NUM_2UI_SHIFTS_16B_MODE__SHIFT                        0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_NUM_2UI_SHIFTS_20B_MODE__SHIFT                        0x4
#define DPCSSYS_CR0_LANE0_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_FIFO_BYPASS__SHIFT                                    0x8
#define DPCSSYS_CR0_LANE0_DIG_TX_CLK_ALIGN_TX_CTL_0__RESERVED_15_9__SHIFT                                     0x9
#define DPCSSYS_CR0_LANE0_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_NUM_2UI_SHIFTS_16B_MODE_MASK                          0x000FL
#define DPCSSYS_CR0_LANE0_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_NUM_2UI_SHIFTS_20B_MODE_MASK                          0x00F0L
#define DPCSSYS_CR0_LANE0_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_FIFO_BYPASS_MASK                                      0x0100L
#define DPCSSYS_CR0_LANE0_DIG_TX_CLK_ALIGN_TX_CTL_0__RESERVED_15_9_MASK                                       0xFE00L
//DPCSSYS_CR0_LANE0_DIG_TX_LBERT_CTL
#define DPCSSYS_CR0_LANE0_DIG_TX_LBERT_CTL__MODE__SHIFT                                                       0x0
#define DPCSSYS_CR0_LANE0_DIG_TX_LBERT_CTL__TRIGGER_ERR__SHIFT                                                0x4
#define DPCSSYS_CR0_LANE0_DIG_TX_LBERT_CTL__PAT0__SHIFT                                                       0x5
#define DPCSSYS_CR0_LANE0_DIG_TX_LBERT_CTL__RESERVED_15_15__SHIFT                                             0xf
#define DPCSSYS_CR0_LANE0_DIG_TX_LBERT_CTL__MODE_MASK                                                         0x000FL
#define DPCSSYS_CR0_LANE0_DIG_TX_LBERT_CTL__TRIGGER_ERR_MASK                                                  0x0010L
#define DPCSSYS_CR0_LANE0_DIG_TX_LBERT_CTL__PAT0_MASK                                                         0x7FE0L
#define DPCSSYS_CR0_LANE0_DIG_TX_LBERT_CTL__RESERVED_15_15_MASK                                               0x8000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_LD_VAL_1
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_LD_VAL_1__SC1_LD_VAL__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_LD_VAL_1__SC1_START__SHIFT                                              0xf
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_LD_VAL_1__SC1_LD_VAL_MASK                                               0x7FFFL
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_LD_VAL_1__SC1_START_MASK                                                0x8000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_DATA_MSK
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_DATA_MSK__DATA_MSK_15_0__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_DATA_MSK__DATA_MSK_15_0_MASK                                            0xFFFFL
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL0__PTTRN_MSK_CR1A_4_0__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL0__PTTRN_CR1A_4_0__SHIFT                                       0x5
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL0__DATA_MSK_19_16__SHIFT                                       0xa
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL0__SCOPE_DLY__SHIFT                                            0xe
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL0__PTTRN_MSK_CR1A_4_0_MASK                                     0x001FL
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL0__PTTRN_CR1A_4_0_MASK                                         0x03E0L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL0__DATA_MSK_19_16_MASK                                         0x3C00L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL0__SCOPE_DLY_MASK                                              0xC000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL1
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1B_EN__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL1__PTTRN_MSK_CR1B_4_0__SHIFT                                   0x1
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1B_4_0__SHIFT                                       0x6
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1A_ADPT_EN__SHIFT                                   0xb
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL1__RESERVED_15_12__SHIFT                                       0xc
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1B_EN_MASK                                          0x0001L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL1__PTTRN_MSK_CR1B_4_0_MASK                                     0x003EL
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1B_4_0_MASK                                         0x07C0L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1A_ADPT_EN_MASK                                     0x0800L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL1__RESERVED_15_12_MASK                                         0xF000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__RESERVED_0__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__CORR_SHFT_SEL_VGA__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__CORR_SHFT_SEL__SHIFT                                         0x2
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__CORR_SRC_SEL__SHIFT                                          0x3
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__CORR_MODE_EN__SHIFT                                          0x5
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__STAT_SHFT_SEL__SHIFT                                         0x6
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__STAT_SRC_SEL__SHIFT                                          0xa
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__STAT_RXCLK_SEL__SHIFT                                        0xd
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__SC_TIMER_MODE__SHIFT                                         0xe
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__SKIP_EN__SHIFT                                               0xf
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__RESERVED_0_MASK                                              0x0001L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__CORR_SHFT_SEL_VGA_MASK                                       0x0002L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__CORR_SHFT_SEL_MASK                                           0x0004L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__CORR_SRC_SEL_MASK                                            0x0018L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__CORR_MODE_EN_MASK                                            0x0020L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__STAT_SHFT_SEL_MASK                                           0x03C0L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__STAT_SRC_SEL_MASK                                            0x1C00L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__STAT_RXCLK_SEL_MASK                                          0x2000L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__SC_TIMER_MODE_MASK                                           0x4000L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL0__SKIP_EN_MASK                                                 0x8000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__STAT_CNT_0_EN__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__STAT_CNT_1_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__STAT_CNT_2_EN__SHIFT                                         0x2
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__STAT_CNT_3_EN__SHIFT                                         0x3
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__STAT_CNT_4_EN__SHIFT                                         0x4
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__STAT_CNT_5_EN__SHIFT                                         0x5
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__STAT_CNT_6_EN__SHIFT                                         0x6
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__RESERVED_8_7__SHIFT                                          0x7
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__SC_PAUSE__SHIFT                                              0x9
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__STAT_CLK_EN__SHIFT                                           0xa
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__DATA_DLY_SEL__SHIFT                                          0xb
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__VLD_LOSS_CLR__SHIFT                                          0xd
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__VLD_CTL__SHIFT                                               0xe
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__STAT_CNT_0_EN_MASK                                           0x0001L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__STAT_CNT_1_EN_MASK                                           0x0002L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__STAT_CNT_2_EN_MASK                                           0x0004L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__STAT_CNT_3_EN_MASK                                           0x0008L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__STAT_CNT_4_EN_MASK                                           0x0010L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__STAT_CNT_5_EN_MASK                                           0x0020L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__STAT_CNT_6_EN_MASK                                           0x0040L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__RESERVED_8_7_MASK                                            0x0180L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__SC_PAUSE_MASK                                                0x0200L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__STAT_CLK_EN_MASK                                             0x0400L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__DATA_DLY_SEL_MASK                                            0x1800L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__VLD_LOSS_CLR_MASK                                            0x2000L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL1__VLD_CTL_MASK                                                 0xC000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_SMPL_CNT1
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_SMPL_CNT1__SMPL_CNT1__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_SMPL_CNT1__SMPL_CNT1_DONE__SHIFT                                        0xf
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_SMPL_CNT1__SMPL_CNT1_MASK                                               0x7FFFL
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_SMPL_CNT1__SMPL_CNT1_DONE_MASK                                          0x8000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_0__STAT_CNT_0__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_0__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_0__STAT_CNT_0_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_0__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_1
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_1__STAT_CNT_1__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_1__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_1__STAT_CNT_1_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_1__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_2
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_2__STAT_CNT_2__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_2__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_2__STAT_CNT_2_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_2__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_3
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_3__STAT_CNT_3__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_3__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_3__STAT_CNT_3_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_3__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_4
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_4__STAT_CNT_4__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_4__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_4__STAT_CNT_4_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_4__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_5
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_5__STAT_CNT_5__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_5__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_5__STAT_CNT_5_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_5__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_6
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_6__STAT_CNT_6__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_6__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_6__STAT_CNT_6_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CNT_6__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_CAL_COMP_CLK_CTL
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_CAL_COMP_CLK_CTL__PRECHRGE_CNT__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_CAL_COMP_CLK_CTL__REF_DIV_CNT__SHIFT                                    0x3
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_CAL_COMP_CLK_CTL__RESERVED_15_6__SHIFT                                  0x6
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_CAL_COMP_CLK_CTL__PRECHRGE_CNT_MASK                                     0x0007L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_CAL_COMP_CLK_CTL__REF_DIV_CNT_MASK                                      0x0038L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_CAL_COMP_CLK_CTL__RESERVED_15_6_MASK                                    0xFFC0L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL2
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL2__PTTRN_CR1A_19_5__SHIFT                                      0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL2__RESERVED_15_15__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL2__PTTRN_CR1A_19_5_MASK                                        0x7FFFL
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL2__RESERVED_15_15_MASK                                         0x8000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL3
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL3__PTTRN_MSK_CR1A_19_5__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL3__RESERVED_15_15__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL3__PTTRN_MSK_CR1A_19_5_MASK                                    0x7FFFL
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL3__RESERVED_15_15_MASK                                         0x8000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL4
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL4__PTTRN_CR1B_19_5__SHIFT                                      0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL4__RESERVED_15_15__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL4__PTTRN_CR1B_19_5_MASK                                        0x7FFFL
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL4__RESERVED_15_15_MASK                                         0x8000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL5
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL5__PTTRN_MSK_CR1B_19_5__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL5__RESERVED_15_15__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL5__PTTRN_MSK_CR1B_19_5_MASK                                    0x7FFFL
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_MATCH_CTL5__RESERVED_15_15_MASK                                         0x8000L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL2
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL2__DATA_DLY_SEL_2__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL2__SCOPE_DLY_2__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL2__DISABLE_SAMPLE_COUNT__SHIFT                                  0x2
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL2__RESERVED_15_3__SHIFT                                         0x3
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL2__DATA_DLY_SEL_2_MASK                                          0x0001L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL2__SCOPE_DLY_2_MASK                                             0x0002L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL2__DISABLE_SAMPLE_COUNT_MASK                                    0x0004L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_CTL2__RESERVED_15_3_MASK                                           0xFFF8L
//DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_STOP
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_STOP__SC1_STOP__SHIFT                                              0x0
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_STOP__RESERVED_15_1__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_STOP__SC1_STOP_MASK                                                0x0001L
#define DPCSSYS_CR0_LANE0_DIG_RX_STAT_STAT_STOP__RESERVED_15_1_MASK                                           0xFFFEL
//DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_CLK_SHIFT__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_DATA_EN__SHIFT                                          0x1
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_REFGEN_EN__SHIFT                                        0x2
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_VCM_HOLD__SHIFT                                         0x3
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_CLK_EN__SHIFT                                           0x4
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_WORD_CLK_EN__SHIFT                                      0x5
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_MPLLA_CLK_EN__SHIFT                                     0x6
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_MPLLB_CLK_EN__SHIFT                                     0x7
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_RESET__SHIFT                                            0x8
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_SERIAL_EN__SHIFT                                        0x9
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_DATA_RATE__SHIFT                                        0xa
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__RESERVED__SHIFT                                                0xc
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_DIV4_EN__SHIFT                                              0xd
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_RXDET_EN__SHIFT                                             0xe
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_OVRD_EN__SHIFT                                              0xf
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_CLK_SHIFT_MASK                                          0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_DATA_EN_MASK                                            0x0002L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_REFGEN_EN_MASK                                          0x0004L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_VCM_HOLD_MASK                                           0x0008L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_CLK_EN_MASK                                             0x0010L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_WORD_CLK_EN_MASK                                        0x0020L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_MPLLA_CLK_EN_MASK                                       0x0040L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_MPLLB_CLK_EN_MASK                                       0x0080L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_RESET_MASK                                              0x0100L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_SERIAL_EN_MASK                                          0x0200L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_ANA_DATA_RATE_MASK                                          0x0C00L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__RESERVED_MASK                                                  0x1000L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_DIV4_EN_MASK                                                0x2000L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_RXDET_EN_MASK                                               0x4000L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT__TX_OVRD_EN_MASK                                                0x8000L
//DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_OVRD_OUT
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_TERM_CODE__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_TERM_OVRD_EN__SHIFT                               0xa
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_DRV_SRC__SHIFT                                    0xb
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_DRV_SRC_OVRD_EN__SHIFT                            0xd
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_OVRD_OUT__RESERVED_15_14__SHIFT                                0xe
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_TERM_CODE_MASK                                    0x03FFL
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_TERM_OVRD_EN_MASK                                 0x0400L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_DRV_SRC_MASK                                      0x1800L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_DRV_SRC_OVRD_EN_MASK                              0x2000L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_OVRD_OUT__RESERVED_15_14_MASK                                  0xC000L
//DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__TX_TERM_DN_CLK__SHIFT                            0x0
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__TX_TERM_CLK_SELF_CLEAR_DISABLE__SHIFT            0x1
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__RESERVED_15_2__SHIFT                             0x2
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__TX_TERM_DN_CLK_MASK                              0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__TX_TERM_CLK_SELF_CLEAR_DISABLE_MASK              0x0002L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__RESERVED_15_2_MASK                               0xFFFCL
//DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_0
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_ANA_LOAD_CLK__SHIFT                                    0x0
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_ANA_CTRL_LEG_PULL_EN_13_0__SHIFT                       0x1
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_EQ_OVRD_EN__SHIFT                                      0xf
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_ANA_LOAD_CLK_MASK                                      0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_ANA_CTRL_LEG_PULL_EN_13_0_MASK                         0x7FFEL
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_EQ_OVRD_EN_MASK                                        0x8000L
//DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_1
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_1__TX_ANA_CTRL_LEG_PULL_EN_19_14__SHIFT                      0x0
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_1__RESERVED_15_6__SHIFT                                      0x6
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_1__TX_ANA_CTRL_LEG_PULL_EN_19_14_MASK                        0x003FL
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_1__RESERVED_15_6_MASK                                        0xFFC0L
//DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_2
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_2__RESERVED__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_2__TX_ANA_CTRL_EQ_MUX_SEL__SHIFT                             0x3
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_2__TX_ANA_CTRL_PRE__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_2__RESERVED_15_13__SHIFT                                     0xd
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_2__RESERVED_MASK                                             0x0007L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_2__TX_ANA_CTRL_EQ_MUX_SEL_MASK                               0x0078L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_2__TX_ANA_CTRL_PRE_MASK                                      0x1F80L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_2__RESERVED_15_13_MASK                                       0xE000L
//DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_3
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_3__TX_ANA_CTRL_POST__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_3__RESERVED_15_9__SHIFT                                      0x9
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_3__TX_ANA_CTRL_POST_MASK                                     0x01FFL
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_3__RESERVED_15_9_MASK                                        0xFE00L
//DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_4
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_4__TX_ANA_CTRL_LEG_PULL_DIR_19_4__SHIFT                      0x0
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_4__TX_ANA_CTRL_LEG_PULL_DIR_19_4_MASK                        0xFFFFL
//DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_5
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_5__TX_ANA_CTRL_LEG_PULL_DIR_3_0__SHIFT                       0x0
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_5__RESERVED_15_4__SHIFT                                      0x4
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_5__TX_ANA_CTRL_LEG_PULL_DIR_3_0_MASK                         0x000FL
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_EQ_OVRD_OUT_5__RESERVED_15_4_MASK                                        0xFFF0L
//DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__TX_ANA_CLK_SHIFT_ACK__SHIFT                                       0x0
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__TX_ANA_RXDETP_RESULT__SHIFT                                       0x1
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__TX_ANA_RXDETM_RESULT__SHIFT                                       0x2
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__TX_ANA_LOOPBACK_EN__SHIFT                                         0x3
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__TX_ANA_CLK_LB_EN__SHIFT                                           0x4
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__RX_ANA_CAL_RESULT__SHIFT                                          0x5
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__RX_ANA_SCOPE_DATA__SHIFT                                          0x6
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__TX_ANA_DCC_CAL_RESULT__SHIFT                                      0x7
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__TX_ANA_CTRL_EQ_MUX__SHIFT                                         0x8
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__TX_ANA_CLK_SHIFT_ACK_MASK                                         0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__TX_ANA_RXDETP_RESULT_MASK                                         0x0002L
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__TX_ANA_RXDETM_RESULT_MASK                                         0x0004L
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__TX_ANA_LOOPBACK_EN_MASK                                           0x0008L
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__TX_ANA_CLK_LB_EN_MASK                                             0x0010L
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__RX_ANA_CAL_RESULT_MASK                                            0x0020L
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__RX_ANA_SCOPE_DATA_MASK                                            0x0040L
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__TX_ANA_DCC_CAL_RESULT_MASK                                        0x0080L
#define DPCSSYS_CR0_LANE0_DIG_ANA_STATUS_0__TX_ANA_CTRL_EQ_MUX_MASK                                           0xFF00L
//DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_RANGE__SHIFT                            0x0
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_RANGE_OVRD_EN__SHIFT                    0x2
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_COMP_EN__SHIFT                          0x3
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_COMP_EN_OVRD_EN__SHIFT                  0x4
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL__SHIFT                             0x5
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_OVRD_EN__SHIFT                     0xd
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_EN__SHIFT                          0xe
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_EN_OVRD_EN__SHIFT                  0xf
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_RANGE_MASK                              0x0003L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_RANGE_OVRD_EN_MASK                      0x0004L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_COMP_EN_MASK                            0x0008L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_COMP_EN_OVRD_EN_MASK                    0x0010L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_MASK                               0x1FE0L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_OVRD_EN_MASK                       0x2000L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_EN_MASK                            0x4000L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_EN_OVRD_EN_MASK                    0x8000L
//DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CAL_CTRL_SEL__SHIFT                       0x0
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CAL_CTRL_SEL_OVRD_EN__SHIFT               0x3
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CLK_COMP__SHIFT                           0x4
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CLK_COMP_OVRD_EN__SHIFT                   0x5
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CAL_CTRL_SEL_MASK                         0x0007L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CAL_CTRL_SEL_OVRD_EN_MASK                 0x0008L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CLK_COMP_MASK                             0x0010L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CLK_COMP_OVRD_EN_MASK                     0x0020L
//DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT_2
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT_2__TX_ANA_FAST_START__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT_2__TX_ANA_FAST_START_OVRD_EN__SHIFT                             0x1
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT_2__TX_CLK_LB_EN__SHIFT                                          0x2
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT_2__TX_CLK_LB_EN_OVRD_EN__SHIFT                                  0x3
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT_2__TX_ACJTAG_EN__SHIFT                                          0x4
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT_2__RESERVED_15_5__SHIFT                                         0x5
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT_2__TX_ANA_FAST_START_MASK                                       0x0001L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT_2__TX_ANA_FAST_START_OVRD_EN_MASK                               0x0002L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT_2__TX_CLK_LB_EN_MASK                                            0x0004L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT_2__TX_CLK_LB_EN_OVRD_EN_MASK                                    0x0008L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT_2__TX_ACJTAG_EN_MASK                                            0x0010L
#define DPCSSYS_CR0_LANE0_DIG_ANA_TX_OVRD_OUT_2__RESERVED_15_5_MASK                                           0xFFE0L
//DPCSSYS_CR0_LANE0_ANA_TX_OVRD_MEAS
#define DPCSSYS_CR0_LANE0_ANA_TX_OVRD_MEAS__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE0_ANA_TX_OVRD_MEAS__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE0_ANA_TX_PWR_OVRD
#define DPCSSYS_CR0_LANE0_ANA_TX_PWR_OVRD__RESERVED_15_8__SHIFT                                               0x8
#define DPCSSYS_CR0_LANE0_ANA_TX_PWR_OVRD__RESERVED_15_8_MASK                                                 0xFF00L
//DPCSSYS_CR0_LANE0_ANA_TX_ALT_BUS
#define DPCSSYS_CR0_LANE0_ANA_TX_ALT_BUS__RESERVED_15_8__SHIFT                                                0x8
#define DPCSSYS_CR0_LANE0_ANA_TX_ALT_BUS__RESERVED_15_8_MASK                                                  0xFF00L
//DPCSSYS_CR0_LANE0_ANA_TX_ATB1
#define DPCSSYS_CR0_LANE0_ANA_TX_ATB1__RESERVED_15_8__SHIFT                                                   0x8
#define DPCSSYS_CR0_LANE0_ANA_TX_ATB1__RESERVED_15_8_MASK                                                     0xFF00L
//DPCSSYS_CR0_LANE0_ANA_TX_ATB2
#define DPCSSYS_CR0_LANE0_ANA_TX_ATB2__RESERVED_15_8__SHIFT                                                   0x8
#define DPCSSYS_CR0_LANE0_ANA_TX_ATB2__RESERVED_15_8_MASK                                                     0xFF00L
//DPCSSYS_CR0_LANE0_ANA_TX_DCC_DAC
#define DPCSSYS_CR0_LANE0_ANA_TX_DCC_DAC__RESERVED_15_8__SHIFT                                                0x8
#define DPCSSYS_CR0_LANE0_ANA_TX_DCC_DAC__RESERVED_15_8_MASK                                                  0xFF00L
//DPCSSYS_CR0_LANE0_ANA_TX_DCC_CTRL1
#define DPCSSYS_CR0_LANE0_ANA_TX_DCC_CTRL1__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE0_ANA_TX_DCC_CTRL1__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE0_ANA_TX_TERM_CODE
#define DPCSSYS_CR0_LANE0_ANA_TX_TERM_CODE__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE0_ANA_TX_TERM_CODE__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE0_ANA_TX_TERM_CODE_CTRL
#define DPCSSYS_CR0_LANE0_ANA_TX_TERM_CODE_CTRL__RESERVED_15_8__SHIFT                                         0x8
#define DPCSSYS_CR0_LANE0_ANA_TX_TERM_CODE_CTRL__RESERVED_15_8_MASK                                           0xFF00L
//DPCSSYS_CR0_LANE0_ANA_TX_OVRD_CLK
#define DPCSSYS_CR0_LANE0_ANA_TX_OVRD_CLK__RESERVED_15_8__SHIFT                                               0x8
#define DPCSSYS_CR0_LANE0_ANA_TX_OVRD_CLK__RESERVED_15_8_MASK                                                 0xFF00L
//DPCSSYS_CR0_LANE0_ANA_TX_MISC1
#define DPCSSYS_CR0_LANE0_ANA_TX_MISC1__RESERVED_15_8__SHIFT                                                  0x8
#define DPCSSYS_CR0_LANE0_ANA_TX_MISC1__RESERVED_15_8_MASK                                                    0xFF00L
//DPCSSYS_CR0_LANE0_ANA_TX_MISC2
#define DPCSSYS_CR0_LANE0_ANA_TX_MISC2__RESERVED_15_8__SHIFT                                                  0x8
#define DPCSSYS_CR0_LANE0_ANA_TX_MISC2__RESERVED_15_8_MASK                                                    0xFF00L
//DPCSSYS_CR0_LANE0_ANA_TX_RESERVED3
#define DPCSSYS_CR0_LANE0_ANA_TX_RESERVED3__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE0_ANA_TX_RESERVED3__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE0_ANA_TX_RESERVED4
#define DPCSSYS_CR0_LANE0_ANA_TX_RESERVED4__NC7_0__SHIFT                                                      0x0
#define DPCSSYS_CR0_LANE0_ANA_TX_RESERVED4__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE0_ANA_TX_RESERVED4__NC7_0_MASK                                                        0x00FFL
#define DPCSSYS_CR0_LANE0_ANA_TX_RESERVED4__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_OVRD_IN
#define DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_OVRD_IN__LANE_TX2RX_SER_LB__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_OVRD_IN__LANE_RX2TX_PAR_LB__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_OVRD_IN__EN__SHIFT                                                    0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_OVRD_IN__RX_ACJTAG_EN__SHIFT                                          0x3
#define DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_OVRD_IN__RESERVED_15_4__SHIFT                                         0x4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_OVRD_IN__LANE_TX2RX_SER_LB_MASK                                       0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_OVRD_IN__LANE_RX2TX_PAR_LB_MASK                                       0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_OVRD_IN__EN_MASK                                                      0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_OVRD_IN__RX_ACJTAG_EN_MASK                                            0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_OVRD_IN__RESERVED_15_4_MASK                                           0xFFF0L
//DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__REQ__SHIFT                                                   0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__REQ_OVRD_EN__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__PSTATE__SHIFT                                                0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__PSTATE_OVRD_EN__SHIFT                                        0x4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__RATE__SHIFT                                                  0x5
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__RATE_OVRD_EN__SHIFT                                          0x8
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__WIDTH__SHIFT                                                 0x9
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__WIDTH_OVRD_EN__SHIFT                                         0xb
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__MPLLB_SEL__SHIFT                                             0xc
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__MPLLB_SEL_OVRD_EN__SHIFT                                     0xd
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__DATA_EN__SHIFT                                               0xe
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__DATA_EN_OVRD_EN__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__REQ_MASK                                                     0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__REQ_OVRD_EN_MASK                                             0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__PSTATE_MASK                                                  0x000CL
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__PSTATE_OVRD_EN_MASK                                          0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__RATE_MASK                                                    0x00E0L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__RATE_OVRD_EN_MASK                                            0x0100L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__WIDTH_MASK                                                   0x0600L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__WIDTH_OVRD_EN_MASK                                           0x0800L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__MPLLB_SEL_MASK                                               0x1000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__MPLLB_SEL_OVRD_EN_MASK                                       0x2000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__DATA_EN_MASK                                                 0x4000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_0__DATA_EN_OVRD_EN_MASK                                         0x8000L
//DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__NYQUIST_DATA__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__DISABLE__SHIFT                                               0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__BEACON_EN__SHIFT                                             0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__EN__SHIFT                                                    0x3
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__TX_MAIN_CURSOR__SHIFT                                        0x4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__MAIN_OVRD_EN__SHIFT                                          0xa
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__ASYNC_DRV_EN__SHIFT                                          0xb
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__ASYNC_DRV_OVRD_EN__SHIFT                                     0xc
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__TX_VREGDRV_BYP_OVRD__SHIFT                                   0xd
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__TX_VREGDRV_BYP_OVRD_EN__SHIFT                                0xe
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__RESERVED_15_15__SHIFT                                        0xf
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__NYQUIST_DATA_MASK                                            0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__DISABLE_MASK                                                 0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__BEACON_EN_MASK                                               0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__EN_MASK                                                      0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__TX_MAIN_CURSOR_MASK                                          0x03F0L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__MAIN_OVRD_EN_MASK                                            0x0400L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__ASYNC_DRV_EN_MASK                                            0x0800L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__ASYNC_DRV_OVRD_EN_MASK                                       0x1000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__TX_VREGDRV_BYP_OVRD_MASK                                     0x2000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__TX_VREGDRV_BYP_OVRD_EN_MASK                                  0x4000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_1__RESERVED_15_15_MASK                                          0x8000L
//DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_2__TX_PRE_CURSOR__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_2__PRE_OVRD_EN__SHIFT                                           0x6
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_2__TX_POST_CURSOR__SHIFT                                        0x7
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_2__POST_OVRD_EN__SHIFT                                          0xd
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_2__HDMIMODE_EN__SHIFT                                           0xe
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_2__HDMIMODE_ENABLE_OVRD_EN__SHIFT                               0xf
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_2__TX_PRE_CURSOR_MASK                                           0x003FL
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_2__PRE_OVRD_EN_MASK                                             0x0040L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_2__TX_POST_CURSOR_MASK                                          0x1F80L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_2__POST_OVRD_EN_MASK                                            0x2000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_2__HDMIMODE_EN_MASK                                             0x4000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_2__HDMIMODE_ENABLE_OVRD_EN_MASK                                 0x8000L
//DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__CLK_RDY__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__CLK_RDY_OVRD_EN__SHIFT                                       0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__DETECT_RX_REQ__SHIFT                                         0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__DETECT_RX_REQ_OVRD_EN__SHIFT                                 0x3
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__INVERT__SHIFT                                                0x4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__INVERT_OVRD_EN__SHIFT                                        0x5
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__LPD__SHIFT                                                   0x6
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__LPD_OVRD_EN__SHIFT                                           0x7
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__TX_DC_COUP_EN__SHIFT                                         0x8
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__TX_DC_COUP_EN_OVRD_EN__SHIFT                                 0x9
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__PMA_EXTENDED_FIFO_EN__SHIFT                                  0xa
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__PMA_EXTENDED_FIFO_EN_OVRD_EN__SHIFT                          0xb
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__TX_MPHY_MODE_EN__SHIFT                                       0xc
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__TX_MPHY_MODE_EN_OVRD_EN__SHIFT                               0xd
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__RESERVED_15_14__SHIFT                                        0xe
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__CLK_RDY_MASK                                                 0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__CLK_RDY_OVRD_EN_MASK                                         0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__DETECT_RX_REQ_MASK                                           0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__DETECT_RX_REQ_OVRD_EN_MASK                                   0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__INVERT_MASK                                                  0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__INVERT_OVRD_EN_MASK                                          0x0020L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__LPD_MASK                                                     0x0040L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__LPD_OVRD_EN_MASK                                             0x0080L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__TX_DC_COUP_EN_MASK                                           0x0100L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__TX_DC_COUP_EN_OVRD_EN_MASK                                   0x0200L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__PMA_EXTENDED_FIFO_EN_MASK                                    0x0400L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__PMA_EXTENDED_FIFO_EN_OVRD_EN_MASK                            0x0800L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__TX_MPHY_MODE_EN_MASK                                         0x1000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__TX_MPHY_MODE_EN_OVRD_EN_MASK                                 0x2000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_3__RESERVED_15_14_MASK                                          0xC000L
//DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_4__RESET__SHIFT                                                 0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_4__RESET_OVRD_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_4__RESET_MASK                                                   0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_4__RESET_OVRD_EN_MASK                                           0x0002L
//DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT__TX_ACK__SHIFT                                                 0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT__EN_TX_ACK__SHIFT                                              0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT__DETRX_RESULT__SHIFT                                           0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT__EN_DETRX_RESULT__SHIFT                                        0x3
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT__RESERVED_15_4__SHIFT                                          0x4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT__TX_ACK_MASK                                                   0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT__EN_TX_ACK_MASK                                                0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT__DETRX_RESULT_MASK                                             0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT__EN_DETRX_RESULT_MASK                                          0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT__RESERVED_15_4_MASK                                            0xFFF0L
//DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__REQ__SHIFT                                                   0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__REQ_OVRD_EN__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__DATA_EN__SHIFT                                               0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__DATA_EN_OVRD_EN__SHIFT                                       0x3
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__PSTATE__SHIFT                                                0x4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__PSTATE_OVRD_EN__SHIFT                                        0x6
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__RATE__SHIFT                                                  0x7
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__RATE_OVRD_EN__SHIFT                                          0x9
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__WIDTH__SHIFT                                                 0xa
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__WIDTH_OVRD_EN__SHIFT                                         0xc
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__RESERVED_15_13__SHIFT                                        0xd
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__REQ_MASK                                                     0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__REQ_OVRD_EN_MASK                                             0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__DATA_EN_MASK                                                 0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__DATA_EN_OVRD_EN_MASK                                         0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__PSTATE_MASK                                                  0x0030L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__PSTATE_OVRD_EN_MASK                                          0x0040L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__RATE_MASK                                                    0x0180L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__RATE_OVRD_EN_MASK                                            0x0200L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__WIDTH_MASK                                                   0x0C00L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__WIDTH_OVRD_EN_MASK                                           0x1000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_0__RESERVED_15_13_MASK                                          0xE000L
//DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_1__RX_REF_LD_VAL_5_0__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_1__RX_CDR_VCO_LOWFREQ__SHIFT                                    0x6
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_1__EN__SHIFT                                                    0x7
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_1__RX_REF_LD_VAL_6__SHIFT                                       0x8
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_1__RESERVED_15_9__SHIFT                                         0x9
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_1__RX_REF_LD_VAL_5_0_MASK                                       0x003FL
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_1__RX_CDR_VCO_LOWFREQ_MASK                                      0x0040L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_1__EN_MASK                                                      0x0080L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_1__RX_REF_LD_VAL_6_MASK                                         0x0100L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_1__RESERVED_15_9_MASK                                           0xFE00L
//DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_2__RX_VCO_LD_VAL__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_2__EN__SHIFT                                                    0xd
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_2__RESERVED_15_14__SHIFT                                        0xe
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_2__RX_VCO_LD_VAL_MASK                                           0x1FFFL
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_2__EN_MASK                                                      0x2000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_2__RESERVED_15_14_MASK                                          0xC000L
//DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__CDR_TRACK_EN__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__CDR_TRACK_EN_OVRD_EN__SHIFT                                  0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__CDR_SSC_EN__SHIFT                                            0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__CDR_SSC_EN_OVRD_EN__SHIFT                                    0x3
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__ALIGN_EN__SHIFT                                              0x4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__ALIGN_EN_OVRD_EN__SHIFT                                      0x5
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__CLK_SHIFT__SHIFT                                             0x6
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__CLK_SHIFT_OVRD_EN__SHIFT                                     0x7
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__DISABLE__SHIFT                                               0x8
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__DISABLE_OVRD_EN__SHIFT                                       0x9
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__RESERVED_15_10__SHIFT                                        0xa
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__CDR_TRACK_EN_MASK                                            0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__CDR_TRACK_EN_OVRD_EN_MASK                                    0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__CDR_SSC_EN_MASK                                              0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__CDR_SSC_EN_OVRD_EN_MASK                                      0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__ALIGN_EN_MASK                                                0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__ALIGN_EN_OVRD_EN_MASK                                        0x0020L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__CLK_SHIFT_MASK                                               0x0040L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__CLK_SHIFT_OVRD_EN_MASK                                       0x0080L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__DISABLE_MASK                                                 0x0100L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__DISABLE_OVRD_EN_MASK                                         0x0200L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_3__RESERVED_15_10_MASK                                          0xFC00L
//DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__LPD__SHIFT                                                   0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__LPD_OVRD_EN__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__INVERT__SHIFT                                                0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__INVERT_OVRD_EN__SHIFT                                        0x3
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__ADAPT_AFE_EN__SHIFT                                          0x4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__ADAPT_DFE_EN__SHIFT                                          0x5
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__ADPT_OVRD_EN__SHIFT                                          0x6
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__TERM_EN__SHIFT                                               0x7
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__TERM_ACDC__SHIFT                                             0x8
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__TERM_OVRD_EN__SHIFT                                          0x9
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__LPD_MASK                                                     0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__LPD_OVRD_EN_MASK                                             0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__INVERT_MASK                                                  0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__INVERT_OVRD_EN_MASK                                          0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__ADAPT_AFE_EN_MASK                                            0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__ADAPT_DFE_EN_MASK                                            0x0020L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__ADPT_OVRD_EN_MASK                                            0x0040L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__TERM_EN_MASK                                                 0x0080L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__TERM_ACDC_MASK                                               0x0100L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_4__TERM_OVRD_EN_MASK                                            0x0200L
//DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_5
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_5__RESET__SHIFT                                                 0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_5__RESET_OVRD_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_5__RESET_MASK                                                   0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_5__RESET_OVRD_EN_MASK                                           0x0002L
//DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_EQ_IN_0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_EQ_IN_0__EQ_ATT_LVL__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_EQ_IN_0__EQ_AFE_GAIN__SHIFT                                        0x3
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_EQ_IN_0__RESERVED__SHIFT                                           0x7
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_EQ_IN_0__EQ_CTLE_BOOST__SHIFT                                      0xb
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_EQ_IN_0__EQ_ATT_LVL_MASK                                           0x0007L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_EQ_IN_0__EQ_AFE_GAIN_MASK                                          0x0078L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_EQ_IN_0__RESERVED_MASK                                             0x0780L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_EQ_IN_0__EQ_CTLE_BOOST_MASK                                        0xF800L
//DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_EQ_IN_1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_EQ_IN_1__EQ_DFE_TAP2__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_EQ_IN_1__EQ_DFE_TAP1__SHIFT                                        0x7
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_EQ_IN_1__EQ_OVRD_EN__SHIFT                                         0xf
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_EQ_IN_1__EQ_DFE_TAP2_MASK                                          0x007FL
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_EQ_IN_1__EQ_DFE_TAP1_MASK                                          0x7F80L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_EQ_IN_1__EQ_OVRD_EN_MASK                                           0x8000L
//DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__ACK__SHIFT                                                  0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__ACK_OVRD_EN__SHIFT                                          0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__ADAPT_STS__SHIFT                                            0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__ADAPT_STS_OVRD_EN__SHIFT                                    0x4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__RX_ASYNC_DATA__SHIFT                                        0x5
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__RX_ASYNC_DATA_OVRD_EN__SHIFT                                0x6
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__RX_SQ_WEAKKEEP_OUT__SHIFT                                   0x7
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__RX_SQ_WEAKKEEP_OUT_OVRD_EN__SHIFT                           0x8
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__RESERVED_15_9__SHIFT                                        0x9
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__ACK_MASK                                                    0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__ACK_OVRD_EN_MASK                                            0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__ADAPT_STS_MASK                                              0x000CL
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__ADAPT_STS_OVRD_EN_MASK                                      0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__RX_ASYNC_DATA_MASK                                          0x0020L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__RX_ASYNC_DATA_OVRD_EN_MASK                                  0x0040L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__RX_SQ_WEAKKEEP_OUT_MASK                                     0x0080L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__RX_SQ_WEAKKEEP_OUT_OVRD_EN_MASK                             0x0100L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_OUT_0__RESERVED_15_9_MASK                                          0xFE00L
//DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_ASIC_IN
#define DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_ASIC_IN__LANE_TX2RX_SER_LB__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_ASIC_IN__LANE_RX2TX_PAR_LB__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_ASIC_IN__RESERVED_15_2__SHIFT                                         0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_ASIC_IN__LANE_TX2RX_SER_LB_MASK                                       0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_ASIC_IN__LANE_RX2TX_PAR_LB_MASK                                       0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_LANE_ASIC_IN__RESERVED_15_2_MASK                                           0xFFFCL
//DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__CLK_RDY__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__RESET__SHIFT                                                 0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__INVERT__SHIFT                                                0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__DATA_EN__SHIFT                                               0x3
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__REQ__SHIFT                                                   0x4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__LPD__SHIFT                                                   0x5
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__PSTATE__SHIFT                                                0x6
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__RATE__SHIFT                                                  0x8
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__WIDTH__SHIFT                                                 0xb
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__MPLLB_SEL__SHIFT                                             0xd
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__DETECT_RX_REQ__SHIFT                                         0xe
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__DISABLE__SHIFT                                               0xf
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__CLK_RDY_MASK                                                 0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__RESET_MASK                                                   0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__INVERT_MASK                                                  0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__DATA_EN_MASK                                                 0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__REQ_MASK                                                     0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__LPD_MASK                                                     0x0020L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__PSTATE_MASK                                                  0x00C0L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__RATE_MASK                                                    0x0700L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__WIDTH_MASK                                                   0x1800L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__MPLLB_SEL_MASK                                               0x2000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__DETECT_RX_REQ_MASK                                           0x4000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_0__DISABLE_MASK                                                 0x8000L
//DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_1__BEACON_EN__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_1__TX_MAIN_CURSOR__SHIFT                                        0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_EN__SHIFT                                           0x7
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_DATA__SHIFT                                         0x8
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_DRV_EN__SHIFT                                       0x9
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_1__TX_VREGDRV_BYP__SHIFT                                        0xa
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_1__BEACON_EN_MASK                                               0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_1__TX_MAIN_CURSOR_MASK                                          0x007EL
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_EN_MASK                                             0x0080L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_DATA_MASK                                           0x0100L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_DRV_EN_MASK                                         0x0200L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_1__TX_VREGDRV_BYP_MASK                                          0x0400L
//DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_2__TX_PRE_CURSOR__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_2__TX_POST_CURSOR__SHIFT                                        0x6
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_2__RESERVED_15_12__SHIFT                                        0xc
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_2__TX_PRE_CURSOR_MASK                                           0x003FL
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_2__TX_POST_CURSOR_MASK                                          0x0FC0L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_IN_2__RESERVED_15_12_MASK                                          0xF000L
//DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_OUT
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_OUT__TX_ACK__SHIFT                                                 0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_OUT__DETRX_RESULT__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_OUT__RESERVED_15_2__SHIFT                                          0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_OUT__TX_ACK_MASK                                                   0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_OUT__DETRX_RESULT_MASK                                             0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_ASIC_OUT__RESERVED_15_2_MASK                                            0xFFFCL
//DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__RESET__SHIFT                                                 0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__INVERT__SHIFT                                                0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__DATA_EN__SHIFT                                               0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__REQ__SHIFT                                                   0x3
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__LPD__SHIFT                                                   0x4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__PSTATE__SHIFT                                                0x5
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__RATE__SHIFT                                                  0x7
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__WIDTH__SHIFT                                                 0x9
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__RESERVED__SHIFT                                              0xb
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__ADAPT_AFE_EN__SHIFT                                          0xc
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__ADAPT_DFE_EN__SHIFT                                          0xd
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__CDR_TRACK_EN__SHIFT                                          0xe
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__RESERVED_15_15__SHIFT                                        0xf
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__RESET_MASK                                                   0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__INVERT_MASK                                                  0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__DATA_EN_MASK                                                 0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__REQ_MASK                                                     0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__LPD_MASK                                                     0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__PSTATE_MASK                                                  0x0060L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__RATE_MASK                                                    0x0180L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__WIDTH_MASK                                                   0x0600L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__RESERVED_MASK                                                0x0800L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__ADAPT_AFE_EN_MASK                                            0x1000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__ADAPT_DFE_EN_MASK                                            0x2000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__CDR_TRACK_EN_MASK                                            0x4000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_0__RESERVED_15_15_MASK                                          0x8000L
//DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_1__CDR_SSC_EN__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_1__ALIGN_EN__SHIFT                                              0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_1__CLK_SHIFT__SHIFT                                             0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_1__DISABLE__SHIFT                                               0x3
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_1__RX_TERM_EN__SHIFT                                            0x4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_1__RX_TERM_ACDC__SHIFT                                          0x5
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_1__CDR_SSC_EN_MASK                                              0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_1__ALIGN_EN_MASK                                                0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_1__CLK_SHIFT_MASK                                               0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_1__DISABLE_MASK                                                 0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_1__RX_TERM_EN_MASK                                              0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_IN_1__RX_TERM_ACDC_MASK                                            0x0020L
//DPCSSYS_CR0_LANE1_DIG_ASIC_RX_EQ_ASIC_IN_0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_EQ_ASIC_IN_0__EQ_ATT_LVL__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_EQ_ASIC_IN_0__EQ_AFE_GAIN__SHIFT                                        0x3
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_EQ_ASIC_IN_0__RESERVED__SHIFT                                           0x7
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_EQ_ASIC_IN_0__EQ_CTLE_BOOST__SHIFT                                      0xb
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_EQ_ASIC_IN_0__EQ_ATT_LVL_MASK                                           0x0007L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_EQ_ASIC_IN_0__EQ_AFE_GAIN_MASK                                          0x0078L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_EQ_ASIC_IN_0__RESERVED_MASK                                             0x0780L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_EQ_ASIC_IN_0__EQ_CTLE_BOOST_MASK                                        0xF800L
//DPCSSYS_CR0_LANE1_DIG_ASIC_RX_EQ_ASIC_IN_1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_EQ_ASIC_IN_1__EQ_DFE_TAP2__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_EQ_ASIC_IN_1__EQ_DFE_TAP1__SHIFT                                        0x7
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_EQ_ASIC_IN_1__RESERVED_15_15__SHIFT                                     0xf
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_EQ_ASIC_IN_1__EQ_DFE_TAP2_MASK                                          0x007FL
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_EQ_ASIC_IN_1__EQ_DFE_TAP1_MASK                                          0x7F80L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_EQ_ASIC_IN_1__RESERVED_15_15_MASK                                       0x8000L
//DPCSSYS_CR0_LANE1_DIG_ASIC_RX_CDR_VCO_ASIC_IN_0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_CDR_VCO_ASIC_IN_0__RX_CDR_VCO_LOWFREQ__SHIFT                            0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_CDR_VCO_ASIC_IN_0__RX_REF_LD_VAL__SHIFT                                 0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_CDR_VCO_ASIC_IN_0__RESERVED_15_8__SHIFT                                 0x8
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_CDR_VCO_ASIC_IN_0__RX_CDR_VCO_LOWFREQ_MASK                              0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_CDR_VCO_ASIC_IN_0__RX_REF_LD_VAL_MASK                                   0x00FEL
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_CDR_VCO_ASIC_IN_0__RESERVED_15_8_MASK                                   0xFF00L
//DPCSSYS_CR0_LANE1_DIG_ASIC_RX_CDR_VCO_ASIC_IN_1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_CDR_VCO_ASIC_IN_1__RX_VCO_LD_VAL__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_CDR_VCO_ASIC_IN_1__RESERVED_15_13__SHIFT                                0xd
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_CDR_VCO_ASIC_IN_1__RX_VCO_LD_VAL_MASK                                   0x1FFFL
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_CDR_VCO_ASIC_IN_1__RESERVED_15_13_MASK                                  0xE000L
//DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_OUT_0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_OUT_0__ACK__SHIFT                                                  0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_OUT_0__VALID__SHIFT                                                0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_OUT_0__ADAPT_STS__SHIFT                                            0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_OUT_0__RESERVED_15_4__SHIFT                                        0x4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_OUT_0__ACK_MASK                                                    0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_OUT_0__VALID_MASK                                                  0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_OUT_0__ADAPT_STS_MASK                                              0x000CL
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_ASIC_OUT_0__RESERVED_15_4_MASK                                          0xFFF0L
//DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_PWM_CLK_SEL__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_PWM_CLK_SEL_OVRD_EN__SHIFT                                0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_LCC_ON__SHIFT                                        0x3
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_LS_ON__SHIFT                                         0x4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_LS_LCC_ON_OVRD_EN__SHIFT                             0x5
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_CTL__SHIFT                                           0x6
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_CTL_OVRD_EN__SHIFT                                   0x8
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_PWM_EN__SHIFT                                             0x9
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_PWM_EN_OVRD_EN__SHIFT                                     0xa
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RESERVED_15_11__SHIFT                                        0xb
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_PWM_CLK_SEL_MASK                                          0x0003L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_PWM_CLK_SEL_OVRD_EN_MASK                                  0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_LCC_ON_MASK                                          0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_LS_ON_MASK                                           0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_LS_LCC_ON_OVRD_EN_MASK                               0x0020L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_CTL_MASK                                             0x00C0L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_CTL_OVRD_EN_MASK                                     0x0100L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_PWM_EN_MASK                                               0x0200L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RX_PWM_EN_OVRD_EN_MASK                                       0x0400L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_RX_OVRD_IN_6__RESERVED_15_11_MASK                                          0xF800L
//DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__RPTR_EN_MASTER_LANE__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__RPTR_EN_MASTER_LANE_OVRD_EN__SHIFT                           0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_EN_OTHER_LANE__SHIFT                                 0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_EN_OTHER_LANE_OVRD_EN__SHIFT                         0x3
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_STATE_MASTER_LANE__SHIFT                             0x4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_STATE_MASTER_LANE_OVRD_EN__SHIFT                     0x5
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__SHIFT_MASTER_LANE__SHIFT                                     0x6
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__SHIFT_MASTER_LANE_ORVD_EN__SHIFT                             0x7
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__SHIFT_ACK_OTHER_LANE__SHIFT                                  0x8
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__SHIFT_ACK_OTHER_LANE_OVRD_EN__SHIFT                          0x9
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__LANE_MASTER__SHIFT                                           0xa
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__LANE_MASTER_OVRD_IN_EN__SHIFT                                0xb
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__TX_DWORD_CLK_SYNC_OVRD__SHIFT                                0xc
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__TX_DWORD_CLK_SYNC_OVRD_EN__SHIFT                             0xd
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__RESERVED_15_14__SHIFT                                        0xe
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__RPTR_EN_MASTER_LANE_MASK                                     0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__RPTR_EN_MASTER_LANE_OVRD_EN_MASK                             0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_EN_OTHER_LANE_MASK                                   0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_EN_OTHER_LANE_OVRD_EN_MASK                           0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_STATE_MASTER_LANE_MASK                               0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_STATE_MASTER_LANE_OVRD_EN_MASK                       0x0020L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__SHIFT_MASTER_LANE_MASK                                       0x0040L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__SHIFT_MASTER_LANE_ORVD_EN_MASK                               0x0080L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__SHIFT_ACK_OTHER_LANE_MASK                                    0x0100L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__SHIFT_ACK_OTHER_LANE_OVRD_EN_MASK                            0x0200L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__LANE_MASTER_MASK                                             0x0400L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__LANE_MASTER_OVRD_IN_EN_MASK                                  0x0800L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__TX_DWORD_CLK_SYNC_OVRD_MASK                                  0x1000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__TX_DWORD_CLK_SYNC_OVRD_EN_MASK                               0x2000L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_IN_5__RESERVED_15_14_MASK                                          0xC000L
//DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__RPTR_EN_OUT__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__RPTR_EN_OUT_OVRD_EN__SHIFT                                  0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_EN_OUT__SHIFT                                       0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_EN_OUT_OVRD_EN__SHIFT                               0x3
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_STATE_OUT__SHIFT                                    0x4
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_STATE_OUT_OVRD_EN__SHIFT                            0x5
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_OUT__SHIFT                                            0x6
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_OUT_OVRD_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_ACK_OUT__SHIFT                                        0x8
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_ACK_OUT_OVRD_EN__SHIFT                                0x9
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__RESERVED_15_10__SHIFT                                       0xa
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__RPTR_EN_OUT_MASK                                            0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__RPTR_EN_OUT_OVRD_EN_MASK                                    0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_EN_OUT_MASK                                         0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_EN_OUT_OVRD_EN_MASK                                 0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_STATE_OUT_MASK                                      0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_STATE_OUT_OVRD_EN_MASK                              0x0020L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_OUT_MASK                                              0x0040L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_OUT_OVRD_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_ACK_OUT_MASK                                          0x0100L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_ACK_OUT_OVRD_EN_MASK                                  0x0200L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_TX_OVRD_OUT_1__RESERVED_15_10_MASK                                         0xFC00L
//DPCSSYS_CR0_LANE1_DIG_ASIC_OCLA
#define DPCSSYS_CR0_LANE1_DIG_ASIC_OCLA__RX_DWORD_OCLA_CLK_EN__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE1_DIG_ASIC_OCLA__RX_DWORD_OCLA_DATA_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE1_DIG_ASIC_OCLA__RESERVED_15_2__SHIFT                                                 0x2
#define DPCSSYS_CR0_LANE1_DIG_ASIC_OCLA__RX_DWORD_OCLA_CLK_EN_MASK                                            0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_OCLA__RX_DWORD_OCLA_DATA_EN_MASK                                           0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ASIC_OCLA__RESERVED_15_2_MASK                                                   0xFFFCL
//DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_REFGEN_EN__SHIFT                              0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_VCM_HOLD__SHIFT                               0x1
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_CLK_EN__SHIFT                                 0x2
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_WORD_CLK_EN__SHIFT                            0x3
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_RESET__SHIFT                                  0x4
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_SERIAL_EN__SHIFT                              0x5
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_DIG_CLK_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_DATA_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ALLOW_RXDET__SHIFT                                0x8
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_DCC_COMP_CAL_EN__SHIFT                        0x9
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__RESERVED_15_10__SHIFT                                   0xa
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_REFGEN_EN_MASK                                0x0001L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_VCM_HOLD_MASK                                 0x0002L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_CLK_EN_MASK                                   0x0004L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_WORD_CLK_EN_MASK                              0x0008L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_RESET_MASK                                    0x0010L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_SERIAL_EN_MASK                                0x0020L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_DIG_CLK_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_DATA_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ALLOW_RXDET_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_DCC_COMP_CAL_EN_MASK                          0x0200L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0__RESERVED_15_10_MASK                                     0xFC00L
//DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_REFGEN_EN__SHIFT                            0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_VCM_HOLD__SHIFT                             0x1
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_CLK_EN__SHIFT                               0x2
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_WORD_CLK_EN__SHIFT                          0x3
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_RESET__SHIFT                                0x4
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_SERIAL_EN__SHIFT                            0x5
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_DIG_CLK_EN__SHIFT                               0x6
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_DATA_EN__SHIFT                                  0x7
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ALLOW_RXDET__SHIFT                              0x8
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_DCC_COMP_CAL_EN__SHIFT                      0x9
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__RESERVED_15_10__SHIFT                                  0xa
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_REFGEN_EN_MASK                              0x0001L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_VCM_HOLD_MASK                               0x0002L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_CLK_EN_MASK                                 0x0004L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_WORD_CLK_EN_MASK                            0x0008L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_RESET_MASK                                  0x0010L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_SERIAL_EN_MASK                              0x0020L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_DIG_CLK_EN_MASK                                 0x0040L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_DATA_EN_MASK                                    0x0080L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ALLOW_RXDET_MASK                                0x0100L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_DCC_COMP_CAL_EN_MASK                        0x0200L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P0S__RESERVED_15_10_MASK                                    0xFC00L
//DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_REFGEN_EN__SHIFT                              0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_VCM_HOLD__SHIFT                               0x1
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_CLK_EN__SHIFT                                 0x2
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_WORD_CLK_EN__SHIFT                            0x3
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_RESET__SHIFT                                  0x4
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_SERIAL_EN__SHIFT                              0x5
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_DIG_CLK_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_DATA_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ALLOW_RXDET__SHIFT                                0x8
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_DCC_COMP_CAL_EN__SHIFT                        0x9
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__RESERVED_15_10__SHIFT                                   0xa
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_REFGEN_EN_MASK                                0x0001L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_VCM_HOLD_MASK                                 0x0002L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_CLK_EN_MASK                                   0x0004L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_WORD_CLK_EN_MASK                              0x0008L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_RESET_MASK                                    0x0010L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_SERIAL_EN_MASK                                0x0020L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_DIG_CLK_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_DATA_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ALLOW_RXDET_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_DCC_COMP_CAL_EN_MASK                          0x0200L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P1__RESERVED_15_10_MASK                                     0xFC00L
//DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_REFGEN_EN__SHIFT                              0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_VCM_HOLD__SHIFT                               0x1
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_CLK_EN__SHIFT                                 0x2
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_WORD_CLK_EN__SHIFT                            0x3
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_RESET__SHIFT                                  0x4
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_SERIAL_EN__SHIFT                              0x5
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_DIG_CLK_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_DATA_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ALLOW_RXDET__SHIFT                                0x8
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ALLOW_VBOOST__SHIFT                               0x9
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_DCC_COMP_CAL_EN__SHIFT                        0xa
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__RESERVED_15_11__SHIFT                                   0xb
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_REFGEN_EN_MASK                                0x0001L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_VCM_HOLD_MASK                                 0x0002L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_CLK_EN_MASK                                   0x0004L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_WORD_CLK_EN_MASK                              0x0008L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_RESET_MASK                                    0x0010L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_SERIAL_EN_MASK                                0x0020L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_DIG_CLK_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_DATA_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ALLOW_RXDET_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ALLOW_VBOOST_MASK                                 0x0200L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_DCC_COMP_CAL_EN_MASK                          0x0400L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PSTATE_P2__RESERVED_15_11_MASK                                     0xF800L
//DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_0__TX_REFGEN_EN_TIME__SHIFT                             0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_0__TX_CLK_EN__SHIFT                                     0x8
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_0__TX_REFGEN_EN_TIME_MASK                               0x00FFL
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_0__TX_CLK_EN_MASK                                       0xFF00L
//DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_1
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_1__TX_VCM_HOLD_TIME_14_0__SHIFT                         0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_1__SKIP_TX_VCM_HOLD_WAIT__SHIFT                         0xf
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_1__TX_VCM_HOLD_TIME_14_0_MASK                           0x7FFFL
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_1__SKIP_TX_VCM_HOLD_WAIT_MASK                           0x8000L
//DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_2
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_2__TX_VBOOST_DIS_TIME_12_0__SHIFT                       0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_2__DTB_SEL__SHIFT                                       0xd
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_2__TX_VBOOST_DIS_TIME_12_0_MASK                         0x1FFFL
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_2__DTB_SEL_MASK                                         0xE000L
//DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_3
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__TX_VCM_HOLD_TIME_17_15__SHIFT                        0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__TX_VBOOST_DIS_TIME_13__SHIFT                         0x3
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__RESERVED_15_4__SHIFT                                 0x4
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__TX_VCM_HOLD_TIME_17_15_MASK                          0x0007L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__TX_VBOOST_DIS_TIME_13_MASK                           0x0008L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__RESERVED_15_4_MASK                                   0xFFF0L
//DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_4
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_4__TX_VCM_HOLD_GS_TIME__SHIFT                           0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_4__SKIP_TX_VCM_HOLD_GS_PULSE__SHIFT                     0xf
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_4__TX_VCM_HOLD_GS_TIME_MASK                             0x7FFFL
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_4__SKIP_TX_VCM_HOLD_GS_PULSE_MASK                       0x8000L
//DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_5
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_RXDET_TIME__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__FAST_TX_RXDET__SHIFT                                 0xa
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_RESET_TIME__SHIFT                                 0xb
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_SERIAL_EN_TIME__SHIFT                             0xd
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__RESERVED_15_15__SHIFT                                0xf
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_RXDET_TIME_MASK                                   0x03FFL
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__FAST_TX_RXDET_MASK                                   0x0400L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_RESET_TIME_MASK                                   0x1800L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_SERIAL_EN_TIME_MASK                               0x6000L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__RESERVED_15_15_MASK                                  0x8000L
//DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_CR_BANK_ADDR
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_CR_BANK_ADDR__ADDR__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_CR_BANK_ADDR__ADDR_MASK                                           0xFFFFL
//DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_CR_BANK_DATA
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_CR_BANK_DATA__DATA__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_CR_BANK_DATA__DATA_MASK                                           0xFFFFL
//DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_CTRL
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_CTRL__CTRL__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_CTRL__RESERVED_15_8__SHIFT                                    0x8
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_CTRL__CTRL_MASK                                               0x00FFL
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_CTRL__RESERVED_15_8_MASK                                      0xFF00L
//DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_RANGE
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_RANGE__CTRL__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_RANGE__RESERVED_15_2__SHIFT                                   0x2
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_RANGE__CTRL_MASK                                              0x0003L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_RANGE__RESERVED_15_2_MASK                                     0xFFFCL
//DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_SEL
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_SEL__SEL__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_SEL__REQ__SHIFT                                               0x3
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_SEL__CTRL_UPD__SHIFT                                          0x4
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_SEL__RANGE_UPD__SHIFT                                         0x5
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_SEL__BIN_HOT__SHIFT                                           0x6
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_SEL__SEL_MASK                                                 0x0007L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_SEL__REQ_MASK                                                 0x0008L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_SEL__CTRL_UPD_MASK                                            0x0010L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_SEL__RANGE_UPD_MASK                                           0x0020L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_SEL__BIN_HOT_MASK                                             0x0040L
//DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_ACK
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_ACK__ACK__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_ACK__RESERVED_15_1__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_ACK__ACK_MASK                                                 0x0001L
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_ACK__RESERVED_15_1_MASK                                       0xFFFEL
//DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_ADDR
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_ADDR__ADDR__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_PWRCTL_DCC_DAC_ADDR__ADDR_MASK                                               0xFFFFL
//DPCSSYS_CR0_LANE1_DIG_TX_CLK_ALIGN_TX_CTL_0
#define DPCSSYS_CR0_LANE1_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_NUM_2UI_SHIFTS_16B_MODE__SHIFT                        0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_NUM_2UI_SHIFTS_20B_MODE__SHIFT                        0x4
#define DPCSSYS_CR0_LANE1_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_FIFO_BYPASS__SHIFT                                    0x8
#define DPCSSYS_CR0_LANE1_DIG_TX_CLK_ALIGN_TX_CTL_0__RESERVED_15_9__SHIFT                                     0x9
#define DPCSSYS_CR0_LANE1_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_NUM_2UI_SHIFTS_16B_MODE_MASK                          0x000FL
#define DPCSSYS_CR0_LANE1_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_NUM_2UI_SHIFTS_20B_MODE_MASK                          0x00F0L
#define DPCSSYS_CR0_LANE1_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_FIFO_BYPASS_MASK                                      0x0100L
#define DPCSSYS_CR0_LANE1_DIG_TX_CLK_ALIGN_TX_CTL_0__RESERVED_15_9_MASK                                       0xFE00L
//DPCSSYS_CR0_LANE1_DIG_TX_LBERT_CTL
#define DPCSSYS_CR0_LANE1_DIG_TX_LBERT_CTL__MODE__SHIFT                                                       0x0
#define DPCSSYS_CR0_LANE1_DIG_TX_LBERT_CTL__TRIGGER_ERR__SHIFT                                                0x4
#define DPCSSYS_CR0_LANE1_DIG_TX_LBERT_CTL__PAT0__SHIFT                                                       0x5
#define DPCSSYS_CR0_LANE1_DIG_TX_LBERT_CTL__RESERVED_15_15__SHIFT                                             0xf
#define DPCSSYS_CR0_LANE1_DIG_TX_LBERT_CTL__MODE_MASK                                                         0x000FL
#define DPCSSYS_CR0_LANE1_DIG_TX_LBERT_CTL__TRIGGER_ERR_MASK                                                  0x0010L
#define DPCSSYS_CR0_LANE1_DIG_TX_LBERT_CTL__PAT0_MASK                                                         0x7FE0L
#define DPCSSYS_CR0_LANE1_DIG_TX_LBERT_CTL__RESERVED_15_15_MASK                                               0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_AFE_EN__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_CLK_VREG_EN__SHIFT                            0x1
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RESERVED_1__SHIFT                                       0x2
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_CLK_EN__SHIFT                                 0x3
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RESERVED_0__SHIFT                                       0x4
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_DESER_EN__SHIFT                               0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_CDR_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_VCO_FREQ_RST__SHIFT                               0x7
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_VCO_CAL_RST__SHIFT                                0x8
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_VCO_CONTCAL_EN__SHIFT                             0x9
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_DIG_CLK_EN__SHIFT                                 0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RESERVED_15_11__SHIFT                                   0xb
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_AFE_EN_MASK                                   0x0001L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_CLK_VREG_EN_MASK                              0x0002L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RESERVED_1_MASK                                         0x0004L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_CLK_EN_MASK                                   0x0008L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RESERVED_0_MASK                                         0x0010L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_DESER_EN_MASK                                 0x0020L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_CDR_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_VCO_FREQ_RST_MASK                                 0x0080L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_VCO_CAL_RST_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_VCO_CONTCAL_EN_MASK                               0x0200L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_DIG_CLK_EN_MASK                                   0x0400L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0__RESERVED_15_11_MASK                                     0xF800L
//DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_AFE_EN__SHIFT                               0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_CLK_VREG_EN__SHIFT                          0x1
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RESERVED_2__SHIFT                                      0x2
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_CLK_EN__SHIFT                               0x3
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RESERVED_4__SHIFT                                      0x4
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_DESER_EN__SHIFT                             0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_CDR_EN__SHIFT                               0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_VCO_FREQ_RST__SHIFT                             0x7
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_VCO_CAL_RST__SHIFT                              0x8
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_VCO_CONTCAL_EN__SHIFT                           0x9
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_DIG_CLK_EN__SHIFT                               0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RESERVED_15_11__SHIFT                                  0xb
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_AFE_EN_MASK                                 0x0001L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_CLK_VREG_EN_MASK                            0x0002L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RESERVED_2_MASK                                        0x0004L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_CLK_EN_MASK                                 0x0008L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RESERVED_4_MASK                                        0x0010L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_DESER_EN_MASK                               0x0020L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_CDR_EN_MASK                                 0x0040L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_VCO_FREQ_RST_MASK                               0x0080L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_VCO_CAL_RST_MASK                                0x0100L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_VCO_CONTCAL_EN_MASK                             0x0200L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_DIG_CLK_EN_MASK                                 0x0400L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P0S__RESERVED_15_11_MASK                                    0xF800L
//DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_AFE_EN__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_CLK_VREG_EN__SHIFT                            0x1
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RESERVED_2__SHIFT                                       0x2
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_CLK_EN__SHIFT                                 0x3
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RESERVED_4__SHIFT                                       0x4
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_DESER_EN__SHIFT                               0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_CDR_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_VCO_FREQ_RST__SHIFT                               0x7
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_VCO_CAL_RST__SHIFT                                0x8
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_VCO_CONTCAL_EN__SHIFT                             0x9
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_DIG_CLK_EN__SHIFT                                 0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RESERVED_15_11__SHIFT                                   0xb
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_AFE_EN_MASK                                   0x0001L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_CLK_VREG_EN_MASK                              0x0002L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RESERVED_2_MASK                                         0x0004L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_CLK_EN_MASK                                   0x0008L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RESERVED_4_MASK                                         0x0010L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_DESER_EN_MASK                                 0x0020L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_CDR_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_VCO_FREQ_RST_MASK                                 0x0080L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_VCO_CAL_RST_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_VCO_CONTCAL_EN_MASK                               0x0200L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_DIG_CLK_EN_MASK                                   0x0400L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P1__RESERVED_15_11_MASK                                     0xF800L
//DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_AFE_EN__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_CLK_VREG_EN__SHIFT                            0x1
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RESERVED_2__SHIFT                                       0x2
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_CLK_EN__SHIFT                                 0x3
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RESERVED_4__SHIFT                                       0x4
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_DESER_EN__SHIFT                               0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_CDR_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_VCO_FREQ_RST__SHIFT                               0x7
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_VCO_CAL_RST__SHIFT                                0x8
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_VCO_CONTCAL_EN__SHIFT                             0x9
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_DIG_CLK_EN__SHIFT                                 0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RESERVED_15_11__SHIFT                                   0xb
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_AFE_EN_MASK                                   0x0001L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_CLK_VREG_EN_MASK                              0x0002L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RESERVED_2_MASK                                         0x0004L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_CLK_EN_MASK                                   0x0008L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RESERVED_4_MASK                                         0x0010L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_DESER_EN_MASK                                 0x0020L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_CDR_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_VCO_FREQ_RST_MASK                                 0x0080L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_VCO_CAL_RST_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_VCO_CONTCAL_EN_MASK                               0x0200L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_DIG_CLK_EN_MASK                                   0x0400L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PSTATE_P2__RESERVED_15_11_MASK                                     0xF800L
//DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_1
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__RX_AFE_EN_TIME__SHIFT                                0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__FAST_RX_AFE_EN__SHIFT                                0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__RX_VREG_EN_TIME__SHIFT                               0x7
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__FAST_RX_VREG_EN__SHIFT                               0xd
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__RESERVED_15_14__SHIFT                                0xe
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__RX_AFE_EN_TIME_MASK                                  0x003FL
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__FAST_RX_AFE_EN_MASK                                  0x0040L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__RX_VREG_EN_TIME_MASK                                 0x1F80L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__FAST_RX_VREG_EN_MASK                                 0x2000L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__RESERVED_15_14_MASK                                  0xC000L
//DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_2
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_2__RX_CLK_EN_TIME__SHIFT                                0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_2__FAST_RX_CLK_EN__SHIFT                                0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_2__RX_FAST_START_TIME__SHIFT                            0x7
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_2__RESERVED_15_11__SHIFT                                0xb
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_2__RX_CLK_EN_TIME_MASK                                  0x003FL
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_2__FAST_RX_CLK_EN_MASK                                  0x0040L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_2__RX_FAST_START_TIME_MASK                              0x0780L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_2__RESERVED_15_11_MASK                                  0xF800L
//DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_3
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RX_RATE_TIME__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RSVD_3_7_2__SHIFT                                    0x2
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RX_CDR_EN_TIME__SHIFT                                0x8
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RX_DESER_EN_TIME__SHIFT                              0xc
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RX_DESER_DIS_TIME__SHIFT                             0xe
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RX_RATE_TIME_MASK                                    0x0003L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RSVD_3_7_2_MASK                                      0x00FCL
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RX_CDR_EN_TIME_MASK                                  0x0F00L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RX_DESER_EN_TIME_MASK                                0x3000L
#define DPCSSYS_CR0_LANE1_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RX_DESER_DIS_TIME_MASK                               0xC000L
//DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__INT_GAIN_CAL_FIXED_CNT__SHIFT                      0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__INT_GAIN_CAL_FIXED_CNT_EN__SHIFT                   0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__INT_GAIN_CAL_CNT_SHIFT__SHIFT                      0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__INT_GAIN_CAL_BOUNCE_CNT__SHIFT                     0x9
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__DISABLE_BIN_HOLD__SHIFT                            0xc
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__DISABLE_INT_GAIN_HOLD__SHIFT                       0xd
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__DISABLE_COARSE_CALDONE__SHIFT                      0xe
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__RESERVED_15_15__SHIFT                              0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__INT_GAIN_CAL_FIXED_CNT_MASK                        0x001FL
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__INT_GAIN_CAL_FIXED_CNT_EN_MASK                     0x0020L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__INT_GAIN_CAL_CNT_SHIFT_MASK                        0x01C0L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__INT_GAIN_CAL_BOUNCE_CNT_MASK                       0x0E00L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__DISABLE_BIN_HOLD_MASK                              0x1000L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__DISABLE_INT_GAIN_HOLD_MASK                         0x2000L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__DISABLE_COARSE_CALDONE_MASK                        0x4000L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__RESERVED_15_15_MASK                                0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__RX_VCO_OVRD_SEL__SHIFT                             0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__RX_VCO_FREQ_RST__SHIFT                             0x1
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__RX_VCO_CAL_RST__SHIFT                              0x2
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__RX_VCO_CONTCAL_EN__SHIFT                           0x3
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__DISABLE_INT_CAL_MODE__SHIFT                        0x4
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__DPLL_CAL_UG__SHIFT                                 0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__DTB_SEL__SHIFT                                     0x9
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__RX_VCO_OVRD_SEL_MASK                               0x0001L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__RX_VCO_FREQ_RST_MASK                               0x0002L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__RX_VCO_CAL_RST_MASK                                0x0004L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__RX_VCO_CONTCAL_EN_MASK                             0x0008L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__DISABLE_INT_CAL_MODE_MASK                          0x0010L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__DPLL_CAL_UG_MASK                                   0x01E0L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__DTB_SEL_MASK                                       0xFE00L
//DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2__FREQ_TUNE_START_VAL__SHIFT                         0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2__FREQ_TUNE_CAL_STEPS__SHIFT                         0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2__SKIP_RX_VCO_FREQ_TUNE_CAL__SHIFT                   0xe
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2__SKIP_RX_VCO_CAL__SHIFT                             0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2__FREQ_TUNE_START_VAL_MASK                           0x03FFL
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2__FREQ_TUNE_CAL_STEPS_MASK                           0x3C00L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2__SKIP_RX_VCO_FREQ_TUNE_CAL_MASK                     0x4000L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2__SKIP_RX_VCO_CAL_MASK                               0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0__RX_VCO_STARTUP_TIME__SHIFT                         0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0__RX_VCO_UPDATE_TIME__SHIFT                          0x7
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0__RX_VCO_CNTR_PWRUP_TIME__SHIFT                      0xb
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0__FAST_RX_VCO_WAIT__SHIFT                            0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0__RX_VCO_STARTUP_TIME_MASK                           0x007FL
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0__RX_VCO_UPDATE_TIME_MASK                            0x0780L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0__RX_VCO_CNTR_PWRUP_TIME_MASK                        0x7800L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0__FAST_RX_VCO_WAIT_MASK                              0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_1
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_1__RX_VCO_CNTR_SETTLE_TIME__SHIFT                     0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_1__RESERVED_15_3__SHIFT                               0x3
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_1__RX_VCO_CNTR_SETTLE_TIME_MASK                       0x0007L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_1__RESERVED_15_3_MASK                                 0xFFF8L
//DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_0
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_CDR_FREQ_TUNE__SHIFT                            0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_VCO_CNTR_PD__SHIFT                              0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_VCO_CNTR_EN__SHIFT                              0xb
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_CDR_STARTUP__SHIFT                              0xc
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_CDR_VCO_EN__SHIFT                               0xd
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_0__RESERVED_15_14__SHIFT                                  0xe
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_CDR_FREQ_TUNE_MASK                              0x03FFL
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_VCO_CNTR_PD_MASK                                0x0400L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_VCO_CNTR_EN_MASK                                0x0800L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_CDR_STARTUP_MASK                                0x1000L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_CDR_VCO_EN_MASK                                 0x2000L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_0__RESERVED_15_14_MASK                                    0xC000L
//DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_1
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_FSM_STATE__SHIFT                                0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_FREQ_RST__SHIFT                                 0x4
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_CAL_RST__SHIFT                                  0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_CONTCAL_EN__SHIFT                               0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_CAL_DONE__SHIFT                                 0x7
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_1__DPLL_FREQ_RST__SHIFT                                   0x8
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_1__RESERVED_15_9__SHIFT                                   0x9
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_FSM_STATE_MASK                                  0x000FL
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_FREQ_RST_MASK                                   0x0010L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_CAL_RST_MASK                                    0x0020L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_CONTCAL_EN_MASK                                 0x0040L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_CAL_DONE_MASK                                   0x0080L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_1__DPLL_FREQ_RST_MASK                                     0x0100L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_1__RESERVED_15_9_MASK                                     0xFE00L
//DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_2
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_2__VCO_CNTR_FINAL__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_2__VCOCLK_TOO_FAST__SHIFT                                 0xd
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_2__RX_VCO_CORRECT__SHIFT                                  0xe
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_2__RX_VCO_UP__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_2__VCO_CNTR_FINAL_MASK                                    0x1FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_2__VCOCLK_TOO_FAST_MASK                                   0x2000L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_2__RX_VCO_CORRECT_MASK                                    0x4000L
#define DPCSSYS_CR0_LANE1_DIG_RX_VCOCAL_RX_VCO_STAT_2__RX_VCO_UP_MASK                                         0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_RX_ALIGN_XAUI_COMM_MASK
#define DPCSSYS_CR0_LANE1_DIG_RX_RX_ALIGN_XAUI_COMM_MASK__XAUI_COMM_MASK__SHIFT                               0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_RX_ALIGN_XAUI_COMM_MASK__RESERVED_15_10__SHIFT                               0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_RX_ALIGN_XAUI_COMM_MASK__XAUI_COMM_MASK_MASK                                 0x03FFL
#define DPCSSYS_CR0_LANE1_DIG_RX_RX_ALIGN_XAUI_COMM_MASK__RESERVED_15_10_MASK                                 0xFC00L
//DPCSSYS_CR0_LANE1_DIG_RX_LBERT_CTL
#define DPCSSYS_CR0_LANE1_DIG_RX_LBERT_CTL__MODE__SHIFT                                                       0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_LBERT_CTL__SYNC__SHIFT                                                       0x4
#define DPCSSYS_CR0_LANE1_DIG_RX_LBERT_CTL__RESERVED_15_5__SHIFT                                              0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_LBERT_CTL__MODE_MASK                                                         0x000FL
#define DPCSSYS_CR0_LANE1_DIG_RX_LBERT_CTL__SYNC_MASK                                                         0x0010L
#define DPCSSYS_CR0_LANE1_DIG_RX_LBERT_CTL__RESERVED_15_5_MASK                                                0xFFE0L
//DPCSSYS_CR0_LANE1_DIG_RX_LBERT_ERR
#define DPCSSYS_CR0_LANE1_DIG_RX_LBERT_ERR__COUNT__SHIFT                                                      0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_LBERT_ERR__OV14__SHIFT                                                       0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_LBERT_ERR__COUNT_MASK                                                        0x7FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_LBERT_ERR__OV14_MASK                                                         0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_0
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_0__PHDET_EN__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_0__PHDET_EDGE__SHIFT                                             0x2
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_0__PHDET_POL__SHIFT                                              0x4
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_0__PHDET_EN_PR_MODE__SHIFT                                       0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_0__ALWAYS_REALIGN__SHIFT                                         0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_0__DTB_SEL__SHIFT                                                0x7
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_0__RESERVED_15_11__SHIFT                                         0xb
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_0__PHDET_EN_MASK                                                 0x0003L
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_0__PHDET_EDGE_MASK                                               0x000CL
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_0__PHDET_POL_MASK                                                0x0010L
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_0__PHDET_EN_PR_MODE_MASK                                         0x0020L
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_0__ALWAYS_REALIGN_MASK                                           0x0040L
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_0__DTB_SEL_MASK                                                  0x0780L
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_0__RESERVED_15_11_MASK                                           0xF800L
//DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_1
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_1__SSC_OFF_CNT0__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_1__SSC_OFF_CNT1__SHIFT                                           0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_1__SSC_OFF_CNT0_MASK                                             0x03FFL
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_1__SSC_OFF_CNT1_MASK                                             0xFC00L
//DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_2
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_2__SSC_ON_CNT0__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_2__SSC_ON_CNT1__SHIFT                                            0x9
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_2__SSC_ON_CNT0_MASK                                              0x01FFL
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_2__SSC_ON_CNT1_MASK                                              0xFE00L
//DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_3
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_3__SSC_OFF_PHUG0__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_3__SSC_OFF_PHUG1__SHIFT                                          0x3
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_3__SSC_OFF_FRUG0__SHIFT                                          0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_3__OVRD_DPLL_GAIN__SHIFT                                         0x9
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_3__PHUG_OVRD_VALUE__SHIFT                                        0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_3__FRUG_OVRD_VALUE__SHIFT                                        0xd
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_3__SSC_OFF_PHUG0_MASK                                            0x0007L
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_3__SSC_OFF_PHUG1_MASK                                            0x0038L
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_3__SSC_OFF_FRUG0_MASK                                            0x01C0L
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_3__OVRD_DPLL_GAIN_MASK                                           0x0200L
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_3__PHUG_OVRD_VALUE_MASK                                          0x1C00L
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_3__FRUG_OVRD_VALUE_MASK                                          0xE000L
//DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_4
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_4__SSC_OFF_FRUG1__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_4__SSC_ON_FRUG0__SHIFT                                           0x3
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_4__SSC_ON_FRUG1__SHIFT                                           0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_4__SSC_ON_PHUG0__SHIFT                                           0x9
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_4__SSC_ON_PHUG1__SHIFT                                           0xc
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_4__RESERVED_15_15__SHIFT                                         0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_4__SSC_OFF_FRUG1_MASK                                            0x0007L
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_4__SSC_ON_FRUG0_MASK                                             0x0038L
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_4__SSC_ON_FRUG1_MASK                                             0x01C0L
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_4__SSC_ON_PHUG0_MASK                                             0x0E00L
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_4__SSC_ON_PHUG1_MASK                                             0x7000L
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_CDR_CTL_4__RESERVED_15_15_MASK                                           0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_CDR_STAT
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_STAT__PHUG_VALUE__SHIFT                                                  0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_STAT__FRUG_VALUE__SHIFT                                                  0x3
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_STAT__RESERVED_15_6__SHIFT                                               0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_STAT__PHUG_VALUE_MASK                                                    0x0007L
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_STAT__FRUG_VALUE_MASK                                                    0x0038L
#define DPCSSYS_CR0_LANE1_DIG_RX_CDR_STAT__RESERVED_15_6_MASK                                                 0xFFC0L
//DPCSSYS_CR0_LANE1_DIG_RX_DPLL_FREQ
#define DPCSSYS_CR0_LANE1_DIG_RX_DPLL_FREQ__VAL__SHIFT                                                        0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_DPLL_FREQ__RESERVED_15_14__SHIFT                                             0xe
#define DPCSSYS_CR0_LANE1_DIG_RX_DPLL_FREQ__VAL_MASK                                                          0x3FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_DPLL_FREQ__RESERVED_15_14_MASK                                               0xC000L
//DPCSSYS_CR0_LANE1_DIG_RX_DPLL_FREQ_BOUND_0
#define DPCSSYS_CR0_LANE1_DIG_RX_DPLL_FREQ_BOUND_0__FREQ_BOUND_EN__SHIFT                                      0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_DPLL_FREQ_BOUND_0__UPPER_FREQ_BOUND__SHIFT                                   0x1
#define DPCSSYS_CR0_LANE1_DIG_RX_DPLL_FREQ_BOUND_0__RESERVED_15_11__SHIFT                                     0xb
#define DPCSSYS_CR0_LANE1_DIG_RX_DPLL_FREQ_BOUND_0__FREQ_BOUND_EN_MASK                                        0x0001L
#define DPCSSYS_CR0_LANE1_DIG_RX_DPLL_FREQ_BOUND_0__UPPER_FREQ_BOUND_MASK                                     0x07FEL
#define DPCSSYS_CR0_LANE1_DIG_RX_DPLL_FREQ_BOUND_0__RESERVED_15_11_MASK                                       0xF800L
//DPCSSYS_CR0_LANE1_DIG_RX_DPLL_FREQ_BOUND_1
#define DPCSSYS_CR0_LANE1_DIG_RX_DPLL_FREQ_BOUND_1__LOWER_FREQ_BOUND__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_DPLL_FREQ_BOUND_1__RESERVED_15_10__SHIFT                                     0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_DPLL_FREQ_BOUND_1__LOWER_FREQ_BOUND_MASK                                     0x03FFL
#define DPCSSYS_CR0_LANE1_DIG_RX_DPLL_FREQ_BOUND_1__RESERVED_15_10_MASK                                       0xFC00L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_0__N_TOP_ASM1__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_0__N_TGG_ASM1__SHIFT                                        0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_0__START_ASM1__SHIFT                                        0xe
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_0__ADPT_CLK_DIV4_EN__SHIFT                                  0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_0__N_TOP_ASM1_MASK                                          0x03FFL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_0__N_TGG_ASM1_MASK                                          0x3C00L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_0__START_ASM1_MASK                                          0x4000L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_0__ADPT_CLK_DIV4_EN_MASK                                    0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_1
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_1__N_WAIT_ASM1__SHIFT                                       0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_1__FAST_AFE_DFE_SETTLE__SHIFT                               0x7
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_1__CTLE_POLE_OVRD_VAL__SHIFT                                0x8
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_1__CTLE_POLE_OVRD_EN__SHIFT                                 0xb
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_1__RESERVED_15_12__SHIFT                                    0xc
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_1__N_WAIT_ASM1_MASK                                         0x007FL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_1__FAST_AFE_DFE_SETTLE_MASK                                 0x0080L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_1__CTLE_POLE_OVRD_VAL_MASK                                  0x0700L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_1__CTLE_POLE_OVRD_EN_MASK                                   0x0800L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_1__RESERVED_15_12_MASK                                      0xF000L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_2
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_2__TGG_PTTRN_0__SHIFT                                       0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_2__TGG_PTTRN_1__SHIFT                                       0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_2__TGG_PTTRN_0_MASK                                         0x001FL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_2__TGG_PTTRN_1_MASK                                         0x03E0L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_3
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_3__CTLE_EN__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_3__VGA_EN__SHIFT                                            0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_3__ATT_EN__SHIFT                                            0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_3__DFE_EN__SHIFT                                            0x7
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_3__EYEHE_EN__SHIFT                                          0xc
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_3__EYEHO_EN__SHIFT                                          0xd
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_3__TGG_EN__SHIFT                                            0xe
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_3__ESL_TWICE_DSL__SHIFT                                     0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_3__CTLE_EN_MASK                                             0x001FL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_3__VGA_EN_MASK                                              0x0020L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_3__ATT_EN_MASK                                              0x0040L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_3__DFE_EN_MASK                                              0x0F80L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_3__EYEHE_EN_MASK                                            0x1000L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_3__EYEHO_EN_MASK                                            0x2000L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_3__TGG_EN_MASK                                              0x4000L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_3__ESL_TWICE_DSL_MASK                                       0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_4
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_4__CTLE_TH__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_4__VGA_TH__SHIFT                                            0x4
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_4__DFE1_TH__SHIFT                                           0x8
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_4__DFE2_TH__SHIFT                                           0xc
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_4__CTLE_TH_MASK                                             0x000FL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_4__VGA_TH_MASK                                              0x00F0L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_4__DFE1_TH_MASK                                             0x0F00L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_4__DFE2_TH_MASK                                             0xF000L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_5
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_5__DFE3_TH__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_5__DFE4_TH__SHIFT                                           0x4
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_5__DFE5_TH__SHIFT                                           0x8
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_5__TH_OFFSET__SHIFT                                         0xc
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_5__DFE3_TH_MASK                                             0x000FL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_5__DFE4_TH_MASK                                             0x00F0L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_5__DFE5_TH_MASK                                             0x0F00L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_5__TH_OFFSET_MASK                                           0xF000L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_6
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_6__CTLE_MU__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_6__VGA_MU__SHIFT                                            0x3
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_6__ATT_MU__SHIFT                                            0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_6__VGA_SAT_CNT__SHIFT                                       0x9
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_6__VGA_SAT_CNT_STICKY__SHIFT                                0xc
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_6__ATT_LOW_TH__SHIFT                                        0xd
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_6__CTLE_MU_MASK                                             0x0007L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_6__VGA_MU_MASK                                              0x0038L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_6__ATT_MU_MASK                                              0x01C0L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_6__VGA_SAT_CNT_MASK                                         0x0E00L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_6__VGA_SAT_CNT_STICKY_MASK                                  0x1000L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_6__ATT_LOW_TH_MASK                                          0xE000L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_7
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_7__VGA_MIN_SAT__SHIFT                                       0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_7__VGA_LEV_HIGH__SHIFT                                      0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_7__VGA_LEV_LOW__SHIFT                                       0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_7__RESERVED_15_15__SHIFT                                    0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_7__VGA_MIN_SAT_MASK                                         0x001FL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_7__VGA_LEV_HIGH_MASK                                        0x03E0L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_7__VGA_LEV_LOW_MASK                                         0x7C00L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_7__RESERVED_15_15_MASK                                      0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_8
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE1_MU__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE2_MU__SHIFT                                           0x3
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE3_MU__SHIFT                                           0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE4_MU__SHIFT                                           0x9
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE5_MU__SHIFT                                           0xc
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_8__RESERVED_15_15__SHIFT                                    0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE1_MU_MASK                                             0x0007L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE2_MU_MASK                                             0x0038L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE3_MU_MASK                                             0x01C0L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE4_MU_MASK                                             0x0E00L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE5_MU_MASK                                             0x7000L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_8__RESERVED_15_15_MASK                                      0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_9
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_9__ERR_SLE_ADPT_INIT__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_9__ERR_SLO_ADPT_INIT__SHIFT                                 0x8
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_9__ERR_SLE_ADPT_INIT_MASK                                   0x00FFL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_CFG_9__ERR_SLO_ADPT_INIT_MASK                                   0xFF00L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RST_ADPT_CFG
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_ATT__SHIFT                                    0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_VGA__SHIFT                                    0x1
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_CTLE_BOOST__SHIFT                             0x2
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_CTLE_POLE__SHIFT                              0x3
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_TAP1__SHIFT                                   0x4
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_ATT_MASK                                      0x0001L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_VGA_MASK                                      0x0002L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_CTLE_BOOST_MASK                               0x0004L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_CTLE_POLE_MASK                                0x0008L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_TAP1_MASK                                     0x0010L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ATT_STATUS
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ATT_STATUS__ATT_ADPT_CODE__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ATT_STATUS__ASM1_DON__SHIFT                                          0x8
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ATT_STATUS__RESERVED_15_9__SHIFT                                     0x9
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ATT_STATUS__ATT_ADPT_CODE_MASK                                       0x00FFL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ATT_STATUS__ASM1_DON_MASK                                            0x0100L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ATT_STATUS__RESERVED_15_9_MASK                                       0xFE00L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_VGA_STATUS
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_VGA_STATUS__VGA_ADPT_CODE__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_VGA_STATUS__ASM1_DONE__SHIFT                                         0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_VGA_STATUS__RESERVED_15_11__SHIFT                                    0xb
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_VGA_STATUS__VGA_ADPT_CODE_MASK                                       0x03FFL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_VGA_STATUS__ASM1_DONE_MASK                                           0x0400L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_VGA_STATUS__RESERVED_15_11_MASK                                      0xF800L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_CTLE_STATUS
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_CTLE_STATUS__CTLE_BOOST_ADPT_CODE__SHIFT                             0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_CTLE_STATUS__CTLE_POLE_ADPT_CODE__SHIFT                              0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_CTLE_STATUS__ASM1_DONE__SHIFT                                        0xd
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_CTLE_STATUS__RESERVED_15_14__SHIFT                                   0xe
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_CTLE_STATUS__CTLE_BOOST_ADPT_CODE_MASK                               0x03FFL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_CTLE_STATUS__CTLE_POLE_ADPT_CODE_MASK                                0x1C00L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_CTLE_STATUS__ASM1_DONE_MASK                                          0x2000L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_CTLE_STATUS__RESERVED_15_14_MASK                                     0xC000L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_TAP1_STATUS
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_TAP1_STATUS__DFE_TAP1_ADPT_CODE__SHIFT                           0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_TAP1_STATUS__ASM1_DONE__SHIFT                                    0xd
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_TAP1_STATUS__RESERVED_15_14__SHIFT                               0xe
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_TAP1_STATUS__DFE_TAP1_ADPT_CODE_MASK                             0x1FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_TAP1_STATUS__ASM1_DONE_MASK                                      0x2000L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_TAP1_STATUS__RESERVED_15_14_MASK                                 0xC000L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_TAP2_STATUS
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_TAP2_STATUS__DFE_TAP2_ADPT_CODE__SHIFT                           0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_TAP2_STATUS__ASM1_DONE__SHIFT                                    0xc
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_TAP2_STATUS__RESERVED_15_13__SHIFT                               0xd
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_TAP2_STATUS__DFE_TAP2_ADPT_CODE_MASK                             0x0FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_TAP2_STATUS__ASM1_DONE_MASK                                      0x1000L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_TAP2_STATUS__RESERVED_15_13_MASK                                 0xE000L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_DATA_EVEN_VDAC_OFST
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_DATA_EVEN_VDAC_OFST__DFE_DATA_EVEN_VDAC_OFST__SHIFT              0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_DATA_EVEN_VDAC_OFST__RESERVED_15_8__SHIFT                        0x8
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_DATA_EVEN_VDAC_OFST__DFE_DATA_EVEN_VDAC_OFST_MASK                0x00FFL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_DATA_EVEN_VDAC_OFST__RESERVED_15_8_MASK                          0xFF00L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_DATA_ODD_VDAC_OFST
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_DATA_ODD_VDAC_OFST__DFE_DATA_ODD_VDAC_OFST__SHIFT                0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_DATA_ODD_VDAC_OFST__RESERVED_15_8__SHIFT                         0x8
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_DATA_ODD_VDAC_OFST__DFE_DATA_ODD_VDAC_OFST_MASK                  0x00FFL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_DATA_ODD_VDAC_OFST__RESERVED_15_8_MASK                           0xFF00L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RX_SLICER_CTRL_EVEN
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RX_SLICER_CTRL_EVEN__RX_ANA_SLICER_CTRL_E__SHIFT                     0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RX_SLICER_CTRL_EVEN__RESERVED_15_4__SHIFT                            0x4
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RX_SLICER_CTRL_EVEN__RX_ANA_SLICER_CTRL_E_MASK                       0x000FL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RX_SLICER_CTRL_EVEN__RESERVED_15_4_MASK                              0xFFF0L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RX_SLICER_CTRL_ODD
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RX_SLICER_CTRL_ODD__RX_ANA_SLICER_CTRL_O__SHIFT                      0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RX_SLICER_CTRL_ODD__RESERVED_15_4__SHIFT                             0x4
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RX_SLICER_CTRL_ODD__RX_ANA_SLICER_CTRL_O_MASK                        0x000FL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_RX_SLICER_CTRL_ODD__RESERVED_15_4_MASK                               0xFFF0L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_ERROR_EVEN_VDAC_OFST
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_ERROR_EVEN_VDAC_OFST__DFE_ERROR_EVEN_VDAC_OFST__SHIFT            0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_ERROR_EVEN_VDAC_OFST__RESERVED_15_8__SHIFT                       0x8
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_ERROR_EVEN_VDAC_OFST__DFE_ERROR_EVEN_VDAC_OFST_MASK              0x00FFL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_ERROR_EVEN_VDAC_OFST__RESERVED_15_8_MASK                         0xFF00L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_ERROR_ODD_VDAC_OFST
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_ERROR_ODD_VDAC_OFST__DFE_ERROR_ODD_VDAC_OFST__SHIFT              0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_ERROR_ODD_VDAC_OFST__RESERVED_15_8__SHIFT                        0x8
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_ERROR_ODD_VDAC_OFST__DFE_ERROR_ODD_VDAC_OFST_MASK                0x00FFL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DFE_ERROR_ODD_VDAC_OFST__RESERVED_15_8_MASK                          0xFF00L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ERROR_SLICER_LEVEL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ERROR_SLICER_LEVEL__E_SLO_LVL__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ERROR_SLICER_LEVEL__E_SLE_LVL__SHIFT                                 0x8
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ERROR_SLICER_LEVEL__E_SLO_LVL_MASK                                   0x00FFL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ERROR_SLICER_LEVEL__E_SLE_LVL_MASK                                   0xFF00L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_RESET
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_RESET__RESET_ASM1__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_RESET__RESERVED_15_1__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_RESET__RESET_ASM1_MASK                                          0x0001L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_ADPT_RESET__RESERVED_15_1_MASK                                       0xFFFEL
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1__DFE_T1_IDAC__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1__DFE_T2_IDAC__SHIFT                                   0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1__DCC_START_IDAC__SHIFT                                0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1__RESERVED_15_15__SHIFT                                0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1__DFE_T1_IDAC_MASK                                     0x001FL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1__DFE_T2_IDAC_MASK                                     0x03E0L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1__DCC_START_IDAC_MASK                                  0x7C00L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1__RESERVED_15_15_MASK                                  0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_2
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_2__DFE_DAT_EVEN_VDAC__SHIFT                             0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_2__DFE_DAT_ODD_VDAC__SHIFT                              0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_2__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_2__DFE_DAT_EVEN_VDAC_MASK                               0x001FL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_2__DFE_DAT_ODD_VDAC_MASK                                0x03E0L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_2__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_3
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_3__DFE_ERR_EVEN_VDAC__SHIFT                             0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_3__DFE_ERR_ODD_VDAC__SHIFT                              0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_3__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_3__DFE_ERR_EVEN_VDAC_MASK                               0x001FL
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_3__DFE_ERR_ODD_VDAC_MASK                                0x03E0L
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_DAC_CTRL_SEL_3__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_CR_BANK_ADDR
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_CR_BANK_ADDR__ADDR__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_CR_BANK_ADDR__ADDR_MASK                                              0xFFFFL
//DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_CR_BANK_DATA
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_CR_BANK_DATA__DATA__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_ADPTCTL_CR_BANK_DATA__DATA_MASK                                              0xFFFFL
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_LD_VAL_1
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_LD_VAL_1__SC1_LD_VAL__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_LD_VAL_1__SC1_START__SHIFT                                              0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_LD_VAL_1__SC1_LD_VAL_MASK                                               0x7FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_LD_VAL_1__SC1_START_MASK                                                0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_DATA_MSK
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_DATA_MSK__DATA_MSK_15_0__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_DATA_MSK__DATA_MSK_15_0_MASK                                            0xFFFFL
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL0__PTTRN_MSK_CR1A_4_0__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL0__PTTRN_CR1A_4_0__SHIFT                                       0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL0__DATA_MSK_19_16__SHIFT                                       0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL0__SCOPE_DLY__SHIFT                                            0xe
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL0__PTTRN_MSK_CR1A_4_0_MASK                                     0x001FL
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL0__PTTRN_CR1A_4_0_MASK                                         0x03E0L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL0__DATA_MSK_19_16_MASK                                         0x3C00L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL0__SCOPE_DLY_MASK                                              0xC000L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL1
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1B_EN__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL1__PTTRN_MSK_CR1B_4_0__SHIFT                                   0x1
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1B_4_0__SHIFT                                       0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1A_ADPT_EN__SHIFT                                   0xb
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL1__RESERVED_15_12__SHIFT                                       0xc
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1B_EN_MASK                                          0x0001L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL1__PTTRN_MSK_CR1B_4_0_MASK                                     0x003EL
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1B_4_0_MASK                                         0x07C0L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1A_ADPT_EN_MASK                                     0x0800L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL1__RESERVED_15_12_MASK                                         0xF000L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__RESERVED_0__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__CORR_SHFT_SEL_VGA__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__CORR_SHFT_SEL__SHIFT                                         0x2
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__CORR_SRC_SEL__SHIFT                                          0x3
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__CORR_MODE_EN__SHIFT                                          0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__STAT_SHFT_SEL__SHIFT                                         0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__STAT_SRC_SEL__SHIFT                                          0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__STAT_RXCLK_SEL__SHIFT                                        0xd
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__SC_TIMER_MODE__SHIFT                                         0xe
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__SKIP_EN__SHIFT                                               0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__RESERVED_0_MASK                                              0x0001L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__CORR_SHFT_SEL_VGA_MASK                                       0x0002L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__CORR_SHFT_SEL_MASK                                           0x0004L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__CORR_SRC_SEL_MASK                                            0x0018L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__CORR_MODE_EN_MASK                                            0x0020L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__STAT_SHFT_SEL_MASK                                           0x03C0L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__STAT_SRC_SEL_MASK                                            0x1C00L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__STAT_RXCLK_SEL_MASK                                          0x2000L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__SC_TIMER_MODE_MASK                                           0x4000L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL0__SKIP_EN_MASK                                                 0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__STAT_CNT_0_EN__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__STAT_CNT_1_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__STAT_CNT_2_EN__SHIFT                                         0x2
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__STAT_CNT_3_EN__SHIFT                                         0x3
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__STAT_CNT_4_EN__SHIFT                                         0x4
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__STAT_CNT_5_EN__SHIFT                                         0x5
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__STAT_CNT_6_EN__SHIFT                                         0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__RESERVED_8_7__SHIFT                                          0x7
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__SC_PAUSE__SHIFT                                              0x9
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__STAT_CLK_EN__SHIFT                                           0xa
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__DATA_DLY_SEL__SHIFT                                          0xb
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__VLD_LOSS_CLR__SHIFT                                          0xd
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__VLD_CTL__SHIFT                                               0xe
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__STAT_CNT_0_EN_MASK                                           0x0001L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__STAT_CNT_1_EN_MASK                                           0x0002L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__STAT_CNT_2_EN_MASK                                           0x0004L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__STAT_CNT_3_EN_MASK                                           0x0008L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__STAT_CNT_4_EN_MASK                                           0x0010L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__STAT_CNT_5_EN_MASK                                           0x0020L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__STAT_CNT_6_EN_MASK                                           0x0040L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__RESERVED_8_7_MASK                                            0x0180L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__SC_PAUSE_MASK                                                0x0200L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__STAT_CLK_EN_MASK                                             0x0400L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__DATA_DLY_SEL_MASK                                            0x1800L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__VLD_LOSS_CLR_MASK                                            0x2000L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL1__VLD_CTL_MASK                                                 0xC000L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_SMPL_CNT1
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_SMPL_CNT1__SMPL_CNT1__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_SMPL_CNT1__SMPL_CNT1_DONE__SHIFT                                        0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_SMPL_CNT1__SMPL_CNT1_MASK                                               0x7FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_SMPL_CNT1__SMPL_CNT1_DONE_MASK                                          0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_0__STAT_CNT_0__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_0__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_0__STAT_CNT_0_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_0__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_1
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_1__STAT_CNT_1__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_1__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_1__STAT_CNT_1_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_1__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_2
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_2__STAT_CNT_2__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_2__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_2__STAT_CNT_2_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_2__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_3
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_3__STAT_CNT_3__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_3__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_3__STAT_CNT_3_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_3__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_4
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_4__STAT_CNT_4__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_4__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_4__STAT_CNT_4_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_4__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_5
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_5__STAT_CNT_5__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_5__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_5__STAT_CNT_5_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_5__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_6
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_6__STAT_CNT_6__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_6__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_6__STAT_CNT_6_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CNT_6__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_CAL_COMP_CLK_CTL
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_CAL_COMP_CLK_CTL__PRECHRGE_CNT__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_CAL_COMP_CLK_CTL__REF_DIV_CNT__SHIFT                                    0x3
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_CAL_COMP_CLK_CTL__RESERVED_15_6__SHIFT                                  0x6
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_CAL_COMP_CLK_CTL__PRECHRGE_CNT_MASK                                     0x0007L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_CAL_COMP_CLK_CTL__REF_DIV_CNT_MASK                                      0x0038L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_CAL_COMP_CLK_CTL__RESERVED_15_6_MASK                                    0xFFC0L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL2
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL2__PTTRN_CR1A_19_5__SHIFT                                      0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL2__RESERVED_15_15__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL2__PTTRN_CR1A_19_5_MASK                                        0x7FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL2__RESERVED_15_15_MASK                                         0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL3
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL3__PTTRN_MSK_CR1A_19_5__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL3__RESERVED_15_15__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL3__PTTRN_MSK_CR1A_19_5_MASK                                    0x7FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL3__RESERVED_15_15_MASK                                         0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL4
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL4__PTTRN_CR1B_19_5__SHIFT                                      0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL4__RESERVED_15_15__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL4__PTTRN_CR1B_19_5_MASK                                        0x7FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL4__RESERVED_15_15_MASK                                         0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL5
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL5__PTTRN_MSK_CR1B_19_5__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL5__RESERVED_15_15__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL5__PTTRN_MSK_CR1B_19_5_MASK                                    0x7FFFL
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_MATCH_CTL5__RESERVED_15_15_MASK                                         0x8000L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL2
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL2__DATA_DLY_SEL_2__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL2__SCOPE_DLY_2__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL2__DISABLE_SAMPLE_COUNT__SHIFT                                  0x2
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL2__RESERVED_15_3__SHIFT                                         0x3
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL2__DATA_DLY_SEL_2_MASK                                          0x0001L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL2__SCOPE_DLY_2_MASK                                             0x0002L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL2__DISABLE_SAMPLE_COUNT_MASK                                    0x0004L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_CTL2__RESERVED_15_3_MASK                                           0xFFF8L
//DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_STOP
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_STOP__SC1_STOP__SHIFT                                              0x0
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_STOP__RESERVED_15_1__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_STOP__SC1_STOP_MASK                                                0x0001L
#define DPCSSYS_CR0_LANE1_DIG_RX_STAT_STAT_STOP__RESERVED_15_1_MASK                                           0xFFFEL
//DPCSSYS_CR0_LANE1_DIG_MPHY_RX_PWM_CTL
#define DPCSSYS_CR0_LANE1_DIG_MPHY_RX_PWM_CTL__RX_PWM_POL__SHIFT                                              0x0
#define DPCSSYS_CR0_LANE1_DIG_MPHY_RX_PWM_CTL__RX_PWM_DATA_POL__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE1_DIG_MPHY_RX_PWM_CTL__RESERVED_15_2__SHIFT                                           0x2
#define DPCSSYS_CR0_LANE1_DIG_MPHY_RX_PWM_CTL__RX_PWM_POL_MASK                                                0x0001L
#define DPCSSYS_CR0_LANE1_DIG_MPHY_RX_PWM_CTL__RX_PWM_DATA_POL_MASK                                           0x0002L
#define DPCSSYS_CR0_LANE1_DIG_MPHY_RX_PWM_CTL__RESERVED_15_2_MASK                                             0xFFFCL
//DPCSSYS_CR0_LANE1_DIG_MPHY_RX_TERM_LS_CTL
#define DPCSSYS_CR0_LANE1_DIG_MPHY_RX_TERM_LS_CTL__RX_TERM_LCC_CNT__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE1_DIG_MPHY_RX_TERM_LS_CTL__RESERVED_15_3__SHIFT                                       0x3
#define DPCSSYS_CR0_LANE1_DIG_MPHY_RX_TERM_LS_CTL__RX_TERM_LCC_CNT_MASK                                       0x0007L
#define DPCSSYS_CR0_LANE1_DIG_MPHY_RX_TERM_LS_CTL__RESERVED_15_3_MASK                                         0xFFF8L
//DPCSSYS_CR0_LANE1_DIG_MPHY_RX_ANA_PWM_CLK_STABLE_CNT
#define DPCSSYS_CR0_LANE1_DIG_MPHY_RX_ANA_PWM_CLK_STABLE_CNT__PWM_CLK_STABLE_CNT__SHIFT                       0x0
#define DPCSSYS_CR0_LANE1_DIG_MPHY_RX_ANA_PWM_CLK_STABLE_CNT__RESERVED_15_4__SHIFT                            0x4
#define DPCSSYS_CR0_LANE1_DIG_MPHY_RX_ANA_PWM_CLK_STABLE_CNT__PWM_CLK_STABLE_CNT_MASK                         0x000FL
#define DPCSSYS_CR0_LANE1_DIG_MPHY_RX_ANA_PWM_CLK_STABLE_CNT__RESERVED_15_4_MASK                              0xFFF0L
//DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_CLK_SHIFT__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_DATA_EN__SHIFT                                          0x1
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_REFGEN_EN__SHIFT                                        0x2
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_VCM_HOLD__SHIFT                                         0x3
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_CLK_EN__SHIFT                                           0x4
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_WORD_CLK_EN__SHIFT                                      0x5
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_MPLLA_CLK_EN__SHIFT                                     0x6
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_MPLLB_CLK_EN__SHIFT                                     0x7
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_RESET__SHIFT                                            0x8
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_SERIAL_EN__SHIFT                                        0x9
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_DATA_RATE__SHIFT                                        0xa
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__RESERVED__SHIFT                                                0xc
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_DIV4_EN__SHIFT                                              0xd
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_RXDET_EN__SHIFT                                             0xe
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_OVRD_EN__SHIFT                                              0xf
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_CLK_SHIFT_MASK                                          0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_DATA_EN_MASK                                            0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_REFGEN_EN_MASK                                          0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_VCM_HOLD_MASK                                           0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_CLK_EN_MASK                                             0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_WORD_CLK_EN_MASK                                        0x0020L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_MPLLA_CLK_EN_MASK                                       0x0040L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_MPLLB_CLK_EN_MASK                                       0x0080L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_RESET_MASK                                              0x0100L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_SERIAL_EN_MASK                                          0x0200L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_ANA_DATA_RATE_MASK                                          0x0C00L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__RESERVED_MASK                                                  0x1000L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_DIV4_EN_MASK                                                0x2000L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_RXDET_EN_MASK                                               0x4000L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT__TX_OVRD_EN_MASK                                                0x8000L
//DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_OVRD_OUT
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_TERM_CODE__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_TERM_OVRD_EN__SHIFT                               0xa
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_DRV_SRC__SHIFT                                    0xb
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_DRV_SRC_OVRD_EN__SHIFT                            0xd
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_OVRD_OUT__RESERVED_15_14__SHIFT                                0xe
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_TERM_CODE_MASK                                    0x03FFL
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_TERM_OVRD_EN_MASK                                 0x0400L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_DRV_SRC_MASK                                      0x1800L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_DRV_SRC_OVRD_EN_MASK                              0x2000L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_OVRD_OUT__RESERVED_15_14_MASK                                  0xC000L
//DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__TX_TERM_DN_CLK__SHIFT                            0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__TX_TERM_CLK_SELF_CLEAR_DISABLE__SHIFT            0x1
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__RESERVED_15_2__SHIFT                             0x2
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__TX_TERM_DN_CLK_MASK                              0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__TX_TERM_CLK_SELF_CLEAR_DISABLE_MASK              0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__RESERVED_15_2_MASK                               0xFFFCL
//DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_0
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_ANA_LOAD_CLK__SHIFT                                    0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_ANA_CTRL_LEG_PULL_EN_13_0__SHIFT                       0x1
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_EQ_OVRD_EN__SHIFT                                      0xf
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_ANA_LOAD_CLK_MASK                                      0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_ANA_CTRL_LEG_PULL_EN_13_0_MASK                         0x7FFEL
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_EQ_OVRD_EN_MASK                                        0x8000L
//DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_1
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_1__TX_ANA_CTRL_LEG_PULL_EN_19_14__SHIFT                      0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_1__RESERVED_15_6__SHIFT                                      0x6
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_1__TX_ANA_CTRL_LEG_PULL_EN_19_14_MASK                        0x003FL
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_1__RESERVED_15_6_MASK                                        0xFFC0L
//DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_2
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_2__RESERVED__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_2__TX_ANA_CTRL_EQ_MUX_SEL__SHIFT                             0x3
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_2__TX_ANA_CTRL_PRE__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_2__RESERVED_15_13__SHIFT                                     0xd
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_2__RESERVED_MASK                                             0x0007L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_2__TX_ANA_CTRL_EQ_MUX_SEL_MASK                               0x0078L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_2__TX_ANA_CTRL_PRE_MASK                                      0x1F80L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_2__RESERVED_15_13_MASK                                       0xE000L
//DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_3
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_3__TX_ANA_CTRL_POST__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_3__RESERVED_15_9__SHIFT                                      0x9
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_3__TX_ANA_CTRL_POST_MASK                                     0x01FFL
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_3__RESERVED_15_9_MASK                                        0xFE00L
//DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_4
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_4__TX_ANA_CTRL_LEG_PULL_DIR_19_4__SHIFT                      0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_4__TX_ANA_CTRL_LEG_PULL_DIR_19_4_MASK                        0xFFFFL
//DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_5
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_5__TX_ANA_CTRL_LEG_PULL_DIR_3_0__SHIFT                       0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_5__RESERVED_15_4__SHIFT                                      0x4
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_5__TX_ANA_CTRL_LEG_PULL_DIR_3_0_MASK                         0x000FL
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_EQ_OVRD_OUT_5__RESERVED_15_4_MASK                                        0xFFF0L
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RESERVED__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_DATA_RATE__SHIFT                                    0x1
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_WORD_CLK_EN__SHIFT                                  0x3
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_DIV4_EN__SHIFT                                      0x4
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_DFE_TAPS_EN__SHIFT                                  0x5
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_ADAPTATION_EN__SHIFT                                0x6
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RX_LBK_CLK_EN__SHIFT                                       0x7
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RX_CTL_OVRD_EN__SHIFT                                      0x8
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RESERVED_15_9__SHIFT                                       0x9
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RESERVED_MASK                                              0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_DATA_RATE_MASK                                      0x0006L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_WORD_CLK_EN_MASK                                    0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_DIV4_EN_MASK                                        0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_DFE_TAPS_EN_MASK                                    0x0020L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_ADAPTATION_EN_MASK                                  0x0040L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RX_LBK_CLK_EN_MASK                                         0x0080L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RX_CTL_OVRD_EN_MASK                                        0x0100L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CTL_OVRD_OUT__RESERVED_15_9_MASK                                         0xFE00L
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_AFE_EN__SHIFT                                       0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_CLK_VREG_EN__SHIFT                                  0x1
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_CLK_DCC_EN__SHIFT                                   0x2
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_CLK_EN__SHIFT                                       0x3
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_CDR_EN__SHIFT                                       0x4
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_DESERIAL_EN__SHIFT                                  0x5
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RX_PWR_OVRD_EN__SHIFT                                      0x6
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_FAST_START__SHIFT                                   0x7
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RESERVED_15_8__SHIFT                                       0x8
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_AFE_EN_MASK                                         0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_CLK_VREG_EN_MASK                                    0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_CLK_DCC_EN_MASK                                     0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_CLK_EN_MASK                                         0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_CDR_EN_MASK                                         0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_DESERIAL_EN_MASK                                    0x0020L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RX_PWR_OVRD_EN_MASK                                        0x0040L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_FAST_START_MASK                                     0x0080L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_PWR_OVRD_OUT__RESERVED_15_8_MASK                                         0xFF00L
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_CDR_VCO_EN__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_CDR_STARTUP__SHIFT                                0x1
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_VCO_CDR_OVRD_EN__SHIFT                                0x2
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_CDR_FREQ_TUNE__SHIFT                              0x3
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_VCO_CNTR_EN__SHIFT                                0xd
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_VCO_CNTR_CLK__SHIFT                               0xe
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_CDR_FREQ_TUNE_OVRD_EN__SHIFT                          0xf
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_CDR_VCO_EN_MASK                                   0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_CDR_STARTUP_MASK                                  0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_VCO_CDR_OVRD_EN_MASK                                  0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_CDR_FREQ_TUNE_MASK                                0x1FF8L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_VCO_CNTR_EN_MASK                                  0x2000L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_VCO_CNTR_CLK_MASK                                 0x4000L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_CDR_FREQ_TUNE_OVRD_EN_MASK                            0x8000L
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_1
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_1__RX_ANA_CDR_VCO_LOWFREQ__SHIFT                            0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_1__RX_ANA_VCO_CNTR_PD__SHIFT                                0x1
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_1__RESERVED_15_2__SHIFT                                     0x2
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_1__RX_ANA_CDR_VCO_LOWFREQ_MASK                              0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_1__RX_ANA_VCO_CNTR_PD_MASK                                  0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_1__RESERVED_15_2_MASK                                       0xFFFCL
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_2
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_2__RX_ANA_CDR_FREQ_TUNE_CLK__SHIFT                          0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_2__CDR_FREQ_TUNE_CLK_SELF_CLEAR_DISABLE__SHIFT              0x1
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_2__RESERVED_15_2__SHIFT                                     0x2
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_2__RX_ANA_CDR_FREQ_TUNE_CLK_MASK                            0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_2__CDR_FREQ_TUNE_CLK_SELF_CLEAR_DISABLE_MASK                0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_VCO_OVRD_OUT_2__RESERVED_15_2_MASK                                       0xFFFCL
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_CAL
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CAL__RX_ANA_CAL_MUXA_SEL__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CAL__RX_ANA_CAL_MUXB_SEL__SHIFT                                          0x5
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CAL__RX_ANA_CAL_LPFBYP_EN__SHIFT                                         0xa
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CAL__RESERVED__SHIFT                                                     0xb
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CAL__RX_ANA_SLICER_CAL_EN__SHIFT                                         0xc
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CAL__RX_ANA_CAL_MODE__SHIFT                                              0xd
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CAL__RX_ANA_CAL_COMP_EN__SHIFT                                           0xf
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CAL__RX_ANA_CAL_MUXA_SEL_MASK                                            0x001FL
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CAL__RX_ANA_CAL_MUXB_SEL_MASK                                            0x03E0L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CAL__RX_ANA_CAL_LPFBYP_EN_MASK                                           0x0400L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CAL__RESERVED_MASK                                                       0x0800L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CAL__RX_ANA_SLICER_CAL_EN_MASK                                           0x1000L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CAL__RX_ANA_CAL_MODE_MASK                                                0x6000L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_CAL__RX_ANA_CAL_COMP_EN_MASK                                             0x8000L
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_DAC_CTRL
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_DAC_CTRL__RX_ANA_CAL_DAC_CTRL__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_DAC_CTRL__RESERVED_15_8__SHIFT                                           0x8
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_DAC_CTRL__RX_ANA_CAL_DAC_CTRL_MASK                                       0x00FFL
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_DAC_CTRL__RESERVED_15_8_MASK                                             0xFF00L
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_DAC_CTRL_OVRD
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_DAC_CTRL_OVRD__RX_CAL_DAC_CTRL_OVRD__SHIFT                               0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_DAC_CTRL_OVRD__RX_CAL_DAC_CTRL_OVRD_MASK                                 0x0001L
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_DAC_CTRL_SEL
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_DAC_CTRL_SEL__RX_ANA_CAL_DAC_CTRL_SEL__SHIFT                             0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_DAC_CTRL_SEL__RESERVED_15_5__SHIFT                                       0x5
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_DAC_CTRL_SEL__RX_ANA_CAL_DAC_CTRL_SEL_MASK                               0x001FL
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_DAC_CTRL_SEL__RESERVED_15_5_MASK                                         0xFFE0L
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_ATT_VGA
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_ATT_VGA__RX_ANA_AFE_ATT_LVL__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_ATT_VGA__RX_ANA_AFE_GAIN__SHIFT                                      0x3
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_ATT_VGA__RESERVED__SHIFT                                             0x7
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_ATT_VGA__RX_AFE_OVRD_EN__SHIFT                                       0xb
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_ATT_VGA__RESERVED_15_12__SHIFT                                       0xc
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_ATT_VGA__RX_ANA_AFE_ATT_LVL_MASK                                     0x0007L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_ATT_VGA__RX_ANA_AFE_GAIN_MASK                                        0x0078L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_ATT_VGA__RESERVED_MASK                                               0x0780L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_ATT_VGA__RX_AFE_OVRD_EN_MASK                                         0x0800L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_ATT_VGA__RESERVED_15_12_MASK                                         0xF000L
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_CTLE
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_CTLE__RESERVED__SHIFT                                                0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_CTLE__RX_ANA_AFE_CTLE_BOOST__SHIFT                                   0x3
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_CTLE__RESERVED_15_8__SHIFT                                           0x8
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_CTLE__RESERVED_MASK                                                  0x0007L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_CTLE__RX_ANA_AFE_CTLE_BOOST_MASK                                     0x00F8L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_AFE_CTLE__RESERVED_15_8_MASK                                             0xFF00L
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_SCOPE
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_EN__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_SEL__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_PH_CLK__SHIFT                                        0x3
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_PHASE__SHIFT                                         0x4
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_CLK_EN__SHIFT                                        0xc
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SCOPE__RX_SCOPE_SELF_CLEAR_DISABLE__SHIFT                                0xd
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SCOPE__RESERVED_15_14__SHIFT                                             0xe
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_EN_MASK                                              0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_SEL_MASK                                             0x0006L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_PH_CLK_MASK                                          0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_PHASE_MASK                                           0x0FF0L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_CLK_EN_MASK                                          0x1000L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SCOPE__RX_SCOPE_SELF_CLEAR_DISABLE_MASK                                  0x2000L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SCOPE__RESERVED_15_14_MASK                                               0xC000L
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_SLICER_CTRL
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SLICER_CTRL__RX_ANA_SLICER_CTRL_E__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SLICER_CTRL__RX_ANA_SLICER_CTRL_O__SHIFT                                 0x4
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SLICER_CTRL__RX_ANA_SLICER_CTRL_OVRD_EN__SHIFT                           0x8
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SLICER_CTRL__RESERVED_15_9__SHIFT                                        0x9
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SLICER_CTRL__RX_ANA_SLICER_CTRL_E_MASK                                   0x000FL
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SLICER_CTRL__RX_ANA_SLICER_CTRL_O_MASK                                   0x00F0L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SLICER_CTRL__RX_ANA_SLICER_CTRL_OVRD_EN_MASK                             0x0100L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_SLICER_CTRL__RESERVED_15_9_MASK                                          0xFE00L
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_IQ_PHASE_ADJUST
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_IQ_PHASE_ADJUST__RX_ANA_IQ_PHASE_ADJUST__SHIFT                       0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_IQ_PHASE_ADJUST__RX_ANA_IQ_PHASE_ADJUST_MASK                         0x007FL
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_IQ_SENSE_EN
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_IQ_SENSE_EN__RX_ANA_IQ_SENSE_EN__SHIFT                               0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_IQ_SENSE_EN__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_IQ_SENSE_EN__RX_ANA_IQ_SENSE_EN_MASK                                 0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_IQ_SENSE_EN__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_CAL_DAC_CTRL_EN
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_CAL_DAC_CTRL_EN__RX_ANA_CAL_DAC_CTRL_EN__SHIFT                       0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_CAL_DAC_CTRL_EN__DAC_CTRL_SELF_CLEAR_DISABLE__SHIFT                  0x1
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_CAL_DAC_CTRL_EN__RESERVED_15_2__SHIFT                                0x2
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_CAL_DAC_CTRL_EN__RX_ANA_CAL_DAC_CTRL_EN_MASK                         0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_CAL_DAC_CTRL_EN__DAC_CTRL_SELF_CLEAR_DISABLE_MASK                    0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_CAL_DAC_CTRL_EN__RESERVED_15_2_MASK                                  0xFFFCL
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_SIGNALS_CHANGES_ENABLE
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_SIGNALS_CHANGES_ENABLE__RX_ANA_AFE_UPDATE_EN__SHIFT                  0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_SIGNALS_CHANGES_ENABLE__AFE_UPDATE_SELF_CLEAR_DISABLE__SHIFT         0x1
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_SIGNALS_CHANGES_ENABLE__RESERVED_15_2__SHIFT                         0x2
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_SIGNALS_CHANGES_ENABLE__RX_ANA_AFE_UPDATE_EN_MASK                    0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_SIGNALS_CHANGES_ENABLE__AFE_UPDATE_SELF_CLEAR_DISABLE_MASK           0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_SIGNALS_CHANGES_ENABLE__RESERVED_15_2_MASK                           0xFFFCL
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_PHASE_ADJUST_CLK
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_PHASE_ADJUST_CLK__RX_ANA_IQ_PHASE_ADJUST_CLK__SHIFT                  0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_PHASE_ADJUST_CLK__PHASE_ADJUST_SELF_CLEAR_DISABLE__SHIFT             0x1
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_PHASE_ADJUST_CLK__RESERVED_15_2__SHIFT                               0x2
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_PHASE_ADJUST_CLK__RX_ANA_IQ_PHASE_ADJUST_CLK_MASK                    0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_PHASE_ADJUST_CLK__PHASE_ADJUST_SELF_CLEAR_DISABLE_MASK               0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_ANA_PHASE_ADJUST_CLK__RESERVED_15_2_MASK                                 0xFFFCL
//DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__TX_ANA_CLK_SHIFT_ACK__SHIFT                                       0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__TX_ANA_RXDETP_RESULT__SHIFT                                       0x1
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__TX_ANA_RXDETM_RESULT__SHIFT                                       0x2
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__TX_ANA_LOOPBACK_EN__SHIFT                                         0x3
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__TX_ANA_CLK_LB_EN__SHIFT                                           0x4
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__RX_ANA_CAL_RESULT__SHIFT                                          0x5
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__RX_ANA_SCOPE_DATA__SHIFT                                          0x6
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__TX_ANA_DCC_CAL_RESULT__SHIFT                                      0x7
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__TX_ANA_CTRL_EQ_MUX__SHIFT                                         0x8
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__TX_ANA_CLK_SHIFT_ACK_MASK                                         0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__TX_ANA_RXDETP_RESULT_MASK                                         0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__TX_ANA_RXDETM_RESULT_MASK                                         0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__TX_ANA_LOOPBACK_EN_MASK                                           0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__TX_ANA_CLK_LB_EN_MASK                                             0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__RX_ANA_CAL_RESULT_MASK                                            0x0020L
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__RX_ANA_SCOPE_DATA_MASK                                            0x0040L
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__TX_ANA_DCC_CAL_RESULT_MASK                                        0x0080L
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_0__TX_ANA_CTRL_EQ_MUX_MASK                                           0xFF00L
//DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_1
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_1__RX_ANA_VCO_CNTR__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_1__RESERVED_15_13__SHIFT                                             0xd
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_1__RX_ANA_VCO_CNTR_MASK                                              0x1FFFL
#define DPCSSYS_CR0_LANE1_DIG_ANA_STATUS_1__RESERVED_15_13_MASK                                               0xE000L
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_TERM_CODE_OVRD_OUT
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_TERM_CODE_OVRD_OUT__RX_TERM_CODE__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_TERM_CODE_OVRD_OUT__RX_TERM_OVRD_EN__SHIFT                               0x6
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_TERM_CODE_OVRD_OUT__RESERVED_15_7__SHIFT                                 0x7
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_TERM_CODE_OVRD_OUT__RX_TERM_CODE_MASK                                    0x003FL
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_TERM_CODE_OVRD_OUT__RX_TERM_OVRD_EN_MASK                                 0x0040L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_TERM_CODE_OVRD_OUT__RESERVED_15_7_MASK                                   0xFF80L
//DPCSSYS_CR0_LANE1_DIG_ANA_RX_TERM_CODE_CLK_OVRD_OUT
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_TERM_CODE_CLK_OVRD_OUT__RX_TERM_CLK__SHIFT                               0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_TERM_CODE_CLK_OVRD_OUT__RX_TERM_CLK_SELF_CLEAR_DISABLE__SHIFT            0x1
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_TERM_CODE_CLK_OVRD_OUT__RESERVED_15_2__SHIFT                             0x2
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_TERM_CODE_CLK_OVRD_OUT__RX_TERM_CLK_MASK                                 0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_TERM_CODE_CLK_OVRD_OUT__RX_TERM_CLK_SELF_CLEAR_DISABLE_MASK              0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ANA_RX_TERM_CODE_CLK_OVRD_OUT__RESERVED_15_2_MASK                               0xFFFCL
//DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_SQ_CTRL_TRESH__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_SQ_CTRL_TRESH_OVRD_EN__SHIFT                          0x3
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_SQ_CTRL_RESP__SHIFT                                   0x4
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_SQ_CTRL_RESP_OVRD_EN__SHIFT                           0x6
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_PWM_EN__SHIFT                                         0x7
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_PWM_EN_OVRD_EN__SHIFT                                 0x8
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_PWM_CLK_SEL__SHIFT                                    0x9
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_PWM_CLK_SEL_OVRD_EN__SHIFT                            0xb
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RESERVED_15_12__SHIFT                                        0xc
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_SQ_CTRL_TRESH_MASK                                    0x0007L
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_SQ_CTRL_TRESH_OVRD_EN_MASK                            0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_SQ_CTRL_RESP_MASK                                     0x0030L
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_SQ_CTRL_RESP_OVRD_EN_MASK                             0x0040L
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_PWM_EN_MASK                                           0x0080L
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_PWM_EN_OVRD_EN_MASK                                   0x0100L
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_PWM_CLK_SEL_MASK                                      0x0600L
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_PWM_CLK_SEL_OVRD_EN_MASK                              0x0800L
#define DPCSSYS_CR0_LANE1_DIG_ANA_MPHY_OVRD_OUT__RESERVED_15_12_MASK                                          0xF000L
//DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_1
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_HF_THRESH__SHIFT                           0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_HF_THRESH_OVRD_EN__SHIFT                   0x3
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_HF_CAL_TUNE__SHIFT                         0x4
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_CAL_TUNE_OVRD_EN__SHIFT                    0xa
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_CAL_EN__SHIFT                              0xb
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_CAL_EN_OVRD_EN__SHIFT                      0xc
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_1__RESERVED_15_13__SHIFT                                    0xd
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_HF_THRESH_MASK                             0x0007L
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_HF_THRESH_OVRD_EN_MASK                     0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_HF_CAL_TUNE_MASK                           0x03F0L
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_CAL_TUNE_OVRD_EN_MASK                      0x0400L
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_CAL_EN_MASK                                0x0800L
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_CAL_EN_OVRD_EN_MASK                        0x1000L
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_1__RESERVED_15_13_MASK                                      0xE000L
//DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_2
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_LF_THRESH__SHIFT                           0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_LF_THRESH_OVRD_EN__SHIFT                   0x3
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_LF_FILTER_EN__SHIFT                        0x4
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_LF_FILTER_EN_OVRD_EN__SHIFT                0x5
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_CAL_TUNE__SHIFT                            0x6
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_CAL_TUNE_OVRD_EN__SHIFT                    0xc
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_2__RESERVED_15_13__SHIFT                                    0xd
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_LF_THRESH_MASK                             0x0007L
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_LF_THRESH_OVRD_EN_MASK                     0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_LF_FILTER_EN_MASK                          0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_LF_FILTER_EN_OVRD_EN_MASK                  0x0020L
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_CAL_TUNE_MASK                              0x0FC0L
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_CAL_TUNE_OVRD_EN_MASK                      0x1000L
#define DPCSSYS_CR0_LANE1_DIG_ANA_SIGDET_OVRD_OUT_2__RESERVED_15_13_MASK                                      0xE000L
//DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_RANGE__SHIFT                            0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_RANGE_OVRD_EN__SHIFT                    0x2
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_COMP_EN__SHIFT                          0x3
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_COMP_EN_OVRD_EN__SHIFT                  0x4
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL__SHIFT                             0x5
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_OVRD_EN__SHIFT                     0xd
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_EN__SHIFT                          0xe
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_EN_OVRD_EN__SHIFT                  0xf
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_RANGE_MASK                              0x0003L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_RANGE_OVRD_EN_MASK                      0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_COMP_EN_MASK                            0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_COMP_EN_OVRD_EN_MASK                    0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_MASK                               0x1FE0L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_OVRD_EN_MASK                       0x2000L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_EN_MASK                            0x4000L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_EN_OVRD_EN_MASK                    0x8000L
//DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CAL_CTRL_SEL__SHIFT                       0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CAL_CTRL_SEL_OVRD_EN__SHIFT               0x3
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CLK_COMP__SHIFT                           0x4
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CLK_COMP_OVRD_EN__SHIFT                   0x5
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CAL_CTRL_SEL_MASK                         0x0007L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CAL_CTRL_SEL_OVRD_EN_MASK                 0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CLK_COMP_MASK                             0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CLK_COMP_OVRD_EN_MASK                     0x0020L
//DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT_2
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT_2__TX_ANA_FAST_START__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT_2__TX_ANA_FAST_START_OVRD_EN__SHIFT                             0x1
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT_2__TX_CLK_LB_EN__SHIFT                                          0x2
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT_2__TX_CLK_LB_EN_OVRD_EN__SHIFT                                  0x3
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT_2__TX_ACJTAG_EN__SHIFT                                          0x4
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT_2__RESERVED_15_5__SHIFT                                         0x5
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT_2__TX_ANA_FAST_START_MASK                                       0x0001L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT_2__TX_ANA_FAST_START_OVRD_EN_MASK                               0x0002L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT_2__TX_CLK_LB_EN_MASK                                            0x0004L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT_2__TX_CLK_LB_EN_OVRD_EN_MASK                                    0x0008L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT_2__TX_ACJTAG_EN_MASK                                            0x0010L
#define DPCSSYS_CR0_LANE1_DIG_ANA_TX_OVRD_OUT_2__RESERVED_15_5_MASK                                           0xFFE0L
//DPCSSYS_CR0_LANE1_ANA_TX_OVRD_MEAS
#define DPCSSYS_CR0_LANE1_ANA_TX_OVRD_MEAS__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE1_ANA_TX_OVRD_MEAS__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE1_ANA_TX_PWR_OVRD
#define DPCSSYS_CR0_LANE1_ANA_TX_PWR_OVRD__RESERVED_15_8__SHIFT                                               0x8
#define DPCSSYS_CR0_LANE1_ANA_TX_PWR_OVRD__RESERVED_15_8_MASK                                                 0xFF00L
//DPCSSYS_CR0_LANE1_ANA_TX_ALT_BUS
#define DPCSSYS_CR0_LANE1_ANA_TX_ALT_BUS__RESERVED_15_8__SHIFT                                                0x8
#define DPCSSYS_CR0_LANE1_ANA_TX_ALT_BUS__RESERVED_15_8_MASK                                                  0xFF00L
//DPCSSYS_CR0_LANE1_ANA_TX_ATB1
#define DPCSSYS_CR0_LANE1_ANA_TX_ATB1__RESERVED_15_8__SHIFT                                                   0x8
#define DPCSSYS_CR0_LANE1_ANA_TX_ATB1__RESERVED_15_8_MASK                                                     0xFF00L
//DPCSSYS_CR0_LANE1_ANA_TX_ATB2
#define DPCSSYS_CR0_LANE1_ANA_TX_ATB2__RESERVED_15_8__SHIFT                                                   0x8
#define DPCSSYS_CR0_LANE1_ANA_TX_ATB2__RESERVED_15_8_MASK                                                     0xFF00L
//DPCSSYS_CR0_LANE1_ANA_TX_DCC_DAC
#define DPCSSYS_CR0_LANE1_ANA_TX_DCC_DAC__RESERVED_15_8__SHIFT                                                0x8
#define DPCSSYS_CR0_LANE1_ANA_TX_DCC_DAC__RESERVED_15_8_MASK                                                  0xFF00L
//DPCSSYS_CR0_LANE1_ANA_TX_DCC_CTRL1
#define DPCSSYS_CR0_LANE1_ANA_TX_DCC_CTRL1__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE1_ANA_TX_DCC_CTRL1__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE1_ANA_TX_TERM_CODE
#define DPCSSYS_CR0_LANE1_ANA_TX_TERM_CODE__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE1_ANA_TX_TERM_CODE__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE1_ANA_TX_TERM_CODE_CTRL
#define DPCSSYS_CR0_LANE1_ANA_TX_TERM_CODE_CTRL__RESERVED_15_8__SHIFT                                         0x8
#define DPCSSYS_CR0_LANE1_ANA_TX_TERM_CODE_CTRL__RESERVED_15_8_MASK                                           0xFF00L
//DPCSSYS_CR0_LANE1_ANA_TX_OVRD_CLK
#define DPCSSYS_CR0_LANE1_ANA_TX_OVRD_CLK__RESERVED_15_8__SHIFT                                               0x8
#define DPCSSYS_CR0_LANE1_ANA_TX_OVRD_CLK__RESERVED_15_8_MASK                                                 0xFF00L
//DPCSSYS_CR0_LANE1_ANA_TX_MISC1
#define DPCSSYS_CR0_LANE1_ANA_TX_MISC1__RESERVED_15_8__SHIFT                                                  0x8
#define DPCSSYS_CR0_LANE1_ANA_TX_MISC1__RESERVED_15_8_MASK                                                    0xFF00L
//DPCSSYS_CR0_LANE1_ANA_TX_MISC2
#define DPCSSYS_CR0_LANE1_ANA_TX_MISC2__RESERVED_15_8__SHIFT                                                  0x8
#define DPCSSYS_CR0_LANE1_ANA_TX_MISC2__RESERVED_15_8_MASK                                                    0xFF00L
//DPCSSYS_CR0_LANE1_ANA_TX_RESERVED3
#define DPCSSYS_CR0_LANE1_ANA_TX_RESERVED3__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE1_ANA_TX_RESERVED3__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE1_ANA_TX_RESERVED4
#define DPCSSYS_CR0_LANE1_ANA_TX_RESERVED4__NC7_0__SHIFT                                                      0x0
#define DPCSSYS_CR0_LANE1_ANA_TX_RESERVED4__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE1_ANA_TX_RESERVED4__NC7_0_MASK                                                        0x00FFL
#define DPCSSYS_CR0_LANE1_ANA_TX_RESERVED4__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE1_ANA_RX_CLK_1
//DPCSSYS_CR0_LANE1_ANA_RX_CLK_2
//DPCSSYS_CR0_LANE1_ANA_RX_CDR_DES
//DPCSSYS_CR0_LANE1_ANA_RX_SLC_CTRL
//DPCSSYS_CR0_LANE1_ANA_RX_PWR_CTRL1
#define DPCSSYS_CR0_LANE1_ANA_RX_PWR_CTRL1__NC7_7__SHIFT                                                      0x7
#define DPCSSYS_CR0_LANE1_ANA_RX_PWR_CTRL1__NC7_7_MASK                                                        0x0080L
//DPCSSYS_CR0_LANE1_ANA_RX_PWR_CTRL2
//DPCSSYS_CR0_LANE1_ANA_RX_SQ
#define DPCSSYS_CR0_LANE1_ANA_RX_SQ__NC4_3__SHIFT                                                             0x3
#define DPCSSYS_CR0_LANE1_ANA_RX_SQ__NC4_3_MASK                                                               0x0018L
//DPCSSYS_CR0_LANE1_ANA_RX_CAL1
//DPCSSYS_CR0_LANE1_ANA_RX_CAL2
#define DPCSSYS_CR0_LANE1_ANA_RX_CAL2__RESERVED_15_8__SHIFT                                                   0x8
#define DPCSSYS_CR0_LANE1_ANA_RX_CAL2__RESERVED_15_8_MASK                                                     0xFF00L
//DPCSSYS_CR0_LANE1_ANA_RX_ATB_REGREF
#define DPCSSYS_CR0_LANE1_ANA_RX_ATB_REGREF__RESERVED_15_8__SHIFT                                             0x8
#define DPCSSYS_CR0_LANE1_ANA_RX_ATB_REGREF__RESERVED_15_8_MASK                                               0xFF00L
//DPCSSYS_CR0_LANE1_ANA_RX_ATB_MEAS1
#define DPCSSYS_CR0_LANE1_ANA_RX_ATB_MEAS1__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE1_ANA_RX_ATB_MEAS1__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE1_ANA_RX_ATB_MEAS2
#define DPCSSYS_CR0_LANE1_ANA_RX_ATB_MEAS2__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE1_ANA_RX_ATB_MEAS2__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE1_ANA_RX_ATB_MEAS3
#define DPCSSYS_CR0_LANE1_ANA_RX_ATB_MEAS3__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE1_ANA_RX_ATB_MEAS3__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_OVRD_IN
#define DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_OVRD_IN__LANE_TX2RX_SER_LB__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_OVRD_IN__LANE_RX2TX_PAR_LB__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_OVRD_IN__EN__SHIFT                                                    0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_OVRD_IN__RX_ACJTAG_EN__SHIFT                                          0x3
#define DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_OVRD_IN__RESERVED_15_4__SHIFT                                         0x4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_OVRD_IN__LANE_TX2RX_SER_LB_MASK                                       0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_OVRD_IN__LANE_RX2TX_PAR_LB_MASK                                       0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_OVRD_IN__EN_MASK                                                      0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_OVRD_IN__RX_ACJTAG_EN_MASK                                            0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_OVRD_IN__RESERVED_15_4_MASK                                           0xFFF0L
//DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__REQ__SHIFT                                                   0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__REQ_OVRD_EN__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__PSTATE__SHIFT                                                0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__PSTATE_OVRD_EN__SHIFT                                        0x4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__RATE__SHIFT                                                  0x5
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__RATE_OVRD_EN__SHIFT                                          0x8
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__WIDTH__SHIFT                                                 0x9
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__WIDTH_OVRD_EN__SHIFT                                         0xb
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__MPLLB_SEL__SHIFT                                             0xc
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__MPLLB_SEL_OVRD_EN__SHIFT                                     0xd
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__DATA_EN__SHIFT                                               0xe
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__DATA_EN_OVRD_EN__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__REQ_MASK                                                     0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__REQ_OVRD_EN_MASK                                             0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__PSTATE_MASK                                                  0x000CL
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__PSTATE_OVRD_EN_MASK                                          0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__RATE_MASK                                                    0x00E0L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__RATE_OVRD_EN_MASK                                            0x0100L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__WIDTH_MASK                                                   0x0600L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__WIDTH_OVRD_EN_MASK                                           0x0800L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__MPLLB_SEL_MASK                                               0x1000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__MPLLB_SEL_OVRD_EN_MASK                                       0x2000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__DATA_EN_MASK                                                 0x4000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_0__DATA_EN_OVRD_EN_MASK                                         0x8000L
//DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__NYQUIST_DATA__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__DISABLE__SHIFT                                               0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__BEACON_EN__SHIFT                                             0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__EN__SHIFT                                                    0x3
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__TX_MAIN_CURSOR__SHIFT                                        0x4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__MAIN_OVRD_EN__SHIFT                                          0xa
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__ASYNC_DRV_EN__SHIFT                                          0xb
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__ASYNC_DRV_OVRD_EN__SHIFT                                     0xc
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__TX_VREGDRV_BYP_OVRD__SHIFT                                   0xd
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__TX_VREGDRV_BYP_OVRD_EN__SHIFT                                0xe
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__RESERVED_15_15__SHIFT                                        0xf
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__NYQUIST_DATA_MASK                                            0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__DISABLE_MASK                                                 0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__BEACON_EN_MASK                                               0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__EN_MASK                                                      0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__TX_MAIN_CURSOR_MASK                                          0x03F0L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__MAIN_OVRD_EN_MASK                                            0x0400L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__ASYNC_DRV_EN_MASK                                            0x0800L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__ASYNC_DRV_OVRD_EN_MASK                                       0x1000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__TX_VREGDRV_BYP_OVRD_MASK                                     0x2000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__TX_VREGDRV_BYP_OVRD_EN_MASK                                  0x4000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_1__RESERVED_15_15_MASK                                          0x8000L
//DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_2__TX_PRE_CURSOR__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_2__PRE_OVRD_EN__SHIFT                                           0x6
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_2__TX_POST_CURSOR__SHIFT                                        0x7
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_2__POST_OVRD_EN__SHIFT                                          0xd
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_2__HDMIMODE_EN__SHIFT                                           0xe
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_2__HDMIMODE_ENABLE_OVRD_EN__SHIFT                               0xf
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_2__TX_PRE_CURSOR_MASK                                           0x003FL
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_2__PRE_OVRD_EN_MASK                                             0x0040L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_2__TX_POST_CURSOR_MASK                                          0x1F80L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_2__POST_OVRD_EN_MASK                                            0x2000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_2__HDMIMODE_EN_MASK                                             0x4000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_2__HDMIMODE_ENABLE_OVRD_EN_MASK                                 0x8000L
//DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__CLK_RDY__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__CLK_RDY_OVRD_EN__SHIFT                                       0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__DETECT_RX_REQ__SHIFT                                         0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__DETECT_RX_REQ_OVRD_EN__SHIFT                                 0x3
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__INVERT__SHIFT                                                0x4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__INVERT_OVRD_EN__SHIFT                                        0x5
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__LPD__SHIFT                                                   0x6
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__LPD_OVRD_EN__SHIFT                                           0x7
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__TX_DC_COUP_EN__SHIFT                                         0x8
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__TX_DC_COUP_EN_OVRD_EN__SHIFT                                 0x9
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__PMA_EXTENDED_FIFO_EN__SHIFT                                  0xa
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__PMA_EXTENDED_FIFO_EN_OVRD_EN__SHIFT                          0xb
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__TX_MPHY_MODE_EN__SHIFT                                       0xc
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__TX_MPHY_MODE_EN_OVRD_EN__SHIFT                               0xd
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__RESERVED_15_14__SHIFT                                        0xe
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__CLK_RDY_MASK                                                 0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__CLK_RDY_OVRD_EN_MASK                                         0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__DETECT_RX_REQ_MASK                                           0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__DETECT_RX_REQ_OVRD_EN_MASK                                   0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__INVERT_MASK                                                  0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__INVERT_OVRD_EN_MASK                                          0x0020L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__LPD_MASK                                                     0x0040L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__LPD_OVRD_EN_MASK                                             0x0080L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__TX_DC_COUP_EN_MASK                                           0x0100L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__TX_DC_COUP_EN_OVRD_EN_MASK                                   0x0200L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__PMA_EXTENDED_FIFO_EN_MASK                                    0x0400L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__PMA_EXTENDED_FIFO_EN_OVRD_EN_MASK                            0x0800L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__TX_MPHY_MODE_EN_MASK                                         0x1000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__TX_MPHY_MODE_EN_OVRD_EN_MASK                                 0x2000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_3__RESERVED_15_14_MASK                                          0xC000L
//DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_4__RESET__SHIFT                                                 0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_4__RESET_OVRD_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_4__RESET_MASK                                                   0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_4__RESET_OVRD_EN_MASK                                           0x0002L
//DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT__TX_ACK__SHIFT                                                 0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT__EN_TX_ACK__SHIFT                                              0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT__DETRX_RESULT__SHIFT                                           0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT__EN_DETRX_RESULT__SHIFT                                        0x3
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT__RESERVED_15_4__SHIFT                                          0x4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT__TX_ACK_MASK                                                   0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT__EN_TX_ACK_MASK                                                0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT__DETRX_RESULT_MASK                                             0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT__EN_DETRX_RESULT_MASK                                          0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT__RESERVED_15_4_MASK                                            0xFFF0L
//DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__REQ__SHIFT                                                   0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__REQ_OVRD_EN__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__DATA_EN__SHIFT                                               0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__DATA_EN_OVRD_EN__SHIFT                                       0x3
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__PSTATE__SHIFT                                                0x4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__PSTATE_OVRD_EN__SHIFT                                        0x6
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__RATE__SHIFT                                                  0x7
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__RATE_OVRD_EN__SHIFT                                          0x9
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__WIDTH__SHIFT                                                 0xa
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__WIDTH_OVRD_EN__SHIFT                                         0xc
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__RESERVED_15_13__SHIFT                                        0xd
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__REQ_MASK                                                     0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__REQ_OVRD_EN_MASK                                             0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__DATA_EN_MASK                                                 0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__DATA_EN_OVRD_EN_MASK                                         0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__PSTATE_MASK                                                  0x0030L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__PSTATE_OVRD_EN_MASK                                          0x0040L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__RATE_MASK                                                    0x0180L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__RATE_OVRD_EN_MASK                                            0x0200L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__WIDTH_MASK                                                   0x0C00L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__WIDTH_OVRD_EN_MASK                                           0x1000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_0__RESERVED_15_13_MASK                                          0xE000L
//DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_1__RX_REF_LD_VAL_5_0__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_1__RX_CDR_VCO_LOWFREQ__SHIFT                                    0x6
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_1__EN__SHIFT                                                    0x7
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_1__RX_REF_LD_VAL_6__SHIFT                                       0x8
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_1__RESERVED_15_9__SHIFT                                         0x9
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_1__RX_REF_LD_VAL_5_0_MASK                                       0x003FL
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_1__RX_CDR_VCO_LOWFREQ_MASK                                      0x0040L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_1__EN_MASK                                                      0x0080L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_1__RX_REF_LD_VAL_6_MASK                                         0x0100L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_1__RESERVED_15_9_MASK                                           0xFE00L
//DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_2__RX_VCO_LD_VAL__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_2__EN__SHIFT                                                    0xd
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_2__RESERVED_15_14__SHIFT                                        0xe
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_2__RX_VCO_LD_VAL_MASK                                           0x1FFFL
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_2__EN_MASK                                                      0x2000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_2__RESERVED_15_14_MASK                                          0xC000L
//DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__CDR_TRACK_EN__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__CDR_TRACK_EN_OVRD_EN__SHIFT                                  0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__CDR_SSC_EN__SHIFT                                            0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__CDR_SSC_EN_OVRD_EN__SHIFT                                    0x3
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__ALIGN_EN__SHIFT                                              0x4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__ALIGN_EN_OVRD_EN__SHIFT                                      0x5
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__CLK_SHIFT__SHIFT                                             0x6
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__CLK_SHIFT_OVRD_EN__SHIFT                                     0x7
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__DISABLE__SHIFT                                               0x8
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__DISABLE_OVRD_EN__SHIFT                                       0x9
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__RESERVED_15_10__SHIFT                                        0xa
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__CDR_TRACK_EN_MASK                                            0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__CDR_TRACK_EN_OVRD_EN_MASK                                    0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__CDR_SSC_EN_MASK                                              0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__CDR_SSC_EN_OVRD_EN_MASK                                      0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__ALIGN_EN_MASK                                                0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__ALIGN_EN_OVRD_EN_MASK                                        0x0020L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__CLK_SHIFT_MASK                                               0x0040L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__CLK_SHIFT_OVRD_EN_MASK                                       0x0080L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__DISABLE_MASK                                                 0x0100L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__DISABLE_OVRD_EN_MASK                                         0x0200L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_3__RESERVED_15_10_MASK                                          0xFC00L
//DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__LPD__SHIFT                                                   0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__LPD_OVRD_EN__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__INVERT__SHIFT                                                0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__INVERT_OVRD_EN__SHIFT                                        0x3
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__ADAPT_AFE_EN__SHIFT                                          0x4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__ADAPT_DFE_EN__SHIFT                                          0x5
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__ADPT_OVRD_EN__SHIFT                                          0x6
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__TERM_EN__SHIFT                                               0x7
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__TERM_ACDC__SHIFT                                             0x8
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__TERM_OVRD_EN__SHIFT                                          0x9
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__LPD_MASK                                                     0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__LPD_OVRD_EN_MASK                                             0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__INVERT_MASK                                                  0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__INVERT_OVRD_EN_MASK                                          0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__ADAPT_AFE_EN_MASK                                            0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__ADAPT_DFE_EN_MASK                                            0x0020L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__ADPT_OVRD_EN_MASK                                            0x0040L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__TERM_EN_MASK                                                 0x0080L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__TERM_ACDC_MASK                                               0x0100L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_4__TERM_OVRD_EN_MASK                                            0x0200L
//DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_5
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_5__RESET__SHIFT                                                 0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_5__RESET_OVRD_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_5__RESET_MASK                                                   0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_5__RESET_OVRD_EN_MASK                                           0x0002L
//DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_EQ_IN_0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_EQ_IN_0__EQ_ATT_LVL__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_EQ_IN_0__EQ_AFE_GAIN__SHIFT                                        0x3
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_EQ_IN_0__RESERVED__SHIFT                                           0x7
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_EQ_IN_0__EQ_CTLE_BOOST__SHIFT                                      0xb
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_EQ_IN_0__EQ_ATT_LVL_MASK                                           0x0007L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_EQ_IN_0__EQ_AFE_GAIN_MASK                                          0x0078L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_EQ_IN_0__RESERVED_MASK                                             0x0780L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_EQ_IN_0__EQ_CTLE_BOOST_MASK                                        0xF800L
//DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_EQ_IN_1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_EQ_IN_1__EQ_DFE_TAP2__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_EQ_IN_1__EQ_DFE_TAP1__SHIFT                                        0x7
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_EQ_IN_1__EQ_OVRD_EN__SHIFT                                         0xf
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_EQ_IN_1__EQ_DFE_TAP2_MASK                                          0x007FL
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_EQ_IN_1__EQ_DFE_TAP1_MASK                                          0x7F80L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_EQ_IN_1__EQ_OVRD_EN_MASK                                           0x8000L
//DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__ACK__SHIFT                                                  0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__ACK_OVRD_EN__SHIFT                                          0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__ADAPT_STS__SHIFT                                            0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__ADAPT_STS_OVRD_EN__SHIFT                                    0x4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__RX_ASYNC_DATA__SHIFT                                        0x5
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__RX_ASYNC_DATA_OVRD_EN__SHIFT                                0x6
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__RX_SQ_WEAKKEEP_OUT__SHIFT                                   0x7
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__RX_SQ_WEAKKEEP_OUT_OVRD_EN__SHIFT                           0x8
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__RESERVED_15_9__SHIFT                                        0x9
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__ACK_MASK                                                    0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__ACK_OVRD_EN_MASK                                            0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__ADAPT_STS_MASK                                              0x000CL
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__ADAPT_STS_OVRD_EN_MASK                                      0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__RX_ASYNC_DATA_MASK                                          0x0020L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__RX_ASYNC_DATA_OVRD_EN_MASK                                  0x0040L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__RX_SQ_WEAKKEEP_OUT_MASK                                     0x0080L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__RX_SQ_WEAKKEEP_OUT_OVRD_EN_MASK                             0x0100L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_OUT_0__RESERVED_15_9_MASK                                          0xFE00L
//DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_ASIC_IN
#define DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_ASIC_IN__LANE_TX2RX_SER_LB__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_ASIC_IN__LANE_RX2TX_PAR_LB__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_ASIC_IN__RESERVED_15_2__SHIFT                                         0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_ASIC_IN__LANE_TX2RX_SER_LB_MASK                                       0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_ASIC_IN__LANE_RX2TX_PAR_LB_MASK                                       0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_LANE_ASIC_IN__RESERVED_15_2_MASK                                           0xFFFCL
//DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__CLK_RDY__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__RESET__SHIFT                                                 0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__INVERT__SHIFT                                                0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__DATA_EN__SHIFT                                               0x3
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__REQ__SHIFT                                                   0x4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__LPD__SHIFT                                                   0x5
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__PSTATE__SHIFT                                                0x6
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__RATE__SHIFT                                                  0x8
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__WIDTH__SHIFT                                                 0xb
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__MPLLB_SEL__SHIFT                                             0xd
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__DETECT_RX_REQ__SHIFT                                         0xe
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__DISABLE__SHIFT                                               0xf
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__CLK_RDY_MASK                                                 0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__RESET_MASK                                                   0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__INVERT_MASK                                                  0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__DATA_EN_MASK                                                 0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__REQ_MASK                                                     0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__LPD_MASK                                                     0x0020L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__PSTATE_MASK                                                  0x00C0L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__RATE_MASK                                                    0x0700L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__WIDTH_MASK                                                   0x1800L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__MPLLB_SEL_MASK                                               0x2000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__DETECT_RX_REQ_MASK                                           0x4000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_0__DISABLE_MASK                                                 0x8000L
//DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_1__BEACON_EN__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_1__TX_MAIN_CURSOR__SHIFT                                        0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_EN__SHIFT                                           0x7
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_DATA__SHIFT                                         0x8
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_DRV_EN__SHIFT                                       0x9
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_1__TX_VREGDRV_BYP__SHIFT                                        0xa
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_1__BEACON_EN_MASK                                               0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_1__TX_MAIN_CURSOR_MASK                                          0x007EL
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_EN_MASK                                             0x0080L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_DATA_MASK                                           0x0100L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_DRV_EN_MASK                                         0x0200L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_1__TX_VREGDRV_BYP_MASK                                          0x0400L
//DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_2__TX_PRE_CURSOR__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_2__TX_POST_CURSOR__SHIFT                                        0x6
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_2__RESERVED_15_12__SHIFT                                        0xc
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_2__TX_PRE_CURSOR_MASK                                           0x003FL
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_2__TX_POST_CURSOR_MASK                                          0x0FC0L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_IN_2__RESERVED_15_12_MASK                                          0xF000L
//DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_OUT
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_OUT__TX_ACK__SHIFT                                                 0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_OUT__DETRX_RESULT__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_OUT__RESERVED_15_2__SHIFT                                          0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_OUT__TX_ACK_MASK                                                   0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_OUT__DETRX_RESULT_MASK                                             0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_ASIC_OUT__RESERVED_15_2_MASK                                            0xFFFCL
//DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__RESET__SHIFT                                                 0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__INVERT__SHIFT                                                0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__DATA_EN__SHIFT                                               0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__REQ__SHIFT                                                   0x3
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__LPD__SHIFT                                                   0x4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__PSTATE__SHIFT                                                0x5
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__RATE__SHIFT                                                  0x7
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__WIDTH__SHIFT                                                 0x9
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__RESERVED__SHIFT                                              0xb
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__ADAPT_AFE_EN__SHIFT                                          0xc
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__ADAPT_DFE_EN__SHIFT                                          0xd
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__CDR_TRACK_EN__SHIFT                                          0xe
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__RESERVED_15_15__SHIFT                                        0xf
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__RESET_MASK                                                   0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__INVERT_MASK                                                  0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__DATA_EN_MASK                                                 0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__REQ_MASK                                                     0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__LPD_MASK                                                     0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__PSTATE_MASK                                                  0x0060L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__RATE_MASK                                                    0x0180L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__WIDTH_MASK                                                   0x0600L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__RESERVED_MASK                                                0x0800L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__ADAPT_AFE_EN_MASK                                            0x1000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__ADAPT_DFE_EN_MASK                                            0x2000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__CDR_TRACK_EN_MASK                                            0x4000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_0__RESERVED_15_15_MASK                                          0x8000L
//DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_1__CDR_SSC_EN__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_1__ALIGN_EN__SHIFT                                              0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_1__CLK_SHIFT__SHIFT                                             0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_1__DISABLE__SHIFT                                               0x3
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_1__RX_TERM_EN__SHIFT                                            0x4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_1__RX_TERM_ACDC__SHIFT                                          0x5
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_1__CDR_SSC_EN_MASK                                              0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_1__ALIGN_EN_MASK                                                0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_1__CLK_SHIFT_MASK                                               0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_1__DISABLE_MASK                                                 0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_1__RX_TERM_EN_MASK                                              0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_IN_1__RX_TERM_ACDC_MASK                                            0x0020L
//DPCSSYS_CR0_LANE2_DIG_ASIC_RX_EQ_ASIC_IN_0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_EQ_ASIC_IN_0__EQ_ATT_LVL__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_EQ_ASIC_IN_0__EQ_AFE_GAIN__SHIFT                                        0x3
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_EQ_ASIC_IN_0__RESERVED__SHIFT                                           0x7
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_EQ_ASIC_IN_0__EQ_CTLE_BOOST__SHIFT                                      0xb
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_EQ_ASIC_IN_0__EQ_ATT_LVL_MASK                                           0x0007L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_EQ_ASIC_IN_0__EQ_AFE_GAIN_MASK                                          0x0078L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_EQ_ASIC_IN_0__RESERVED_MASK                                             0x0780L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_EQ_ASIC_IN_0__EQ_CTLE_BOOST_MASK                                        0xF800L
//DPCSSYS_CR0_LANE2_DIG_ASIC_RX_EQ_ASIC_IN_1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_EQ_ASIC_IN_1__EQ_DFE_TAP2__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_EQ_ASIC_IN_1__EQ_DFE_TAP1__SHIFT                                        0x7
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_EQ_ASIC_IN_1__RESERVED_15_15__SHIFT                                     0xf
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_EQ_ASIC_IN_1__EQ_DFE_TAP2_MASK                                          0x007FL
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_EQ_ASIC_IN_1__EQ_DFE_TAP1_MASK                                          0x7F80L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_EQ_ASIC_IN_1__RESERVED_15_15_MASK                                       0x8000L
//DPCSSYS_CR0_LANE2_DIG_ASIC_RX_CDR_VCO_ASIC_IN_0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_CDR_VCO_ASIC_IN_0__RX_CDR_VCO_LOWFREQ__SHIFT                            0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_CDR_VCO_ASIC_IN_0__RX_REF_LD_VAL__SHIFT                                 0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_CDR_VCO_ASIC_IN_0__RESERVED_15_8__SHIFT                                 0x8
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_CDR_VCO_ASIC_IN_0__RX_CDR_VCO_LOWFREQ_MASK                              0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_CDR_VCO_ASIC_IN_0__RX_REF_LD_VAL_MASK                                   0x00FEL
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_CDR_VCO_ASIC_IN_0__RESERVED_15_8_MASK                                   0xFF00L
//DPCSSYS_CR0_LANE2_DIG_ASIC_RX_CDR_VCO_ASIC_IN_1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_CDR_VCO_ASIC_IN_1__RX_VCO_LD_VAL__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_CDR_VCO_ASIC_IN_1__RESERVED_15_13__SHIFT                                0xd
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_CDR_VCO_ASIC_IN_1__RX_VCO_LD_VAL_MASK                                   0x1FFFL
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_CDR_VCO_ASIC_IN_1__RESERVED_15_13_MASK                                  0xE000L
//DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_OUT_0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_OUT_0__ACK__SHIFT                                                  0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_OUT_0__VALID__SHIFT                                                0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_OUT_0__ADAPT_STS__SHIFT                                            0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_OUT_0__RESERVED_15_4__SHIFT                                        0x4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_OUT_0__ACK_MASK                                                    0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_OUT_0__VALID_MASK                                                  0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_OUT_0__ADAPT_STS_MASK                                              0x000CL
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_ASIC_OUT_0__RESERVED_15_4_MASK                                          0xFFF0L
//DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_PWM_CLK_SEL__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_PWM_CLK_SEL_OVRD_EN__SHIFT                                0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_LCC_ON__SHIFT                                        0x3
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_LS_ON__SHIFT                                         0x4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_LS_LCC_ON_OVRD_EN__SHIFT                             0x5
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_CTL__SHIFT                                           0x6
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_CTL_OVRD_EN__SHIFT                                   0x8
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_PWM_EN__SHIFT                                             0x9
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_PWM_EN_OVRD_EN__SHIFT                                     0xa
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RESERVED_15_11__SHIFT                                        0xb
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_PWM_CLK_SEL_MASK                                          0x0003L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_PWM_CLK_SEL_OVRD_EN_MASK                                  0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_LCC_ON_MASK                                          0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_LS_ON_MASK                                           0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_LS_LCC_ON_OVRD_EN_MASK                               0x0020L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_CTL_MASK                                             0x00C0L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_TERM_CTL_OVRD_EN_MASK                                     0x0100L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_PWM_EN_MASK                                               0x0200L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RX_PWM_EN_OVRD_EN_MASK                                       0x0400L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_RX_OVRD_IN_6__RESERVED_15_11_MASK                                          0xF800L
//DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__RPTR_EN_MASTER_LANE__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__RPTR_EN_MASTER_LANE_OVRD_EN__SHIFT                           0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_EN_OTHER_LANE__SHIFT                                 0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_EN_OTHER_LANE_OVRD_EN__SHIFT                         0x3
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_STATE_MASTER_LANE__SHIFT                             0x4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_STATE_MASTER_LANE_OVRD_EN__SHIFT                     0x5
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__SHIFT_MASTER_LANE__SHIFT                                     0x6
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__SHIFT_MASTER_LANE_ORVD_EN__SHIFT                             0x7
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__SHIFT_ACK_OTHER_LANE__SHIFT                                  0x8
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__SHIFT_ACK_OTHER_LANE_OVRD_EN__SHIFT                          0x9
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__LANE_MASTER__SHIFT                                           0xa
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__LANE_MASTER_OVRD_IN_EN__SHIFT                                0xb
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__TX_DWORD_CLK_SYNC_OVRD__SHIFT                                0xc
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__TX_DWORD_CLK_SYNC_OVRD_EN__SHIFT                             0xd
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__RESERVED_15_14__SHIFT                                        0xe
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__RPTR_EN_MASTER_LANE_MASK                                     0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__RPTR_EN_MASTER_LANE_OVRD_EN_MASK                             0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_EN_OTHER_LANE_MASK                                   0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_EN_OTHER_LANE_OVRD_EN_MASK                           0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_STATE_MASTER_LANE_MASK                               0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_STATE_MASTER_LANE_OVRD_EN_MASK                       0x0020L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__SHIFT_MASTER_LANE_MASK                                       0x0040L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__SHIFT_MASTER_LANE_ORVD_EN_MASK                               0x0080L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__SHIFT_ACK_OTHER_LANE_MASK                                    0x0100L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__SHIFT_ACK_OTHER_LANE_OVRD_EN_MASK                            0x0200L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__LANE_MASTER_MASK                                             0x0400L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__LANE_MASTER_OVRD_IN_EN_MASK                                  0x0800L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__TX_DWORD_CLK_SYNC_OVRD_MASK                                  0x1000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__TX_DWORD_CLK_SYNC_OVRD_EN_MASK                               0x2000L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_IN_5__RESERVED_15_14_MASK                                          0xC000L
//DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__RPTR_EN_OUT__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__RPTR_EN_OUT_OVRD_EN__SHIFT                                  0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_EN_OUT__SHIFT                                       0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_EN_OUT_OVRD_EN__SHIFT                               0x3
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_STATE_OUT__SHIFT                                    0x4
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_STATE_OUT_OVRD_EN__SHIFT                            0x5
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_OUT__SHIFT                                            0x6
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_OUT_OVRD_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_ACK_OUT__SHIFT                                        0x8
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_ACK_OUT_OVRD_EN__SHIFT                                0x9
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__RESERVED_15_10__SHIFT                                       0xa
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__RPTR_EN_OUT_MASK                                            0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__RPTR_EN_OUT_OVRD_EN_MASK                                    0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_EN_OUT_MASK                                         0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_EN_OUT_OVRD_EN_MASK                                 0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_STATE_OUT_MASK                                      0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_STATE_OUT_OVRD_EN_MASK                              0x0020L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_OUT_MASK                                              0x0040L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_OUT_OVRD_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_ACK_OUT_MASK                                          0x0100L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_ACK_OUT_OVRD_EN_MASK                                  0x0200L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_TX_OVRD_OUT_1__RESERVED_15_10_MASK                                         0xFC00L
//DPCSSYS_CR0_LANE2_DIG_ASIC_OCLA
#define DPCSSYS_CR0_LANE2_DIG_ASIC_OCLA__RX_DWORD_OCLA_CLK_EN__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE2_DIG_ASIC_OCLA__RX_DWORD_OCLA_DATA_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE2_DIG_ASIC_OCLA__RESERVED_15_2__SHIFT                                                 0x2
#define DPCSSYS_CR0_LANE2_DIG_ASIC_OCLA__RX_DWORD_OCLA_CLK_EN_MASK                                            0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_OCLA__RX_DWORD_OCLA_DATA_EN_MASK                                           0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ASIC_OCLA__RESERVED_15_2_MASK                                                   0xFFFCL
//DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_REFGEN_EN__SHIFT                              0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_VCM_HOLD__SHIFT                               0x1
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_CLK_EN__SHIFT                                 0x2
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_WORD_CLK_EN__SHIFT                            0x3
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_RESET__SHIFT                                  0x4
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_SERIAL_EN__SHIFT                              0x5
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_DIG_CLK_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_DATA_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ALLOW_RXDET__SHIFT                                0x8
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_DCC_COMP_CAL_EN__SHIFT                        0x9
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__RESERVED_15_10__SHIFT                                   0xa
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_REFGEN_EN_MASK                                0x0001L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_VCM_HOLD_MASK                                 0x0002L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_CLK_EN_MASK                                   0x0004L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_WORD_CLK_EN_MASK                              0x0008L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_RESET_MASK                                    0x0010L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_SERIAL_EN_MASK                                0x0020L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_DIG_CLK_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_DATA_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ALLOW_RXDET_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_DCC_COMP_CAL_EN_MASK                          0x0200L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0__RESERVED_15_10_MASK                                     0xFC00L
//DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_REFGEN_EN__SHIFT                            0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_VCM_HOLD__SHIFT                             0x1
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_CLK_EN__SHIFT                               0x2
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_WORD_CLK_EN__SHIFT                          0x3
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_RESET__SHIFT                                0x4
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_SERIAL_EN__SHIFT                            0x5
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_DIG_CLK_EN__SHIFT                               0x6
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_DATA_EN__SHIFT                                  0x7
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ALLOW_RXDET__SHIFT                              0x8
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_DCC_COMP_CAL_EN__SHIFT                      0x9
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__RESERVED_15_10__SHIFT                                  0xa
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_REFGEN_EN_MASK                              0x0001L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_VCM_HOLD_MASK                               0x0002L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_CLK_EN_MASK                                 0x0004L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_WORD_CLK_EN_MASK                            0x0008L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_RESET_MASK                                  0x0010L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_SERIAL_EN_MASK                              0x0020L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_DIG_CLK_EN_MASK                                 0x0040L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_DATA_EN_MASK                                    0x0080L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ALLOW_RXDET_MASK                                0x0100L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_DCC_COMP_CAL_EN_MASK                        0x0200L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P0S__RESERVED_15_10_MASK                                    0xFC00L
//DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_REFGEN_EN__SHIFT                              0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_VCM_HOLD__SHIFT                               0x1
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_CLK_EN__SHIFT                                 0x2
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_WORD_CLK_EN__SHIFT                            0x3
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_RESET__SHIFT                                  0x4
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_SERIAL_EN__SHIFT                              0x5
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_DIG_CLK_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_DATA_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ALLOW_RXDET__SHIFT                                0x8
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_DCC_COMP_CAL_EN__SHIFT                        0x9
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__RESERVED_15_10__SHIFT                                   0xa
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_REFGEN_EN_MASK                                0x0001L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_VCM_HOLD_MASK                                 0x0002L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_CLK_EN_MASK                                   0x0004L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_WORD_CLK_EN_MASK                              0x0008L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_RESET_MASK                                    0x0010L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_SERIAL_EN_MASK                                0x0020L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_DIG_CLK_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_DATA_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ALLOW_RXDET_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_DCC_COMP_CAL_EN_MASK                          0x0200L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P1__RESERVED_15_10_MASK                                     0xFC00L
//DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_REFGEN_EN__SHIFT                              0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_VCM_HOLD__SHIFT                               0x1
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_CLK_EN__SHIFT                                 0x2
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_WORD_CLK_EN__SHIFT                            0x3
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_RESET__SHIFT                                  0x4
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_SERIAL_EN__SHIFT                              0x5
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_DIG_CLK_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_DATA_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ALLOW_RXDET__SHIFT                                0x8
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ALLOW_VBOOST__SHIFT                               0x9
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_DCC_COMP_CAL_EN__SHIFT                        0xa
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__RESERVED_15_11__SHIFT                                   0xb
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_REFGEN_EN_MASK                                0x0001L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_VCM_HOLD_MASK                                 0x0002L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_CLK_EN_MASK                                   0x0004L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_WORD_CLK_EN_MASK                              0x0008L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_RESET_MASK                                    0x0010L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_SERIAL_EN_MASK                                0x0020L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_DIG_CLK_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_DATA_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ALLOW_RXDET_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ALLOW_VBOOST_MASK                                 0x0200L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_DCC_COMP_CAL_EN_MASK                          0x0400L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PSTATE_P2__RESERVED_15_11_MASK                                     0xF800L
//DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_0__TX_REFGEN_EN_TIME__SHIFT                             0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_0__TX_CLK_EN__SHIFT                                     0x8
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_0__TX_REFGEN_EN_TIME_MASK                               0x00FFL
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_0__TX_CLK_EN_MASK                                       0xFF00L
//DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_1
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_1__TX_VCM_HOLD_TIME_14_0__SHIFT                         0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_1__SKIP_TX_VCM_HOLD_WAIT__SHIFT                         0xf
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_1__TX_VCM_HOLD_TIME_14_0_MASK                           0x7FFFL
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_1__SKIP_TX_VCM_HOLD_WAIT_MASK                           0x8000L
//DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_2
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_2__TX_VBOOST_DIS_TIME_12_0__SHIFT                       0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_2__DTB_SEL__SHIFT                                       0xd
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_2__TX_VBOOST_DIS_TIME_12_0_MASK                         0x1FFFL
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_2__DTB_SEL_MASK                                         0xE000L
//DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_3
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__TX_VCM_HOLD_TIME_17_15__SHIFT                        0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__TX_VBOOST_DIS_TIME_13__SHIFT                         0x3
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__RESERVED_15_4__SHIFT                                 0x4
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__TX_VCM_HOLD_TIME_17_15_MASK                          0x0007L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__TX_VBOOST_DIS_TIME_13_MASK                           0x0008L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__RESERVED_15_4_MASK                                   0xFFF0L
//DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_4
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_4__TX_VCM_HOLD_GS_TIME__SHIFT                           0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_4__SKIP_TX_VCM_HOLD_GS_PULSE__SHIFT                     0xf
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_4__TX_VCM_HOLD_GS_TIME_MASK                             0x7FFFL
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_4__SKIP_TX_VCM_HOLD_GS_PULSE_MASK                       0x8000L
//DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_5
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_RXDET_TIME__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__FAST_TX_RXDET__SHIFT                                 0xa
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_RESET_TIME__SHIFT                                 0xb
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_SERIAL_EN_TIME__SHIFT                             0xd
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__RESERVED_15_15__SHIFT                                0xf
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_RXDET_TIME_MASK                                   0x03FFL
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__FAST_TX_RXDET_MASK                                   0x0400L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_RESET_TIME_MASK                                   0x1800L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_SERIAL_EN_TIME_MASK                               0x6000L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__RESERVED_15_15_MASK                                  0x8000L
//DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_CR_BANK_ADDR
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_CR_BANK_ADDR__ADDR__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_CR_BANK_ADDR__ADDR_MASK                                           0xFFFFL
//DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_CR_BANK_DATA
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_CR_BANK_DATA__DATA__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_CR_BANK_DATA__DATA_MASK                                           0xFFFFL
//DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_CTRL
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_CTRL__CTRL__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_CTRL__RESERVED_15_8__SHIFT                                    0x8
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_CTRL__CTRL_MASK                                               0x00FFL
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_CTRL__RESERVED_15_8_MASK                                      0xFF00L
//DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_RANGE
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_RANGE__CTRL__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_RANGE__RESERVED_15_2__SHIFT                                   0x2
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_RANGE__CTRL_MASK                                              0x0003L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_RANGE__RESERVED_15_2_MASK                                     0xFFFCL
//DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_SEL
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_SEL__SEL__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_SEL__REQ__SHIFT                                               0x3
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_SEL__CTRL_UPD__SHIFT                                          0x4
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_SEL__RANGE_UPD__SHIFT                                         0x5
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_SEL__BIN_HOT__SHIFT                                           0x6
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_SEL__SEL_MASK                                                 0x0007L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_SEL__REQ_MASK                                                 0x0008L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_SEL__CTRL_UPD_MASK                                            0x0010L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_SEL__RANGE_UPD_MASK                                           0x0020L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_SEL__BIN_HOT_MASK                                             0x0040L
//DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_ACK
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_ACK__ACK__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_ACK__RESERVED_15_1__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_ACK__ACK_MASK                                                 0x0001L
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_ACK__RESERVED_15_1_MASK                                       0xFFFEL
//DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_ADDR
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_ADDR__ADDR__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_PWRCTL_DCC_DAC_ADDR__ADDR_MASK                                               0xFFFFL
//DPCSSYS_CR0_LANE2_DIG_TX_CLK_ALIGN_TX_CTL_0
#define DPCSSYS_CR0_LANE2_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_NUM_2UI_SHIFTS_16B_MODE__SHIFT                        0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_NUM_2UI_SHIFTS_20B_MODE__SHIFT                        0x4
#define DPCSSYS_CR0_LANE2_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_FIFO_BYPASS__SHIFT                                    0x8
#define DPCSSYS_CR0_LANE2_DIG_TX_CLK_ALIGN_TX_CTL_0__RESERVED_15_9__SHIFT                                     0x9
#define DPCSSYS_CR0_LANE2_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_NUM_2UI_SHIFTS_16B_MODE_MASK                          0x000FL
#define DPCSSYS_CR0_LANE2_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_NUM_2UI_SHIFTS_20B_MODE_MASK                          0x00F0L
#define DPCSSYS_CR0_LANE2_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_FIFO_BYPASS_MASK                                      0x0100L
#define DPCSSYS_CR0_LANE2_DIG_TX_CLK_ALIGN_TX_CTL_0__RESERVED_15_9_MASK                                       0xFE00L
//DPCSSYS_CR0_LANE2_DIG_TX_LBERT_CTL
#define DPCSSYS_CR0_LANE2_DIG_TX_LBERT_CTL__MODE__SHIFT                                                       0x0
#define DPCSSYS_CR0_LANE2_DIG_TX_LBERT_CTL__TRIGGER_ERR__SHIFT                                                0x4
#define DPCSSYS_CR0_LANE2_DIG_TX_LBERT_CTL__PAT0__SHIFT                                                       0x5
#define DPCSSYS_CR0_LANE2_DIG_TX_LBERT_CTL__RESERVED_15_15__SHIFT                                             0xf
#define DPCSSYS_CR0_LANE2_DIG_TX_LBERT_CTL__MODE_MASK                                                         0x000FL
#define DPCSSYS_CR0_LANE2_DIG_TX_LBERT_CTL__TRIGGER_ERR_MASK                                                  0x0010L
#define DPCSSYS_CR0_LANE2_DIG_TX_LBERT_CTL__PAT0_MASK                                                         0x7FE0L
#define DPCSSYS_CR0_LANE2_DIG_TX_LBERT_CTL__RESERVED_15_15_MASK                                               0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_AFE_EN__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_CLK_VREG_EN__SHIFT                            0x1
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RESERVED_1__SHIFT                                       0x2
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_CLK_EN__SHIFT                                 0x3
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RESERVED_0__SHIFT                                       0x4
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_DESER_EN__SHIFT                               0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_CDR_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_VCO_FREQ_RST__SHIFT                               0x7
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_VCO_CAL_RST__SHIFT                                0x8
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_VCO_CONTCAL_EN__SHIFT                             0x9
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_DIG_CLK_EN__SHIFT                                 0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RESERVED_15_11__SHIFT                                   0xb
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_AFE_EN_MASK                                   0x0001L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_CLK_VREG_EN_MASK                              0x0002L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RESERVED_1_MASK                                         0x0004L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_CLK_EN_MASK                                   0x0008L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RESERVED_0_MASK                                         0x0010L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_DESER_EN_MASK                                 0x0020L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_ANA_CDR_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_VCO_FREQ_RST_MASK                                 0x0080L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_VCO_CAL_RST_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_VCO_CONTCAL_EN_MASK                               0x0200L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RX_P0_DIG_CLK_EN_MASK                                   0x0400L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0__RESERVED_15_11_MASK                                     0xF800L
//DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_AFE_EN__SHIFT                               0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_CLK_VREG_EN__SHIFT                          0x1
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RESERVED_2__SHIFT                                      0x2
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_CLK_EN__SHIFT                               0x3
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RESERVED_4__SHIFT                                      0x4
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_DESER_EN__SHIFT                             0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_CDR_EN__SHIFT                               0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_VCO_FREQ_RST__SHIFT                             0x7
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_VCO_CAL_RST__SHIFT                              0x8
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_VCO_CONTCAL_EN__SHIFT                           0x9
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_DIG_CLK_EN__SHIFT                               0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RESERVED_15_11__SHIFT                                  0xb
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_AFE_EN_MASK                                 0x0001L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_CLK_VREG_EN_MASK                            0x0002L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RESERVED_2_MASK                                        0x0004L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_CLK_EN_MASK                                 0x0008L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RESERVED_4_MASK                                        0x0010L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_DESER_EN_MASK                               0x0020L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_ANA_CDR_EN_MASK                                 0x0040L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_VCO_FREQ_RST_MASK                               0x0080L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_VCO_CAL_RST_MASK                                0x0100L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_VCO_CONTCAL_EN_MASK                             0x0200L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RX_P0S_DIG_CLK_EN_MASK                                 0x0400L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P0S__RESERVED_15_11_MASK                                    0xF800L
//DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_AFE_EN__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_CLK_VREG_EN__SHIFT                            0x1
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RESERVED_2__SHIFT                                       0x2
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_CLK_EN__SHIFT                                 0x3
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RESERVED_4__SHIFT                                       0x4
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_DESER_EN__SHIFT                               0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_CDR_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_VCO_FREQ_RST__SHIFT                               0x7
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_VCO_CAL_RST__SHIFT                                0x8
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_VCO_CONTCAL_EN__SHIFT                             0x9
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_DIG_CLK_EN__SHIFT                                 0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RESERVED_15_11__SHIFT                                   0xb
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_AFE_EN_MASK                                   0x0001L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_CLK_VREG_EN_MASK                              0x0002L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RESERVED_2_MASK                                         0x0004L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_CLK_EN_MASK                                   0x0008L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RESERVED_4_MASK                                         0x0010L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_DESER_EN_MASK                                 0x0020L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_ANA_CDR_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_VCO_FREQ_RST_MASK                                 0x0080L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_VCO_CAL_RST_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_VCO_CONTCAL_EN_MASK                               0x0200L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RX_P1_DIG_CLK_EN_MASK                                   0x0400L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P1__RESERVED_15_11_MASK                                     0xF800L
//DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_AFE_EN__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_CLK_VREG_EN__SHIFT                            0x1
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RESERVED_2__SHIFT                                       0x2
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_CLK_EN__SHIFT                                 0x3
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RESERVED_4__SHIFT                                       0x4
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_DESER_EN__SHIFT                               0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_CDR_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_VCO_FREQ_RST__SHIFT                               0x7
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_VCO_CAL_RST__SHIFT                                0x8
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_VCO_CONTCAL_EN__SHIFT                             0x9
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_DIG_CLK_EN__SHIFT                                 0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RESERVED_15_11__SHIFT                                   0xb
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_AFE_EN_MASK                                   0x0001L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_CLK_VREG_EN_MASK                              0x0002L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RESERVED_2_MASK                                         0x0004L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_CLK_EN_MASK                                   0x0008L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RESERVED_4_MASK                                         0x0010L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_DESER_EN_MASK                                 0x0020L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_ANA_CDR_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_VCO_FREQ_RST_MASK                                 0x0080L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_VCO_CAL_RST_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_VCO_CONTCAL_EN_MASK                               0x0200L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RX_P2_DIG_CLK_EN_MASK                                   0x0400L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PSTATE_P2__RESERVED_15_11_MASK                                     0xF800L
//DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_1
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__RX_AFE_EN_TIME__SHIFT                                0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__FAST_RX_AFE_EN__SHIFT                                0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__RX_VREG_EN_TIME__SHIFT                               0x7
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__FAST_RX_VREG_EN__SHIFT                               0xd
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__RESERVED_15_14__SHIFT                                0xe
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__RX_AFE_EN_TIME_MASK                                  0x003FL
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__FAST_RX_AFE_EN_MASK                                  0x0040L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__RX_VREG_EN_TIME_MASK                                 0x1F80L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__FAST_RX_VREG_EN_MASK                                 0x2000L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_1__RESERVED_15_14_MASK                                  0xC000L
//DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_2
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_2__RX_CLK_EN_TIME__SHIFT                                0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_2__FAST_RX_CLK_EN__SHIFT                                0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_2__RX_FAST_START_TIME__SHIFT                            0x7
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_2__RESERVED_15_11__SHIFT                                0xb
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_2__RX_CLK_EN_TIME_MASK                                  0x003FL
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_2__FAST_RX_CLK_EN_MASK                                  0x0040L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_2__RX_FAST_START_TIME_MASK                              0x0780L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_2__RESERVED_15_11_MASK                                  0xF800L
//DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_3
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RX_RATE_TIME__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RSVD_3_7_2__SHIFT                                    0x2
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RX_CDR_EN_TIME__SHIFT                                0x8
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RX_DESER_EN_TIME__SHIFT                              0xc
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RX_DESER_DIS_TIME__SHIFT                             0xe
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RX_RATE_TIME_MASK                                    0x0003L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RSVD_3_7_2_MASK                                      0x00FCL
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RX_CDR_EN_TIME_MASK                                  0x0F00L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RX_DESER_EN_TIME_MASK                                0x3000L
#define DPCSSYS_CR0_LANE2_DIG_RX_PWRCTL_RX_PWRUP_TIME_3__RX_DESER_DIS_TIME_MASK                               0xC000L
//DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__INT_GAIN_CAL_FIXED_CNT__SHIFT                      0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__INT_GAIN_CAL_FIXED_CNT_EN__SHIFT                   0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__INT_GAIN_CAL_CNT_SHIFT__SHIFT                      0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__INT_GAIN_CAL_BOUNCE_CNT__SHIFT                     0x9
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__DISABLE_BIN_HOLD__SHIFT                            0xc
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__DISABLE_INT_GAIN_HOLD__SHIFT                       0xd
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__DISABLE_COARSE_CALDONE__SHIFT                      0xe
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__RESERVED_15_15__SHIFT                              0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__INT_GAIN_CAL_FIXED_CNT_MASK                        0x001FL
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__INT_GAIN_CAL_FIXED_CNT_EN_MASK                     0x0020L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__INT_GAIN_CAL_CNT_SHIFT_MASK                        0x01C0L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__INT_GAIN_CAL_BOUNCE_CNT_MASK                       0x0E00L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__DISABLE_BIN_HOLD_MASK                              0x1000L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__DISABLE_INT_GAIN_HOLD_MASK                         0x2000L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__DISABLE_COARSE_CALDONE_MASK                        0x4000L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_0__RESERVED_15_15_MASK                                0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__RX_VCO_OVRD_SEL__SHIFT                             0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__RX_VCO_FREQ_RST__SHIFT                             0x1
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__RX_VCO_CAL_RST__SHIFT                              0x2
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__RX_VCO_CONTCAL_EN__SHIFT                           0x3
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__DISABLE_INT_CAL_MODE__SHIFT                        0x4
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__DPLL_CAL_UG__SHIFT                                 0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__DTB_SEL__SHIFT                                     0x9
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__RX_VCO_OVRD_SEL_MASK                               0x0001L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__RX_VCO_FREQ_RST_MASK                               0x0002L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__RX_VCO_CAL_RST_MASK                                0x0004L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__RX_VCO_CONTCAL_EN_MASK                             0x0008L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__DISABLE_INT_CAL_MODE_MASK                          0x0010L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__DPLL_CAL_UG_MASK                                   0x01E0L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_1__DTB_SEL_MASK                                       0xFE00L
//DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2__FREQ_TUNE_START_VAL__SHIFT                         0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2__FREQ_TUNE_CAL_STEPS__SHIFT                         0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2__SKIP_RX_VCO_FREQ_TUNE_CAL__SHIFT                   0xe
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2__SKIP_RX_VCO_CAL__SHIFT                             0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2__FREQ_TUNE_START_VAL_MASK                           0x03FFL
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2__FREQ_TUNE_CAL_STEPS_MASK                           0x3C00L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2__SKIP_RX_VCO_FREQ_TUNE_CAL_MASK                     0x4000L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_CTRL_2__SKIP_RX_VCO_CAL_MASK                               0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0__RX_VCO_STARTUP_TIME__SHIFT                         0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0__RX_VCO_UPDATE_TIME__SHIFT                          0x7
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0__RX_VCO_CNTR_PWRUP_TIME__SHIFT                      0xb
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0__FAST_RX_VCO_WAIT__SHIFT                            0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0__RX_VCO_STARTUP_TIME_MASK                           0x007FL
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0__RX_VCO_UPDATE_TIME_MASK                            0x0780L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0__RX_VCO_CNTR_PWRUP_TIME_MASK                        0x7800L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_0__FAST_RX_VCO_WAIT_MASK                              0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_1
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_1__RX_VCO_CNTR_SETTLE_TIME__SHIFT                     0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_1__RESERVED_15_3__SHIFT                               0x3
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_1__RX_VCO_CNTR_SETTLE_TIME_MASK                       0x0007L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_CAL_TIME_1__RESERVED_15_3_MASK                                 0xFFF8L
//DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_0
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_CDR_FREQ_TUNE__SHIFT                            0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_VCO_CNTR_PD__SHIFT                              0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_VCO_CNTR_EN__SHIFT                              0xb
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_CDR_STARTUP__SHIFT                              0xc
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_CDR_VCO_EN__SHIFT                               0xd
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_0__RESERVED_15_14__SHIFT                                  0xe
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_CDR_FREQ_TUNE_MASK                              0x03FFL
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_VCO_CNTR_PD_MASK                                0x0400L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_VCO_CNTR_EN_MASK                                0x0800L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_CDR_STARTUP_MASK                                0x1000L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_0__RX_ANA_CDR_VCO_EN_MASK                                 0x2000L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_0__RESERVED_15_14_MASK                                    0xC000L
//DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_1
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_FSM_STATE__SHIFT                                0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_FREQ_RST__SHIFT                                 0x4
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_CAL_RST__SHIFT                                  0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_CONTCAL_EN__SHIFT                               0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_CAL_DONE__SHIFT                                 0x7
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_1__DPLL_FREQ_RST__SHIFT                                   0x8
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_1__RESERVED_15_9__SHIFT                                   0x9
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_FSM_STATE_MASK                                  0x000FL
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_FREQ_RST_MASK                                   0x0010L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_CAL_RST_MASK                                    0x0020L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_CONTCAL_EN_MASK                                 0x0040L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_1__RX_VCO_CAL_DONE_MASK                                   0x0080L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_1__DPLL_FREQ_RST_MASK                                     0x0100L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_1__RESERVED_15_9_MASK                                     0xFE00L
//DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_2
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_2__VCO_CNTR_FINAL__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_2__VCOCLK_TOO_FAST__SHIFT                                 0xd
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_2__RX_VCO_CORRECT__SHIFT                                  0xe
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_2__RX_VCO_UP__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_2__VCO_CNTR_FINAL_MASK                                    0x1FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_2__VCOCLK_TOO_FAST_MASK                                   0x2000L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_2__RX_VCO_CORRECT_MASK                                    0x4000L
#define DPCSSYS_CR0_LANE2_DIG_RX_VCOCAL_RX_VCO_STAT_2__RX_VCO_UP_MASK                                         0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_RX_ALIGN_XAUI_COMM_MASK
#define DPCSSYS_CR0_LANE2_DIG_RX_RX_ALIGN_XAUI_COMM_MASK__XAUI_COMM_MASK__SHIFT                               0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_RX_ALIGN_XAUI_COMM_MASK__RESERVED_15_10__SHIFT                               0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_RX_ALIGN_XAUI_COMM_MASK__XAUI_COMM_MASK_MASK                                 0x03FFL
#define DPCSSYS_CR0_LANE2_DIG_RX_RX_ALIGN_XAUI_COMM_MASK__RESERVED_15_10_MASK                                 0xFC00L
//DPCSSYS_CR0_LANE2_DIG_RX_LBERT_CTL
#define DPCSSYS_CR0_LANE2_DIG_RX_LBERT_CTL__MODE__SHIFT                                                       0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_LBERT_CTL__SYNC__SHIFT                                                       0x4
#define DPCSSYS_CR0_LANE2_DIG_RX_LBERT_CTL__RESERVED_15_5__SHIFT                                              0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_LBERT_CTL__MODE_MASK                                                         0x000FL
#define DPCSSYS_CR0_LANE2_DIG_RX_LBERT_CTL__SYNC_MASK                                                         0x0010L
#define DPCSSYS_CR0_LANE2_DIG_RX_LBERT_CTL__RESERVED_15_5_MASK                                                0xFFE0L
//DPCSSYS_CR0_LANE2_DIG_RX_LBERT_ERR
#define DPCSSYS_CR0_LANE2_DIG_RX_LBERT_ERR__COUNT__SHIFT                                                      0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_LBERT_ERR__OV14__SHIFT                                                       0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_LBERT_ERR__COUNT_MASK                                                        0x7FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_LBERT_ERR__OV14_MASK                                                         0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_0
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_0__PHDET_EN__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_0__PHDET_EDGE__SHIFT                                             0x2
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_0__PHDET_POL__SHIFT                                              0x4
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_0__PHDET_EN_PR_MODE__SHIFT                                       0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_0__ALWAYS_REALIGN__SHIFT                                         0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_0__DTB_SEL__SHIFT                                                0x7
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_0__RESERVED_15_11__SHIFT                                         0xb
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_0__PHDET_EN_MASK                                                 0x0003L
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_0__PHDET_EDGE_MASK                                               0x000CL
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_0__PHDET_POL_MASK                                                0x0010L
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_0__PHDET_EN_PR_MODE_MASK                                         0x0020L
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_0__ALWAYS_REALIGN_MASK                                           0x0040L
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_0__DTB_SEL_MASK                                                  0x0780L
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_0__RESERVED_15_11_MASK                                           0xF800L
//DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_1
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_1__SSC_OFF_CNT0__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_1__SSC_OFF_CNT1__SHIFT                                           0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_1__SSC_OFF_CNT0_MASK                                             0x03FFL
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_1__SSC_OFF_CNT1_MASK                                             0xFC00L
//DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_2
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_2__SSC_ON_CNT0__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_2__SSC_ON_CNT1__SHIFT                                            0x9
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_2__SSC_ON_CNT0_MASK                                              0x01FFL
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_2__SSC_ON_CNT1_MASK                                              0xFE00L
//DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_3
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_3__SSC_OFF_PHUG0__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_3__SSC_OFF_PHUG1__SHIFT                                          0x3
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_3__SSC_OFF_FRUG0__SHIFT                                          0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_3__OVRD_DPLL_GAIN__SHIFT                                         0x9
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_3__PHUG_OVRD_VALUE__SHIFT                                        0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_3__FRUG_OVRD_VALUE__SHIFT                                        0xd
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_3__SSC_OFF_PHUG0_MASK                                            0x0007L
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_3__SSC_OFF_PHUG1_MASK                                            0x0038L
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_3__SSC_OFF_FRUG0_MASK                                            0x01C0L
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_3__OVRD_DPLL_GAIN_MASK                                           0x0200L
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_3__PHUG_OVRD_VALUE_MASK                                          0x1C00L
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_3__FRUG_OVRD_VALUE_MASK                                          0xE000L
//DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_4
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_4__SSC_OFF_FRUG1__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_4__SSC_ON_FRUG0__SHIFT                                           0x3
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_4__SSC_ON_FRUG1__SHIFT                                           0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_4__SSC_ON_PHUG0__SHIFT                                           0x9
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_4__SSC_ON_PHUG1__SHIFT                                           0xc
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_4__RESERVED_15_15__SHIFT                                         0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_4__SSC_OFF_FRUG1_MASK                                            0x0007L
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_4__SSC_ON_FRUG0_MASK                                             0x0038L
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_4__SSC_ON_FRUG1_MASK                                             0x01C0L
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_4__SSC_ON_PHUG0_MASK                                             0x0E00L
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_4__SSC_ON_PHUG1_MASK                                             0x7000L
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_CDR_CTL_4__RESERVED_15_15_MASK                                           0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_CDR_STAT
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_STAT__PHUG_VALUE__SHIFT                                                  0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_STAT__FRUG_VALUE__SHIFT                                                  0x3
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_STAT__RESERVED_15_6__SHIFT                                               0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_STAT__PHUG_VALUE_MASK                                                    0x0007L
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_STAT__FRUG_VALUE_MASK                                                    0x0038L
#define DPCSSYS_CR0_LANE2_DIG_RX_CDR_STAT__RESERVED_15_6_MASK                                                 0xFFC0L
//DPCSSYS_CR0_LANE2_DIG_RX_DPLL_FREQ
#define DPCSSYS_CR0_LANE2_DIG_RX_DPLL_FREQ__VAL__SHIFT                                                        0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_DPLL_FREQ__RESERVED_15_14__SHIFT                                             0xe
#define DPCSSYS_CR0_LANE2_DIG_RX_DPLL_FREQ__VAL_MASK                                                          0x3FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_DPLL_FREQ__RESERVED_15_14_MASK                                               0xC000L
//DPCSSYS_CR0_LANE2_DIG_RX_DPLL_FREQ_BOUND_0
#define DPCSSYS_CR0_LANE2_DIG_RX_DPLL_FREQ_BOUND_0__FREQ_BOUND_EN__SHIFT                                      0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_DPLL_FREQ_BOUND_0__UPPER_FREQ_BOUND__SHIFT                                   0x1
#define DPCSSYS_CR0_LANE2_DIG_RX_DPLL_FREQ_BOUND_0__RESERVED_15_11__SHIFT                                     0xb
#define DPCSSYS_CR0_LANE2_DIG_RX_DPLL_FREQ_BOUND_0__FREQ_BOUND_EN_MASK                                        0x0001L
#define DPCSSYS_CR0_LANE2_DIG_RX_DPLL_FREQ_BOUND_0__UPPER_FREQ_BOUND_MASK                                     0x07FEL
#define DPCSSYS_CR0_LANE2_DIG_RX_DPLL_FREQ_BOUND_0__RESERVED_15_11_MASK                                       0xF800L
//DPCSSYS_CR0_LANE2_DIG_RX_DPLL_FREQ_BOUND_1
#define DPCSSYS_CR0_LANE2_DIG_RX_DPLL_FREQ_BOUND_1__LOWER_FREQ_BOUND__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_DPLL_FREQ_BOUND_1__RESERVED_15_10__SHIFT                                     0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_DPLL_FREQ_BOUND_1__LOWER_FREQ_BOUND_MASK                                     0x03FFL
#define DPCSSYS_CR0_LANE2_DIG_RX_DPLL_FREQ_BOUND_1__RESERVED_15_10_MASK                                       0xFC00L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_0__N_TOP_ASM1__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_0__N_TGG_ASM1__SHIFT                                        0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_0__START_ASM1__SHIFT                                        0xe
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_0__ADPT_CLK_DIV4_EN__SHIFT                                  0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_0__N_TOP_ASM1_MASK                                          0x03FFL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_0__N_TGG_ASM1_MASK                                          0x3C00L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_0__START_ASM1_MASK                                          0x4000L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_0__ADPT_CLK_DIV4_EN_MASK                                    0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_1
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_1__N_WAIT_ASM1__SHIFT                                       0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_1__FAST_AFE_DFE_SETTLE__SHIFT                               0x7
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_1__CTLE_POLE_OVRD_VAL__SHIFT                                0x8
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_1__CTLE_POLE_OVRD_EN__SHIFT                                 0xb
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_1__RESERVED_15_12__SHIFT                                    0xc
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_1__N_WAIT_ASM1_MASK                                         0x007FL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_1__FAST_AFE_DFE_SETTLE_MASK                                 0x0080L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_1__CTLE_POLE_OVRD_VAL_MASK                                  0x0700L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_1__CTLE_POLE_OVRD_EN_MASK                                   0x0800L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_1__RESERVED_15_12_MASK                                      0xF000L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_2
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_2__TGG_PTTRN_0__SHIFT                                       0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_2__TGG_PTTRN_1__SHIFT                                       0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_2__TGG_PTTRN_0_MASK                                         0x001FL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_2__TGG_PTTRN_1_MASK                                         0x03E0L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_3
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_3__CTLE_EN__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_3__VGA_EN__SHIFT                                            0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_3__ATT_EN__SHIFT                                            0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_3__DFE_EN__SHIFT                                            0x7
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_3__EYEHE_EN__SHIFT                                          0xc
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_3__EYEHO_EN__SHIFT                                          0xd
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_3__TGG_EN__SHIFT                                            0xe
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_3__ESL_TWICE_DSL__SHIFT                                     0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_3__CTLE_EN_MASK                                             0x001FL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_3__VGA_EN_MASK                                              0x0020L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_3__ATT_EN_MASK                                              0x0040L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_3__DFE_EN_MASK                                              0x0F80L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_3__EYEHE_EN_MASK                                            0x1000L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_3__EYEHO_EN_MASK                                            0x2000L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_3__TGG_EN_MASK                                              0x4000L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_3__ESL_TWICE_DSL_MASK                                       0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_4
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_4__CTLE_TH__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_4__VGA_TH__SHIFT                                            0x4
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_4__DFE1_TH__SHIFT                                           0x8
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_4__DFE2_TH__SHIFT                                           0xc
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_4__CTLE_TH_MASK                                             0x000FL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_4__VGA_TH_MASK                                              0x00F0L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_4__DFE1_TH_MASK                                             0x0F00L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_4__DFE2_TH_MASK                                             0xF000L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_5
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_5__DFE3_TH__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_5__DFE4_TH__SHIFT                                           0x4
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_5__DFE5_TH__SHIFT                                           0x8
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_5__TH_OFFSET__SHIFT                                         0xc
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_5__DFE3_TH_MASK                                             0x000FL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_5__DFE4_TH_MASK                                             0x00F0L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_5__DFE5_TH_MASK                                             0x0F00L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_5__TH_OFFSET_MASK                                           0xF000L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_6
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_6__CTLE_MU__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_6__VGA_MU__SHIFT                                            0x3
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_6__ATT_MU__SHIFT                                            0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_6__VGA_SAT_CNT__SHIFT                                       0x9
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_6__VGA_SAT_CNT_STICKY__SHIFT                                0xc
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_6__ATT_LOW_TH__SHIFT                                        0xd
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_6__CTLE_MU_MASK                                             0x0007L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_6__VGA_MU_MASK                                              0x0038L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_6__ATT_MU_MASK                                              0x01C0L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_6__VGA_SAT_CNT_MASK                                         0x0E00L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_6__VGA_SAT_CNT_STICKY_MASK                                  0x1000L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_6__ATT_LOW_TH_MASK                                          0xE000L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_7
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_7__VGA_MIN_SAT__SHIFT                                       0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_7__VGA_LEV_HIGH__SHIFT                                      0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_7__VGA_LEV_LOW__SHIFT                                       0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_7__RESERVED_15_15__SHIFT                                    0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_7__VGA_MIN_SAT_MASK                                         0x001FL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_7__VGA_LEV_HIGH_MASK                                        0x03E0L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_7__VGA_LEV_LOW_MASK                                         0x7C00L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_7__RESERVED_15_15_MASK                                      0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_8
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE1_MU__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE2_MU__SHIFT                                           0x3
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE3_MU__SHIFT                                           0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE4_MU__SHIFT                                           0x9
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE5_MU__SHIFT                                           0xc
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_8__RESERVED_15_15__SHIFT                                    0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE1_MU_MASK                                             0x0007L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE2_MU_MASK                                             0x0038L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE3_MU_MASK                                             0x01C0L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE4_MU_MASK                                             0x0E00L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_8__DFE5_MU_MASK                                             0x7000L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_8__RESERVED_15_15_MASK                                      0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_9
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_9__ERR_SLE_ADPT_INIT__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_9__ERR_SLO_ADPT_INIT__SHIFT                                 0x8
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_9__ERR_SLE_ADPT_INIT_MASK                                   0x00FFL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_CFG_9__ERR_SLO_ADPT_INIT_MASK                                   0xFF00L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RST_ADPT_CFG
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_ATT__SHIFT                                    0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_VGA__SHIFT                                    0x1
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_CTLE_BOOST__SHIFT                             0x2
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_CTLE_POLE__SHIFT                              0x3
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_TAP1__SHIFT                                   0x4
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_ATT_MASK                                      0x0001L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_VGA_MASK                                      0x0002L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_CTLE_BOOST_MASK                               0x0004L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_CTLE_POLE_MASK                                0x0008L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RST_ADPT_CFG__RST_ADPT_TAP1_MASK                                     0x0010L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ATT_STATUS
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ATT_STATUS__ATT_ADPT_CODE__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ATT_STATUS__ASM1_DON__SHIFT                                          0x8
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ATT_STATUS__RESERVED_15_9__SHIFT                                     0x9
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ATT_STATUS__ATT_ADPT_CODE_MASK                                       0x00FFL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ATT_STATUS__ASM1_DON_MASK                                            0x0100L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ATT_STATUS__RESERVED_15_9_MASK                                       0xFE00L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_VGA_STATUS
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_VGA_STATUS__VGA_ADPT_CODE__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_VGA_STATUS__ASM1_DONE__SHIFT                                         0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_VGA_STATUS__RESERVED_15_11__SHIFT                                    0xb
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_VGA_STATUS__VGA_ADPT_CODE_MASK                                       0x03FFL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_VGA_STATUS__ASM1_DONE_MASK                                           0x0400L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_VGA_STATUS__RESERVED_15_11_MASK                                      0xF800L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_CTLE_STATUS
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_CTLE_STATUS__CTLE_BOOST_ADPT_CODE__SHIFT                             0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_CTLE_STATUS__CTLE_POLE_ADPT_CODE__SHIFT                              0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_CTLE_STATUS__ASM1_DONE__SHIFT                                        0xd
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_CTLE_STATUS__RESERVED_15_14__SHIFT                                   0xe
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_CTLE_STATUS__CTLE_BOOST_ADPT_CODE_MASK                               0x03FFL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_CTLE_STATUS__CTLE_POLE_ADPT_CODE_MASK                                0x1C00L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_CTLE_STATUS__ASM1_DONE_MASK                                          0x2000L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_CTLE_STATUS__RESERVED_15_14_MASK                                     0xC000L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_TAP1_STATUS
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_TAP1_STATUS__DFE_TAP1_ADPT_CODE__SHIFT                           0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_TAP1_STATUS__ASM1_DONE__SHIFT                                    0xd
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_TAP1_STATUS__RESERVED_15_14__SHIFT                               0xe
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_TAP1_STATUS__DFE_TAP1_ADPT_CODE_MASK                             0x1FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_TAP1_STATUS__ASM1_DONE_MASK                                      0x2000L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_TAP1_STATUS__RESERVED_15_14_MASK                                 0xC000L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_TAP2_STATUS
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_TAP2_STATUS__DFE_TAP2_ADPT_CODE__SHIFT                           0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_TAP2_STATUS__ASM1_DONE__SHIFT                                    0xc
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_TAP2_STATUS__RESERVED_15_13__SHIFT                               0xd
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_TAP2_STATUS__DFE_TAP2_ADPT_CODE_MASK                             0x0FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_TAP2_STATUS__ASM1_DONE_MASK                                      0x1000L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_TAP2_STATUS__RESERVED_15_13_MASK                                 0xE000L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_DATA_EVEN_VDAC_OFST
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_DATA_EVEN_VDAC_OFST__DFE_DATA_EVEN_VDAC_OFST__SHIFT              0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_DATA_EVEN_VDAC_OFST__RESERVED_15_8__SHIFT                        0x8
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_DATA_EVEN_VDAC_OFST__DFE_DATA_EVEN_VDAC_OFST_MASK                0x00FFL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_DATA_EVEN_VDAC_OFST__RESERVED_15_8_MASK                          0xFF00L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_DATA_ODD_VDAC_OFST
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_DATA_ODD_VDAC_OFST__DFE_DATA_ODD_VDAC_OFST__SHIFT                0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_DATA_ODD_VDAC_OFST__RESERVED_15_8__SHIFT                         0x8
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_DATA_ODD_VDAC_OFST__DFE_DATA_ODD_VDAC_OFST_MASK                  0x00FFL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_DATA_ODD_VDAC_OFST__RESERVED_15_8_MASK                           0xFF00L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RX_SLICER_CTRL_EVEN
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RX_SLICER_CTRL_EVEN__RX_ANA_SLICER_CTRL_E__SHIFT                     0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RX_SLICER_CTRL_EVEN__RESERVED_15_4__SHIFT                            0x4
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RX_SLICER_CTRL_EVEN__RX_ANA_SLICER_CTRL_E_MASK                       0x000FL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RX_SLICER_CTRL_EVEN__RESERVED_15_4_MASK                              0xFFF0L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RX_SLICER_CTRL_ODD
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RX_SLICER_CTRL_ODD__RX_ANA_SLICER_CTRL_O__SHIFT                      0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RX_SLICER_CTRL_ODD__RESERVED_15_4__SHIFT                             0x4
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RX_SLICER_CTRL_ODD__RX_ANA_SLICER_CTRL_O_MASK                        0x000FL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_RX_SLICER_CTRL_ODD__RESERVED_15_4_MASK                               0xFFF0L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_ERROR_EVEN_VDAC_OFST
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_ERROR_EVEN_VDAC_OFST__DFE_ERROR_EVEN_VDAC_OFST__SHIFT            0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_ERROR_EVEN_VDAC_OFST__RESERVED_15_8__SHIFT                       0x8
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_ERROR_EVEN_VDAC_OFST__DFE_ERROR_EVEN_VDAC_OFST_MASK              0x00FFL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_ERROR_EVEN_VDAC_OFST__RESERVED_15_8_MASK                         0xFF00L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_ERROR_ODD_VDAC_OFST
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_ERROR_ODD_VDAC_OFST__DFE_ERROR_ODD_VDAC_OFST__SHIFT              0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_ERROR_ODD_VDAC_OFST__RESERVED_15_8__SHIFT                        0x8
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_ERROR_ODD_VDAC_OFST__DFE_ERROR_ODD_VDAC_OFST_MASK                0x00FFL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DFE_ERROR_ODD_VDAC_OFST__RESERVED_15_8_MASK                          0xFF00L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ERROR_SLICER_LEVEL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ERROR_SLICER_LEVEL__E_SLO_LVL__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ERROR_SLICER_LEVEL__E_SLE_LVL__SHIFT                                 0x8
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ERROR_SLICER_LEVEL__E_SLO_LVL_MASK                                   0x00FFL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ERROR_SLICER_LEVEL__E_SLE_LVL_MASK                                   0xFF00L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_RESET
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_RESET__RESET_ASM1__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_RESET__RESERVED_15_1__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_RESET__RESET_ASM1_MASK                                          0x0001L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_ADPT_RESET__RESERVED_15_1_MASK                                       0xFFFEL
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1__DFE_T1_IDAC__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1__DFE_T2_IDAC__SHIFT                                   0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1__DCC_START_IDAC__SHIFT                                0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1__RESERVED_15_15__SHIFT                                0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1__DFE_T1_IDAC_MASK                                     0x001FL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1__DFE_T2_IDAC_MASK                                     0x03E0L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1__DCC_START_IDAC_MASK                                  0x7C00L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_1__RESERVED_15_15_MASK                                  0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_2
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_2__DFE_DAT_EVEN_VDAC__SHIFT                             0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_2__DFE_DAT_ODD_VDAC__SHIFT                              0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_2__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_2__DFE_DAT_EVEN_VDAC_MASK                               0x001FL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_2__DFE_DAT_ODD_VDAC_MASK                                0x03E0L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_2__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_3
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_3__DFE_ERR_EVEN_VDAC__SHIFT                             0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_3__DFE_ERR_ODD_VDAC__SHIFT                              0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_3__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_3__DFE_ERR_EVEN_VDAC_MASK                               0x001FL
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_3__DFE_ERR_ODD_VDAC_MASK                                0x03E0L
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_DAC_CTRL_SEL_3__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_CR_BANK_ADDR
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_CR_BANK_ADDR__ADDR__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_CR_BANK_ADDR__ADDR_MASK                                              0xFFFFL
//DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_CR_BANK_DATA
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_CR_BANK_DATA__DATA__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_ADPTCTL_CR_BANK_DATA__DATA_MASK                                              0xFFFFL
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_LD_VAL_1
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_LD_VAL_1__SC1_LD_VAL__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_LD_VAL_1__SC1_START__SHIFT                                              0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_LD_VAL_1__SC1_LD_VAL_MASK                                               0x7FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_LD_VAL_1__SC1_START_MASK                                                0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_DATA_MSK
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_DATA_MSK__DATA_MSK_15_0__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_DATA_MSK__DATA_MSK_15_0_MASK                                            0xFFFFL
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL0__PTTRN_MSK_CR1A_4_0__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL0__PTTRN_CR1A_4_0__SHIFT                                       0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL0__DATA_MSK_19_16__SHIFT                                       0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL0__SCOPE_DLY__SHIFT                                            0xe
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL0__PTTRN_MSK_CR1A_4_0_MASK                                     0x001FL
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL0__PTTRN_CR1A_4_0_MASK                                         0x03E0L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL0__DATA_MSK_19_16_MASK                                         0x3C00L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL0__SCOPE_DLY_MASK                                              0xC000L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL1
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1B_EN__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL1__PTTRN_MSK_CR1B_4_0__SHIFT                                   0x1
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1B_4_0__SHIFT                                       0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1A_ADPT_EN__SHIFT                                   0xb
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL1__RESERVED_15_12__SHIFT                                       0xc
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1B_EN_MASK                                          0x0001L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL1__PTTRN_MSK_CR1B_4_0_MASK                                     0x003EL
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1B_4_0_MASK                                         0x07C0L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1A_ADPT_EN_MASK                                     0x0800L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL1__RESERVED_15_12_MASK                                         0xF000L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__RESERVED_0__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__CORR_SHFT_SEL_VGA__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__CORR_SHFT_SEL__SHIFT                                         0x2
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__CORR_SRC_SEL__SHIFT                                          0x3
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__CORR_MODE_EN__SHIFT                                          0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__STAT_SHFT_SEL__SHIFT                                         0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__STAT_SRC_SEL__SHIFT                                          0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__STAT_RXCLK_SEL__SHIFT                                        0xd
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__SC_TIMER_MODE__SHIFT                                         0xe
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__SKIP_EN__SHIFT                                               0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__RESERVED_0_MASK                                              0x0001L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__CORR_SHFT_SEL_VGA_MASK                                       0x0002L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__CORR_SHFT_SEL_MASK                                           0x0004L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__CORR_SRC_SEL_MASK                                            0x0018L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__CORR_MODE_EN_MASK                                            0x0020L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__STAT_SHFT_SEL_MASK                                           0x03C0L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__STAT_SRC_SEL_MASK                                            0x1C00L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__STAT_RXCLK_SEL_MASK                                          0x2000L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__SC_TIMER_MODE_MASK                                           0x4000L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL0__SKIP_EN_MASK                                                 0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__STAT_CNT_0_EN__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__STAT_CNT_1_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__STAT_CNT_2_EN__SHIFT                                         0x2
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__STAT_CNT_3_EN__SHIFT                                         0x3
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__STAT_CNT_4_EN__SHIFT                                         0x4
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__STAT_CNT_5_EN__SHIFT                                         0x5
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__STAT_CNT_6_EN__SHIFT                                         0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__RESERVED_8_7__SHIFT                                          0x7
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__SC_PAUSE__SHIFT                                              0x9
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__STAT_CLK_EN__SHIFT                                           0xa
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__DATA_DLY_SEL__SHIFT                                          0xb
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__VLD_LOSS_CLR__SHIFT                                          0xd
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__VLD_CTL__SHIFT                                               0xe
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__STAT_CNT_0_EN_MASK                                           0x0001L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__STAT_CNT_1_EN_MASK                                           0x0002L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__STAT_CNT_2_EN_MASK                                           0x0004L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__STAT_CNT_3_EN_MASK                                           0x0008L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__STAT_CNT_4_EN_MASK                                           0x0010L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__STAT_CNT_5_EN_MASK                                           0x0020L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__STAT_CNT_6_EN_MASK                                           0x0040L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__RESERVED_8_7_MASK                                            0x0180L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__SC_PAUSE_MASK                                                0x0200L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__STAT_CLK_EN_MASK                                             0x0400L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__DATA_DLY_SEL_MASK                                            0x1800L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__VLD_LOSS_CLR_MASK                                            0x2000L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL1__VLD_CTL_MASK                                                 0xC000L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_SMPL_CNT1
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_SMPL_CNT1__SMPL_CNT1__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_SMPL_CNT1__SMPL_CNT1_DONE__SHIFT                                        0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_SMPL_CNT1__SMPL_CNT1_MASK                                               0x7FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_SMPL_CNT1__SMPL_CNT1_DONE_MASK                                          0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_0__STAT_CNT_0__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_0__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_0__STAT_CNT_0_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_0__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_1
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_1__STAT_CNT_1__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_1__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_1__STAT_CNT_1_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_1__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_2
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_2__STAT_CNT_2__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_2__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_2__STAT_CNT_2_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_2__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_3
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_3__STAT_CNT_3__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_3__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_3__STAT_CNT_3_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_3__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_4
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_4__STAT_CNT_4__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_4__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_4__STAT_CNT_4_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_4__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_5
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_5__STAT_CNT_5__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_5__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_5__STAT_CNT_5_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_5__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_6
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_6__STAT_CNT_6__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_6__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_6__STAT_CNT_6_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CNT_6__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_CAL_COMP_CLK_CTL
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_CAL_COMP_CLK_CTL__PRECHRGE_CNT__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_CAL_COMP_CLK_CTL__REF_DIV_CNT__SHIFT                                    0x3
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_CAL_COMP_CLK_CTL__RESERVED_15_6__SHIFT                                  0x6
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_CAL_COMP_CLK_CTL__PRECHRGE_CNT_MASK                                     0x0007L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_CAL_COMP_CLK_CTL__REF_DIV_CNT_MASK                                      0x0038L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_CAL_COMP_CLK_CTL__RESERVED_15_6_MASK                                    0xFFC0L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL2
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL2__PTTRN_CR1A_19_5__SHIFT                                      0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL2__RESERVED_15_15__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL2__PTTRN_CR1A_19_5_MASK                                        0x7FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL2__RESERVED_15_15_MASK                                         0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL3
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL3__PTTRN_MSK_CR1A_19_5__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL3__RESERVED_15_15__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL3__PTTRN_MSK_CR1A_19_5_MASK                                    0x7FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL3__RESERVED_15_15_MASK                                         0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL4
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL4__PTTRN_CR1B_19_5__SHIFT                                      0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL4__RESERVED_15_15__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL4__PTTRN_CR1B_19_5_MASK                                        0x7FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL4__RESERVED_15_15_MASK                                         0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL5
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL5__PTTRN_MSK_CR1B_19_5__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL5__RESERVED_15_15__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL5__PTTRN_MSK_CR1B_19_5_MASK                                    0x7FFFL
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_MATCH_CTL5__RESERVED_15_15_MASK                                         0x8000L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL2
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL2__DATA_DLY_SEL_2__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL2__SCOPE_DLY_2__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL2__DISABLE_SAMPLE_COUNT__SHIFT                                  0x2
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL2__RESERVED_15_3__SHIFT                                         0x3
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL2__DATA_DLY_SEL_2_MASK                                          0x0001L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL2__SCOPE_DLY_2_MASK                                             0x0002L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL2__DISABLE_SAMPLE_COUNT_MASK                                    0x0004L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_CTL2__RESERVED_15_3_MASK                                           0xFFF8L
//DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_STOP
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_STOP__SC1_STOP__SHIFT                                              0x0
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_STOP__RESERVED_15_1__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_STOP__SC1_STOP_MASK                                                0x0001L
#define DPCSSYS_CR0_LANE2_DIG_RX_STAT_STAT_STOP__RESERVED_15_1_MASK                                           0xFFFEL
//DPCSSYS_CR0_LANE2_DIG_MPHY_RX_PWM_CTL
#define DPCSSYS_CR0_LANE2_DIG_MPHY_RX_PWM_CTL__RX_PWM_POL__SHIFT                                              0x0
#define DPCSSYS_CR0_LANE2_DIG_MPHY_RX_PWM_CTL__RX_PWM_DATA_POL__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE2_DIG_MPHY_RX_PWM_CTL__RESERVED_15_2__SHIFT                                           0x2
#define DPCSSYS_CR0_LANE2_DIG_MPHY_RX_PWM_CTL__RX_PWM_POL_MASK                                                0x0001L
#define DPCSSYS_CR0_LANE2_DIG_MPHY_RX_PWM_CTL__RX_PWM_DATA_POL_MASK                                           0x0002L
#define DPCSSYS_CR0_LANE2_DIG_MPHY_RX_PWM_CTL__RESERVED_15_2_MASK                                             0xFFFCL
//DPCSSYS_CR0_LANE2_DIG_MPHY_RX_TERM_LS_CTL
#define DPCSSYS_CR0_LANE2_DIG_MPHY_RX_TERM_LS_CTL__RX_TERM_LCC_CNT__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE2_DIG_MPHY_RX_TERM_LS_CTL__RESERVED_15_3__SHIFT                                       0x3
#define DPCSSYS_CR0_LANE2_DIG_MPHY_RX_TERM_LS_CTL__RX_TERM_LCC_CNT_MASK                                       0x0007L
#define DPCSSYS_CR0_LANE2_DIG_MPHY_RX_TERM_LS_CTL__RESERVED_15_3_MASK                                         0xFFF8L
//DPCSSYS_CR0_LANE2_DIG_MPHY_RX_ANA_PWM_CLK_STABLE_CNT
#define DPCSSYS_CR0_LANE2_DIG_MPHY_RX_ANA_PWM_CLK_STABLE_CNT__PWM_CLK_STABLE_CNT__SHIFT                       0x0
#define DPCSSYS_CR0_LANE2_DIG_MPHY_RX_ANA_PWM_CLK_STABLE_CNT__RESERVED_15_4__SHIFT                            0x4
#define DPCSSYS_CR0_LANE2_DIG_MPHY_RX_ANA_PWM_CLK_STABLE_CNT__PWM_CLK_STABLE_CNT_MASK                         0x000FL
#define DPCSSYS_CR0_LANE2_DIG_MPHY_RX_ANA_PWM_CLK_STABLE_CNT__RESERVED_15_4_MASK                              0xFFF0L
//DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_CLK_SHIFT__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_DATA_EN__SHIFT                                          0x1
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_REFGEN_EN__SHIFT                                        0x2
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_VCM_HOLD__SHIFT                                         0x3
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_CLK_EN__SHIFT                                           0x4
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_WORD_CLK_EN__SHIFT                                      0x5
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_MPLLA_CLK_EN__SHIFT                                     0x6
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_MPLLB_CLK_EN__SHIFT                                     0x7
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_RESET__SHIFT                                            0x8
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_SERIAL_EN__SHIFT                                        0x9
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_DATA_RATE__SHIFT                                        0xa
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__RESERVED__SHIFT                                                0xc
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_DIV4_EN__SHIFT                                              0xd
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_RXDET_EN__SHIFT                                             0xe
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_OVRD_EN__SHIFT                                              0xf
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_CLK_SHIFT_MASK                                          0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_DATA_EN_MASK                                            0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_REFGEN_EN_MASK                                          0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_VCM_HOLD_MASK                                           0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_CLK_EN_MASK                                             0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_WORD_CLK_EN_MASK                                        0x0020L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_MPLLA_CLK_EN_MASK                                       0x0040L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_MPLLB_CLK_EN_MASK                                       0x0080L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_RESET_MASK                                              0x0100L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_SERIAL_EN_MASK                                          0x0200L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_ANA_DATA_RATE_MASK                                          0x0C00L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__RESERVED_MASK                                                  0x1000L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_DIV4_EN_MASK                                                0x2000L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_RXDET_EN_MASK                                               0x4000L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT__TX_OVRD_EN_MASK                                                0x8000L
//DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_OVRD_OUT
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_TERM_CODE__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_TERM_OVRD_EN__SHIFT                               0xa
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_DRV_SRC__SHIFT                                    0xb
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_DRV_SRC_OVRD_EN__SHIFT                            0xd
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_OVRD_OUT__RESERVED_15_14__SHIFT                                0xe
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_TERM_CODE_MASK                                    0x03FFL
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_TERM_OVRD_EN_MASK                                 0x0400L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_DRV_SRC_MASK                                      0x1800L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_DRV_SRC_OVRD_EN_MASK                              0x2000L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_OVRD_OUT__RESERVED_15_14_MASK                                  0xC000L
//DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__TX_TERM_DN_CLK__SHIFT                            0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__TX_TERM_CLK_SELF_CLEAR_DISABLE__SHIFT            0x1
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__RESERVED_15_2__SHIFT                             0x2
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__TX_TERM_DN_CLK_MASK                              0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__TX_TERM_CLK_SELF_CLEAR_DISABLE_MASK              0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__RESERVED_15_2_MASK                               0xFFFCL
//DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_0
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_ANA_LOAD_CLK__SHIFT                                    0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_ANA_CTRL_LEG_PULL_EN_13_0__SHIFT                       0x1
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_EQ_OVRD_EN__SHIFT                                      0xf
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_ANA_LOAD_CLK_MASK                                      0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_ANA_CTRL_LEG_PULL_EN_13_0_MASK                         0x7FFEL
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_EQ_OVRD_EN_MASK                                        0x8000L
//DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_1
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_1__TX_ANA_CTRL_LEG_PULL_EN_19_14__SHIFT                      0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_1__RESERVED_15_6__SHIFT                                      0x6
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_1__TX_ANA_CTRL_LEG_PULL_EN_19_14_MASK                        0x003FL
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_1__RESERVED_15_6_MASK                                        0xFFC0L
//DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_2
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_2__RESERVED__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_2__TX_ANA_CTRL_EQ_MUX_SEL__SHIFT                             0x3
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_2__TX_ANA_CTRL_PRE__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_2__RESERVED_15_13__SHIFT                                     0xd
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_2__RESERVED_MASK                                             0x0007L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_2__TX_ANA_CTRL_EQ_MUX_SEL_MASK                               0x0078L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_2__TX_ANA_CTRL_PRE_MASK                                      0x1F80L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_2__RESERVED_15_13_MASK                                       0xE000L
//DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_3
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_3__TX_ANA_CTRL_POST__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_3__RESERVED_15_9__SHIFT                                      0x9
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_3__TX_ANA_CTRL_POST_MASK                                     0x01FFL
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_3__RESERVED_15_9_MASK                                        0xFE00L
//DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_4
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_4__TX_ANA_CTRL_LEG_PULL_DIR_19_4__SHIFT                      0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_4__TX_ANA_CTRL_LEG_PULL_DIR_19_4_MASK                        0xFFFFL
//DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_5
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_5__TX_ANA_CTRL_LEG_PULL_DIR_3_0__SHIFT                       0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_5__RESERVED_15_4__SHIFT                                      0x4
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_5__TX_ANA_CTRL_LEG_PULL_DIR_3_0_MASK                         0x000FL
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_EQ_OVRD_OUT_5__RESERVED_15_4_MASK                                        0xFFF0L
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RESERVED__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_DATA_RATE__SHIFT                                    0x1
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_WORD_CLK_EN__SHIFT                                  0x3
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_DIV4_EN__SHIFT                                      0x4
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_DFE_TAPS_EN__SHIFT                                  0x5
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_ADAPTATION_EN__SHIFT                                0x6
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RX_LBK_CLK_EN__SHIFT                                       0x7
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RX_CTL_OVRD_EN__SHIFT                                      0x8
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RESERVED_15_9__SHIFT                                       0x9
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RESERVED_MASK                                              0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_DATA_RATE_MASK                                      0x0006L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_WORD_CLK_EN_MASK                                    0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_DIV4_EN_MASK                                        0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_DFE_TAPS_EN_MASK                                    0x0020L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RX_ANA_ADAPTATION_EN_MASK                                  0x0040L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RX_LBK_CLK_EN_MASK                                         0x0080L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RX_CTL_OVRD_EN_MASK                                        0x0100L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CTL_OVRD_OUT__RESERVED_15_9_MASK                                         0xFE00L
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_AFE_EN__SHIFT                                       0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_CLK_VREG_EN__SHIFT                                  0x1
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_CLK_DCC_EN__SHIFT                                   0x2
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_CLK_EN__SHIFT                                       0x3
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_CDR_EN__SHIFT                                       0x4
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_DESERIAL_EN__SHIFT                                  0x5
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RX_PWR_OVRD_EN__SHIFT                                      0x6
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_FAST_START__SHIFT                                   0x7
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RESERVED_15_8__SHIFT                                       0x8
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_AFE_EN_MASK                                         0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_CLK_VREG_EN_MASK                                    0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_CLK_DCC_EN_MASK                                     0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_CLK_EN_MASK                                         0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_CDR_EN_MASK                                         0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_DESERIAL_EN_MASK                                    0x0020L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RX_PWR_OVRD_EN_MASK                                        0x0040L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RX_ANA_FAST_START_MASK                                     0x0080L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_PWR_OVRD_OUT__RESERVED_15_8_MASK                                         0xFF00L
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_CDR_VCO_EN__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_CDR_STARTUP__SHIFT                                0x1
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_VCO_CDR_OVRD_EN__SHIFT                                0x2
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_CDR_FREQ_TUNE__SHIFT                              0x3
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_VCO_CNTR_EN__SHIFT                                0xd
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_VCO_CNTR_CLK__SHIFT                               0xe
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_CDR_FREQ_TUNE_OVRD_EN__SHIFT                          0xf
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_CDR_VCO_EN_MASK                                   0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_CDR_STARTUP_MASK                                  0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_VCO_CDR_OVRD_EN_MASK                                  0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_CDR_FREQ_TUNE_MASK                                0x1FF8L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_VCO_CNTR_EN_MASK                                  0x2000L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_ANA_VCO_CNTR_CLK_MASK                                 0x4000L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_0__RX_CDR_FREQ_TUNE_OVRD_EN_MASK                            0x8000L
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_1
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_1__RX_ANA_CDR_VCO_LOWFREQ__SHIFT                            0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_1__RX_ANA_VCO_CNTR_PD__SHIFT                                0x1
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_1__RESERVED_15_2__SHIFT                                     0x2
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_1__RX_ANA_CDR_VCO_LOWFREQ_MASK                              0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_1__RX_ANA_VCO_CNTR_PD_MASK                                  0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_1__RESERVED_15_2_MASK                                       0xFFFCL
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_2
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_2__RX_ANA_CDR_FREQ_TUNE_CLK__SHIFT                          0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_2__CDR_FREQ_TUNE_CLK_SELF_CLEAR_DISABLE__SHIFT              0x1
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_2__RESERVED_15_2__SHIFT                                     0x2
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_2__RX_ANA_CDR_FREQ_TUNE_CLK_MASK                            0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_2__CDR_FREQ_TUNE_CLK_SELF_CLEAR_DISABLE_MASK                0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_VCO_OVRD_OUT_2__RESERVED_15_2_MASK                                       0xFFFCL
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_CAL
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CAL__RX_ANA_CAL_MUXA_SEL__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CAL__RX_ANA_CAL_MUXB_SEL__SHIFT                                          0x5
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CAL__RX_ANA_CAL_LPFBYP_EN__SHIFT                                         0xa
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CAL__RESERVED__SHIFT                                                     0xb
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CAL__RX_ANA_SLICER_CAL_EN__SHIFT                                         0xc
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CAL__RX_ANA_CAL_MODE__SHIFT                                              0xd
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CAL__RX_ANA_CAL_COMP_EN__SHIFT                                           0xf
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CAL__RX_ANA_CAL_MUXA_SEL_MASK                                            0x001FL
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CAL__RX_ANA_CAL_MUXB_SEL_MASK                                            0x03E0L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CAL__RX_ANA_CAL_LPFBYP_EN_MASK                                           0x0400L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CAL__RESERVED_MASK                                                       0x0800L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CAL__RX_ANA_SLICER_CAL_EN_MASK                                           0x1000L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CAL__RX_ANA_CAL_MODE_MASK                                                0x6000L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_CAL__RX_ANA_CAL_COMP_EN_MASK                                             0x8000L
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_DAC_CTRL
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_DAC_CTRL__RX_ANA_CAL_DAC_CTRL__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_DAC_CTRL__RESERVED_15_8__SHIFT                                           0x8
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_DAC_CTRL__RX_ANA_CAL_DAC_CTRL_MASK                                       0x00FFL
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_DAC_CTRL__RESERVED_15_8_MASK                                             0xFF00L
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_DAC_CTRL_OVRD
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_DAC_CTRL_OVRD__RX_CAL_DAC_CTRL_OVRD__SHIFT                               0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_DAC_CTRL_OVRD__RX_CAL_DAC_CTRL_OVRD_MASK                                 0x0001L
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_DAC_CTRL_SEL
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_DAC_CTRL_SEL__RX_ANA_CAL_DAC_CTRL_SEL__SHIFT                             0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_DAC_CTRL_SEL__RESERVED_15_5__SHIFT                                       0x5
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_DAC_CTRL_SEL__RX_ANA_CAL_DAC_CTRL_SEL_MASK                               0x001FL
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_DAC_CTRL_SEL__RESERVED_15_5_MASK                                         0xFFE0L
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_ATT_VGA
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_ATT_VGA__RX_ANA_AFE_ATT_LVL__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_ATT_VGA__RX_ANA_AFE_GAIN__SHIFT                                      0x3
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_ATT_VGA__RESERVED__SHIFT                                             0x7
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_ATT_VGA__RX_AFE_OVRD_EN__SHIFT                                       0xb
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_ATT_VGA__RESERVED_15_12__SHIFT                                       0xc
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_ATT_VGA__RX_ANA_AFE_ATT_LVL_MASK                                     0x0007L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_ATT_VGA__RX_ANA_AFE_GAIN_MASK                                        0x0078L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_ATT_VGA__RESERVED_MASK                                               0x0780L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_ATT_VGA__RX_AFE_OVRD_EN_MASK                                         0x0800L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_ATT_VGA__RESERVED_15_12_MASK                                         0xF000L
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_CTLE
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_CTLE__RESERVED__SHIFT                                                0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_CTLE__RX_ANA_AFE_CTLE_BOOST__SHIFT                                   0x3
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_CTLE__RESERVED_15_8__SHIFT                                           0x8
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_CTLE__RESERVED_MASK                                                  0x0007L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_CTLE__RX_ANA_AFE_CTLE_BOOST_MASK                                     0x00F8L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_AFE_CTLE__RESERVED_15_8_MASK                                             0xFF00L
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_SCOPE
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_EN__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_SEL__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_PH_CLK__SHIFT                                        0x3
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_PHASE__SHIFT                                         0x4
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_CLK_EN__SHIFT                                        0xc
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SCOPE__RX_SCOPE_SELF_CLEAR_DISABLE__SHIFT                                0xd
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SCOPE__RESERVED_15_14__SHIFT                                             0xe
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_EN_MASK                                              0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_SEL_MASK                                             0x0006L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_PH_CLK_MASK                                          0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_PHASE_MASK                                           0x0FF0L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SCOPE__RX_ANA_SCOPE_CLK_EN_MASK                                          0x1000L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SCOPE__RX_SCOPE_SELF_CLEAR_DISABLE_MASK                                  0x2000L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SCOPE__RESERVED_15_14_MASK                                               0xC000L
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_SLICER_CTRL
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SLICER_CTRL__RX_ANA_SLICER_CTRL_E__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SLICER_CTRL__RX_ANA_SLICER_CTRL_O__SHIFT                                 0x4
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SLICER_CTRL__RX_ANA_SLICER_CTRL_OVRD_EN__SHIFT                           0x8
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SLICER_CTRL__RESERVED_15_9__SHIFT                                        0x9
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SLICER_CTRL__RX_ANA_SLICER_CTRL_E_MASK                                   0x000FL
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SLICER_CTRL__RX_ANA_SLICER_CTRL_O_MASK                                   0x00F0L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SLICER_CTRL__RX_ANA_SLICER_CTRL_OVRD_EN_MASK                             0x0100L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_SLICER_CTRL__RESERVED_15_9_MASK                                          0xFE00L
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_IQ_PHASE_ADJUST
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_IQ_PHASE_ADJUST__RX_ANA_IQ_PHASE_ADJUST__SHIFT                       0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_IQ_PHASE_ADJUST__RX_ANA_IQ_PHASE_ADJUST_MASK                         0x007FL
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_IQ_SENSE_EN
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_IQ_SENSE_EN__RX_ANA_IQ_SENSE_EN__SHIFT                               0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_IQ_SENSE_EN__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_IQ_SENSE_EN__RX_ANA_IQ_SENSE_EN_MASK                                 0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_IQ_SENSE_EN__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_CAL_DAC_CTRL_EN
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_CAL_DAC_CTRL_EN__RX_ANA_CAL_DAC_CTRL_EN__SHIFT                       0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_CAL_DAC_CTRL_EN__DAC_CTRL_SELF_CLEAR_DISABLE__SHIFT                  0x1
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_CAL_DAC_CTRL_EN__RESERVED_15_2__SHIFT                                0x2
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_CAL_DAC_CTRL_EN__RX_ANA_CAL_DAC_CTRL_EN_MASK                         0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_CAL_DAC_CTRL_EN__DAC_CTRL_SELF_CLEAR_DISABLE_MASK                    0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_CAL_DAC_CTRL_EN__RESERVED_15_2_MASK                                  0xFFFCL
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_SIGNALS_CHANGES_ENABLE
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_SIGNALS_CHANGES_ENABLE__RX_ANA_AFE_UPDATE_EN__SHIFT                  0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_SIGNALS_CHANGES_ENABLE__AFE_UPDATE_SELF_CLEAR_DISABLE__SHIFT         0x1
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_SIGNALS_CHANGES_ENABLE__RESERVED_15_2__SHIFT                         0x2
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_SIGNALS_CHANGES_ENABLE__RX_ANA_AFE_UPDATE_EN_MASK                    0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_SIGNALS_CHANGES_ENABLE__AFE_UPDATE_SELF_CLEAR_DISABLE_MASK           0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_SIGNALS_CHANGES_ENABLE__RESERVED_15_2_MASK                           0xFFFCL
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_PHASE_ADJUST_CLK
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_PHASE_ADJUST_CLK__RX_ANA_IQ_PHASE_ADJUST_CLK__SHIFT                  0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_PHASE_ADJUST_CLK__PHASE_ADJUST_SELF_CLEAR_DISABLE__SHIFT             0x1
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_PHASE_ADJUST_CLK__RESERVED_15_2__SHIFT                               0x2
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_PHASE_ADJUST_CLK__RX_ANA_IQ_PHASE_ADJUST_CLK_MASK                    0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_PHASE_ADJUST_CLK__PHASE_ADJUST_SELF_CLEAR_DISABLE_MASK               0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_ANA_PHASE_ADJUST_CLK__RESERVED_15_2_MASK                                 0xFFFCL
//DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__TX_ANA_CLK_SHIFT_ACK__SHIFT                                       0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__TX_ANA_RXDETP_RESULT__SHIFT                                       0x1
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__TX_ANA_RXDETM_RESULT__SHIFT                                       0x2
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__TX_ANA_LOOPBACK_EN__SHIFT                                         0x3
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__TX_ANA_CLK_LB_EN__SHIFT                                           0x4
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__RX_ANA_CAL_RESULT__SHIFT                                          0x5
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__RX_ANA_SCOPE_DATA__SHIFT                                          0x6
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__TX_ANA_DCC_CAL_RESULT__SHIFT                                      0x7
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__TX_ANA_CTRL_EQ_MUX__SHIFT                                         0x8
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__TX_ANA_CLK_SHIFT_ACK_MASK                                         0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__TX_ANA_RXDETP_RESULT_MASK                                         0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__TX_ANA_RXDETM_RESULT_MASK                                         0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__TX_ANA_LOOPBACK_EN_MASK                                           0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__TX_ANA_CLK_LB_EN_MASK                                             0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__RX_ANA_CAL_RESULT_MASK                                            0x0020L
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__RX_ANA_SCOPE_DATA_MASK                                            0x0040L
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__TX_ANA_DCC_CAL_RESULT_MASK                                        0x0080L
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_0__TX_ANA_CTRL_EQ_MUX_MASK                                           0xFF00L
//DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_1
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_1__RX_ANA_VCO_CNTR__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_1__RESERVED_15_13__SHIFT                                             0xd
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_1__RX_ANA_VCO_CNTR_MASK                                              0x1FFFL
#define DPCSSYS_CR0_LANE2_DIG_ANA_STATUS_1__RESERVED_15_13_MASK                                               0xE000L
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_TERM_CODE_OVRD_OUT
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_TERM_CODE_OVRD_OUT__RX_TERM_CODE__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_TERM_CODE_OVRD_OUT__RX_TERM_OVRD_EN__SHIFT                               0x6
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_TERM_CODE_OVRD_OUT__RESERVED_15_7__SHIFT                                 0x7
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_TERM_CODE_OVRD_OUT__RX_TERM_CODE_MASK                                    0x003FL
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_TERM_CODE_OVRD_OUT__RX_TERM_OVRD_EN_MASK                                 0x0040L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_TERM_CODE_OVRD_OUT__RESERVED_15_7_MASK                                   0xFF80L
//DPCSSYS_CR0_LANE2_DIG_ANA_RX_TERM_CODE_CLK_OVRD_OUT
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_TERM_CODE_CLK_OVRD_OUT__RX_TERM_CLK__SHIFT                               0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_TERM_CODE_CLK_OVRD_OUT__RX_TERM_CLK_SELF_CLEAR_DISABLE__SHIFT            0x1
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_TERM_CODE_CLK_OVRD_OUT__RESERVED_15_2__SHIFT                             0x2
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_TERM_CODE_CLK_OVRD_OUT__RX_TERM_CLK_MASK                                 0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_TERM_CODE_CLK_OVRD_OUT__RX_TERM_CLK_SELF_CLEAR_DISABLE_MASK              0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ANA_RX_TERM_CODE_CLK_OVRD_OUT__RESERVED_15_2_MASK                               0xFFFCL
//DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_SQ_CTRL_TRESH__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_SQ_CTRL_TRESH_OVRD_EN__SHIFT                          0x3
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_SQ_CTRL_RESP__SHIFT                                   0x4
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_SQ_CTRL_RESP_OVRD_EN__SHIFT                           0x6
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_PWM_EN__SHIFT                                         0x7
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_PWM_EN_OVRD_EN__SHIFT                                 0x8
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_PWM_CLK_SEL__SHIFT                                    0x9
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_PWM_CLK_SEL_OVRD_EN__SHIFT                            0xb
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RESERVED_15_12__SHIFT                                        0xc
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_SQ_CTRL_TRESH_MASK                                    0x0007L
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_SQ_CTRL_TRESH_OVRD_EN_MASK                            0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_SQ_CTRL_RESP_MASK                                     0x0030L
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_SQ_CTRL_RESP_OVRD_EN_MASK                             0x0040L
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_PWM_EN_MASK                                           0x0080L
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_PWM_EN_OVRD_EN_MASK                                   0x0100L
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_PWM_CLK_SEL_MASK                                      0x0600L
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RX_ANA_PWM_CLK_SEL_OVRD_EN_MASK                              0x0800L
#define DPCSSYS_CR0_LANE2_DIG_ANA_MPHY_OVRD_OUT__RESERVED_15_12_MASK                                          0xF000L
//DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_1
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_HF_THRESH__SHIFT                           0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_HF_THRESH_OVRD_EN__SHIFT                   0x3
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_HF_CAL_TUNE__SHIFT                         0x4
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_CAL_TUNE_OVRD_EN__SHIFT                    0xa
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_CAL_EN__SHIFT                              0xb
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_CAL_EN_OVRD_EN__SHIFT                      0xc
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_1__RESERVED_15_13__SHIFT                                    0xd
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_HF_THRESH_MASK                             0x0007L
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_HF_THRESH_OVRD_EN_MASK                     0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_HF_CAL_TUNE_MASK                           0x03F0L
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_CAL_TUNE_OVRD_EN_MASK                      0x0400L
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_CAL_EN_MASK                                0x0800L
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_1__RX_ANA_SIGDET_CAL_EN_OVRD_EN_MASK                        0x1000L
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_1__RESERVED_15_13_MASK                                      0xE000L
//DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_2
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_LF_THRESH__SHIFT                           0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_LF_THRESH_OVRD_EN__SHIFT                   0x3
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_LF_FILTER_EN__SHIFT                        0x4
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_LF_FILTER_EN_OVRD_EN__SHIFT                0x5
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_CAL_TUNE__SHIFT                            0x6
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_CAL_TUNE_OVRD_EN__SHIFT                    0xc
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_2__RESERVED_15_13__SHIFT                                    0xd
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_LF_THRESH_MASK                             0x0007L
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_LF_THRESH_OVRD_EN_MASK                     0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_LF_FILTER_EN_MASK                          0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_LF_FILTER_EN_OVRD_EN_MASK                  0x0020L
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_CAL_TUNE_MASK                              0x0FC0L
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_2__RX_ANA_SIGDET_CAL_TUNE_OVRD_EN_MASK                      0x1000L
#define DPCSSYS_CR0_LANE2_DIG_ANA_SIGDET_OVRD_OUT_2__RESERVED_15_13_MASK                                      0xE000L
//DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_RANGE__SHIFT                            0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_RANGE_OVRD_EN__SHIFT                    0x2
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_COMP_EN__SHIFT                          0x3
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_COMP_EN_OVRD_EN__SHIFT                  0x4
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL__SHIFT                             0x5
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_OVRD_EN__SHIFT                     0xd
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_EN__SHIFT                          0xe
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_EN_OVRD_EN__SHIFT                  0xf
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_RANGE_MASK                              0x0003L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_RANGE_OVRD_EN_MASK                      0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_COMP_EN_MASK                            0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_COMP_EN_OVRD_EN_MASK                    0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_MASK                               0x1FE0L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_OVRD_EN_MASK                       0x2000L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_EN_MASK                            0x4000L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_EN_OVRD_EN_MASK                    0x8000L
//DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CAL_CTRL_SEL__SHIFT                       0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CAL_CTRL_SEL_OVRD_EN__SHIFT               0x3
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CLK_COMP__SHIFT                           0x4
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CLK_COMP_OVRD_EN__SHIFT                   0x5
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CAL_CTRL_SEL_MASK                         0x0007L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CAL_CTRL_SEL_OVRD_EN_MASK                 0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CLK_COMP_MASK                             0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CLK_COMP_OVRD_EN_MASK                     0x0020L
//DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT_2
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT_2__TX_ANA_FAST_START__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT_2__TX_ANA_FAST_START_OVRD_EN__SHIFT                             0x1
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT_2__TX_CLK_LB_EN__SHIFT                                          0x2
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT_2__TX_CLK_LB_EN_OVRD_EN__SHIFT                                  0x3
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT_2__TX_ACJTAG_EN__SHIFT                                          0x4
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT_2__RESERVED_15_5__SHIFT                                         0x5
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT_2__TX_ANA_FAST_START_MASK                                       0x0001L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT_2__TX_ANA_FAST_START_OVRD_EN_MASK                               0x0002L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT_2__TX_CLK_LB_EN_MASK                                            0x0004L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT_2__TX_CLK_LB_EN_OVRD_EN_MASK                                    0x0008L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT_2__TX_ACJTAG_EN_MASK                                            0x0010L
#define DPCSSYS_CR0_LANE2_DIG_ANA_TX_OVRD_OUT_2__RESERVED_15_5_MASK                                           0xFFE0L
//DPCSSYS_CR0_LANE2_ANA_TX_OVRD_MEAS
#define DPCSSYS_CR0_LANE2_ANA_TX_OVRD_MEAS__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE2_ANA_TX_OVRD_MEAS__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE2_ANA_TX_PWR_OVRD
#define DPCSSYS_CR0_LANE2_ANA_TX_PWR_OVRD__RESERVED_15_8__SHIFT                                               0x8
#define DPCSSYS_CR0_LANE2_ANA_TX_PWR_OVRD__RESERVED_15_8_MASK                                                 0xFF00L
//DPCSSYS_CR0_LANE2_ANA_TX_ALT_BUS
#define DPCSSYS_CR0_LANE2_ANA_TX_ALT_BUS__RESERVED_15_8__SHIFT                                                0x8
#define DPCSSYS_CR0_LANE2_ANA_TX_ALT_BUS__RESERVED_15_8_MASK                                                  0xFF00L
//DPCSSYS_CR0_LANE2_ANA_TX_ATB1
#define DPCSSYS_CR0_LANE2_ANA_TX_ATB1__RESERVED_15_8__SHIFT                                                   0x8
#define DPCSSYS_CR0_LANE2_ANA_TX_ATB1__RESERVED_15_8_MASK                                                     0xFF00L
//DPCSSYS_CR0_LANE2_ANA_TX_ATB2
#define DPCSSYS_CR0_LANE2_ANA_TX_ATB2__RESERVED_15_8__SHIFT                                                   0x8
#define DPCSSYS_CR0_LANE2_ANA_TX_ATB2__RESERVED_15_8_MASK                                                     0xFF00L
//DPCSSYS_CR0_LANE2_ANA_TX_DCC_DAC
#define DPCSSYS_CR0_LANE2_ANA_TX_DCC_DAC__RESERVED_15_8__SHIFT                                                0x8
#define DPCSSYS_CR0_LANE2_ANA_TX_DCC_DAC__RESERVED_15_8_MASK                                                  0xFF00L
//DPCSSYS_CR0_LANE2_ANA_TX_DCC_CTRL1
#define DPCSSYS_CR0_LANE2_ANA_TX_DCC_CTRL1__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE2_ANA_TX_DCC_CTRL1__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE2_ANA_TX_TERM_CODE
#define DPCSSYS_CR0_LANE2_ANA_TX_TERM_CODE__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE2_ANA_TX_TERM_CODE__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE2_ANA_TX_TERM_CODE_CTRL
#define DPCSSYS_CR0_LANE2_ANA_TX_TERM_CODE_CTRL__RESERVED_15_8__SHIFT                                         0x8
#define DPCSSYS_CR0_LANE2_ANA_TX_TERM_CODE_CTRL__RESERVED_15_8_MASK                                           0xFF00L
//DPCSSYS_CR0_LANE2_ANA_TX_OVRD_CLK
#define DPCSSYS_CR0_LANE2_ANA_TX_OVRD_CLK__RESERVED_15_8__SHIFT                                               0x8
#define DPCSSYS_CR0_LANE2_ANA_TX_OVRD_CLK__RESERVED_15_8_MASK                                                 0xFF00L
//DPCSSYS_CR0_LANE2_ANA_TX_MISC1
#define DPCSSYS_CR0_LANE2_ANA_TX_MISC1__RESERVED_15_8__SHIFT                                                  0x8
#define DPCSSYS_CR0_LANE2_ANA_TX_MISC1__RESERVED_15_8_MASK                                                    0xFF00L
//DPCSSYS_CR0_LANE2_ANA_TX_MISC2
#define DPCSSYS_CR0_LANE2_ANA_TX_MISC2__RESERVED_15_8__SHIFT                                                  0x8
#define DPCSSYS_CR0_LANE2_ANA_TX_MISC2__RESERVED_15_8_MASK                                                    0xFF00L
//DPCSSYS_CR0_LANE2_ANA_TX_RESERVED3
#define DPCSSYS_CR0_LANE2_ANA_TX_RESERVED3__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE2_ANA_TX_RESERVED3__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE2_ANA_TX_RESERVED4
#define DPCSSYS_CR0_LANE2_ANA_TX_RESERVED4__NC7_0__SHIFT                                                      0x0
#define DPCSSYS_CR0_LANE2_ANA_TX_RESERVED4__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE2_ANA_TX_RESERVED4__NC7_0_MASK                                                        0x00FFL
#define DPCSSYS_CR0_LANE2_ANA_TX_RESERVED4__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE2_ANA_RX_CLK_1
//DPCSSYS_CR0_LANE2_ANA_RX_CLK_2
//DPCSSYS_CR0_LANE2_ANA_RX_CDR_DES
//DPCSSYS_CR0_LANE2_ANA_RX_SLC_CTRL
//DPCSSYS_CR0_LANE2_ANA_RX_PWR_CTRL1
#define DPCSSYS_CR0_LANE2_ANA_RX_PWR_CTRL1__NC7_7__SHIFT                                                      0x7
#define DPCSSYS_CR0_LANE2_ANA_RX_PWR_CTRL1__NC7_7_MASK                                                        0x0080L
//DPCSSYS_CR0_LANE2_ANA_RX_PWR_CTRL2
//DPCSSYS_CR0_LANE2_ANA_RX_SQ
#define DPCSSYS_CR0_LANE2_ANA_RX_SQ__NC4_3__SHIFT                                                             0x3
#define DPCSSYS_CR0_LANE2_ANA_RX_SQ__NC4_3_MASK                                                               0x0018L
//DPCSSYS_CR0_LANE2_ANA_RX_CAL1
//DPCSSYS_CR0_LANE2_ANA_RX_CAL2
#define DPCSSYS_CR0_LANE2_ANA_RX_CAL2__RESERVED_15_8__SHIFT                                                   0x8
#define DPCSSYS_CR0_LANE2_ANA_RX_CAL2__RESERVED_15_8_MASK                                                     0xFF00L
//DPCSSYS_CR0_LANE2_ANA_RX_ATB_REGREF
#define DPCSSYS_CR0_LANE2_ANA_RX_ATB_REGREF__RESERVED_15_8__SHIFT                                             0x8
#define DPCSSYS_CR0_LANE2_ANA_RX_ATB_REGREF__RESERVED_15_8_MASK                                               0xFF00L
//DPCSSYS_CR0_LANE2_ANA_RX_ATB_MEAS1
#define DPCSSYS_CR0_LANE2_ANA_RX_ATB_MEAS1__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE2_ANA_RX_ATB_MEAS1__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE2_ANA_RX_ATB_MEAS2
#define DPCSSYS_CR0_LANE2_ANA_RX_ATB_MEAS2__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE2_ANA_RX_ATB_MEAS2__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE2_ANA_RX_ATB_MEAS3
#define DPCSSYS_CR0_LANE2_ANA_RX_ATB_MEAS3__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE2_ANA_RX_ATB_MEAS3__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_OVRD_IN
#define DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_OVRD_IN__LANE_TX2RX_SER_LB__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_OVRD_IN__LANE_RX2TX_PAR_LB__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_OVRD_IN__EN__SHIFT                                                    0x2
#define DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_OVRD_IN__RX_ACJTAG_EN__SHIFT                                          0x3
#define DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_OVRD_IN__RESERVED_15_4__SHIFT                                         0x4
#define DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_OVRD_IN__LANE_TX2RX_SER_LB_MASK                                       0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_OVRD_IN__LANE_RX2TX_PAR_LB_MASK                                       0x0002L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_OVRD_IN__EN_MASK                                                      0x0004L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_OVRD_IN__RX_ACJTAG_EN_MASK                                            0x0008L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_OVRD_IN__RESERVED_15_4_MASK                                           0xFFF0L
//DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__REQ__SHIFT                                                   0x0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__REQ_OVRD_EN__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__PSTATE__SHIFT                                                0x2
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__PSTATE_OVRD_EN__SHIFT                                        0x4
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__RATE__SHIFT                                                  0x5
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__RATE_OVRD_EN__SHIFT                                          0x8
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__WIDTH__SHIFT                                                 0x9
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__WIDTH_OVRD_EN__SHIFT                                         0xb
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__MPLLB_SEL__SHIFT                                             0xc
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__MPLLB_SEL_OVRD_EN__SHIFT                                     0xd
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__DATA_EN__SHIFT                                               0xe
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__DATA_EN_OVRD_EN__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__REQ_MASK                                                     0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__REQ_OVRD_EN_MASK                                             0x0002L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__PSTATE_MASK                                                  0x000CL
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__PSTATE_OVRD_EN_MASK                                          0x0010L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__RATE_MASK                                                    0x00E0L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__RATE_OVRD_EN_MASK                                            0x0100L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__WIDTH_MASK                                                   0x0600L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__WIDTH_OVRD_EN_MASK                                           0x0800L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__MPLLB_SEL_MASK                                               0x1000L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__MPLLB_SEL_OVRD_EN_MASK                                       0x2000L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__DATA_EN_MASK                                                 0x4000L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_0__DATA_EN_OVRD_EN_MASK                                         0x8000L
//DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__NYQUIST_DATA__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__DISABLE__SHIFT                                               0x1
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__BEACON_EN__SHIFT                                             0x2
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__EN__SHIFT                                                    0x3
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__TX_MAIN_CURSOR__SHIFT                                        0x4
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__MAIN_OVRD_EN__SHIFT                                          0xa
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__ASYNC_DRV_EN__SHIFT                                          0xb
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__ASYNC_DRV_OVRD_EN__SHIFT                                     0xc
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__TX_VREGDRV_BYP_OVRD__SHIFT                                   0xd
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__TX_VREGDRV_BYP_OVRD_EN__SHIFT                                0xe
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__RESERVED_15_15__SHIFT                                        0xf
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__NYQUIST_DATA_MASK                                            0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__DISABLE_MASK                                                 0x0002L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__BEACON_EN_MASK                                               0x0004L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__EN_MASK                                                      0x0008L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__TX_MAIN_CURSOR_MASK                                          0x03F0L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__MAIN_OVRD_EN_MASK                                            0x0400L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__ASYNC_DRV_EN_MASK                                            0x0800L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__ASYNC_DRV_OVRD_EN_MASK                                       0x1000L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__TX_VREGDRV_BYP_OVRD_MASK                                     0x2000L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__TX_VREGDRV_BYP_OVRD_EN_MASK                                  0x4000L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_1__RESERVED_15_15_MASK                                          0x8000L
//DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_2
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_2__TX_PRE_CURSOR__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_2__PRE_OVRD_EN__SHIFT                                           0x6
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_2__TX_POST_CURSOR__SHIFT                                        0x7
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_2__POST_OVRD_EN__SHIFT                                          0xd
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_2__HDMIMODE_EN__SHIFT                                           0xe
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_2__HDMIMODE_ENABLE_OVRD_EN__SHIFT                               0xf
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_2__TX_PRE_CURSOR_MASK                                           0x003FL
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_2__PRE_OVRD_EN_MASK                                             0x0040L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_2__TX_POST_CURSOR_MASK                                          0x1F80L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_2__POST_OVRD_EN_MASK                                            0x2000L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_2__HDMIMODE_EN_MASK                                             0x4000L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_2__HDMIMODE_ENABLE_OVRD_EN_MASK                                 0x8000L
//DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__CLK_RDY__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__CLK_RDY_OVRD_EN__SHIFT                                       0x1
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__DETECT_RX_REQ__SHIFT                                         0x2
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__DETECT_RX_REQ_OVRD_EN__SHIFT                                 0x3
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__INVERT__SHIFT                                                0x4
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__INVERT_OVRD_EN__SHIFT                                        0x5
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__LPD__SHIFT                                                   0x6
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__LPD_OVRD_EN__SHIFT                                           0x7
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__TX_DC_COUP_EN__SHIFT                                         0x8
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__TX_DC_COUP_EN_OVRD_EN__SHIFT                                 0x9
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__PMA_EXTENDED_FIFO_EN__SHIFT                                  0xa
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__PMA_EXTENDED_FIFO_EN_OVRD_EN__SHIFT                          0xb
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__TX_MPHY_MODE_EN__SHIFT                                       0xc
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__TX_MPHY_MODE_EN_OVRD_EN__SHIFT                               0xd
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__RESERVED_15_14__SHIFT                                        0xe
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__CLK_RDY_MASK                                                 0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__CLK_RDY_OVRD_EN_MASK                                         0x0002L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__DETECT_RX_REQ_MASK                                           0x0004L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__DETECT_RX_REQ_OVRD_EN_MASK                                   0x0008L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__INVERT_MASK                                                  0x0010L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__INVERT_OVRD_EN_MASK                                          0x0020L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__LPD_MASK                                                     0x0040L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__LPD_OVRD_EN_MASK                                             0x0080L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__TX_DC_COUP_EN_MASK                                           0x0100L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__TX_DC_COUP_EN_OVRD_EN_MASK                                   0x0200L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__PMA_EXTENDED_FIFO_EN_MASK                                    0x0400L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__PMA_EXTENDED_FIFO_EN_OVRD_EN_MASK                            0x0800L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__TX_MPHY_MODE_EN_MASK                                         0x1000L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__TX_MPHY_MODE_EN_OVRD_EN_MASK                                 0x2000L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_3__RESERVED_15_14_MASK                                          0xC000L
//DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_4
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_4__RESET__SHIFT                                                 0x0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_4__RESET_OVRD_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_4__RESET_MASK                                                   0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_4__RESET_OVRD_EN_MASK                                           0x0002L
//DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT__TX_ACK__SHIFT                                                 0x0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT__EN_TX_ACK__SHIFT                                              0x1
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT__DETRX_RESULT__SHIFT                                           0x2
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT__EN_DETRX_RESULT__SHIFT                                        0x3
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT__RESERVED_15_4__SHIFT                                          0x4
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT__TX_ACK_MASK                                                   0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT__EN_TX_ACK_MASK                                                0x0002L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT__DETRX_RESULT_MASK                                             0x0004L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT__EN_DETRX_RESULT_MASK                                          0x0008L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT__RESERVED_15_4_MASK                                            0xFFF0L
//DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__ACK__SHIFT                                                  0x0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__ACK_OVRD_EN__SHIFT                                          0x1
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__ADAPT_STS__SHIFT                                            0x2
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__ADAPT_STS_OVRD_EN__SHIFT                                    0x4
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__RX_ASYNC_DATA__SHIFT                                        0x5
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__RX_ASYNC_DATA_OVRD_EN__SHIFT                                0x6
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__RX_SQ_WEAKKEEP_OUT__SHIFT                                   0x7
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__RX_SQ_WEAKKEEP_OUT_OVRD_EN__SHIFT                           0x8
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__RESERVED_15_9__SHIFT                                        0x9
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__ACK_MASK                                                    0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__ACK_OVRD_EN_MASK                                            0x0002L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__ADAPT_STS_MASK                                              0x000CL
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__ADAPT_STS_OVRD_EN_MASK                                      0x0010L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__RX_ASYNC_DATA_MASK                                          0x0020L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__RX_ASYNC_DATA_OVRD_EN_MASK                                  0x0040L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__RX_SQ_WEAKKEEP_OUT_MASK                                     0x0080L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__RX_SQ_WEAKKEEP_OUT_OVRD_EN_MASK                             0x0100L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_OVRD_OUT_0__RESERVED_15_9_MASK                                          0xFE00L
//DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_ASIC_IN
#define DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_ASIC_IN__LANE_TX2RX_SER_LB__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_ASIC_IN__LANE_RX2TX_PAR_LB__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_ASIC_IN__RESERVED_15_2__SHIFT                                         0x2
#define DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_ASIC_IN__LANE_TX2RX_SER_LB_MASK                                       0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_ASIC_IN__LANE_RX2TX_PAR_LB_MASK                                       0x0002L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_LANE_ASIC_IN__RESERVED_15_2_MASK                                           0xFFFCL
//DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__CLK_RDY__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__RESET__SHIFT                                                 0x1
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__INVERT__SHIFT                                                0x2
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__DATA_EN__SHIFT                                               0x3
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__REQ__SHIFT                                                   0x4
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__LPD__SHIFT                                                   0x5
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__PSTATE__SHIFT                                                0x6
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__RATE__SHIFT                                                  0x8
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__WIDTH__SHIFT                                                 0xb
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__MPLLB_SEL__SHIFT                                             0xd
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__DETECT_RX_REQ__SHIFT                                         0xe
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__DISABLE__SHIFT                                               0xf
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__CLK_RDY_MASK                                                 0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__RESET_MASK                                                   0x0002L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__INVERT_MASK                                                  0x0004L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__DATA_EN_MASK                                                 0x0008L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__REQ_MASK                                                     0x0010L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__LPD_MASK                                                     0x0020L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__PSTATE_MASK                                                  0x00C0L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__RATE_MASK                                                    0x0700L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__WIDTH_MASK                                                   0x1800L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__MPLLB_SEL_MASK                                               0x2000L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__DETECT_RX_REQ_MASK                                           0x4000L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_0__DISABLE_MASK                                                 0x8000L
//DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_1
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_1__BEACON_EN__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_1__TX_MAIN_CURSOR__SHIFT                                        0x1
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_EN__SHIFT                                           0x7
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_DATA__SHIFT                                         0x8
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_DRV_EN__SHIFT                                       0x9
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_1__TX_VREGDRV_BYP__SHIFT                                        0xa
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_1__BEACON_EN_MASK                                               0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_1__TX_MAIN_CURSOR_MASK                                          0x007EL
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_EN_MASK                                             0x0080L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_DATA_MASK                                           0x0100L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_1__TX_ASYNC_DRV_EN_MASK                                         0x0200L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_1__TX_VREGDRV_BYP_MASK                                          0x0400L
//DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_2
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_2__TX_PRE_CURSOR__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_2__TX_POST_CURSOR__SHIFT                                        0x6
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_2__RESERVED_15_12__SHIFT                                        0xc
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_2__TX_PRE_CURSOR_MASK                                           0x003FL
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_2__TX_POST_CURSOR_MASK                                          0x0FC0L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_IN_2__RESERVED_15_12_MASK                                          0xF000L
//DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_OUT
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_OUT__TX_ACK__SHIFT                                                 0x0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_OUT__DETRX_RESULT__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_OUT__RESERVED_15_2__SHIFT                                          0x2
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_OUT__TX_ACK_MASK                                                   0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_OUT__DETRX_RESULT_MASK                                             0x0002L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_ASIC_OUT__RESERVED_15_2_MASK                                            0xFFFCL
//DPCSSYS_CR0_LANE3_DIG_ASIC_RX_ASIC_OUT_0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_ASIC_OUT_0__ACK__SHIFT                                                  0x0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_ASIC_OUT_0__VALID__SHIFT                                                0x1
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_ASIC_OUT_0__ADAPT_STS__SHIFT                                            0x2
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_ASIC_OUT_0__RESERVED_15_4__SHIFT                                        0x4
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_ASIC_OUT_0__ACK_MASK                                                    0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_ASIC_OUT_0__VALID_MASK                                                  0x0002L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_ASIC_OUT_0__ADAPT_STS_MASK                                              0x000CL
#define DPCSSYS_CR0_LANE3_DIG_ASIC_RX_ASIC_OUT_0__RESERVED_15_4_MASK                                          0xFFF0L
//DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__RPTR_EN_MASTER_LANE__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__RPTR_EN_MASTER_LANE_OVRD_EN__SHIFT                           0x1
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_EN_OTHER_LANE__SHIFT                                 0x2
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_EN_OTHER_LANE_OVRD_EN__SHIFT                         0x3
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_STATE_MASTER_LANE__SHIFT                             0x4
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_STATE_MASTER_LANE_OVRD_EN__SHIFT                     0x5
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__SHIFT_MASTER_LANE__SHIFT                                     0x6
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__SHIFT_MASTER_LANE_ORVD_EN__SHIFT                             0x7
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__SHIFT_ACK_OTHER_LANE__SHIFT                                  0x8
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__SHIFT_ACK_OTHER_LANE_OVRD_EN__SHIFT                          0x9
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__LANE_MASTER__SHIFT                                           0xa
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__LANE_MASTER_OVRD_IN_EN__SHIFT                                0xb
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__TX_DWORD_CLK_SYNC_OVRD__SHIFT                                0xc
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__TX_DWORD_CLK_SYNC_OVRD_EN__SHIFT                             0xd
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__RESERVED_15_14__SHIFT                                        0xe
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__RPTR_EN_MASTER_LANE_MASK                                     0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__RPTR_EN_MASTER_LANE_OVRD_EN_MASK                             0x0002L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_EN_OTHER_LANE_MASK                                   0x0004L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_EN_OTHER_LANE_OVRD_EN_MASK                           0x0008L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_STATE_MASTER_LANE_MASK                               0x0010L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__DIG_CLK_STATE_MASTER_LANE_OVRD_EN_MASK                       0x0020L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__SHIFT_MASTER_LANE_MASK                                       0x0040L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__SHIFT_MASTER_LANE_ORVD_EN_MASK                               0x0080L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__SHIFT_ACK_OTHER_LANE_MASK                                    0x0100L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__SHIFT_ACK_OTHER_LANE_OVRD_EN_MASK                            0x0200L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__LANE_MASTER_MASK                                             0x0400L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__LANE_MASTER_OVRD_IN_EN_MASK                                  0x0800L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__TX_DWORD_CLK_SYNC_OVRD_MASK                                  0x1000L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__TX_DWORD_CLK_SYNC_OVRD_EN_MASK                               0x2000L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_IN_5__RESERVED_15_14_MASK                                          0xC000L
//DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__RPTR_EN_OUT__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__RPTR_EN_OUT_OVRD_EN__SHIFT                                  0x1
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_EN_OUT__SHIFT                                       0x2
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_EN_OUT_OVRD_EN__SHIFT                               0x3
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_STATE_OUT__SHIFT                                    0x4
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_STATE_OUT_OVRD_EN__SHIFT                            0x5
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_OUT__SHIFT                                            0x6
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_OUT_OVRD_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_ACK_OUT__SHIFT                                        0x8
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_ACK_OUT_OVRD_EN__SHIFT                                0x9
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__RESERVED_15_10__SHIFT                                       0xa
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__RPTR_EN_OUT_MASK                                            0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__RPTR_EN_OUT_OVRD_EN_MASK                                    0x0002L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_EN_OUT_MASK                                         0x0004L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_EN_OUT_OVRD_EN_MASK                                 0x0008L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_STATE_OUT_MASK                                      0x0010L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__DIG_CLK_STATE_OUT_OVRD_EN_MASK                              0x0020L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_OUT_MASK                                              0x0040L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_OUT_OVRD_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_ACK_OUT_MASK                                          0x0100L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__SHIFT_ACK_OUT_OVRD_EN_MASK                                  0x0200L
#define DPCSSYS_CR0_LANE3_DIG_ASIC_TX_OVRD_OUT_1__RESERVED_15_10_MASK                                         0xFC00L
//DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_REFGEN_EN__SHIFT                              0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_VCM_HOLD__SHIFT                               0x1
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_CLK_EN__SHIFT                                 0x2
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_WORD_CLK_EN__SHIFT                            0x3
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_RESET__SHIFT                                  0x4
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_SERIAL_EN__SHIFT                              0x5
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_DIG_CLK_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_DATA_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ALLOW_RXDET__SHIFT                                0x8
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_DCC_COMP_CAL_EN__SHIFT                        0x9
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__RESERVED_15_10__SHIFT                                   0xa
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_REFGEN_EN_MASK                                0x0001L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_VCM_HOLD_MASK                                 0x0002L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_CLK_EN_MASK                                   0x0004L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_WORD_CLK_EN_MASK                              0x0008L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_RESET_MASK                                    0x0010L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_SERIAL_EN_MASK                                0x0020L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_DIG_CLK_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_DATA_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ALLOW_RXDET_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__TX_P0_ANA_DCC_COMP_CAL_EN_MASK                          0x0200L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0__RESERVED_15_10_MASK                                     0xFC00L
//DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_REFGEN_EN__SHIFT                            0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_VCM_HOLD__SHIFT                             0x1
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_CLK_EN__SHIFT                               0x2
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_WORD_CLK_EN__SHIFT                          0x3
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_RESET__SHIFT                                0x4
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_SERIAL_EN__SHIFT                            0x5
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_DIG_CLK_EN__SHIFT                               0x6
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_DATA_EN__SHIFT                                  0x7
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ALLOW_RXDET__SHIFT                              0x8
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_DCC_COMP_CAL_EN__SHIFT                      0x9
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__RESERVED_15_10__SHIFT                                  0xa
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_REFGEN_EN_MASK                              0x0001L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_VCM_HOLD_MASK                               0x0002L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_CLK_EN_MASK                                 0x0004L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_WORD_CLK_EN_MASK                            0x0008L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_RESET_MASK                                  0x0010L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_SERIAL_EN_MASK                              0x0020L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_DIG_CLK_EN_MASK                                 0x0040L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_DATA_EN_MASK                                    0x0080L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ALLOW_RXDET_MASK                                0x0100L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__TX_P0S_ANA_DCC_COMP_CAL_EN_MASK                        0x0200L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P0S__RESERVED_15_10_MASK                                    0xFC00L
//DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_REFGEN_EN__SHIFT                              0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_VCM_HOLD__SHIFT                               0x1
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_CLK_EN__SHIFT                                 0x2
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_WORD_CLK_EN__SHIFT                            0x3
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_RESET__SHIFT                                  0x4
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_SERIAL_EN__SHIFT                              0x5
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_DIG_CLK_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_DATA_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ALLOW_RXDET__SHIFT                                0x8
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_DCC_COMP_CAL_EN__SHIFT                        0x9
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__RESERVED_15_10__SHIFT                                   0xa
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_REFGEN_EN_MASK                                0x0001L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_VCM_HOLD_MASK                                 0x0002L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_CLK_EN_MASK                                   0x0004L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_WORD_CLK_EN_MASK                              0x0008L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_RESET_MASK                                    0x0010L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_SERIAL_EN_MASK                                0x0020L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_DIG_CLK_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_DATA_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ALLOW_RXDET_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__TX_P1_ANA_DCC_COMP_CAL_EN_MASK                          0x0200L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P1__RESERVED_15_10_MASK                                     0xFC00L
//DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_REFGEN_EN__SHIFT                              0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_VCM_HOLD__SHIFT                               0x1
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_CLK_EN__SHIFT                                 0x2
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_WORD_CLK_EN__SHIFT                            0x3
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_RESET__SHIFT                                  0x4
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_SERIAL_EN__SHIFT                              0x5
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_DIG_CLK_EN__SHIFT                                 0x6
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_DATA_EN__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ALLOW_RXDET__SHIFT                                0x8
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ALLOW_VBOOST__SHIFT                               0x9
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_DCC_COMP_CAL_EN__SHIFT                        0xa
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__RESERVED_15_11__SHIFT                                   0xb
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_REFGEN_EN_MASK                                0x0001L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_VCM_HOLD_MASK                                 0x0002L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_CLK_EN_MASK                                   0x0004L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_WORD_CLK_EN_MASK                              0x0008L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_RESET_MASK                                    0x0010L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_SERIAL_EN_MASK                                0x0020L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_DIG_CLK_EN_MASK                                   0x0040L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_DATA_EN_MASK                                      0x0080L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ALLOW_RXDET_MASK                                  0x0100L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ALLOW_VBOOST_MASK                                 0x0200L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__TX_P2_ANA_DCC_COMP_CAL_EN_MASK                          0x0400L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PSTATE_P2__RESERVED_15_11_MASK                                     0xF800L
//DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_0__TX_REFGEN_EN_TIME__SHIFT                             0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_0__TX_CLK_EN__SHIFT                                     0x8
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_0__TX_REFGEN_EN_TIME_MASK                               0x00FFL
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_0__TX_CLK_EN_MASK                                       0xFF00L
//DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_1
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_1__TX_VCM_HOLD_TIME_14_0__SHIFT                         0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_1__SKIP_TX_VCM_HOLD_WAIT__SHIFT                         0xf
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_1__TX_VCM_HOLD_TIME_14_0_MASK                           0x7FFFL
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_1__SKIP_TX_VCM_HOLD_WAIT_MASK                           0x8000L
//DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_2
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_2__TX_VBOOST_DIS_TIME_12_0__SHIFT                       0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_2__DTB_SEL__SHIFT                                       0xd
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_2__TX_VBOOST_DIS_TIME_12_0_MASK                         0x1FFFL
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_2__DTB_SEL_MASK                                         0xE000L
//DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_3
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__TX_VCM_HOLD_TIME_17_15__SHIFT                        0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__TX_VBOOST_DIS_TIME_13__SHIFT                         0x3
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__RESERVED_15_4__SHIFT                                 0x4
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__TX_VCM_HOLD_TIME_17_15_MASK                          0x0007L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__TX_VBOOST_DIS_TIME_13_MASK                           0x0008L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_3__RESERVED_15_4_MASK                                   0xFFF0L
//DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_4
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_4__TX_VCM_HOLD_GS_TIME__SHIFT                           0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_4__SKIP_TX_VCM_HOLD_GS_PULSE__SHIFT                     0xf
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_4__TX_VCM_HOLD_GS_TIME_MASK                             0x7FFFL
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_4__SKIP_TX_VCM_HOLD_GS_PULSE_MASK                       0x8000L
//DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_5
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_RXDET_TIME__SHIFT                                 0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__FAST_TX_RXDET__SHIFT                                 0xa
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_RESET_TIME__SHIFT                                 0xb
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_SERIAL_EN_TIME__SHIFT                             0xd
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__RESERVED_15_15__SHIFT                                0xf
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_RXDET_TIME_MASK                                   0x03FFL
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__FAST_TX_RXDET_MASK                                   0x0400L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_RESET_TIME_MASK                                   0x1800L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__TX_SERIAL_EN_TIME_MASK                               0x6000L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_TX_PWRUP_TIME_5__RESERVED_15_15_MASK                                  0x8000L
//DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_CR_BANK_ADDR
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_CR_BANK_ADDR__ADDR__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_CR_BANK_ADDR__ADDR_MASK                                           0xFFFFL
//DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_CR_BANK_DATA
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_CR_BANK_DATA__DATA__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_CR_BANK_DATA__DATA_MASK                                           0xFFFFL
//DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_CTRL
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_CTRL__CTRL__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_CTRL__RESERVED_15_8__SHIFT                                    0x8
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_CTRL__CTRL_MASK                                               0x00FFL
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_CTRL__RESERVED_15_8_MASK                                      0xFF00L
//DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_RANGE
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_RANGE__CTRL__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_RANGE__RESERVED_15_2__SHIFT                                   0x2
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_RANGE__CTRL_MASK                                              0x0003L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_RANGE__RESERVED_15_2_MASK                                     0xFFFCL
//DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_SEL
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_SEL__SEL__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_SEL__REQ__SHIFT                                               0x3
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_SEL__CTRL_UPD__SHIFT                                          0x4
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_SEL__RANGE_UPD__SHIFT                                         0x5
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_SEL__BIN_HOT__SHIFT                                           0x6
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_SEL__SEL_MASK                                                 0x0007L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_SEL__REQ_MASK                                                 0x0008L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_SEL__CTRL_UPD_MASK                                            0x0010L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_SEL__RANGE_UPD_MASK                                           0x0020L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_SEL__BIN_HOT_MASK                                             0x0040L
//DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_ACK
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_ACK__ACK__SHIFT                                               0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_ACK__RESERVED_15_1__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_ACK__ACK_MASK                                                 0x0001L
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_ACK__RESERVED_15_1_MASK                                       0xFFFEL
//DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_ADDR
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_ADDR__ADDR__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_PWRCTL_DCC_DAC_ADDR__ADDR_MASK                                               0xFFFFL
//DPCSSYS_CR0_LANE3_DIG_TX_CLK_ALIGN_TX_CTL_0
#define DPCSSYS_CR0_LANE3_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_NUM_2UI_SHIFTS_16B_MODE__SHIFT                        0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_NUM_2UI_SHIFTS_20B_MODE__SHIFT                        0x4
#define DPCSSYS_CR0_LANE3_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_FIFO_BYPASS__SHIFT                                    0x8
#define DPCSSYS_CR0_LANE3_DIG_TX_CLK_ALIGN_TX_CTL_0__RESERVED_15_9__SHIFT                                     0x9
#define DPCSSYS_CR0_LANE3_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_NUM_2UI_SHIFTS_16B_MODE_MASK                          0x000FL
#define DPCSSYS_CR0_LANE3_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_NUM_2UI_SHIFTS_20B_MODE_MASK                          0x00F0L
#define DPCSSYS_CR0_LANE3_DIG_TX_CLK_ALIGN_TX_CTL_0__TX_FIFO_BYPASS_MASK                                      0x0100L
#define DPCSSYS_CR0_LANE3_DIG_TX_CLK_ALIGN_TX_CTL_0__RESERVED_15_9_MASK                                       0xFE00L
//DPCSSYS_CR0_LANE3_DIG_TX_LBERT_CTL
#define DPCSSYS_CR0_LANE3_DIG_TX_LBERT_CTL__MODE__SHIFT                                                       0x0
#define DPCSSYS_CR0_LANE3_DIG_TX_LBERT_CTL__TRIGGER_ERR__SHIFT                                                0x4
#define DPCSSYS_CR0_LANE3_DIG_TX_LBERT_CTL__PAT0__SHIFT                                                       0x5
#define DPCSSYS_CR0_LANE3_DIG_TX_LBERT_CTL__RESERVED_15_15__SHIFT                                             0xf
#define DPCSSYS_CR0_LANE3_DIG_TX_LBERT_CTL__MODE_MASK                                                         0x000FL
#define DPCSSYS_CR0_LANE3_DIG_TX_LBERT_CTL__TRIGGER_ERR_MASK                                                  0x0010L
#define DPCSSYS_CR0_LANE3_DIG_TX_LBERT_CTL__PAT0_MASK                                                         0x7FE0L
#define DPCSSYS_CR0_LANE3_DIG_TX_LBERT_CTL__RESERVED_15_15_MASK                                               0x8000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_LD_VAL_1
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_LD_VAL_1__SC1_LD_VAL__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_LD_VAL_1__SC1_START__SHIFT                                              0xf
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_LD_VAL_1__SC1_LD_VAL_MASK                                               0x7FFFL
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_LD_VAL_1__SC1_START_MASK                                                0x8000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_DATA_MSK
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_DATA_MSK__DATA_MSK_15_0__SHIFT                                          0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_DATA_MSK__DATA_MSK_15_0_MASK                                            0xFFFFL
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL0__PTTRN_MSK_CR1A_4_0__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL0__PTTRN_CR1A_4_0__SHIFT                                       0x5
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL0__DATA_MSK_19_16__SHIFT                                       0xa
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL0__SCOPE_DLY__SHIFT                                            0xe
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL0__PTTRN_MSK_CR1A_4_0_MASK                                     0x001FL
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL0__PTTRN_CR1A_4_0_MASK                                         0x03E0L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL0__DATA_MSK_19_16_MASK                                         0x3C00L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL0__SCOPE_DLY_MASK                                              0xC000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL1
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1B_EN__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL1__PTTRN_MSK_CR1B_4_0__SHIFT                                   0x1
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1B_4_0__SHIFT                                       0x6
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1A_ADPT_EN__SHIFT                                   0xb
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL1__RESERVED_15_12__SHIFT                                       0xc
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1B_EN_MASK                                          0x0001L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL1__PTTRN_MSK_CR1B_4_0_MASK                                     0x003EL
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1B_4_0_MASK                                         0x07C0L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL1__PTTRN_CR1A_ADPT_EN_MASK                                     0x0800L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL1__RESERVED_15_12_MASK                                         0xF000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__RESERVED_0__SHIFT                                            0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__CORR_SHFT_SEL_VGA__SHIFT                                     0x1
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__CORR_SHFT_SEL__SHIFT                                         0x2
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__CORR_SRC_SEL__SHIFT                                          0x3
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__CORR_MODE_EN__SHIFT                                          0x5
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__STAT_SHFT_SEL__SHIFT                                         0x6
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__STAT_SRC_SEL__SHIFT                                          0xa
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__STAT_RXCLK_SEL__SHIFT                                        0xd
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__SC_TIMER_MODE__SHIFT                                         0xe
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__SKIP_EN__SHIFT                                               0xf
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__RESERVED_0_MASK                                              0x0001L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__CORR_SHFT_SEL_VGA_MASK                                       0x0002L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__CORR_SHFT_SEL_MASK                                           0x0004L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__CORR_SRC_SEL_MASK                                            0x0018L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__CORR_MODE_EN_MASK                                            0x0020L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__STAT_SHFT_SEL_MASK                                           0x03C0L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__STAT_SRC_SEL_MASK                                            0x1C00L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__STAT_RXCLK_SEL_MASK                                          0x2000L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__SC_TIMER_MODE_MASK                                           0x4000L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL0__SKIP_EN_MASK                                                 0x8000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__STAT_CNT_0_EN__SHIFT                                         0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__STAT_CNT_1_EN__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__STAT_CNT_2_EN__SHIFT                                         0x2
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__STAT_CNT_3_EN__SHIFT                                         0x3
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__STAT_CNT_4_EN__SHIFT                                         0x4
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__STAT_CNT_5_EN__SHIFT                                         0x5
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__STAT_CNT_6_EN__SHIFT                                         0x6
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__RESERVED_8_7__SHIFT                                          0x7
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__SC_PAUSE__SHIFT                                              0x9
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__STAT_CLK_EN__SHIFT                                           0xa
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__DATA_DLY_SEL__SHIFT                                          0xb
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__VLD_LOSS_CLR__SHIFT                                          0xd
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__VLD_CTL__SHIFT                                               0xe
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__STAT_CNT_0_EN_MASK                                           0x0001L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__STAT_CNT_1_EN_MASK                                           0x0002L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__STAT_CNT_2_EN_MASK                                           0x0004L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__STAT_CNT_3_EN_MASK                                           0x0008L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__STAT_CNT_4_EN_MASK                                           0x0010L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__STAT_CNT_5_EN_MASK                                           0x0020L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__STAT_CNT_6_EN_MASK                                           0x0040L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__RESERVED_8_7_MASK                                            0x0180L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__SC_PAUSE_MASK                                                0x0200L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__STAT_CLK_EN_MASK                                             0x0400L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__DATA_DLY_SEL_MASK                                            0x1800L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__VLD_LOSS_CLR_MASK                                            0x2000L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL1__VLD_CTL_MASK                                                 0xC000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_SMPL_CNT1
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_SMPL_CNT1__SMPL_CNT1__SHIFT                                             0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_SMPL_CNT1__SMPL_CNT1_DONE__SHIFT                                        0xf
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_SMPL_CNT1__SMPL_CNT1_MASK                                               0x7FFFL
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_SMPL_CNT1__SMPL_CNT1_DONE_MASK                                          0x8000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_0__STAT_CNT_0__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_0__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_0__STAT_CNT_0_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_0__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_1
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_1__STAT_CNT_1__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_1__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_1__STAT_CNT_1_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_1__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_2
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_2__STAT_CNT_2__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_2__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_2__STAT_CNT_2_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_2__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_3
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_3__STAT_CNT_3__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_3__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_3__STAT_CNT_3_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_3__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_4
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_4__STAT_CNT_4__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_4__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_4__STAT_CNT_4_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_4__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_5
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_5__STAT_CNT_5__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_5__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_5__STAT_CNT_5_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_5__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_6
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_6__STAT_CNT_6__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_6__SMPL_CNT1_DONE__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_6__STAT_CNT_6_MASK                                             0x7FFFL
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CNT_6__SMPL_CNT1_DONE_MASK                                         0x8000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_CAL_COMP_CLK_CTL
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_CAL_COMP_CLK_CTL__PRECHRGE_CNT__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_CAL_COMP_CLK_CTL__REF_DIV_CNT__SHIFT                                    0x3
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_CAL_COMP_CLK_CTL__RESERVED_15_6__SHIFT                                  0x6
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_CAL_COMP_CLK_CTL__PRECHRGE_CNT_MASK                                     0x0007L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_CAL_COMP_CLK_CTL__REF_DIV_CNT_MASK                                      0x0038L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_CAL_COMP_CLK_CTL__RESERVED_15_6_MASK                                    0xFFC0L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL2
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL2__PTTRN_CR1A_19_5__SHIFT                                      0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL2__RESERVED_15_15__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL2__PTTRN_CR1A_19_5_MASK                                        0x7FFFL
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL2__RESERVED_15_15_MASK                                         0x8000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL3
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL3__PTTRN_MSK_CR1A_19_5__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL3__RESERVED_15_15__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL3__PTTRN_MSK_CR1A_19_5_MASK                                    0x7FFFL
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL3__RESERVED_15_15_MASK                                         0x8000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL4
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL4__PTTRN_CR1B_19_5__SHIFT                                      0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL4__RESERVED_15_15__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL4__PTTRN_CR1B_19_5_MASK                                        0x7FFFL
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL4__RESERVED_15_15_MASK                                         0x8000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL5
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL5__PTTRN_MSK_CR1B_19_5__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL5__RESERVED_15_15__SHIFT                                       0xf
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL5__PTTRN_MSK_CR1B_19_5_MASK                                    0x7FFFL
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_MATCH_CTL5__RESERVED_15_15_MASK                                         0x8000L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL2
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL2__DATA_DLY_SEL_2__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL2__SCOPE_DLY_2__SHIFT                                           0x1
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL2__DISABLE_SAMPLE_COUNT__SHIFT                                  0x2
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL2__RESERVED_15_3__SHIFT                                         0x3
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL2__DATA_DLY_SEL_2_MASK                                          0x0001L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL2__SCOPE_DLY_2_MASK                                             0x0002L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL2__DISABLE_SAMPLE_COUNT_MASK                                    0x0004L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_CTL2__RESERVED_15_3_MASK                                           0xFFF8L
//DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_STOP
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_STOP__SC1_STOP__SHIFT                                              0x0
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_STOP__RESERVED_15_1__SHIFT                                         0x1
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_STOP__SC1_STOP_MASK                                                0x0001L
#define DPCSSYS_CR0_LANE3_DIG_RX_STAT_STAT_STOP__RESERVED_15_1_MASK                                           0xFFFEL
//DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_CLK_SHIFT__SHIFT                                        0x0
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_DATA_EN__SHIFT                                          0x1
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_REFGEN_EN__SHIFT                                        0x2
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_VCM_HOLD__SHIFT                                         0x3
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_CLK_EN__SHIFT                                           0x4
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_WORD_CLK_EN__SHIFT                                      0x5
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_MPLLA_CLK_EN__SHIFT                                     0x6
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_MPLLB_CLK_EN__SHIFT                                     0x7
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_RESET__SHIFT                                            0x8
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_SERIAL_EN__SHIFT                                        0x9
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_DATA_RATE__SHIFT                                        0xa
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__RESERVED__SHIFT                                                0xc
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_DIV4_EN__SHIFT                                              0xd
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_RXDET_EN__SHIFT                                             0xe
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_OVRD_EN__SHIFT                                              0xf
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_CLK_SHIFT_MASK                                          0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_DATA_EN_MASK                                            0x0002L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_REFGEN_EN_MASK                                          0x0004L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_VCM_HOLD_MASK                                           0x0008L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_CLK_EN_MASK                                             0x0010L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_WORD_CLK_EN_MASK                                        0x0020L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_MPLLA_CLK_EN_MASK                                       0x0040L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_MPLLB_CLK_EN_MASK                                       0x0080L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_RESET_MASK                                              0x0100L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_SERIAL_EN_MASK                                          0x0200L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_ANA_DATA_RATE_MASK                                          0x0C00L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__RESERVED_MASK                                                  0x1000L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_DIV4_EN_MASK                                                0x2000L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_RXDET_EN_MASK                                               0x4000L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT__TX_OVRD_EN_MASK                                                0x8000L
//DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_OVRD_OUT
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_TERM_CODE__SHIFT                                  0x0
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_TERM_OVRD_EN__SHIFT                               0xa
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_DRV_SRC__SHIFT                                    0xb
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_DRV_SRC_OVRD_EN__SHIFT                            0xd
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_OVRD_OUT__RESERVED_15_14__SHIFT                                0xe
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_TERM_CODE_MASK                                    0x03FFL
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_TERM_OVRD_EN_MASK                                 0x0400L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_DRV_SRC_MASK                                      0x1800L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_OVRD_OUT__TX_DRV_SRC_OVRD_EN_MASK                              0x2000L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_OVRD_OUT__RESERVED_15_14_MASK                                  0xC000L
//DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__TX_TERM_DN_CLK__SHIFT                            0x0
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__TX_TERM_CLK_SELF_CLEAR_DISABLE__SHIFT            0x1
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__RESERVED_15_2__SHIFT                             0x2
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__TX_TERM_DN_CLK_MASK                              0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__TX_TERM_CLK_SELF_CLEAR_DISABLE_MASK              0x0002L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_TERM_CODE_CLK_OVRD_OUT__RESERVED_15_2_MASK                               0xFFFCL
//DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_0
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_ANA_LOAD_CLK__SHIFT                                    0x0
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_ANA_CTRL_LEG_PULL_EN_13_0__SHIFT                       0x1
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_EQ_OVRD_EN__SHIFT                                      0xf
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_ANA_LOAD_CLK_MASK                                      0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_ANA_CTRL_LEG_PULL_EN_13_0_MASK                         0x7FFEL
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_0__TX_EQ_OVRD_EN_MASK                                        0x8000L
//DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_1
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_1__TX_ANA_CTRL_LEG_PULL_EN_19_14__SHIFT                      0x0
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_1__RESERVED_15_6__SHIFT                                      0x6
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_1__TX_ANA_CTRL_LEG_PULL_EN_19_14_MASK                        0x003FL
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_1__RESERVED_15_6_MASK                                        0xFFC0L
//DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_2
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_2__RESERVED__SHIFT                                           0x0
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_2__TX_ANA_CTRL_EQ_MUX_SEL__SHIFT                             0x3
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_2__TX_ANA_CTRL_PRE__SHIFT                                    0x7
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_2__RESERVED_15_13__SHIFT                                     0xd
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_2__RESERVED_MASK                                             0x0007L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_2__TX_ANA_CTRL_EQ_MUX_SEL_MASK                               0x0078L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_2__TX_ANA_CTRL_PRE_MASK                                      0x1F80L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_2__RESERVED_15_13_MASK                                       0xE000L
//DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_3
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_3__TX_ANA_CTRL_POST__SHIFT                                   0x0
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_3__RESERVED_15_9__SHIFT                                      0x9
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_3__TX_ANA_CTRL_POST_MASK                                     0x01FFL
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_3__RESERVED_15_9_MASK                                        0xFE00L
//DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_4
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_4__TX_ANA_CTRL_LEG_PULL_DIR_19_4__SHIFT                      0x0
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_4__TX_ANA_CTRL_LEG_PULL_DIR_19_4_MASK                        0xFFFFL
//DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_5
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_5__TX_ANA_CTRL_LEG_PULL_DIR_3_0__SHIFT                       0x0
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_5__RESERVED_15_4__SHIFT                                      0x4
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_5__TX_ANA_CTRL_LEG_PULL_DIR_3_0_MASK                         0x000FL
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_EQ_OVRD_OUT_5__RESERVED_15_4_MASK                                        0xFFF0L
//DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__TX_ANA_CLK_SHIFT_ACK__SHIFT                                       0x0
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__TX_ANA_RXDETP_RESULT__SHIFT                                       0x1
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__TX_ANA_RXDETM_RESULT__SHIFT                                       0x2
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__TX_ANA_LOOPBACK_EN__SHIFT                                         0x3
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__TX_ANA_CLK_LB_EN__SHIFT                                           0x4
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__RX_ANA_CAL_RESULT__SHIFT                                          0x5
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__RX_ANA_SCOPE_DATA__SHIFT                                          0x6
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__TX_ANA_DCC_CAL_RESULT__SHIFT                                      0x7
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__TX_ANA_CTRL_EQ_MUX__SHIFT                                         0x8
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__TX_ANA_CLK_SHIFT_ACK_MASK                                         0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__TX_ANA_RXDETP_RESULT_MASK                                         0x0002L
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__TX_ANA_RXDETM_RESULT_MASK                                         0x0004L
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__TX_ANA_LOOPBACK_EN_MASK                                           0x0008L
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__TX_ANA_CLK_LB_EN_MASK                                             0x0010L
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__RX_ANA_CAL_RESULT_MASK                                            0x0020L
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__RX_ANA_SCOPE_DATA_MASK                                            0x0040L
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__TX_ANA_DCC_CAL_RESULT_MASK                                        0x0080L
#define DPCSSYS_CR0_LANE3_DIG_ANA_STATUS_0__TX_ANA_CTRL_EQ_MUX_MASK                                           0xFF00L
//DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_RANGE__SHIFT                            0x0
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_RANGE_OVRD_EN__SHIFT                    0x2
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_COMP_EN__SHIFT                          0x3
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_COMP_EN_OVRD_EN__SHIFT                  0x4
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL__SHIFT                             0x5
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_OVRD_EN__SHIFT                     0xd
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_EN__SHIFT                          0xe
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_EN_OVRD_EN__SHIFT                  0xf
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_RANGE_MASK                              0x0003L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_RANGE_OVRD_EN_MASK                      0x0004L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_COMP_EN_MASK                            0x0008L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_COMP_EN_OVRD_EN_MASK                    0x0010L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_MASK                               0x1FE0L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_OVRD_EN_MASK                       0x2000L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_EN_MASK                            0x4000L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT__TX_ANA_DCC_CAL_CTRL_EN_OVRD_EN_MASK                    0x8000L
//DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CAL_CTRL_SEL__SHIFT                       0x0
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CAL_CTRL_SEL_OVRD_EN__SHIFT               0x3
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CLK_COMP__SHIFT                           0x4
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CLK_COMP_OVRD_EN__SHIFT                   0x5
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CAL_CTRL_SEL_MASK                         0x0007L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CAL_CTRL_SEL_OVRD_EN_MASK                 0x0008L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CLK_COMP_MASK                             0x0010L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_DCC_DAC_OVRD_OUT_2__TX_ANA_DCC_CLK_COMP_OVRD_EN_MASK                     0x0020L
//DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT_2
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT_2__TX_ANA_FAST_START__SHIFT                                     0x0
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT_2__TX_ANA_FAST_START_OVRD_EN__SHIFT                             0x1
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT_2__TX_CLK_LB_EN__SHIFT                                          0x2
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT_2__TX_CLK_LB_EN_OVRD_EN__SHIFT                                  0x3
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT_2__TX_ACJTAG_EN__SHIFT                                          0x4
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT_2__RESERVED_15_5__SHIFT                                         0x5
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT_2__TX_ANA_FAST_START_MASK                                       0x0001L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT_2__TX_ANA_FAST_START_OVRD_EN_MASK                               0x0002L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT_2__TX_CLK_LB_EN_MASK                                            0x0004L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT_2__TX_CLK_LB_EN_OVRD_EN_MASK                                    0x0008L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT_2__TX_ACJTAG_EN_MASK                                            0x0010L
#define DPCSSYS_CR0_LANE3_DIG_ANA_TX_OVRD_OUT_2__RESERVED_15_5_MASK                                           0xFFE0L
//DPCSSYS_CR0_LANE3_ANA_TX_OVRD_MEAS
#define DPCSSYS_CR0_LANE3_ANA_TX_OVRD_MEAS__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE3_ANA_TX_OVRD_MEAS__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE3_ANA_TX_PWR_OVRD
#define DPCSSYS_CR0_LANE3_ANA_TX_PWR_OVRD__RESERVED_15_8__SHIFT                                               0x8
#define DPCSSYS_CR0_LANE3_ANA_TX_PWR_OVRD__RESERVED_15_8_MASK                                                 0xFF00L
//DPCSSYS_CR0_LANE3_ANA_TX_ALT_BUS
#define DPCSSYS_CR0_LANE3_ANA_TX_ALT_BUS__RESERVED_15_8__SHIFT                                                0x8
#define DPCSSYS_CR0_LANE3_ANA_TX_ALT_BUS__RESERVED_15_8_MASK                                                  0xFF00L
//DPCSSYS_CR0_LANE3_ANA_TX_ATB1
#define DPCSSYS_CR0_LANE3_ANA_TX_ATB1__RESERVED_15_8__SHIFT                                                   0x8
#define DPCSSYS_CR0_LANE3_ANA_TX_ATB1__RESERVED_15_8_MASK                                                     0xFF00L
//DPCSSYS_CR0_LANE3_ANA_TX_ATB2
#define DPCSSYS_CR0_LANE3_ANA_TX_ATB2__RESERVED_15_8__SHIFT                                                   0x8
#define DPCSSYS_CR0_LANE3_ANA_TX_ATB2__RESERVED_15_8_MASK                                                     0xFF00L
//DPCSSYS_CR0_LANE3_ANA_TX_DCC_DAC
#define DPCSSYS_CR0_LANE3_ANA_TX_DCC_DAC__RESERVED_15_8__SHIFT                                                0x8
#define DPCSSYS_CR0_LANE3_ANA_TX_DCC_DAC__RESERVED_15_8_MASK                                                  0xFF00L
//DPCSSYS_CR0_LANE3_ANA_TX_DCC_CTRL1
#define DPCSSYS_CR0_LANE3_ANA_TX_DCC_CTRL1__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE3_ANA_TX_DCC_CTRL1__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE3_ANA_TX_TERM_CODE
#define DPCSSYS_CR0_LANE3_ANA_TX_TERM_CODE__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE3_ANA_TX_TERM_CODE__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE3_ANA_TX_TERM_CODE_CTRL
#define DPCSSYS_CR0_LANE3_ANA_TX_TERM_CODE_CTRL__RESERVED_15_8__SHIFT                                         0x8
#define DPCSSYS_CR0_LANE3_ANA_TX_TERM_CODE_CTRL__RESERVED_15_8_MASK                                           0xFF00L
//DPCSSYS_CR0_LANE3_ANA_TX_OVRD_CLK
#define DPCSSYS_CR0_LANE3_ANA_TX_OVRD_CLK__RESERVED_15_8__SHIFT                                               0x8
#define DPCSSYS_CR0_LANE3_ANA_TX_OVRD_CLK__RESERVED_15_8_MASK                                                 0xFF00L
//DPCSSYS_CR0_LANE3_ANA_TX_MISC1
#define DPCSSYS_CR0_LANE3_ANA_TX_MISC1__RESERVED_15_8__SHIFT                                                  0x8
#define DPCSSYS_CR0_LANE3_ANA_TX_MISC1__RESERVED_15_8_MASK                                                    0xFF00L
//DPCSSYS_CR0_LANE3_ANA_TX_MISC2
#define DPCSSYS_CR0_LANE3_ANA_TX_MISC2__RESERVED_15_8__SHIFT                                                  0x8
#define DPCSSYS_CR0_LANE3_ANA_TX_MISC2__RESERVED_15_8_MASK                                                    0xFF00L
//DPCSSYS_CR0_LANE3_ANA_TX_RESERVED3
#define DPCSSYS_CR0_LANE3_ANA_TX_RESERVED3__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE3_ANA_TX_RESERVED3__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_LANE3_ANA_TX_RESERVED4
#define DPCSSYS_CR0_LANE3_ANA_TX_RESERVED4__NC7_0__SHIFT                                                      0x0
#define DPCSSYS_CR0_LANE3_ANA_TX_RESERVED4__RESERVED_15_8__SHIFT                                              0x8
#define DPCSSYS_CR0_LANE3_ANA_TX_RESERVED4__NC7_0_MASK                                                        0x00FFL
#define DPCSSYS_CR0_LANE3_ANA_TX_RESERVED4__RESERVED_15_8_MASK                                                0xFF00L
//DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL__PHY_FUNC_RST__SHIFT                                                   0x0
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL__RESERVED_15_1__SHIFT                                                  0x1
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL__PHY_FUNC_RST_MASK                                                     0x0001L
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL__RESERVED_15_1_MASK                                                    0xFFFEL
//DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_WORD_DIV2_EN_OVRD_VAL__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_WORD_DIV2_EN_OVRD_EN__SHIFT                               0x1
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_TX_CLK_DIV_OVRD_VAL__SHIFT                                0x2
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_TX_CLK_DIV_OVRD_EN__SHIFT                                 0x5
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_DIV10_CLK_EN_OVRD_VAL__SHIFT                              0x6
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_DIV10_CLK_EN_OVRD_EN__SHIFT                               0x7
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_DIV8_CLK_EN_OVRD_VAL__SHIFT                               0x8
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_DIV8_CLK_EN_OVRD_EN__SHIFT                                0x9
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_BW_OVRD_EN__SHIFT                                         0xa
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__RESERVED_15_11__SHIFT                                           0xb
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_WORD_DIV2_EN_OVRD_VAL_MASK                                0x0001L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_WORD_DIV2_EN_OVRD_EN_MASK                                 0x0002L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_TX_CLK_DIV_OVRD_VAL_MASK                                  0x001CL
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_TX_CLK_DIV_OVRD_EN_MASK                                   0x0020L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_DIV10_CLK_EN_OVRD_VAL_MASK                                0x0040L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_DIV10_CLK_EN_OVRD_EN_MASK                                 0x0080L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_DIV8_CLK_EN_OVRD_VAL_MASK                                 0x0100L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_DIV8_CLK_EN_OVRD_EN_MASK                                  0x0200L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__MPLLA_BW_OVRD_EN_MASK                                           0x0400L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_OVRD_IN__RESERVED_15_11_MASK                                             0xF800L
//DPCSSYS_CR0_RAWCMN_DIG_MPLLA_BW_OVRD_IN
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_BW_OVRD_IN__MPLLA_BW_OVRD_VAL__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_BW_OVRD_IN__MPLLA_BW_OVRD_VAL_MASK                                       0xFFFFL
//DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_0
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_0__MPLLA_SSC_RANGE_OVRD_VAL__SHIFT                       0x0
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_0__MPLLA_SSC_RANGE_OVRD_EN__SHIFT                        0x3
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_0__MPLLA_SSC_CLK_SEL_OVRD_VAL__SHIFT                     0x4
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_0__MPLLA_SSC_CLK_SEL_OVRD_EN__SHIFT                      0x7
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_0__MPLLA_SSC_EN_OVRD_VAL__SHIFT                          0x8
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_0__MPLLA_SSC_EN_OVRD_EN__SHIFT                           0x9
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_0__RESERVED_15_10__SHIFT                                 0xa
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_0__MPLLA_SSC_RANGE_OVRD_VAL_MASK                         0x0007L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_0__MPLLA_SSC_RANGE_OVRD_EN_MASK                          0x0008L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_0__MPLLA_SSC_CLK_SEL_OVRD_VAL_MASK                       0x0070L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_0__MPLLA_SSC_CLK_SEL_OVRD_EN_MASK                        0x0080L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_0__MPLLA_SSC_EN_OVRD_VAL_MASK                            0x0100L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_0__MPLLA_SSC_EN_OVRD_EN_MASK                             0x0200L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_0__RESERVED_15_10_MASK                                   0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_WORD_DIV2_EN_OVRD_VAL__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_WORD_DIV2_EN_OVRD_EN__SHIFT                               0x1
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_TX_CLK_DIV_OVRD_VAL__SHIFT                                0x2
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_TX_CLK_DIV_OVRD_EN__SHIFT                                 0x5
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_DIV10_CLK_EN_OVRD_VAL__SHIFT                              0x6
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_DIV10_CLK_EN_OVRD_EN__SHIFT                               0x7
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_DIV8_CLK_EN_OVRD_VAL__SHIFT                               0x8
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_DIV8_CLK_EN_OVRD_EN__SHIFT                                0x9
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_BW_OVRD_EN__SHIFT                                         0xa
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__RESERVED_15_11__SHIFT                                           0xb
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_WORD_DIV2_EN_OVRD_VAL_MASK                                0x0001L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_WORD_DIV2_EN_OVRD_EN_MASK                                 0x0002L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_TX_CLK_DIV_OVRD_VAL_MASK                                  0x001CL
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_TX_CLK_DIV_OVRD_EN_MASK                                   0x0020L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_DIV10_CLK_EN_OVRD_VAL_MASK                                0x0040L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_DIV10_CLK_EN_OVRD_EN_MASK                                 0x0080L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_DIV8_CLK_EN_OVRD_VAL_MASK                                 0x0100L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_DIV8_CLK_EN_OVRD_EN_MASK                                  0x0200L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__MPLLB_BW_OVRD_EN_MASK                                           0x0400L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_OVRD_IN__RESERVED_15_11_MASK                                             0xF800L
//DPCSSYS_CR0_RAWCMN_DIG_MPLLB_BW_OVRD_IN
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_BW_OVRD_IN__MPLLB_BW_OVRD_VAL__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_BW_OVRD_IN__MPLLB_BW_OVRD_VAL_MASK                                       0xFFFFL
//DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_0
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_0__MPLLB_SSC_RANGE_OVRD_VAL__SHIFT                       0x0
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_0__MPLLB_SSC_RANGE_OVRD_EN__SHIFT                        0x3
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_0__MPLLB_SSC_CLK_SEL_OVRD_VAL__SHIFT                     0x4
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_0__MPLLB_SSC_CLK_SEL_OVRD_EN__SHIFT                      0x7
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_0__MPLLB_SSC_EN_OVRD_VAL__SHIFT                          0x8
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_0__MPLLB_SSC_EN_OVRD_EN__SHIFT                           0x9
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_0__RESERVED_15_10__SHIFT                                 0xa
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_0__MPLLB_SSC_RANGE_OVRD_VAL_MASK                         0x0007L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_0__MPLLB_SSC_RANGE_OVRD_EN_MASK                          0x0008L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_0__MPLLB_SSC_CLK_SEL_OVRD_VAL_MASK                       0x0070L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_0__MPLLB_SSC_CLK_SEL_OVRD_EN_MASK                        0x0080L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_0__MPLLB_SSC_EN_OVRD_VAL_MASK                            0x0100L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_0__MPLLB_SSC_EN_OVRD_EN_MASK                             0x0200L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_0__RESERVED_15_10_MASK                                   0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_LANE_FSM_OP_XTND
#define DPCSSYS_CR0_RAWCMN_DIG_LANE_FSM_OP_XTND__RESERVED_15_1__SHIFT                                         0x1
#define DPCSSYS_CR0_RAWCMN_DIG_LANE_FSM_OP_XTND__RESERVED_15_1_MASK                                           0xFFFEL
//DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_1
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_1__MPLLA_FRACN_CTRL_OVRD_VAL__SHIFT                      0x0
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_1__MPLLA_FRACN_CTRL_OVRD_EN__SHIFT                       0xb
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_1__RESERVED_15_12__SHIFT                                 0xc
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_1__MPLLA_FRACN_CTRL_OVRD_VAL_MASK                        0x07FFL
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_1__MPLLA_FRACN_CTRL_OVRD_EN_MASK                         0x0800L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLA_SSC_CTL_OVRD_IN_1__RESERVED_15_12_MASK                                   0xF000L
//DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_1
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_1__MPLLB_FRACN_CTRL_OVRD_VAL__SHIFT                      0x0
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_1__MPLLB_FRACN_CTRL_OVRD_EN__SHIFT                       0xb
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_1__RESERVED_15_12__SHIFT                                 0xc
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_1__MPLLB_FRACN_CTRL_OVRD_VAL_MASK                        0x07FFL
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_1__MPLLB_FRACN_CTRL_OVRD_EN_MASK                         0x0800L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLLB_SSC_CTL_OVRD_IN_1__RESERVED_15_12_MASK                                   0xF000L
//DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__MPLLA_INIT_CAL_DISABLE_OVRD_VAL__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__MPLLA_INIT_CAL_DISABLE_OVRD_EN__SHIFT                               0x1
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__MPLLB_INIT_CAL_DISABLE_OVRD_VAL__SHIFT                              0x2
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__MPLLB_INIT_CAL_DISABLE_OVRD_EN__SHIFT                               0x3
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__RTUNE_REQ_OVRD_VAL__SHIFT                                           0x4
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__RTUNE_REQ_OVRD_EN__SHIFT                                            0x5
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__HDMIMODE_ENABLE_OVRD_VAL__SHIFT                                     0x6
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__HDMIMODE_ENABLE_OVRD_EN__SHIFT                                      0x7
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__TX_PWM_CLK_SEL_OVRD_VAL__SHIFT                                      0x8
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__TX_PWM_CLK_SEL_OVRD_EN__SHIFT                                       0xa
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__TX_PWM_CLK_EN_OVRD_VAL__SHIFT                                       0xb
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__TX_PWM_CLK_EN_OVRD_EN__SHIFT                                        0xc
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__RESERVED_15_13__SHIFT                                               0xd
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__MPLLA_INIT_CAL_DISABLE_OVRD_VAL_MASK                                0x0001L
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__MPLLA_INIT_CAL_DISABLE_OVRD_EN_MASK                                 0x0002L
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__MPLLB_INIT_CAL_DISABLE_OVRD_VAL_MASK                                0x0004L
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__MPLLB_INIT_CAL_DISABLE_OVRD_EN_MASK                                 0x0008L
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__RTUNE_REQ_OVRD_VAL_MASK                                             0x0010L
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__RTUNE_REQ_OVRD_EN_MASK                                              0x0020L
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__HDMIMODE_ENABLE_OVRD_VAL_MASK                                       0x0040L
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__HDMIMODE_ENABLE_OVRD_EN_MASK                                        0x0080L
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__TX_PWM_CLK_SEL_OVRD_VAL_MASK                                        0x0300L
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__TX_PWM_CLK_SEL_OVRD_EN_MASK                                         0x0400L
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__TX_PWM_CLK_EN_OVRD_VAL_MASK                                         0x0800L
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__TX_PWM_CLK_EN_OVRD_EN_MASK                                          0x1000L
#define DPCSSYS_CR0_RAWCMN_DIG_CMN_CTL_1__RESERVED_15_13_MASK                                                 0xE000L
//DPCSSYS_CR0_RAWCMN_DIG_MPLL_STATE_CTL
#define DPCSSYS_CR0_RAWCMN_DIG_MPLL_STATE_CTL__MPLL_OFF_TIME__SHIFT                                           0x0
#define DPCSSYS_CR0_RAWCMN_DIG_MPLL_STATE_CTL__MPLLA_STATE__SHIFT                                             0x6
#define DPCSSYS_CR0_RAWCMN_DIG_MPLL_STATE_CTL__MPLLB_STATE__SHIFT                                             0x7
#define DPCSSYS_CR0_RAWCMN_DIG_MPLL_STATE_CTL__MPLL_STATE_OVRD_OUT_EN__SHIFT                                  0x8
#define DPCSSYS_CR0_RAWCMN_DIG_MPLL_STATE_CTL__MPLL_FORCE_ON_TIME__SHIFT                                      0x9
#define DPCSSYS_CR0_RAWCMN_DIG_MPLL_STATE_CTL__MPLLB_BANK_SEL__SHIFT                                          0xd
#define DPCSSYS_CR0_RAWCMN_DIG_MPLL_STATE_CTL__MPLLA_BANK_SEL__SHIFT                                          0xe
#define DPCSSYS_CR0_RAWCMN_DIG_MPLL_STATE_CTL__RESERVED_15_15__SHIFT                                          0xf
#define DPCSSYS_CR0_RAWCMN_DIG_MPLL_STATE_CTL__MPLL_OFF_TIME_MASK                                             0x003FL
#define DPCSSYS_CR0_RAWCMN_DIG_MPLL_STATE_CTL__MPLLA_STATE_MASK                                               0x0040L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLL_STATE_CTL__MPLLB_STATE_MASK                                               0x0080L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLL_STATE_CTL__MPLL_STATE_OVRD_OUT_EN_MASK                                    0x0100L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLL_STATE_CTL__MPLL_FORCE_ON_TIME_MASK                                        0x1E00L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLL_STATE_CTL__MPLLB_BANK_SEL_MASK                                            0x2000L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLL_STATE_CTL__MPLLA_BANK_SEL_MASK                                            0x4000L
#define DPCSSYS_CR0_RAWCMN_DIG_MPLL_STATE_CTL__RESERVED_15_15_MASK                                            0x8000L
//DPCSSYS_CR0_RAWCMN_DIG_TX_CAL_CODE
#define DPCSSYS_CR0_RAWCMN_DIG_TX_CAL_CODE__RESERVED_15_4__SHIFT                                              0x4
#define DPCSSYS_CR0_RAWCMN_DIG_TX_CAL_CODE__RESERVED_15_4_MASK                                                0xFFF0L
//DPCSSYS_CR0_RAWCMN_DIG_SRAM_INIT_DONE
#define DPCSSYS_CR0_RAWCMN_DIG_SRAM_INIT_DONE__RESERVED_15_1__SHIFT                                           0x1
#define DPCSSYS_CR0_RAWCMN_DIG_SRAM_INIT_DONE__RESERVED_15_1_MASK                                             0xFFFEL
//DPCSSYS_CR0_RAWCMN_DIG_OCLA
#define DPCSSYS_CR0_RAWCMN_DIG_OCLA__DIV2_CLK_EN__SHIFT                                                       0x0
#define DPCSSYS_CR0_RAWCMN_DIG_OCLA__TCA_OCLA_PROBE_SEL__SHIFT                                                0x1
#define DPCSSYS_CR0_RAWCMN_DIG_OCLA__RESERVED_15_2__SHIFT                                                     0x2
#define DPCSSYS_CR0_RAWCMN_DIG_OCLA__DIV2_CLK_EN_MASK                                                         0x0001L
#define DPCSSYS_CR0_RAWCMN_DIG_OCLA__TCA_OCLA_PROBE_SEL_MASK                                                  0x0002L
#define DPCSSYS_CR0_RAWCMN_DIG_OCLA__RESERVED_15_2_MASK                                                       0xFFFCL
//DPCSSYS_CR0_RAWCMN_DIG_SUP_ANA_OVRD
#define DPCSSYS_CR0_RAWCMN_DIG_SUP_ANA_OVRD__REF_ALT_CLK_LP_SEL_OVRD_EN__SHIFT                                0x0
#define DPCSSYS_CR0_RAWCMN_DIG_SUP_ANA_OVRD__REF_ALT_CLK_LP_SEL_OVRD_VAL__SHIFT                               0x1
#define DPCSSYS_CR0_RAWCMN_DIG_SUP_ANA_OVRD__SUP_PRE_HP_OVRD_EN__SHIFT                                        0x2
#define DPCSSYS_CR0_RAWCMN_DIG_SUP_ANA_OVRD__SUP_PRE_HP_OVRD_VAL__SHIFT                                       0x3
#define DPCSSYS_CR0_RAWCMN_DIG_SUP_ANA_OVRD__SUP_RX_VCO_VREF_SEL_OVRD_EN__SHIFT                               0x4
#define DPCSSYS_CR0_RAWCMN_DIG_SUP_ANA_OVRD__SUP_RX_VCO_VREF_SEL_OVRD_VAL__SHIFT                              0x5
#define DPCSSYS_CR0_RAWCMN_DIG_SUP_ANA_OVRD__RESERVED_15_8__SHIFT                                             0x8
#define DPCSSYS_CR0_RAWCMN_DIG_SUP_ANA_OVRD__REF_ALT_CLK_LP_SEL_OVRD_EN_MASK                                  0x0001L
#define DPCSSYS_CR0_RAWCMN_DIG_SUP_ANA_OVRD__REF_ALT_CLK_LP_SEL_OVRD_VAL_MASK                                 0x0002L
#define DPCSSYS_CR0_RAWCMN_DIG_SUP_ANA_OVRD__SUP_PRE_HP_OVRD_EN_MASK                                          0x0004L
#define DPCSSYS_CR0_RAWCMN_DIG_SUP_ANA_OVRD__SUP_PRE_HP_OVRD_VAL_MASK                                         0x0008L
#define DPCSSYS_CR0_RAWCMN_DIG_SUP_ANA_OVRD__SUP_RX_VCO_VREF_SEL_OVRD_EN_MASK                                 0x0010L
#define DPCSSYS_CR0_RAWCMN_DIG_SUP_ANA_OVRD__SUP_RX_VCO_VREF_SEL_OVRD_VAL_MASK                                0x00E0L
#define DPCSSYS_CR0_RAWCMN_DIG_SUP_ANA_OVRD__RESERVED_15_8_MASK                                               0xFF00L
//DPCSSYS_CR0_RAWCMN_DIG_PCS_RAW_ID_CODE
//DPCSSYS_CR0_RAWCMN_DIG_FW_ID_CODE_1
#define DPCSSYS_CR0_RAWCMN_DIG_FW_ID_CODE_1__W_ID_CODE_1__SHIFT                                               0x0
#define DPCSSYS_CR0_RAWCMN_DIG_FW_ID_CODE_1__W_ID_CODE_1_MASK                                                 0xFFFFL
//DPCSSYS_CR0_RAWCMN_DIG_FW_ID_CODE_2
#define DPCSSYS_CR0_RAWCMN_DIG_FW_ID_CODE_2__W_ID_CODE_2__SHIFT                                               0x0
#define DPCSSYS_CR0_RAWCMN_DIG_FW_ID_CODE_2__W_ID_CODE_2_MASK                                                 0xFFFFL
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_0__RTUNE_RX_VAL_0__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_0__RESERVED_15_6__SHIFT                                   0x6
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_0__RTUNE_RX_VAL_0_MASK                                    0x003FL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_0__RESERVED_15_6_MASK                                     0xFFC0L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_0__RTUNE_TXDN_VAL_0__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_0__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_0__RTUNE_TXDN_VAL_0_MASK                                0x03FFL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_0__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_0__RTUNE_TXUP_VAL_0__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_0__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_0__RTUNE_TXUP_VAL_0_MASK                                0x03FFL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_0__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_1
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_1__RTUNE_RX_VAL_1__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_1__RESERVED_15_6__SHIFT                                   0x6
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_1__RTUNE_RX_VAL_1_MASK                                    0x003FL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_1__RESERVED_15_6_MASK                                     0xFFC0L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_1
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_1__RTUNE_TXDN_VAL_1__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_1__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_1__RTUNE_TXDN_VAL_1_MASK                                0x03FFL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_1__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_1
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_1__RTUNE_TXUP_VAL_1__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_1__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_1__RTUNE_TXUP_VAL_1_MASK                                0x03FFL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_1__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_2
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_2__RTUNE_RX_VAL_2__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_2__RESERVED_15_6__SHIFT                                   0x6
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_2__RTUNE_RX_VAL_2_MASK                                    0x003FL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_2__RESERVED_15_6_MASK                                     0xFFC0L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_2
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_2__RTUNE_TXDN_VAL_2__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_2__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_2__RTUNE_TXDN_VAL_2_MASK                                0x03FFL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_2__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_2
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_2__RTUNE_TXUP_VAL_2__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_2__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_2__RTUNE_TXUP_VAL_2_MASK                                0x03FFL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_2__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_3
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_3__RTUNE_RX_VAL_3__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_3__RESERVED_15_6__SHIFT                                   0x6
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_3__RTUNE_RX_VAL_3_MASK                                    0x003FL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_3__RESERVED_15_6_MASK                                     0xFFC0L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_3
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_3__RTUNE_TXDN_VAL_3__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_3__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_3__RTUNE_TXDN_VAL_3_MASK                                0x03FFL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_3__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_3
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_3__RTUNE_TXUP_VAL_3__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_3__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_3__RTUNE_TXUP_VAL_3_MASK                                0x03FFL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_3__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_4
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_4__RTUNE_RX_VAL_4__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_4__RESERVED_15_6__SHIFT                                   0x6
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_4__RTUNE_RX_VAL_4_MASK                                    0x003FL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_4__RESERVED_15_6_MASK                                     0xFFC0L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_4
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_4__RTUNE_TXDN_VAL_4__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_4__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_4__RTUNE_TXDN_VAL_4_MASK                                0x03FFL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_4__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_4
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_4__RTUNE_TXUP_VAL_4__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_4__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_4__RTUNE_TXUP_VAL_4_MASK                                0x03FFL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_4__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_5
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_5__RTUNE_RX_VAL_5__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_5__RESERVED_15_6__SHIFT                                   0x6
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_5__RTUNE_RX_VAL_5_MASK                                    0x003FL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_5__RESERVED_15_6_MASK                                     0xFFC0L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_5
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_5__RTUNE_TXDN_VAL_5__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_5__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_5__RTUNE_TXDN_VAL_5_MASK                                0x03FFL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_5__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_5
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_5__RTUNE_TXUP_VAL_5__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_5__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_5__RTUNE_TXUP_VAL_5_MASK                                0x03FFL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_5__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_6
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_6__RTUNE_RX_VAL_6__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_6__RESERVED_15_6__SHIFT                                   0x6
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_6__RTUNE_RX_VAL_6_MASK                                    0x003FL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_6__RESERVED_15_6_MASK                                     0xFFC0L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_6
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_6__RTUNE_TXDN_VAL_6__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_6__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_6__RTUNE_TXDN_VAL_6_MASK                                0x03FFL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_6__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_6
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_6__RTUNE_TXUP_VAL_6__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_6__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_6__RTUNE_TXUP_VAL_6_MASK                                0x03FFL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_6__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_7
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_7__RTUNE_RX_VAL_7__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_7__RESERVED_15_6__SHIFT                                   0x6
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_7__RTUNE_RX_VAL_7_MASK                                    0x003FL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_RX_VAL_7__RESERVED_15_6_MASK                                     0xFFC0L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_7
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_7__RTUNE_TXDN_VAL_7__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_7__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_7__RTUNE_TXDN_VAL_7_MASK                                0x03FFL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXDN_VAL_7__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_7
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_7__RTUNE_TXUP_VAL_7__SHIFT                              0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_7__RESERVED_15_10__SHIFT                                0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_7__RTUNE_TXUP_VAL_7_MASK                                0x03FFL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RTUNE_TXUP_VAL_7__RESERVED_15_10_MASK                                  0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SRAM_BL_CFG
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SRAM_BL_CFG__SRAM_PGATE_BL_EN__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SRAM_BL_CFG__SRAM_BL_ROM__SHIFT                                        0x1
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SRAM_BL_CFG__SRAM_BL_BYPASS__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SRAM_BL_CFG__SRAM_BL_START__SHIFT                                      0x3
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SRAM_BL_CFG__RESERVED_15_4__SHIFT                                      0x4
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SRAM_BL_CFG__SRAM_PGATE_BL_EN_MASK                                     0x0001L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SRAM_BL_CFG__SRAM_BL_ROM_MASK                                          0x0002L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SRAM_BL_CFG__SRAM_BL_BYPASS_MASK                                       0x0004L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SRAM_BL_CFG__SRAM_BL_START_MASK                                        0x0008L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SRAM_BL_CFG__RESERVED_15_4_MASK                                        0xFFF0L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_IN
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_IN__PMA_PWR_STABLE_OVRD__SHIFT                                 0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_IN__PCS_PWR_STABLE_OVRD__SHIFT                                 0x1
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_IN__PG_RESET_OVRD_VAL__SHIFT                                   0x2
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_IN__PG_RESET_OVRD_EN__SHIFT                                    0x3
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_IN__PG_MODE_EN_OVRD_VAL__SHIFT                                 0x4
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_IN__PG_MODE_EN_OVRD_EN__SHIFT                                  0x5
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_IN__RESERVED_15_6__SHIFT                                       0x6
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_IN__PMA_PWR_STABLE_OVRD_MASK                                   0x0001L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_IN__PCS_PWR_STABLE_OVRD_MASK                                   0x0002L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_IN__PG_RESET_OVRD_VAL_MASK                                     0x0004L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_IN__PG_RESET_OVRD_EN_MASK                                      0x0008L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_IN__PG_MODE_EN_OVRD_VAL_MASK                                   0x0010L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_IN__PG_MODE_EN_OVRD_EN_MASK                                    0x0020L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_IN__RESERVED_15_6_MASK                                         0xFFC0L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_OUT
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_OUT__PMA_PWR_EN_OVRD__SHIFT                                    0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_OUT__PCS_PWR_EN_OVRD__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_OUT__MON_IN_VALID_OVRD_VAL__SHIFT                              0x2
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_OUT__MON_IN_VALID_OVRD_EN__SHIFT                               0x3
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_OUT__MON_IN_PULL_DOWN__SHIFT                                   0x4
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_OUT__ANA_ISOLATION_EN_OVRD_EN__SHIFT                           0x5
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_OUT__ANA_ISOLATION_EN_OVRD_VAL__SHIFT                          0x6
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_OUT__RESERVED_15_7__SHIFT                                      0x7
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_OUT__PMA_PWR_EN_OVRD_MASK                                      0x0001L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_OUT__PCS_PWR_EN_OVRD_MASK                                      0x0002L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_OUT__MON_IN_VALID_OVRD_VAL_MASK                                0x0004L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_OUT__MON_IN_VALID_OVRD_EN_MASK                                 0x0008L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_OUT__MON_IN_PULL_DOWN_MASK                                     0x0010L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_OUT__ANA_ISOLATION_EN_OVRD_EN_MASK                             0x0020L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_OUT__ANA_ISOLATION_EN_OVRD_VAL_MASK                            0x0040L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_PG_OVRD_OUT__RESERVED_15_7_MASK                                        0xFF80L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__MPLLA_FORCE_EN_OVRD_VAL__SHIFT                            0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__MPLLA_FORCE_EN_OVRD_EN__SHIFT                             0x1
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__MPLLB_FORCE_EN_OVRD_VAL__SHIFT                            0x2
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__MPLLB_FORCE_EN_OVRD_EN__SHIFT                             0x3
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__REF_CLK_EN_OVRD_VAL__SHIFT                                0x4
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__REF_CLK_EN_OVRD_EN__SHIFT                                 0x5
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__MPLLA_FORCE_ACK_OVRD_VAL__SHIFT                           0x6
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__MPLLA_FORCE_ACK_OVRD_EN__SHIFT                            0x7
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__MPLLB_FORCE_ACK_OVRD_VAL__SHIFT                           0x8
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__MPLLB_FORCE_ACK_OVRD_EN__SHIFT                            0x9
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__RESERVED_15_10__SHIFT                                     0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__MPLLA_FORCE_EN_OVRD_VAL_MASK                              0x0001L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__MPLLA_FORCE_EN_OVRD_EN_MASK                               0x0002L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__MPLLB_FORCE_EN_OVRD_VAL_MASK                              0x0004L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__MPLLB_FORCE_EN_OVRD_EN_MASK                               0x0008L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__REF_CLK_EN_OVRD_VAL_MASK                                  0x0010L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__REF_CLK_EN_OVRD_EN_MASK                                   0x0020L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__MPLLA_FORCE_ACK_OVRD_VAL_MASK                             0x0040L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__MPLLA_FORCE_ACK_OVRD_EN_MASK                              0x0080L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__MPLLB_FORCE_ACK_OVRD_VAL_MASK                             0x0100L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__MPLLB_FORCE_ACK_OVRD_EN_MASK                              0x0200L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_SUP_OVRD_IN__RESERVED_15_10_MASK                                       0xFC00L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_VREF_STATS
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_VREF_STATS__SUP_ANA_VPHUD_SELVPH__SHIFT                                0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_VREF_STATS__VREF_CAL_DONE__SHIFT                                       0x1
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_VREF_STATS__RESERVED_15_2__SHIFT                                       0x2
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_VREF_STATS__SUP_ANA_VPHUD_SELVPH_MASK                                  0x0001L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_VREF_STATS__VREF_CAL_DONE_MASK                                         0x0002L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_VREF_STATS__RESERVED_15_2_MASK                                         0xFFFCL
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_OVRD_IN
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_OVRD_IN__RES_REQ_IN__SHIFT                                         0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_OVRD_IN__RES_ACK_IN__SHIFT                                         0x1
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_OVRD_IN__RES_OVRD_EN__SHIFT                                        0x2
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_OVRD_IN__RES_REQ_OUT__SHIFT                                        0x3
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_OVRD_IN__RES_REQ_OUT_OVRD_EN__SHIFT                                0x4
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_OVRD_IN__RES_ACK_OUT__SHIFT                                        0x5
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_OVRD_IN__RES_ACK_OUT_OVRD_EN__SHIFT                                0x6
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_OVRD_IN__RESERVED_15_7__SHIFT                                      0x7
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_OVRD_IN__RES_REQ_IN_MASK                                           0x0001L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_OVRD_IN__RES_ACK_IN_MASK                                           0x0002L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_OVRD_IN__RES_OVRD_EN_MASK                                          0x0004L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_OVRD_IN__RES_REQ_OUT_MASK                                          0x0008L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_OVRD_IN__RES_REQ_OUT_OVRD_EN_MASK                                  0x0010L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_OVRD_IN__RES_ACK_OUT_MASK                                          0x0020L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_OVRD_IN__RES_ACK_OUT_OVRD_EN_MASK                                  0x0040L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_OVRD_IN__RESERVED_15_7_MASK                                        0xFF80L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_ASIC_IN_OUT
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_ASIC_IN_OUT__RES_REQ_IN__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_ASIC_IN_OUT__RES_REQ_OUT__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_ASIC_IN_OUT__RES_ACK_IN__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_ASIC_IN_OUT__RES_ACK_OUT__SHIFT                                    0x3
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_ASIC_IN_OUT__RESERVED_15_4__SHIFT                                  0x4
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_ASIC_IN_OUT__RES_REQ_IN_MASK                                       0x0001L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_ASIC_IN_OUT__RES_REQ_OUT_MASK                                      0x0002L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_ASIC_IN_OUT__RES_ACK_IN_MASK                                       0x0004L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_ASIC_IN_OUT__RES_ACK_OUT_MASK                                      0x0008L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_RES_ASIC_IN_OUT__RESERVED_15_4_MASK                                    0xFFF0L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_REF_RANGE_OVRD
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_REF_RANGE_OVRD__OVRD_VAL__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_REF_RANGE_OVRD__OVRD_EN__SHIFT                                         0x5
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_REF_RANGE_OVRD__OVRD_VAL_MASK                                          0x0007L
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_REF_RANGE_OVRD__OVRD_EN_MASK                                           0x0020L
//DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_MISC_CONF_IN_1
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_MISC_CONF_IN_1__MPLL_PWRDN_TIME__SHIFT                                 0x0
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_MISC_CONF_IN_1__RESERVED_15_10__SHIFT                                  0xa
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_MISC_CONF_IN_1__MPLL_PWRDN_TIME_MASK                                   0x03FFL
#define DPCSSYS_CR0_RAWCMN_DIG_AON_CMN_MISC_CONF_IN_1__RESERVED_15_10_MASK                                    0xFC00L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__PSTATE__SHIFT                                             0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__LPD__SHIFT                                                0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__WIDTH__SHIFT                                              0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__RATE__SHIFT                                               0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__MPLLB_SEL__SHIFT                                          0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__MPLL_EN__SHIFT                                            0x9
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__OVRD_EN__SHIFT                                            0xa
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLLA_STATE__SHIFT                                   0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLLB_STATE__SHIFT                                   0xc
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLL_OVRD_EN__SHIFT                                  0xd
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__TX_ASYNC_EN_OVR_VAL__SHIFT                                0xe
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__TX_ASYNC_EN_OVR_EN__SHIFT                                 0xf
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__PSTATE_MASK                                               0x0003L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__LPD_MASK                                                  0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__WIDTH_MASK                                                0x0018L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__RATE_MASK                                                 0x00E0L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__MPLLB_SEL_MASK                                            0x0100L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__MPLL_EN_MASK                                              0x0200L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__OVRD_EN_MASK                                              0x0400L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLLA_STATE_MASK                                     0x0800L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLLB_STATE_MASK                                     0x1000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLL_OVRD_EN_MASK                                    0x2000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__TX_ASYNC_EN_OVR_VAL_MASK                                  0x4000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN__TX_ASYNC_EN_OVR_EN_MASK                                   0x8000L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__RESET_OVRD_VAL__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__RESET_OVRD_EN__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__REQ_OVRD_VAL__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__REQ_OVRD_EN__SHIFT                                      0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__DETRX_REQ_OVRD_VAL__SHIFT                               0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__DETRX_REQ_OVRD_EN__SHIFT                                0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__VBOOST_EN_OVRD_VAL__SHIFT                               0x6
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__VBOOST_EN_OVRD_EN__SHIFT                                0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__IBOOST_LVL_OVRD_VAL__SHIFT                              0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__IBOOST_LVL_OVRD_EN__SHIFT                               0xc
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__TX_BEACON_EN_OVR_VAL__SHIFT                             0xd
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__TX_BEACON_EN_OVR_EN__SHIFT                              0xe
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__RESERVED_15_15__SHIFT                                   0xf
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__RESET_OVRD_VAL_MASK                                     0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__RESET_OVRD_EN_MASK                                      0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__REQ_OVRD_VAL_MASK                                       0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__REQ_OVRD_EN_MASK                                        0x0008L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__DETRX_REQ_OVRD_VAL_MASK                                 0x0010L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__DETRX_REQ_OVRD_EN_MASK                                  0x0020L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__VBOOST_EN_OVRD_VAL_MASK                                 0x0040L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__VBOOST_EN_OVRD_EN_MASK                                  0x0080L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__IBOOST_LVL_OVRD_VAL_MASK                                0x0F00L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__IBOOST_LVL_OVRD_EN_MASK                                 0x1000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__TX_BEACON_EN_OVR_VAL_MASK                               0x2000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__TX_BEACON_EN_OVR_EN_MASK                                0x4000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_1__RESERVED_15_15_MASK                                     0x8000L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__RESET__SHIFT                                               0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__REQ__SHIFT                                                 0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__PSTATE__SHIFT                                              0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__LPD__SHIFT                                                 0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__WIDTH__SHIFT                                               0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__RATE__SHIFT                                                0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__MPLLB_SEL__SHIFT                                           0xa
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__MPLL_EN__SHIFT                                             0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__MSTR_MPLLA_STATE__SHIFT                                    0xc
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__MSTR_MPLLB_STATE__SHIFT                                    0xd
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__DETRX_REQ__SHIFT                                           0xe
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__RESERVED_15_15__SHIFT                                      0xf
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__RESET_MASK                                                 0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__REQ_MASK                                                   0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__PSTATE_MASK                                                0x000CL
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__LPD_MASK                                                   0x0010L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__WIDTH_MASK                                                 0x0060L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__RATE_MASK                                                  0x0380L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__MPLLB_SEL_MASK                                             0x0400L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__MPLL_EN_MASK                                               0x0800L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__MSTR_MPLLA_STATE_MASK                                      0x1000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__MSTR_MPLLB_STATE_MASK                                      0x2000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__DETRX_REQ_MASK                                             0x4000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_IN__RESERVED_15_15_MASK                                        0x8000L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_OUT
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_OUT__ACK__SHIFT                                               0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_OUT__DETRX_RESULT__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_OUT__EN_CTL__SHIFT                                            0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_VAL__SHIFT                        0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_EN__SHIFT                         0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_OUT__RESERVED_15_5__SHIFT                                     0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_OUT__ACK_MASK                                                 0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_OUT__DETRX_RESULT_MASK                                        0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_OUT__EN_CTL_MASK                                              0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_VAL_MASK                          0x0008L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_EN_MASK                           0x0010L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_OUT__RESERVED_15_5_MASK                                       0xFFE0L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_OUT
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_OUT__ACK__SHIFT                                                0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_OUT__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_OUT__ACK_MASK                                                  0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_PCS_OUT__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__RATE__SHIFT                                               0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__WIDTH__SHIFT                                              0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__PSTATE__SHIFT                                             0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__LPD__SHIFT                                                0x6
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__OVRD_EN__SHIFT                                            0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__ADAPT_AFE_EN__SHIFT                                       0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__ADAPT_DFE_EN__SHIFT                                       0x9
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_VAL__SHIFT                      0xa
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_EN__SHIFT                       0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__RX_DATA_EN_OVRD_VAL_R__SHIFT                              0xc
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__RX_DATA_EN_OVRD_EN_R__SHIFT                               0xd
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__RESERVED_15_14__SHIFT                                     0xe
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__RATE_MASK                                                 0x0003L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__WIDTH_MASK                                                0x000CL
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__PSTATE_MASK                                               0x0030L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__LPD_MASK                                                  0x0040L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__OVRD_EN_MASK                                              0x0080L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__ADAPT_AFE_EN_MASK                                         0x0100L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__ADAPT_DFE_EN_MASK                                         0x0200L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_VAL_MASK                        0x0400L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_EN_MASK                         0x0800L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__RX_DATA_EN_OVRD_VAL_R_MASK                                0x1000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__RX_DATA_EN_OVRD_EN_R_MASK                                 0x2000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN__RESERVED_15_14_MASK                                       0xC000L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__RESET_OVRD_VAL__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__RESET_OVRD_EN__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__REQ_OVRD_VAL__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__REQ_OVRD_EN__SHIFT                                      0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_VAL__SHIFT                          0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_EN__SHIFT                           0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_REQ__SHIFT                                        0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_REQ_OVRD_EN__SHIFT                                0x9
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_CONT__SHIFT                                       0xa
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__OFFCAN_CONT__SHIFT                                      0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__CONT_OVRD_EN__SHIFT                                     0xc
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__RESERVED_15_13__SHIFT                                   0xd
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__RESET_OVRD_VAL_MASK                                     0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__RESET_OVRD_EN_MASK                                      0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__REQ_OVRD_VAL_MASK                                       0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__REQ_OVRD_EN_MASK                                        0x0008L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_VAL_MASK                            0x0070L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_EN_MASK                             0x0080L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_REQ_MASK                                          0x0100L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_REQ_OVRD_EN_MASK                                  0x0200L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_CONT_MASK                                         0x0400L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__OFFCAN_CONT_MASK                                        0x0800L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__CONT_OVRD_EN_MASK                                       0x1000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_1__RESERVED_15_13_MASK                                     0xE000L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LD_VAL_OVRD__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LD_VAL_OVRD_EN__SHIFT                               0xd
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD__SHIFT                             0xe
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD_EN__SHIFT                          0xf
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LD_VAL_OVRD_MASK                                    0x1FFFL
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LD_VAL_OVRD_EN_MASK                                 0x2000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD_MASK                               0x4000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD_EN_MASK                            0x8000L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_3__REF_LD_VAL_OVRD__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_3__REF_LD_VAL_OVRD_EN__SHIFT                               0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_3__RESERVED_15_8__SHIFT                                    0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_3__REF_LD_VAL_OVRD_MASK                                    0x007FL
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_3__REF_LD_VAL_OVRD_EN_MASK                                 0x0080L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_IN_3__RESERVED_15_8_MASK                                      0xFF00L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__REQ__SHIFT                                                 0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__RATE__SHIFT                                                0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__WIDTH__SHIFT                                               0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__PSTATE__SHIFT                                              0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__LPD__SHIFT                                                 0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__CDR_VCO_LOWFREQ__SHIFT                                     0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__ADAPT_AFE_EN__SHIFT                                        0x9
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__ADAPT_DFE_EN__SHIFT                                        0xa
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__ADAPT_REQ__SHIFT                                           0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__ADAPT_CONT__SHIFT                                          0xc
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__OFFCAN_CONT__SHIFT                                         0xd
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__RESET__SHIFT                                               0xe
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__RESERVED_15_15__SHIFT                                      0xf
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__REQ_MASK                                                   0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__RATE_MASK                                                  0x0006L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__WIDTH_MASK                                                 0x0018L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__PSTATE_MASK                                                0x0060L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__LPD_MASK                                                   0x0080L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__CDR_VCO_LOWFREQ_MASK                                       0x0100L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__ADAPT_AFE_EN_MASK                                          0x0200L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__ADAPT_DFE_EN_MASK                                          0x0400L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__ADAPT_REQ_MASK                                             0x0800L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__ADAPT_CONT_MASK                                            0x1000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__OFFCAN_CONT_MASK                                           0x2000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__RESET_MASK                                                 0x4000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN__RESERVED_15_15_MASK                                        0x8000L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_1__REF_LD_VAL__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_1__RESERVED_15_7__SHIFT                                     0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_1__REF_LD_VAL_MASK                                          0x007FL
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_1__RESERVED_15_7_MASK                                       0xFF80L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_2__VCO_LD_VAL__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_2__RESERVED_15_13__SHIFT                                    0xd
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_2__VCO_LD_VAL_MASK                                          0x1FFFL
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_2__RESERVED_15_13_MASK                                      0xE000L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_3__EQ_ATT_LVL__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_3__EQ_VGA1_GAIN__SHIFT                                      0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_3__EQ_VGA2_GAIN__SHIFT                                      0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_3__EQ_CTLE_BOOST__SHIFT                                     0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_3__EQ_ATT_LVL_MASK                                          0x0007L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_3__EQ_VGA1_GAIN_MASK                                        0x0078L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_3__EQ_VGA2_GAIN_MASK                                        0x0780L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_3__EQ_CTLE_BOOST_MASK                                       0xF800L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_4
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_4__EQ_CTLE_POLE__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_4__EQ_DFE_TAP1__SHIFT                                       0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_4__RESERVED_15_11__SHIFT                                    0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_4__EQ_CTLE_POLE_MASK                                        0x0007L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_4__EQ_DFE_TAP1_MASK                                         0x07F8L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_IN_4__RESERVED_15_11_MASK                                      0xF800L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT__ACK__SHIFT                                               0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT__EN_CTL__SHIFT                                            0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT__RESERVED_15_2__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT__ACK_MASK                                                 0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT__EN_CTL_MASK                                              0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT__RESERVED_15_2_MASK                                       0xFFFCL
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_OUT
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_OUT__ACK__SHIFT                                                0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_OUT__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_OUT__ACK_MASK                                                  0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PCS_OUT__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_ADAPT_ACK
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_ADAPT_ACK__RX_ADAPT_ACK__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_ADAPT_ACK__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_ADAPT_ACK__RX_ADAPT_ACK_MASK                                       0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_ADAPT_ACK__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_ADAPT_FOM
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_ADAPT_FOM__RX_ADAPT_FOM__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_ADAPT_FOM__RESERVED_15_8__SHIFT                                    0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_ADAPT_FOM__RX_ADAPT_FOM_MASK                                       0x00FFL
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_ADAPT_FOM__RESERVED_15_8_MASK                                      0xFF00L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_TXPRE_DIR
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_TXPRE_DIR__RX_TXPRE_DIR__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_TXPRE_DIR__RESERVED_15_2__SHIFT                                    0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_TXPRE_DIR__RX_TXPRE_DIR_MASK                                       0x0003L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_TXPRE_DIR__RESERVED_15_2_MASK                                      0xFFFCL
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_TXMAIN_DIR
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_TXMAIN_DIR__RX_TXMAIN_DIR__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_TXMAIN_DIR__RESERVED_15_2__SHIFT                                   0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_TXMAIN_DIR__RX_TXMAIN_DIR_MASK                                     0x0003L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_TXMAIN_DIR__RESERVED_15_2_MASK                                     0xFFFCL
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_TXPOST_DIR
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_TXPOST_DIR__RX_TXPOST_DIR__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_TXPOST_DIR__RESERVED_15_2__SHIFT                                   0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_TXPOST_DIR__RX_TXPOST_DIR_MASK                                     0x0003L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_TXPOST_DIR__RESERVED_15_2_MASK                                     0xFFFCL
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_LANE_NUMBER
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_LANE_NUMBER__LANE_NUMBER__SHIFT                                       0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_LANE_NUMBER__RESERVED_15_4__SHIFT                                     0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_LANE_NUMBER__LANE_NUMBER_MASK                                         0x000FL
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_LANE_NUMBER__RESERVED_15_4_MASK                                       0xFFF0L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RESERVED_1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RESERVED_1__RESERVED_REG_1__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RESERVED_1__RESERVED_REG_1_MASK                                       0xFFFFL
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RESERVED_2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RESERVED_2__RESERVED_REG_2__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RESERVED_2__RESERVED_REG_2_MASK                                       0xFFFFL
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_RESET_ATE_OVRD_VAL__SHIFT                             0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_RESET_ATE_OVRD_EN__SHIFT                              0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__TX_RESET_ATE_OVRD_VAL__SHIFT                             0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__TX_RESET_ATE_OVRD_EN__SHIFT                              0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_REQ_ATE_OVRD_VAL__SHIFT                               0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_REQ_ATE_OVRD_EN__SHIFT                                0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__TX_REQ_ATE_OVRD_VAL__SHIFT                               0x6
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__TX_REQ_ATE_OVRD_EN__SHIFT                                0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_AFE_EN_OVRD_VAL__SHIFT                          0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_AFE_EN_OVRD_EN__SHIFT                           0x9
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_DFE_EN_OVRD_VAL__SHIFT                          0xa
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_DFE_EN_OVRD_EN__SHIFT                           0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__TX_DATA_EN_ATE_OVRD_VAL__SHIFT                           0xc
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__TX_DATA_EN_ATE_OVRD_EN__SHIFT                            0xd
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_DATA_EN_ATE_OVRD_VAL__SHIFT                           0xe
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_DATA_EN_ATE_OVRD_EN__SHIFT                            0xf
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_RESET_ATE_OVRD_VAL_MASK                               0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_RESET_ATE_OVRD_EN_MASK                                0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__TX_RESET_ATE_OVRD_VAL_MASK                               0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__TX_RESET_ATE_OVRD_EN_MASK                                0x0008L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_REQ_ATE_OVRD_VAL_MASK                                 0x0010L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_REQ_ATE_OVRD_EN_MASK                                  0x0020L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__TX_REQ_ATE_OVRD_VAL_MASK                                 0x0040L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__TX_REQ_ATE_OVRD_EN_MASK                                  0x0080L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_AFE_EN_OVRD_VAL_MASK                            0x0100L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_AFE_EN_OVRD_EN_MASK                             0x0200L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_DFE_EN_OVRD_VAL_MASK                            0x0400L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_DFE_EN_OVRD_EN_MASK                             0x0800L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__TX_DATA_EN_ATE_OVRD_VAL_MASK                             0x1000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__TX_DATA_EN_ATE_OVRD_EN_MASK                              0x2000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_DATA_EN_ATE_OVRD_VAL_MASK                             0x4000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_OVRD_IN__RX_DATA_EN_ATE_OVRD_EN_MASK                              0x8000L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RX_EQ_DELTA_IQ_OVRD_VAL__SHIFT                0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RX_EQ_DELTA_IQ_OVRD_EN__SHIFT                 0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RESERVED_15_5__SHIFT                          0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RX_EQ_DELTA_IQ_OVRD_VAL_MASK                  0x000FL
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RX_EQ_DELTA_IQ_OVRD_EN_MASK                   0x0010L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RESERVED_15_5_MASK                            0xFFE0L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RX_TERM_CTRL_OVRD_VAL__SHIFT                  0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RX_TERM_CTRL_OVRD_EN__SHIFT                   0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__TX_TERM_CTRL_OVRD_VAL__SHIFT                  0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__TX_TERM_CTRL_OVRD_EN__SHIFT                   0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RESERVED_15_8__SHIFT                          0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RX_TERM_CTRL_OVRD_VAL_MASK                    0x0007L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RX_TERM_CTRL_OVRD_EN_MASK                     0x0008L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__TX_TERM_CTRL_OVRD_VAL_MASK                    0x0070L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__TX_TERM_CTRL_OVRD_EN_MASK                     0x0080L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RESERVED_15_8_MASK                            0xFF00L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_IN
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_IN__RX_TERM_CTRL__SHIFT                                0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_IN__TX_TERM_CTRL__SHIFT                                0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_IN__RESERVED_15_6__SHIFT                               0x6
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_IN__RX_TERM_CTRL_MASK                                  0x0007L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_IN__TX_TERM_CTRL_MASK                                  0x0038L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TXRX_TERM_CTRL_IN__RESERVED_15_6_MASK                                 0xFFC0L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT_1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT_1__RX_CLK_EN__SHIFT                                       0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT_1__RESERVED_15_1__SHIFT                                   0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT_1__RX_CLK_EN_MASK                                         0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT_1__RESERVED_15_1_MASK                                     0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_OVRD_IN_1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_AFE_GAIN_OVRD_VAL__SHIFT                       0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_ATT_LVL_OVRD_VAL__SHIFT                        0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_OVRD_EN__SHIFT                                 0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RESERVED_15_8__SHIFT                                 0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_AFE_GAIN_OVRD_VAL_MASK                         0x000FL
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_ATT_LVL_OVRD_VAL_MASK                          0x0070L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_OVRD_EN_MASK                                   0x0080L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RESERVED_15_8_MASK                                   0xFF00L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_OVRD_IN_2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RX_EQ_DFE_TAP1_OVRD_VAL__SHIFT                       0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RX_EQ_CTLE_BOOST_OVRD_VAL__SHIFT                     0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RESERVED_15_13__SHIFT                                0xd
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RX_EQ_DFE_TAP1_OVRD_VAL_MASK                         0x00FFL
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RX_EQ_CTLE_BOOST_OVRD_VAL_MASK                       0x1F00L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RESERVED_15_13_MASK                                  0xE000L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PH2_CAL
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_ACK_VAL__SHIFT                                    0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_REQ_VAL__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_REQ_OVRD_VAL__SHIFT                               0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PH2_CAL__RESERVED_15_3__SHIFT                                      0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_ACK_VAL_MASK                                      0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_REQ_VAL_MASK                                      0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_REQ_OVRD_VAL_MASK                                 0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_PH2_CAL__RESERVED_15_3_MASK                                        0xFFF8L
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FSM_OVRD_CTL
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FSM_OVRD_CTL__FSM_JMP_ADDR__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FSM_OVRD_CTL__FSM_JMP_EN__SHIFT                                          0xc
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FSM_OVRD_CTL__FSM_CMD_START__SHIFT                                       0xd
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FSM_OVRD_CTL__FSM_OVRD_EN__SHIFT                                         0xe
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FSM_OVRD_CTL__FSM_BREAK__SHIFT                                           0xf
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FSM_OVRD_CTL__FSM_JMP_ADDR_MASK                                          0x0FFFL
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FSM_OVRD_CTL__FSM_JMP_EN_MASK                                            0x1000L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FSM_OVRD_CTL__FSM_CMD_START_MASK                                         0x2000L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FSM_OVRD_CTL__FSM_OVRD_EN_MASK                                           0x4000L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FSM_OVRD_CTL__FSM_BREAK_MASK                                             0x8000L
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_MEM_ADDR_MON
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_MEM_ADDR_MON__MEM_ADDR__SHIFT                                            0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_MEM_ADDR_MON__MEM_ADDR_MASK                                              0xFFFFL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_STATUS_MON
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_STATUS_MON__STATE__SHIFT                                                 0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_STATUS_MON__CMD_RDY__SHIFT                                               0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_STATUS_MON__ALU_OVFLW__SHIFT                                             0x6
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_STATUS_MON__ALU_RES_EQ0__SHIFT                                           0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_STATUS_MON__WAIT_CNT_EQ0__SHIFT                                          0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_STATUS_MON__WRMSK_DISABLED__SHIFT                                        0x9
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_STATUS_MON__RDMSK_DISABLED__SHIFT                                        0xa
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_STATUS_MON__RESERVED_15_11__SHIFT                                        0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_STATUS_MON__STATE_MASK                                                   0x001FL
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_STATUS_MON__CMD_RDY_MASK                                                 0x0020L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_STATUS_MON__ALU_OVFLW_MASK                                               0x0040L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_STATUS_MON__ALU_RES_EQ0_MASK                                             0x0080L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_STATUS_MON__WAIT_CNT_EQ0_MASK                                            0x0100L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_STATUS_MON__WRMSK_DISABLED_MASK                                          0x0200L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_STATUS_MON__RDMSK_DISABLED_MASK                                          0x0400L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_STATUS_MON__RESERVED_15_11_MASK                                          0xF800L
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_STARTUP_CAL
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_STARTUP_CAL__FAST_RX_STARTUP_CAL__SHIFT                          0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_STARTUP_CAL__RESERVED_15_1__SHIFT                                0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_STARTUP_CAL__FAST_RX_STARTUP_CAL_MASK                            0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_STARTUP_CAL__RESERVED_15_1_MASK                                  0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_ADAPT
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_ADAPT__FAST_RX_ADAPT__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_ADAPT__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_ADAPT__FAST_RX_ADAPT_MASK                                        0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_ADAPT__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_AFE_CAL
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_AFE_CAL__FAST_RX_AFE_CAL__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_AFE_CAL__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_AFE_CAL__FAST_RX_AFE_CAL_MASK                                    0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_AFE_CAL__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_DFE_CAL
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_DFE_CAL__FAST_RX_DFE_CAL__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_DFE_CAL__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_DFE_CAL__FAST_RX_DFE_CAL_MASK                                    0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_DFE_CAL__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_BYPASS_CAL
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_BYPASS_CAL__FAST_RX_BYPASS_CAL__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_BYPASS_CAL__RESERVED_15_1__SHIFT                                 0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_BYPASS_CAL__FAST_RX_BYPASS_CAL_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_BYPASS_CAL__RESERVED_15_1_MASK                                   0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_REFLVL_CAL
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_REFLVL_CAL__FAST_RX_REFLVL_CAL__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_REFLVL_CAL__RESERVED_15_1__SHIFT                                 0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_REFLVL_CAL__FAST_RX_REFLVL_CAL_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_REFLVL_CAL__RESERVED_15_1_MASK                                   0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_IQ_CAL
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_IQ_CAL__FAST_RX_IQ_CAL__SHIFT                                    0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_IQ_CAL__RESERVED_15_1__SHIFT                                     0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_IQ_CAL__FAST_RX_IQ_CAL_MASK                                      0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_IQ_CAL__RESERVED_15_1_MASK                                       0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_AFE_ADAPT
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_AFE_ADAPT__FAST_RX_AFE_ADAPT__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_AFE_ADAPT__RESERVED_15_1__SHIFT                                  0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_AFE_ADAPT__FAST_RX_AFE_ADAPT_MASK                                0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_AFE_ADAPT__RESERVED_15_1_MASK                                    0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_DFE_ADAPT
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_DFE_ADAPT__FAST_RX_DFE_ADAPT__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_DFE_ADAPT__RESERVED_15_1__SHIFT                                  0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_DFE_ADAPT__FAST_RX_DFE_ADAPT_MASK                                0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_DFE_ADAPT__RESERVED_15_1_MASK                                    0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_SUP
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_SUP__FAST_SUP__SHIFT                                                0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_SUP__RESERVED_15_1__SHIFT                                           0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_SUP__FAST_SUP_MASK                                                  0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_SUP__RESERVED_15_1_MASK                                             0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_TX_CMN_MODE
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_TX_CMN_MODE__FAST_TX_CMN_MODE__SHIFT                                0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_TX_CMN_MODE__RESERVED_15_1__SHIFT                                   0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_TX_CMN_MODE__FAST_TX_CMN_MODE_MASK                                  0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_TX_CMN_MODE__RESERVED_15_1_MASK                                     0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_TX_RXDET
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_TX_RXDET__FAST_TX_RXDET__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_TX_RXDET__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_TX_RXDET__FAST_TX_RXDET_MASK                                        0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_TX_RXDET__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_PWRUP
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_PWRUP__FAST_RX_PWRUP__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_PWRUP__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_PWRUP__FAST_RX_PWRUP_MASK                                        0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_PWRUP__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_VCO_WAIT
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_VCO_WAIT__FAST_RX_VCO_WAIT__SHIFT                                0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_VCO_WAIT__RESERVED_15_1__SHIFT                                   0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_VCO_WAIT__FAST_RX_VCO_WAIT_MASK                                  0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_VCO_WAIT__RESERVED_15_1_MASK                                     0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_VCO_CAL
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_VCO_CAL__FAST_RX_VCO_CAL__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_VCO_CAL__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_VCO_CAL__FAST_RX_VCO_CAL_MASK                                    0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_VCO_CAL__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_CMNCAL_MPLL_STATUS
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CMNCAL_MPLL_STATUS__CMNCAL_MPLL_INIT__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CMNCAL_MPLL_STATUS__CMNCAL_MPLL_DONE__SHIFT                              0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CMNCAL_MPLL_STATUS__RESERVED_15_2__SHIFT                                 0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CMNCAL_MPLL_STATUS__CMNCAL_MPLL_INIT_MASK                                0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CMNCAL_MPLL_STATUS__CMNCAL_MPLL_DONE_MASK                                0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CMNCAL_MPLL_STATUS__RESERVED_15_2_MASK                                   0xFFFCL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_CAL_ADAPT
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_CAL_ADAPT__FAST_RX_CONT_CAL_ADAPT__SHIFT                    0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_CAL_ADAPT__RESERVED_15_1__SHIFT                             0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_CAL_ADAPT__FAST_RX_CONT_CAL_ADAPT_MASK                      0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_CAL_ADAPT__RESERVED_15_1_MASK                               0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_ADAPT
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_ADAPT__FAST_RX_CONT_ADAPT__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_ADAPT__RESERVED_15_1__SHIFT                                 0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_ADAPT__FAST_RX_CONT_ADAPT_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_ADAPT__RESERVED_15_1_MASK                                   0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_DATA_CAL
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_DATA_CAL__FAST_RX_CONT_DATA_CAL__SHIFT                      0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_DATA_CAL__RESERVED_15_1__SHIFT                              0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_DATA_CAL__FAST_RX_CONT_DATA_CAL_MASK                        0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_DATA_CAL__RESERVED_15_1_MASK                                0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_PHASE_CAL
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_PHASE_CAL__FAST_RX_CONT_PHASE_CAL__SHIFT                    0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_PHASE_CAL__RESERVED_15_1__SHIFT                             0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_PHASE_CAL__FAST_RX_CONT_PHASE_CAL_MASK                      0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_PHASE_CAL__RESERVED_15_1_MASK                               0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_AFE_CAL
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_AFE_CAL__FAST_RX_CONT_AFE_CAL__SHIFT                        0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_AFE_CAL__RESERVED_15_1__SHIFT                               0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_AFE_CAL__FAST_RX_CONT_AFE_CAL_MASK                          0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_RX_CONT_AFE_CAL__RESERVED_15_1_MASK                                 0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__TX_FAST_DCC_CAL__SHIFT                                       0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RX_FAST_DCC_CAL__SHIFT                                       0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RX_FAST_VPHUD_CAL__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RX_FAST_VREF_CAL__SHIFT                                      0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RX_FAST_SIGDET_CAL__SHIFT                                    0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RESERVED_2__SHIFT                                            0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__TX_FAST_CONT_DCC_CAL__SHIFT                                  0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_DCC_CAL__SHIFT                                  0x9
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_VPHUD_CAL__SHIFT                                0xa
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_VREF_CAL__SHIFT                                 0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RESERVED_1__SHIFT                                            0xc
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__TX_SKIP_SUP_CAL__SHIFT                                       0xf
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__TX_FAST_DCC_CAL_MASK                                         0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RX_FAST_DCC_CAL_MASK                                         0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RX_FAST_VPHUD_CAL_MASK                                       0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RX_FAST_VREF_CAL_MASK                                        0x0008L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RX_FAST_SIGDET_CAL_MASK                                      0x0010L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RESERVED_2_MASK                                              0x00E0L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__TX_FAST_CONT_DCC_CAL_MASK                                    0x0100L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_DCC_CAL_MASK                                    0x0200L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_VPHUD_CAL_MASK                                  0x0400L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_VREF_CAL_MASK                                   0x0800L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__RESERVED_1_MASK                                              0x7000L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_FAST_FLAGS__TX_SKIP_SUP_CAL_MASK                                         0x8000L
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_CR_LOCK
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CR_LOCK__CR_REG_LOCK__SHIFT                                              0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CR_LOCK__CR_MEM_LOCK__SHIFT                                              0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CR_LOCK__RESERVED_15_2__SHIFT                                            0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CR_LOCK__CR_REG_LOCK_MASK                                                0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CR_LOCK__CR_MEM_LOCK_MASK                                                0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CR_LOCK__RESERVED_15_2_MASK                                              0xFFFCL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_DCC_FLAGS
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_DCC_FLAGS__RATE__SHIFT                                                0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_DCC_FLAGS__DIV__SHIFT                                                 0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_DCC_FLAGS__MPLL__SHIFT                                                0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_DCC_FLAGS__RESERVED_15_3__SHIFT                                       0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_DCC_FLAGS__RATE_MASK                                                  0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_DCC_FLAGS__DIV_MASK                                                   0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_DCC_FLAGS__MPLL_MASK                                                  0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_DCC_FLAGS__RESERVED_15_3_MASK                                         0xFFF8L
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_DCC_STATUS
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_DCC_STATUS__FLAG__SHIFT                                               0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_DCC_STATUS__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_DCC_STATUS__FLAG_MASK                                                 0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_DCC_STATUS__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_OCLA
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_OCLA__PC_EN__SHIFT                                                       0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_OCLA__REG_BANK1_EN__SHIFT                                                0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_OCLA__REG_BANK2_EN__SHIFT                                                0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_OCLA__RESERVED_15_3__SHIFT                                               0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_OCLA__PC_EN_MASK                                                         0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_OCLA__REG_BANK1_EN_MASK                                                  0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_OCLA__REG_BANK2_EN_MASK                                                  0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_OCLA__RESERVED_15_3_MASK                                                 0xFFF8L
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_EQ_UPDATE_FLAG
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_EQ_UPDATE_FLAG__TX_EQ_UPDATE_FLAG__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_EQ_UPDATE_FLAG__RESERVED_15_1__SHIFT                                  0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_EQ_UPDATE_FLAG__TX_EQ_UPDATE_FLAG_MASK                                0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_TX_EQ_UPDATE_FLAG__RESERVED_15_1_MASK                                    0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_CMNCAL_RCAL_STATUS
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CMNCAL_RCAL_STATUS__CMNCAL_RCAL_INIT__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CMNCAL_RCAL_STATUS__CMNCAL_RCAL_DONE__SHIFT                              0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CMNCAL_RCAL_STATUS__RESERVED_15_2__SHIFT                                 0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CMNCAL_RCAL_STATUS__CMNCAL_RCAL_INIT_MASK                                0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CMNCAL_RCAL_STATUS__CMNCAL_RCAL_DONE_MASK                                0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_CMNCAL_RCAL_STATUS__RESERVED_15_2_MASK                                   0xFFFCL
//DPCSSYS_CR0_RAWLANE0_DIG_FSM_RX_IQ_PHASE_OFFSET
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_RX_IQ_PHASE_OFFSET__RX_IQ_PHASE_OFFSET__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_RX_IQ_PHASE_OFFSET__RESERVED_15_4__SHIFT                                 0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_RX_IQ_PHASE_OFFSET__RX_IQ_PHASE_OFFSET_MASK                              0x000FL
#define DPCSSYS_CR0_RAWLANE0_DIG_FSM_RX_IQ_PHASE_OFFSET__RESERVED_15_4_MASK                                   0xFFF0L
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RESET_RTN_REQ
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RESET_RTN_REQ__RESET_RTN_REQ__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RESET_RTN_REQ__RESERVED_15_1__SHIFT                                  0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RESET_RTN_REQ__RESET_RTN_REQ_MASK                                    0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RESET_RTN_REQ__RESERVED_15_1_MASK                                    0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RESET_IRQ
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RESET_IRQ__RX_RESET__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RESET_IRQ__RESERVED_15_1__SHIFT                                   0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RESET_IRQ__RX_RESET_MASK                                          0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RESET_IRQ__RESERVED_15_1_MASK                                     0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_REQ_IRQ
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_REQ_IRQ__RX_REQ__SHIFT                                            0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_REQ_IRQ__RESERVED_15_1__SHIFT                                     0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_REQ_IRQ__RX_REQ_MASK                                              0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_REQ_IRQ__RESERVED_15_1_MASK                                       0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RATE_IRQ
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RATE_IRQ__RX_RATE_IRQ__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RATE_IRQ__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RATE_IRQ__RX_RATE_IRQ_MASK                                        0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RATE_IRQ__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PSTATE_IRQ
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PSTATE_IRQ__RX_PSTATE_IRQ__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PSTATE_IRQ__RESERVED_15_1__SHIFT                                  0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PSTATE_IRQ__RX_PSTATE_IRQ_MASK                                    0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PSTATE_IRQ__RESERVED_15_1_MASK                                    0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ__RX_ADAPT_REQ_IRQ__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ__RESERVED_15_1__SHIFT                               0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ__RX_ADAPT_REQ_IRQ_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ__RESERVED_15_1_MASK                                 0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ__RX_ADAPT_DIS_IRQ__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ__RESERVED_15_1__SHIFT                               0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ__RX_ADAPT_DIS_IRQ_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ__RESERVED_15_1_MASK                                 0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RESET_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RESET_IRQ_CLR__RX_RESET_IRQ_CLR__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RESET_IRQ_CLR__RESERVED_15_1__SHIFT                               0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RESET_IRQ_CLR__RX_RESET_IRQ_CLR_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RESET_IRQ_CLR__RESERVED_15_1_MASK                                 0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_REQ_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_REQ_IRQ_CLR__RX_REQ_IRQ_CLR__SHIFT                                0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_REQ_IRQ_CLR__RESERVED_15_1__SHIFT                                 0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_REQ_IRQ_CLR__RX_REQ_IRQ_CLR_MASK                                  0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_REQ_IRQ_CLR__RESERVED_15_1_MASK                                   0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RATE_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RATE_IRQ_CLR__RX_RATE_IRQ_CLR__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RATE_IRQ_CLR__RESERVED_15_1__SHIFT                                0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RATE_IRQ_CLR__RX_RATE_IRQ_CLR_MASK                                0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_RATE_IRQ_CLR__RESERVED_15_1_MASK                                  0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PSTATE_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PSTATE_IRQ_CLR__RX_PSTATE_IRQ_CLR__SHIFT                          0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PSTATE_IRQ_CLR__RESERVED_15_1__SHIFT                              0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PSTATE_IRQ_CLR__RX_PSTATE_IRQ_CLR_MASK                            0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PSTATE_IRQ_CLR__RESERVED_15_1_MASK                                0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ_CLR__RX_ADAPT_REQ_IRQ_CLR__SHIFT                    0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ_CLR__RESERVED_15_1__SHIFT                           0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ_CLR__RX_ADAPT_REQ_IRQ_CLR_MASK                      0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ_CLR__RESERVED_15_1_MASK                             0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ_CLR__RX_ADAPT_DIS_IRQ_CLR__SHIFT                    0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ_CLR__RESERVED_15_1__SHIFT                           0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ_CLR__RX_ADAPT_DIS_IRQ_CLR_MASK                      0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ_CLR__RESERVED_15_1_MASK                             0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RX_REQ_IRQ_MSK__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RX_RATE_IRQ_MSK__SHIFT                                     0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RX_PSTATE_IRQ_MSK__SHIFT                                   0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RX_ADAPT_REQ_IRQ_MSK__SHIFT                                0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RX_ADAPT_DIS_IRQ_MSK__SHIFT                                0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RX_RESET_IRQ_MSK__SHIFT                                    0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__LANE_XCVR_MODE_IRQ_MSK__SHIFT                              0x6
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RX_PH2_CAL_REQ_IRQ_MSK__SHIFT                              0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RX_PH2_CAL_DIS_IRQ_MSK__SHIFT                              0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__LANE_RX2TX_SER_LB_EN_IRQ_MSK__SHIFT                        0x9
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__DCC_ONDMD_IRQ_MSK__SHIFT                                   0xa
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RESERVED_15_11__SHIFT                                      0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RX_REQ_IRQ_MSK_MASK                                        0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RX_RATE_IRQ_MSK_MASK                                       0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RX_PSTATE_IRQ_MSK_MASK                                     0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RX_ADAPT_REQ_IRQ_MSK_MASK                                  0x0008L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RX_ADAPT_DIS_IRQ_MSK_MASK                                  0x0010L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RX_RESET_IRQ_MSK_MASK                                      0x0020L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__LANE_XCVR_MODE_IRQ_MSK_MASK                                0x0040L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RX_PH2_CAL_REQ_IRQ_MSK_MASK                                0x0080L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RX_PH2_CAL_DIS_IRQ_MSK_MASK                                0x0100L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__LANE_RX2TX_SER_LB_EN_IRQ_MSK_MASK                          0x0200L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__DCC_ONDMD_IRQ_MSK_MASK                                     0x0400L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK__RESERVED_15_11_MASK                                        0xF800L
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK_2
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK_2__TX_RESET_IRQ_MSK__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK_2__TX_REQ_IRQ_MSK__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK_2__RESERVED_15_2__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK_2__TX_RESET_IRQ_MSK_MASK                                    0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK_2__TX_REQ_IRQ_MSK_MASK                                      0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_IRQ_MASK_2__RESERVED_15_2_MASK                                       0xFFFCL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ__LANE_XCVR_MODE_IRQ__SHIFT                        0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ__RESERVED_15_1__SHIFT                             0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ__LANE_XCVR_MODE_IRQ_MASK                          0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ__RESERVED_15_1_MASK                               0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ_CLR__LANE_XCVR_MODE_IRQ_CLR__SHIFT                0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ_CLR__RESERVED_15_1__SHIFT                         0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ_CLR__LANE_XCVR_MODE_IRQ_CLR_MASK                  0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ_CLR__RESERVED_15_1_MASK                           0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ__RX_PH2_CAL_REQ_IRQ__SHIFT                        0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ__RESERVED_15_1__SHIFT                             0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ__RX_PH2_CAL_REQ_IRQ_MASK                          0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ__RESERVED_15_1_MASK                               0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ__RX_PH2_CAL_DIS_IRQ__SHIFT                        0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ__RESERVED_15_1__SHIFT                             0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ__RX_PH2_CAL_DIS_IRQ_MASK                          0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ__RESERVED_15_1_MASK                               0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ_CLR__RX_PH2_CAL_REQ_IRQ_CLR__SHIFT                0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ_CLR__RESERVED_15_1__SHIFT                         0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ_CLR__RX_PH2_CAL_REQ_IRQ_CLR_MASK                  0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ_CLR__RESERVED_15_1_MASK                           0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ_CLR__RX_PH2_CAL_DIS_IRQ_CLR__SHIFT                0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ_CLR__RESERVED_15_1__SHIFT                         0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ_CLR__RX_PH2_CAL_DIS_IRQ_CLR_MASK                  0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ_CLR__RESERVED_15_1_MASK                           0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ__LANE_RX2TX_SER_LB_EN_IRQ__SHIFT            0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ__RESERVED_15_1__SHIFT                       0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ__LANE_RX2TX_SER_LB_EN_IRQ_MASK              0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ__RESERVED_15_1_MASK                         0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ_CLR__LANE_RX2TX_SER_LB_EN_IRQ_CLR__SHIFT    0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ_CLR__RESERVED_15_1__SHIFT                   0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ_CLR__LANE_RX2TX_SER_LB_EN_IRQ_CLR_MASK      0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ_CLR__RESERVED_15_1_MASK                     0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_DCC_ONDMD_IRQ
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_DCC_ONDMD_IRQ__IRQ__SHIFT                                            0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_DCC_ONDMD_IRQ__RESERVED_15_1__SHIFT                                  0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_DCC_ONDMD_IRQ__IRQ_MASK                                              0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_DCC_ONDMD_IRQ__RESERVED_15_1_MASK                                    0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_RESET_IRQ
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_RESET_IRQ__TX_RESET__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_RESET_IRQ__RESERVED_15_1__SHIFT                                   0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_RESET_IRQ__TX_RESET_MASK                                          0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_RESET_IRQ__RESERVED_15_1_MASK                                     0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_REQ_IRQ
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_REQ_IRQ__TX_REQ__SHIFT                                            0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_REQ_IRQ__RESERVED_15_1__SHIFT                                     0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_REQ_IRQ__TX_REQ_MASK                                              0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_REQ_IRQ__RESERVED_15_1_MASK                                       0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_RESET_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_RESET_IRQ_CLR__TX_RESET_IRQ_CLR__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_RESET_IRQ_CLR__RESERVED_15_1__SHIFT                               0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_RESET_IRQ_CLR__TX_RESET_IRQ_CLR_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_RESET_IRQ_CLR__RESERVED_15_1_MASK                                 0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_REQ_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_REQ_IRQ_CLR__TX_REQ_IRQ_CLR__SHIFT                                0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_REQ_IRQ_CLR__RESERVED_15_1__SHIFT                                 0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_REQ_IRQ_CLR__TX_REQ_IRQ_CLR_MASK                                  0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_IRQ_CTL_TX_REQ_IRQ_CLR__RESERVED_15_1_MASK                                   0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_IN
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_IN__LANE_MPLLA_EN_IN__SHIFT                                 0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_IN__LANE_MPLLB_EN_IN__SHIFT                                 0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_IN__LANE_OVRD_EN__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_IN__RESERVED_15_3__SHIFT                                    0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_IN__LANE_MPLLA_EN_IN_MASK                                   0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_IN__LANE_MPLLB_EN_IN_MASK                                   0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_IN__LANE_OVRD_EN_MASK                                       0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_IN__RESERVED_15_3_MASK                                      0xFFF8L
//DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_OUT
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_OUT__LANE_MPLLA_EN_OUT__SHIFT                               0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_OUT__LANE_MPLLB_EN_OUT__SHIFT                               0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_OUT__LANE_OVRD_EN__SHIFT                                    0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_OUT__RESERVED_15_3__SHIFT                                   0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_OUT__LANE_MPLLA_EN_OUT_MASK                                 0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_OUT__LANE_MPLLB_EN_OUT_MASK                                 0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_OUT__LANE_OVRD_EN_MASK                                      0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_OVRD_OUT__RESERVED_15_3_MASK                                     0xFFF8L
//DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_OVRD_IN
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_OVRD_IN__MPLLA_STATE__SHIFT                                       0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_OVRD_IN__MPLLB_STATE__SHIFT                                       0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_OVRD_IN__SUP_STATE_OVRD_EN__SHIFT                                 0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_OVRD_IN__RESERVED_15_3__SHIFT                                     0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_OVRD_IN__MPLLA_STATE_MASK                                         0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_OVRD_IN__MPLLB_STATE_MASK                                         0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_OVRD_IN__SUP_STATE_OVRD_EN_MASK                                   0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_OVRD_IN__RESERVED_15_3_MASK                                       0xFFF8L
//DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_PMA_IN
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_PMA_IN__MPLLA_STATE__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_PMA_IN__MPLLB_STATE__SHIFT                                        0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_PMA_IN__RESERVED_15_2__SHIFT                                      0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_PMA_IN__MPLLA_STATE_MASK                                          0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_PMA_IN__MPLLB_STATE_MASK                                          0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_PMA_IN__RESERVED_15_2_MASK                                        0xFFFCL
//DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_REQ_OVRD_VAL__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_REQ_OVRD_EN__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_RESET_OVRD_VAL__SHIFT                                 0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_RESET_OVRD_EN__SHIFT                                  0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_BEACON_EN_OVRD_VAL__SHIFT                             0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_BEACON_EN_OVRD_EN__SHIFT                              0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_ASYNC_DRV_EN_OVRD_VAL__SHIFT                          0x6
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_ASYNC_DRV_EN_OVRD_EN__SHIFT                           0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_ASYNC_EN_OVRD_VAL__SHIFT                              0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_ASYNC_EN_OVRD_EN__SHIFT                               0x9
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_VAL__SHIFT                        0xa
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_EN__SHIFT                         0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__LANE_TX2RX_SER_LB_EN_OVRD_VAL__SHIFT                     0xc
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__LANE_TX2RX_SER_LB_EN_OVRD_EN__SHIFT                      0xd
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_PMA_DATA_EN_OVRD_VAL_R__SHIFT                         0xe
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_PMA_DATA_EN_OVRD_EN_R__SHIFT                          0xf
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_REQ_OVRD_VAL_MASK                                     0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_REQ_OVRD_EN_MASK                                      0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_RESET_OVRD_VAL_MASK                                   0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_RESET_OVRD_EN_MASK                                    0x0008L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_BEACON_EN_OVRD_VAL_MASK                               0x0010L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_BEACON_EN_OVRD_EN_MASK                                0x0020L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_ASYNC_DRV_EN_OVRD_VAL_MASK                            0x0040L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_ASYNC_DRV_EN_OVRD_EN_MASK                             0x0080L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_ASYNC_EN_OVRD_VAL_MASK                                0x0100L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_ASYNC_EN_OVRD_EN_MASK                                 0x0200L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_VAL_MASK                          0x0400L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_EN_MASK                           0x0800L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__LANE_TX2RX_SER_LB_EN_OVRD_VAL_MASK                       0x1000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__LANE_TX2RX_SER_LB_EN_OVRD_EN_MASK                        0x2000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_PMA_DATA_EN_OVRD_VAL_R_MASK                           0x4000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_OVRD_OUT__TX_PMA_DATA_EN_OVRD_EN_R_MASK                            0x8000L
//DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_PMA_IN
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_PMA_IN__ACK__SHIFT                                                 0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_PMA_IN__RESERVED_15_1__SHIFT                                       0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_PMA_IN__ACK_MASK                                                   0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_TX_PMA_IN__RESERVED_15_1_MASK                                         0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__RX_REQ_OVRD_VAL__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__RX_REQ_OVRD_EN__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__RX_RESET_OVRD_VAL__SHIFT                                 0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__RX_RESET_OVRD_EN__SHIFT                                  0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__LANE_RX2TX_PAR_LB_EN_OVRD_VAL__SHIFT                     0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__LANE_RX2TX_PAR_LB_EN_OVRD_EN__SHIFT                      0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__RX_PMA_DATA_EN_OVRD_VAL_R__SHIFT                         0x6
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__RX_PMA_DATA_EN_OVRD_EN_R__SHIFT                          0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__RESERVED_15_8__SHIFT                                     0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__RX_REQ_OVRD_VAL_MASK                                     0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__RX_REQ_OVRD_EN_MASK                                      0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__RX_RESET_OVRD_VAL_MASK                                   0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__RX_RESET_OVRD_EN_MASK                                    0x0008L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__LANE_RX2TX_PAR_LB_EN_OVRD_VAL_MASK                       0x0010L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__LANE_RX2TX_PAR_LB_EN_OVRD_EN_MASK                        0x0020L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__RX_PMA_DATA_EN_OVRD_VAL_R_MASK                           0x0040L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__RX_PMA_DATA_EN_OVRD_EN_R_MASK                            0x0080L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_OVRD_OUT__RESERVED_15_8_MASK                                       0xFF00L
//DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_PMA_IN
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_PMA_IN__ACK__SHIFT                                                 0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_PMA_IN__RESERVED_15_1__SHIFT                                       0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_PMA_IN__ACK_MASK                                                   0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_PMA_IN__RESERVED_15_1_MASK                                         0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_RTUNE_CTL
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_RTUNE_CTL__LANE_RTUNE_REQ__SHIFT                                 0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_RTUNE_CTL__RESERVED_15_1__SHIFT                                  0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_RTUNE_CTL__LANE_RTUNE_REQ_MASK                                   0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_LANE_RTUNE_CTL__RESERVED_15_1_MASK                                    0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_PMA_IN_1
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_PMA_IN_1__RTUNE_ACK__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_PMA_IN_1__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_PMA_IN_1__RTUNE_ACK_MASK                                          0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_SUP_PMA_IN_1__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_WORD_CLK_R__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_WORD_CLK_OVRD_EN__SHIFT                      0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_DATA_R__SHIFT                                0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_DATA_OVRD_EN__SHIFT                          0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_CLK_R__SHIFT                                 0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_CLK_OVRD_EN__SHIFT                           0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_TERM_CTL_R__SHIFT                                0x6
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_TERM_CTL_OVRD_EN__SHIFT                          0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RESERVED_15_9__SHIFT                                    0x9
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_WORD_CLK_R_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_WORD_CLK_OVRD_EN_MASK                        0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_DATA_R_MASK                                  0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_DATA_OVRD_EN_MASK                            0x0008L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_CLK_R_MASK                                   0x0010L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_CLK_OVRD_EN_MASK                             0x0020L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_TERM_CTL_R_MASK                                  0x00C0L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_TERM_CTL_OVRD_EN_MASK                            0x0100L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_IN__RESERVED_15_9_MASK                                      0xFE00L
//DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_OUT
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_PWM_EN__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_PWM_EN_OVRD_EN__SHIFT                           0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_PWM_CLK_SEL__SHIFT                              0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_PWM_CLK_SEL_OVRD_EN__SHIFT                      0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_ASYNC_EN__SHIFT                                 0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_ASYNC_EN_OVRD_EN__SHIFT                         0x6
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_OUT__RESERVED_15_7__SHIFT                                   0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_PWM_EN_MASK                                     0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_PWM_EN_OVRD_EN_MASK                             0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_PWM_CLK_SEL_MASK                                0x000CL
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_PWM_CLK_SEL_OVRD_EN_MASK                        0x0010L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_ASYNC_EN_MASK                                   0x0020L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_ASYNC_EN_OVRD_EN_MASK                           0x0040L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_MPHY_OVRD_OUT__RESERVED_15_7_MASK                                     0xFF80L
//DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_ADAPT_OVRD_OUT
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_ADAPT_OVRD_OUT__RX_PMA_IQ_PHASE_ADJUST_MAP_OVRD_VAL__SHIFT         0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_ADAPT_OVRD_OUT__RX_PMA_IQ_PHASE_ADJUST_MAP_OVRD_EN__SHIFT          0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_ADAPT_OVRD_OUT__RESERVED_15_8__SHIFT                               0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_ADAPT_OVRD_OUT__RX_PMA_IQ_PHASE_ADJUST_MAP_OVRD_VAL_MASK           0x007FL
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_ADAPT_OVRD_OUT__RX_PMA_IQ_PHASE_ADJUST_MAP_OVRD_EN_MASK            0x0080L
#define DPCSSYS_CR0_RAWLANE0_DIG_PMA_XF_RX_ADAPT_OVRD_OUT__RESERVED_15_8_MASK                                 0xFF00L
//DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_FSM_CTL
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_FSM_CTL__TX_WAIT_MPLL_OFF_TIME__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_FSM_CTL__TX_P2_ALLOW_RXDET__SHIFT                                  0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_FSM_CTL__TX_P1_ALLOW_RXDET__SHIFT                                  0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_FSM_CTL__TX_P0S_ALLOW_RXDET__SHIFT                                 0x9
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_FSM_CTL__TX_P0_ALLOW_RXDET__SHIFT                                  0xa
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_FSM_CTL__RESERVED_15_11__SHIFT                                     0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_FSM_CTL__TX_WAIT_MPLL_OFF_TIME_MASK                                0x007FL
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_FSM_CTL__TX_P2_ALLOW_RXDET_MASK                                    0x0080L
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_FSM_CTL__TX_P1_ALLOW_RXDET_MASK                                    0x0100L
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_FSM_CTL__TX_P0S_ALLOW_RXDET_MASK                                   0x0200L
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_FSM_CTL__TX_P0_ALLOW_RXDET_MASK                                    0x0400L
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_FSM_CTL__RESERVED_15_11_MASK                                       0xF800L
//DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_CLK_CTL
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_CLK_CTL__TX_CLK_EN__SHIFT                                          0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_CLK_CTL__TX_CLK_SEL__SHIFT                                         0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_CLK_CTL__ASYNC_BEACON_WAIT_TIME__SHIFT                             0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_CLK_CTL__RESERVED_15_11__SHIFT                                     0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_CLK_CTL__TX_CLK_EN_MASK                                            0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_CLK_CTL__TX_CLK_SEL_MASK                                           0x001EL
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_CLK_CTL__ASYNC_BEACON_WAIT_TIME_MASK                               0x07E0L
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_CLK_CTL__RESERVED_15_11_MASK                                       0xF800L
//DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_DCC_CONT_STATUS
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_DCC_CONT_STATUS__ENABLE__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_DCC_CONT_STATUS__RESERVED_15_1__SHIFT                              0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_DCC_CONT_STATUS__ENABLE_MASK                                       0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_TX_DCC_CONT_STATUS__RESERVED_15_1_MASK                                0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_OCLA
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_OCLA__FSM_EN__SHIFT                                                   0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_OCLA__RESERVED_15_1__SHIFT                                            0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_OCLA__FSM_EN_MASK                                                     0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_OCLA__RESERVED_15_1_MASK                                              0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_UPCS_OCLA
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_UPCS_OCLA__DATA_EN__SHIFT                                             0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_UPCS_OCLA__CLK_EN__SHIFT                                              0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_UPCS_OCLA__RESERVED_15_3__SHIFT                                       0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_UPCS_OCLA__DATA_EN_MASK                                               0x0003L
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_UPCS_OCLA__CLK_EN_MASK                                                0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_TX_CTL_UPCS_OCLA__RESERVED_15_3_MASK                                         0xFFF8L
//DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_RX_FSM_CTL
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_RX_FSM_CTL__EN_RX_CTL_FSM__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_RX_FSM_CTL__RATE_CHG_IN_P1__SHIFT                                     0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_RX_FSM_CTL__RESERVED_15_2__SHIFT                                      0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_RX_FSM_CTL__EN_RX_CTL_FSM_MASK                                        0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_RX_FSM_CTL__RATE_CHG_IN_P1_MASK                                       0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_RX_FSM_CTL__RESERVED_15_2_MASK                                        0xFFFCL
//DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_RX_LOS_MASK_CTL
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_RX_LOS_MASK_CTL__RX_LOS_MASK_CNT__SHIFT                               0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_RX_LOS_MASK_CTL__RESERVED_15_9__SHIFT                                 0x9
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_RX_LOS_MASK_CTL__RX_LOS_MASK_CNT_MASK                                 0x01FFL
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_RX_LOS_MASK_CTL__RESERVED_15_9_MASK                                   0xFE00L
//DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_RX_DATA_EN_OVRD_CTL
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_RX_DATA_EN_OVRD_CTL__RX_DATA_EN_OVRD_CNT__SHIFT                       0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_RX_DATA_EN_OVRD_CTL__INT_REF_TRCK_CNT__SHIFT                          0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_RX_DATA_EN_OVRD_CTL__RX_DATA_EN_OVRD_CNT_MASK                         0x001FL
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_RX_DATA_EN_OVRD_CTL__INT_REF_TRCK_CNT_MASK                            0xFFE0L
//DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_OFFCAN_CONT_STATUS
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_OFFCAN_CONT_STATUS__ENABLE__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_OFFCAN_CONT_STATUS__ENABLE_MASK                                       0x0001L
//DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_ADAPT_CONT_STATUS
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_ADAPT_CONT_STATUS__ENABLE__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_ADAPT_CONT_STATUS__RESERVED_15_1__SHIFT                               0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_ADAPT_CONT_STATUS__ENABLE_MASK                                        0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_ADAPT_CONT_STATUS__RESERVED_15_1_MASK                                 0xFFFEL
//DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_UPCS_OCLA
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_UPCS_OCLA__DATA_EN__SHIFT                                             0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_UPCS_OCLA__CLK_EN__SHIFT                                              0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_UPCS_OCLA__RESERVED_15_4__SHIFT                                       0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_UPCS_OCLA__DATA_EN_MASK                                               0x0007L
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_UPCS_OCLA__CLK_EN_MASK                                                0x0008L
#define DPCSSYS_CR0_RAWLANE0_DIG_RX_CTL_UPCS_OCLA__RESERVED_15_4_MASK                                         0xFFF0L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__RATE_OVRD_VAL__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__RATE_OVRD_EN__SHIFT                                   0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__WIDTH_OVRD_VAL__SHIFT                                 0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__WIDTH_OVRD_EN__SHIFT                                  0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__PSTATE_OVRD_VAL__SHIFT                                0x6
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__PSTATE_OVRD_EN__SHIFT                                 0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__LPD_OVRD_VAL__SHIFT                                   0x9
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__LPD_OVRD_EN__SHIFT                                    0xa
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_VAL__SHIFT                  0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_EN__SHIFT                   0xc
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__RESERVED_15_13__SHIFT                                 0xd
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__RATE_OVRD_VAL_MASK                                    0x0003L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__RATE_OVRD_EN_MASK                                     0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__WIDTH_OVRD_VAL_MASK                                   0x0018L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__WIDTH_OVRD_EN_MASK                                    0x0020L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__PSTATE_OVRD_VAL_MASK                                  0x00C0L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__PSTATE_OVRD_EN_MASK                                   0x0100L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__LPD_OVRD_VAL_MASK                                     0x0200L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__LPD_OVRD_EN_MASK                                      0x0400L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_VAL_MASK                    0x0800L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_EN_MASK                     0x1000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN__RESERVED_15_13_MASK                                   0xE000L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__PSTATE__SHIFT                                         0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__LPD__SHIFT                                            0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__WIDTH__SHIFT                                          0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__RATE__SHIFT                                           0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__MPLLB_SEL__SHIFT                                      0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__MPLL_EN__SHIFT                                        0x9
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__OVRD_EN__SHIFT                                        0xa
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__MSTR_MPLLA_STATE__SHIFT                               0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__MSTR_MPLLB_STATE__SHIFT                               0xc
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__MSTR_MPLL_OVRD_EN__SHIFT                              0xd
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__TX_ASYNC_EN_OVR_VAL__SHIFT                            0xe
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__TX_ASYNC_EN_OVR_EN__SHIFT                             0xf
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__PSTATE_MASK                                           0x0003L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__LPD_MASK                                              0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__WIDTH_MASK                                            0x0018L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__RATE_MASK                                             0x00E0L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__MPLLB_SEL_MASK                                        0x0100L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__MPLL_EN_MASK                                          0x0200L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__OVRD_EN_MASK                                          0x0400L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__MSTR_MPLLA_STATE_MASK                                 0x0800L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__MSTR_MPLLB_STATE_MASK                                 0x1000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__MSTR_MPLL_OVRD_EN_MASK                                0x2000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__TX_ASYNC_EN_OVR_VAL_MASK                              0x4000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN__TX_ASYNC_EN_OVR_EN_MASK                               0x8000L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__DETRX_REQ_OVRD_VAL__SHIFT                           0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__DETRX_REQ_OVRD_EN__SHIFT                            0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__VBOOST_EN_OVRD_VAL__SHIFT                           0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__VBOOST_EN_OVRD_EN__SHIFT                            0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__IBOOST_LVL_OVRD_VAL__SHIFT                          0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__IBOOST_LVL_OVRD_EN__SHIFT                           0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__TX_BEACON_EN_OVR_VAL__SHIFT                         0x9
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__TX_BEACON_EN_OVR_EN__SHIFT                          0xa
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__LANE_TX2RX_SER_LB_EN_OVRD_VAL__SHIFT                0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__LANE_TX2RX_SER_LB_EN_OVRD_EN__SHIFT                 0xc
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__TX_ASYNC_DATA_OVRD_VAL__SHIFT                       0xd
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__TX_ASYNC_DATA_OVRD_EN__SHIFT                        0xe
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__RESERVED_15_15__SHIFT                               0xf
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__DETRX_REQ_OVRD_VAL_MASK                             0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__DETRX_REQ_OVRD_EN_MASK                              0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__VBOOST_EN_OVRD_VAL_MASK                             0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__VBOOST_EN_OVRD_EN_MASK                              0x0008L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__IBOOST_LVL_OVRD_VAL_MASK                            0x00F0L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__IBOOST_LVL_OVRD_EN_MASK                             0x0100L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__TX_BEACON_EN_OVR_VAL_MASK                           0x0200L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__TX_BEACON_EN_OVR_EN_MASK                            0x0400L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__LANE_TX2RX_SER_LB_EN_OVRD_VAL_MASK                  0x0800L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__LANE_TX2RX_SER_LB_EN_OVRD_EN_MASK                   0x1000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__TX_ASYNC_DATA_OVRD_VAL_MASK                         0x2000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__TX_ASYNC_DATA_OVRD_EN_MASK                          0x4000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_TX_OVRD_IN_1__RESERVED_15_15_MASK                                 0x8000L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_MASTER_MPLL_LOOP
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_MASTER_MPLL_LOOP__MPLLB_LOOP_EN__SHIFT                                0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_MASTER_MPLL_LOOP__MPLLA_LOOP_EN__SHIFT                                0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_MASTER_MPLL_LOOP__RESERVED_15_2__SHIFT                                0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_MASTER_MPLL_LOOP__MPLLB_LOOP_EN_MASK                                  0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_MASTER_MPLL_LOOP__MPLLA_LOOP_EN_MASK                                  0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_MASTER_MPLL_LOOP__RESERVED_15_2_MASK                                  0xFFFCL
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RESERVED__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RX_LOS_LFPS_EN_OVRD_VAL__SHIFT                      0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RX_LOS_LFPS_EN_OVRD_EN__SHIFT                       0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_VAL__SHIFT                      0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_EN__SHIFT                       0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__ADAPT_REQ__SHIFT                                    0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__ADAPT_REQ_OVRD_EN__SHIFT                            0x9
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__ADAPT_CONT__SHIFT                                   0xa
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__OFFCAN_CONT__SHIFT                                  0xb
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__CONT_OVRD_EN__SHIFT                                 0xc
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RESERVED_15_13__SHIFT                               0xd
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RESERVED_MASK                                       0x0003L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RX_LOS_LFPS_EN_OVRD_VAL_MASK                        0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RX_LOS_LFPS_EN_OVRD_EN_MASK                         0x0008L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_VAL_MASK                        0x0070L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_EN_MASK                         0x0080L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__ADAPT_REQ_MASK                                      0x0100L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__ADAPT_REQ_OVRD_EN_MASK                              0x0200L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__ADAPT_CONT_MASK                                     0x0400L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__OFFCAN_CONT_MASK                                    0x0800L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__CONT_OVRD_EN_MASK                                   0x1000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RESERVED_15_13_MASK                                 0xE000L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_2__VCO_LD_VAL_OVRD__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_2__VCO_LD_VAL_OVRD_EN__SHIFT                           0xd
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD__SHIFT                         0xe
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD_EN__SHIFT                      0xf
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_2__VCO_LD_VAL_OVRD_MASK                                0x1FFFL
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_2__VCO_LD_VAL_OVRD_EN_MASK                             0x2000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD_MASK                           0x4000L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD_EN_MASK                        0x8000L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_3__REF_LD_VAL_OVRD__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_3__REF_LD_VAL_OVRD_EN__SHIFT                           0x7
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_3__RESERVED_15_8__SHIFT                                0x8
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_3__REF_LD_VAL_OVRD_MASK                                0x007FL
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_3__REF_LD_VAL_OVRD_EN_MASK                             0x0080L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_ATE_RX_OVRD_IN_3__RESERVED_15_8_MASK                                  0xFF00L
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT_2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT_2__RX_VALID__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT_2__RX_VALID_OVRD_EN__SHIFT                                0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT_2__RESERVED_15_2__SHIFT                                   0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT_2__RX_VALID_MASK                                          0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT_2__RX_VALID_OVRD_EN_MASK                                  0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_RX_OVRD_OUT_2__RESERVED_15_2_MASK                                     0xFFFCL
//DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_2__LANE_TX2RX_SER_LB_EN_OVRD_VAL__SHIFT                    0x0
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_2__LANE_TX2RX_SER_LB_EN_OVRD_EN__SHIFT                     0x1
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_2__TX_DATA_EN_OVRD_VAL_R__SHIFT                            0x2
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_2__TX_DATA_EN_OVRD_EN_R__SHIFT                             0x3
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_2__TX_ASYNC_DATA_OVRD_VAL_R__SHIFT                         0x4
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_2__TX_ASYNC_DATA_OVRD_EN_R__SHIFT                          0x5
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_2__RESERVED_15_6__SHIFT                                    0x6
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_2__LANE_TX2RX_SER_LB_EN_OVRD_VAL_MASK                      0x0001L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_2__LANE_TX2RX_SER_LB_EN_OVRD_EN_MASK                       0x0002L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_2__TX_DATA_EN_OVRD_VAL_R_MASK                              0x0004L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_2__TX_DATA_EN_OVRD_EN_R_MASK                               0x0008L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_2__TX_ASYNC_DATA_OVRD_VAL_R_MASK                           0x0010L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_2__TX_ASYNC_DATA_OVRD_EN_R_MASK                            0x0020L
#define DPCSSYS_CR0_RAWLANE0_DIG_PCS_XF_TX_OVRD_IN_2__RESERVED_15_6_MASK                                      0xFFC0L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__PSTATE__SHIFT                                             0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__LPD__SHIFT                                                0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__WIDTH__SHIFT                                              0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__RATE__SHIFT                                               0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__MPLLB_SEL__SHIFT                                          0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__MPLL_EN__SHIFT                                            0x9
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__OVRD_EN__SHIFT                                            0xa
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLLA_STATE__SHIFT                                   0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLLB_STATE__SHIFT                                   0xc
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLL_OVRD_EN__SHIFT                                  0xd
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__TX_ASYNC_EN_OVR_VAL__SHIFT                                0xe
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__TX_ASYNC_EN_OVR_EN__SHIFT                                 0xf
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__PSTATE_MASK                                               0x0003L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__LPD_MASK                                                  0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__WIDTH_MASK                                                0x0018L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__RATE_MASK                                                 0x00E0L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__MPLLB_SEL_MASK                                            0x0100L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__MPLL_EN_MASK                                              0x0200L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__OVRD_EN_MASK                                              0x0400L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLLA_STATE_MASK                                     0x0800L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLLB_STATE_MASK                                     0x1000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLL_OVRD_EN_MASK                                    0x2000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__TX_ASYNC_EN_OVR_VAL_MASK                                  0x4000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN__TX_ASYNC_EN_OVR_EN_MASK                                   0x8000L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__RESET_OVRD_VAL__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__RESET_OVRD_EN__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__REQ_OVRD_VAL__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__REQ_OVRD_EN__SHIFT                                      0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__DETRX_REQ_OVRD_VAL__SHIFT                               0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__DETRX_REQ_OVRD_EN__SHIFT                                0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__VBOOST_EN_OVRD_VAL__SHIFT                               0x6
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__VBOOST_EN_OVRD_EN__SHIFT                                0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__IBOOST_LVL_OVRD_VAL__SHIFT                              0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__IBOOST_LVL_OVRD_EN__SHIFT                               0xc
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__TX_BEACON_EN_OVR_VAL__SHIFT                             0xd
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__TX_BEACON_EN_OVR_EN__SHIFT                              0xe
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__RESERVED_15_15__SHIFT                                   0xf
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__RESET_OVRD_VAL_MASK                                     0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__RESET_OVRD_EN_MASK                                      0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__REQ_OVRD_VAL_MASK                                       0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__REQ_OVRD_EN_MASK                                        0x0008L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__DETRX_REQ_OVRD_VAL_MASK                                 0x0010L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__DETRX_REQ_OVRD_EN_MASK                                  0x0020L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__VBOOST_EN_OVRD_VAL_MASK                                 0x0040L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__VBOOST_EN_OVRD_EN_MASK                                  0x0080L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__IBOOST_LVL_OVRD_VAL_MASK                                0x0F00L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__IBOOST_LVL_OVRD_EN_MASK                                 0x1000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__TX_BEACON_EN_OVR_VAL_MASK                               0x2000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__TX_BEACON_EN_OVR_EN_MASK                                0x4000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_1__RESERVED_15_15_MASK                                     0x8000L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__RESET__SHIFT                                               0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__REQ__SHIFT                                                 0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__PSTATE__SHIFT                                              0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__LPD__SHIFT                                                 0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__WIDTH__SHIFT                                               0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__RATE__SHIFT                                                0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__MPLLB_SEL__SHIFT                                           0xa
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__MPLL_EN__SHIFT                                             0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__MSTR_MPLLA_STATE__SHIFT                                    0xc
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__MSTR_MPLLB_STATE__SHIFT                                    0xd
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__DETRX_REQ__SHIFT                                           0xe
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__RESERVED_15_15__SHIFT                                      0xf
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__RESET_MASK                                                 0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__REQ_MASK                                                   0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__PSTATE_MASK                                                0x000CL
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__LPD_MASK                                                   0x0010L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__WIDTH_MASK                                                 0x0060L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__RATE_MASK                                                  0x0380L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__MPLLB_SEL_MASK                                             0x0400L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__MPLL_EN_MASK                                               0x0800L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__MSTR_MPLLA_STATE_MASK                                      0x1000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__MSTR_MPLLB_STATE_MASK                                      0x2000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__DETRX_REQ_MASK                                             0x4000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_IN__RESERVED_15_15_MASK                                        0x8000L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_OUT
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_OUT__ACK__SHIFT                                               0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_OUT__DETRX_RESULT__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_OUT__EN_CTL__SHIFT                                            0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_VAL__SHIFT                        0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_EN__SHIFT                         0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_OUT__RESERVED_15_5__SHIFT                                     0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_OUT__ACK_MASK                                                 0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_OUT__DETRX_RESULT_MASK                                        0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_OUT__EN_CTL_MASK                                              0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_VAL_MASK                          0x0008L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_EN_MASK                           0x0010L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_OUT__RESERVED_15_5_MASK                                       0xFFE0L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_OUT
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_OUT__ACK__SHIFT                                                0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_OUT__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_OUT__ACK_MASK                                                  0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_PCS_OUT__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__RATE__SHIFT                                               0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__WIDTH__SHIFT                                              0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__PSTATE__SHIFT                                             0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__LPD__SHIFT                                                0x6
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__OVRD_EN__SHIFT                                            0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__ADAPT_AFE_EN__SHIFT                                       0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__ADAPT_DFE_EN__SHIFT                                       0x9
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_VAL__SHIFT                      0xa
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_EN__SHIFT                       0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__RX_DATA_EN_OVRD_VAL_R__SHIFT                              0xc
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__RX_DATA_EN_OVRD_EN_R__SHIFT                               0xd
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__RESERVED_15_14__SHIFT                                     0xe
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__RATE_MASK                                                 0x0003L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__WIDTH_MASK                                                0x000CL
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__PSTATE_MASK                                               0x0030L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__LPD_MASK                                                  0x0040L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__OVRD_EN_MASK                                              0x0080L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__ADAPT_AFE_EN_MASK                                         0x0100L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__ADAPT_DFE_EN_MASK                                         0x0200L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_VAL_MASK                        0x0400L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_EN_MASK                         0x0800L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__RX_DATA_EN_OVRD_VAL_R_MASK                                0x1000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__RX_DATA_EN_OVRD_EN_R_MASK                                 0x2000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN__RESERVED_15_14_MASK                                       0xC000L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__RESET_OVRD_VAL__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__RESET_OVRD_EN__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__REQ_OVRD_VAL__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__REQ_OVRD_EN__SHIFT                                      0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_VAL__SHIFT                          0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_EN__SHIFT                           0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_REQ__SHIFT                                        0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_REQ_OVRD_EN__SHIFT                                0x9
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_CONT__SHIFT                                       0xa
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__OFFCAN_CONT__SHIFT                                      0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__CONT_OVRD_EN__SHIFT                                     0xc
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__RESERVED_15_13__SHIFT                                   0xd
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__RESET_OVRD_VAL_MASK                                     0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__RESET_OVRD_EN_MASK                                      0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__REQ_OVRD_VAL_MASK                                       0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__REQ_OVRD_EN_MASK                                        0x0008L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_VAL_MASK                            0x0070L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_EN_MASK                             0x0080L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_REQ_MASK                                          0x0100L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_REQ_OVRD_EN_MASK                                  0x0200L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_CONT_MASK                                         0x0400L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__OFFCAN_CONT_MASK                                        0x0800L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__CONT_OVRD_EN_MASK                                       0x1000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_1__RESERVED_15_13_MASK                                     0xE000L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LD_VAL_OVRD__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LD_VAL_OVRD_EN__SHIFT                               0xd
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD__SHIFT                             0xe
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD_EN__SHIFT                          0xf
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LD_VAL_OVRD_MASK                                    0x1FFFL
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LD_VAL_OVRD_EN_MASK                                 0x2000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD_MASK                               0x4000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD_EN_MASK                            0x8000L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_3__REF_LD_VAL_OVRD__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_3__REF_LD_VAL_OVRD_EN__SHIFT                               0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_3__RESERVED_15_8__SHIFT                                    0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_3__REF_LD_VAL_OVRD_MASK                                    0x007FL
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_3__REF_LD_VAL_OVRD_EN_MASK                                 0x0080L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_IN_3__RESERVED_15_8_MASK                                      0xFF00L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__REQ__SHIFT                                                 0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__RATE__SHIFT                                                0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__WIDTH__SHIFT                                               0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__PSTATE__SHIFT                                              0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__LPD__SHIFT                                                 0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__CDR_VCO_LOWFREQ__SHIFT                                     0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__ADAPT_AFE_EN__SHIFT                                        0x9
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__ADAPT_DFE_EN__SHIFT                                        0xa
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__ADAPT_REQ__SHIFT                                           0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__ADAPT_CONT__SHIFT                                          0xc
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__OFFCAN_CONT__SHIFT                                         0xd
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__RESET__SHIFT                                               0xe
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__RESERVED_15_15__SHIFT                                      0xf
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__REQ_MASK                                                   0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__RATE_MASK                                                  0x0006L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__WIDTH_MASK                                                 0x0018L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__PSTATE_MASK                                                0x0060L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__LPD_MASK                                                   0x0080L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__CDR_VCO_LOWFREQ_MASK                                       0x0100L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__ADAPT_AFE_EN_MASK                                          0x0200L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__ADAPT_DFE_EN_MASK                                          0x0400L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__ADAPT_REQ_MASK                                             0x0800L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__ADAPT_CONT_MASK                                            0x1000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__OFFCAN_CONT_MASK                                           0x2000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__RESET_MASK                                                 0x4000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN__RESERVED_15_15_MASK                                        0x8000L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_1__REF_LD_VAL__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_1__RESERVED_15_7__SHIFT                                     0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_1__REF_LD_VAL_MASK                                          0x007FL
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_1__RESERVED_15_7_MASK                                       0xFF80L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_2__VCO_LD_VAL__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_2__RESERVED_15_13__SHIFT                                    0xd
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_2__VCO_LD_VAL_MASK                                          0x1FFFL
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_2__RESERVED_15_13_MASK                                      0xE000L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_3__EQ_ATT_LVL__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_3__EQ_VGA1_GAIN__SHIFT                                      0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_3__EQ_VGA2_GAIN__SHIFT                                      0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_3__EQ_CTLE_BOOST__SHIFT                                     0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_3__EQ_ATT_LVL_MASK                                          0x0007L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_3__EQ_VGA1_GAIN_MASK                                        0x0078L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_3__EQ_VGA2_GAIN_MASK                                        0x0780L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_3__EQ_CTLE_BOOST_MASK                                       0xF800L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_4
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_4__EQ_CTLE_POLE__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_4__EQ_DFE_TAP1__SHIFT                                       0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_4__RESERVED_15_11__SHIFT                                    0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_4__EQ_CTLE_POLE_MASK                                        0x0007L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_4__EQ_DFE_TAP1_MASK                                         0x07F8L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_IN_4__RESERVED_15_11_MASK                                      0xF800L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT__ACK__SHIFT                                               0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT__EN_CTL__SHIFT                                            0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT__RESERVED_15_2__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT__ACK_MASK                                                 0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT__EN_CTL_MASK                                              0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT__RESERVED_15_2_MASK                                       0xFFFCL
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_OUT
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_OUT__ACK__SHIFT                                                0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_OUT__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_OUT__ACK_MASK                                                  0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PCS_OUT__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_ADAPT_ACK
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_ADAPT_ACK__RX_ADAPT_ACK__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_ADAPT_ACK__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_ADAPT_ACK__RX_ADAPT_ACK_MASK                                       0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_ADAPT_ACK__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_ADAPT_FOM
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_ADAPT_FOM__RX_ADAPT_FOM__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_ADAPT_FOM__RESERVED_15_8__SHIFT                                    0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_ADAPT_FOM__RX_ADAPT_FOM_MASK                                       0x00FFL
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_ADAPT_FOM__RESERVED_15_8_MASK                                      0xFF00L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_TXPRE_DIR
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_TXPRE_DIR__RX_TXPRE_DIR__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_TXPRE_DIR__RESERVED_15_2__SHIFT                                    0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_TXPRE_DIR__RX_TXPRE_DIR_MASK                                       0x0003L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_TXPRE_DIR__RESERVED_15_2_MASK                                      0xFFFCL
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_TXMAIN_DIR
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_TXMAIN_DIR__RX_TXMAIN_DIR__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_TXMAIN_DIR__RESERVED_15_2__SHIFT                                   0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_TXMAIN_DIR__RX_TXMAIN_DIR_MASK                                     0x0003L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_TXMAIN_DIR__RESERVED_15_2_MASK                                     0xFFFCL
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_TXPOST_DIR
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_TXPOST_DIR__RX_TXPOST_DIR__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_TXPOST_DIR__RESERVED_15_2__SHIFT                                   0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_TXPOST_DIR__RX_TXPOST_DIR_MASK                                     0x0003L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_TXPOST_DIR__RESERVED_15_2_MASK                                     0xFFFCL
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_LANE_NUMBER
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_LANE_NUMBER__LANE_NUMBER__SHIFT                                       0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_LANE_NUMBER__RESERVED_15_4__SHIFT                                     0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_LANE_NUMBER__LANE_NUMBER_MASK                                         0x000FL
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_LANE_NUMBER__RESERVED_15_4_MASK                                       0xFFF0L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RESERVED_1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RESERVED_1__RESERVED_REG_1__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RESERVED_1__RESERVED_REG_1_MASK                                       0xFFFFL
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RESERVED_2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RESERVED_2__RESERVED_REG_2__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RESERVED_2__RESERVED_REG_2_MASK                                       0xFFFFL
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_RESET_ATE_OVRD_VAL__SHIFT                             0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_RESET_ATE_OVRD_EN__SHIFT                              0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__TX_RESET_ATE_OVRD_VAL__SHIFT                             0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__TX_RESET_ATE_OVRD_EN__SHIFT                              0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_REQ_ATE_OVRD_VAL__SHIFT                               0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_REQ_ATE_OVRD_EN__SHIFT                                0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__TX_REQ_ATE_OVRD_VAL__SHIFT                               0x6
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__TX_REQ_ATE_OVRD_EN__SHIFT                                0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_AFE_EN_OVRD_VAL__SHIFT                          0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_AFE_EN_OVRD_EN__SHIFT                           0x9
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_DFE_EN_OVRD_VAL__SHIFT                          0xa
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_DFE_EN_OVRD_EN__SHIFT                           0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__TX_DATA_EN_ATE_OVRD_VAL__SHIFT                           0xc
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__TX_DATA_EN_ATE_OVRD_EN__SHIFT                            0xd
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_DATA_EN_ATE_OVRD_VAL__SHIFT                           0xe
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_DATA_EN_ATE_OVRD_EN__SHIFT                            0xf
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_RESET_ATE_OVRD_VAL_MASK                               0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_RESET_ATE_OVRD_EN_MASK                                0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__TX_RESET_ATE_OVRD_VAL_MASK                               0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__TX_RESET_ATE_OVRD_EN_MASK                                0x0008L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_REQ_ATE_OVRD_VAL_MASK                                 0x0010L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_REQ_ATE_OVRD_EN_MASK                                  0x0020L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__TX_REQ_ATE_OVRD_VAL_MASK                                 0x0040L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__TX_REQ_ATE_OVRD_EN_MASK                                  0x0080L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_AFE_EN_OVRD_VAL_MASK                            0x0100L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_AFE_EN_OVRD_EN_MASK                             0x0200L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_DFE_EN_OVRD_VAL_MASK                            0x0400L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_DFE_EN_OVRD_EN_MASK                             0x0800L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__TX_DATA_EN_ATE_OVRD_VAL_MASK                             0x1000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__TX_DATA_EN_ATE_OVRD_EN_MASK                              0x2000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_DATA_EN_ATE_OVRD_VAL_MASK                             0x4000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_OVRD_IN__RX_DATA_EN_ATE_OVRD_EN_MASK                              0x8000L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RX_EQ_DELTA_IQ_OVRD_VAL__SHIFT                0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RX_EQ_DELTA_IQ_OVRD_EN__SHIFT                 0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RESERVED_15_5__SHIFT                          0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RX_EQ_DELTA_IQ_OVRD_VAL_MASK                  0x000FL
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RX_EQ_DELTA_IQ_OVRD_EN_MASK                   0x0010L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RESERVED_15_5_MASK                            0xFFE0L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RX_TERM_CTRL_OVRD_VAL__SHIFT                  0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RX_TERM_CTRL_OVRD_EN__SHIFT                   0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__TX_TERM_CTRL_OVRD_VAL__SHIFT                  0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__TX_TERM_CTRL_OVRD_EN__SHIFT                   0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RESERVED_15_8__SHIFT                          0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RX_TERM_CTRL_OVRD_VAL_MASK                    0x0007L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RX_TERM_CTRL_OVRD_EN_MASK                     0x0008L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__TX_TERM_CTRL_OVRD_VAL_MASK                    0x0070L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__TX_TERM_CTRL_OVRD_EN_MASK                     0x0080L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RESERVED_15_8_MASK                            0xFF00L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_IN
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_IN__RX_TERM_CTRL__SHIFT                                0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_IN__TX_TERM_CTRL__SHIFT                                0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_IN__RESERVED_15_6__SHIFT                               0x6
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_IN__RX_TERM_CTRL_MASK                                  0x0007L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_IN__TX_TERM_CTRL_MASK                                  0x0038L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TXRX_TERM_CTRL_IN__RESERVED_15_6_MASK                                 0xFFC0L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT_1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT_1__RX_CLK_EN__SHIFT                                       0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT_1__RESERVED_15_1__SHIFT                                   0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT_1__RX_CLK_EN_MASK                                         0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT_1__RESERVED_15_1_MASK                                     0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_OVRD_IN_1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_AFE_GAIN_OVRD_VAL__SHIFT                       0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_ATT_LVL_OVRD_VAL__SHIFT                        0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_OVRD_EN__SHIFT                                 0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RESERVED_15_8__SHIFT                                 0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_AFE_GAIN_OVRD_VAL_MASK                         0x000FL
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_ATT_LVL_OVRD_VAL_MASK                          0x0070L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_OVRD_EN_MASK                                   0x0080L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RESERVED_15_8_MASK                                   0xFF00L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_OVRD_IN_2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RX_EQ_DFE_TAP1_OVRD_VAL__SHIFT                       0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RX_EQ_CTLE_BOOST_OVRD_VAL__SHIFT                     0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RESERVED_15_13__SHIFT                                0xd
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RX_EQ_DFE_TAP1_OVRD_VAL_MASK                         0x00FFL
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RX_EQ_CTLE_BOOST_OVRD_VAL_MASK                       0x1F00L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RESERVED_15_13_MASK                                  0xE000L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PH2_CAL
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_ACK_VAL__SHIFT                                    0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_REQ_VAL__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_REQ_OVRD_VAL__SHIFT                               0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PH2_CAL__RESERVED_15_3__SHIFT                                      0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_ACK_VAL_MASK                                      0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_REQ_VAL_MASK                                      0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_REQ_OVRD_VAL_MASK                                 0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_PH2_CAL__RESERVED_15_3_MASK                                        0xFFF8L
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FSM_OVRD_CTL
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FSM_OVRD_CTL__FSM_JMP_ADDR__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FSM_OVRD_CTL__FSM_JMP_EN__SHIFT                                          0xc
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FSM_OVRD_CTL__FSM_CMD_START__SHIFT                                       0xd
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FSM_OVRD_CTL__FSM_OVRD_EN__SHIFT                                         0xe
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FSM_OVRD_CTL__FSM_BREAK__SHIFT                                           0xf
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FSM_OVRD_CTL__FSM_JMP_ADDR_MASK                                          0x0FFFL
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FSM_OVRD_CTL__FSM_JMP_EN_MASK                                            0x1000L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FSM_OVRD_CTL__FSM_CMD_START_MASK                                         0x2000L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FSM_OVRD_CTL__FSM_OVRD_EN_MASK                                           0x4000L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FSM_OVRD_CTL__FSM_BREAK_MASK                                             0x8000L
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_MEM_ADDR_MON
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_MEM_ADDR_MON__MEM_ADDR__SHIFT                                            0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_MEM_ADDR_MON__MEM_ADDR_MASK                                              0xFFFFL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_STATUS_MON
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_STATUS_MON__STATE__SHIFT                                                 0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_STATUS_MON__CMD_RDY__SHIFT                                               0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_STATUS_MON__ALU_OVFLW__SHIFT                                             0x6
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_STATUS_MON__ALU_RES_EQ0__SHIFT                                           0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_STATUS_MON__WAIT_CNT_EQ0__SHIFT                                          0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_STATUS_MON__WRMSK_DISABLED__SHIFT                                        0x9
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_STATUS_MON__RDMSK_DISABLED__SHIFT                                        0xa
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_STATUS_MON__RESERVED_15_11__SHIFT                                        0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_STATUS_MON__STATE_MASK                                                   0x001FL
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_STATUS_MON__CMD_RDY_MASK                                                 0x0020L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_STATUS_MON__ALU_OVFLW_MASK                                               0x0040L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_STATUS_MON__ALU_RES_EQ0_MASK                                             0x0080L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_STATUS_MON__WAIT_CNT_EQ0_MASK                                            0x0100L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_STATUS_MON__WRMSK_DISABLED_MASK                                          0x0200L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_STATUS_MON__RDMSK_DISABLED_MASK                                          0x0400L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_STATUS_MON__RESERVED_15_11_MASK                                          0xF800L
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_STARTUP_CAL
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_STARTUP_CAL__FAST_RX_STARTUP_CAL__SHIFT                          0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_STARTUP_CAL__RESERVED_15_1__SHIFT                                0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_STARTUP_CAL__FAST_RX_STARTUP_CAL_MASK                            0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_STARTUP_CAL__RESERVED_15_1_MASK                                  0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_ADAPT
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_ADAPT__FAST_RX_ADAPT__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_ADAPT__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_ADAPT__FAST_RX_ADAPT_MASK                                        0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_ADAPT__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_AFE_CAL
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_AFE_CAL__FAST_RX_AFE_CAL__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_AFE_CAL__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_AFE_CAL__FAST_RX_AFE_CAL_MASK                                    0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_AFE_CAL__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_DFE_CAL
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_DFE_CAL__FAST_RX_DFE_CAL__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_DFE_CAL__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_DFE_CAL__FAST_RX_DFE_CAL_MASK                                    0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_DFE_CAL__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_BYPASS_CAL
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_BYPASS_CAL__FAST_RX_BYPASS_CAL__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_BYPASS_CAL__RESERVED_15_1__SHIFT                                 0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_BYPASS_CAL__FAST_RX_BYPASS_CAL_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_BYPASS_CAL__RESERVED_15_1_MASK                                   0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_REFLVL_CAL
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_REFLVL_CAL__FAST_RX_REFLVL_CAL__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_REFLVL_CAL__RESERVED_15_1__SHIFT                                 0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_REFLVL_CAL__FAST_RX_REFLVL_CAL_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_REFLVL_CAL__RESERVED_15_1_MASK                                   0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_IQ_CAL
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_IQ_CAL__FAST_RX_IQ_CAL__SHIFT                                    0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_IQ_CAL__RESERVED_15_1__SHIFT                                     0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_IQ_CAL__FAST_RX_IQ_CAL_MASK                                      0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_IQ_CAL__RESERVED_15_1_MASK                                       0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_AFE_ADAPT
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_AFE_ADAPT__FAST_RX_AFE_ADAPT__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_AFE_ADAPT__RESERVED_15_1__SHIFT                                  0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_AFE_ADAPT__FAST_RX_AFE_ADAPT_MASK                                0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_AFE_ADAPT__RESERVED_15_1_MASK                                    0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_DFE_ADAPT
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_DFE_ADAPT__FAST_RX_DFE_ADAPT__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_DFE_ADAPT__RESERVED_15_1__SHIFT                                  0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_DFE_ADAPT__FAST_RX_DFE_ADAPT_MASK                                0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_DFE_ADAPT__RESERVED_15_1_MASK                                    0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_SUP
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_SUP__FAST_SUP__SHIFT                                                0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_SUP__RESERVED_15_1__SHIFT                                           0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_SUP__FAST_SUP_MASK                                                  0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_SUP__RESERVED_15_1_MASK                                             0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_TX_CMN_MODE
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_TX_CMN_MODE__FAST_TX_CMN_MODE__SHIFT                                0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_TX_CMN_MODE__RESERVED_15_1__SHIFT                                   0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_TX_CMN_MODE__FAST_TX_CMN_MODE_MASK                                  0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_TX_CMN_MODE__RESERVED_15_1_MASK                                     0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_TX_RXDET
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_TX_RXDET__FAST_TX_RXDET__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_TX_RXDET__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_TX_RXDET__FAST_TX_RXDET_MASK                                        0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_TX_RXDET__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_PWRUP
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_PWRUP__FAST_RX_PWRUP__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_PWRUP__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_PWRUP__FAST_RX_PWRUP_MASK                                        0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_PWRUP__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_VCO_WAIT
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_VCO_WAIT__FAST_RX_VCO_WAIT__SHIFT                                0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_VCO_WAIT__RESERVED_15_1__SHIFT                                   0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_VCO_WAIT__FAST_RX_VCO_WAIT_MASK                                  0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_VCO_WAIT__RESERVED_15_1_MASK                                     0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_VCO_CAL
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_VCO_CAL__FAST_RX_VCO_CAL__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_VCO_CAL__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_VCO_CAL__FAST_RX_VCO_CAL_MASK                                    0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_VCO_CAL__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_CMNCAL_MPLL_STATUS
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CMNCAL_MPLL_STATUS__CMNCAL_MPLL_INIT__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CMNCAL_MPLL_STATUS__CMNCAL_MPLL_DONE__SHIFT                              0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CMNCAL_MPLL_STATUS__RESERVED_15_2__SHIFT                                 0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CMNCAL_MPLL_STATUS__CMNCAL_MPLL_INIT_MASK                                0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CMNCAL_MPLL_STATUS__CMNCAL_MPLL_DONE_MASK                                0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CMNCAL_MPLL_STATUS__RESERVED_15_2_MASK                                   0xFFFCL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_CAL_ADAPT
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_CAL_ADAPT__FAST_RX_CONT_CAL_ADAPT__SHIFT                    0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_CAL_ADAPT__RESERVED_15_1__SHIFT                             0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_CAL_ADAPT__FAST_RX_CONT_CAL_ADAPT_MASK                      0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_CAL_ADAPT__RESERVED_15_1_MASK                               0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_ADAPT
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_ADAPT__FAST_RX_CONT_ADAPT__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_ADAPT__RESERVED_15_1__SHIFT                                 0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_ADAPT__FAST_RX_CONT_ADAPT_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_ADAPT__RESERVED_15_1_MASK                                   0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_DATA_CAL
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_DATA_CAL__FAST_RX_CONT_DATA_CAL__SHIFT                      0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_DATA_CAL__RESERVED_15_1__SHIFT                              0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_DATA_CAL__FAST_RX_CONT_DATA_CAL_MASK                        0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_DATA_CAL__RESERVED_15_1_MASK                                0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_PHASE_CAL
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_PHASE_CAL__FAST_RX_CONT_PHASE_CAL__SHIFT                    0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_PHASE_CAL__RESERVED_15_1__SHIFT                             0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_PHASE_CAL__FAST_RX_CONT_PHASE_CAL_MASK                      0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_PHASE_CAL__RESERVED_15_1_MASK                               0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_AFE_CAL
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_AFE_CAL__FAST_RX_CONT_AFE_CAL__SHIFT                        0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_AFE_CAL__RESERVED_15_1__SHIFT                               0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_AFE_CAL__FAST_RX_CONT_AFE_CAL_MASK                          0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_RX_CONT_AFE_CAL__RESERVED_15_1_MASK                                 0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__TX_FAST_DCC_CAL__SHIFT                                       0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RX_FAST_DCC_CAL__SHIFT                                       0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RX_FAST_VPHUD_CAL__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RX_FAST_VREF_CAL__SHIFT                                      0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RX_FAST_SIGDET_CAL__SHIFT                                    0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RESERVED_2__SHIFT                                            0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__TX_FAST_CONT_DCC_CAL__SHIFT                                  0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_DCC_CAL__SHIFT                                  0x9
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_VPHUD_CAL__SHIFT                                0xa
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_VREF_CAL__SHIFT                                 0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RESERVED_1__SHIFT                                            0xc
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__TX_SKIP_SUP_CAL__SHIFT                                       0xf
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__TX_FAST_DCC_CAL_MASK                                         0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RX_FAST_DCC_CAL_MASK                                         0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RX_FAST_VPHUD_CAL_MASK                                       0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RX_FAST_VREF_CAL_MASK                                        0x0008L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RX_FAST_SIGDET_CAL_MASK                                      0x0010L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RESERVED_2_MASK                                              0x00E0L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__TX_FAST_CONT_DCC_CAL_MASK                                    0x0100L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_DCC_CAL_MASK                                    0x0200L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_VPHUD_CAL_MASK                                  0x0400L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_VREF_CAL_MASK                                   0x0800L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__RESERVED_1_MASK                                              0x7000L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_FAST_FLAGS__TX_SKIP_SUP_CAL_MASK                                         0x8000L
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_CR_LOCK
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CR_LOCK__CR_REG_LOCK__SHIFT                                              0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CR_LOCK__CR_MEM_LOCK__SHIFT                                              0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CR_LOCK__RESERVED_15_2__SHIFT                                            0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CR_LOCK__CR_REG_LOCK_MASK                                                0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CR_LOCK__CR_MEM_LOCK_MASK                                                0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CR_LOCK__RESERVED_15_2_MASK                                              0xFFFCL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_DCC_FLAGS
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_DCC_FLAGS__RATE__SHIFT                                                0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_DCC_FLAGS__DIV__SHIFT                                                 0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_DCC_FLAGS__MPLL__SHIFT                                                0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_DCC_FLAGS__RESERVED_15_3__SHIFT                                       0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_DCC_FLAGS__RATE_MASK                                                  0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_DCC_FLAGS__DIV_MASK                                                   0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_DCC_FLAGS__MPLL_MASK                                                  0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_DCC_FLAGS__RESERVED_15_3_MASK                                         0xFFF8L
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_DCC_STATUS
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_DCC_STATUS__FLAG__SHIFT                                               0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_DCC_STATUS__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_DCC_STATUS__FLAG_MASK                                                 0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_DCC_STATUS__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_OCLA
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_OCLA__PC_EN__SHIFT                                                       0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_OCLA__REG_BANK1_EN__SHIFT                                                0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_OCLA__REG_BANK2_EN__SHIFT                                                0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_OCLA__RESERVED_15_3__SHIFT                                               0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_OCLA__PC_EN_MASK                                                         0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_OCLA__REG_BANK1_EN_MASK                                                  0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_OCLA__REG_BANK2_EN_MASK                                                  0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_OCLA__RESERVED_15_3_MASK                                                 0xFFF8L
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_EQ_UPDATE_FLAG
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_EQ_UPDATE_FLAG__TX_EQ_UPDATE_FLAG__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_EQ_UPDATE_FLAG__RESERVED_15_1__SHIFT                                  0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_EQ_UPDATE_FLAG__TX_EQ_UPDATE_FLAG_MASK                                0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_TX_EQ_UPDATE_FLAG__RESERVED_15_1_MASK                                    0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_CMNCAL_RCAL_STATUS
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CMNCAL_RCAL_STATUS__CMNCAL_RCAL_INIT__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CMNCAL_RCAL_STATUS__CMNCAL_RCAL_DONE__SHIFT                              0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CMNCAL_RCAL_STATUS__RESERVED_15_2__SHIFT                                 0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CMNCAL_RCAL_STATUS__CMNCAL_RCAL_INIT_MASK                                0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CMNCAL_RCAL_STATUS__CMNCAL_RCAL_DONE_MASK                                0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_CMNCAL_RCAL_STATUS__RESERVED_15_2_MASK                                   0xFFFCL
//DPCSSYS_CR0_RAWLANE1_DIG_FSM_RX_IQ_PHASE_OFFSET
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_RX_IQ_PHASE_OFFSET__RX_IQ_PHASE_OFFSET__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_RX_IQ_PHASE_OFFSET__RESERVED_15_4__SHIFT                                 0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_RX_IQ_PHASE_OFFSET__RX_IQ_PHASE_OFFSET_MASK                              0x000FL
#define DPCSSYS_CR0_RAWLANE1_DIG_FSM_RX_IQ_PHASE_OFFSET__RESERVED_15_4_MASK                                   0xFFF0L
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RESET_RTN_REQ
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RESET_RTN_REQ__RESET_RTN_REQ__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RESET_RTN_REQ__RESERVED_15_1__SHIFT                                  0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RESET_RTN_REQ__RESET_RTN_REQ_MASK                                    0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RESET_RTN_REQ__RESERVED_15_1_MASK                                    0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RESET_IRQ
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RESET_IRQ__RX_RESET__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RESET_IRQ__RESERVED_15_1__SHIFT                                   0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RESET_IRQ__RX_RESET_MASK                                          0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RESET_IRQ__RESERVED_15_1_MASK                                     0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_REQ_IRQ
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_REQ_IRQ__RX_REQ__SHIFT                                            0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_REQ_IRQ__RESERVED_15_1__SHIFT                                     0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_REQ_IRQ__RX_REQ_MASK                                              0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_REQ_IRQ__RESERVED_15_1_MASK                                       0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RATE_IRQ
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RATE_IRQ__RX_RATE_IRQ__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RATE_IRQ__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RATE_IRQ__RX_RATE_IRQ_MASK                                        0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RATE_IRQ__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PSTATE_IRQ
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PSTATE_IRQ__RX_PSTATE_IRQ__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PSTATE_IRQ__RESERVED_15_1__SHIFT                                  0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PSTATE_IRQ__RX_PSTATE_IRQ_MASK                                    0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PSTATE_IRQ__RESERVED_15_1_MASK                                    0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ__RX_ADAPT_REQ_IRQ__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ__RESERVED_15_1__SHIFT                               0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ__RX_ADAPT_REQ_IRQ_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ__RESERVED_15_1_MASK                                 0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ__RX_ADAPT_DIS_IRQ__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ__RESERVED_15_1__SHIFT                               0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ__RX_ADAPT_DIS_IRQ_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ__RESERVED_15_1_MASK                                 0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RESET_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RESET_IRQ_CLR__RX_RESET_IRQ_CLR__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RESET_IRQ_CLR__RESERVED_15_1__SHIFT                               0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RESET_IRQ_CLR__RX_RESET_IRQ_CLR_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RESET_IRQ_CLR__RESERVED_15_1_MASK                                 0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_REQ_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_REQ_IRQ_CLR__RX_REQ_IRQ_CLR__SHIFT                                0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_REQ_IRQ_CLR__RESERVED_15_1__SHIFT                                 0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_REQ_IRQ_CLR__RX_REQ_IRQ_CLR_MASK                                  0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_REQ_IRQ_CLR__RESERVED_15_1_MASK                                   0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RATE_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RATE_IRQ_CLR__RX_RATE_IRQ_CLR__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RATE_IRQ_CLR__RESERVED_15_1__SHIFT                                0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RATE_IRQ_CLR__RX_RATE_IRQ_CLR_MASK                                0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_RATE_IRQ_CLR__RESERVED_15_1_MASK                                  0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PSTATE_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PSTATE_IRQ_CLR__RX_PSTATE_IRQ_CLR__SHIFT                          0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PSTATE_IRQ_CLR__RESERVED_15_1__SHIFT                              0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PSTATE_IRQ_CLR__RX_PSTATE_IRQ_CLR_MASK                            0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PSTATE_IRQ_CLR__RESERVED_15_1_MASK                                0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ_CLR__RX_ADAPT_REQ_IRQ_CLR__SHIFT                    0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ_CLR__RESERVED_15_1__SHIFT                           0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ_CLR__RX_ADAPT_REQ_IRQ_CLR_MASK                      0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_REQ_IRQ_CLR__RESERVED_15_1_MASK                             0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ_CLR__RX_ADAPT_DIS_IRQ_CLR__SHIFT                    0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ_CLR__RESERVED_15_1__SHIFT                           0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ_CLR__RX_ADAPT_DIS_IRQ_CLR_MASK                      0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_ADAPT_DIS_IRQ_CLR__RESERVED_15_1_MASK                             0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RX_REQ_IRQ_MSK__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RX_RATE_IRQ_MSK__SHIFT                                     0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RX_PSTATE_IRQ_MSK__SHIFT                                   0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RX_ADAPT_REQ_IRQ_MSK__SHIFT                                0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RX_ADAPT_DIS_IRQ_MSK__SHIFT                                0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RX_RESET_IRQ_MSK__SHIFT                                    0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__LANE_XCVR_MODE_IRQ_MSK__SHIFT                              0x6
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RX_PH2_CAL_REQ_IRQ_MSK__SHIFT                              0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RX_PH2_CAL_DIS_IRQ_MSK__SHIFT                              0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__LANE_RX2TX_SER_LB_EN_IRQ_MSK__SHIFT                        0x9
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__DCC_ONDMD_IRQ_MSK__SHIFT                                   0xa
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RESERVED_15_11__SHIFT                                      0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RX_REQ_IRQ_MSK_MASK                                        0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RX_RATE_IRQ_MSK_MASK                                       0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RX_PSTATE_IRQ_MSK_MASK                                     0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RX_ADAPT_REQ_IRQ_MSK_MASK                                  0x0008L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RX_ADAPT_DIS_IRQ_MSK_MASK                                  0x0010L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RX_RESET_IRQ_MSK_MASK                                      0x0020L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__LANE_XCVR_MODE_IRQ_MSK_MASK                                0x0040L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RX_PH2_CAL_REQ_IRQ_MSK_MASK                                0x0080L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RX_PH2_CAL_DIS_IRQ_MSK_MASK                                0x0100L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__LANE_RX2TX_SER_LB_EN_IRQ_MSK_MASK                          0x0200L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__DCC_ONDMD_IRQ_MSK_MASK                                     0x0400L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK__RESERVED_15_11_MASK                                        0xF800L
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK_2
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK_2__TX_RESET_IRQ_MSK__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK_2__TX_REQ_IRQ_MSK__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK_2__RESERVED_15_2__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK_2__TX_RESET_IRQ_MSK_MASK                                    0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK_2__TX_REQ_IRQ_MSK_MASK                                      0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_IRQ_MASK_2__RESERVED_15_2_MASK                                       0xFFFCL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ__LANE_XCVR_MODE_IRQ__SHIFT                        0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ__RESERVED_15_1__SHIFT                             0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ__LANE_XCVR_MODE_IRQ_MASK                          0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ__RESERVED_15_1_MASK                               0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ_CLR__LANE_XCVR_MODE_IRQ_CLR__SHIFT                0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ_CLR__RESERVED_15_1__SHIFT                         0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ_CLR__LANE_XCVR_MODE_IRQ_CLR_MASK                  0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_XCVR_MODE_IRQ_CLR__RESERVED_15_1_MASK                           0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ__RX_PH2_CAL_REQ_IRQ__SHIFT                        0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ__RESERVED_15_1__SHIFT                             0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ__RX_PH2_CAL_REQ_IRQ_MASK                          0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ__RESERVED_15_1_MASK                               0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ__RX_PH2_CAL_DIS_IRQ__SHIFT                        0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ__RESERVED_15_1__SHIFT                             0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ__RX_PH2_CAL_DIS_IRQ_MASK                          0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ__RESERVED_15_1_MASK                               0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ_CLR__RX_PH2_CAL_REQ_IRQ_CLR__SHIFT                0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ_CLR__RESERVED_15_1__SHIFT                         0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ_CLR__RX_PH2_CAL_REQ_IRQ_CLR_MASK                  0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_REQ_IRQ_CLR__RESERVED_15_1_MASK                           0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ_CLR__RX_PH2_CAL_DIS_IRQ_CLR__SHIFT                0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ_CLR__RESERVED_15_1__SHIFT                         0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ_CLR__RX_PH2_CAL_DIS_IRQ_CLR_MASK                  0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_RX_PH2_CAL_DIS_IRQ_CLR__RESERVED_15_1_MASK                           0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ__LANE_RX2TX_SER_LB_EN_IRQ__SHIFT            0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ__RESERVED_15_1__SHIFT                       0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ__LANE_RX2TX_SER_LB_EN_IRQ_MASK              0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ__RESERVED_15_1_MASK                         0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ_CLR__LANE_RX2TX_SER_LB_EN_IRQ_CLR__SHIFT    0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ_CLR__RESERVED_15_1__SHIFT                   0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ_CLR__LANE_RX2TX_SER_LB_EN_IRQ_CLR_MASK      0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_LANE_RX2TX_SER_LB_EN_IRQ_CLR__RESERVED_15_1_MASK                     0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_DCC_ONDMD_IRQ
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_DCC_ONDMD_IRQ__IRQ__SHIFT                                            0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_DCC_ONDMD_IRQ__RESERVED_15_1__SHIFT                                  0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_DCC_ONDMD_IRQ__IRQ_MASK                                              0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_DCC_ONDMD_IRQ__RESERVED_15_1_MASK                                    0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_RESET_IRQ
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_RESET_IRQ__TX_RESET__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_RESET_IRQ__RESERVED_15_1__SHIFT                                   0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_RESET_IRQ__TX_RESET_MASK                                          0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_RESET_IRQ__RESERVED_15_1_MASK                                     0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_REQ_IRQ
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_REQ_IRQ__TX_REQ__SHIFT                                            0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_REQ_IRQ__RESERVED_15_1__SHIFT                                     0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_REQ_IRQ__TX_REQ_MASK                                              0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_REQ_IRQ__RESERVED_15_1_MASK                                       0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_RESET_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_RESET_IRQ_CLR__TX_RESET_IRQ_CLR__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_RESET_IRQ_CLR__RESERVED_15_1__SHIFT                               0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_RESET_IRQ_CLR__TX_RESET_IRQ_CLR_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_RESET_IRQ_CLR__RESERVED_15_1_MASK                                 0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_REQ_IRQ_CLR
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_REQ_IRQ_CLR__TX_REQ_IRQ_CLR__SHIFT                                0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_REQ_IRQ_CLR__RESERVED_15_1__SHIFT                                 0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_REQ_IRQ_CLR__TX_REQ_IRQ_CLR_MASK                                  0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_IRQ_CTL_TX_REQ_IRQ_CLR__RESERVED_15_1_MASK                                   0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_IN
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_IN__LANE_MPLLA_EN_IN__SHIFT                                 0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_IN__LANE_MPLLB_EN_IN__SHIFT                                 0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_IN__LANE_OVRD_EN__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_IN__RESERVED_15_3__SHIFT                                    0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_IN__LANE_MPLLA_EN_IN_MASK                                   0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_IN__LANE_MPLLB_EN_IN_MASK                                   0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_IN__LANE_OVRD_EN_MASK                                       0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_IN__RESERVED_15_3_MASK                                      0xFFF8L
//DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_OUT
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_OUT__LANE_MPLLA_EN_OUT__SHIFT                               0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_OUT__LANE_MPLLB_EN_OUT__SHIFT                               0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_OUT__LANE_OVRD_EN__SHIFT                                    0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_OUT__RESERVED_15_3__SHIFT                                   0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_OUT__LANE_MPLLA_EN_OUT_MASK                                 0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_OUT__LANE_MPLLB_EN_OUT_MASK                                 0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_OUT__LANE_OVRD_EN_MASK                                      0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_OVRD_OUT__RESERVED_15_3_MASK                                     0xFFF8L
//DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_OVRD_IN
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_OVRD_IN__MPLLA_STATE__SHIFT                                       0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_OVRD_IN__MPLLB_STATE__SHIFT                                       0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_OVRD_IN__SUP_STATE_OVRD_EN__SHIFT                                 0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_OVRD_IN__RESERVED_15_3__SHIFT                                     0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_OVRD_IN__MPLLA_STATE_MASK                                         0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_OVRD_IN__MPLLB_STATE_MASK                                         0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_OVRD_IN__SUP_STATE_OVRD_EN_MASK                                   0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_OVRD_IN__RESERVED_15_3_MASK                                       0xFFF8L
//DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_PMA_IN
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_PMA_IN__MPLLA_STATE__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_PMA_IN__MPLLB_STATE__SHIFT                                        0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_PMA_IN__RESERVED_15_2__SHIFT                                      0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_PMA_IN__MPLLA_STATE_MASK                                          0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_PMA_IN__MPLLB_STATE_MASK                                          0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_PMA_IN__RESERVED_15_2_MASK                                        0xFFFCL
//DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_REQ_OVRD_VAL__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_REQ_OVRD_EN__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_RESET_OVRD_VAL__SHIFT                                 0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_RESET_OVRD_EN__SHIFT                                  0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_BEACON_EN_OVRD_VAL__SHIFT                             0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_BEACON_EN_OVRD_EN__SHIFT                              0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_ASYNC_DRV_EN_OVRD_VAL__SHIFT                          0x6
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_ASYNC_DRV_EN_OVRD_EN__SHIFT                           0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_ASYNC_EN_OVRD_VAL__SHIFT                              0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_ASYNC_EN_OVRD_EN__SHIFT                               0x9
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_VAL__SHIFT                        0xa
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_EN__SHIFT                         0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__LANE_TX2RX_SER_LB_EN_OVRD_VAL__SHIFT                     0xc
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__LANE_TX2RX_SER_LB_EN_OVRD_EN__SHIFT                      0xd
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_PMA_DATA_EN_OVRD_VAL_R__SHIFT                         0xe
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_PMA_DATA_EN_OVRD_EN_R__SHIFT                          0xf
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_REQ_OVRD_VAL_MASK                                     0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_REQ_OVRD_EN_MASK                                      0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_RESET_OVRD_VAL_MASK                                   0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_RESET_OVRD_EN_MASK                                    0x0008L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_BEACON_EN_OVRD_VAL_MASK                               0x0010L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_BEACON_EN_OVRD_EN_MASK                                0x0020L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_ASYNC_DRV_EN_OVRD_VAL_MASK                            0x0040L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_ASYNC_DRV_EN_OVRD_EN_MASK                             0x0080L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_ASYNC_EN_OVRD_VAL_MASK                                0x0100L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_ASYNC_EN_OVRD_EN_MASK                                 0x0200L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_VAL_MASK                          0x0400L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_EN_MASK                           0x0800L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__LANE_TX2RX_SER_LB_EN_OVRD_VAL_MASK                       0x1000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__LANE_TX2RX_SER_LB_EN_OVRD_EN_MASK                        0x2000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_PMA_DATA_EN_OVRD_VAL_R_MASK                           0x4000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_OVRD_OUT__TX_PMA_DATA_EN_OVRD_EN_R_MASK                            0x8000L
//DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_PMA_IN
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_PMA_IN__ACK__SHIFT                                                 0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_PMA_IN__RESERVED_15_1__SHIFT                                       0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_PMA_IN__ACK_MASK                                                   0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_TX_PMA_IN__RESERVED_15_1_MASK                                         0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__RX_REQ_OVRD_VAL__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__RX_REQ_OVRD_EN__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__RX_RESET_OVRD_VAL__SHIFT                                 0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__RX_RESET_OVRD_EN__SHIFT                                  0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__LANE_RX2TX_PAR_LB_EN_OVRD_VAL__SHIFT                     0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__LANE_RX2TX_PAR_LB_EN_OVRD_EN__SHIFT                      0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__RX_PMA_DATA_EN_OVRD_VAL_R__SHIFT                         0x6
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__RX_PMA_DATA_EN_OVRD_EN_R__SHIFT                          0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__RESERVED_15_8__SHIFT                                     0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__RX_REQ_OVRD_VAL_MASK                                     0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__RX_REQ_OVRD_EN_MASK                                      0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__RX_RESET_OVRD_VAL_MASK                                   0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__RX_RESET_OVRD_EN_MASK                                    0x0008L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__LANE_RX2TX_PAR_LB_EN_OVRD_VAL_MASK                       0x0010L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__LANE_RX2TX_PAR_LB_EN_OVRD_EN_MASK                        0x0020L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__RX_PMA_DATA_EN_OVRD_VAL_R_MASK                           0x0040L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__RX_PMA_DATA_EN_OVRD_EN_R_MASK                            0x0080L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_OVRD_OUT__RESERVED_15_8_MASK                                       0xFF00L
//DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_PMA_IN
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_PMA_IN__ACK__SHIFT                                                 0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_PMA_IN__RESERVED_15_1__SHIFT                                       0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_PMA_IN__ACK_MASK                                                   0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_PMA_IN__RESERVED_15_1_MASK                                         0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_RTUNE_CTL
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_RTUNE_CTL__LANE_RTUNE_REQ__SHIFT                                 0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_RTUNE_CTL__RESERVED_15_1__SHIFT                                  0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_RTUNE_CTL__LANE_RTUNE_REQ_MASK                                   0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_LANE_RTUNE_CTL__RESERVED_15_1_MASK                                    0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_PMA_IN_1
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_PMA_IN_1__RTUNE_ACK__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_PMA_IN_1__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_PMA_IN_1__RTUNE_ACK_MASK                                          0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_SUP_PMA_IN_1__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_WORD_CLK_R__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_WORD_CLK_OVRD_EN__SHIFT                      0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_DATA_R__SHIFT                                0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_DATA_OVRD_EN__SHIFT                          0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_CLK_R__SHIFT                                 0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_CLK_OVRD_EN__SHIFT                           0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_TERM_CTL_R__SHIFT                                0x6
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_TERM_CTL_OVRD_EN__SHIFT                          0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RESERVED_15_9__SHIFT                                    0x9
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_WORD_CLK_R_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_WORD_CLK_OVRD_EN_MASK                        0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_DATA_R_MASK                                  0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_DATA_OVRD_EN_MASK                            0x0008L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_CLK_R_MASK                                   0x0010L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_PWM_CLK_OVRD_EN_MASK                             0x0020L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_TERM_CTL_R_MASK                                  0x00C0L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RX_PMA_TERM_CTL_OVRD_EN_MASK                            0x0100L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_IN__RESERVED_15_9_MASK                                      0xFE00L
//DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_OUT
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_PWM_EN__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_PWM_EN_OVRD_EN__SHIFT                           0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_PWM_CLK_SEL__SHIFT                              0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_PWM_CLK_SEL_OVRD_EN__SHIFT                      0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_ASYNC_EN__SHIFT                                 0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_ASYNC_EN_OVRD_EN__SHIFT                         0x6
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_OUT__RESERVED_15_7__SHIFT                                   0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_PWM_EN_MASK                                     0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_PWM_EN_OVRD_EN_MASK                             0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_PWM_CLK_SEL_MASK                                0x000CL
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_PWM_CLK_SEL_OVRD_EN_MASK                        0x0010L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_ASYNC_EN_MASK                                   0x0020L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_OUT__RX_PMA_ASYNC_EN_OVRD_EN_MASK                           0x0040L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_MPHY_OVRD_OUT__RESERVED_15_7_MASK                                     0xFF80L
//DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_ADAPT_OVRD_OUT
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_ADAPT_OVRD_OUT__RX_PMA_IQ_PHASE_ADJUST_MAP_OVRD_VAL__SHIFT         0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_ADAPT_OVRD_OUT__RX_PMA_IQ_PHASE_ADJUST_MAP_OVRD_EN__SHIFT          0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_ADAPT_OVRD_OUT__RESERVED_15_8__SHIFT                               0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_ADAPT_OVRD_OUT__RX_PMA_IQ_PHASE_ADJUST_MAP_OVRD_VAL_MASK           0x007FL
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_ADAPT_OVRD_OUT__RX_PMA_IQ_PHASE_ADJUST_MAP_OVRD_EN_MASK            0x0080L
#define DPCSSYS_CR0_RAWLANE1_DIG_PMA_XF_RX_ADAPT_OVRD_OUT__RESERVED_15_8_MASK                                 0xFF00L
//DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_FSM_CTL
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_FSM_CTL__TX_WAIT_MPLL_OFF_TIME__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_FSM_CTL__TX_P2_ALLOW_RXDET__SHIFT                                  0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_FSM_CTL__TX_P1_ALLOW_RXDET__SHIFT                                  0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_FSM_CTL__TX_P0S_ALLOW_RXDET__SHIFT                                 0x9
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_FSM_CTL__TX_P0_ALLOW_RXDET__SHIFT                                  0xa
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_FSM_CTL__RESERVED_15_11__SHIFT                                     0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_FSM_CTL__TX_WAIT_MPLL_OFF_TIME_MASK                                0x007FL
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_FSM_CTL__TX_P2_ALLOW_RXDET_MASK                                    0x0080L
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_FSM_CTL__TX_P1_ALLOW_RXDET_MASK                                    0x0100L
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_FSM_CTL__TX_P0S_ALLOW_RXDET_MASK                                   0x0200L
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_FSM_CTL__TX_P0_ALLOW_RXDET_MASK                                    0x0400L
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_FSM_CTL__RESERVED_15_11_MASK                                       0xF800L
//DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_CLK_CTL
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_CLK_CTL__TX_CLK_EN__SHIFT                                          0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_CLK_CTL__TX_CLK_SEL__SHIFT                                         0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_CLK_CTL__ASYNC_BEACON_WAIT_TIME__SHIFT                             0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_CLK_CTL__RESERVED_15_11__SHIFT                                     0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_CLK_CTL__TX_CLK_EN_MASK                                            0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_CLK_CTL__TX_CLK_SEL_MASK                                           0x001EL
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_CLK_CTL__ASYNC_BEACON_WAIT_TIME_MASK                               0x07E0L
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_CLK_CTL__RESERVED_15_11_MASK                                       0xF800L
//DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_DCC_CONT_STATUS
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_DCC_CONT_STATUS__ENABLE__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_DCC_CONT_STATUS__RESERVED_15_1__SHIFT                              0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_DCC_CONT_STATUS__ENABLE_MASK                                       0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_TX_DCC_CONT_STATUS__RESERVED_15_1_MASK                                0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_OCLA
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_OCLA__FSM_EN__SHIFT                                                   0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_OCLA__RESERVED_15_1__SHIFT                                            0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_OCLA__FSM_EN_MASK                                                     0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_OCLA__RESERVED_15_1_MASK                                              0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_UPCS_OCLA
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_UPCS_OCLA__DATA_EN__SHIFT                                             0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_UPCS_OCLA__CLK_EN__SHIFT                                              0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_UPCS_OCLA__RESERVED_15_3__SHIFT                                       0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_UPCS_OCLA__DATA_EN_MASK                                               0x0003L
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_UPCS_OCLA__CLK_EN_MASK                                                0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_TX_CTL_UPCS_OCLA__RESERVED_15_3_MASK                                         0xFFF8L
//DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_RX_FSM_CTL
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_RX_FSM_CTL__EN_RX_CTL_FSM__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_RX_FSM_CTL__RATE_CHG_IN_P1__SHIFT                                     0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_RX_FSM_CTL__RESERVED_15_2__SHIFT                                      0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_RX_FSM_CTL__EN_RX_CTL_FSM_MASK                                        0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_RX_FSM_CTL__RATE_CHG_IN_P1_MASK                                       0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_RX_FSM_CTL__RESERVED_15_2_MASK                                        0xFFFCL
//DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_RX_LOS_MASK_CTL
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_RX_LOS_MASK_CTL__RX_LOS_MASK_CNT__SHIFT                               0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_RX_LOS_MASK_CTL__RESERVED_15_9__SHIFT                                 0x9
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_RX_LOS_MASK_CTL__RX_LOS_MASK_CNT_MASK                                 0x01FFL
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_RX_LOS_MASK_CTL__RESERVED_15_9_MASK                                   0xFE00L
//DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_RX_DATA_EN_OVRD_CTL
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_RX_DATA_EN_OVRD_CTL__RX_DATA_EN_OVRD_CNT__SHIFT                       0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_RX_DATA_EN_OVRD_CTL__INT_REF_TRCK_CNT__SHIFT                          0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_RX_DATA_EN_OVRD_CTL__RX_DATA_EN_OVRD_CNT_MASK                         0x001FL
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_RX_DATA_EN_OVRD_CTL__INT_REF_TRCK_CNT_MASK                            0xFFE0L
//DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_OFFCAN_CONT_STATUS
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_OFFCAN_CONT_STATUS__ENABLE__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_OFFCAN_CONT_STATUS__ENABLE_MASK                                       0x0001L
//DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_ADAPT_CONT_STATUS
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_ADAPT_CONT_STATUS__ENABLE__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_ADAPT_CONT_STATUS__RESERVED_15_1__SHIFT                               0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_ADAPT_CONT_STATUS__ENABLE_MASK                                        0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_ADAPT_CONT_STATUS__RESERVED_15_1_MASK                                 0xFFFEL
//DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_UPCS_OCLA
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_UPCS_OCLA__DATA_EN__SHIFT                                             0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_UPCS_OCLA__CLK_EN__SHIFT                                              0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_UPCS_OCLA__RESERVED_15_4__SHIFT                                       0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_UPCS_OCLA__DATA_EN_MASK                                               0x0007L
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_UPCS_OCLA__CLK_EN_MASK                                                0x0008L
#define DPCSSYS_CR0_RAWLANE1_DIG_RX_CTL_UPCS_OCLA__RESERVED_15_4_MASK                                         0xFFF0L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__RATE_OVRD_VAL__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__RATE_OVRD_EN__SHIFT                                   0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__WIDTH_OVRD_VAL__SHIFT                                 0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__WIDTH_OVRD_EN__SHIFT                                  0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__PSTATE_OVRD_VAL__SHIFT                                0x6
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__PSTATE_OVRD_EN__SHIFT                                 0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__LPD_OVRD_VAL__SHIFT                                   0x9
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__LPD_OVRD_EN__SHIFT                                    0xa
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_VAL__SHIFT                  0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_EN__SHIFT                   0xc
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__RESERVED_15_13__SHIFT                                 0xd
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__RATE_OVRD_VAL_MASK                                    0x0003L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__RATE_OVRD_EN_MASK                                     0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__WIDTH_OVRD_VAL_MASK                                   0x0018L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__WIDTH_OVRD_EN_MASK                                    0x0020L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__PSTATE_OVRD_VAL_MASK                                  0x00C0L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__PSTATE_OVRD_EN_MASK                                   0x0100L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__LPD_OVRD_VAL_MASK                                     0x0200L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__LPD_OVRD_EN_MASK                                      0x0400L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_VAL_MASK                    0x0800L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_EN_MASK                     0x1000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN__RESERVED_15_13_MASK                                   0xE000L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__PSTATE__SHIFT                                         0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__LPD__SHIFT                                            0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__WIDTH__SHIFT                                          0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__RATE__SHIFT                                           0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__MPLLB_SEL__SHIFT                                      0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__MPLL_EN__SHIFT                                        0x9
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__OVRD_EN__SHIFT                                        0xa
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__MSTR_MPLLA_STATE__SHIFT                               0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__MSTR_MPLLB_STATE__SHIFT                               0xc
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__MSTR_MPLL_OVRD_EN__SHIFT                              0xd
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__TX_ASYNC_EN_OVR_VAL__SHIFT                            0xe
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__TX_ASYNC_EN_OVR_EN__SHIFT                             0xf
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__PSTATE_MASK                                           0x0003L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__LPD_MASK                                              0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__WIDTH_MASK                                            0x0018L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__RATE_MASK                                             0x00E0L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__MPLLB_SEL_MASK                                        0x0100L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__MPLL_EN_MASK                                          0x0200L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__OVRD_EN_MASK                                          0x0400L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__MSTR_MPLLA_STATE_MASK                                 0x0800L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__MSTR_MPLLB_STATE_MASK                                 0x1000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__MSTR_MPLL_OVRD_EN_MASK                                0x2000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__TX_ASYNC_EN_OVR_VAL_MASK                              0x4000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN__TX_ASYNC_EN_OVR_EN_MASK                               0x8000L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__DETRX_REQ_OVRD_VAL__SHIFT                           0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__DETRX_REQ_OVRD_EN__SHIFT                            0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__VBOOST_EN_OVRD_VAL__SHIFT                           0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__VBOOST_EN_OVRD_EN__SHIFT                            0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__IBOOST_LVL_OVRD_VAL__SHIFT                          0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__IBOOST_LVL_OVRD_EN__SHIFT                           0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__TX_BEACON_EN_OVR_VAL__SHIFT                         0x9
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__TX_BEACON_EN_OVR_EN__SHIFT                          0xa
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__LANE_TX2RX_SER_LB_EN_OVRD_VAL__SHIFT                0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__LANE_TX2RX_SER_LB_EN_OVRD_EN__SHIFT                 0xc
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__TX_ASYNC_DATA_OVRD_VAL__SHIFT                       0xd
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__TX_ASYNC_DATA_OVRD_EN__SHIFT                        0xe
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__RESERVED_15_15__SHIFT                               0xf
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__DETRX_REQ_OVRD_VAL_MASK                             0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__DETRX_REQ_OVRD_EN_MASK                              0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__VBOOST_EN_OVRD_VAL_MASK                             0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__VBOOST_EN_OVRD_EN_MASK                              0x0008L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__IBOOST_LVL_OVRD_VAL_MASK                            0x00F0L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__IBOOST_LVL_OVRD_EN_MASK                             0x0100L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__TX_BEACON_EN_OVR_VAL_MASK                           0x0200L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__TX_BEACON_EN_OVR_EN_MASK                            0x0400L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__LANE_TX2RX_SER_LB_EN_OVRD_VAL_MASK                  0x0800L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__LANE_TX2RX_SER_LB_EN_OVRD_EN_MASK                   0x1000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__TX_ASYNC_DATA_OVRD_VAL_MASK                         0x2000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__TX_ASYNC_DATA_OVRD_EN_MASK                          0x4000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_TX_OVRD_IN_1__RESERVED_15_15_MASK                                 0x8000L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_MASTER_MPLL_LOOP
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_MASTER_MPLL_LOOP__MPLLB_LOOP_EN__SHIFT                                0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_MASTER_MPLL_LOOP__MPLLA_LOOP_EN__SHIFT                                0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_MASTER_MPLL_LOOP__RESERVED_15_2__SHIFT                                0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_MASTER_MPLL_LOOP__MPLLB_LOOP_EN_MASK                                  0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_MASTER_MPLL_LOOP__MPLLA_LOOP_EN_MASK                                  0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_MASTER_MPLL_LOOP__RESERVED_15_2_MASK                                  0xFFFCL
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RESERVED__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RX_LOS_LFPS_EN_OVRD_VAL__SHIFT                      0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RX_LOS_LFPS_EN_OVRD_EN__SHIFT                       0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_VAL__SHIFT                      0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_EN__SHIFT                       0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__ADAPT_REQ__SHIFT                                    0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__ADAPT_REQ_OVRD_EN__SHIFT                            0x9
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__ADAPT_CONT__SHIFT                                   0xa
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__OFFCAN_CONT__SHIFT                                  0xb
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__CONT_OVRD_EN__SHIFT                                 0xc
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RESERVED_15_13__SHIFT                               0xd
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RESERVED_MASK                                       0x0003L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RX_LOS_LFPS_EN_OVRD_VAL_MASK                        0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RX_LOS_LFPS_EN_OVRD_EN_MASK                         0x0008L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_VAL_MASK                        0x0070L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_EN_MASK                         0x0080L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__ADAPT_REQ_MASK                                      0x0100L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__ADAPT_REQ_OVRD_EN_MASK                              0x0200L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__ADAPT_CONT_MASK                                     0x0400L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__OFFCAN_CONT_MASK                                    0x0800L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__CONT_OVRD_EN_MASK                                   0x1000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_1__RESERVED_15_13_MASK                                 0xE000L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_2__VCO_LD_VAL_OVRD__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_2__VCO_LD_VAL_OVRD_EN__SHIFT                           0xd
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD__SHIFT                         0xe
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD_EN__SHIFT                      0xf
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_2__VCO_LD_VAL_OVRD_MASK                                0x1FFFL
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_2__VCO_LD_VAL_OVRD_EN_MASK                             0x2000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD_MASK                           0x4000L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD_EN_MASK                        0x8000L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_3__REF_LD_VAL_OVRD__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_3__REF_LD_VAL_OVRD_EN__SHIFT                           0x7
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_3__RESERVED_15_8__SHIFT                                0x8
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_3__REF_LD_VAL_OVRD_MASK                                0x007FL
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_3__REF_LD_VAL_OVRD_EN_MASK                             0x0080L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_ATE_RX_OVRD_IN_3__RESERVED_15_8_MASK                                  0xFF00L
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT_2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT_2__RX_VALID__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT_2__RX_VALID_OVRD_EN__SHIFT                                0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT_2__RESERVED_15_2__SHIFT                                   0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT_2__RX_VALID_MASK                                          0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT_2__RX_VALID_OVRD_EN_MASK                                  0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_RX_OVRD_OUT_2__RESERVED_15_2_MASK                                     0xFFFCL
//DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_2__LANE_TX2RX_SER_LB_EN_OVRD_VAL__SHIFT                    0x0
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_2__LANE_TX2RX_SER_LB_EN_OVRD_EN__SHIFT                     0x1
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_2__TX_DATA_EN_OVRD_VAL_R__SHIFT                            0x2
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_2__TX_DATA_EN_OVRD_EN_R__SHIFT                             0x3
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_2__TX_ASYNC_DATA_OVRD_VAL_R__SHIFT                         0x4
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_2__TX_ASYNC_DATA_OVRD_EN_R__SHIFT                          0x5
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_2__RESERVED_15_6__SHIFT                                    0x6
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_2__LANE_TX2RX_SER_LB_EN_OVRD_VAL_MASK                      0x0001L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_2__LANE_TX2RX_SER_LB_EN_OVRD_EN_MASK                       0x0002L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_2__TX_DATA_EN_OVRD_VAL_R_MASK                              0x0004L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_2__TX_DATA_EN_OVRD_EN_R_MASK                               0x0008L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_2__TX_ASYNC_DATA_OVRD_VAL_R_MASK                           0x0010L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_2__TX_ASYNC_DATA_OVRD_EN_R_MASK                            0x0020L
#define DPCSSYS_CR0_RAWLANE1_DIG_PCS_XF_TX_OVRD_IN_2__RESERVED_15_6_MASK                                      0xFFC0L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__PSTATE__SHIFT                                             0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__LPD__SHIFT                                                0x2
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__WIDTH__SHIFT                                              0x3
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__RATE__SHIFT                                               0x5
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__MPLLB_SEL__SHIFT                                          0x8
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__MPLL_EN__SHIFT                                            0x9
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__OVRD_EN__SHIFT                                            0xa
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLLA_STATE__SHIFT                                   0xb
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLLB_STATE__SHIFT                                   0xc
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLL_OVRD_EN__SHIFT                                  0xd
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__TX_ASYNC_EN_OVR_VAL__SHIFT                                0xe
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__TX_ASYNC_EN_OVR_EN__SHIFT                                 0xf
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__PSTATE_MASK                                               0x0003L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__LPD_MASK                                                  0x0004L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__WIDTH_MASK                                                0x0018L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__RATE_MASK                                                 0x00E0L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__MPLLB_SEL_MASK                                            0x0100L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__MPLL_EN_MASK                                              0x0200L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__OVRD_EN_MASK                                              0x0400L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLLA_STATE_MASK                                     0x0800L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLLB_STATE_MASK                                     0x1000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__MSTR_MPLL_OVRD_EN_MASK                                    0x2000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__TX_ASYNC_EN_OVR_VAL_MASK                                  0x4000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN__TX_ASYNC_EN_OVR_EN_MASK                                   0x8000L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__RESET_OVRD_VAL__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__RESET_OVRD_EN__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__REQ_OVRD_VAL__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__REQ_OVRD_EN__SHIFT                                      0x3
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__DETRX_REQ_OVRD_VAL__SHIFT                               0x4
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__DETRX_REQ_OVRD_EN__SHIFT                                0x5
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__VBOOST_EN_OVRD_VAL__SHIFT                               0x6
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__VBOOST_EN_OVRD_EN__SHIFT                                0x7
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__IBOOST_LVL_OVRD_VAL__SHIFT                              0x8
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__IBOOST_LVL_OVRD_EN__SHIFT                               0xc
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__TX_BEACON_EN_OVR_VAL__SHIFT                             0xd
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__TX_BEACON_EN_OVR_EN__SHIFT                              0xe
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__RESERVED_15_15__SHIFT                                   0xf
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__RESET_OVRD_VAL_MASK                                     0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__RESET_OVRD_EN_MASK                                      0x0002L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__REQ_OVRD_VAL_MASK                                       0x0004L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__REQ_OVRD_EN_MASK                                        0x0008L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__DETRX_REQ_OVRD_VAL_MASK                                 0x0010L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__DETRX_REQ_OVRD_EN_MASK                                  0x0020L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__VBOOST_EN_OVRD_VAL_MASK                                 0x0040L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__VBOOST_EN_OVRD_EN_MASK                                  0x0080L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__IBOOST_LVL_OVRD_VAL_MASK                                0x0F00L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__IBOOST_LVL_OVRD_EN_MASK                                 0x1000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__TX_BEACON_EN_OVR_VAL_MASK                               0x2000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__TX_BEACON_EN_OVR_EN_MASK                                0x4000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_IN_1__RESERVED_15_15_MASK                                     0x8000L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__RESET__SHIFT                                               0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__REQ__SHIFT                                                 0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__PSTATE__SHIFT                                              0x2
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__LPD__SHIFT                                                 0x4
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__WIDTH__SHIFT                                               0x5
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__RATE__SHIFT                                                0x7
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__MPLLB_SEL__SHIFT                                           0xa
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__MPLL_EN__SHIFT                                             0xb
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__MSTR_MPLLA_STATE__SHIFT                                    0xc
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__MSTR_MPLLB_STATE__SHIFT                                    0xd
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__DETRX_REQ__SHIFT                                           0xe
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__RESERVED_15_15__SHIFT                                      0xf
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__RESET_MASK                                                 0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__REQ_MASK                                                   0x0002L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__PSTATE_MASK                                                0x000CL
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__LPD_MASK                                                   0x0010L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__WIDTH_MASK                                                 0x0060L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__RATE_MASK                                                  0x0380L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__MPLLB_SEL_MASK                                             0x0400L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__MPLL_EN_MASK                                               0x0800L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__MSTR_MPLLA_STATE_MASK                                      0x1000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__MSTR_MPLLB_STATE_MASK                                      0x2000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__DETRX_REQ_MASK                                             0x4000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_IN__RESERVED_15_15_MASK                                        0x8000L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_OUT
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_OUT__ACK__SHIFT                                               0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_OUT__DETRX_RESULT__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_OUT__EN_CTL__SHIFT                                            0x2
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_VAL__SHIFT                        0x3
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_EN__SHIFT                         0x4
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_OUT__RESERVED_15_5__SHIFT                                     0x5
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_OUT__ACK_MASK                                                 0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_OUT__DETRX_RESULT_MASK                                        0x0002L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_OUT__EN_CTL_MASK                                              0x0004L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_VAL_MASK                          0x0008L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_OUT__TX_DWORD_CLK_SYNC_OVRD_EN_MASK                           0x0010L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_OVRD_OUT__RESERVED_15_5_MASK                                       0xFFE0L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_OUT
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_OUT__ACK__SHIFT                                                0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_OUT__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_OUT__ACK_MASK                                                  0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TX_PCS_OUT__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__RATE__SHIFT                                               0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__WIDTH__SHIFT                                              0x2
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__PSTATE__SHIFT                                             0x4
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__LPD__SHIFT                                                0x6
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__OVRD_EN__SHIFT                                            0x7
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__ADAPT_AFE_EN__SHIFT                                       0x8
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__ADAPT_DFE_EN__SHIFT                                       0x9
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_VAL__SHIFT                      0xa
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_EN__SHIFT                       0xb
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__RX_DATA_EN_OVRD_VAL_R__SHIFT                              0xc
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__RX_DATA_EN_OVRD_EN_R__SHIFT                               0xd
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__RESERVED_15_14__SHIFT                                     0xe
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__RATE_MASK                                                 0x0003L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__WIDTH_MASK                                                0x000CL
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__PSTATE_MASK                                               0x0030L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__LPD_MASK                                                  0x0040L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__OVRD_EN_MASK                                              0x0080L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__ADAPT_AFE_EN_MASK                                         0x0100L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__ADAPT_DFE_EN_MASK                                         0x0200L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_VAL_MASK                        0x0400L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__LANE_RX2TX_PAR_LB_EN_OVRD_EN_MASK                         0x0800L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__RX_DATA_EN_OVRD_VAL_R_MASK                                0x1000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__RX_DATA_EN_OVRD_EN_R_MASK                                 0x2000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN__RESERVED_15_14_MASK                                       0xC000L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__RESET_OVRD_VAL__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__RESET_OVRD_EN__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__REQ_OVRD_VAL__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__REQ_OVRD_EN__SHIFT                                      0x3
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_VAL__SHIFT                          0x4
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_EN__SHIFT                           0x7
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_REQ__SHIFT                                        0x8
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_REQ_OVRD_EN__SHIFT                                0x9
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_CONT__SHIFT                                       0xa
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__OFFCAN_CONT__SHIFT                                      0xb
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__CONT_OVRD_EN__SHIFT                                     0xc
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__RESERVED_15_13__SHIFT                                   0xd
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__RESET_OVRD_VAL_MASK                                     0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__RESET_OVRD_EN_MASK                                      0x0002L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__REQ_OVRD_VAL_MASK                                       0x0004L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__REQ_OVRD_EN_MASK                                        0x0008L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_VAL_MASK                            0x0070L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__RX_LOS_THRSHLD_OVRD_EN_MASK                             0x0080L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_REQ_MASK                                          0x0100L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_REQ_OVRD_EN_MASK                                  0x0200L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__ADAPT_CONT_MASK                                         0x0400L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__OFFCAN_CONT_MASK                                        0x0800L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__CONT_OVRD_EN_MASK                                       0x1000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_1__RESERVED_15_13_MASK                                     0xE000L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_2
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LD_VAL_OVRD__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LD_VAL_OVRD_EN__SHIFT                               0xd
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD__SHIFT                             0xe
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD_EN__SHIFT                          0xf
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LD_VAL_OVRD_MASK                                    0x1FFFL
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LD_VAL_OVRD_EN_MASK                                 0x2000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD_MASK                               0x4000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_2__VCO_LOWFREQ_VAL_OVRD_EN_MASK                            0x8000L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_3
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_3__REF_LD_VAL_OVRD__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_3__REF_LD_VAL_OVRD_EN__SHIFT                               0x7
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_3__RESERVED_15_8__SHIFT                                    0x8
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_3__REF_LD_VAL_OVRD_MASK                                    0x007FL
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_3__REF_LD_VAL_OVRD_EN_MASK                                 0x0080L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_IN_3__RESERVED_15_8_MASK                                      0xFF00L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__REQ__SHIFT                                                 0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__RATE__SHIFT                                                0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__WIDTH__SHIFT                                               0x3
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__PSTATE__SHIFT                                              0x5
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__LPD__SHIFT                                                 0x7
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__CDR_VCO_LOWFREQ__SHIFT                                     0x8
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__ADAPT_AFE_EN__SHIFT                                        0x9
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__ADAPT_DFE_EN__SHIFT                                        0xa
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__ADAPT_REQ__SHIFT                                           0xb
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__ADAPT_CONT__SHIFT                                          0xc
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__OFFCAN_CONT__SHIFT                                         0xd
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__RESET__SHIFT                                               0xe
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__RESERVED_15_15__SHIFT                                      0xf
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__REQ_MASK                                                   0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__RATE_MASK                                                  0x0006L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__WIDTH_MASK                                                 0x0018L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__PSTATE_MASK                                                0x0060L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__LPD_MASK                                                   0x0080L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__CDR_VCO_LOWFREQ_MASK                                       0x0100L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__ADAPT_AFE_EN_MASK                                          0x0200L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__ADAPT_DFE_EN_MASK                                          0x0400L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__ADAPT_REQ_MASK                                             0x0800L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__ADAPT_CONT_MASK                                            0x1000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__OFFCAN_CONT_MASK                                           0x2000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__RESET_MASK                                                 0x4000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN__RESERVED_15_15_MASK                                        0x8000L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_1__REF_LD_VAL__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_1__RESERVED_15_7__SHIFT                                     0x7
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_1__REF_LD_VAL_MASK                                          0x007FL
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_1__RESERVED_15_7_MASK                                       0xFF80L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_2
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_2__VCO_LD_VAL__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_2__RESERVED_15_13__SHIFT                                    0xd
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_2__VCO_LD_VAL_MASK                                          0x1FFFL
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_2__RESERVED_15_13_MASK                                      0xE000L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_3
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_3__EQ_ATT_LVL__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_3__EQ_VGA1_GAIN__SHIFT                                      0x3
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_3__EQ_VGA2_GAIN__SHIFT                                      0x7
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_3__EQ_CTLE_BOOST__SHIFT                                     0xb
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_3__EQ_ATT_LVL_MASK                                          0x0007L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_3__EQ_VGA1_GAIN_MASK                                        0x0078L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_3__EQ_VGA2_GAIN_MASK                                        0x0780L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_3__EQ_CTLE_BOOST_MASK                                       0xF800L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_4
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_4__EQ_CTLE_POLE__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_4__EQ_DFE_TAP1__SHIFT                                       0x3
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_4__RESERVED_15_11__SHIFT                                    0xb
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_4__EQ_CTLE_POLE_MASK                                        0x0007L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_4__EQ_DFE_TAP1_MASK                                         0x07F8L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_IN_4__RESERVED_15_11_MASK                                      0xF800L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_OUT
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_OUT__ACK__SHIFT                                               0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_OUT__EN_CTL__SHIFT                                            0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_OUT__RESERVED_15_2__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_OUT__ACK_MASK                                                 0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_OUT__EN_CTL_MASK                                              0x0002L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_OUT__RESERVED_15_2_MASK                                       0xFFFCL
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_OUT
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_OUT__ACK__SHIFT                                                0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_OUT__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_OUT__ACK_MASK                                                  0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PCS_OUT__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_ADAPT_ACK
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_ADAPT_ACK__RX_ADAPT_ACK__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_ADAPT_ACK__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_ADAPT_ACK__RX_ADAPT_ACK_MASK                                       0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_ADAPT_ACK__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_ADAPT_FOM
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_ADAPT_FOM__RX_ADAPT_FOM__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_ADAPT_FOM__RESERVED_15_8__SHIFT                                    0x8
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_ADAPT_FOM__RX_ADAPT_FOM_MASK                                       0x00FFL
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_ADAPT_FOM__RESERVED_15_8_MASK                                      0xFF00L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_TXPRE_DIR
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_TXPRE_DIR__RX_TXPRE_DIR__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_TXPRE_DIR__RESERVED_15_2__SHIFT                                    0x2
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_TXPRE_DIR__RX_TXPRE_DIR_MASK                                       0x0003L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_TXPRE_DIR__RESERVED_15_2_MASK                                      0xFFFCL
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_TXMAIN_DIR
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_TXMAIN_DIR__RX_TXMAIN_DIR__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_TXMAIN_DIR__RESERVED_15_2__SHIFT                                   0x2
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_TXMAIN_DIR__RX_TXMAIN_DIR_MASK                                     0x0003L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_TXMAIN_DIR__RESERVED_15_2_MASK                                     0xFFFCL
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_TXPOST_DIR
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_TXPOST_DIR__RX_TXPOST_DIR__SHIFT                                   0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_TXPOST_DIR__RESERVED_15_2__SHIFT                                   0x2
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_TXPOST_DIR__RX_TXPOST_DIR_MASK                                     0x0003L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_TXPOST_DIR__RESERVED_15_2_MASK                                     0xFFFCL
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_LANE_NUMBER
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_LANE_NUMBER__LANE_NUMBER__SHIFT                                       0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_LANE_NUMBER__RESERVED_15_4__SHIFT                                     0x4
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_LANE_NUMBER__LANE_NUMBER_MASK                                         0x000FL
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_LANE_NUMBER__RESERVED_15_4_MASK                                       0xFFF0L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RESERVED_1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RESERVED_1__RESERVED_REG_1__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RESERVED_1__RESERVED_REG_1_MASK                                       0xFFFFL
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RESERVED_2
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RESERVED_2__RESERVED_REG_2__SHIFT                                     0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RESERVED_2__RESERVED_REG_2_MASK                                       0xFFFFL
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_RESET_ATE_OVRD_VAL__SHIFT                             0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_RESET_ATE_OVRD_EN__SHIFT                              0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__TX_RESET_ATE_OVRD_VAL__SHIFT                             0x2
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__TX_RESET_ATE_OVRD_EN__SHIFT                              0x3
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_REQ_ATE_OVRD_VAL__SHIFT                               0x4
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_REQ_ATE_OVRD_EN__SHIFT                                0x5
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__TX_REQ_ATE_OVRD_VAL__SHIFT                               0x6
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__TX_REQ_ATE_OVRD_EN__SHIFT                                0x7
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_AFE_EN_OVRD_VAL__SHIFT                          0x8
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_AFE_EN_OVRD_EN__SHIFT                           0x9
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_DFE_EN_OVRD_VAL__SHIFT                          0xa
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_DFE_EN_OVRD_EN__SHIFT                           0xb
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__TX_DATA_EN_ATE_OVRD_VAL__SHIFT                           0xc
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__TX_DATA_EN_ATE_OVRD_EN__SHIFT                            0xd
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_DATA_EN_ATE_OVRD_VAL__SHIFT                           0xe
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_DATA_EN_ATE_OVRD_EN__SHIFT                            0xf
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_RESET_ATE_OVRD_VAL_MASK                               0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_RESET_ATE_OVRD_EN_MASK                                0x0002L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__TX_RESET_ATE_OVRD_VAL_MASK                               0x0004L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__TX_RESET_ATE_OVRD_EN_MASK                                0x0008L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_REQ_ATE_OVRD_VAL_MASK                                 0x0010L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_REQ_ATE_OVRD_EN_MASK                                  0x0020L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__TX_REQ_ATE_OVRD_VAL_MASK                                 0x0040L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__TX_REQ_ATE_OVRD_EN_MASK                                  0x0080L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_AFE_EN_OVRD_VAL_MASK                            0x0100L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_AFE_EN_OVRD_EN_MASK                             0x0200L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_DFE_EN_OVRD_VAL_MASK                            0x0400L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_ADAPT_DFE_EN_OVRD_EN_MASK                             0x0800L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__TX_DATA_EN_ATE_OVRD_VAL_MASK                             0x1000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__TX_DATA_EN_ATE_OVRD_EN_MASK                              0x2000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_DATA_EN_ATE_OVRD_VAL_MASK                             0x4000L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_ATE_OVRD_IN__RX_DATA_EN_ATE_OVRD_EN_MASK                              0x8000L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RX_EQ_DELTA_IQ_OVRD_VAL__SHIFT                0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RX_EQ_DELTA_IQ_OVRD_EN__SHIFT                 0x4
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RESERVED_15_5__SHIFT                          0x5
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RX_EQ_DELTA_IQ_OVRD_VAL_MASK                  0x000FL
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RX_EQ_DELTA_IQ_OVRD_EN_MASK                   0x0010L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_DELTA_IQ_OVRD_IN__RESERVED_15_5_MASK                            0xFFE0L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RX_TERM_CTRL_OVRD_VAL__SHIFT                  0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RX_TERM_CTRL_OVRD_EN__SHIFT                   0x3
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__TX_TERM_CTRL_OVRD_VAL__SHIFT                  0x4
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__TX_TERM_CTRL_OVRD_EN__SHIFT                   0x7
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RESERVED_15_8__SHIFT                          0x8
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RX_TERM_CTRL_OVRD_VAL_MASK                    0x0007L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RX_TERM_CTRL_OVRD_EN_MASK                     0x0008L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__TX_TERM_CTRL_OVRD_VAL_MASK                    0x0070L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__TX_TERM_CTRL_OVRD_EN_MASK                     0x0080L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_OVRD_IN__RESERVED_15_8_MASK                            0xFF00L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_IN
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_IN__RX_TERM_CTRL__SHIFT                                0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_IN__TX_TERM_CTRL__SHIFT                                0x3
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_IN__RESERVED_15_6__SHIFT                               0x6
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_IN__RX_TERM_CTRL_MASK                                  0x0007L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_IN__TX_TERM_CTRL_MASK                                  0x0038L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_TXRX_TERM_CTRL_IN__RESERVED_15_6_MASK                                 0xFFC0L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_OUT_1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_OUT_1__RX_CLK_EN__SHIFT                                       0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_OUT_1__RESERVED_15_1__SHIFT                                   0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_OUT_1__RX_CLK_EN_MASK                                         0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_OVRD_OUT_1__RESERVED_15_1_MASK                                     0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_OVRD_IN_1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_AFE_GAIN_OVRD_VAL__SHIFT                       0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_ATT_LVL_OVRD_VAL__SHIFT                        0x4
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_OVRD_EN__SHIFT                                 0x7
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RESERVED_15_8__SHIFT                                 0x8
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_AFE_GAIN_OVRD_VAL_MASK                         0x000FL
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_ATT_LVL_OVRD_VAL_MASK                          0x0070L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RX_EQ_OVRD_EN_MASK                                   0x0080L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_OVRD_IN_1__RESERVED_15_8_MASK                                   0xFF00L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_OVRD_IN_2
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RX_EQ_DFE_TAP1_OVRD_VAL__SHIFT                       0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RX_EQ_CTLE_BOOST_OVRD_VAL__SHIFT                     0x8
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RESERVED_15_13__SHIFT                                0xd
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RX_EQ_DFE_TAP1_OVRD_VAL_MASK                         0x00FFL
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RX_EQ_CTLE_BOOST_OVRD_VAL_MASK                       0x1F00L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_EQ_OVRD_IN_2__RESERVED_15_13_MASK                                  0xE000L
//DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PH2_CAL
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_ACK_VAL__SHIFT                                    0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_REQ_VAL__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_REQ_OVRD_VAL__SHIFT                               0x2
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PH2_CAL__RESERVED_15_3__SHIFT                                      0x3
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_ACK_VAL_MASK                                      0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_REQ_VAL_MASK                                      0x0002L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PH2_CAL__PH2_CAL_REQ_OVRD_VAL_MASK                                 0x0004L
#define DPCSSYS_CR0_RAWLANE2_DIG_PCS_XF_RX_PH2_CAL__RESERVED_15_3_MASK                                        0xFFF8L
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FSM_OVRD_CTL
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FSM_OVRD_CTL__FSM_JMP_ADDR__SHIFT                                        0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FSM_OVRD_CTL__FSM_JMP_EN__SHIFT                                          0xc
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FSM_OVRD_CTL__FSM_CMD_START__SHIFT                                       0xd
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FSM_OVRD_CTL__FSM_OVRD_EN__SHIFT                                         0xe
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FSM_OVRD_CTL__FSM_BREAK__SHIFT                                           0xf
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FSM_OVRD_CTL__FSM_JMP_ADDR_MASK                                          0x0FFFL
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FSM_OVRD_CTL__FSM_JMP_EN_MASK                                            0x1000L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FSM_OVRD_CTL__FSM_CMD_START_MASK                                         0x2000L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FSM_OVRD_CTL__FSM_OVRD_EN_MASK                                           0x4000L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FSM_OVRD_CTL__FSM_BREAK_MASK                                             0x8000L
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_MEM_ADDR_MON
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_MEM_ADDR_MON__MEM_ADDR__SHIFT                                            0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_MEM_ADDR_MON__MEM_ADDR_MASK                                              0xFFFFL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_STATUS_MON
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_STATUS_MON__STATE__SHIFT                                                 0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_STATUS_MON__CMD_RDY__SHIFT                                               0x5
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_STATUS_MON__ALU_OVFLW__SHIFT                                             0x6
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_STATUS_MON__ALU_RES_EQ0__SHIFT                                           0x7
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_STATUS_MON__WAIT_CNT_EQ0__SHIFT                                          0x8
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_STATUS_MON__WRMSK_DISABLED__SHIFT                                        0x9
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_STATUS_MON__RDMSK_DISABLED__SHIFT                                        0xa
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_STATUS_MON__RESERVED_15_11__SHIFT                                        0xb
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_STATUS_MON__STATE_MASK                                                   0x001FL
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_STATUS_MON__CMD_RDY_MASK                                                 0x0020L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_STATUS_MON__ALU_OVFLW_MASK                                               0x0040L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_STATUS_MON__ALU_RES_EQ0_MASK                                             0x0080L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_STATUS_MON__WAIT_CNT_EQ0_MASK                                            0x0100L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_STATUS_MON__WRMSK_DISABLED_MASK                                          0x0200L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_STATUS_MON__RDMSK_DISABLED_MASK                                          0x0400L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_STATUS_MON__RESERVED_15_11_MASK                                          0xF800L
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_STARTUP_CAL
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_STARTUP_CAL__FAST_RX_STARTUP_CAL__SHIFT                          0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_STARTUP_CAL__RESERVED_15_1__SHIFT                                0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_STARTUP_CAL__FAST_RX_STARTUP_CAL_MASK                            0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_STARTUP_CAL__RESERVED_15_1_MASK                                  0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_ADAPT
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_ADAPT__FAST_RX_ADAPT__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_ADAPT__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_ADAPT__FAST_RX_ADAPT_MASK                                        0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_ADAPT__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_AFE_CAL
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_AFE_CAL__FAST_RX_AFE_CAL__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_AFE_CAL__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_AFE_CAL__FAST_RX_AFE_CAL_MASK                                    0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_AFE_CAL__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_DFE_CAL
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_DFE_CAL__FAST_RX_DFE_CAL__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_DFE_CAL__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_DFE_CAL__FAST_RX_DFE_CAL_MASK                                    0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_DFE_CAL__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_BYPASS_CAL
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_BYPASS_CAL__FAST_RX_BYPASS_CAL__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_BYPASS_CAL__RESERVED_15_1__SHIFT                                 0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_BYPASS_CAL__FAST_RX_BYPASS_CAL_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_BYPASS_CAL__RESERVED_15_1_MASK                                   0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_REFLVL_CAL
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_REFLVL_CAL__FAST_RX_REFLVL_CAL__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_REFLVL_CAL__RESERVED_15_1__SHIFT                                 0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_REFLVL_CAL__FAST_RX_REFLVL_CAL_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_REFLVL_CAL__RESERVED_15_1_MASK                                   0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_IQ_CAL
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_IQ_CAL__FAST_RX_IQ_CAL__SHIFT                                    0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_IQ_CAL__RESERVED_15_1__SHIFT                                     0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_IQ_CAL__FAST_RX_IQ_CAL_MASK                                      0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_IQ_CAL__RESERVED_15_1_MASK                                       0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_AFE_ADAPT
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_AFE_ADAPT__FAST_RX_AFE_ADAPT__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_AFE_ADAPT__RESERVED_15_1__SHIFT                                  0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_AFE_ADAPT__FAST_RX_AFE_ADAPT_MASK                                0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_AFE_ADAPT__RESERVED_15_1_MASK                                    0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_DFE_ADAPT
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_DFE_ADAPT__FAST_RX_DFE_ADAPT__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_DFE_ADAPT__RESERVED_15_1__SHIFT                                  0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_DFE_ADAPT__FAST_RX_DFE_ADAPT_MASK                                0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_DFE_ADAPT__RESERVED_15_1_MASK                                    0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_SUP
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_SUP__FAST_SUP__SHIFT                                                0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_SUP__RESERVED_15_1__SHIFT                                           0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_SUP__FAST_SUP_MASK                                                  0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_SUP__RESERVED_15_1_MASK                                             0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_TX_CMN_MODE
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_TX_CMN_MODE__FAST_TX_CMN_MODE__SHIFT                                0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_TX_CMN_MODE__RESERVED_15_1__SHIFT                                   0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_TX_CMN_MODE__FAST_TX_CMN_MODE_MASK                                  0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_TX_CMN_MODE__RESERVED_15_1_MASK                                     0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_TX_RXDET
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_TX_RXDET__FAST_TX_RXDET__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_TX_RXDET__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_TX_RXDET__FAST_TX_RXDET_MASK                                        0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_TX_RXDET__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_PWRUP
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_PWRUP__FAST_RX_PWRUP__SHIFT                                      0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_PWRUP__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_PWRUP__FAST_RX_PWRUP_MASK                                        0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_PWRUP__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_VCO_WAIT
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_VCO_WAIT__FAST_RX_VCO_WAIT__SHIFT                                0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_VCO_WAIT__RESERVED_15_1__SHIFT                                   0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_VCO_WAIT__FAST_RX_VCO_WAIT_MASK                                  0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_VCO_WAIT__RESERVED_15_1_MASK                                     0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_VCO_CAL
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_VCO_CAL__FAST_RX_VCO_CAL__SHIFT                                  0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_VCO_CAL__RESERVED_15_1__SHIFT                                    0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_VCO_CAL__FAST_RX_VCO_CAL_MASK                                    0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_VCO_CAL__RESERVED_15_1_MASK                                      0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_CMNCAL_MPLL_STATUS
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_CMNCAL_MPLL_STATUS__CMNCAL_MPLL_INIT__SHIFT                              0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_CMNCAL_MPLL_STATUS__CMNCAL_MPLL_DONE__SHIFT                              0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_CMNCAL_MPLL_STATUS__RESERVED_15_2__SHIFT                                 0x2
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_CMNCAL_MPLL_STATUS__CMNCAL_MPLL_INIT_MASK                                0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_CMNCAL_MPLL_STATUS__CMNCAL_MPLL_DONE_MASK                                0x0002L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_CMNCAL_MPLL_STATUS__RESERVED_15_2_MASK                                   0xFFFCL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_CAL_ADAPT
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_CAL_ADAPT__FAST_RX_CONT_CAL_ADAPT__SHIFT                    0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_CAL_ADAPT__RESERVED_15_1__SHIFT                             0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_CAL_ADAPT__FAST_RX_CONT_CAL_ADAPT_MASK                      0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_CAL_ADAPT__RESERVED_15_1_MASK                               0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_ADAPT
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_ADAPT__FAST_RX_CONT_ADAPT__SHIFT                            0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_ADAPT__RESERVED_15_1__SHIFT                                 0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_ADAPT__FAST_RX_CONT_ADAPT_MASK                              0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_ADAPT__RESERVED_15_1_MASK                                   0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_DATA_CAL
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_DATA_CAL__FAST_RX_CONT_DATA_CAL__SHIFT                      0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_DATA_CAL__RESERVED_15_1__SHIFT                              0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_DATA_CAL__FAST_RX_CONT_DATA_CAL_MASK                        0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_DATA_CAL__RESERVED_15_1_MASK                                0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_PHASE_CAL
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_PHASE_CAL__FAST_RX_CONT_PHASE_CAL__SHIFT                    0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_PHASE_CAL__RESERVED_15_1__SHIFT                             0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_PHASE_CAL__FAST_RX_CONT_PHASE_CAL_MASK                      0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_PHASE_CAL__RESERVED_15_1_MASK                               0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_AFE_CAL
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_AFE_CAL__FAST_RX_CONT_AFE_CAL__SHIFT                        0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_AFE_CAL__RESERVED_15_1__SHIFT                               0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_AFE_CAL__FAST_RX_CONT_AFE_CAL_MASK                          0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_RX_CONT_AFE_CAL__RESERVED_15_1_MASK                                 0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__TX_FAST_DCC_CAL__SHIFT                                       0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RX_FAST_DCC_CAL__SHIFT                                       0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RX_FAST_VPHUD_CAL__SHIFT                                     0x2
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RX_FAST_VREF_CAL__SHIFT                                      0x3
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RX_FAST_SIGDET_CAL__SHIFT                                    0x4
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RESERVED_2__SHIFT                                            0x5
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__TX_FAST_CONT_DCC_CAL__SHIFT                                  0x8
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_DCC_CAL__SHIFT                                  0x9
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_VPHUD_CAL__SHIFT                                0xa
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_VREF_CAL__SHIFT                                 0xb
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RESERVED_1__SHIFT                                            0xc
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__TX_SKIP_SUP_CAL__SHIFT                                       0xf
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__TX_FAST_DCC_CAL_MASK                                         0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RX_FAST_DCC_CAL_MASK                                         0x0002L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RX_FAST_VPHUD_CAL_MASK                                       0x0004L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RX_FAST_VREF_CAL_MASK                                        0x0008L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RX_FAST_SIGDET_CAL_MASK                                      0x0010L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RESERVED_2_MASK                                              0x00E0L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__TX_FAST_CONT_DCC_CAL_MASK                                    0x0100L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_DCC_CAL_MASK                                    0x0200L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_VPHUD_CAL_MASK                                  0x0400L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RX_FAST_CONT_VREF_CAL_MASK                                   0x0800L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__RESERVED_1_MASK                                              0x7000L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_FAST_FLAGS__TX_SKIP_SUP_CAL_MASK                                         0x8000L
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_CR_LOCK
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_CR_LOCK__CR_REG_LOCK__SHIFT                                              0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_CR_LOCK__CR_MEM_LOCK__SHIFT                                              0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_CR_LOCK__RESERVED_15_2__SHIFT                                            0x2
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_CR_LOCK__CR_REG_LOCK_MASK                                                0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_CR_LOCK__CR_MEM_LOCK_MASK                                                0x0002L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_CR_LOCK__RESERVED_15_2_MASK                                              0xFFFCL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_TX_DCC_FLAGS
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_TX_DCC_FLAGS__RATE__SHIFT                                                0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_TX_DCC_FLAGS__DIV__SHIFT                                                 0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_TX_DCC_FLAGS__MPLL__SHIFT                                                0x2
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_TX_DCC_FLAGS__RESERVED_15_3__SHIFT                                       0x3
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_TX_DCC_FLAGS__RATE_MASK                                                  0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_TX_DCC_FLAGS__DIV_MASK                                                   0x0002L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_TX_DCC_FLAGS__MPLL_MASK                                                  0x0004L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_TX_DCC_FLAGS__RESERVED_15_3_MASK                                         0xFFF8L
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_TX_DCC_STATUS
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_TX_DCC_STATUS__FLAG__SHIFT                                               0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_TX_DCC_STATUS__RESERVED_15_1__SHIFT                                      0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_TX_DCC_STATUS__FLAG_MASK                                                 0x0001L
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_TX_DCC_STATUS__RESERVED_15_1_MASK                                        0xFFFEL
//DPCSSYS_CR0_RAWLANE2_DIG_FSM_OCLA
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_OCLA__PC_EN__SHIFT                                                       0x0
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_OCLA__REG_BANK1_EN__SHIFT                                                0x1
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_OCLA__REG_BANK2_EN__SHIFT                                                0x2
#define DPCSSYS_CR0_RAWLANE2_DIG_FSM_OCL