// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: internal/protocol/commands.proto

/*
	Package protocol is a generated protocol buffer package.

	It is generated from these files:
		internal/protocol/commands.proto

	It has these top-level messages:
		Command
		Open
		Begin
		Frames
		FramesPage
		Undo
		End
		Checkpoint
*/
package protocol

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Command encapsulates the payload fo a dqlite Raft FSM command.
//
// On the wire this will be a varint indentifying the command type,
// followed by the command payload.
type Command struct {
	// Types that are valid to be assigned to Payload:
	//	*Command_Open
	//	*Command_Begin
	//	*Command_Frames
	//	*Command_Undo
	//	*Command_End
	//	*Command_Checkpoint
	Payload isCommand_Payload `protobuf_oneof:"Payload"`
}

func (m *Command) Reset()                    { *m = Command{} }
func (m *Command) String() string            { return proto.CompactTextString(m) }
func (*Command) ProtoMessage()               {}
func (*Command) Descriptor() ([]byte, []int) { return fileDescriptorCommands, []int{0} }

type isCommand_Payload interface {
	isCommand_Payload()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Command_Open struct {
	Open *Open `protobuf:"bytes,1,opt,name=open,oneof"`
}
type Command_Begin struct {
	Begin *Begin `protobuf:"bytes,2,opt,name=begin,oneof"`
}
type Command_Frames struct {
	Frames *Frames `protobuf:"bytes,3,opt,name=frames,oneof"`
}
type Command_Undo struct {
	Undo *Undo `protobuf:"bytes,4,opt,name=undo,oneof"`
}
type Command_End struct {
	End *End `protobuf:"bytes,5,opt,name=end,oneof"`
}
type Command_Checkpoint struct {
	Checkpoint *Checkpoint `protobuf:"bytes,6,opt,name=checkpoint,oneof"`
}

func (*Command_Open) isCommand_Payload()       {}
func (*Command_Begin) isCommand_Payload()      {}
func (*Command_Frames) isCommand_Payload()     {}
func (*Command_Undo) isCommand_Payload()       {}
func (*Command_End) isCommand_Payload()        {}
func (*Command_Checkpoint) isCommand_Payload() {}

func (m *Command) GetPayload() isCommand_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *Command) GetOpen() *Open {
	if x, ok := m.GetPayload().(*Command_Open); ok {
		return x.Open
	}
	return nil
}

func (m *Command) GetBegin() *Begin {
	if x, ok := m.GetPayload().(*Command_Begin); ok {
		return x.Begin
	}
	return nil
}

func (m *Command) GetFrames() *Frames {
	if x, ok := m.GetPayload().(*Command_Frames); ok {
		return x.Frames
	}
	return nil
}

func (m *Command) GetUndo() *Undo {
	if x, ok := m.GetPayload().(*Command_Undo); ok {
		return x.Undo
	}
	return nil
}

func (m *Command) GetEnd() *End {
	if x, ok := m.GetPayload().(*Command_End); ok {
		return x.End
	}
	return nil
}

func (m *Command) GetCheckpoint() *Checkpoint {
	if x, ok := m.GetPayload().(*Command_Checkpoint); ok {
		return x.Checkpoint
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Command) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Command_OneofMarshaler, _Command_OneofUnmarshaler, _Command_OneofSizer, []interface{}{
		(*Command_Open)(nil),
		(*Command_Begin)(nil),
		(*Command_Frames)(nil),
		(*Command_Undo)(nil),
		(*Command_End)(nil),
		(*Command_Checkpoint)(nil),
	}
}

func _Command_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Command)
	// Payload
	switch x := m.Payload.(type) {
	case *Command_Open:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Open); err != nil {
			return err
		}
	case *Command_Begin:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Begin); err != nil {
			return err
		}
	case *Command_Frames:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Frames); err != nil {
			return err
		}
	case *Command_Undo:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Undo); err != nil {
			return err
		}
	case *Command_End:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.End); err != nil {
			return err
		}
	case *Command_Checkpoint:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Checkpoint); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Command.Payload has unexpected type %T", x)
	}
	return nil
}

func _Command_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Command)
	switch tag {
	case 1: // Payload.open
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Open)
		err := b.DecodeMessage(msg)
		m.Payload = &Command_Open{msg}
		return true, err
	case 2: // Payload.begin
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Begin)
		err := b.DecodeMessage(msg)
		m.Payload = &Command_Begin{msg}
		return true, err
	case 3: // Payload.frames
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Frames)
		err := b.DecodeMessage(msg)
		m.Payload = &Command_Frames{msg}
		return true, err
	case 4: // Payload.undo
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Undo)
		err := b.DecodeMessage(msg)
		m.Payload = &Command_Undo{msg}
		return true, err
	case 5: // Payload.end
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(End)
		err := b.DecodeMessage(msg)
		m.Payload = &Command_End{msg}
		return true, err
	case 6: // Payload.checkpoint
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Checkpoint)
		err := b.DecodeMessage(msg)
		m.Payload = &Command_Checkpoint{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Command_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Command)
	// Payload
	switch x := m.Payload.(type) {
	case *Command_Open:
		s := proto.Size(x.Open)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Command_Begin:
		s := proto.Size(x.Begin)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Command_Frames:
		s := proto.Size(x.Frames)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Command_Undo:
		s := proto.Size(x.Undo)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Command_End:
		s := proto.Size(x.End)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Command_Checkpoint:
		s := proto.Size(x.Checkpoint)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Parameters to open a new database and setup the needed data
// structures for replication.
type Open struct {
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *Open) Reset()                    { *m = Open{} }
func (m *Open) String() string            { return proto.CompactTextString(m) }
func (*Open) ProtoMessage()               {}
func (*Open) Descriptor() ([]byte, []int) { return fileDescriptorCommands, []int{1} }

func (m *Open) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Parameters to begin a new write transaction.
//
// This command is not used anymore, but it's
// kept for backward-compatibility.
type Begin struct {
	Txid uint64 `protobuf:"varint,1,opt,name=txid,proto3" json:"txid,omitempty"`
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *Begin) Reset()                    { *m = Begin{} }
func (m *Begin) String() string            { return proto.CompactTextString(m) }
func (*Begin) ProtoMessage()               {}
func (*Begin) Descriptor() ([]byte, []int) { return fileDescriptorCommands, []int{2} }

func (m *Begin) GetTxid() uint64 {
	if m != nil {
		return m.Txid
	}
	return 0
}

func (m *Begin) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Parameters to append new frames to the WAL within a write transaction.
type Frames struct {
	Txid      uint64        `protobuf:"varint,1,opt,name=txid,proto3" json:"txid,omitempty"`
	PageSize  int32         `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	Pages     []*FramesPage `protobuf:"bytes,3,rep,name=pages" json:"pages,omitempty"`
	Truncate  uint32        `protobuf:"varint,4,opt,name=truncate,proto3" json:"truncate,omitempty"`
	IsCommit  int32         `protobuf:"varint,5,opt,name=is_commit,json=isCommit,proto3" json:"is_commit,omitempty"`
	SyncFlags uint32        `protobuf:"varint,6,opt,name=sync_flags,json=syncFlags,proto3" json:"sync_flags,omitempty"`
	Filename  string        `protobuf:"bytes,7,opt,name=filename,proto3" json:"filename,omitempty"`
}

func (m *Frames) Reset()                    { *m = Frames{} }
func (m *Frames) String() string            { return proto.CompactTextString(m) }
func (*Frames) ProtoMessage()               {}
func (*Frames) Descriptor() ([]byte, []int) { return fileDescriptorCommands, []int{3} }

func (m *Frames) GetTxid() uint64 {
	if m != nil {
		return m.Txid
	}
	return 0
}

func (m *Frames) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *Frames) GetPages() []*FramesPage {
	if m != nil {
		return m.Pages
	}
	return nil
}

func (m *Frames) GetTruncate() uint32 {
	if m != nil {
		return m.Truncate
	}
	return 0
}

func (m *Frames) GetIsCommit() int32 {
	if m != nil {
		return m.IsCommit
	}
	return 0
}

func (m *Frames) GetSyncFlags() uint32 {
	if m != nil {
		return m.SyncFlags
	}
	return 0
}

func (m *Frames) GetFilename() string {
	if m != nil {
		return m.Filename
	}
	return ""
}

// A single frame of data in a Frames command.
type FramesPage struct {
	Data   []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	Flags  uint32 `protobuf:"varint,2,opt,name=flags,proto3" json:"flags,omitempty"`
	Number uint32 `protobuf:"varint,3,opt,name=number,proto3" json:"number,omitempty"`
}

func (m *FramesPage) Reset()                    { *m = FramesPage{} }
func (m *FramesPage) String() string            { return proto.CompactTextString(m) }
func (*FramesPage) ProtoMessage()               {}
func (*FramesPage) Descriptor() ([]byte, []int) { return fileDescriptorCommands, []int{4} }

func (m *FramesPage) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *FramesPage) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *FramesPage) GetNumber() uint32 {
	if m != nil {
		return m.Number
	}
	return 0
}

// Parameters to undo any previous WAL change in a write transaction.
type Undo struct {
	Txid uint64 `protobuf:"varint,1,opt,name=txid,proto3" json:"txid,omitempty"`
}

func (m *Undo) Reset()                    { *m = Undo{} }
func (m *Undo) String() string            { return proto.CompactTextString(m) }
func (*Undo) ProtoMessage()               {}
func (*Undo) Descriptor() ([]byte, []int) { return fileDescriptorCommands, []int{5} }

func (m *Undo) GetTxid() uint64 {
	if m != nil {
		return m.Txid
	}
	return 0
}

// Parameters to end a write transaction, and update the WAL commit
// pointer.
//
// This command is not used anymore, but it's
// kept for backward-compatibility.
type End struct {
	Txid uint64 `protobuf:"varint,1,opt,name=txid,proto3" json:"txid,omitempty"`
}

func (m *End) Reset()                    { *m = End{} }
func (m *End) String() string            { return proto.CompactTextString(m) }
func (*End) ProtoMessage()               {}
func (*End) Descriptor() ([]byte, []int) { return fileDescriptorCommands, []int{6} }

func (m *End) GetTxid() uint64 {
	if m != nil {
		return m.Txid
	}
	return 0
}

// Parameters to perform a WAL checkpoint.
type Checkpoint struct {
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *Checkpoint) Reset()                    { *m = Checkpoint{} }
func (m *Checkpoint) String() string            { return proto.CompactTextString(m) }
func (*Checkpoint) ProtoMessage()               {}
func (*Checkpoint) Descriptor() ([]byte, []int) { return fileDescriptorCommands, []int{7} }

func (m *Checkpoint) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterType((*Command)(nil), "protocol.Command")
	proto.RegisterType((*Open)(nil), "protocol.Open")
	proto.RegisterType((*Begin)(nil), "protocol.Begin")
	proto.RegisterType((*Frames)(nil), "protocol.Frames")
	proto.RegisterType((*FramesPage)(nil), "protocol.FramesPage")
	proto.RegisterType((*Undo)(nil), "protocol.Undo")
	proto.RegisterType((*End)(nil), "protocol.End")
	proto.RegisterType((*Checkpoint)(nil), "protocol.Checkpoint")
}
func (m *Command) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Command) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Payload != nil {
		nn1, err := m.Payload.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	return i, nil
}

func (m *Command_Open) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Open != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCommands(dAtA, i, uint64(m.Open.Size()))
		n2, err := m.Open.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}
func (m *Command_Begin) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Begin != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCommands(dAtA, i, uint64(m.Begin.Size()))
		n3, err := m.Begin.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *Command_Frames) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Frames != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCommands(dAtA, i, uint64(m.Frames.Size()))
		n4, err := m.Frames.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}
func (m *Command_Undo) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Undo != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintCommands(dAtA, i, uint64(m.Undo.Size()))
		n5, err := m.Undo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *Command_End) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.End != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintCommands(dAtA, i, uint64(m.End.Size()))
		n6, err := m.End.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}
func (m *Command_Checkpoint) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Checkpoint != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintCommands(dAtA, i, uint64(m.Checkpoint.Size()))
		n7, err := m.Checkpoint.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}
func (m *Open) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Open) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCommands(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	return i, nil
}

func (m *Begin) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Begin) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Txid != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintCommands(dAtA, i, uint64(m.Txid))
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCommands(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	return i, nil
}

func (m *Frames) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Frames) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Txid != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintCommands(dAtA, i, uint64(m.Txid))
	}
	if m.PageSize != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintCommands(dAtA, i, uint64(m.PageSize))
	}
	if len(m.Pages) > 0 {
		for _, msg := range m.Pages {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintCommands(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Truncate != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintCommands(dAtA, i, uint64(m.Truncate))
	}
	if m.IsCommit != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintCommands(dAtA, i, uint64(m.IsCommit))
	}
	if m.SyncFlags != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintCommands(dAtA, i, uint64(m.SyncFlags))
	}
	if len(m.Filename) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintCommands(dAtA, i, uint64(len(m.Filename)))
		i += copy(dAtA[i:], m.Filename)
	}
	return i, nil
}

func (m *FramesPage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FramesPage) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Data) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCommands(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	if m.Flags != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintCommands(dAtA, i, uint64(m.Flags))
	}
	if m.Number != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintCommands(dAtA, i, uint64(m.Number))
	}
	return i, nil
}

func (m *Undo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Undo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Txid != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintCommands(dAtA, i, uint64(m.Txid))
	}
	return i, nil
}

func (m *End) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *End) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Txid != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintCommands(dAtA, i, uint64(m.Txid))
	}
	return i, nil
}

func (m *Checkpoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Checkpoint) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCommands(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	return i, nil
}

func encodeVarintCommands(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Command) Size() (n int) {
	var l int
	_ = l
	if m.Payload != nil {
		n += m.Payload.Size()
	}
	return n
}

func (m *Command_Open) Size() (n int) {
	var l int
	_ = l
	if m.Open != nil {
		l = m.Open.Size()
		n += 1 + l + sovCommands(uint64(l))
	}
	return n
}
func (m *Command_Begin) Size() (n int) {
	var l int
	_ = l
	if m.Begin != nil {
		l = m.Begin.Size()
		n += 1 + l + sovCommands(uint64(l))
	}
	return n
}
func (m *Command_Frames) Size() (n int) {
	var l int
	_ = l
	if m.Frames != nil {
		l = m.Frames.Size()
		n += 1 + l + sovCommands(uint64(l))
	}
	return n
}
func (m *Command_Undo) Size() (n int) {
	var l int
	_ = l
	if m.Undo != nil {
		l = m.Undo.Size()
		n += 1 + l + sovCommands(uint64(l))
	}
	return n
}
func (m *Command_End) Size() (n int) {
	var l int
	_ = l
	if m.End != nil {
		l = m.End.Size()
		n += 1 + l + sovCommands(uint64(l))
	}
	return n
}
func (m *Command_Checkpoint) Size() (n int) {
	var l int
	_ = l
	if m.Checkpoint != nil {
		l = m.Checkpoint.Size()
		n += 1 + l + sovCommands(uint64(l))
	}
	return n
}
func (m *Open) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCommands(uint64(l))
	}
	return n
}

func (m *Begin) Size() (n int) {
	var l int
	_ = l
	if m.Txid != 0 {
		n += 1 + sovCommands(uint64(m.Txid))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCommands(uint64(l))
	}
	return n
}

func (m *Frames) Size() (n int) {
	var l int
	_ = l
	if m.Txid != 0 {
		n += 1 + sovCommands(uint64(m.Txid))
	}
	if m.PageSize != 0 {
		n += 1 + sovCommands(uint64(m.PageSize))
	}
	if len(m.Pages) > 0 {
		for _, e := range m.Pages {
			l = e.Size()
			n += 1 + l + sovCommands(uint64(l))
		}
	}
	if m.Truncate != 0 {
		n += 1 + sovCommands(uint64(m.Truncate))
	}
	if m.IsCommit != 0 {
		n += 1 + sovCommands(uint64(m.IsCommit))
	}
	if m.SyncFlags != 0 {
		n += 1 + sovCommands(uint64(m.SyncFlags))
	}
	l = len(m.Filename)
	if l > 0 {
		n += 1 + l + sovCommands(uint64(l))
	}
	return n
}

func (m *FramesPage) Size() (n int) {
	var l int
	_ = l
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovCommands(uint64(l))
	}
	if m.Flags != 0 {
		n += 1 + sovCommands(uint64(m.Flags))
	}
	if m.Number != 0 {
		n += 1 + sovCommands(uint64(m.Number))
	}
	return n
}

func (m *Undo) Size() (n int) {
	var l int
	_ = l
	if m.Txid != 0 {
		n += 1 + sovCommands(uint64(m.Txid))
	}
	return n
}

func (m *End) Size() (n int) {
	var l int
	_ = l
	if m.Txid != 0 {
		n += 1 + sovCommands(uint64(m.Txid))
	}
	return n
}

func (m *Checkpoint) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCommands(uint64(l))
	}
	return n
}

func sovCommands(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozCommands(x uint64) (n int) {
	return sovCommands(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Command) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommands
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Command: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Command: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Open", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommands
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Open{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &Command_Open{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Begin", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommands
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Begin{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &Command_Begin{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Frames", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommands
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Frames{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &Command_Frames{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Undo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommands
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Undo{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &Command_Undo{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommands
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &End{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &Command_End{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checkpoint", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommands
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Checkpoint{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Payload = &Command_Checkpoint{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCommands(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCommands
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Open) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommands
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Open: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Open: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCommands
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCommands(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCommands
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Begin) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommands
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Begin: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Begin: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txid", wireType)
			}
			m.Txid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Txid |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCommands
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCommands(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCommands
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Frames) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommands
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Frames: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Frames: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txid", wireType)
			}
			m.Txid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Txid |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PageSize", wireType)
			}
			m.PageSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PageSize |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pages", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCommands
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pages = append(m.Pages, &FramesPage{})
			if err := m.Pages[len(m.Pages)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Truncate", wireType)
			}
			m.Truncate = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Truncate |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsCommit", wireType)
			}
			m.IsCommit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IsCommit |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SyncFlags", wireType)
			}
			m.SyncFlags = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SyncFlags |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filename", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCommands
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filename = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCommands(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCommands
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FramesPage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommands
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FramesPage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FramesPage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthCommands
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			m.Flags = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Flags |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Number", wireType)
			}
			m.Number = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Number |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCommands(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCommands
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Undo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommands
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Undo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Undo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txid", wireType)
			}
			m.Txid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Txid |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCommands(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCommands
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *End) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommands
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: End: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: End: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txid", wireType)
			}
			m.Txid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Txid |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCommands(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCommands
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Checkpoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCommands
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Checkpoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Checkpoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCommands
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCommands(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCommands
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCommands(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCommands
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCommands
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthCommands
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowCommands
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipCommands(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthCommands = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCommands   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("internal/protocol/commands.proto", fileDescriptorCommands) }

var fileDescriptorCommands = []byte{
	// 451 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x52, 0xc1, 0x6e, 0xd3, 0x40,
	0x10, 0xb5, 0x13, 0xdb, 0x49, 0x06, 0x02, 0xd5, 0xaa, 0x42, 0xa6, 0x88, 0x28, 0x58, 0x48, 0xa0,
	0x1e, 0x12, 0x09, 0x24, 0x3e, 0x20, 0x51, 0x2b, 0x9f, 0xa0, 0x5a, 0xc4, 0x39, 0xda, 0x78, 0x37,
	0x61, 0x85, 0x3d, 0x6b, 0xd9, 0x8e, 0x44, 0xfb, 0x15, 0x1c, 0xf9, 0x24, 0x8e, 0x5c, 0xb9, 0xa1,
	0xf0, 0x23, 0x68, 0xc6, 0x6d, 0x5c, 0x50, 0x6e, 0x33, 0xef, 0xbd, 0x99, 0xf1, 0x7b, 0x6b, 0x98,
	0x5a, 0x6c, 0x4c, 0x85, 0x2a, 0x9f, 0x97, 0x95, 0x6b, 0x5c, 0xe6, 0xf2, 0x79, 0xe6, 0x8a, 0x42,
	0xa1, 0xae, 0x67, 0x8c, 0x88, 0xe1, 0x1d, 0x91, 0x7c, 0xeb, 0xc1, 0x60, 0xd9, 0x92, 0xe2, 0x25,
	0x04, 0xae, 0x34, 0x18, 0xfb, 0x53, 0xff, 0xf5, 0x83, 0x37, 0x8f, 0x66, 0x77, 0xa2, 0xd9, 0x87,
	0xd2, 0x60, 0xea, 0x49, 0x66, 0xc5, 0x2b, 0x08, 0xd7, 0x66, 0x6b, 0x31, 0xee, 0xb1, 0xec, 0x71,
	0x27, 0x5b, 0x10, 0x9c, 0x7a, 0xb2, 0xe5, 0xc5, 0x39, 0x44, 0x9b, 0x4a, 0x15, 0xa6, 0x8e, 0xfb,
	0xac, 0x3c, 0xe9, 0x94, 0x97, 0x8c, 0xa7, 0x9e, 0xbc, 0x55, 0xd0, 0xe9, 0x1d, 0x6a, 0x17, 0x07,
	0xff, 0x9f, 0xfe, 0x84, 0xda, 0xd1, 0x69, 0x62, 0xc5, 0x0b, 0xe8, 0x1b, 0xd4, 0x71, 0xc8, 0xa2,
	0x71, 0x27, 0xba, 0x40, 0x9d, 0x7a, 0x92, 0x38, 0xf1, 0x0e, 0x20, 0xfb, 0x6c, 0xb2, 0x2f, 0xa5,
	0xb3, 0xd8, 0xc4, 0x11, 0x2b, 0x4f, 0x3b, 0xe5, 0xf2, 0xc0, 0xa5, 0x9e, 0xbc, 0xa7, 0x5c, 0x8c,
	0x60, 0x70, 0xa5, 0xae, 0x73, 0xa7, 0x74, 0x72, 0x06, 0x01, 0x19, 0x16, 0x02, 0x02, 0x54, 0x85,
	0xe1, 0x38, 0x46, 0x92, 0xeb, 0x64, 0x0e, 0x21, 0xbb, 0x24, 0xb2, 0xf9, 0x6a, 0x35, 0x93, 0x81,
	0xe4, 0xfa, 0x30, 0xd0, 0xbb, 0x37, 0xf0, 0xcb, 0x87, 0xa8, 0x75, 0x7b, 0x74, 0xe4, 0x19, 0x8c,
	0x4a, 0xb5, 0x35, 0xab, 0xda, 0xde, 0xb4, 0x73, 0xa1, 0x1c, 0x12, 0xf0, 0xd1, 0xde, 0x18, 0x71,
	0x0e, 0x21, 0xd5, 0x94, 0x5f, 0xff, 0x5f, 0x1b, 0xed, 0xc6, 0x2b, 0xb5, 0x35, 0xb2, 0x95, 0x88,
	0x33, 0x18, 0x36, 0xd5, 0x0e, 0x33, 0xd5, 0x18, 0x0e, 0x71, 0x2c, 0x0f, 0x3d, 0x1d, 0xb1, 0xf5,
	0x8a, 0x7e, 0x01, 0xdb, 0x70, 0x78, 0xa1, 0x1c, 0xda, 0x7a, 0xc9, 0xbd, 0x78, 0x0e, 0x50, 0x5f,
	0x63, 0xb6, 0xda, 0xe4, 0x6a, 0x5b, 0x73, 0x60, 0x63, 0x39, 0x22, 0xe4, 0x92, 0x00, 0xda, 0xbb,
	0xb1, 0xb9, 0x61, 0x5f, 0x03, 0xf6, 0x75, 0xe8, 0x93, 0xf7, 0x00, 0xdd, 0x87, 0x90, 0x3d, 0xad,
	0x1a, 0xc5, 0xf6, 0x1e, 0x4a, 0xae, 0xc5, 0x29, 0x84, 0xed, 0xde, 0x1e, 0xef, 0x6d, 0x1b, 0xf1,
	0x04, 0x22, 0xdc, 0x15, 0x6b, 0x53, 0xf1, 0x8f, 0x31, 0x96, 0xb7, 0x1d, 0x05, 0x4f, 0xcf, 0x7d,
	0x2c, 0xa8, 0xe4, 0x29, 0xf4, 0x2f, 0x50, 0x1f, 0xa5, 0xa6, 0x00, 0xdd, 0xb3, 0x1e, 0x7b, 0xb5,
	0xc5, 0xc9, 0x8f, 0xfd, 0xc4, 0xff, 0xb9, 0x9f, 0xf8, 0xbf, 0xf7, 0x13, 0xff, 0xfb, 0x9f, 0x89,
	0xb7, 0x8e, 0x38, 0xca, 0xb7, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x13, 0x86, 0x50, 0xa9, 0x2b,
	0x03, 0x00, 0x00,
}
