/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef FB2CONTENTMAP_H_INCLUDED
#define FB2CONTENTMAP_H_INCLUDED

#include <string>

namespace libebook
{

struct ContentMapImpl;
class FB2Content;

class FB2ContentMap
{
  // no copying
  FB2ContentMap(const FB2ContentMap &other);
  FB2ContentMap &operator=(const FB2ContentMap &other);

public:
  FB2ContentMap();
  ~FB2ContentMap();

  bool insert(const std::string &id, const FB2Content *content);
  bool exists(const std::string &id) const;
  const FB2Content *get(const std::string &id) const;

  ContentMapImpl *const m_impl;
};

}

#endif // FB2CONTENTMAP_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
