# MNT Reform: Operator Manual

## TOC

- Preface
- List of existing manuals / references / online communications channels
- Safety / Hazards / Warnings
- Quickstart
  - How to unwrap, plug in, turn on
  - First steps in Debian GNU/Linux
  - Important functions of the default sway-based desktop
    - Windows and workspaces
    - Display brightness
    - CPU/IO/Mem meter
    - Network
    - Audio
    - Date and time
  - (maybe) functions of the alternative GNOME desktop
- Writing a small game/program
  - Creating graphics
  - Making sound
  - Putting it all together
- Software recommendations
  - List of tested productivity applications (creative, office)
  - List of tested communication programs (email, chat, voip)
  - List of tested games
  - List of tested tools
- Reference
  - Electronics
    - Schematics
    - Short explanation of important chips/parts
  - Mechanical
    - Diagram/drawings of mechanical parts
    - Explanation of what connects to what / which screw goes where
  - Common Problems
  - Maintenance
- Credits / Thanks

## Tech

- [Sphinx](https://www.sphinx-doc.org/en/master/) worked well as a generator for the old handbook. Probably we can use it again. I might rather go with markdown than with RSt this time, but this is up for discussion. I'm also OK with looking around for another tool that can do PDF layout.
- We don't have a printing service selected yet, and should do it soon.
- The print format can be unusual, like A4. Ideas welcome.
- We organize on [here](https://chat.mnt.re/mnt/channels/town-square).

## Assets

- Logo
- Type
- Graphics

## Style

- Inspiration: classic computer manuals, like ZX Spectrum, QL, Commodore 64, Amiga 500. But also LISP machines, classic Macintosh. Classic Sony, Nintendo?
- International Typographic Style https://en.wikipedia.org/wiki/International_Typographic_Style
- TODO: Moodboard
- TODO: Grid

## Resources

- Corporate design: http://dump.mntmn.com/mnt-corporate-design-20200929.pdf
- Exploded view: https://www.behance.net/gallery/96804715/MNT-Reform
- Dense manual for ZZ9000: https://mntre.com/media/ZZ9000_info_md/zz9000-manual-r2.pdf
- Sinclair Programming: https://k1.spdns.de/Vintage/Sinclair/80/Sinclair%20ZX81/ZX81%20Basic%20Programming.pdf
- https://mntre.com/reform2-handbook/system.html
- https://mntre.com/reform2-ibom/reform2-motherboard/ibom.html
- Font: https://www.brailleinstitute.org/freefont
